# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_acknowledge_rma_errors_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest

try {
    $result = $apiInstance->acknowledgeRMAErrors($returns_refunds_acknowledge_rma_errors_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->acknowledgeRMAErrors: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ReturnsRefundsApi* | [**acknowledgeRMAErrors**](docs/Api/ReturnsRefundsApi.md#acknowledgermaerrors) | **POST** /api/ReturnsRefunds/AcknowledgeRMAErrors | AcknowledgeRMAErrors
*ReturnsRefundsApi* | [**acknowledgeRefundErrors**](docs/Api/ReturnsRefundsApi.md#acknowledgerefunderrors) | **POST** /api/ReturnsRefunds/AcknowledgeRefundErrors | AcknowledgeRefundErrors
*ReturnsRefundsApi* | [**actionBookedOrder**](docs/Api/ReturnsRefundsApi.md#actionbookedorder) | **POST** /api/ReturnsRefunds/ActionBookedOrder | ActionBookedOrder
*ReturnsRefundsApi* | [**actionRMABooking**](docs/Api/ReturnsRefundsApi.md#actionrmabooking) | **POST** /api/ReturnsRefunds/ActionRMABooking | ActionRMABooking
*ReturnsRefundsApi* | [**actionRefund**](docs/Api/ReturnsRefundsApi.md#actionrefund) | **POST** /api/ReturnsRefunds/ActionRefund | ActionRefund
*ReturnsRefundsApi* | [**createRMABooking**](docs/Api/ReturnsRefundsApi.md#creatermabooking) | **POST** /api/ReturnsRefunds/CreateRMABooking | CreateRMABooking
*ReturnsRefundsApi* | [**createRefund**](docs/Api/ReturnsRefundsApi.md#createrefund) | **POST** /api/ReturnsRefunds/CreateRefund | CreateRefund
*ReturnsRefundsApi* | [**createReturnsRefundsCSV**](docs/Api/ReturnsRefundsApi.md#createreturnsrefundscsv) | **GET** /api/ReturnsRefunds/CreateReturnsRefundsCSV | CreateReturnsRefundsCSV
*ReturnsRefundsApi* | [**deleteBookedItem**](docs/Api/ReturnsRefundsApi.md#deletebookeditem) | **POST** /api/ReturnsRefunds/DeleteBookedItem | DeleteBookedItem
*ReturnsRefundsApi* | [**deleteBookedOrder**](docs/Api/ReturnsRefundsApi.md#deletebookedorder) | **POST** /api/ReturnsRefunds/DeleteBookedOrder | DeleteBookedOrder
*ReturnsRefundsApi* | [**deletePendingRefundItem**](docs/Api/ReturnsRefundsApi.md#deletependingrefunditem) | **POST** /api/ReturnsRefunds/DeletePendingRefundItem | DeletePendingRefundItem
*ReturnsRefundsApi* | [**deleteRMA**](docs/Api/ReturnsRefundsApi.md#deleterma) | **POST** /api/ReturnsRefunds/DeleteRMA | DeleteRMA
*ReturnsRefundsApi* | [**deleteRefund**](docs/Api/ReturnsRefundsApi.md#deleterefund) | **POST** /api/ReturnsRefunds/DeleteRefund | DeleteRefund
*ReturnsRefundsApi* | [**editBookedItemInfo**](docs/Api/ReturnsRefundsApi.md#editbookediteminfo) | **POST** /api/ReturnsRefunds/EditBookedItemInfo | EditBookedItemInfo
*ReturnsRefundsApi* | [**getActionableRMAHeaders**](docs/Api/ReturnsRefundsApi.md#getactionablermaheaders) | **POST** /api/ReturnsRefunds/GetActionableRMAHeaders | GetActionableRMAHeaders
*ReturnsRefundsApi* | [**getActionableRefundHeaders**](docs/Api/ReturnsRefundsApi.md#getactionablerefundheaders) | **POST** /api/ReturnsRefunds/GetActionableRefundHeaders | GetActionableRefundHeaders
*ReturnsRefundsApi* | [**getBookedReturnsExchangeOrders**](docs/Api/ReturnsRefundsApi.md#getbookedreturnsexchangeorders) | **GET** /api/ReturnsRefunds/GetBookedReturnsExchangeOrders | GetBookedReturnsExchangeOrders
*ReturnsRefundsApi* | [**getProcessedOrAckedErrorRMAHeaders**](docs/Api/ReturnsRefundsApi.md#getprocessedorackederrorrmaheaders) | **POST** /api/ReturnsRefunds/GetProcessedOrAckedErrorRMAHeaders | GetProcessedOrAckedErrorRMAHeaders
*ReturnsRefundsApi* | [**getProcessedOrAckedErrorRefundHeaders**](docs/Api/ReturnsRefundsApi.md#getprocessedorackederrorrefundheaders) | **POST** /api/ReturnsRefunds/GetProcessedOrAckedErrorRefundHeaders | GetProcessedOrAckedErrorRefundHeaders
*ReturnsRefundsApi* | [**getRMAHeadersByOrderId**](docs/Api/ReturnsRefundsApi.md#getrmaheadersbyorderid) | **POST** /api/ReturnsRefunds/GetRMAHeadersByOrderId | GetRMAHeadersByOrderId
*ReturnsRefundsApi* | [**getRefundHeadersByOrderId**](docs/Api/ReturnsRefundsApi.md#getrefundheadersbyorderid) | **POST** /api/ReturnsRefunds/GetRefundHeadersByOrderId | GetRefundHeadersByOrderId
*ReturnsRefundsApi* | [**getRefundLinesByHeaderId**](docs/Api/ReturnsRefundsApi.md#getrefundlinesbyheaderid) | **POST** /api/ReturnsRefunds/GetRefundLinesByHeaderId | GetRefundLinesByHeaderId
*ReturnsRefundsApi* | [**getRefundOptions**](docs/Api/ReturnsRefundsApi.md#getrefundoptions) | **POST** /api/ReturnsRefunds/GetRefundOptions | GetRefundOptions
*ReturnsRefundsApi* | [**getRefundOrders**](docs/Api/ReturnsRefundsApi.md#getrefundorders) | **GET** /api/ReturnsRefunds/GetRefundOrders | GetRefundOrders
*ReturnsRefundsApi* | [**getReturnOptions**](docs/Api/ReturnsRefundsApi.md#getreturnoptions) | **POST** /api/ReturnsRefunds/GetReturnOptions | GetReturnOptions
*ReturnsRefundsApi* | [**getSearchTypes**](docs/Api/ReturnsRefundsApi.md#getsearchtypes) | **GET** /api/ReturnsRefunds/GetSearchTypes | GetSearchTypes
*ReturnsRefundsApi* | [**getTotalRefunds**](docs/Api/ReturnsRefundsApi.md#gettotalrefunds) | **GET** /api/ReturnsRefunds/GetTotalRefunds | GetTotalRefunds
*ReturnsRefundsApi* | [**getWarehouseLocations**](docs/Api/ReturnsRefundsApi.md#getwarehouselocations) | **GET** /api/ReturnsRefunds/GetWarehouseLocations | GetWarehouseLocations
*ReturnsRefundsApi* | [**refundOrder**](docs/Api/ReturnsRefundsApi.md#refundorder) | **POST** /api/ReturnsRefunds/RefundOrder | RefundOrder
*ReturnsRefundsApi* | [**searchReturnsRefundsPaged**](docs/Api/ReturnsRefundsApi.md#searchreturnsrefundspaged) | **GET** /api/ReturnsRefunds/SearchReturnsRefundsPaged | SearchReturnsRefundsPaged
*ReturnsRefundsApi* | [**updateRMABooking**](docs/Api/ReturnsRefundsApi.md#updatermabooking) | **POST** /api/ReturnsRefunds/UpdateRMABooking | UpdateRMABooking
*ReturnsRefundsApi* | [**updateRefund**](docs/Api/ReturnsRefundsApi.md#updaterefund) | **POST** /api/ReturnsRefunds/UpdateRefund | UpdateRefund

## Models

- [AcknowledgeRMAErrorsRequest](docs/Model/AcknowledgeRMAErrorsRequest.md)
- [AcknowledgeRMAErrorsResponse](docs/Model/AcknowledgeRMAErrorsResponse.md)
- [AcknowledgeRefundErrorsRequest](docs/Model/AcknowledgeRefundErrorsRequest.md)
- [AcknowledgeRefundErrorsResponse](docs/Model/AcknowledgeRefundErrorsResponse.md)
- [ActionForm](docs/Model/ActionForm.md)
- [ActionFormControl](docs/Model/ActionFormControl.md)
- [ActionRMABookingRequest](docs/Model/ActionRMABookingRequest.md)
- [ActionRMABookingResponse](docs/Model/ActionRMABookingResponse.md)
- [ActionRefundRequest](docs/Model/ActionRefundRequest.md)
- [ActionRefundResponse](docs/Model/ActionRefundResponse.md)
- [ActionablePostSaleSearchFilters](docs/Model/ActionablePostSaleSearchFilters.md)
- [BookedReturnsExchangeItem](docs/Model/BookedReturnsExchangeItem.md)
- [BookedReturnsExchangeOrder](docs/Model/BookedReturnsExchangeOrder.md)
- [ChannelReason](docs/Model/ChannelReason.md)
- [ChannelReasonBase](docs/Model/ChannelReasonBase.md)
- [ChannelSubReason](docs/Model/ChannelSubReason.md)
- [CreateRMABookingRequest](docs/Model/CreateRMABookingRequest.md)
- [CreateRMABookingResponse](docs/Model/CreateRMABookingResponse.md)
- [CreateRefundRequest](docs/Model/CreateRefundRequest.md)
- [CreateRefundResponse](docs/Model/CreateRefundResponse.md)
- [CustomerAddress](docs/Model/CustomerAddress.md)
- [DeleteRMARequest](docs/Model/DeleteRMARequest.md)
- [DeleteRefundRequest](docs/Model/DeleteRefundRequest.md)
- [ExchangeItem](docs/Model/ExchangeItem.md)
- [ExtendedProperty](docs/Model/ExtendedProperty.md)
- [GenericPagedResultReturnsRefundsWeb](docs/Model/GenericPagedResultReturnsRefundsWeb.md)
- [GetActionableRMAHeadersRequest](docs/Model/GetActionableRMAHeadersRequest.md)
- [GetActionableRMAHeadersResponse](docs/Model/GetActionableRMAHeadersResponse.md)
- [GetActionableRefundHeadersRequest](docs/Model/GetActionableRefundHeadersRequest.md)
- [GetActionableRefundHeadersResponse](docs/Model/GetActionableRefundHeadersResponse.md)
- [GetProcessedOrAckedErrorRMAHeadersRequest](docs/Model/GetProcessedOrAckedErrorRMAHeadersRequest.md)
- [GetProcessedOrAckedErrorRMAHeadersResponse](docs/Model/GetProcessedOrAckedErrorRMAHeadersResponse.md)
- [GetProcessedOrAckedErrorRefundHeadersRequest](docs/Model/GetProcessedOrAckedErrorRefundHeadersRequest.md)
- [GetProcessedOrAckedErrorRefundHeadersResponse](docs/Model/GetProcessedOrAckedErrorRefundHeadersResponse.md)
- [GetRMAHeadersByOrderIdRequest](docs/Model/GetRMAHeadersByOrderIdRequest.md)
- [GetRMAHeadersByOrderIdResponse](docs/Model/GetRMAHeadersByOrderIdResponse.md)
- [GetRefundHeadersByOrderIdRequest](docs/Model/GetRefundHeadersByOrderIdRequest.md)
- [GetRefundHeadersByOrderIdResponse](docs/Model/GetRefundHeadersByOrderIdResponse.md)
- [GetRefundLinesByHeaderIdRequest](docs/Model/GetRefundLinesByHeaderIdRequest.md)
- [GetRefundLinesByHeaderIdResponse](docs/Model/GetRefundLinesByHeaderIdResponse.md)
- [GetRefundOptionsRequest](docs/Model/GetRefundOptionsRequest.md)
- [GetRefundOptionsResponse](docs/Model/GetRefundOptionsResponse.md)
- [GetReturnOptionsRequest](docs/Model/GetReturnOptionsRequest.md)
- [GetReturnOptionsResponse](docs/Model/GetReturnOptionsResponse.md)
- [Identifier](docs/Model/Identifier.md)
- [ItemizedRefundReason](docs/Model/ItemizedRefundReason.md)
- [NewRefundLine](docs/Model/NewRefundLine.md)
- [OrderCustomerInfo](docs/Model/OrderCustomerInfo.md)
- [OrderDetails](docs/Model/OrderDetails.md)
- [OrderGeneralInfo](docs/Model/OrderGeneralInfo.md)
- [OrderItem](docs/Model/OrderItem.md)
- [OrderItemBinRack](docs/Model/OrderItemBinRack.md)
- [OrderItemOnOrder](docs/Model/OrderItemOnOrder.md)
- [OrderItemOption](docs/Model/OrderItemOption.md)
- [OrderNote](docs/Model/OrderNote.md)
- [OrderRMAHeader](docs/Model/OrderRMAHeader.md)
- [OrderRefundHeader](docs/Model/OrderRefundHeader.md)
- [OrderShippingInfo](docs/Model/OrderShippingInfo.md)
- [OrderTotalsInfo](docs/Model/OrderTotalsInfo.md)
- [PostSaleStatus](docs/Model/PostSaleStatus.md)
- [PostSaleSubStatus](docs/Model/PostSaleSubStatus.md)
- [ProcessedPostSaleSearchFilters](docs/Model/ProcessedPostSaleSearchFilters.md)
- [RMAError](docs/Model/RMAError.md)
- [RefundError](docs/Model/RefundError.md)
- [RefundOptions](docs/Model/RefundOptions.md)
- [RefundOrder](docs/Model/RefundOrder.md)
- [ResendItem](docs/Model/ResendItem.md)
- [ReturnItem](docs/Model/ReturnItem.md)
- [ReturnOptions](docs/Model/ReturnOptions.md)
- [ReturnsRefundsAcknowledgeRMAErrorsRequest](docs/Model/ReturnsRefundsAcknowledgeRMAErrorsRequest.md)
- [ReturnsRefundsAcknowledgeRefundErrorsRequest](docs/Model/ReturnsRefundsAcknowledgeRefundErrorsRequest.md)
- [ReturnsRefundsActionBookedOrderRequest](docs/Model/ReturnsRefundsActionBookedOrderRequest.md)
- [ReturnsRefundsActionRMABookingRequest](docs/Model/ReturnsRefundsActionRMABookingRequest.md)
- [ReturnsRefundsActionRefundRequest](docs/Model/ReturnsRefundsActionRefundRequest.md)
- [ReturnsRefundsCreateRMABookingRequest](docs/Model/ReturnsRefundsCreateRMABookingRequest.md)
- [ReturnsRefundsCreateRefundRequest](docs/Model/ReturnsRefundsCreateRefundRequest.md)
- [ReturnsRefundsDeleteBookedItemRequest](docs/Model/ReturnsRefundsDeleteBookedItemRequest.md)
- [ReturnsRefundsDeleteBookedOrderRequest](docs/Model/ReturnsRefundsDeleteBookedOrderRequest.md)
- [ReturnsRefundsDeletePendingRefundItemRequest](docs/Model/ReturnsRefundsDeletePendingRefundItemRequest.md)
- [ReturnsRefundsDeleteRMARequest](docs/Model/ReturnsRefundsDeleteRMARequest.md)
- [ReturnsRefundsDeleteRefundRequest](docs/Model/ReturnsRefundsDeleteRefundRequest.md)
- [ReturnsRefundsEditBookedItemInfoRequest](docs/Model/ReturnsRefundsEditBookedItemInfoRequest.md)
- [ReturnsRefundsGetActionableRMAHeadersRequest](docs/Model/ReturnsRefundsGetActionableRMAHeadersRequest.md)
- [ReturnsRefundsGetActionableRefundHeadersRequest](docs/Model/ReturnsRefundsGetActionableRefundHeadersRequest.md)
- [ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest](docs/Model/ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest.md)
- [ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest](docs/Model/ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest.md)
- [ReturnsRefundsGetRMAHeadersByOrderIdRequest](docs/Model/ReturnsRefundsGetRMAHeadersByOrderIdRequest.md)
- [ReturnsRefundsGetRefundHeadersByOrderIdRequest](docs/Model/ReturnsRefundsGetRefundHeadersByOrderIdRequest.md)
- [ReturnsRefundsGetRefundLinesByHeaderIdRequest](docs/Model/ReturnsRefundsGetRefundLinesByHeaderIdRequest.md)
- [ReturnsRefundsGetRefundOptionsRequest](docs/Model/ReturnsRefundsGetRefundOptionsRequest.md)
- [ReturnsRefundsGetReturnOptionsRequest](docs/Model/ReturnsRefundsGetReturnOptionsRequest.md)
- [ReturnsRefundsRefundOrderRequest](docs/Model/ReturnsRefundsRefundOrderRequest.md)
- [ReturnsRefundsUpdateRMABookingRequest](docs/Model/ReturnsRefundsUpdateRMABookingRequest.md)
- [ReturnsRefundsUpdateRefundRequest](docs/Model/ReturnsRefundsUpdateRefundRequest.md)
- [ReturnsRefundsWeb](docs/Model/ReturnsRefundsWeb.md)
- [ScheduledDelivery](docs/Model/ScheduledDelivery.md)
- [SearchField](docs/Model/SearchField.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [StockItemBoxConfiguration](docs/Model/StockItemBoxConfiguration.md)
- [UpdateRMABookingRequest](docs/Model/UpdateRMABookingRequest.md)
- [UpdateRMABookingResponse](docs/Model/UpdateRMABookingResponse.md)
- [UpdateRefundRequest](docs/Model/UpdateRefundRequest.md)
- [UpdateRefundResponse](docs/Model/UpdateRefundResponse.md)
- [UpdatedExchangeItem](docs/Model/UpdatedExchangeItem.md)
- [UpdatedRefundLine](docs/Model/UpdatedRefundLine.md)
- [UpdatedResendItem](docs/Model/UpdatedResendItem.md)
- [UpdatedReturnItem](docs/Model/UpdatedReturnItem.md)
- [VerifiedRMAItem](docs/Model/VerifiedRMAItem.md)
- [VerifiedRefund](docs/Model/VerifiedRefund.md)
- [VerifiedRefundItem](docs/Model/VerifiedRefundItem.md)
- [WarehouseLocation](docs/Model/WarehouseLocation.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `returnsrefunds`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
