# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## OpenAPI files

https://github.com/LinnSystems/PublicApiSpecs

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Linnworks\Auth\Api\AuthApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Linnworks\Auth\Model\AuthorizeByApplicationRequest(); // \Linnworks\Auth\Model\AuthorizeByApplicationRequest

try {
    $result = $apiInstance->authorizeByApplication($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthApi->authorizeByApplication: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**authorizeByApplication**](docs/Api/AuthApi.md#authorizebyapplication) | **POST** /api/Auth/AuthorizeByApplication | AuthorizeByApplication
*AuthApi* | [**getApplicationProfileBySecretKey**](docs/Api/AuthApi.md#getapplicationprofilebysecretkey) | **POST** /api/Auth/GetApplicationProfileBySecretKey | GetApplicationProfileBySecretKey

## Models

- [ApplicationProfileResponse](docs/Model/ApplicationProfileResponse.md)
- [AuthGetApplicationProfileBySecretKeyRequest](docs/Model/AuthGetApplicationProfileBySecretKeyRequest.md)
- [AuthorizeByApplicationRequest](docs/Model/AuthorizeByApplicationRequest.md)
- [BaseSession](docs/Model/BaseSession.md)
- [StatusDetails](docs/Model/StatusDetails.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `auth`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
