<?php
/**
 * ServiceItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ServiceItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ServiceItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ServiceItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_item_row_id' => 'string',
        'service_name' => 'string',
        'service_cost' => 'float',
        'default_channel_reason' => '\Linnworks\ProcessedOrders\Model\ChannelRefundReason',
        'default_channel_sub_reason' => '\Linnworks\ProcessedOrders\Model\ChannelRefundSubReason',
        'item_number' => 'string',
        'allows_automated_refund' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_item_row_id' => 'uuid',
        'service_name' => null,
        'service_cost' => 'double',
        'default_channel_reason' => null,
        'default_channel_sub_reason' => null,
        'item_number' => null,
        'allows_automated_refund' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_item_row_id' => false,
        'service_name' => false,
        'service_cost' => false,
        'default_channel_reason' => false,
        'default_channel_sub_reason' => false,
        'item_number' => false,
        'allows_automated_refund' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_item_row_id' => 'pkOrderItemRowId',
        'service_name' => 'ServiceName',
        'service_cost' => 'ServiceCost',
        'default_channel_reason' => 'DefaultChannelReason',
        'default_channel_sub_reason' => 'DefaultChannelSubReason',
        'item_number' => 'ItemNumber',
        'allows_automated_refund' => 'AllowsAutomatedRefund'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_item_row_id' => 'setPkOrderItemRowId',
        'service_name' => 'setServiceName',
        'service_cost' => 'setServiceCost',
        'default_channel_reason' => 'setDefaultChannelReason',
        'default_channel_sub_reason' => 'setDefaultChannelSubReason',
        'item_number' => 'setItemNumber',
        'allows_automated_refund' => 'setAllowsAutomatedRefund'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_item_row_id' => 'getPkOrderItemRowId',
        'service_name' => 'getServiceName',
        'service_cost' => 'getServiceCost',
        'default_channel_reason' => 'getDefaultChannelReason',
        'default_channel_sub_reason' => 'getDefaultChannelSubReason',
        'item_number' => 'getItemNumber',
        'allows_automated_refund' => 'getAllowsAutomatedRefund'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_item_row_id', $data ?? [], null);
        $this->setIfExists('service_name', $data ?? [], null);
        $this->setIfExists('service_cost', $data ?? [], null);
        $this->setIfExists('default_channel_reason', $data ?? [], null);
        $this->setIfExists('default_channel_sub_reason', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('allows_automated_refund', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_item_row_id
     *
     * @return string|null
     */
    public function getPkOrderItemRowId()
    {
        return $this->container['pk_order_item_row_id'];
    }

    /**
     * Sets pk_order_item_row_id
     *
     * @param string|null $pk_order_item_row_id Order item record row ID
     *
     * @return self
     */
    public function setPkOrderItemRowId($pk_order_item_row_id)
    {
        if (is_null($pk_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_item_row_id cannot be null');
        }
        $this->container['pk_order_item_row_id'] = $pk_order_item_row_id;

        return $this;
    }

    /**
     * Gets service_name
     *
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->container['service_name'];
    }

    /**
     * Sets service_name
     *
     * @param string|null $service_name Service name
     *
     * @return self
     */
    public function setServiceName($service_name)
    {
        if (is_null($service_name)) {
            throw new \InvalidArgumentException('non-nullable service_name cannot be null');
        }
        $this->container['service_name'] = $service_name;

        return $this;
    }

    /**
     * Gets service_cost
     *
     * @return float|null
     */
    public function getServiceCost()
    {
        return $this->container['service_cost'];
    }

    /**
     * Sets service_cost
     *
     * @param float|null $service_cost Service cost
     *
     * @return self
     */
    public function setServiceCost($service_cost)
    {
        if (is_null($service_cost)) {
            throw new \InvalidArgumentException('non-nullable service_cost cannot be null');
        }
        $this->container['service_cost'] = $service_cost;

        return $this;
    }

    /**
     * Gets default_channel_reason
     *
     * @return \Linnworks\ProcessedOrders\Model\ChannelRefundReason|null
     */
    public function getDefaultChannelReason()
    {
        return $this->container['default_channel_reason'];
    }

    /**
     * Sets default_channel_reason
     *
     * @param \Linnworks\ProcessedOrders\Model\ChannelRefundReason|null $default_channel_reason default_channel_reason
     *
     * @return self
     */
    public function setDefaultChannelReason($default_channel_reason)
    {
        if (is_null($default_channel_reason)) {
            throw new \InvalidArgumentException('non-nullable default_channel_reason cannot be null');
        }
        $this->container['default_channel_reason'] = $default_channel_reason;

        return $this;
    }

    /**
     * Gets default_channel_sub_reason
     *
     * @return \Linnworks\ProcessedOrders\Model\ChannelRefundSubReason|null
     */
    public function getDefaultChannelSubReason()
    {
        return $this->container['default_channel_sub_reason'];
    }

    /**
     * Sets default_channel_sub_reason
     *
     * @param \Linnworks\ProcessedOrders\Model\ChannelRefundSubReason|null $default_channel_sub_reason default_channel_sub_reason
     *
     * @return self
     */
    public function setDefaultChannelSubReason($default_channel_sub_reason)
    {
        if (is_null($default_channel_sub_reason)) {
            throw new \InvalidArgumentException('non-nullable default_channel_sub_reason cannot be null');
        }
        $this->container['default_channel_sub_reason'] = $default_channel_sub_reason;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number Item number
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets allows_automated_refund
     *
     * @return bool|null
     */
    public function getAllowsAutomatedRefund()
    {
        return $this->container['allows_automated_refund'];
    }

    /**
     * Sets allows_automated_refund
     *
     * @param bool|null $allows_automated_refund If automatic refunds allowed
     *
     * @return self
     */
    public function setAllowsAutomatedRefund($allows_automated_refund)
    {
        if (is_null($allows_automated_refund)) {
            throw new \InvalidArgumentException('non-nullable allows_automated_refund cannot be null');
        }
        $this->container['allows_automated_refund'] = $allows_automated_refund;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


