<?php
/**
 * RowQty
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * RowQty Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RowQty implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RowQty';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_row_id' => 'string',
        'order_item_batch_id' => 'int',
        'refund' => 'float',
        'qty' => 'int',
        'scrap_qty' => 'int',
        'batch' => '\Linnworks\ProcessedOrders\Model\OrderItemBatch',
        'additional_cost' => 'float',
        'new_stock_item_id' => 'string',
        'new_qty' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_row_id' => 'uuid',
        'order_item_batch_id' => 'int32',
        'refund' => 'double',
        'qty' => 'int32',
        'scrap_qty' => 'int32',
        'batch' => null,
        'additional_cost' => 'double',
        'new_stock_item_id' => 'uuid',
        'new_qty' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_item_row_id' => false,
        'order_item_batch_id' => false,
        'refund' => false,
        'qty' => false,
        'scrap_qty' => false,
        'batch' => false,
        'additional_cost' => false,
        'new_stock_item_id' => false,
        'new_qty' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_row_id' => 'OrderItemRowId',
        'order_item_batch_id' => 'OrderItemBatchId',
        'refund' => 'Refund',
        'qty' => 'Qty',
        'scrap_qty' => 'ScrapQty',
        'batch' => 'Batch',
        'additional_cost' => 'AdditionalCost',
        'new_stock_item_id' => 'NewStockItemId',
        'new_qty' => 'NewQty'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_row_id' => 'setOrderItemRowId',
        'order_item_batch_id' => 'setOrderItemBatchId',
        'refund' => 'setRefund',
        'qty' => 'setQty',
        'scrap_qty' => 'setScrapQty',
        'batch' => 'setBatch',
        'additional_cost' => 'setAdditionalCost',
        'new_stock_item_id' => 'setNewStockItemId',
        'new_qty' => 'setNewQty'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_row_id' => 'getOrderItemRowId',
        'order_item_batch_id' => 'getOrderItemBatchId',
        'refund' => 'getRefund',
        'qty' => 'getQty',
        'scrap_qty' => 'getScrapQty',
        'batch' => 'getBatch',
        'additional_cost' => 'getAdditionalCost',
        'new_stock_item_id' => 'getNewStockItemId',
        'new_qty' => 'getNewQty'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_item_row_id', $data ?? [], null);
        $this->setIfExists('order_item_batch_id', $data ?? [], null);
        $this->setIfExists('refund', $data ?? [], null);
        $this->setIfExists('qty', $data ?? [], null);
        $this->setIfExists('scrap_qty', $data ?? [], null);
        $this->setIfExists('batch', $data ?? [], null);
        $this->setIfExists('additional_cost', $data ?? [], null);
        $this->setIfExists('new_stock_item_id', $data ?? [], null);
        $this->setIfExists('new_qty', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_item_row_id
     *
     * @return string|null
     */
    public function getOrderItemRowId()
    {
        return $this->container['order_item_row_id'];
    }

    /**
     * Sets order_item_row_id
     *
     * @param string|null $order_item_row_id Order item record row ID
     *
     * @return self
     */
    public function setOrderItemRowId($order_item_row_id)
    {
        if (is_null($order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_row_id cannot be null');
        }
        $this->container['order_item_row_id'] = $order_item_row_id;

        return $this;
    }

    /**
     * Gets order_item_batch_id
     *
     * @return int|null
     */
    public function getOrderItemBatchId()
    {
        return $this->container['order_item_batch_id'];
    }

    /**
     * Sets order_item_batch_id
     *
     * @param int|null $order_item_batch_id Batch inventory id
     *
     * @return self
     */
    public function setOrderItemBatchId($order_item_batch_id)
    {
        if (is_null($order_item_batch_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_batch_id cannot be null');
        }
        $this->container['order_item_batch_id'] = $order_item_batch_id;

        return $this;
    }

    /**
     * Gets refund
     *
     * @return float|null
     */
    public function getRefund()
    {
        return $this->container['refund'];
    }

    /**
     * Sets refund
     *
     * @param float|null $refund Refund amount
     *
     * @return self
     */
    public function setRefund($refund)
    {
        if (is_null($refund)) {
            throw new \InvalidArgumentException('non-nullable refund cannot be null');
        }
        $this->container['refund'] = $refund;

        return $this;
    }

    /**
     * Gets qty
     *
     * @return int|null
     */
    public function getQty()
    {
        return $this->container['qty'];
    }

    /**
     * Sets qty
     *
     * @param int|null $qty Affected quantity
     *
     * @return self
     */
    public function setQty($qty)
    {
        if (is_null($qty)) {
            throw new \InvalidArgumentException('non-nullable qty cannot be null');
        }
        $this->container['qty'] = $qty;

        return $this;
    }

    /**
     * Gets scrap_qty
     *
     * @return int|null
     */
    public function getScrapQty()
    {
        return $this->container['scrap_qty'];
    }

    /**
     * Sets scrap_qty
     *
     * @param int|null $scrap_qty Scrapped quantity
     *
     * @return self
     */
    public function setScrapQty($scrap_qty)
    {
        if (is_null($scrap_qty)) {
            throw new \InvalidArgumentException('non-nullable scrap_qty cannot be null');
        }
        $this->container['scrap_qty'] = $scrap_qty;

        return $this;
    }

    /**
     * Gets batch
     *
     * @return \Linnworks\ProcessedOrders\Model\OrderItemBatch|null
     */
    public function getBatch()
    {
        return $this->container['batch'];
    }

    /**
     * Sets batch
     *
     * @param \Linnworks\ProcessedOrders\Model\OrderItemBatch|null $batch batch
     *
     * @return self
     */
    public function setBatch($batch)
    {
        if (is_null($batch)) {
            throw new \InvalidArgumentException('non-nullable batch cannot be null');
        }
        $this->container['batch'] = $batch;

        return $this;
    }

    /**
     * Gets additional_cost
     *
     * @return float|null
     */
    public function getAdditionalCost()
    {
        return $this->container['additional_cost'];
    }

    /**
     * Sets additional_cost
     *
     * @param float|null $additional_cost Additional costs
     *
     * @return self
     */
    public function setAdditionalCost($additional_cost)
    {
        if (is_null($additional_cost)) {
            throw new \InvalidArgumentException('non-nullable additional_cost cannot be null');
        }
        $this->container['additional_cost'] = $additional_cost;

        return $this;
    }

    /**
     * Gets new_stock_item_id
     *
     * @return string|null
     */
    public function getNewStockItemId()
    {
        return $this->container['new_stock_item_id'];
    }

    /**
     * Sets new_stock_item_id
     *
     * @param string|null $new_stock_item_id New (returned) stock item ID
     *
     * @return self
     */
    public function setNewStockItemId($new_stock_item_id)
    {
        if (is_null($new_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable new_stock_item_id cannot be null');
        }
        $this->container['new_stock_item_id'] = $new_stock_item_id;

        return $this;
    }

    /**
     * Gets new_qty
     *
     * @return int|null
     */
    public function getNewQty()
    {
        return $this->container['new_qty'];
    }

    /**
     * Sets new_qty
     *
     * @param int|null $new_qty Returned qty
     *
     * @return self
     */
    public function setNewQty($new_qty)
    {
        if (is_null($new_qty)) {
            throw new \InvalidArgumentException('non-nullable new_qty cannot be null');
        }
        $this->container['new_qty'] = $new_qty;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


