<?php
/**
 * ReturnOrderHeader
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ReturnOrderHeader Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReturnOrderHeader implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReturnOrderHeader';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'n_order_id' => 'int',
        'source' => 'string',
        'sub_source' => 'string',
        'postal_service_name' => 'string',
        'c_shipping_address' => 'string',
        'c_currency' => 'string',
        'd_received_date' => '\DateTime',
        'd_processed_on' => '\DateTime',
        'f_total_charge' => 'float',
        'refund_link' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'n_order_id' => 'int32',
        'source' => null,
        'sub_source' => null,
        'postal_service_name' => null,
        'c_shipping_address' => null,
        'c_currency' => null,
        'd_received_date' => 'date-time',
        'd_processed_on' => 'date-time',
        'f_total_charge' => 'double',
        'refund_link' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'n_order_id' => false,
        'source' => false,
        'sub_source' => false,
        'postal_service_name' => false,
        'c_shipping_address' => false,
        'c_currency' => false,
        'd_received_date' => false,
        'd_processed_on' => false,
        'f_total_charge' => false,
        'refund_link' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderId',
        'n_order_id' => 'nOrderId',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'postal_service_name' => 'PostalServiceName',
        'c_shipping_address' => 'cShippingAddress',
        'c_currency' => 'cCurrency',
        'd_received_date' => 'dReceivedDate',
        'd_processed_on' => 'dProcessedOn',
        'f_total_charge' => 'fTotalCharge',
        'refund_link' => 'RefundLink'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'n_order_id' => 'setNOrderId',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'postal_service_name' => 'setPostalServiceName',
        'c_shipping_address' => 'setCShippingAddress',
        'c_currency' => 'setCCurrency',
        'd_received_date' => 'setDReceivedDate',
        'd_processed_on' => 'setDProcessedOn',
        'f_total_charge' => 'setFTotalCharge',
        'refund_link' => 'setRefundLink'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'n_order_id' => 'getNOrderId',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'postal_service_name' => 'getPostalServiceName',
        'c_shipping_address' => 'getCShippingAddress',
        'c_currency' => 'getCCurrency',
        'd_received_date' => 'getDReceivedDate',
        'd_processed_on' => 'getDProcessedOn',
        'f_total_charge' => 'getFTotalCharge',
        'refund_link' => 'getRefundLink'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('c_shipping_address', $data ?? [], null);
        $this->setIfExists('c_currency', $data ?? [], null);
        $this->setIfExists('d_received_date', $data ?? [], null);
        $this->setIfExists('d_processed_on', $data ?? [], null);
        $this->setIfExists('f_total_charge', $data ?? [], null);
        $this->setIfExists('refund_link', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order ID
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Linnworks order number
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source Subsource (e.g. EBAY1)
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name Postal service name (e.g. Next day delivery)
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets c_shipping_address
     *
     * @return string|null
     */
    public function getCShippingAddress()
    {
        return $this->container['c_shipping_address'];
    }

    /**
     * Sets c_shipping_address
     *
     * @param string|null $c_shipping_address Shipping address
     *
     * @return self
     */
    public function setCShippingAddress($c_shipping_address)
    {
        if (is_null($c_shipping_address)) {
            throw new \InvalidArgumentException('non-nullable c_shipping_address cannot be null');
        }
        $this->container['c_shipping_address'] = $c_shipping_address;

        return $this;
    }

    /**
     * Gets c_currency
     *
     * @return string|null
     */
    public function getCCurrency()
    {
        return $this->container['c_currency'];
    }

    /**
     * Sets c_currency
     *
     * @param string|null $c_currency Currency
     *
     * @return self
     */
    public function setCCurrency($c_currency)
    {
        if (is_null($c_currency)) {
            throw new \InvalidArgumentException('non-nullable c_currency cannot be null');
        }
        $this->container['c_currency'] = $c_currency;

        return $this;
    }

    /**
     * Gets d_received_date
     *
     * @return \DateTime|null
     */
    public function getDReceivedDate()
    {
        return $this->container['d_received_date'];
    }

    /**
     * Sets d_received_date
     *
     * @param \DateTime|null $d_received_date Order received date. When order was downloaded from the channel
     *
     * @return self
     */
    public function setDReceivedDate($d_received_date)
    {
        if (is_null($d_received_date)) {
            throw new \InvalidArgumentException('non-nullable d_received_date cannot be null');
        }
        $this->container['d_received_date'] = $d_received_date;

        return $this;
    }

    /**
     * Gets d_processed_on
     *
     * @return \DateTime|null
     */
    public function getDProcessedOn()
    {
        return $this->container['d_processed_on'];
    }

    /**
     * Sets d_processed_on
     *
     * @param \DateTime|null $d_processed_on When order was processed
     *
     * @return self
     */
    public function setDProcessedOn($d_processed_on)
    {
        if (is_null($d_processed_on)) {
            throw new \InvalidArgumentException('non-nullable d_processed_on cannot be null');
        }
        $this->container['d_processed_on'] = $d_processed_on;

        return $this;
    }

    /**
     * Gets f_total_charge
     *
     * @return float|null
     */
    public function getFTotalCharge()
    {
        return $this->container['f_total_charge'];
    }

    /**
     * Sets f_total_charge
     *
     * @param float|null $f_total_charge OrdOrder total charge
     *
     * @return self
     */
    public function setFTotalCharge($f_total_charge)
    {
        if (is_null($f_total_charge)) {
            throw new \InvalidArgumentException('non-nullable f_total_charge cannot be null');
        }
        $this->container['f_total_charge'] = $f_total_charge;

        return $this;
    }

    /**
     * Gets refund_link
     *
     * @return string|null
     */
    public function getRefundLink()
    {
        return $this->container['refund_link'];
    }

    /**
     * Sets refund_link
     *
     * @param string|null $refund_link Link to order refund
     *
     * @return self
     */
    public function setRefundLink($refund_link)
    {
        if (is_null($refund_link)) {
            throw new \InvalidArgumentException('non-nullable refund_link cannot be null');
        }
        $this->container['refund_link'] = $refund_link;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


