<?php
/**
 * ReturnInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ReturnInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReturnInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReturnInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_return_id' => 'int',
        'row_type' => 'string',
        'return_reference' => 'string',
        'fk_order_id' => 'string',
        'fk_order_item_row_id' => 'string',
        'order_item_batch_id' => 'int',
        'n_order_id' => 'int',
        'sku' => 'string',
        'item_title' => 'string',
        'batch_number' => 'string',
        'reason' => 'string',
        'channel_reason' => 'string',
        'channel_reason_sec' => 'string',
        'category' => 'string',
        'return_qty' => 'int',
        'fk_return_location_id' => 'string',
        'scrapped' => 'bool',
        'scrap_qty' => 'int',
        'last_state' => 'string',
        'last_date' => '\DateTime',
        'completed' => 'bool',
        'fk_new_order_id' => 'string',
        'fk_new_order_item_row_id' => 'string',
        'fk_new_stock_item_id' => 'string',
        'new_qty' => 'int',
        'new_order_id' => 'int',
        'new_order_cancelled' => 'bool',
        'new_sku' => 'string',
        'new_item_title' => 'string',
        'new_order_processed_on' => '\DateTime',
        'additional_cost' => 'float',
        'fk_refund_row_id' => 'string',
        'refunded_amount' => 'float',
        'pending_refund' => 'float',
        'return_date' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_return_id' => 'int32',
        'row_type' => null,
        'return_reference' => null,
        'fk_order_id' => 'uuid',
        'fk_order_item_row_id' => 'uuid',
        'order_item_batch_id' => 'int32',
        'n_order_id' => 'int32',
        'sku' => null,
        'item_title' => null,
        'batch_number' => null,
        'reason' => null,
        'channel_reason' => null,
        'channel_reason_sec' => null,
        'category' => null,
        'return_qty' => 'int32',
        'fk_return_location_id' => 'uuid',
        'scrapped' => null,
        'scrap_qty' => 'int32',
        'last_state' => null,
        'last_date' => 'date-time',
        'completed' => null,
        'fk_new_order_id' => 'uuid',
        'fk_new_order_item_row_id' => 'uuid',
        'fk_new_stock_item_id' => 'uuid',
        'new_qty' => 'int32',
        'new_order_id' => 'int32',
        'new_order_cancelled' => null,
        'new_sku' => null,
        'new_item_title' => null,
        'new_order_processed_on' => 'date-time',
        'additional_cost' => 'double',
        'fk_refund_row_id' => 'uuid',
        'refunded_amount' => 'double',
        'pending_refund' => 'double',
        'return_date' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_return_id' => false,
        'row_type' => false,
        'return_reference' => false,
        'fk_order_id' => false,
        'fk_order_item_row_id' => false,
        'order_item_batch_id' => false,
        'n_order_id' => false,
        'sku' => false,
        'item_title' => false,
        'batch_number' => false,
        'reason' => false,
        'channel_reason' => false,
        'channel_reason_sec' => false,
        'category' => false,
        'return_qty' => false,
        'fk_return_location_id' => false,
        'scrapped' => false,
        'scrap_qty' => false,
        'last_state' => false,
        'last_date' => false,
        'completed' => false,
        'fk_new_order_id' => false,
        'fk_new_order_item_row_id' => false,
        'fk_new_stock_item_id' => false,
        'new_qty' => false,
        'new_order_id' => false,
        'new_order_cancelled' => false,
        'new_sku' => false,
        'new_item_title' => false,
        'new_order_processed_on' => false,
        'additional_cost' => false,
        'fk_refund_row_id' => false,
        'refunded_amount' => false,
        'pending_refund' => false,
        'return_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_return_id' => 'pkReturnId',
        'row_type' => 'RowType',
        'return_reference' => 'ReturnReference',
        'fk_order_id' => 'fkOrderId',
        'fk_order_item_row_id' => 'fkOrderItemRowId',
        'order_item_batch_id' => 'OrderItemBatchId',
        'n_order_id' => 'nOrderId',
        'sku' => 'SKU',
        'item_title' => 'ItemTitle',
        'batch_number' => 'BatchNumber',
        'reason' => 'Reason',
        'channel_reason' => 'ChannelReason',
        'channel_reason_sec' => 'ChannelReasonSec',
        'category' => 'Category',
        'return_qty' => 'ReturnQty',
        'fk_return_location_id' => 'fkReturnLocationId',
        'scrapped' => 'Scrapped',
        'scrap_qty' => 'ScrapQty',
        'last_state' => 'LastState',
        'last_date' => 'LastDate',
        'completed' => 'Completed',
        'fk_new_order_id' => 'fkNewOrderId',
        'fk_new_order_item_row_id' => 'fkNewOrderItemRowId',
        'fk_new_stock_item_id' => 'fkNewStockItemId',
        'new_qty' => 'NewQty',
        'new_order_id' => 'NewOrderId',
        'new_order_cancelled' => 'NewOrderCancelled',
        'new_sku' => 'NewSKU',
        'new_item_title' => 'NewItemTitle',
        'new_order_processed_on' => 'NewOrderProcessedOn',
        'additional_cost' => 'AdditionalCost',
        'fk_refund_row_id' => 'fkRefundRowId',
        'refunded_amount' => 'RefundedAmount',
        'pending_refund' => 'PendingRefund',
        'return_date' => 'ReturnDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_return_id' => 'setPkReturnId',
        'row_type' => 'setRowType',
        'return_reference' => 'setReturnReference',
        'fk_order_id' => 'setFkOrderId',
        'fk_order_item_row_id' => 'setFkOrderItemRowId',
        'order_item_batch_id' => 'setOrderItemBatchId',
        'n_order_id' => 'setNOrderId',
        'sku' => 'setSku',
        'item_title' => 'setItemTitle',
        'batch_number' => 'setBatchNumber',
        'reason' => 'setReason',
        'channel_reason' => 'setChannelReason',
        'channel_reason_sec' => 'setChannelReasonSec',
        'category' => 'setCategory',
        'return_qty' => 'setReturnQty',
        'fk_return_location_id' => 'setFkReturnLocationId',
        'scrapped' => 'setScrapped',
        'scrap_qty' => 'setScrapQty',
        'last_state' => 'setLastState',
        'last_date' => 'setLastDate',
        'completed' => 'setCompleted',
        'fk_new_order_id' => 'setFkNewOrderId',
        'fk_new_order_item_row_id' => 'setFkNewOrderItemRowId',
        'fk_new_stock_item_id' => 'setFkNewStockItemId',
        'new_qty' => 'setNewQty',
        'new_order_id' => 'setNewOrderId',
        'new_order_cancelled' => 'setNewOrderCancelled',
        'new_sku' => 'setNewSku',
        'new_item_title' => 'setNewItemTitle',
        'new_order_processed_on' => 'setNewOrderProcessedOn',
        'additional_cost' => 'setAdditionalCost',
        'fk_refund_row_id' => 'setFkRefundRowId',
        'refunded_amount' => 'setRefundedAmount',
        'pending_refund' => 'setPendingRefund',
        'return_date' => 'setReturnDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_return_id' => 'getPkReturnId',
        'row_type' => 'getRowType',
        'return_reference' => 'getReturnReference',
        'fk_order_id' => 'getFkOrderId',
        'fk_order_item_row_id' => 'getFkOrderItemRowId',
        'order_item_batch_id' => 'getOrderItemBatchId',
        'n_order_id' => 'getNOrderId',
        'sku' => 'getSku',
        'item_title' => 'getItemTitle',
        'batch_number' => 'getBatchNumber',
        'reason' => 'getReason',
        'channel_reason' => 'getChannelReason',
        'channel_reason_sec' => 'getChannelReasonSec',
        'category' => 'getCategory',
        'return_qty' => 'getReturnQty',
        'fk_return_location_id' => 'getFkReturnLocationId',
        'scrapped' => 'getScrapped',
        'scrap_qty' => 'getScrapQty',
        'last_state' => 'getLastState',
        'last_date' => 'getLastDate',
        'completed' => 'getCompleted',
        'fk_new_order_id' => 'getFkNewOrderId',
        'fk_new_order_item_row_id' => 'getFkNewOrderItemRowId',
        'fk_new_stock_item_id' => 'getFkNewStockItemId',
        'new_qty' => 'getNewQty',
        'new_order_id' => 'getNewOrderId',
        'new_order_cancelled' => 'getNewOrderCancelled',
        'new_sku' => 'getNewSku',
        'new_item_title' => 'getNewItemTitle',
        'new_order_processed_on' => 'getNewOrderProcessedOn',
        'additional_cost' => 'getAdditionalCost',
        'fk_refund_row_id' => 'getFkRefundRowId',
        'refunded_amount' => 'getRefundedAmount',
        'pending_refund' => 'getPendingRefund',
        'return_date' => 'getReturnDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ROW_TYPE_UNKNOWN = 'UNKNOWN';
    public const ROW_TYPE__RETURN = 'RETURN';
    public const ROW_TYPE_RETURNREFUND = 'RETURNREFUND';
    public const ROW_TYPE_EXCHANGE = 'EXCHANGE';
    public const ROW_TYPE_RESEND = 'RESEND';
    public const ROW_TYPE_RETURNBOOKING = 'RETURNBOOKING';
    public const ROW_TYPE_EXCHANGEBOOKING = 'EXCHANGEBOOKING';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRowTypeAllowableValues()
    {
        return [
            self::ROW_TYPE_UNKNOWN,
            self::ROW_TYPE__RETURN,
            self::ROW_TYPE_RETURNREFUND,
            self::ROW_TYPE_EXCHANGE,
            self::ROW_TYPE_RESEND,
            self::ROW_TYPE_RETURNBOOKING,
            self::ROW_TYPE_EXCHANGEBOOKING,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_return_id', $data ?? [], null);
        $this->setIfExists('row_type', $data ?? [], null);
        $this->setIfExists('return_reference', $data ?? [], null);
        $this->setIfExists('fk_order_id', $data ?? [], null);
        $this->setIfExists('fk_order_item_row_id', $data ?? [], null);
        $this->setIfExists('order_item_batch_id', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('batch_number', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('channel_reason_sec', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('return_qty', $data ?? [], null);
        $this->setIfExists('fk_return_location_id', $data ?? [], null);
        $this->setIfExists('scrapped', $data ?? [], null);
        $this->setIfExists('scrap_qty', $data ?? [], null);
        $this->setIfExists('last_state', $data ?? [], null);
        $this->setIfExists('last_date', $data ?? [], null);
        $this->setIfExists('completed', $data ?? [], null);
        $this->setIfExists('fk_new_order_id', $data ?? [], null);
        $this->setIfExists('fk_new_order_item_row_id', $data ?? [], null);
        $this->setIfExists('fk_new_stock_item_id', $data ?? [], null);
        $this->setIfExists('new_qty', $data ?? [], null);
        $this->setIfExists('new_order_id', $data ?? [], null);
        $this->setIfExists('new_order_cancelled', $data ?? [], null);
        $this->setIfExists('new_sku', $data ?? [], null);
        $this->setIfExists('new_item_title', $data ?? [], null);
        $this->setIfExists('new_order_processed_on', $data ?? [], null);
        $this->setIfExists('additional_cost', $data ?? [], null);
        $this->setIfExists('fk_refund_row_id', $data ?? [], null);
        $this->setIfExists('refunded_amount', $data ?? [], null);
        $this->setIfExists('pending_refund', $data ?? [], null);
        $this->setIfExists('return_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getRowTypeAllowableValues();
        if (!is_null($this->container['row_type']) && !in_array($this->container['row_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'row_type', must be one of '%s'",
                $this->container['row_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_return_id
     *
     * @return int|null
     */
    public function getPkReturnId()
    {
        return $this->container['pk_return_id'];
    }

    /**
     * Sets pk_return_id
     *
     * @param int|null $pk_return_id Return ID
     *
     * @return self
     */
    public function setPkReturnId($pk_return_id)
    {
        if (is_null($pk_return_id)) {
            throw new \InvalidArgumentException('non-nullable pk_return_id cannot be null');
        }
        $this->container['pk_return_id'] = $pk_return_id;

        return $this;
    }

    /**
     * Gets row_type
     *
     * @return string|null
     */
    public function getRowType()
    {
        return $this->container['row_type'];
    }

    /**
     * Sets row_type
     *
     * @param string|null $row_type return type (e.g. EXCHANGE)
     *
     * @return self
     */
    public function setRowType($row_type)
    {
        if (is_null($row_type)) {
            throw new \InvalidArgumentException('non-nullable row_type cannot be null');
        }
        $allowedValues = $this->getRowTypeAllowableValues();
        if (!in_array($row_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'row_type', must be one of '%s'",
                    $row_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['row_type'] = $row_type;

        return $this;
    }

    /**
     * Gets return_reference
     *
     * @return string|null
     */
    public function getReturnReference()
    {
        return $this->container['return_reference'];
    }

    /**
     * Sets return_reference
     *
     * @param string|null $return_reference Return reference
     *
     * @return self
     */
    public function setReturnReference($return_reference)
    {
        if (is_null($return_reference)) {
            throw new \InvalidArgumentException('non-nullable return_reference cannot be null');
        }
        $this->container['return_reference'] = $return_reference;

        return $this;
    }

    /**
     * Gets fk_order_id
     *
     * @return string|null
     */
    public function getFkOrderId()
    {
        return $this->container['fk_order_id'];
    }

    /**
     * Sets fk_order_id
     *
     * @param string|null $fk_order_id Order ID
     *
     * @return self
     */
    public function setFkOrderId($fk_order_id)
    {
        if (is_null($fk_order_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_id cannot be null');
        }
        $this->container['fk_order_id'] = $fk_order_id;

        return $this;
    }

    /**
     * Gets fk_order_item_row_id
     *
     * @return string|null
     */
    public function getFkOrderItemRowId()
    {
        return $this->container['fk_order_item_row_id'];
    }

    /**
     * Sets fk_order_item_row_id
     *
     * @param string|null $fk_order_item_row_id Order item record row ID
     *
     * @return self
     */
    public function setFkOrderItemRowId($fk_order_item_row_id)
    {
        if (is_null($fk_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_row_id cannot be null');
        }
        $this->container['fk_order_item_row_id'] = $fk_order_item_row_id;

        return $this;
    }

    /**
     * Gets order_item_batch_id
     *
     * @return int|null
     */
    public function getOrderItemBatchId()
    {
        return $this->container['order_item_batch_id'];
    }

    /**
     * Sets order_item_batch_id
     *
     * @param int|null $order_item_batch_id Order item batch id
     *
     * @return self
     */
    public function setOrderItemBatchId($order_item_batch_id)
    {
        if (is_null($order_item_batch_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_batch_id cannot be null');
        }
        $this->container['order_item_batch_id'] = $order_item_batch_id;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Linnworks order number
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Product title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets batch_number
     *
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->container['batch_number'];
    }

    /**
     * Sets batch_number
     *
     * @param string|null $batch_number Batch number
     *
     * @return self
     */
    public function setBatchNumber($batch_number)
    {
        if (is_null($batch_number)) {
            throw new \InvalidArgumentException('non-nullable batch_number cannot be null');
        }
        $this->container['batch_number'] = $batch_number;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason Return reason
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason Return reason set on a channel
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets channel_reason_sec
     *
     * @return string|null
     */
    public function getChannelReasonSec()
    {
        return $this->container['channel_reason_sec'];
    }

    /**
     * Sets channel_reason_sec
     *
     * @param string|null $channel_reason_sec Secondary return reason on a channel
     *
     * @return self
     */
    public function setChannelReasonSec($channel_reason_sec)
    {
        if (is_null($channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable channel_reason_sec cannot be null');
        }
        $this->container['channel_reason_sec'] = $channel_reason_sec;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category Category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets return_qty
     *
     * @return int|null
     */
    public function getReturnQty()
    {
        return $this->container['return_qty'];
    }

    /**
     * Sets return_qty
     *
     * @param int|null $return_qty Returned quantity
     *
     * @return self
     */
    public function setReturnQty($return_qty)
    {
        if (is_null($return_qty)) {
            throw new \InvalidArgumentException('non-nullable return_qty cannot be null');
        }
        $this->container['return_qty'] = $return_qty;

        return $this;
    }

    /**
     * Gets fk_return_location_id
     *
     * @return string|null
     */
    public function getFkReturnLocationId()
    {
        return $this->container['fk_return_location_id'];
    }

    /**
     * Sets fk_return_location_id
     *
     * @param string|null $fk_return_location_id Return location ID
     *
     * @return self
     */
    public function setFkReturnLocationId($fk_return_location_id)
    {
        if (is_null($fk_return_location_id)) {
            throw new \InvalidArgumentException('non-nullable fk_return_location_id cannot be null');
        }
        $this->container['fk_return_location_id'] = $fk_return_location_id;

        return $this;
    }

    /**
     * Gets scrapped
     *
     * @return bool|null
     */
    public function getScrapped()
    {
        return $this->container['scrapped'];
    }

    /**
     * Sets scrapped
     *
     * @param bool|null $scrapped If returned item was scrapped
     *
     * @return self
     */
    public function setScrapped($scrapped)
    {
        if (is_null($scrapped)) {
            throw new \InvalidArgumentException('non-nullable scrapped cannot be null');
        }
        $this->container['scrapped'] = $scrapped;

        return $this;
    }

    /**
     * Gets scrap_qty
     *
     * @return int|null
     */
    public function getScrapQty()
    {
        return $this->container['scrap_qty'];
    }

    /**
     * Sets scrap_qty
     *
     * @param int|null $scrap_qty Scrapped quantity
     *
     * @return self
     */
    public function setScrapQty($scrap_qty)
    {
        if (is_null($scrap_qty)) {
            throw new \InvalidArgumentException('non-nullable scrap_qty cannot be null');
        }
        $this->container['scrap_qty'] = $scrap_qty;

        return $this;
    }

    /**
     * Gets last_state
     *
     * @return string|null
     */
    public function getLastState()
    {
        return $this->container['last_state'];
    }

    /**
     * Sets last_state
     *
     * @param string|null $last_state Last state
     *
     * @return self
     */
    public function setLastState($last_state)
    {
        if (is_null($last_state)) {
            throw new \InvalidArgumentException('non-nullable last_state cannot be null');
        }
        $this->container['last_state'] = $last_state;

        return $this;
    }

    /**
     * Gets last_date
     *
     * @return \DateTime|null
     */
    public function getLastDate()
    {
        return $this->container['last_date'];
    }

    /**
     * Sets last_date
     *
     * @param \DateTime|null $last_date Last date
     *
     * @return self
     */
    public function setLastDate($last_date)
    {
        if (is_null($last_date)) {
            throw new \InvalidArgumentException('non-nullable last_date cannot be null');
        }
        $this->container['last_date'] = $last_date;

        return $this;
    }

    /**
     * Gets completed
     *
     * @return bool|null
     */
    public function getCompleted()
    {
        return $this->container['completed'];
    }

    /**
     * Sets completed
     *
     * @param bool|null $completed If return is completed
     *
     * @return self
     */
    public function setCompleted($completed)
    {
        if (is_null($completed)) {
            throw new \InvalidArgumentException('non-nullable completed cannot be null');
        }
        $this->container['completed'] = $completed;

        return $this;
    }

    /**
     * Gets fk_new_order_id
     *
     * @return string|null
     */
    public function getFkNewOrderId()
    {
        return $this->container['fk_new_order_id'];
    }

    /**
     * Sets fk_new_order_id
     *
     * @param string|null $fk_new_order_id New order ID for return
     *
     * @return self
     */
    public function setFkNewOrderId($fk_new_order_id)
    {
        if (is_null($fk_new_order_id)) {
            throw new \InvalidArgumentException('non-nullable fk_new_order_id cannot be null');
        }
        $this->container['fk_new_order_id'] = $fk_new_order_id;

        return $this;
    }

    /**
     * Gets fk_new_order_item_row_id
     *
     * @return string|null
     */
    public function getFkNewOrderItemRowId()
    {
        return $this->container['fk_new_order_item_row_id'];
    }

    /**
     * Sets fk_new_order_item_row_id
     *
     * @param string|null $fk_new_order_item_row_id New order item record row ID
     *
     * @return self
     */
    public function setFkNewOrderItemRowId($fk_new_order_item_row_id)
    {
        if (is_null($fk_new_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_new_order_item_row_id cannot be null');
        }
        $this->container['fk_new_order_item_row_id'] = $fk_new_order_item_row_id;

        return $this;
    }

    /**
     * Gets fk_new_stock_item_id
     *
     * @return string|null
     */
    public function getFkNewStockItemId()
    {
        return $this->container['fk_new_stock_item_id'];
    }

    /**
     * Sets fk_new_stock_item_id
     *
     * @param string|null $fk_new_stock_item_id New stock item ID
     *
     * @return self
     */
    public function setFkNewStockItemId($fk_new_stock_item_id)
    {
        if (is_null($fk_new_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_new_stock_item_id cannot be null');
        }
        $this->container['fk_new_stock_item_id'] = $fk_new_stock_item_id;

        return $this;
    }

    /**
     * Gets new_qty
     *
     * @return int|null
     */
    public function getNewQty()
    {
        return $this->container['new_qty'];
    }

    /**
     * Sets new_qty
     *
     * @param int|null $new_qty New return quantity
     *
     * @return self
     */
    public function setNewQty($new_qty)
    {
        if (is_null($new_qty)) {
            throw new \InvalidArgumentException('non-nullable new_qty cannot be null');
        }
        $this->container['new_qty'] = $new_qty;

        return $this;
    }

    /**
     * Gets new_order_id
     *
     * @return int|null
     */
    public function getNewOrderId()
    {
        return $this->container['new_order_id'];
    }

    /**
     * Sets new_order_id
     *
     * @param int|null $new_order_id New order ID
     *
     * @return self
     */
    public function setNewOrderId($new_order_id)
    {
        if (is_null($new_order_id)) {
            throw new \InvalidArgumentException('non-nullable new_order_id cannot be null');
        }
        $this->container['new_order_id'] = $new_order_id;

        return $this;
    }

    /**
     * Gets new_order_cancelled
     *
     * @return bool|null
     */
    public function getNewOrderCancelled()
    {
        return $this->container['new_order_cancelled'];
    }

    /**
     * Sets new_order_cancelled
     *
     * @param bool|null $new_order_cancelled If new order were cancelled
     *
     * @return self
     */
    public function setNewOrderCancelled($new_order_cancelled)
    {
        if (is_null($new_order_cancelled)) {
            throw new \InvalidArgumentException('non-nullable new_order_cancelled cannot be null');
        }
        $this->container['new_order_cancelled'] = $new_order_cancelled;

        return $this;
    }

    /**
     * Gets new_sku
     *
     * @return string|null
     */
    public function getNewSku()
    {
        return $this->container['new_sku'];
    }

    /**
     * Sets new_sku
     *
     * @param string|null $new_sku new product SKU
     *
     * @return self
     */
    public function setNewSku($new_sku)
    {
        if (is_null($new_sku)) {
            throw new \InvalidArgumentException('non-nullable new_sku cannot be null');
        }
        $this->container['new_sku'] = $new_sku;

        return $this;
    }

    /**
     * Gets new_item_title
     *
     * @return string|null
     */
    public function getNewItemTitle()
    {
        return $this->container['new_item_title'];
    }

    /**
     * Sets new_item_title
     *
     * @param string|null $new_item_title New product title
     *
     * @return self
     */
    public function setNewItemTitle($new_item_title)
    {
        if (is_null($new_item_title)) {
            throw new \InvalidArgumentException('non-nullable new_item_title cannot be null');
        }
        $this->container['new_item_title'] = $new_item_title;

        return $this;
    }

    /**
     * Gets new_order_processed_on
     *
     * @return \DateTime|null
     */
    public function getNewOrderProcessedOn()
    {
        return $this->container['new_order_processed_on'];
    }

    /**
     * Sets new_order_processed_on
     *
     * @param \DateTime|null $new_order_processed_on When new order was processed
     *
     * @return self
     */
    public function setNewOrderProcessedOn($new_order_processed_on)
    {
        if (is_null($new_order_processed_on)) {
            throw new \InvalidArgumentException('non-nullable new_order_processed_on cannot be null');
        }
        $this->container['new_order_processed_on'] = $new_order_processed_on;

        return $this;
    }

    /**
     * Gets additional_cost
     *
     * @return float|null
     */
    public function getAdditionalCost()
    {
        return $this->container['additional_cost'];
    }

    /**
     * Sets additional_cost
     *
     * @param float|null $additional_cost Additional costs involved
     *
     * @return self
     */
    public function setAdditionalCost($additional_cost)
    {
        if (is_null($additional_cost)) {
            throw new \InvalidArgumentException('non-nullable additional_cost cannot be null');
        }
        $this->container['additional_cost'] = $additional_cost;

        return $this;
    }

    /**
     * Gets fk_refund_row_id
     *
     * @return string|null
     */
    public function getFkRefundRowId()
    {
        return $this->container['fk_refund_row_id'];
    }

    /**
     * Sets fk_refund_row_id
     *
     * @param string|null $fk_refund_row_id Refund record row ID
     *
     * @return self
     */
    public function setFkRefundRowId($fk_refund_row_id)
    {
        if (is_null($fk_refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_refund_row_id cannot be null');
        }
        $this->container['fk_refund_row_id'] = $fk_refund_row_id;

        return $this;
    }

    /**
     * Gets refunded_amount
     *
     * @return float|null
     */
    public function getRefundedAmount()
    {
        return $this->container['refunded_amount'];
    }

    /**
     * Sets refunded_amount
     *
     * @param float|null $refunded_amount Amount refunded
     *
     * @return self
     */
    public function setRefundedAmount($refunded_amount)
    {
        if (is_null($refunded_amount)) {
            throw new \InvalidArgumentException('non-nullable refunded_amount cannot be null');
        }
        $this->container['refunded_amount'] = $refunded_amount;

        return $this;
    }

    /**
     * Gets pending_refund
     *
     * @return float|null
     */
    public function getPendingRefund()
    {
        return $this->container['pending_refund'];
    }

    /**
     * Sets pending_refund
     *
     * @param float|null $pending_refund Refund pending
     *
     * @return self
     */
    public function setPendingRefund($pending_refund)
    {
        if (is_null($pending_refund)) {
            throw new \InvalidArgumentException('non-nullable pending_refund cannot be null');
        }
        $this->container['pending_refund'] = $pending_refund;

        return $this;
    }

    /**
     * Gets return_date
     *
     * @return \DateTime|null
     */
    public function getReturnDate()
    {
        return $this->container['return_date'];
    }

    /**
     * Sets return_date
     *
     * @param \DateTime|null $return_date Return date
     *
     * @return self
     */
    public function setReturnDate($return_date)
    {
        if (is_null($return_date)) {
            throw new \InvalidArgumentException('non-nullable return_date cannot be null');
        }
        $this->container['return_date'] = $return_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


