<?php
/**
 * RefundItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * RefundItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_refund_row_id' => 'string',
        'is_manual_refund' => 'bool',
        'type' => 'string',
        'fk_order_item_id' => 'string',
        'refund_qty' => 'int',
        'refund_amount' => 'float',
        'reason' => 'string',
        'channel_reason' => 'string',
        'channel_reason_sec' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_refund_row_id' => 'uuid',
        'is_manual_refund' => null,
        'type' => null,
        'fk_order_item_id' => 'uuid',
        'refund_qty' => 'int32',
        'refund_amount' => 'double',
        'reason' => null,
        'channel_reason' => null,
        'channel_reason_sec' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_refund_row_id' => false,
        'is_manual_refund' => false,
        'type' => false,
        'fk_order_item_id' => false,
        'refund_qty' => false,
        'refund_amount' => false,
        'reason' => false,
        'channel_reason' => false,
        'channel_reason_sec' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_refund_row_id' => 'pkRefundRowId',
        'is_manual_refund' => 'IsManualRefund',
        'type' => 'Type',
        'fk_order_item_id' => 'fkOrderItemId',
        'refund_qty' => 'RefundQty',
        'refund_amount' => 'RefundAmount',
        'reason' => 'Reason',
        'channel_reason' => 'ChannelReason',
        'channel_reason_sec' => 'ChannelReasonSec'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_refund_row_id' => 'setPkRefundRowId',
        'is_manual_refund' => 'setIsManualRefund',
        'type' => 'setType',
        'fk_order_item_id' => 'setFkOrderItemId',
        'refund_qty' => 'setRefundQty',
        'refund_amount' => 'setRefundAmount',
        'reason' => 'setReason',
        'channel_reason' => 'setChannelReason',
        'channel_reason_sec' => 'setChannelReasonSec'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_refund_row_id' => 'getPkRefundRowId',
        'is_manual_refund' => 'getIsManualRefund',
        'type' => 'getType',
        'fk_order_item_id' => 'getFkOrderItemId',
        'refund_qty' => 'getRefundQty',
        'refund_amount' => 'getRefundAmount',
        'reason' => 'getReason',
        'channel_reason' => 'getChannelReason',
        'channel_reason_sec' => 'getChannelReasonSec'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_ITEM = 'Item';
    public const TYPE_SERVICE = 'Service';
    public const TYPE_SHIPPING = 'Shipping';
    public const TYPE_FREE_TEXT = 'FreeText';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ITEM,
            self::TYPE_SERVICE,
            self::TYPE_SHIPPING,
            self::TYPE_FREE_TEXT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_refund_row_id', $data ?? [], null);
        $this->setIfExists('is_manual_refund', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('fk_order_item_id', $data ?? [], null);
        $this->setIfExists('refund_qty', $data ?? [], null);
        $this->setIfExists('refund_amount', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('channel_reason_sec', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_refund_row_id
     *
     * @return string|null
     */
    public function getPkRefundRowId()
    {
        return $this->container['pk_refund_row_id'];
    }

    /**
     * Sets pk_refund_row_id
     *
     * @param string|null $pk_refund_row_id For updating refund amounts
     *
     * @return self
     */
    public function setPkRefundRowId($pk_refund_row_id)
    {
        if (is_null($pk_refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_refund_row_id cannot be null');
        }
        $this->container['pk_refund_row_id'] = $pk_refund_row_id;

        return $this;
    }

    /**
     * Gets is_manual_refund
     *
     * @return bool|null
     */
    public function getIsManualRefund()
    {
        return $this->container['is_manual_refund'];
    }

    /**
     * Sets is_manual_refund
     *
     * @param bool|null $is_manual_refund Manual refunds will never be passed to the channel validation routines
     *
     * @return self
     */
    public function setIsManualRefund($is_manual_refund)
    {
        if (is_null($is_manual_refund)) {
            throw new \InvalidArgumentException('non-nullable is_manual_refund cannot be null');
        }
        $this->container['is_manual_refund'] = $is_manual_refund;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of refund item
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets fk_order_item_id
     *
     * @return string|null
     */
    public function getFkOrderItemId()
    {
        return $this->container['fk_order_item_id'];
    }

    /**
     * Sets fk_order_item_id
     *
     * @param string|null $fk_order_item_id The order item or service to refund
     *
     * @return self
     */
    public function setFkOrderItemId($fk_order_item_id)
    {
        if (is_null($fk_order_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_id cannot be null');
        }
        $this->container['fk_order_item_id'] = $fk_order_item_id;

        return $this;
    }

    /**
     * Gets refund_qty
     *
     * @return int|null
     */
    public function getRefundQty()
    {
        return $this->container['refund_qty'];
    }

    /**
     * Sets refund_qty
     *
     * @param int|null $refund_qty In the case of item refunds, the number of items
     *
     * @return self
     */
    public function setRefundQty($refund_qty)
    {
        if (is_null($refund_qty)) {
            throw new \InvalidArgumentException('non-nullable refund_qty cannot be null');
        }
        $this->container['refund_qty'] = $refund_qty;

        return $this;
    }

    /**
     * Gets refund_amount
     *
     * @return float|null
     */
    public function getRefundAmount()
    {
        return $this->container['refund_amount'];
    }

    /**
     * Sets refund_amount
     *
     * @param float|null $refund_amount The amount of money the refund is for.
     *
     * @return self
     */
    public function setRefundAmount($refund_amount)
    {
        if (is_null($refund_amount)) {
            throw new \InvalidArgumentException('non-nullable refund_amount cannot be null');
        }
        $this->container['refund_amount'] = $refund_amount;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason The seller's text reason for the refund
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason The primary channel reason
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets channel_reason_sec
     *
     * @return string|null
     */
    public function getChannelReasonSec()
    {
        return $this->container['channel_reason_sec'];
    }

    /**
     * Sets channel_reason_sec
     *
     * @param string|null $channel_reason_sec The secondary channel reason
     *
     * @return self
     */
    public function setChannelReasonSec($channel_reason_sec)
    {
        if (is_null($channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable channel_reason_sec cannot be null');
        }
        $this->container['channel_reason_sec'] = $channel_reason_sec;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


