<?php
/**
 * RefundInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * RefundInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_refund_row_id' => 'string',
        'sku' => 'string',
        'item_title' => 'string',
        'is_item' => 'bool',
        'is_service' => 'bool',
        'amount' => 'float',
        'reason' => 'string',
        'actioned' => 'bool',
        'action_date' => '\DateTime',
        'return_reference' => 'string',
        'cost' => 'float',
        'refund_status' => 'string',
        'ignored_validation' => 'bool',
        'fk_order_item_row_id' => 'string',
        'should_serialize_channel_reason' => 'bool',
        'channel_reason' => 'string',
        'should_serialize_channel_reason_sec' => 'bool',
        'channel_reason_sec' => 'string',
        'is_new' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_refund_row_id' => 'uuid',
        'sku' => null,
        'item_title' => null,
        'is_item' => null,
        'is_service' => null,
        'amount' => 'double',
        'reason' => null,
        'actioned' => null,
        'action_date' => 'date-time',
        'return_reference' => null,
        'cost' => 'double',
        'refund_status' => null,
        'ignored_validation' => null,
        'fk_order_item_row_id' => 'uuid',
        'should_serialize_channel_reason' => null,
        'channel_reason' => null,
        'should_serialize_channel_reason_sec' => null,
        'channel_reason_sec' => null,
        'is_new' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_refund_row_id' => false,
        'sku' => false,
        'item_title' => false,
        'is_item' => false,
        'is_service' => false,
        'amount' => false,
        'reason' => false,
        'actioned' => false,
        'action_date' => false,
        'return_reference' => false,
        'cost' => false,
        'refund_status' => false,
        'ignored_validation' => false,
        'fk_order_item_row_id' => false,
        'should_serialize_channel_reason' => false,
        'channel_reason' => false,
        'should_serialize_channel_reason_sec' => false,
        'channel_reason_sec' => false,
        'is_new' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_refund_row_id' => 'pkRefundRowId',
        'sku' => 'SKU',
        'item_title' => 'ItemTitle',
        'is_item' => 'IsItem',
        'is_service' => 'IsService',
        'amount' => 'Amount',
        'reason' => 'Reason',
        'actioned' => 'Actioned',
        'action_date' => 'ActionDate',
        'return_reference' => 'ReturnReference',
        'cost' => 'Cost',
        'refund_status' => 'RefundStatus',
        'ignored_validation' => 'IgnoredValidation',
        'fk_order_item_row_id' => 'fkOrderItemRowId',
        'should_serialize_channel_reason' => 'ShouldSerializeChannelReason',
        'channel_reason' => 'ChannelReason',
        'should_serialize_channel_reason_sec' => 'ShouldSerializeChannelReasonSec',
        'channel_reason_sec' => 'ChannelReasonSec',
        'is_new' => 'IsNew'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_refund_row_id' => 'setPkRefundRowId',
        'sku' => 'setSku',
        'item_title' => 'setItemTitle',
        'is_item' => 'setIsItem',
        'is_service' => 'setIsService',
        'amount' => 'setAmount',
        'reason' => 'setReason',
        'actioned' => 'setActioned',
        'action_date' => 'setActionDate',
        'return_reference' => 'setReturnReference',
        'cost' => 'setCost',
        'refund_status' => 'setRefundStatus',
        'ignored_validation' => 'setIgnoredValidation',
        'fk_order_item_row_id' => 'setFkOrderItemRowId',
        'should_serialize_channel_reason' => 'setShouldSerializeChannelReason',
        'channel_reason' => 'setChannelReason',
        'should_serialize_channel_reason_sec' => 'setShouldSerializeChannelReasonSec',
        'channel_reason_sec' => 'setChannelReasonSec',
        'is_new' => 'setIsNew'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_refund_row_id' => 'getPkRefundRowId',
        'sku' => 'getSku',
        'item_title' => 'getItemTitle',
        'is_item' => 'getIsItem',
        'is_service' => 'getIsService',
        'amount' => 'getAmount',
        'reason' => 'getReason',
        'actioned' => 'getActioned',
        'action_date' => 'getActionDate',
        'return_reference' => 'getReturnReference',
        'cost' => 'getCost',
        'refund_status' => 'getRefundStatus',
        'ignored_validation' => 'getIgnoredValidation',
        'fk_order_item_row_id' => 'getFkOrderItemRowId',
        'should_serialize_channel_reason' => 'getShouldSerializeChannelReason',
        'channel_reason' => 'getChannelReason',
        'should_serialize_channel_reason_sec' => 'getShouldSerializeChannelReasonSec',
        'channel_reason_sec' => 'getChannelReasonSec',
        'is_new' => 'getIsNew'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const REFUND_STATUS_OPEN = 'OPEN';
    public const REFUND_STATUS_PROCESSED = 'PROCESSED';
    public const REFUND_STATUS_ERROR = 'ERROR';
    public const REFUND_STATUS_ERROR_ACKED = 'ERROR_ACKED';
    public const REFUND_STATUS_PENDING = 'PENDING';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundStatusAllowableValues()
    {
        return [
            self::REFUND_STATUS_OPEN,
            self::REFUND_STATUS_PROCESSED,
            self::REFUND_STATUS_ERROR,
            self::REFUND_STATUS_ERROR_ACKED,
            self::REFUND_STATUS_PENDING,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_refund_row_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('is_item', $data ?? [], null);
        $this->setIfExists('is_service', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('actioned', $data ?? [], null);
        $this->setIfExists('action_date', $data ?? [], null);
        $this->setIfExists('return_reference', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('refund_status', $data ?? [], null);
        $this->setIfExists('ignored_validation', $data ?? [], null);
        $this->setIfExists('fk_order_item_row_id', $data ?? [], null);
        $this->setIfExists('should_serialize_channel_reason', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('should_serialize_channel_reason_sec', $data ?? [], null);
        $this->setIfExists('channel_reason_sec', $data ?? [], null);
        $this->setIfExists('is_new', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!is_null($this->container['refund_status']) && !in_array($this->container['refund_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund_status', must be one of '%s'",
                $this->container['refund_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_refund_row_id
     *
     * @return string|null
     */
    public function getPkRefundRowId()
    {
        return $this->container['pk_refund_row_id'];
    }

    /**
     * Sets pk_refund_row_id
     *
     * @param string|null $pk_refund_row_id Refund record ID
     *
     * @return self
     */
    public function setPkRefundRowId($pk_refund_row_id)
    {
        if (is_null($pk_refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_refund_row_id cannot be null');
        }
        $this->container['pk_refund_row_id'] = $pk_refund_row_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Product title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets is_item
     *
     * @return bool|null
     */
    public function getIsItem()
    {
        return $this->container['is_item'];
    }

    /**
     * Sets is_item
     *
     * @param bool|null $is_item If its an item that is refunded
     *
     * @return self
     */
    public function setIsItem($is_item)
    {
        if (is_null($is_item)) {
            throw new \InvalidArgumentException('non-nullable is_item cannot be null');
        }
        $this->container['is_item'] = $is_item;

        return $this;
    }

    /**
     * Gets is_service
     *
     * @return bool|null
     */
    public function getIsService()
    {
        return $this->container['is_service'];
    }

    /**
     * Sets is_service
     *
     * @param bool|null $is_service If its a service that is refunded
     *
     * @return self
     */
    public function setIsService($is_service)
    {
        if (is_null($is_service)) {
            throw new \InvalidArgumentException('non-nullable is_service cannot be null');
        }
        $this->container['is_service'] = $is_service;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount Refund amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason Reason for a refund
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets actioned
     *
     * @return bool|null
     */
    public function getActioned()
    {
        return $this->container['actioned'];
    }

    /**
     * Sets actioned
     *
     * @param bool|null $actioned If refund has been actioned
     *
     * @return self
     */
    public function setActioned($actioned)
    {
        if (is_null($actioned)) {
            throw new \InvalidArgumentException('non-nullable actioned cannot be null');
        }
        $this->container['actioned'] = $actioned;

        return $this;
    }

    /**
     * Gets action_date
     *
     * @return \DateTime|null
     */
    public function getActionDate()
    {
        return $this->container['action_date'];
    }

    /**
     * Sets action_date
     *
     * @param \DateTime|null $action_date When refund was actioned
     *
     * @return self
     */
    public function setActionDate($action_date)
    {
        if (is_null($action_date)) {
            throw new \InvalidArgumentException('non-nullable action_date cannot be null');
        }
        $this->container['action_date'] = $action_date;

        return $this;
    }

    /**
     * Gets return_reference
     *
     * @return string|null
     */
    public function getReturnReference()
    {
        return $this->container['return_reference'];
    }

    /**
     * Sets return_reference
     *
     * @param string|null $return_reference return reference number
     *
     * @return self
     */
    public function setReturnReference($return_reference)
    {
        if (is_null($return_reference)) {
            throw new \InvalidArgumentException('non-nullable return_reference cannot be null');
        }
        $this->container['return_reference'] = $return_reference;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost Cost
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets refund_status
     *
     * @return string|null
     */
    public function getRefundStatus()
    {
        return $this->container['refund_status'];
    }

    /**
     * Sets refund_status
     *
     * @param string|null $refund_status refund_status
     *
     * @return self
     */
    public function setRefundStatus($refund_status)
    {
        if (is_null($refund_status)) {
            throw new \InvalidArgumentException('non-nullable refund_status cannot be null');
        }
        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!in_array($refund_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund_status', must be one of '%s'",
                    $refund_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund_status'] = $refund_status;

        return $this;
    }

    /**
     * Gets ignored_validation
     *
     * @return bool|null
     */
    public function getIgnoredValidation()
    {
        return $this->container['ignored_validation'];
    }

    /**
     * Sets ignored_validation
     *
     * @param bool|null $ignored_validation Status of refund
     *
     * @return self
     */
    public function setIgnoredValidation($ignored_validation)
    {
        if (is_null($ignored_validation)) {
            throw new \InvalidArgumentException('non-nullable ignored_validation cannot be null');
        }
        $this->container['ignored_validation'] = $ignored_validation;

        return $this;
    }

    /**
     * Gets fk_order_item_row_id
     *
     * @return string|null
     */
    public function getFkOrderItemRowId()
    {
        return $this->container['fk_order_item_row_id'];
    }

    /**
     * Sets fk_order_item_row_id
     *
     * @param string|null $fk_order_item_row_id Order item record ID
     *
     * @return self
     */
    public function setFkOrderItemRowId($fk_order_item_row_id)
    {
        if (is_null($fk_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_row_id cannot be null');
        }
        $this->container['fk_order_item_row_id'] = $fk_order_item_row_id;

        return $this;
    }

    /**
     * Gets should_serialize_channel_reason
     *
     * @return bool|null
     */
    public function getShouldSerializeChannelReason()
    {
        return $this->container['should_serialize_channel_reason'];
    }

    /**
     * Sets should_serialize_channel_reason
     *
     * @param bool|null $should_serialize_channel_reason should_serialize_channel_reason
     *
     * @return self
     */
    public function setShouldSerializeChannelReason($should_serialize_channel_reason)
    {
        if (is_null($should_serialize_channel_reason)) {
            throw new \InvalidArgumentException('non-nullable should_serialize_channel_reason cannot be null');
        }
        $this->container['should_serialize_channel_reason'] = $should_serialize_channel_reason;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason Channel refund reason
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets should_serialize_channel_reason_sec
     *
     * @return bool|null
     */
    public function getShouldSerializeChannelReasonSec()
    {
        return $this->container['should_serialize_channel_reason_sec'];
    }

    /**
     * Sets should_serialize_channel_reason_sec
     *
     * @param bool|null $should_serialize_channel_reason_sec should_serialize_channel_reason_sec
     *
     * @return self
     */
    public function setShouldSerializeChannelReasonSec($should_serialize_channel_reason_sec)
    {
        if (is_null($should_serialize_channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable should_serialize_channel_reason_sec cannot be null');
        }
        $this->container['should_serialize_channel_reason_sec'] = $should_serialize_channel_reason_sec;

        return $this;
    }

    /**
     * Gets channel_reason_sec
     *
     * @return string|null
     */
    public function getChannelReasonSec()
    {
        return $this->container['channel_reason_sec'];
    }

    /**
     * Sets channel_reason_sec
     *
     * @param string|null $channel_reason_sec Secondary channel reason for a refund
     *
     * @return self
     */
    public function setChannelReasonSec($channel_reason_sec)
    {
        if (is_null($channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable channel_reason_sec cannot be null');
        }
        $this->container['channel_reason_sec'] = $channel_reason_sec;

        return $this;
    }

    /**
     * Gets is_new
     *
     * @return bool|null
     */
    public function getIsNew()
    {
        return $this->container['is_new'];
    }

    /**
     * Sets is_new
     *
     * @param bool|null $is_new is_new
     *
     * @return self
     */
    public function setIsNew($is_new)
    {
        if (is_null($is_new)) {
            throw new \InvalidArgumentException('non-nullable is_new cannot be null');
        }
        $this->container['is_new'] = $is_new;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


