<?php
/**
 * ProcessedOrdersSearchProcessedOrdersPagedRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ProcessedOrdersSearchProcessedOrdersPagedRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedOrdersSearchProcessedOrdersPagedRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedOrders_SearchProcessedOrdersPagedRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'from' => '\DateTime',
        'to' => '\DateTime',
        'date_type' => 'string',
        'search_field' => 'string',
        'exact_match' => 'bool',
        'search_term' => 'string',
        'page_num' => 'int',
        'num_entries_per_page' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'from' => 'date-time',
        'to' => 'date-time',
        'date_type' => null,
        'search_field' => null,
        'exact_match' => null,
        'search_term' => null,
        'page_num' => 'int32',
        'num_entries_per_page' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'from' => false,
        'to' => false,
        'date_type' => false,
        'search_field' => false,
        'exact_match' => false,
        'search_term' => false,
        'page_num' => false,
        'num_entries_per_page' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'from' => 'from',
        'to' => 'to',
        'date_type' => 'dateType',
        'search_field' => 'searchField',
        'exact_match' => 'exactMatch',
        'search_term' => 'searchTerm',
        'page_num' => 'pageNum',
        'num_entries_per_page' => 'numEntriesPerPage'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'from' => 'setFrom',
        'to' => 'setTo',
        'date_type' => 'setDateType',
        'search_field' => 'setSearchField',
        'exact_match' => 'setExactMatch',
        'search_term' => 'setSearchTerm',
        'page_num' => 'setPageNum',
        'num_entries_per_page' => 'setNumEntriesPerPage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'from' => 'getFrom',
        'to' => 'getTo',
        'date_type' => 'getDateType',
        'search_field' => 'getSearchField',
        'exact_match' => 'getExactMatch',
        'search_term' => 'getSearchTerm',
        'page_num' => 'getPageNum',
        'num_entries_per_page' => 'getNumEntriesPerPage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DATE_TYPE_ALLDATES = 'ALLDATES';
    public const DATE_TYPE_RECEIVED = 'RECEIVED';
    public const DATE_TYPE_PROCESSED = 'PROCESSED';
    public const DATE_TYPE_PAYMENTRECEIVED = 'PAYMENTRECEIVED';
    public const DATE_TYPE_CANCELLED = 'CANCELLED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDateTypeAllowableValues()
    {
        return [
            self::DATE_TYPE_ALLDATES,
            self::DATE_TYPE_RECEIVED,
            self::DATE_TYPE_PROCESSED,
            self::DATE_TYPE_PAYMENTRECEIVED,
            self::DATE_TYPE_CANCELLED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('from', $data ?? [], null);
        $this->setIfExists('to', $data ?? [], null);
        $this->setIfExists('date_type', $data ?? [], null);
        $this->setIfExists('search_field', $data ?? [], null);
        $this->setIfExists('exact_match', $data ?? [], null);
        $this->setIfExists('search_term', $data ?? [], null);
        $this->setIfExists('page_num', $data ?? [], null);
        $this->setIfExists('num_entries_per_page', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDateTypeAllowableValues();
        if (!is_null($this->container['date_type']) && !in_array($this->container['date_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'date_type', must be one of '%s'",
                $this->container['date_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets from
     *
     * @return \DateTime|null
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     *
     * @param \DateTime|null $from The lower end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
     *
     * @return self
     */
    public function setFrom($from)
    {
        if (is_null($from)) {
            throw new \InvalidArgumentException('non-nullable from cannot be null');
        }
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets to
     *
     * @return \DateTime|null
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     *
     * @param \DateTime|null $to The upper end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
     *
     * @return self
     */
    public function setTo($to)
    {
        if (is_null($to)) {
            throw new \InvalidArgumentException('non-nullable to cannot be null');
        }
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets date_type
     *
     * @return string|null
     */
    public function getDateType()
    {
        return $this->container['date_type'];
    }

    /**
     * Sets date_type
     *
     * @param string|null $date_type The search type (e.g. ALLDATES)
     *
     * @return self
     */
    public function setDateType($date_type)
    {
        if (is_null($date_type)) {
            throw new \InvalidArgumentException('non-nullable date_type cannot be null');
        }
        $allowedValues = $this->getDateTypeAllowableValues();
        if (!in_array($date_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'date_type', must be one of '%s'",
                    $date_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['date_type'] = $date_type;

        return $this;
    }

    /**
     * Gets search_field
     *
     * @return string|null
     */
    public function getSearchField()
    {
        return $this->container['search_field'];
    }

    /**
     * Sets search_field
     *
     * @param string|null $search_field The field to search by. Can be found by calling GetSearchTypes.
     *
     * @return self
     */
    public function setSearchField($search_field)
    {
        if (is_null($search_field)) {
            throw new \InvalidArgumentException('non-nullable search_field cannot be null');
        }
        $this->container['search_field'] = $search_field;

        return $this;
    }

    /**
     * Gets exact_match
     *
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->container['exact_match'];
    }

    /**
     * Sets exact_match
     *
     * @param bool|null $exact_match Set to true if an exact match is required for the search data.
     *
     * @return self
     */
    public function setExactMatch($exact_match)
    {
        if (is_null($exact_match)) {
            throw new \InvalidArgumentException('non-nullable exact_match cannot be null');
        }
        $this->container['exact_match'] = $exact_match;

        return $this;
    }

    /**
     * Gets search_term
     *
     * @return string|null
     */
    public function getSearchTerm()
    {
        return $this->container['search_term'];
    }

    /**
     * Sets search_term
     *
     * @param string|null $search_term The term which you are searching for.
     *
     * @return self
     */
    public function setSearchTerm($search_term)
    {
        if (is_null($search_term)) {
            throw new \InvalidArgumentException('non-nullable search_term cannot be null');
        }
        $this->container['search_term'] = $search_term;

        return $this;
    }

    /**
     * Gets page_num
     *
     * @return int|null
     */
    public function getPageNum()
    {
        return $this->container['page_num'];
    }

    /**
     * Sets page_num
     *
     * @param int|null $page_num The page number of the request.
     *
     * @return self
     */
    public function setPageNum($page_num)
    {
        if (is_null($page_num)) {
            throw new \InvalidArgumentException('non-nullable page_num cannot be null');
        }
        $this->container['page_num'] = $page_num;

        return $this;
    }

    /**
     * Gets num_entries_per_page
     *
     * @return int|null
     */
    public function getNumEntriesPerPage()
    {
        return $this->container['num_entries_per_page'];
    }

    /**
     * Sets num_entries_per_page
     *
     * @param int|null $num_entries_per_page The number of entries required on a page. Maximum 200.
     *
     * @return self
     */
    public function setNumEntriesPerPage($num_entries_per_page)
    {
        if (is_null($num_entries_per_page)) {
            throw new \InvalidArgumentException('non-nullable num_entries_per_page cannot be null');
        }
        $this->container['num_entries_per_page'] = $num_entries_per_page;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


