<?php
/**
 * ProcessedOrdersCreateExchangeRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ProcessedOrdersCreateExchangeRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedOrdersCreateExchangeRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedOrders_CreateExchangeRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'exchange_items' => '\Linnworks\ProcessedOrders\Model\RowQty[]',
        'despatch_location' => 'string',
        'return_location' => 'string',
        'channel_reason' => 'string',
        'channel_sub_reason' => 'string',
        'category' => 'string',
        'reason' => 'string',
        'is_booking' => 'bool',
        'ignored_validation' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'exchange_items' => null,
        'despatch_location' => 'uuid',
        'return_location' => 'uuid',
        'channel_reason' => null,
        'channel_sub_reason' => null,
        'category' => null,
        'reason' => null,
        'is_booking' => null,
        'ignored_validation' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'exchange_items' => false,
        'despatch_location' => false,
        'return_location' => false,
        'channel_reason' => false,
        'channel_sub_reason' => false,
        'category' => false,
        'reason' => false,
        'is_booking' => false,
        'ignored_validation' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderId',
        'exchange_items' => 'exchangeItems',
        'despatch_location' => 'despatchLocation',
        'return_location' => 'returnLocation',
        'channel_reason' => 'channelReason',
        'channel_sub_reason' => 'channelSubReason',
        'category' => 'category',
        'reason' => 'reason',
        'is_booking' => 'isBooking',
        'ignored_validation' => 'ignoredValidation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'exchange_items' => 'setExchangeItems',
        'despatch_location' => 'setDespatchLocation',
        'return_location' => 'setReturnLocation',
        'channel_reason' => 'setChannelReason',
        'channel_sub_reason' => 'setChannelSubReason',
        'category' => 'setCategory',
        'reason' => 'setReason',
        'is_booking' => 'setIsBooking',
        'ignored_validation' => 'setIgnoredValidation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'exchange_items' => 'getExchangeItems',
        'despatch_location' => 'getDespatchLocation',
        'return_location' => 'getReturnLocation',
        'channel_reason' => 'getChannelReason',
        'channel_sub_reason' => 'getChannelSubReason',
        'category' => 'getCategory',
        'reason' => 'getReason',
        'is_booking' => 'getIsBooking',
        'ignored_validation' => 'getIgnoredValidation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('exchange_items', $data ?? [], null);
        $this->setIfExists('despatch_location', $data ?? [], null);
        $this->setIfExists('return_location', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('channel_sub_reason', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('is_booking', $data ?? [], null);
        $this->setIfExists('ignored_validation', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id The order id
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets exchange_items
     *
     * @return \Linnworks\ProcessedOrders\Model\RowQty[]|null
     */
    public function getExchangeItems()
    {
        return $this->container['exchange_items'];
    }

    /**
     * Sets exchange_items
     *
     * @param \Linnworks\ProcessedOrders\Model\RowQty[]|null $exchange_items A list of items to be exchanged, including quantity, scrap, refund, etc.
     *
     * @return self
     */
    public function setExchangeItems($exchange_items)
    {
        if (is_null($exchange_items)) {
            throw new \InvalidArgumentException('non-nullable exchange_items cannot be null');
        }
        $this->container['exchange_items'] = $exchange_items;

        return $this;
    }

    /**
     * Gets despatch_location
     *
     * @return string|null
     */
    public function getDespatchLocation()
    {
        return $this->container['despatch_location'];
    }

    /**
     * Sets despatch_location
     *
     * @param string|null $despatch_location The id of the location to despatch replacement items from
     *
     * @return self
     */
    public function setDespatchLocation($despatch_location)
    {
        if (is_null($despatch_location)) {
            throw new \InvalidArgumentException('non-nullable despatch_location cannot be null');
        }
        $this->container['despatch_location'] = $despatch_location;

        return $this;
    }

    /**
     * Gets return_location
     *
     * @return string|null
     */
    public function getReturnLocation()
    {
        return $this->container['return_location'];
    }

    /**
     * Sets return_location
     *
     * @param string|null $return_location The id of the location to return stock to
     *
     * @return self
     */
    public function setReturnLocation($return_location)
    {
        if (is_null($return_location)) {
            throw new \InvalidArgumentException('non-nullable return_location cannot be null');
        }
        $this->container['return_location'] = $return_location;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason Channel reason - required if a refund on the channel is required
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets channel_sub_reason
     *
     * @return string|null
     */
    public function getChannelSubReason()
    {
        return $this->container['channel_sub_reason'];
    }

    /**
     * Sets channel_sub_reason
     *
     * @param string|null $channel_sub_reason Channel subreason - required if a refund on the channel is required.
     *
     * @return self
     */
    public function setChannelSubReason($channel_sub_reason)
    {
        if (is_null($channel_sub_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_sub_reason cannot be null');
        }
        $this->container['channel_sub_reason'] = $channel_sub_reason;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category The refund category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason The reason for the reason
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets is_booking
     *
     * @return bool|null
     */
    public function getIsBooking()
    {
        return $this->container['is_booking'];
    }

    /**
     * Sets is_booking
     *
     * @param bool|null $is_booking True if it is a exchange booking, False if it is a new exchange
     *
     * @return self
     */
    public function setIsBooking($is_booking)
    {
        if (is_null($is_booking)) {
            throw new \InvalidArgumentException('non-nullable is_booking cannot be null');
        }
        $this->container['is_booking'] = $is_booking;

        return $this;
    }

    /**
     * Gets ignored_validation
     *
     * @return bool|null
     */
    public function getIgnoredValidation()
    {
        return $this->container['ignored_validation'];
    }

    /**
     * Sets ignored_validation
     *
     * @param bool|null $ignored_validation True if failed validation has been ignored (see IsRefundValid). Otherwise, false. When set to true, refunds will not be automatically actioned on the channel. Ignored if creating a booking as a refund is not created at this stage.
     *
     * @return self
     */
    public function setIgnoredValidation($ignored_validation)
    {
        if (is_null($ignored_validation)) {
            throw new \InvalidArgumentException('non-nullable ignored_validation cannot be null');
        }
        $this->container['ignored_validation'] = $ignored_validation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


