<?php
/**
 * ProcessedOrderWeb
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ProcessedOrderWeb Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedOrderWeb implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedOrderWeb';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'c_shipping_address' => 'string',
        'd_received_date' => '\DateTime',
        'd_processed_on' => '\DateTime',
        'time_diff' => 'float',
        'f_postage_cost' => 'float',
        'f_total_charge' => 'float',
        'postage_cost_ex_tax' => 'float',
        'subtotal' => 'float',
        'f_tax' => 'float',
        'total_discount' => 'float',
        'profit_margin' => 'float',
        'country_tax_rate' => 'float',
        'n_order_id' => 'int',
        'n_status' => 'int',
        'c_currency' => 'string',
        'postal_tracking_number' => 'string',
        'c_country' => 'string',
        'source' => 'string',
        'postal_service_name' => 'string',
        'postal_service_code' => 'string',
        'vendor' => 'string',
        'billing_email_address' => 'string',
        'reference_num' => 'string',
        'secondary_reference' => 'string',
        'external_reference' => 'string',
        'address1' => 'string',
        'address2' => 'string',
        'address3' => 'string',
        'town' => 'string',
        'region' => 'string',
        'buyer_phone_number' => 'string',
        'company' => 'string',
        'sub_source' => 'string',
        'channel_buyer_name' => 'string',
        'account_name' => 'string',
        'c_full_name' => 'string',
        'c_email_address' => 'string',
        'c_post_code' => 'string',
        'd_paid_on' => '\DateTime',
        'd_cancelled_on' => '\DateTime',
        'package_category' => 'string',
        'package_title' => 'string',
        'item_weight' => 'float',
        'total_weight' => 'float',
        'folder_collection' => 'string',
        'c_billing_address' => 'string',
        'billing_name' => 'string',
        'billing_company' => 'string',
        'billing_address1' => 'string',
        'billing_address2' => 'string',
        'billing_address3' => 'string',
        'billing_town' => 'string',
        'billing_region' => 'string',
        'billing_post_code' => 'string',
        'billing_country_name' => 'string',
        'billing_phone_number' => 'string',
        'hold_or_cancel' => 'bool',
        'is_resend' => 'bool',
        'is_exchange' => 'bool',
        'tax_id' => 'string',
        'fulfilment_location_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'c_shipping_address' => null,
        'd_received_date' => 'date-time',
        'd_processed_on' => 'date-time',
        'time_diff' => 'double',
        'f_postage_cost' => 'double',
        'f_total_charge' => 'double',
        'postage_cost_ex_tax' => 'double',
        'subtotal' => 'double',
        'f_tax' => 'double',
        'total_discount' => 'double',
        'profit_margin' => 'double',
        'country_tax_rate' => 'double',
        'n_order_id' => 'int32',
        'n_status' => 'int32',
        'c_currency' => null,
        'postal_tracking_number' => null,
        'c_country' => null,
        'source' => null,
        'postal_service_name' => null,
        'postal_service_code' => null,
        'vendor' => null,
        'billing_email_address' => null,
        'reference_num' => null,
        'secondary_reference' => null,
        'external_reference' => null,
        'address1' => null,
        'address2' => null,
        'address3' => null,
        'town' => null,
        'region' => null,
        'buyer_phone_number' => null,
        'company' => null,
        'sub_source' => null,
        'channel_buyer_name' => null,
        'account_name' => null,
        'c_full_name' => null,
        'c_email_address' => null,
        'c_post_code' => null,
        'd_paid_on' => 'date-time',
        'd_cancelled_on' => 'date-time',
        'package_category' => null,
        'package_title' => null,
        'item_weight' => 'double',
        'total_weight' => 'double',
        'folder_collection' => null,
        'c_billing_address' => null,
        'billing_name' => null,
        'billing_company' => null,
        'billing_address1' => null,
        'billing_address2' => null,
        'billing_address3' => null,
        'billing_town' => null,
        'billing_region' => null,
        'billing_post_code' => null,
        'billing_country_name' => null,
        'billing_phone_number' => null,
        'hold_or_cancel' => null,
        'is_resend' => null,
        'is_exchange' => null,
        'tax_id' => null,
        'fulfilment_location_name' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'c_shipping_address' => false,
        'd_received_date' => false,
        'd_processed_on' => false,
        'time_diff' => false,
        'f_postage_cost' => false,
        'f_total_charge' => false,
        'postage_cost_ex_tax' => false,
        'subtotal' => false,
        'f_tax' => false,
        'total_discount' => false,
        'profit_margin' => false,
        'country_tax_rate' => false,
        'n_order_id' => false,
        'n_status' => false,
        'c_currency' => false,
        'postal_tracking_number' => false,
        'c_country' => false,
        'source' => false,
        'postal_service_name' => false,
        'postal_service_code' => false,
        'vendor' => false,
        'billing_email_address' => false,
        'reference_num' => false,
        'secondary_reference' => false,
        'external_reference' => false,
        'address1' => false,
        'address2' => false,
        'address3' => false,
        'town' => false,
        'region' => false,
        'buyer_phone_number' => false,
        'company' => false,
        'sub_source' => false,
        'channel_buyer_name' => false,
        'account_name' => false,
        'c_full_name' => false,
        'c_email_address' => false,
        'c_post_code' => false,
        'd_paid_on' => false,
        'd_cancelled_on' => false,
        'package_category' => false,
        'package_title' => false,
        'item_weight' => false,
        'total_weight' => false,
        'folder_collection' => false,
        'c_billing_address' => false,
        'billing_name' => false,
        'billing_company' => false,
        'billing_address1' => false,
        'billing_address2' => false,
        'billing_address3' => false,
        'billing_town' => false,
        'billing_region' => false,
        'billing_post_code' => false,
        'billing_country_name' => false,
        'billing_phone_number' => false,
        'hold_or_cancel' => false,
        'is_resend' => false,
        'is_exchange' => false,
        'tax_id' => false,
        'fulfilment_location_name' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderID',
        'c_shipping_address' => 'cShippingAddress',
        'd_received_date' => 'dReceivedDate',
        'd_processed_on' => 'dProcessedOn',
        'time_diff' => 'timeDiff',
        'f_postage_cost' => 'fPostageCost',
        'f_total_charge' => 'fTotalCharge',
        'postage_cost_ex_tax' => 'PostageCostExTax',
        'subtotal' => 'Subtotal',
        'f_tax' => 'fTax',
        'total_discount' => 'TotalDiscount',
        'profit_margin' => 'ProfitMargin',
        'country_tax_rate' => 'CountryTaxRate',
        'n_order_id' => 'nOrderId',
        'n_status' => 'nStatus',
        'c_currency' => 'cCurrency',
        'postal_tracking_number' => 'PostalTrackingNumber',
        'c_country' => 'cCountry',
        'source' => 'Source',
        'postal_service_name' => 'PostalServiceName',
        'postal_service_code' => 'PostalServiceCode',
        'vendor' => 'Vendor',
        'billing_email_address' => 'BillingEmailAddress',
        'reference_num' => 'ReferenceNum',
        'secondary_reference' => 'SecondaryReference',
        'external_reference' => 'ExternalReference',
        'address1' => 'Address1',
        'address2' => 'Address2',
        'address3' => 'Address3',
        'town' => 'Town',
        'region' => 'Region',
        'buyer_phone_number' => 'BuyerPhoneNumber',
        'company' => 'Company',
        'sub_source' => 'SubSource',
        'channel_buyer_name' => 'ChannelBuyerName',
        'account_name' => 'AccountName',
        'c_full_name' => 'cFullName',
        'c_email_address' => 'cEmailAddress',
        'c_post_code' => 'cPostCode',
        'd_paid_on' => 'dPaidOn',
        'd_cancelled_on' => 'dCancelledOn',
        'package_category' => 'PackageCategory',
        'package_title' => 'PackageTitle',
        'item_weight' => 'ItemWeight',
        'total_weight' => 'TotalWeight',
        'folder_collection' => 'FolderCollection',
        'c_billing_address' => 'cBillingAddress',
        'billing_name' => 'BillingName',
        'billing_company' => 'BillingCompany',
        'billing_address1' => 'BillingAddress1',
        'billing_address2' => 'BillingAddress2',
        'billing_address3' => 'BillingAddress3',
        'billing_town' => 'BillingTown',
        'billing_region' => 'BillingRegion',
        'billing_post_code' => 'BillingPostCode',
        'billing_country_name' => 'BillingCountryName',
        'billing_phone_number' => 'BillingPhoneNumber',
        'hold_or_cancel' => 'HoldOrCancel',
        'is_resend' => 'IsResend',
        'is_exchange' => 'IsExchange',
        'tax_id' => 'TaxId',
        'fulfilment_location_name' => 'FulfilmentLocationName'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'c_shipping_address' => 'setCShippingAddress',
        'd_received_date' => 'setDReceivedDate',
        'd_processed_on' => 'setDProcessedOn',
        'time_diff' => 'setTimeDiff',
        'f_postage_cost' => 'setFPostageCost',
        'f_total_charge' => 'setFTotalCharge',
        'postage_cost_ex_tax' => 'setPostageCostExTax',
        'subtotal' => 'setSubtotal',
        'f_tax' => 'setFTax',
        'total_discount' => 'setTotalDiscount',
        'profit_margin' => 'setProfitMargin',
        'country_tax_rate' => 'setCountryTaxRate',
        'n_order_id' => 'setNOrderId',
        'n_status' => 'setNStatus',
        'c_currency' => 'setCCurrency',
        'postal_tracking_number' => 'setPostalTrackingNumber',
        'c_country' => 'setCCountry',
        'source' => 'setSource',
        'postal_service_name' => 'setPostalServiceName',
        'postal_service_code' => 'setPostalServiceCode',
        'vendor' => 'setVendor',
        'billing_email_address' => 'setBillingEmailAddress',
        'reference_num' => 'setReferenceNum',
        'secondary_reference' => 'setSecondaryReference',
        'external_reference' => 'setExternalReference',
        'address1' => 'setAddress1',
        'address2' => 'setAddress2',
        'address3' => 'setAddress3',
        'town' => 'setTown',
        'region' => 'setRegion',
        'buyer_phone_number' => 'setBuyerPhoneNumber',
        'company' => 'setCompany',
        'sub_source' => 'setSubSource',
        'channel_buyer_name' => 'setChannelBuyerName',
        'account_name' => 'setAccountName',
        'c_full_name' => 'setCFullName',
        'c_email_address' => 'setCEmailAddress',
        'c_post_code' => 'setCPostCode',
        'd_paid_on' => 'setDPaidOn',
        'd_cancelled_on' => 'setDCancelledOn',
        'package_category' => 'setPackageCategory',
        'package_title' => 'setPackageTitle',
        'item_weight' => 'setItemWeight',
        'total_weight' => 'setTotalWeight',
        'folder_collection' => 'setFolderCollection',
        'c_billing_address' => 'setCBillingAddress',
        'billing_name' => 'setBillingName',
        'billing_company' => 'setBillingCompany',
        'billing_address1' => 'setBillingAddress1',
        'billing_address2' => 'setBillingAddress2',
        'billing_address3' => 'setBillingAddress3',
        'billing_town' => 'setBillingTown',
        'billing_region' => 'setBillingRegion',
        'billing_post_code' => 'setBillingPostCode',
        'billing_country_name' => 'setBillingCountryName',
        'billing_phone_number' => 'setBillingPhoneNumber',
        'hold_or_cancel' => 'setHoldOrCancel',
        'is_resend' => 'setIsResend',
        'is_exchange' => 'setIsExchange',
        'tax_id' => 'setTaxId',
        'fulfilment_location_name' => 'setFulfilmentLocationName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'c_shipping_address' => 'getCShippingAddress',
        'd_received_date' => 'getDReceivedDate',
        'd_processed_on' => 'getDProcessedOn',
        'time_diff' => 'getTimeDiff',
        'f_postage_cost' => 'getFPostageCost',
        'f_total_charge' => 'getFTotalCharge',
        'postage_cost_ex_tax' => 'getPostageCostExTax',
        'subtotal' => 'getSubtotal',
        'f_tax' => 'getFTax',
        'total_discount' => 'getTotalDiscount',
        'profit_margin' => 'getProfitMargin',
        'country_tax_rate' => 'getCountryTaxRate',
        'n_order_id' => 'getNOrderId',
        'n_status' => 'getNStatus',
        'c_currency' => 'getCCurrency',
        'postal_tracking_number' => 'getPostalTrackingNumber',
        'c_country' => 'getCCountry',
        'source' => 'getSource',
        'postal_service_name' => 'getPostalServiceName',
        'postal_service_code' => 'getPostalServiceCode',
        'vendor' => 'getVendor',
        'billing_email_address' => 'getBillingEmailAddress',
        'reference_num' => 'getReferenceNum',
        'secondary_reference' => 'getSecondaryReference',
        'external_reference' => 'getExternalReference',
        'address1' => 'getAddress1',
        'address2' => 'getAddress2',
        'address3' => 'getAddress3',
        'town' => 'getTown',
        'region' => 'getRegion',
        'buyer_phone_number' => 'getBuyerPhoneNumber',
        'company' => 'getCompany',
        'sub_source' => 'getSubSource',
        'channel_buyer_name' => 'getChannelBuyerName',
        'account_name' => 'getAccountName',
        'c_full_name' => 'getCFullName',
        'c_email_address' => 'getCEmailAddress',
        'c_post_code' => 'getCPostCode',
        'd_paid_on' => 'getDPaidOn',
        'd_cancelled_on' => 'getDCancelledOn',
        'package_category' => 'getPackageCategory',
        'package_title' => 'getPackageTitle',
        'item_weight' => 'getItemWeight',
        'total_weight' => 'getTotalWeight',
        'folder_collection' => 'getFolderCollection',
        'c_billing_address' => 'getCBillingAddress',
        'billing_name' => 'getBillingName',
        'billing_company' => 'getBillingCompany',
        'billing_address1' => 'getBillingAddress1',
        'billing_address2' => 'getBillingAddress2',
        'billing_address3' => 'getBillingAddress3',
        'billing_town' => 'getBillingTown',
        'billing_region' => 'getBillingRegion',
        'billing_post_code' => 'getBillingPostCode',
        'billing_country_name' => 'getBillingCountryName',
        'billing_phone_number' => 'getBillingPhoneNumber',
        'hold_or_cancel' => 'getHoldOrCancel',
        'is_resend' => 'getIsResend',
        'is_exchange' => 'getIsExchange',
        'tax_id' => 'getTaxId',
        'fulfilment_location_name' => 'getFulfilmentLocationName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('c_shipping_address', $data ?? [], null);
        $this->setIfExists('d_received_date', $data ?? [], null);
        $this->setIfExists('d_processed_on', $data ?? [], null);
        $this->setIfExists('time_diff', $data ?? [], null);
        $this->setIfExists('f_postage_cost', $data ?? [], null);
        $this->setIfExists('f_total_charge', $data ?? [], null);
        $this->setIfExists('postage_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('f_tax', $data ?? [], null);
        $this->setIfExists('total_discount', $data ?? [], null);
        $this->setIfExists('profit_margin', $data ?? [], null);
        $this->setIfExists('country_tax_rate', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('n_status', $data ?? [], null);
        $this->setIfExists('c_currency', $data ?? [], null);
        $this->setIfExists('postal_tracking_number', $data ?? [], null);
        $this->setIfExists('c_country', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('postal_service_code', $data ?? [], null);
        $this->setIfExists('vendor', $data ?? [], null);
        $this->setIfExists('billing_email_address', $data ?? [], null);
        $this->setIfExists('reference_num', $data ?? [], null);
        $this->setIfExists('secondary_reference', $data ?? [], null);
        $this->setIfExists('external_reference', $data ?? [], null);
        $this->setIfExists('address1', $data ?? [], null);
        $this->setIfExists('address2', $data ?? [], null);
        $this->setIfExists('address3', $data ?? [], null);
        $this->setIfExists('town', $data ?? [], null);
        $this->setIfExists('region', $data ?? [], null);
        $this->setIfExists('buyer_phone_number', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('channel_buyer_name', $data ?? [], null);
        $this->setIfExists('account_name', $data ?? [], null);
        $this->setIfExists('c_full_name', $data ?? [], null);
        $this->setIfExists('c_email_address', $data ?? [], null);
        $this->setIfExists('c_post_code', $data ?? [], null);
        $this->setIfExists('d_paid_on', $data ?? [], null);
        $this->setIfExists('d_cancelled_on', $data ?? [], null);
        $this->setIfExists('package_category', $data ?? [], null);
        $this->setIfExists('package_title', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('folder_collection', $data ?? [], null);
        $this->setIfExists('c_billing_address', $data ?? [], null);
        $this->setIfExists('billing_name', $data ?? [], null);
        $this->setIfExists('billing_company', $data ?? [], null);
        $this->setIfExists('billing_address1', $data ?? [], null);
        $this->setIfExists('billing_address2', $data ?? [], null);
        $this->setIfExists('billing_address3', $data ?? [], null);
        $this->setIfExists('billing_town', $data ?? [], null);
        $this->setIfExists('billing_region', $data ?? [], null);
        $this->setIfExists('billing_post_code', $data ?? [], null);
        $this->setIfExists('billing_country_name', $data ?? [], null);
        $this->setIfExists('billing_phone_number', $data ?? [], null);
        $this->setIfExists('hold_or_cancel', $data ?? [], null);
        $this->setIfExists('is_resend', $data ?? [], null);
        $this->setIfExists('is_exchange', $data ?? [], null);
        $this->setIfExists('tax_id', $data ?? [], null);
        $this->setIfExists('fulfilment_location_name', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order ID
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets c_shipping_address
     *
     * @return string|null
     */
    public function getCShippingAddress()
    {
        return $this->container['c_shipping_address'];
    }

    /**
     * Sets c_shipping_address
     *
     * @param string|null $c_shipping_address Customer's shipping address
     *
     * @return self
     */
    public function setCShippingAddress($c_shipping_address)
    {
        if (is_null($c_shipping_address)) {
            throw new \InvalidArgumentException('non-nullable c_shipping_address cannot be null');
        }
        $this->container['c_shipping_address'] = $c_shipping_address;

        return $this;
    }

    /**
     * Gets d_received_date
     *
     * @return \DateTime|null
     */
    public function getDReceivedDate()
    {
        return $this->container['d_received_date'];
    }

    /**
     * Sets d_received_date
     *
     * @param \DateTime|null $d_received_date Date when order was received on a channel
     *
     * @return self
     */
    public function setDReceivedDate($d_received_date)
    {
        if (is_null($d_received_date)) {
            throw new \InvalidArgumentException('non-nullable d_received_date cannot be null');
        }
        $this->container['d_received_date'] = $d_received_date;

        return $this;
    }

    /**
     * Gets d_processed_on
     *
     * @return \DateTime|null
     */
    public function getDProcessedOn()
    {
        return $this->container['d_processed_on'];
    }

    /**
     * Sets d_processed_on
     *
     * @param \DateTime|null $d_processed_on Date when order was processed
     *
     * @return self
     */
    public function setDProcessedOn($d_processed_on)
    {
        if (is_null($d_processed_on)) {
            throw new \InvalidArgumentException('non-nullable d_processed_on cannot be null');
        }
        $this->container['d_processed_on'] = $d_processed_on;

        return $this;
    }

    /**
     * Gets time_diff
     *
     * @return float|null
     */
    public function getTimeDiff()
    {
        return $this->container['time_diff'];
    }

    /**
     * Sets time_diff
     *
     * @param float|null $time_diff Days elapsed between order received and order processed
     *
     * @return self
     */
    public function setTimeDiff($time_diff)
    {
        if (is_null($time_diff)) {
            throw new \InvalidArgumentException('non-nullable time_diff cannot be null');
        }
        $this->container['time_diff'] = $time_diff;

        return $this;
    }

    /**
     * Gets f_postage_cost
     *
     * @return float|null
     */
    public function getFPostageCost()
    {
        return $this->container['f_postage_cost'];
    }

    /**
     * Sets f_postage_cost
     *
     * @param float|null $f_postage_cost Order postage cost
     *
     * @return self
     */
    public function setFPostageCost($f_postage_cost)
    {
        if (is_null($f_postage_cost)) {
            throw new \InvalidArgumentException('non-nullable f_postage_cost cannot be null');
        }
        $this->container['f_postage_cost'] = $f_postage_cost;

        return $this;
    }

    /**
     * Gets f_total_charge
     *
     * @return float|null
     */
    public function getFTotalCharge()
    {
        return $this->container['f_total_charge'];
    }

    /**
     * Sets f_total_charge
     *
     * @param float|null $f_total_charge Order total charge
     *
     * @return self
     */
    public function setFTotalCharge($f_total_charge)
    {
        if (is_null($f_total_charge)) {
            throw new \InvalidArgumentException('non-nullable f_total_charge cannot be null');
        }
        $this->container['f_total_charge'] = $f_total_charge;

        return $this;
    }

    /**
     * Gets postage_cost_ex_tax
     *
     * @return float|null
     */
    public function getPostageCostExTax()
    {
        return $this->container['postage_cost_ex_tax'];
    }

    /**
     * Sets postage_cost_ex_tax
     *
     * @param float|null $postage_cost_ex_tax Postage cost excluding tax
     *
     * @return self
     */
    public function setPostageCostExTax($postage_cost_ex_tax)
    {
        if (is_null($postage_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable postage_cost_ex_tax cannot be null');
        }
        $this->container['postage_cost_ex_tax'] = $postage_cost_ex_tax;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return float|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param float|null $subtotal Order subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets f_tax
     *
     * @return float|null
     */
    public function getFTax()
    {
        return $this->container['f_tax'];
    }

    /**
     * Sets f_tax
     *
     * @param float|null $f_tax Order tax
     *
     * @return self
     */
    public function setFTax($f_tax)
    {
        if (is_null($f_tax)) {
            throw new \InvalidArgumentException('non-nullable f_tax cannot be null');
        }
        $this->container['f_tax'] = $f_tax;

        return $this;
    }

    /**
     * Gets total_discount
     *
     * @return float|null
     */
    public function getTotalDiscount()
    {
        return $this->container['total_discount'];
    }

    /**
     * Sets total_discount
     *
     * @param float|null $total_discount Total discount
     *
     * @return self
     */
    public function setTotalDiscount($total_discount)
    {
        if (is_null($total_discount)) {
            throw new \InvalidArgumentException('non-nullable total_discount cannot be null');
        }
        $this->container['total_discount'] = $total_discount;

        return $this;
    }

    /**
     * Gets profit_margin
     *
     * @return float|null
     */
    public function getProfitMargin()
    {
        return $this->container['profit_margin'];
    }

    /**
     * Sets profit_margin
     *
     * @param float|null $profit_margin Profit margin
     *
     * @return self
     */
    public function setProfitMargin($profit_margin)
    {
        if (is_null($profit_margin)) {
            throw new \InvalidArgumentException('non-nullable profit_margin cannot be null');
        }
        $this->container['profit_margin'] = $profit_margin;

        return $this;
    }

    /**
     * Gets country_tax_rate
     *
     * @return float|null
     */
    public function getCountryTaxRate()
    {
        return $this->container['country_tax_rate'];
    }

    /**
     * Sets country_tax_rate
     *
     * @param float|null $country_tax_rate Country specific tax rate
     *
     * @return self
     */
    public function setCountryTaxRate($country_tax_rate)
    {
        if (is_null($country_tax_rate)) {
            throw new \InvalidArgumentException('non-nullable country_tax_rate cannot be null');
        }
        $this->container['country_tax_rate'] = $country_tax_rate;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Linnworks order ID
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets n_status
     *
     * @return int|null
     */
    public function getNStatus()
    {
        return $this->container['n_status'];
    }

    /**
     * Sets n_status
     *
     * @param int|null $n_status Order status
     *
     * @return self
     */
    public function setNStatus($n_status)
    {
        if (is_null($n_status)) {
            throw new \InvalidArgumentException('non-nullable n_status cannot be null');
        }
        $this->container['n_status'] = $n_status;

        return $this;
    }

    /**
     * Gets c_currency
     *
     * @return string|null
     */
    public function getCCurrency()
    {
        return $this->container['c_currency'];
    }

    /**
     * Sets c_currency
     *
     * @param string|null $c_currency Order currency
     *
     * @return self
     */
    public function setCCurrency($c_currency)
    {
        if (is_null($c_currency)) {
            throw new \InvalidArgumentException('non-nullable c_currency cannot be null');
        }
        $this->container['c_currency'] = $c_currency;

        return $this;
    }

    /**
     * Gets postal_tracking_number
     *
     * @return string|null
     */
    public function getPostalTrackingNumber()
    {
        return $this->container['postal_tracking_number'];
    }

    /**
     * Sets postal_tracking_number
     *
     * @param string|null $postal_tracking_number Postal tracking number
     *
     * @return self
     */
    public function setPostalTrackingNumber($postal_tracking_number)
    {
        if (is_null($postal_tracking_number)) {
            throw new \InvalidArgumentException('non-nullable postal_tracking_number cannot be null');
        }
        $this->container['postal_tracking_number'] = $postal_tracking_number;

        return $this;
    }

    /**
     * Gets c_country
     *
     * @return string|null
     */
    public function getCCountry()
    {
        return $this->container['c_country'];
    }

    /**
     * Sets c_country
     *
     * @param string|null $c_country Country
     *
     * @return self
     */
    public function setCCountry($c_country)
    {
        if (is_null($c_country)) {
            throw new \InvalidArgumentException('non-nullable c_country cannot be null');
        }
        $this->container['c_country'] = $c_country;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name Postal service name (e.g. Next day delivery)
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets postal_service_code
     *
     * @return string|null
     */
    public function getPostalServiceCode()
    {
        return $this->container['postal_service_code'];
    }

    /**
     * Sets postal_service_code
     *
     * @param string|null $postal_service_code Postal service code
     *
     * @return self
     */
    public function setPostalServiceCode($postal_service_code)
    {
        if (is_null($postal_service_code)) {
            throw new \InvalidArgumentException('non-nullable postal_service_code cannot be null');
        }
        $this->container['postal_service_code'] = $postal_service_code;

        return $this;
    }

    /**
     * Gets vendor
     *
     * @return string|null
     */
    public function getVendor()
    {
        return $this->container['vendor'];
    }

    /**
     * Sets vendor
     *
     * @param string|null $vendor Courier name (e.g. DPD)
     *
     * @return self
     */
    public function setVendor($vendor)
    {
        if (is_null($vendor)) {
            throw new \InvalidArgumentException('non-nullable vendor cannot be null');
        }
        $this->container['vendor'] = $vendor;

        return $this;
    }

    /**
     * Gets billing_email_address
     *
     * @return string|null
     */
    public function getBillingEmailAddress()
    {
        return $this->container['billing_email_address'];
    }

    /**
     * Sets billing_email_address
     *
     * @param string|null $billing_email_address billing_email_address
     *
     * @return self
     */
    public function setBillingEmailAddress($billing_email_address)
    {
        if (is_null($billing_email_address)) {
            throw new \InvalidArgumentException('non-nullable billing_email_address cannot be null');
        }
        $this->container['billing_email_address'] = $billing_email_address;

        return $this;
    }

    /**
     * Gets reference_num
     *
     * @return string|null
     */
    public function getReferenceNum()
    {
        return $this->container['reference_num'];
    }

    /**
     * Sets reference_num
     *
     * @param string|null $reference_num Order reference number
     *
     * @return self
     */
    public function setReferenceNum($reference_num)
    {
        if (is_null($reference_num)) {
            throw new \InvalidArgumentException('non-nullable reference_num cannot be null');
        }
        $this->container['reference_num'] = $reference_num;

        return $this;
    }

    /**
     * Gets secondary_reference
     *
     * @return string|null
     */
    public function getSecondaryReference()
    {
        return $this->container['secondary_reference'];
    }

    /**
     * Sets secondary_reference
     *
     * @param string|null $secondary_reference An additional reference number for the order
     *
     * @return self
     */
    public function setSecondaryReference($secondary_reference)
    {
        if (is_null($secondary_reference)) {
            throw new \InvalidArgumentException('non-nullable secondary_reference cannot be null');
        }
        $this->container['secondary_reference'] = $secondary_reference;

        return $this;
    }

    /**
     * Gets external_reference
     *
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->container['external_reference'];
    }

    /**
     * Sets external_reference
     *
     * @param string|null $external_reference This is an additional reference number from the sales channel, typically used by eBay
     *
     * @return self
     */
    public function setExternalReference($external_reference)
    {
        if (is_null($external_reference)) {
            throw new \InvalidArgumentException('non-nullable external_reference cannot be null');
        }
        $this->container['external_reference'] = $external_reference;

        return $this;
    }

    /**
     * Gets address1
     *
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->container['address1'];
    }

    /**
     * Sets address1
     *
     * @param string|null $address1 Order first line of address
     *
     * @return self
     */
    public function setAddress1($address1)
    {
        if (is_null($address1)) {
            throw new \InvalidArgumentException('non-nullable address1 cannot be null');
        }
        $this->container['address1'] = $address1;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string|null $address2 Order second line of address
     *
     * @return self
     */
    public function setAddress2($address2)
    {
        if (is_null($address2)) {
            throw new \InvalidArgumentException('non-nullable address2 cannot be null');
        }
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets address3
     *
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->container['address3'];
    }

    /**
     * Sets address3
     *
     * @param string|null $address3 Order third line of address
     *
     * @return self
     */
    public function setAddress3($address3)
    {
        if (is_null($address3)) {
            throw new \InvalidArgumentException('non-nullable address3 cannot be null');
        }
        $this->container['address3'] = $address3;

        return $this;
    }

    /**
     * Gets town
     *
     * @return string|null
     */
    public function getTown()
    {
        return $this->container['town'];
    }

    /**
     * Sets town
     *
     * @param string|null $town Town
     *
     * @return self
     */
    public function setTown($town)
    {
        if (is_null($town)) {
            throw new \InvalidArgumentException('non-nullable town cannot be null');
        }
        $this->container['town'] = $town;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region Region, county, area
     *
     * @return self
     */
    public function setRegion($region)
    {
        if (is_null($region)) {
            throw new \InvalidArgumentException('non-nullable region cannot be null');
        }
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets buyer_phone_number
     *
     * @return string|null
     */
    public function getBuyerPhoneNumber()
    {
        return $this->container['buyer_phone_number'];
    }

    /**
     * Sets buyer_phone_number
     *
     * @param string|null $buyer_phone_number Buyer phone number
     *
     * @return self
     */
    public function setBuyerPhoneNumber($buyer_phone_number)
    {
        if (is_null($buyer_phone_number)) {
            throw new \InvalidArgumentException('non-nullable buyer_phone_number cannot be null');
        }
        $this->container['buyer_phone_number'] = $buyer_phone_number;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company Company
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source Order subsource (e.g. EBAY1)
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets channel_buyer_name
     *
     * @return string|null
     */
    public function getChannelBuyerName()
    {
        return $this->container['channel_buyer_name'];
    }

    /**
     * Sets channel_buyer_name
     *
     * @param string|null $channel_buyer_name Channel specific name used to identify the buyer, such as a username, normally used for eBay
     *
     * @return self
     */
    public function setChannelBuyerName($channel_buyer_name)
    {
        if (is_null($channel_buyer_name)) {
            throw new \InvalidArgumentException('non-nullable channel_buyer_name cannot be null');
        }
        $this->container['channel_buyer_name'] = $channel_buyer_name;

        return $this;
    }

    /**
     * Gets account_name
     *
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     *
     * @param string|null $account_name Customer channel account name
     *
     * @return self
     */
    public function setAccountName($account_name)
    {
        if (is_null($account_name)) {
            throw new \InvalidArgumentException('non-nullable account_name cannot be null');
        }
        $this->container['account_name'] = $account_name;

        return $this;
    }

    /**
     * Gets c_full_name
     *
     * @return string|null
     */
    public function getCFullName()
    {
        return $this->container['c_full_name'];
    }

    /**
     * Sets c_full_name
     *
     * @param string|null $c_full_name Customer full name
     *
     * @return self
     */
    public function setCFullName($c_full_name)
    {
        if (is_null($c_full_name)) {
            throw new \InvalidArgumentException('non-nullable c_full_name cannot be null');
        }
        $this->container['c_full_name'] = $c_full_name;

        return $this;
    }

    /**
     * Gets c_email_address
     *
     * @return string|null
     */
    public function getCEmailAddress()
    {
        return $this->container['c_email_address'];
    }

    /**
     * Sets c_email_address
     *
     * @param string|null $c_email_address Customer email address
     *
     * @return self
     */
    public function setCEmailAddress($c_email_address)
    {
        if (is_null($c_email_address)) {
            throw new \InvalidArgumentException('non-nullable c_email_address cannot be null');
        }
        $this->container['c_email_address'] = $c_email_address;

        return $this;
    }

    /**
     * Gets c_post_code
     *
     * @return string|null
     */
    public function getCPostCode()
    {
        return $this->container['c_post_code'];
    }

    /**
     * Sets c_post_code
     *
     * @param string|null $c_post_code Post Code
     *
     * @return self
     */
    public function setCPostCode($c_post_code)
    {
        if (is_null($c_post_code)) {
            throw new \InvalidArgumentException('non-nullable c_post_code cannot be null');
        }
        $this->container['c_post_code'] = $c_post_code;

        return $this;
    }

    /**
     * Gets d_paid_on
     *
     * @return \DateTime|null
     */
    public function getDPaidOn()
    {
        return $this->container['d_paid_on'];
    }

    /**
     * Sets d_paid_on
     *
     * @param \DateTime|null $d_paid_on When order was marked as PAID
     *
     * @return self
     */
    public function setDPaidOn($d_paid_on)
    {
        if (is_null($d_paid_on)) {
            throw new \InvalidArgumentException('non-nullable d_paid_on cannot be null');
        }
        $this->container['d_paid_on'] = $d_paid_on;

        return $this;
    }

    /**
     * Gets d_cancelled_on
     *
     * @return \DateTime|null
     */
    public function getDCancelledOn()
    {
        return $this->container['d_cancelled_on'];
    }

    /**
     * Sets d_cancelled_on
     *
     * @param \DateTime|null $d_cancelled_on When order was cancelled
     *
     * @return self
     */
    public function setDCancelledOn($d_cancelled_on)
    {
        if (is_null($d_cancelled_on)) {
            throw new \InvalidArgumentException('non-nullable d_cancelled_on cannot be null');
        }
        $this->container['d_cancelled_on'] = $d_cancelled_on;

        return $this;
    }

    /**
     * Gets package_category
     *
     * @return string|null
     */
    public function getPackageCategory()
    {
        return $this->container['package_category'];
    }

    /**
     * Sets package_category
     *
     * @param string|null $package_category Package category
     *
     * @return self
     */
    public function setPackageCategory($package_category)
    {
        if (is_null($package_category)) {
            throw new \InvalidArgumentException('non-nullable package_category cannot be null');
        }
        $this->container['package_category'] = $package_category;

        return $this;
    }

    /**
     * Gets package_title
     *
     * @return string|null
     */
    public function getPackageTitle()
    {
        return $this->container['package_title'];
    }

    /**
     * Sets package_title
     *
     * @param string|null $package_title Package name
     *
     * @return self
     */
    public function setPackageTitle($package_title)
    {
        if (is_null($package_title)) {
            throw new \InvalidArgumentException('non-nullable package_title cannot be null');
        }
        $this->container['package_title'] = $package_title;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight Items weight
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Total order weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets folder_collection
     *
     * @return string|null
     */
    public function getFolderCollection()
    {
        return $this->container['folder_collection'];
    }

    /**
     * Sets folder_collection
     *
     * @param string|null $folder_collection Folder name of an order
     *
     * @return self
     */
    public function setFolderCollection($folder_collection)
    {
        if (is_null($folder_collection)) {
            throw new \InvalidArgumentException('non-nullable folder_collection cannot be null');
        }
        $this->container['folder_collection'] = $folder_collection;

        return $this;
    }

    /**
     * Gets c_billing_address
     *
     * @return string|null
     */
    public function getCBillingAddress()
    {
        return $this->container['c_billing_address'];
    }

    /**
     * Sets c_billing_address
     *
     * @param string|null $c_billing_address Customer billing address
     *
     * @return self
     */
    public function setCBillingAddress($c_billing_address)
    {
        if (is_null($c_billing_address)) {
            throw new \InvalidArgumentException('non-nullable c_billing_address cannot be null');
        }
        $this->container['c_billing_address'] = $c_billing_address;

        return $this;
    }

    /**
     * Gets billing_name
     *
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->container['billing_name'];
    }

    /**
     * Sets billing_name
     *
     * @param string|null $billing_name Customer billing name
     *
     * @return self
     */
    public function setBillingName($billing_name)
    {
        if (is_null($billing_name)) {
            throw new \InvalidArgumentException('non-nullable billing_name cannot be null');
        }
        $this->container['billing_name'] = $billing_name;

        return $this;
    }

    /**
     * Gets billing_company
     *
     * @return string|null
     */
    public function getBillingCompany()
    {
        return $this->container['billing_company'];
    }

    /**
     * Sets billing_company
     *
     * @param string|null $billing_company Customer billing company
     *
     * @return self
     */
    public function setBillingCompany($billing_company)
    {
        if (is_null($billing_company)) {
            throw new \InvalidArgumentException('non-nullable billing_company cannot be null');
        }
        $this->container['billing_company'] = $billing_company;

        return $this;
    }

    /**
     * Gets billing_address1
     *
     * @return string|null
     */
    public function getBillingAddress1()
    {
        return $this->container['billing_address1'];
    }

    /**
     * Sets billing_address1
     *
     * @param string|null $billing_address1 Billing address line one
     *
     * @return self
     */
    public function setBillingAddress1($billing_address1)
    {
        if (is_null($billing_address1)) {
            throw new \InvalidArgumentException('non-nullable billing_address1 cannot be null');
        }
        $this->container['billing_address1'] = $billing_address1;

        return $this;
    }

    /**
     * Gets billing_address2
     *
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->container['billing_address2'];
    }

    /**
     * Sets billing_address2
     *
     * @param string|null $billing_address2 Billing address line two
     *
     * @return self
     */
    public function setBillingAddress2($billing_address2)
    {
        if (is_null($billing_address2)) {
            throw new \InvalidArgumentException('non-nullable billing_address2 cannot be null');
        }
        $this->container['billing_address2'] = $billing_address2;

        return $this;
    }

    /**
     * Gets billing_address3
     *
     * @return string|null
     */
    public function getBillingAddress3()
    {
        return $this->container['billing_address3'];
    }

    /**
     * Sets billing_address3
     *
     * @param string|null $billing_address3 Billing address line three
     *
     * @return self
     */
    public function setBillingAddress3($billing_address3)
    {
        if (is_null($billing_address3)) {
            throw new \InvalidArgumentException('non-nullable billing_address3 cannot be null');
        }
        $this->container['billing_address3'] = $billing_address3;

        return $this;
    }

    /**
     * Gets billing_town
     *
     * @return string|null
     */
    public function getBillingTown()
    {
        return $this->container['billing_town'];
    }

    /**
     * Sets billing_town
     *
     * @param string|null $billing_town Billing town
     *
     * @return self
     */
    public function setBillingTown($billing_town)
    {
        if (is_null($billing_town)) {
            throw new \InvalidArgumentException('non-nullable billing_town cannot be null');
        }
        $this->container['billing_town'] = $billing_town;

        return $this;
    }

    /**
     * Gets billing_region
     *
     * @return string|null
     */
    public function getBillingRegion()
    {
        return $this->container['billing_region'];
    }

    /**
     * Sets billing_region
     *
     * @param string|null $billing_region Billing region, area, county
     *
     * @return self
     */
    public function setBillingRegion($billing_region)
    {
        if (is_null($billing_region)) {
            throw new \InvalidArgumentException('non-nullable billing_region cannot be null');
        }
        $this->container['billing_region'] = $billing_region;

        return $this;
    }

    /**
     * Gets billing_post_code
     *
     * @return string|null
     */
    public function getBillingPostCode()
    {
        return $this->container['billing_post_code'];
    }

    /**
     * Sets billing_post_code
     *
     * @param string|null $billing_post_code Billing postcode
     *
     * @return self
     */
    public function setBillingPostCode($billing_post_code)
    {
        if (is_null($billing_post_code)) {
            throw new \InvalidArgumentException('non-nullable billing_post_code cannot be null');
        }
        $this->container['billing_post_code'] = $billing_post_code;

        return $this;
    }

    /**
     * Gets billing_country_name
     *
     * @return string|null
     */
    public function getBillingCountryName()
    {
        return $this->container['billing_country_name'];
    }

    /**
     * Sets billing_country_name
     *
     * @param string|null $billing_country_name Billing country
     *
     * @return self
     */
    public function setBillingCountryName($billing_country_name)
    {
        if (is_null($billing_country_name)) {
            throw new \InvalidArgumentException('non-nullable billing_country_name cannot be null');
        }
        $this->container['billing_country_name'] = $billing_country_name;

        return $this;
    }

    /**
     * Gets billing_phone_number
     *
     * @return string|null
     */
    public function getBillingPhoneNumber()
    {
        return $this->container['billing_phone_number'];
    }

    /**
     * Sets billing_phone_number
     *
     * @param string|null $billing_phone_number Billing phone number
     *
     * @return self
     */
    public function setBillingPhoneNumber($billing_phone_number)
    {
        if (is_null($billing_phone_number)) {
            throw new \InvalidArgumentException('non-nullable billing_phone_number cannot be null');
        }
        $this->container['billing_phone_number'] = $billing_phone_number;

        return $this;
    }

    /**
     * Gets hold_or_cancel
     *
     * @return bool|null
     */
    public function getHoldOrCancel()
    {
        return $this->container['hold_or_cancel'];
    }

    /**
     * Sets hold_or_cancel
     *
     * @param bool|null $hold_or_cancel If order on hold or cancelled.
     *
     * @return self
     */
    public function setHoldOrCancel($hold_or_cancel)
    {
        if (is_null($hold_or_cancel)) {
            throw new \InvalidArgumentException('non-nullable hold_or_cancel cannot be null');
        }
        $this->container['hold_or_cancel'] = $hold_or_cancel;

        return $this;
    }

    /**
     * Gets is_resend
     *
     * @return bool|null
     */
    public function getIsResend()
    {
        return $this->container['is_resend'];
    }

    /**
     * Sets is_resend
     *
     * @param bool|null $is_resend If order was created from a resend
     *
     * @return self
     */
    public function setIsResend($is_resend)
    {
        if (is_null($is_resend)) {
            throw new \InvalidArgumentException('non-nullable is_resend cannot be null');
        }
        $this->container['is_resend'] = $is_resend;

        return $this;
    }

    /**
     * Gets is_exchange
     *
     * @return bool|null
     */
    public function getIsExchange()
    {
        return $this->container['is_exchange'];
    }

    /**
     * Sets is_exchange
     *
     * @param bool|null $is_exchange If order was created from an exchange
     *
     * @return self
     */
    public function setIsExchange($is_exchange)
    {
        if (is_null($is_exchange)) {
            throw new \InvalidArgumentException('non-nullable is_exchange cannot be null');
        }
        $this->container['is_exchange'] = $is_exchange;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id Order tax id
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        if (is_null($tax_id)) {
            throw new \InvalidArgumentException('non-nullable tax_id cannot be null');
        }
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets fulfilment_location_name
     *
     * @return string|null
     */
    public function getFulfilmentLocationName()
    {
        return $this->container['fulfilment_location_name'];
    }

    /**
     * Sets fulfilment_location_name
     *
     * @param string|null $fulfilment_location_name Order fulfilment location
     *
     * @return self
     */
    public function setFulfilmentLocationName($fulfilment_location_name)
    {
        if (is_null($fulfilment_location_name)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_location_name cannot be null');
        }
        $this->container['fulfilment_location_name'] = $fulfilment_location_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


