<?php
/**
 * OrderItemReturnInfoBatched
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * OrderItemReturnInfoBatched Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderItemReturnInfoBatched implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderItemReturnInfoBatched';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_batch_id' => 'int',
        'batch_inventory_id' => 'int',
        'batch_number' => 'string',
        'despatch_unit_value' => 'float',
        'order_id' => 'string',
        'fk_order_item_row_id' => 'string',
        'parent_row_id' => 'string',
        'returnable_qty' => 'int',
        'order_qty' => 'int',
        'returned_qty' => 'int',
        'sku' => 'string',
        'item_title' => 'string',
        'unit_value' => 'float',
        'tax_rate' => 'float',
        'tax_cost_inclusive' => 'bool',
        'currency' => 'string',
        'is_composite_parent' => 'bool',
        'is_partial_composite_return' => 'bool',
        'parent_ratio' => 'int',
        'pk_stock_item_id' => 'string',
        'resent_qty' => 'int',
        'fk_refund_row_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_batch_id' => 'int32',
        'batch_inventory_id' => 'int32',
        'batch_number' => null,
        'despatch_unit_value' => 'double',
        'order_id' => 'uuid',
        'fk_order_item_row_id' => 'uuid',
        'parent_row_id' => 'uuid',
        'returnable_qty' => 'int32',
        'order_qty' => 'int32',
        'returned_qty' => 'int32',
        'sku' => null,
        'item_title' => null,
        'unit_value' => 'double',
        'tax_rate' => 'double',
        'tax_cost_inclusive' => null,
        'currency' => null,
        'is_composite_parent' => null,
        'is_partial_composite_return' => null,
        'parent_ratio' => 'int32',
        'pk_stock_item_id' => 'uuid',
        'resent_qty' => 'int32',
        'fk_refund_row_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_item_batch_id' => false,
        'batch_inventory_id' => false,
        'batch_number' => false,
        'despatch_unit_value' => false,
        'order_id' => false,
        'fk_order_item_row_id' => false,
        'parent_row_id' => false,
        'returnable_qty' => false,
        'order_qty' => false,
        'returned_qty' => false,
        'sku' => false,
        'item_title' => false,
        'unit_value' => false,
        'tax_rate' => false,
        'tax_cost_inclusive' => false,
        'currency' => false,
        'is_composite_parent' => false,
        'is_partial_composite_return' => false,
        'parent_ratio' => false,
        'pk_stock_item_id' => false,
        'resent_qty' => false,
        'fk_refund_row_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_batch_id' => 'OrderItemBatchId',
        'batch_inventory_id' => 'BatchInventoryId',
        'batch_number' => 'BatchNumber',
        'despatch_unit_value' => 'DespatchUnitValue',
        'order_id' => 'OrderId',
        'fk_order_item_row_id' => 'fkOrderItemRowId',
        'parent_row_id' => 'ParentRowId',
        'returnable_qty' => 'ReturnableQty',
        'order_qty' => 'OrderQty',
        'returned_qty' => 'ReturnedQty',
        'sku' => 'SKU',
        'item_title' => 'ItemTitle',
        'unit_value' => 'UnitValue',
        'tax_rate' => 'TaxRate',
        'tax_cost_inclusive' => 'TaxCostInclusive',
        'currency' => 'Currency',
        'is_composite_parent' => 'IsCompositeParent',
        'is_partial_composite_return' => 'IsPartialCompositeReturn',
        'parent_ratio' => 'ParentRatio',
        'pk_stock_item_id' => 'pkStockItemId',
        'resent_qty' => 'ResentQty',
        'fk_refund_row_id' => 'fkRefundRowId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_batch_id' => 'setOrderItemBatchId',
        'batch_inventory_id' => 'setBatchInventoryId',
        'batch_number' => 'setBatchNumber',
        'despatch_unit_value' => 'setDespatchUnitValue',
        'order_id' => 'setOrderId',
        'fk_order_item_row_id' => 'setFkOrderItemRowId',
        'parent_row_id' => 'setParentRowId',
        'returnable_qty' => 'setReturnableQty',
        'order_qty' => 'setOrderQty',
        'returned_qty' => 'setReturnedQty',
        'sku' => 'setSku',
        'item_title' => 'setItemTitle',
        'unit_value' => 'setUnitValue',
        'tax_rate' => 'setTaxRate',
        'tax_cost_inclusive' => 'setTaxCostInclusive',
        'currency' => 'setCurrency',
        'is_composite_parent' => 'setIsCompositeParent',
        'is_partial_composite_return' => 'setIsPartialCompositeReturn',
        'parent_ratio' => 'setParentRatio',
        'pk_stock_item_id' => 'setPkStockItemId',
        'resent_qty' => 'setResentQty',
        'fk_refund_row_id' => 'setFkRefundRowId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_batch_id' => 'getOrderItemBatchId',
        'batch_inventory_id' => 'getBatchInventoryId',
        'batch_number' => 'getBatchNumber',
        'despatch_unit_value' => 'getDespatchUnitValue',
        'order_id' => 'getOrderId',
        'fk_order_item_row_id' => 'getFkOrderItemRowId',
        'parent_row_id' => 'getParentRowId',
        'returnable_qty' => 'getReturnableQty',
        'order_qty' => 'getOrderQty',
        'returned_qty' => 'getReturnedQty',
        'sku' => 'getSku',
        'item_title' => 'getItemTitle',
        'unit_value' => 'getUnitValue',
        'tax_rate' => 'getTaxRate',
        'tax_cost_inclusive' => 'getTaxCostInclusive',
        'currency' => 'getCurrency',
        'is_composite_parent' => 'getIsCompositeParent',
        'is_partial_composite_return' => 'getIsPartialCompositeReturn',
        'parent_ratio' => 'getParentRatio',
        'pk_stock_item_id' => 'getPkStockItemId',
        'resent_qty' => 'getResentQty',
        'fk_refund_row_id' => 'getFkRefundRowId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_item_batch_id', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('batch_number', $data ?? [], null);
        $this->setIfExists('despatch_unit_value', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('fk_order_item_row_id', $data ?? [], null);
        $this->setIfExists('parent_row_id', $data ?? [], null);
        $this->setIfExists('returnable_qty', $data ?? [], null);
        $this->setIfExists('order_qty', $data ?? [], null);
        $this->setIfExists('returned_qty', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('unit_value', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('tax_cost_inclusive', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('is_composite_parent', $data ?? [], null);
        $this->setIfExists('is_partial_composite_return', $data ?? [], null);
        $this->setIfExists('parent_ratio', $data ?? [], null);
        $this->setIfExists('pk_stock_item_id', $data ?? [], null);
        $this->setIfExists('resent_qty', $data ?? [], null);
        $this->setIfExists('fk_refund_row_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_item_batch_id
     *
     * @return int|null
     */
    public function getOrderItemBatchId()
    {
        return $this->container['order_item_batch_id'];
    }

    /**
     * Sets order_item_batch_id
     *
     * @param int|null $order_item_batch_id order_item_batch_id
     *
     * @return self
     */
    public function setOrderItemBatchId($order_item_batch_id)
    {
        if (is_null($order_item_batch_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_batch_id cannot be null');
        }
        $this->container['order_item_batch_id'] = $order_item_batch_id;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id batch_inventory_id
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets batch_number
     *
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->container['batch_number'];
    }

    /**
     * Sets batch_number
     *
     * @param string|null $batch_number batch_number
     *
     * @return self
     */
    public function setBatchNumber($batch_number)
    {
        if (is_null($batch_number)) {
            throw new \InvalidArgumentException('non-nullable batch_number cannot be null');
        }
        $this->container['batch_number'] = $batch_number;

        return $this;
    }

    /**
     * Gets despatch_unit_value
     *
     * @return float|null
     */
    public function getDespatchUnitValue()
    {
        return $this->container['despatch_unit_value'];
    }

    /**
     * Sets despatch_unit_value
     *
     * @param float|null $despatch_unit_value despatch_unit_value
     *
     * @return self
     */
    public function setDespatchUnitValue($despatch_unit_value)
    {
        if (is_null($despatch_unit_value)) {
            throw new \InvalidArgumentException('non-nullable despatch_unit_value cannot be null');
        }
        $this->container['despatch_unit_value'] = $despatch_unit_value;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Order Id [Guid]
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets fk_order_item_row_id
     *
     * @return string|null
     */
    public function getFkOrderItemRowId()
    {
        return $this->container['fk_order_item_row_id'];
    }

    /**
     * Sets fk_order_item_row_id
     *
     * @param string|null $fk_order_item_row_id Order item record row ID
     *
     * @return self
     */
    public function setFkOrderItemRowId($fk_order_item_row_id)
    {
        if (is_null($fk_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_row_id cannot be null');
        }
        $this->container['fk_order_item_row_id'] = $fk_order_item_row_id;

        return $this;
    }

    /**
     * Gets parent_row_id
     *
     * @return string|null
     */
    public function getParentRowId()
    {
        return $this->container['parent_row_id'];
    }

    /**
     * Sets parent_row_id
     *
     * @param string|null $parent_row_id Parent record row ID
     *
     * @return self
     */
    public function setParentRowId($parent_row_id)
    {
        if (is_null($parent_row_id)) {
            throw new \InvalidArgumentException('non-nullable parent_row_id cannot be null');
        }
        $this->container['parent_row_id'] = $parent_row_id;

        return $this;
    }

    /**
     * Gets returnable_qty
     *
     * @return int|null
     */
    public function getReturnableQty()
    {
        return $this->container['returnable_qty'];
    }

    /**
     * Sets returnable_qty
     *
     * @param int|null $returnable_qty Returnable quantity
     *
     * @return self
     */
    public function setReturnableQty($returnable_qty)
    {
        if (is_null($returnable_qty)) {
            throw new \InvalidArgumentException('non-nullable returnable_qty cannot be null');
        }
        $this->container['returnable_qty'] = $returnable_qty;

        return $this;
    }

    /**
     * Gets order_qty
     *
     * @return int|null
     */
    public function getOrderQty()
    {
        return $this->container['order_qty'];
    }

    /**
     * Sets order_qty
     *
     * @param int|null $order_qty Order quantity
     *
     * @return self
     */
    public function setOrderQty($order_qty)
    {
        if (is_null($order_qty)) {
            throw new \InvalidArgumentException('non-nullable order_qty cannot be null');
        }
        $this->container['order_qty'] = $order_qty;

        return $this;
    }

    /**
     * Gets returned_qty
     *
     * @return int|null
     */
    public function getReturnedQty()
    {
        return $this->container['returned_qty'];
    }

    /**
     * Sets returned_qty
     *
     * @param int|null $returned_qty Returned quantity
     *
     * @return self
     */
    public function setReturnedQty($returned_qty)
    {
        if (is_null($returned_qty)) {
            throw new \InvalidArgumentException('non-nullable returned_qty cannot be null');
        }
        $this->container['returned_qty'] = $returned_qty;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Product title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets unit_value
     *
     * @return float|null
     */
    public function getUnitValue()
    {
        return $this->container['unit_value'];
    }

    /**
     * Sets unit_value
     *
     * @param float|null $unit_value Item value
     *
     * @return self
     */
    public function setUnitValue($unit_value)
    {
        if (is_null($unit_value)) {
            throw new \InvalidArgumentException('non-nullable unit_value cannot be null');
        }
        $this->container['unit_value'] = $unit_value;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Tax rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets tax_cost_inclusive
     *
     * @return bool|null
     */
    public function getTaxCostInclusive()
    {
        return $this->container['tax_cost_inclusive'];
    }

    /**
     * Sets tax_cost_inclusive
     *
     * @param bool|null $tax_cost_inclusive Indicates whether the UnitValue specified includes or exludes tax.
     *
     * @return self
     */
    public function setTaxCostInclusive($tax_cost_inclusive)
    {
        if (is_null($tax_cost_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_cost_inclusive cannot be null');
        }
        $this->container['tax_cost_inclusive'] = $tax_cost_inclusive;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets is_composite_parent
     *
     * @return bool|null
     */
    public function getIsCompositeParent()
    {
        return $this->container['is_composite_parent'];
    }

    /**
     * Sets is_composite_parent
     *
     * @param bool|null $is_composite_parent If item is composite parent
     *
     * @return self
     */
    public function setIsCompositeParent($is_composite_parent)
    {
        if (is_null($is_composite_parent)) {
            throw new \InvalidArgumentException('non-nullable is_composite_parent cannot be null');
        }
        $this->container['is_composite_parent'] = $is_composite_parent;

        return $this;
    }

    /**
     * Gets is_partial_composite_return
     *
     * @return bool|null
     */
    public function getIsPartialCompositeReturn()
    {
        return $this->container['is_partial_composite_return'];
    }

    /**
     * Sets is_partial_composite_return
     *
     * @param bool|null $is_partial_composite_return If return is a part of composite item
     *
     * @return self
     */
    public function setIsPartialCompositeReturn($is_partial_composite_return)
    {
        if (is_null($is_partial_composite_return)) {
            throw new \InvalidArgumentException('non-nullable is_partial_composite_return cannot be null');
        }
        $this->container['is_partial_composite_return'] = $is_partial_composite_return;

        return $this;
    }

    /**
     * Gets parent_ratio
     *
     * @return int|null
     */
    public function getParentRatio()
    {
        return $this->container['parent_ratio'];
    }

    /**
     * Sets parent_ratio
     *
     * @param int|null $parent_ratio parent_ratio
     *
     * @return self
     */
    public function setParentRatio($parent_ratio)
    {
        if (is_null($parent_ratio)) {
            throw new \InvalidArgumentException('non-nullable parent_ratio cannot be null');
        }
        $this->container['parent_ratio'] = $parent_ratio;

        return $this;
    }

    /**
     * Gets pk_stock_item_id
     *
     * @return string|null
     */
    public function getPkStockItemId()
    {
        return $this->container['pk_stock_item_id'];
    }

    /**
     * Sets pk_stock_item_id
     *
     * @param string|null $pk_stock_item_id Stock item ID
     *
     * @return self
     */
    public function setPkStockItemId($pk_stock_item_id)
    {
        if (is_null($pk_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable pk_stock_item_id cannot be null');
        }
        $this->container['pk_stock_item_id'] = $pk_stock_item_id;

        return $this;
    }

    /**
     * Gets resent_qty
     *
     * @return int|null
     */
    public function getResentQty()
    {
        return $this->container['resent_qty'];
    }

    /**
     * Sets resent_qty
     *
     * @param int|null $resent_qty resend quantity
     *
     * @return self
     */
    public function setResentQty($resent_qty)
    {
        if (is_null($resent_qty)) {
            throw new \InvalidArgumentException('non-nullable resent_qty cannot be null');
        }
        $this->container['resent_qty'] = $resent_qty;

        return $this;
    }

    /**
     * Gets fk_refund_row_id
     *
     * @return string|null
     */
    public function getFkRefundRowId()
    {
        return $this->container['fk_refund_row_id'];
    }

    /**
     * Sets fk_refund_row_id
     *
     * @param string|null $fk_refund_row_id Refund Row Id
     *
     * @return self
     */
    public function setFkRefundRowId($fk_refund_row_id)
    {
        if (is_null($fk_refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_refund_row_id cannot be null');
        }
        $this->container['fk_refund_row_id'] = $fk_refund_row_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


