<?php
/**
 * OrderItemBatch
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * OrderItemBatch Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderItemBatch implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderItemBatch';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_batch_id' => 'int',
        'order_item_row_id' => 'string',
        'batch_inventory_id' => 'int',
        'quantity' => 'int',
        'batch' => '\Linnworks\ProcessedOrders\Model\StockItemBatch',
        'despatch_unit_value' => 'float',
        'assignment_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_batch_id' => 'int32',
        'order_item_row_id' => 'uuid',
        'batch_inventory_id' => 'int32',
        'quantity' => 'int32',
        'batch' => null,
        'despatch_unit_value' => 'double',
        'assignment_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_item_batch_id' => false,
        'order_item_row_id' => false,
        'batch_inventory_id' => false,
        'quantity' => false,
        'batch' => false,
        'despatch_unit_value' => false,
        'assignment_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_batch_id' => 'OrderItemBatchId',
        'order_item_row_id' => 'OrderItemRowId',
        'batch_inventory_id' => 'BatchInventoryId',
        'quantity' => 'Quantity',
        'batch' => 'Batch',
        'despatch_unit_value' => 'DespatchUnitValue',
        'assignment_type' => 'AssignmentType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_batch_id' => 'setOrderItemBatchId',
        'order_item_row_id' => 'setOrderItemRowId',
        'batch_inventory_id' => 'setBatchInventoryId',
        'quantity' => 'setQuantity',
        'batch' => 'setBatch',
        'despatch_unit_value' => 'setDespatchUnitValue',
        'assignment_type' => 'setAssignmentType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_batch_id' => 'getOrderItemBatchId',
        'order_item_row_id' => 'getOrderItemRowId',
        'batch_inventory_id' => 'getBatchInventoryId',
        'quantity' => 'getQuantity',
        'batch' => 'getBatch',
        'despatch_unit_value' => 'getDespatchUnitValue',
        'assignment_type' => 'getAssignmentType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ASSIGNMENT_TYPE_AUTO = 'AUTO';
    public const ASSIGNMENT_TYPE_MANUAL = 'MANUAL';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAssignmentTypeAllowableValues()
    {
        return [
            self::ASSIGNMENT_TYPE_AUTO,
            self::ASSIGNMENT_TYPE_MANUAL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_item_batch_id', $data ?? [], null);
        $this->setIfExists('order_item_row_id', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('batch', $data ?? [], null);
        $this->setIfExists('despatch_unit_value', $data ?? [], null);
        $this->setIfExists('assignment_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAssignmentTypeAllowableValues();
        if (!is_null($this->container['assignment_type']) && !in_array($this->container['assignment_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'assignment_type', must be one of '%s'",
                $this->container['assignment_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_item_batch_id
     *
     * @return int|null
     */
    public function getOrderItemBatchId()
    {
        return $this->container['order_item_batch_id'];
    }

    /**
     * Sets order_item_batch_id
     *
     * @param int|null $order_item_batch_id order_item_batch_id
     *
     * @return self
     */
    public function setOrderItemBatchId($order_item_batch_id)
    {
        if (is_null($order_item_batch_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_batch_id cannot be null');
        }
        $this->container['order_item_batch_id'] = $order_item_batch_id;

        return $this;
    }

    /**
     * Gets order_item_row_id
     *
     * @return string|null
     */
    public function getOrderItemRowId()
    {
        return $this->container['order_item_row_id'];
    }

    /**
     * Sets order_item_row_id
     *
     * @param string|null $order_item_row_id order_item_row_id
     *
     * @return self
     */
    public function setOrderItemRowId($order_item_row_id)
    {
        if (is_null($order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_row_id cannot be null');
        }
        $this->container['order_item_row_id'] = $order_item_row_id;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id batch_inventory_id
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets batch
     *
     * @return \Linnworks\ProcessedOrders\Model\StockItemBatch|null
     */
    public function getBatch()
    {
        return $this->container['batch'];
    }

    /**
     * Sets batch
     *
     * @param \Linnworks\ProcessedOrders\Model\StockItemBatch|null $batch batch
     *
     * @return self
     */
    public function setBatch($batch)
    {
        if (is_null($batch)) {
            throw new \InvalidArgumentException('non-nullable batch cannot be null');
        }
        $this->container['batch'] = $batch;

        return $this;
    }

    /**
     * Gets despatch_unit_value
     *
     * @return float|null
     */
    public function getDespatchUnitValue()
    {
        return $this->container['despatch_unit_value'];
    }

    /**
     * Sets despatch_unit_value
     *
     * @param float|null $despatch_unit_value despatch_unit_value
     *
     * @return self
     */
    public function setDespatchUnitValue($despatch_unit_value)
    {
        if (is_null($despatch_unit_value)) {
            throw new \InvalidArgumentException('non-nullable despatch_unit_value cannot be null');
        }
        $this->container['despatch_unit_value'] = $despatch_unit_value;

        return $this;
    }

    /**
     * Gets assignment_type
     *
     * @return string|null
     */
    public function getAssignmentType()
    {
        return $this->container['assignment_type'];
    }

    /**
     * Sets assignment_type
     *
     * @param string|null $assignment_type assignment_type
     *
     * @return self
     */
    public function setAssignmentType($assignment_type)
    {
        if (is_null($assignment_type)) {
            throw new \InvalidArgumentException('non-nullable assignment_type cannot be null');
        }
        $allowedValues = $this->getAssignmentTypeAllowableValues();
        if (!in_array($assignment_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'assignment_type', must be one of '%s'",
                    $assignment_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['assignment_type'] = $assignment_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


