<?php
/**
 * DownloadOrdersToCSVRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * DownloadOrdersToCSVRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DownloadOrdersToCSVRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DownloadOrdersToCSVRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'search_term' => 'string',
        'search_filters' => '\Linnworks\ProcessedOrders\Model\SearchFilters[]',
        'date_field' => 'string',
        'from_date' => '\DateTime',
        'to_date' => '\DateTime',
        'search_sorting' => '\Linnworks\ProcessedOrders\Model\SearchSorting'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'search_term' => null,
        'search_filters' => null,
        'date_field' => null,
        'from_date' => 'date-time',
        'to_date' => 'date-time',
        'search_sorting' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'search_term' => false,
        'search_filters' => false,
        'date_field' => false,
        'from_date' => false,
        'to_date' => false,
        'search_sorting' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'search_term' => 'SearchTerm',
        'search_filters' => 'SearchFilters',
        'date_field' => 'DateField',
        'from_date' => 'FromDate',
        'to_date' => 'ToDate',
        'search_sorting' => 'SearchSorting'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'search_term' => 'setSearchTerm',
        'search_filters' => 'setSearchFilters',
        'date_field' => 'setDateField',
        'from_date' => 'setFromDate',
        'to_date' => 'setToDate',
        'search_sorting' => 'setSearchSorting'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'search_term' => 'getSearchTerm',
        'search_filters' => 'getSearchFilters',
        'date_field' => 'getDateField',
        'from_date' => 'getFromDate',
        'to_date' => 'getToDate',
        'search_sorting' => 'getSearchSorting'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DATE_FIELD_PROCESSED = 'processed';
    public const DATE_FIELD_PAYMENT = 'payment';
    public const DATE_FIELD_CANCELLED = 'cancelled';
    public const DATE_FIELD_RECEIVED = 'received';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDateFieldAllowableValues()
    {
        return [
            self::DATE_FIELD_PROCESSED,
            self::DATE_FIELD_PAYMENT,
            self::DATE_FIELD_CANCELLED,
            self::DATE_FIELD_RECEIVED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('search_term', $data ?? [], null);
        $this->setIfExists('search_filters', $data ?? [], null);
        $this->setIfExists('date_field', $data ?? [], null);
        $this->setIfExists('from_date', $data ?? [], null);
        $this->setIfExists('to_date', $data ?? [], null);
        $this->setIfExists('search_sorting', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDateFieldAllowableValues();
        if (!is_null($this->container['date_field']) && !in_array($this->container['date_field'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'date_field', must be one of '%s'",
                $this->container['date_field'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets search_term
     *
     * @return string|null
     */
    public function getSearchTerm()
    {
        return $this->container['search_term'];
    }

    /**
     * Sets search_term
     *
     * @param string|null $search_term Search Term
     *
     * @return self
     */
    public function setSearchTerm($search_term)
    {
        if (is_null($search_term)) {
            throw new \InvalidArgumentException('non-nullable search_term cannot be null');
        }
        $this->container['search_term'] = $search_term;

        return $this;
    }

    /**
     * Gets search_filters
     *
     * @return \Linnworks\ProcessedOrders\Model\SearchFilters[]|null
     */
    public function getSearchFilters()
    {
        return $this->container['search_filters'];
    }

    /**
     * Sets search_filters
     *
     * @param \Linnworks\ProcessedOrders\Model\SearchFilters[]|null $search_filters Search Filters
     *
     * @return self
     */
    public function setSearchFilters($search_filters)
    {
        if (is_null($search_filters)) {
            throw new \InvalidArgumentException('non-nullable search_filters cannot be null');
        }
        $this->container['search_filters'] = $search_filters;

        return $this;
    }

    /**
     * Gets date_field
     *
     * @return string|null
     */
    public function getDateField()
    {
        return $this->container['date_field'];
    }

    /**
     * Sets date_field
     *
     * @param string|null $date_field Date Field Type
     *
     * @return self
     */
    public function setDateField($date_field)
    {
        if (is_null($date_field)) {
            throw new \InvalidArgumentException('non-nullable date_field cannot be null');
        }
        $allowedValues = $this->getDateFieldAllowableValues();
        if (!in_array($date_field, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'date_field', must be one of '%s'",
                    $date_field,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['date_field'] = $date_field;

        return $this;
    }

    /**
     * Gets from_date
     *
     * @return \DateTime|null
     */
    public function getFromDate()
    {
        return $this->container['from_date'];
    }

    /**
     * Sets from_date
     *
     * @param \DateTime|null $from_date From Date
     *
     * @return self
     */
    public function setFromDate($from_date)
    {
        if (is_null($from_date)) {
            throw new \InvalidArgumentException('non-nullable from_date cannot be null');
        }
        $this->container['from_date'] = $from_date;

        return $this;
    }

    /**
     * Gets to_date
     *
     * @return \DateTime|null
     */
    public function getToDate()
    {
        return $this->container['to_date'];
    }

    /**
     * Sets to_date
     *
     * @param \DateTime|null $to_date To Date
     *
     * @return self
     */
    public function setToDate($to_date)
    {
        if (is_null($to_date)) {
            throw new \InvalidArgumentException('non-nullable to_date cannot be null');
        }
        $this->container['to_date'] = $to_date;

        return $this;
    }

    /**
     * Gets search_sorting
     *
     * @return \Linnworks\ProcessedOrders\Model\SearchSorting|null
     */
    public function getSearchSorting()
    {
        return $this->container['search_sorting'];
    }

    /**
     * Sets search_sorting
     *
     * @param \Linnworks\ProcessedOrders\Model\SearchSorting|null $search_sorting search_sorting
     *
     * @return self
     */
    public function setSearchSorting($search_sorting)
    {
        if (is_null($search_sorting)) {
            throw new \InvalidArgumentException('non-nullable search_sorting cannot be null');
        }
        $this->container['search_sorting'] = $search_sorting;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


