<?php
/**
 * AuditEntry
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Model;

use \ArrayAccess;
use \Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * AuditEntry Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AuditEntry implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AuditEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sid_history' => 'int',
        'fk_order_id' => 'string',
        'history_note' => 'string',
        'fk_order_history_type_id' => 'string',
        'date_stamp' => '\DateTime',
        'tag' => 'string',
        'updated_by' => 'string',
        'type_description' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sid_history' => 'int32',
        'fk_order_id' => 'uuid',
        'history_note' => null,
        'fk_order_history_type_id' => null,
        'date_stamp' => 'date-time',
        'tag' => null,
        'updated_by' => null,
        'type_description' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sid_history' => false,
        'fk_order_id' => false,
        'history_note' => false,
        'fk_order_history_type_id' => false,
        'date_stamp' => false,
        'tag' => false,
        'updated_by' => false,
        'type_description' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sid_history' => 'sid_history',
        'fk_order_id' => 'fkOrderId',
        'history_note' => 'HistoryNote',
        'fk_order_history_type_id' => 'fkOrderHistoryTypeId',
        'date_stamp' => 'DateStamp',
        'tag' => 'Tag',
        'updated_by' => 'UpdatedBy',
        'type_description' => 'TypeDescription'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sid_history' => 'setSidHistory',
        'fk_order_id' => 'setFkOrderId',
        'history_note' => 'setHistoryNote',
        'fk_order_history_type_id' => 'setFkOrderHistoryTypeId',
        'date_stamp' => 'setDateStamp',
        'tag' => 'setTag',
        'updated_by' => 'setUpdatedBy',
        'type_description' => 'setTypeDescription'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sid_history' => 'getSidHistory',
        'fk_order_id' => 'getFkOrderId',
        'history_note' => 'getHistoryNote',
        'fk_order_history_type_id' => 'getFkOrderHistoryTypeId',
        'date_stamp' => 'getDateStamp',
        'tag' => 'getTag',
        'updated_by' => 'getUpdatedBy',
        'type_description' => 'getTypeDescription'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sid_history', $data ?? [], null);
        $this->setIfExists('fk_order_id', $data ?? [], null);
        $this->setIfExists('history_note', $data ?? [], null);
        $this->setIfExists('fk_order_history_type_id', $data ?? [], null);
        $this->setIfExists('date_stamp', $data ?? [], null);
        $this->setIfExists('tag', $data ?? [], null);
        $this->setIfExists('updated_by', $data ?? [], null);
        $this->setIfExists('type_description', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sid_history
     *
     * @return int|null
     */
    public function getSidHistory()
    {
        return $this->container['sid_history'];
    }

    /**
     * Sets sid_history
     *
     * @param int|null $sid_history Audit record ID
     *
     * @return self
     */
    public function setSidHistory($sid_history)
    {
        if (is_null($sid_history)) {
            throw new \InvalidArgumentException('non-nullable sid_history cannot be null');
        }
        $this->container['sid_history'] = $sid_history;

        return $this;
    }

    /**
     * Gets fk_order_id
     *
     * @return string|null
     */
    public function getFkOrderId()
    {
        return $this->container['fk_order_id'];
    }

    /**
     * Sets fk_order_id
     *
     * @param string|null $fk_order_id Order ID (pkOrdeID)
     *
     * @return self
     */
    public function setFkOrderId($fk_order_id)
    {
        if (is_null($fk_order_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_id cannot be null');
        }
        $this->container['fk_order_id'] = $fk_order_id;

        return $this;
    }

    /**
     * Gets history_note
     *
     * @return string|null
     */
    public function getHistoryNote()
    {
        return $this->container['history_note'];
    }

    /**
     * Sets history_note
     *
     * @param string|null $history_note Note text
     *
     * @return self
     */
    public function setHistoryNote($history_note)
    {
        if (is_null($history_note)) {
            throw new \InvalidArgumentException('non-nullable history_note cannot be null');
        }
        $this->container['history_note'] = $history_note;

        return $this;
    }

    /**
     * Gets fk_order_history_type_id
     *
     * @return string|null
     */
    public function getFkOrderHistoryTypeId()
    {
        return $this->container['fk_order_history_type_id'];
    }

    /**
     * Sets fk_order_history_type_id
     *
     * @param string|null $fk_order_history_type_id Record type ID
     *
     * @return self
     */
    public function setFkOrderHistoryTypeId($fk_order_history_type_id)
    {
        if (is_null($fk_order_history_type_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_history_type_id cannot be null');
        }
        $this->container['fk_order_history_type_id'] = $fk_order_history_type_id;

        return $this;
    }

    /**
     * Gets date_stamp
     *
     * @return \DateTime|null
     */
    public function getDateStamp()
    {
        return $this->container['date_stamp'];
    }

    /**
     * Sets date_stamp
     *
     * @param \DateTime|null $date_stamp Record time and date
     *
     * @return self
     */
    public function setDateStamp($date_stamp)
    {
        if (is_null($date_stamp)) {
            throw new \InvalidArgumentException('non-nullable date_stamp cannot be null');
        }
        $this->container['date_stamp'] = $date_stamp;

        return $this;
    }

    /**
     * Gets tag
     *
     * @return string|null
     */
    public function getTag()
    {
        return $this->container['tag'];
    }

    /**
     * Sets tag
     *
     * @param string|null $tag Audit record tag
     *
     * @return self
     */
    public function setTag($tag)
    {
        if (is_null($tag)) {
            throw new \InvalidArgumentException('non-nullable tag cannot be null');
        }
        $this->container['tag'] = $tag;

        return $this;
    }

    /**
     * Gets updated_by
     *
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return $this->container['updated_by'];
    }

    /**
     * Sets updated_by
     *
     * @param string|null $updated_by User who made audited change
     *
     * @return self
     */
    public function setUpdatedBy($updated_by)
    {
        if (is_null($updated_by)) {
            throw new \InvalidArgumentException('non-nullable updated_by cannot be null');
        }
        $this->container['updated_by'] = $updated_by;

        return $this;
    }

    /**
     * Gets type_description
     *
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->container['type_description'];
    }

    /**
     * Sets type_description
     *
     * @param string|null $type_description Audit trail record type
     *
     * @return self
     */
    public function setTypeDescription($type_description)
    {
        if (is_null($type_description)) {
            throw new \InvalidArgumentException('non-nullable type_description cannot be null');
        }
        $this->container['type_description'] = $type_description;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


