<?php
/**
 * ProcessedOrdersApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Processed Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: processedorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ProcessedOrders\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\ProcessedOrders\ApiException;
use Linnworks\ProcessedOrders\Configuration;
use Linnworks\ProcessedOrders\HeaderSelector;
use Linnworks\ProcessedOrders\ObjectSerializer;

/**
 * ProcessedOrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ProcessedOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProcessedOrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addOrderNote' => [
            'application/json',
        ],
        'addReturnCategory' => [
            'application/json',
        ],
        'changeOrderNote' => [
            'application/json',
        ],
        'checkOrderFullyReturned' => [
            'application/json',
        ],
        'createExchange' => [
            'application/json',
        ],
        'createFullResend' => [
            'application/json',
        ],
        'createResend' => [
            'application/json',
        ],
        'deleteOrderNote' => [
            'application/json',
        ],
        'deleteReturnCategory' => [
            'application/json',
        ],
        'downloadOrdersToCSV' => [
            'application/json',
        ],
        'getChannelRefundReasons' => [
            'application/json',
        ],
        'getOrderInfo' => [
            'application/json',
        ],
        'getOrderTrackingURLs' => [
            'application/json',
        ],
        'getPackageSplit' => [
            'application/json',
        ],
        'getProcessedAuditTrail' => [
            'application/json',
        ],
        'getProcessedOrderExtendedProperties' => [
            'application/json',
        ],
        'getProcessedOrderNotes' => [
            'application/json',
        ],
        'getProcessedRelatives' => [
            'application/json',
        ],
        'getRefundableServiceItems' => [
            'application/json',
        ],
        'getRefunds' => [
            'application/json',
        ],
        'getRefundsOptions' => [
            'application/json',
        ],
        'getReturnCategories' => [
            'application/json',
        ],
        'getReturnItemsInfo' => [
            'application/json',
        ],
        'getReturnOrderInfo' => [
            'application/json',
        ],
        'getReturnsExchanges' => [
            'application/json',
        ],
        'getTotalRefunds' => [
            'application/json',
        ],
        'isRefundValid' => [
            'application/json',
        ],
        'isRefundValidationRequiredByOrderId' => [
            'application/json',
        ],
        'markManualRefundsAsActioned' => [
            'application/json',
        ],
        'refundFreeText' => [
            'application/json',
        ],
        'refundServices' => [
            'application/json',
        ],
        'refundShipping' => [
            'application/json',
        ],
        'renameReturnCategory' => [
            'application/json',
        ],
        'searchProcessedOrders' => [
            'application/json',
        ],
        'searchProcessedOrdersPaged' => [
            'application/json',
        ],
        'validateCompleteOrderRefund' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addOrderNote
     *
     * AddOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest $processed_orders_add_order_note_request processed_orders_add_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function addOrderNote($processed_orders_add_order_note_request, string $contentType = self::contentTypes['addOrderNote'][0])
    {
        list($response) = $this->addOrderNoteWithHttpInfo($processed_orders_add_order_note_request, $contentType);
        return $response;
    }

    /**
     * Operation addOrderNoteWithHttpInfo
     *
     * AddOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest $processed_orders_add_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrderNoteWithHttpInfo($processed_orders_add_order_note_request, string $contentType = self::contentTypes['addOrderNote'][0])
    {
        $request = $this->addOrderNoteRequest($processed_orders_add_order_note_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addOrderNoteAsync
     *
     * AddOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest $processed_orders_add_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderNoteAsync($processed_orders_add_order_note_request, string $contentType = self::contentTypes['addOrderNote'][0])
    {
        return $this->addOrderNoteAsyncWithHttpInfo($processed_orders_add_order_note_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrderNoteAsyncWithHttpInfo
     *
     * AddOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest $processed_orders_add_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderNoteAsyncWithHttpInfo($processed_orders_add_order_note_request, string $contentType = self::contentTypes['addOrderNote'][0])
    {
        $returnType = 'string';
        $request = $this->addOrderNoteRequest($processed_orders_add_order_note_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrderNote'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest $processed_orders_add_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrderNoteRequest($processed_orders_add_order_note_request, string $contentType = self::contentTypes['addOrderNote'][0])
    {

        // verify the required parameter 'processed_orders_add_order_note_request' is set
        if ($processed_orders_add_order_note_request === null || (is_array($processed_orders_add_order_note_request) && count($processed_orders_add_order_note_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_add_order_note_request when calling addOrderNote'
            );
        }


        $resourcePath = '/api/ProcessedOrders/AddOrderNote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_add_order_note_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_add_order_note_request));
            } else {
                $httpBody = $processed_orders_add_order_note_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addReturnCategory
     *
     * AddReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest $processed_orders_add_return_category_request processed_orders_add_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\OrderReturnCategory
     */
    public function addReturnCategory($processed_orders_add_return_category_request, string $contentType = self::contentTypes['addReturnCategory'][0])
    {
        list($response) = $this->addReturnCategoryWithHttpInfo($processed_orders_add_return_category_request, $contentType);
        return $response;
    }

    /**
     * Operation addReturnCategoryWithHttpInfo
     *
     * AddReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest $processed_orders_add_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\OrderReturnCategory, HTTP status code, HTTP response headers (array of strings)
     */
    public function addReturnCategoryWithHttpInfo($processed_orders_add_return_category_request, string $contentType = self::contentTypes['addReturnCategory'][0])
    {
        $request = $this->addReturnCategoryRequest($processed_orders_add_return_category_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\OrderReturnCategory' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\OrderReturnCategory' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\OrderReturnCategory', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\OrderReturnCategory';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\OrderReturnCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addReturnCategoryAsync
     *
     * AddReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest $processed_orders_add_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addReturnCategoryAsync($processed_orders_add_return_category_request, string $contentType = self::contentTypes['addReturnCategory'][0])
    {
        return $this->addReturnCategoryAsyncWithHttpInfo($processed_orders_add_return_category_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addReturnCategoryAsyncWithHttpInfo
     *
     * AddReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest $processed_orders_add_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addReturnCategoryAsyncWithHttpInfo($processed_orders_add_return_category_request, string $contentType = self::contentTypes['addReturnCategory'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\OrderReturnCategory';
        $request = $this->addReturnCategoryRequest($processed_orders_add_return_category_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addReturnCategory'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest $processed_orders_add_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addReturnCategoryRequest($processed_orders_add_return_category_request, string $contentType = self::contentTypes['addReturnCategory'][0])
    {

        // verify the required parameter 'processed_orders_add_return_category_request' is set
        if ($processed_orders_add_return_category_request === null || (is_array($processed_orders_add_return_category_request) && count($processed_orders_add_return_category_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_add_return_category_request when calling addReturnCategory'
            );
        }


        $resourcePath = '/api/ProcessedOrders/AddReturnCategory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_add_return_category_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_add_return_category_request));
            } else {
                $httpBody = $processed_orders_add_return_category_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation changeOrderNote
     *
     * ChangeOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest $processed_orders_change_order_note_request processed_orders_change_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function changeOrderNote($processed_orders_change_order_note_request, string $contentType = self::contentTypes['changeOrderNote'][0])
    {
        $this->changeOrderNoteWithHttpInfo($processed_orders_change_order_note_request, $contentType);
    }

    /**
     * Operation changeOrderNoteWithHttpInfo
     *
     * ChangeOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest $processed_orders_change_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function changeOrderNoteWithHttpInfo($processed_orders_change_order_note_request, string $contentType = self::contentTypes['changeOrderNote'][0])
    {
        $request = $this->changeOrderNoteRequest($processed_orders_change_order_note_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation changeOrderNoteAsync
     *
     * ChangeOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest $processed_orders_change_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeOrderNoteAsync($processed_orders_change_order_note_request, string $contentType = self::contentTypes['changeOrderNote'][0])
    {
        return $this->changeOrderNoteAsyncWithHttpInfo($processed_orders_change_order_note_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation changeOrderNoteAsyncWithHttpInfo
     *
     * ChangeOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest $processed_orders_change_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeOrderNoteAsyncWithHttpInfo($processed_orders_change_order_note_request, string $contentType = self::contentTypes['changeOrderNote'][0])
    {
        $returnType = '';
        $request = $this->changeOrderNoteRequest($processed_orders_change_order_note_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'changeOrderNote'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest $processed_orders_change_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function changeOrderNoteRequest($processed_orders_change_order_note_request, string $contentType = self::contentTypes['changeOrderNote'][0])
    {

        // verify the required parameter 'processed_orders_change_order_note_request' is set
        if ($processed_orders_change_order_note_request === null || (is_array($processed_orders_change_order_note_request) && count($processed_orders_change_order_note_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_change_order_note_request when calling changeOrderNote'
            );
        }


        $resourcePath = '/api/ProcessedOrders/ChangeOrderNote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_change_order_note_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_change_order_note_request));
            } else {
                $httpBody = $processed_orders_change_order_note_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation checkOrderFullyReturned
     *
     * CheckOrderFullyReturned
     *
     * @param  string|null $pk_order_id Primary key for an order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkOrderFullyReturned'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function checkOrderFullyReturned($pk_order_id = null, string $contentType = self::contentTypes['checkOrderFullyReturned'][0])
    {
        list($response) = $this->checkOrderFullyReturnedWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation checkOrderFullyReturnedWithHttpInfo
     *
     * CheckOrderFullyReturned
     *
     * @param  string|null $pk_order_id Primary key for an order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkOrderFullyReturned'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkOrderFullyReturnedWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['checkOrderFullyReturned'][0])
    {
        $request = $this->checkOrderFullyReturnedRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('bool' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('bool' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'bool', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'bool';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkOrderFullyReturnedAsync
     *
     * CheckOrderFullyReturned
     *
     * @param  string|null $pk_order_id Primary key for an order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkOrderFullyReturned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkOrderFullyReturnedAsync($pk_order_id = null, string $contentType = self::contentTypes['checkOrderFullyReturned'][0])
    {
        return $this->checkOrderFullyReturnedAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkOrderFullyReturnedAsyncWithHttpInfo
     *
     * CheckOrderFullyReturned
     *
     * @param  string|null $pk_order_id Primary key for an order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkOrderFullyReturned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkOrderFullyReturnedAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['checkOrderFullyReturned'][0])
    {
        $returnType = 'bool';
        $request = $this->checkOrderFullyReturnedRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkOrderFullyReturned'
     *
     * @param  string|null $pk_order_id Primary key for an order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkOrderFullyReturned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkOrderFullyReturnedRequest($pk_order_id = null, string $contentType = self::contentTypes['checkOrderFullyReturned'][0])
    {



        $resourcePath = '/api/ProcessedOrders/CheckOrderFullyReturned';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExchange
     *
     * CreateExchange
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest $processed_orders_create_exchange_request processed_orders_create_exchange_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createExchange'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ReturnInfo[]
     */
    public function createExchange($processed_orders_create_exchange_request, string $contentType = self::contentTypes['createExchange'][0])
    {
        list($response) = $this->createExchangeWithHttpInfo($processed_orders_create_exchange_request, $contentType);
        return $response;
    }

    /**
     * Operation createExchangeWithHttpInfo
     *
     * CreateExchange
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest $processed_orders_create_exchange_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createExchange'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ReturnInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function createExchangeWithHttpInfo($processed_orders_create_exchange_request, string $contentType = self::contentTypes['createExchange'][0])
    {
        $request = $this->createExchangeRequest($processed_orders_create_exchange_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ReturnInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ReturnInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExchangeAsync
     *
     * CreateExchange
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest $processed_orders_create_exchange_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createExchange'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExchangeAsync($processed_orders_create_exchange_request, string $contentType = self::contentTypes['createExchange'][0])
    {
        return $this->createExchangeAsyncWithHttpInfo($processed_orders_create_exchange_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExchangeAsyncWithHttpInfo
     *
     * CreateExchange
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest $processed_orders_create_exchange_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createExchange'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExchangeAsyncWithHttpInfo($processed_orders_create_exchange_request, string $contentType = self::contentTypes['createExchange'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
        $request = $this->createExchangeRequest($processed_orders_create_exchange_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExchange'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest $processed_orders_create_exchange_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createExchange'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createExchangeRequest($processed_orders_create_exchange_request, string $contentType = self::contentTypes['createExchange'][0])
    {

        // verify the required parameter 'processed_orders_create_exchange_request' is set
        if ($processed_orders_create_exchange_request === null || (is_array($processed_orders_create_exchange_request) && count($processed_orders_create_exchange_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_create_exchange_request when calling createExchange'
            );
        }


        $resourcePath = '/api/ProcessedOrders/CreateExchange';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_create_exchange_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_create_exchange_request));
            } else {
                $httpBody = $processed_orders_create_exchange_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createFullResend
     *
     * CreateFullResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest $processed_orders_create_full_resend_request processed_orders_create_full_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFullResend'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ReturnInfo[]
     */
    public function createFullResend($processed_orders_create_full_resend_request, string $contentType = self::contentTypes['createFullResend'][0])
    {
        list($response) = $this->createFullResendWithHttpInfo($processed_orders_create_full_resend_request, $contentType);
        return $response;
    }

    /**
     * Operation createFullResendWithHttpInfo
     *
     * CreateFullResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest $processed_orders_create_full_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFullResend'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ReturnInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function createFullResendWithHttpInfo($processed_orders_create_full_resend_request, string $contentType = self::contentTypes['createFullResend'][0])
    {
        $request = $this->createFullResendRequest($processed_orders_create_full_resend_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ReturnInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ReturnInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createFullResendAsync
     *
     * CreateFullResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest $processed_orders_create_full_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFullResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFullResendAsync($processed_orders_create_full_resend_request, string $contentType = self::contentTypes['createFullResend'][0])
    {
        return $this->createFullResendAsyncWithHttpInfo($processed_orders_create_full_resend_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createFullResendAsyncWithHttpInfo
     *
     * CreateFullResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest $processed_orders_create_full_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFullResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFullResendAsyncWithHttpInfo($processed_orders_create_full_resend_request, string $contentType = self::contentTypes['createFullResend'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
        $request = $this->createFullResendRequest($processed_orders_create_full_resend_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createFullResend'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest $processed_orders_create_full_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFullResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createFullResendRequest($processed_orders_create_full_resend_request, string $contentType = self::contentTypes['createFullResend'][0])
    {

        // verify the required parameter 'processed_orders_create_full_resend_request' is set
        if ($processed_orders_create_full_resend_request === null || (is_array($processed_orders_create_full_resend_request) && count($processed_orders_create_full_resend_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_create_full_resend_request when calling createFullResend'
            );
        }


        $resourcePath = '/api/ProcessedOrders/CreateFullResend';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_create_full_resend_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_create_full_resend_request));
            } else {
                $httpBody = $processed_orders_create_full_resend_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createResend
     *
     * CreateResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest $processed_orders_create_resend_request processed_orders_create_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createResend'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ReturnInfo[]
     */
    public function createResend($processed_orders_create_resend_request, string $contentType = self::contentTypes['createResend'][0])
    {
        list($response) = $this->createResendWithHttpInfo($processed_orders_create_resend_request, $contentType);
        return $response;
    }

    /**
     * Operation createResendWithHttpInfo
     *
     * CreateResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest $processed_orders_create_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createResend'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ReturnInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function createResendWithHttpInfo($processed_orders_create_resend_request, string $contentType = self::contentTypes['createResend'][0])
    {
        $request = $this->createResendRequest($processed_orders_create_resend_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ReturnInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ReturnInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createResendAsync
     *
     * CreateResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest $processed_orders_create_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createResendAsync($processed_orders_create_resend_request, string $contentType = self::contentTypes['createResend'][0])
    {
        return $this->createResendAsyncWithHttpInfo($processed_orders_create_resend_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createResendAsyncWithHttpInfo
     *
     * CreateResend
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest $processed_orders_create_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createResendAsyncWithHttpInfo($processed_orders_create_resend_request, string $contentType = self::contentTypes['createResend'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
        $request = $this->createResendRequest($processed_orders_create_resend_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createResend'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest $processed_orders_create_resend_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createResend'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createResendRequest($processed_orders_create_resend_request, string $contentType = self::contentTypes['createResend'][0])
    {

        // verify the required parameter 'processed_orders_create_resend_request' is set
        if ($processed_orders_create_resend_request === null || (is_array($processed_orders_create_resend_request) && count($processed_orders_create_resend_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_create_resend_request when calling createResend'
            );
        }


        $resourcePath = '/api/ProcessedOrders/CreateResend';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_create_resend_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_create_resend_request));
            } else {
                $httpBody = $processed_orders_create_resend_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrderNote
     *
     * DeleteOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest $processed_orders_delete_order_note_request processed_orders_delete_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrderNote($processed_orders_delete_order_note_request, string $contentType = self::contentTypes['deleteOrderNote'][0])
    {
        $this->deleteOrderNoteWithHttpInfo($processed_orders_delete_order_note_request, $contentType);
    }

    /**
     * Operation deleteOrderNoteWithHttpInfo
     *
     * DeleteOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest $processed_orders_delete_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrderNote'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrderNoteWithHttpInfo($processed_orders_delete_order_note_request, string $contentType = self::contentTypes['deleteOrderNote'][0])
    {
        $request = $this->deleteOrderNoteRequest($processed_orders_delete_order_note_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrderNoteAsync
     *
     * DeleteOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest $processed_orders_delete_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrderNoteAsync($processed_orders_delete_order_note_request, string $contentType = self::contentTypes['deleteOrderNote'][0])
    {
        return $this->deleteOrderNoteAsyncWithHttpInfo($processed_orders_delete_order_note_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrderNoteAsyncWithHttpInfo
     *
     * DeleteOrderNote
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest $processed_orders_delete_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrderNoteAsyncWithHttpInfo($processed_orders_delete_order_note_request, string $contentType = self::contentTypes['deleteOrderNote'][0])
    {
        $returnType = '';
        $request = $this->deleteOrderNoteRequest($processed_orders_delete_order_note_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrderNote'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest $processed_orders_delete_order_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrderNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrderNoteRequest($processed_orders_delete_order_note_request, string $contentType = self::contentTypes['deleteOrderNote'][0])
    {

        // verify the required parameter 'processed_orders_delete_order_note_request' is set
        if ($processed_orders_delete_order_note_request === null || (is_array($processed_orders_delete_order_note_request) && count($processed_orders_delete_order_note_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_delete_order_note_request when calling deleteOrderNote'
            );
        }


        $resourcePath = '/api/ProcessedOrders/DeleteOrderNote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_delete_order_note_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_delete_order_note_request));
            } else {
                $httpBody = $processed_orders_delete_order_note_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteReturnCategory
     *
     * DeleteReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest $processed_orders_delete_return_category_request processed_orders_delete_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteReturnCategory($processed_orders_delete_return_category_request, string $contentType = self::contentTypes['deleteReturnCategory'][0])
    {
        $this->deleteReturnCategoryWithHttpInfo($processed_orders_delete_return_category_request, $contentType);
    }

    /**
     * Operation deleteReturnCategoryWithHttpInfo
     *
     * DeleteReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest $processed_orders_delete_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteReturnCategoryWithHttpInfo($processed_orders_delete_return_category_request, string $contentType = self::contentTypes['deleteReturnCategory'][0])
    {
        $request = $this->deleteReturnCategoryRequest($processed_orders_delete_return_category_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteReturnCategoryAsync
     *
     * DeleteReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest $processed_orders_delete_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnCategoryAsync($processed_orders_delete_return_category_request, string $contentType = self::contentTypes['deleteReturnCategory'][0])
    {
        return $this->deleteReturnCategoryAsyncWithHttpInfo($processed_orders_delete_return_category_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteReturnCategoryAsyncWithHttpInfo
     *
     * DeleteReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest $processed_orders_delete_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnCategoryAsyncWithHttpInfo($processed_orders_delete_return_category_request, string $contentType = self::contentTypes['deleteReturnCategory'][0])
    {
        $returnType = '';
        $request = $this->deleteReturnCategoryRequest($processed_orders_delete_return_category_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteReturnCategory'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest $processed_orders_delete_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteReturnCategoryRequest($processed_orders_delete_return_category_request, string $contentType = self::contentTypes['deleteReturnCategory'][0])
    {

        // verify the required parameter 'processed_orders_delete_return_category_request' is set
        if ($processed_orders_delete_return_category_request === null || (is_array($processed_orders_delete_return_category_request) && count($processed_orders_delete_return_category_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_delete_return_category_request when calling deleteReturnCategory'
            );
        }


        $resourcePath = '/api/ProcessedOrders/DeleteReturnCategory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_delete_return_category_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_delete_return_category_request));
            } else {
                $httpBody = $processed_orders_delete_return_category_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation downloadOrdersToCSV
     *
     * DownloadOrdersToCSV
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest $processed_orders_download_orders_to_csv_request processed_orders_download_orders_to_csv_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadOrdersToCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse
     */
    public function downloadOrdersToCSV($processed_orders_download_orders_to_csv_request, string $contentType = self::contentTypes['downloadOrdersToCSV'][0])
    {
        list($response) = $this->downloadOrdersToCSVWithHttpInfo($processed_orders_download_orders_to_csv_request, $contentType);
        return $response;
    }

    /**
     * Operation downloadOrdersToCSVWithHttpInfo
     *
     * DownloadOrdersToCSV
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest $processed_orders_download_orders_to_csv_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadOrdersToCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function downloadOrdersToCSVWithHttpInfo($processed_orders_download_orders_to_csv_request, string $contentType = self::contentTypes['downloadOrdersToCSV'][0])
    {
        $request = $this->downloadOrdersToCSVRequest($processed_orders_download_orders_to_csv_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation downloadOrdersToCSVAsync
     *
     * DownloadOrdersToCSV
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest $processed_orders_download_orders_to_csv_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadOrdersToCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function downloadOrdersToCSVAsync($processed_orders_download_orders_to_csv_request, string $contentType = self::contentTypes['downloadOrdersToCSV'][0])
    {
        return $this->downloadOrdersToCSVAsyncWithHttpInfo($processed_orders_download_orders_to_csv_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation downloadOrdersToCSVAsyncWithHttpInfo
     *
     * DownloadOrdersToCSV
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest $processed_orders_download_orders_to_csv_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadOrdersToCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function downloadOrdersToCSVAsyncWithHttpInfo($processed_orders_download_orders_to_csv_request, string $contentType = self::contentTypes['downloadOrdersToCSV'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse';
        $request = $this->downloadOrdersToCSVRequest($processed_orders_download_orders_to_csv_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'downloadOrdersToCSV'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest $processed_orders_download_orders_to_csv_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadOrdersToCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function downloadOrdersToCSVRequest($processed_orders_download_orders_to_csv_request, string $contentType = self::contentTypes['downloadOrdersToCSV'][0])
    {

        // verify the required parameter 'processed_orders_download_orders_to_csv_request' is set
        if ($processed_orders_download_orders_to_csv_request === null || (is_array($processed_orders_download_orders_to_csv_request) && count($processed_orders_download_orders_to_csv_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_download_orders_to_csv_request when calling downloadOrdersToCSV'
            );
        }


        $resourcePath = '/api/ProcessedOrders/DownloadOrdersToCSV';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_download_orders_to_csv_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_download_orders_to_csv_request));
            } else {
                $httpBody = $processed_orders_download_orders_to_csv_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getChannelRefundReasons
     *
     * GetChannelRefundReasons
     *
     * @param  string|null $pk_order_id The order id to get reasons for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelRefundReasons'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ChannelRefundReason[]
     */
    public function getChannelRefundReasons($pk_order_id = null, string $contentType = self::contentTypes['getChannelRefundReasons'][0])
    {
        list($response) = $this->getChannelRefundReasonsWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getChannelRefundReasonsWithHttpInfo
     *
     * GetChannelRefundReasons
     *
     * @param  string|null $pk_order_id The order id to get reasons for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelRefundReasons'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ChannelRefundReason[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getChannelRefundReasonsWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getChannelRefundReasons'][0])
    {
        $request = $this->getChannelRefundReasonsRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getChannelRefundReasonsAsync
     *
     * GetChannelRefundReasons
     *
     * @param  string|null $pk_order_id The order id to get reasons for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelRefundReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelRefundReasonsAsync($pk_order_id = null, string $contentType = self::contentTypes['getChannelRefundReasons'][0])
    {
        return $this->getChannelRefundReasonsAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getChannelRefundReasonsAsyncWithHttpInfo
     *
     * GetChannelRefundReasons
     *
     * @param  string|null $pk_order_id The order id to get reasons for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelRefundReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelRefundReasonsAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getChannelRefundReasons'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]';
        $request = $this->getChannelRefundReasonsRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getChannelRefundReasons'
     *
     * @param  string|null $pk_order_id The order id to get reasons for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelRefundReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getChannelRefundReasonsRequest($pk_order_id = null, string $contentType = self::contentTypes['getChannelRefundReasons'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetChannelRefundReasons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderInfo
     *
     * GetOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ProcessedOrderWeb
     */
    public function getOrderInfo($pk_order_id = null, string $contentType = self::contentTypes['getOrderInfo'][0])
    {
        list($response) = $this->getOrderInfoWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderInfoWithHttpInfo
     *
     * GetOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ProcessedOrderWeb, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderInfoWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getOrderInfo'][0])
    {
        $request = $this->getOrderInfoRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderInfoAsync
     *
     * GetOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderInfoAsync($pk_order_id = null, string $contentType = self::contentTypes['getOrderInfo'][0])
    {
        return $this->getOrderInfoAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderInfoAsyncWithHttpInfo
     *
     * GetOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderInfoAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getOrderInfo'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb';
        $request = $this->getOrderInfoRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderInfo'
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderInfoRequest($pk_order_id = null, string $contentType = self::contentTypes['getOrderInfo'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetOrderInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderTrackingURLs
     *
     * GetOrderTrackingURLs
     *
     * @param  \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest|null $request The request for TrackingURL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderTrackingURLs'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse
     */
    public function getOrderTrackingURLs($request = null, string $contentType = self::contentTypes['getOrderTrackingURLs'][0])
    {
        list($response) = $this->getOrderTrackingURLsWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderTrackingURLsWithHttpInfo
     *
     * GetOrderTrackingURLs
     *
     * @param  \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest|null $request The request for TrackingURL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderTrackingURLs'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderTrackingURLsWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderTrackingURLs'][0])
    {
        $request = $this->getOrderTrackingURLsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderTrackingURLsAsync
     *
     * GetOrderTrackingURLs
     *
     * @param  \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest|null $request The request for TrackingURL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderTrackingURLs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderTrackingURLsAsync($request = null, string $contentType = self::contentTypes['getOrderTrackingURLs'][0])
    {
        return $this->getOrderTrackingURLsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderTrackingURLsAsyncWithHttpInfo
     *
     * GetOrderTrackingURLs
     *
     * @param  \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest|null $request The request for TrackingURL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderTrackingURLs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderTrackingURLsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderTrackingURLs'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse';
        $request = $this->getOrderTrackingURLsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderTrackingURLs'
     *
     * @param  \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest|null $request The request for TrackingURL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderTrackingURLs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderTrackingURLsRequest($request = null, string $contentType = self::contentTypes['getOrderTrackingURLs'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetOrderTrackingURLs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPackageSplit
     *
     * GetPackageSplit
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageSplit'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\SplitPackaging[]
     */
    public function getPackageSplit($pk_order_id = null, string $contentType = self::contentTypes['getPackageSplit'][0])
    {
        list($response) = $this->getPackageSplitWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getPackageSplitWithHttpInfo
     *
     * GetPackageSplit
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageSplit'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\SplitPackaging[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPackageSplitWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getPackageSplit'][0])
    {
        $request = $this->getPackageSplitRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\SplitPackaging[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\SplitPackaging[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\SplitPackaging[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\SplitPackaging[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\SplitPackaging[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPackageSplitAsync
     *
     * GetPackageSplit
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageSplitAsync($pk_order_id = null, string $contentType = self::contentTypes['getPackageSplit'][0])
    {
        return $this->getPackageSplitAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPackageSplitAsyncWithHttpInfo
     *
     * GetPackageSplit
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageSplitAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getPackageSplit'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\SplitPackaging[]';
        $request = $this->getPackageSplitRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPackageSplit'
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPackageSplitRequest($pk_order_id = null, string $contentType = self::contentTypes['getPackageSplit'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetPackageSplit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedAuditTrail
     *
     * GetProcessedAuditTrail
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\AuditEntry[]
     */
    public function getProcessedAuditTrail($pk_order_id = null, string $contentType = self::contentTypes['getProcessedAuditTrail'][0])
    {
        list($response) = $this->getProcessedAuditTrailWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedAuditTrailWithHttpInfo
     *
     * GetProcessedAuditTrail
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\AuditEntry[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getProcessedAuditTrailWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedAuditTrail'][0])
    {
        $request = $this->getProcessedAuditTrailRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\AuditEntry[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\AuditEntry[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\AuditEntry[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\AuditEntry[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\AuditEntry[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedAuditTrailAsync
     *
     * GetProcessedAuditTrail
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedAuditTrailAsync($pk_order_id = null, string $contentType = self::contentTypes['getProcessedAuditTrail'][0])
    {
        return $this->getProcessedAuditTrailAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedAuditTrailAsyncWithHttpInfo
     *
     * GetProcessedAuditTrail
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedAuditTrailAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedAuditTrail'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\AuditEntry[]';
        $request = $this->getProcessedAuditTrailRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedAuditTrail'
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProcessedAuditTrailRequest($pk_order_id = null, string $contentType = self::contentTypes['getProcessedAuditTrail'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetProcessedAuditTrail';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedOrderExtendedProperties
     *
     * GetProcessedOrderExtendedProperties
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]
     */
    public function getProcessedOrderExtendedProperties($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderExtendedProperties'][0])
    {
        list($response) = $this->getProcessedOrderExtendedPropertiesWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedOrderExtendedPropertiesWithHttpInfo
     *
     * GetProcessedOrderExtendedProperties
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\OrderExtendedProperty[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getProcessedOrderExtendedPropertiesWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderExtendedProperties'][0])
    {
        $request = $this->getProcessedOrderExtendedPropertiesRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedOrderExtendedPropertiesAsync
     *
     * GetProcessedOrderExtendedProperties
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrderExtendedPropertiesAsync($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderExtendedProperties'][0])
    {
        return $this->getProcessedOrderExtendedPropertiesAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedOrderExtendedPropertiesAsyncWithHttpInfo
     *
     * GetProcessedOrderExtendedProperties
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrderExtendedPropertiesAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderExtendedProperties'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]';
        $request = $this->getProcessedOrderExtendedPropertiesRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedOrderExtendedProperties'
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProcessedOrderExtendedPropertiesRequest($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderExtendedProperties'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetProcessedOrderExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedOrderNotes
     *
     * GetProcessedOrderNotes
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]
     * @deprecated
     */
    public function getProcessedOrderNotes($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderNotes'][0])
    {
        list($response) = $this->getProcessedOrderNotesWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedOrderNotesWithHttpInfo
     *
     * GetProcessedOrderNotes
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ProcessedOrderNote[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getProcessedOrderNotesWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderNotes'][0])
    {
        $request = $this->getProcessedOrderNotesRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedOrderNotesAsync
     *
     * GetProcessedOrderNotes
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getProcessedOrderNotesAsync($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderNotes'][0])
    {
        return $this->getProcessedOrderNotesAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedOrderNotesAsyncWithHttpInfo
     *
     * GetProcessedOrderNotes
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getProcessedOrderNotesAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderNotes'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]';
        $request = $this->getProcessedOrderNotesRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedOrderNotes'
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getProcessedOrderNotesRequest($pk_order_id = null, string $contentType = self::contentTypes['getProcessedOrderNotes'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetProcessedOrderNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedRelatives
     *
     * GetProcessedRelatives
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedRelatives'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]
     */
    public function getProcessedRelatives($pk_order_id = null, string $contentType = self::contentTypes['getProcessedRelatives'][0])
    {
        list($response) = $this->getProcessedRelativesWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedRelativesWithHttpInfo
     *
     * GetProcessedRelatives
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedRelatives'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getProcessedRelativesWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedRelatives'][0])
    {
        $request = $this->getProcessedRelativesRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedRelativesAsync
     *
     * GetProcessedRelatives
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedRelatives'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedRelativesAsync($pk_order_id = null, string $contentType = self::contentTypes['getProcessedRelatives'][0])
    {
        return $this->getProcessedRelativesAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedRelativesAsyncWithHttpInfo
     *
     * GetProcessedRelatives
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedRelatives'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedRelativesAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getProcessedRelatives'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]';
        $request = $this->getProcessedRelativesRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedRelatives'
     *
     * @param  string|null $pk_order_id The order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedRelatives'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProcessedRelativesRequest($pk_order_id = null, string $contentType = self::contentTypes['getProcessedRelatives'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetProcessedRelatives';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundableServiceItems
     *
     * GetRefundableServiceItems
     *
     * @param  string|null $pk_order_id The id of the order which the service items belong to. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundableServiceItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ServiceItem[]
     */
    public function getRefundableServiceItems($pk_order_id = null, string $contentType = self::contentTypes['getRefundableServiceItems'][0])
    {
        list($response) = $this->getRefundableServiceItemsWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getRefundableServiceItemsWithHttpInfo
     *
     * GetRefundableServiceItems
     *
     * @param  string|null $pk_order_id The id of the order which the service items belong to. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundableServiceItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ServiceItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundableServiceItemsWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefundableServiceItems'][0])
    {
        $request = $this->getRefundableServiceItemsRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ServiceItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ServiceItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ServiceItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ServiceItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ServiceItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundableServiceItemsAsync
     *
     * GetRefundableServiceItems
     *
     * @param  string|null $pk_order_id The id of the order which the service items belong to. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundableServiceItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundableServiceItemsAsync($pk_order_id = null, string $contentType = self::contentTypes['getRefundableServiceItems'][0])
    {
        return $this->getRefundableServiceItemsAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundableServiceItemsAsyncWithHttpInfo
     *
     * GetRefundableServiceItems
     *
     * @param  string|null $pk_order_id The id of the order which the service items belong to. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundableServiceItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundableServiceItemsAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefundableServiceItems'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ServiceItem[]';
        $request = $this->getRefundableServiceItemsRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundableServiceItems'
     *
     * @param  string|null $pk_order_id The id of the order which the service items belong to. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundableServiceItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundableServiceItemsRequest($pk_order_id = null, string $contentType = self::contentTypes['getRefundableServiceItems'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetRefundableServiceItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefunds
     *
     * GetRefunds
     *
     * @param  string|null $pk_order_id Primary key for order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\RefundInfo[]
     */
    public function getRefunds($pk_order_id = null, string $contentType = self::contentTypes['getRefunds'][0])
    {
        list($response) = $this->getRefundsWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getRefundsWithHttpInfo
     *
     * GetRefunds
     *
     * @param  string|null $pk_order_id Primary key for order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\RefundInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundsWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefunds'][0])
    {
        $request = $this->getRefundsRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\RefundInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\RefundInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundsAsync
     *
     * GetRefunds
     *
     * @param  string|null $pk_order_id Primary key for order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundsAsync($pk_order_id = null, string $contentType = self::contentTypes['getRefunds'][0])
    {
        return $this->getRefundsAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundsAsyncWithHttpInfo
     *
     * GetRefunds
     *
     * @param  string|null $pk_order_id Primary key for order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundsAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefunds'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
        $request = $this->getRefundsRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefunds'
     *
     * @param  string|null $pk_order_id Primary key for order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundsRequest($pk_order_id = null, string $contentType = self::contentTypes['getRefunds'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetRefunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundsOptions
     *
     * GetRefundsOptions
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundsOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\RefundScreenOptions
     */
    public function getRefundsOptions($pk_order_id = null, string $contentType = self::contentTypes['getRefundsOptions'][0])
    {
        list($response) = $this->getRefundsOptionsWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getRefundsOptionsWithHttpInfo
     *
     * GetRefundsOptions
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundsOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\RefundScreenOptions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundsOptionsWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefundsOptions'][0])
    {
        $request = $this->getRefundsOptionsRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\RefundScreenOptions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\RefundScreenOptions' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\RefundScreenOptions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\RefundScreenOptions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\RefundScreenOptions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundsOptionsAsync
     *
     * GetRefundsOptions
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundsOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundsOptionsAsync($pk_order_id = null, string $contentType = self::contentTypes['getRefundsOptions'][0])
    {
        return $this->getRefundsOptionsAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundsOptionsAsyncWithHttpInfo
     *
     * GetRefundsOptions
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundsOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundsOptionsAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getRefundsOptions'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\RefundScreenOptions';
        $request = $this->getRefundsOptionsRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundsOptions'
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundsOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundsOptionsRequest($pk_order_id = null, string $contentType = self::contentTypes['getRefundsOptions'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetRefundsOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnCategories
     *
     * GetReturnCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\OrderReturnCategory[]
     */
    public function getReturnCategories(string $contentType = self::contentTypes['getReturnCategories'][0])
    {
        list($response) = $this->getReturnCategoriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getReturnCategoriesWithHttpInfo
     *
     * GetReturnCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\OrderReturnCategory[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnCategoriesWithHttpInfo(string $contentType = self::contentTypes['getReturnCategories'][0])
    {
        $request = $this->getReturnCategoriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnCategoriesAsync
     *
     * GetReturnCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnCategoriesAsync(string $contentType = self::contentTypes['getReturnCategories'][0])
    {
        return $this->getReturnCategoriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnCategoriesAsyncWithHttpInfo
     *
     * GetReturnCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnCategoriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getReturnCategories'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]';
        $request = $this->getReturnCategoriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnCategories'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnCategoriesRequest(string $contentType = self::contentTypes['getReturnCategories'][0])
    {


        $resourcePath = '/api/ProcessedOrders/GetReturnCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnItemsInfo
     *
     * GetReturnItemsInfo
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnItemsInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]
     */
    public function getReturnItemsInfo($pk_order_id = null, string $contentType = self::contentTypes['getReturnItemsInfo'][0])
    {
        list($response) = $this->getReturnItemsInfoWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getReturnItemsInfoWithHttpInfo
     *
     * GetReturnItemsInfo
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnItemsInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnItemsInfoWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getReturnItemsInfo'][0])
    {
        $request = $this->getReturnItemsInfoRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnItemsInfoAsync
     *
     * GetReturnItemsInfo
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnItemsInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnItemsInfoAsync($pk_order_id = null, string $contentType = self::contentTypes['getReturnItemsInfo'][0])
    {
        return $this->getReturnItemsInfoAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnItemsInfoAsyncWithHttpInfo
     *
     * GetReturnItemsInfo
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnItemsInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnItemsInfoAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getReturnItemsInfo'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]';
        $request = $this->getReturnItemsInfoRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnItemsInfo'
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnItemsInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnItemsInfoRequest($pk_order_id = null, string $contentType = self::contentTypes['getReturnItemsInfo'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetReturnItemsInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnOrderInfo
     *
     * GetReturnOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  bool|null $include_refund_link Is a refund link required (not available for all channels). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOrderInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ReturnOrderHeader
     */
    public function getReturnOrderInfo($pk_order_id = null, $include_refund_link = null, string $contentType = self::contentTypes['getReturnOrderInfo'][0])
    {
        list($response) = $this->getReturnOrderInfoWithHttpInfo($pk_order_id, $include_refund_link, $contentType);
        return $response;
    }

    /**
     * Operation getReturnOrderInfoWithHttpInfo
     *
     * GetReturnOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  bool|null $include_refund_link Is a refund link required (not available for all channels). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOrderInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ReturnOrderHeader, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnOrderInfoWithHttpInfo($pk_order_id = null, $include_refund_link = null, string $contentType = self::contentTypes['getReturnOrderInfo'][0])
    {
        $request = $this->getReturnOrderInfoRequest($pk_order_id, $include_refund_link, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ReturnOrderHeader' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ReturnOrderHeader' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ReturnOrderHeader', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ReturnOrderHeader';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ReturnOrderHeader',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnOrderInfoAsync
     *
     * GetReturnOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  bool|null $include_refund_link Is a refund link required (not available for all channels). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnOrderInfoAsync($pk_order_id = null, $include_refund_link = null, string $contentType = self::contentTypes['getReturnOrderInfo'][0])
    {
        return $this->getReturnOrderInfoAsyncWithHttpInfo($pk_order_id, $include_refund_link, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnOrderInfoAsyncWithHttpInfo
     *
     * GetReturnOrderInfo
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  bool|null $include_refund_link Is a refund link required (not available for all channels). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnOrderInfoAsyncWithHttpInfo($pk_order_id = null, $include_refund_link = null, string $contentType = self::contentTypes['getReturnOrderInfo'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ReturnOrderHeader';
        $request = $this->getReturnOrderInfoRequest($pk_order_id, $include_refund_link, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnOrderInfo'
     *
     * @param  string|null $pk_order_id The id of the order. (optional)
     * @param  bool|null $include_refund_link Is a refund link required (not available for all channels). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOrderInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnOrderInfoRequest($pk_order_id = null, $include_refund_link = null, string $contentType = self::contentTypes['getReturnOrderInfo'][0])
    {




        $resourcePath = '/api/ProcessedOrders/GetReturnOrderInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_refund_link,
            'includeRefundLink', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnsExchanges
     *
     * GetReturnsExchanges
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnsExchanges'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ReturnInfo[]
     */
    public function getReturnsExchanges($pk_order_id = null, string $contentType = self::contentTypes['getReturnsExchanges'][0])
    {
        list($response) = $this->getReturnsExchangesWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getReturnsExchangesWithHttpInfo
     *
     * GetReturnsExchanges
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnsExchanges'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ReturnInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnsExchangesWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getReturnsExchanges'][0])
    {
        $request = $this->getReturnsExchangesRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ReturnInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ReturnInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ReturnInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnsExchangesAsync
     *
     * GetReturnsExchanges
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnsExchanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnsExchangesAsync($pk_order_id = null, string $contentType = self::contentTypes['getReturnsExchanges'][0])
    {
        return $this->getReturnsExchangesAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnsExchangesAsyncWithHttpInfo
     *
     * GetReturnsExchanges
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnsExchanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnsExchangesAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getReturnsExchanges'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ReturnInfo[]';
        $request = $this->getReturnsExchangesRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnsExchanges'
     *
     * @param  string|null $pk_order_id The order id to get the returns for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnsExchanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnsExchangesRequest($pk_order_id = null, string $contentType = self::contentTypes['getReturnsExchanges'][0])
    {



        $resourcePath = '/api/ProcessedOrders/GetReturnsExchanges';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTotalRefunds
     *
     * GetTotalRefunds
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  bool|null $include_bookings If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ExistingRefundTotal
     */
    public function getTotalRefunds($pk_order_id = null, $include_bookings = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        list($response) = $this->getTotalRefundsWithHttpInfo($pk_order_id, $include_bookings, $contentType);
        return $response;
    }

    /**
     * Operation getTotalRefundsWithHttpInfo
     *
     * GetTotalRefunds
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  bool|null $include_bookings If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ExistingRefundTotal, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTotalRefundsWithHttpInfo($pk_order_id = null, $include_bookings = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        $request = $this->getTotalRefundsRequest($pk_order_id, $include_bookings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ExistingRefundTotal' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ExistingRefundTotal' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ExistingRefundTotal', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ExistingRefundTotal';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ExistingRefundTotal',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTotalRefundsAsync
     *
     * GetTotalRefunds
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  bool|null $include_bookings If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTotalRefundsAsync($pk_order_id = null, $include_bookings = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        return $this->getTotalRefundsAsyncWithHttpInfo($pk_order_id, $include_bookings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTotalRefundsAsyncWithHttpInfo
     *
     * GetTotalRefunds
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  bool|null $include_bookings If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTotalRefundsAsyncWithHttpInfo($pk_order_id = null, $include_bookings = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ExistingRefundTotal';
        $request = $this->getTotalRefundsRequest($pk_order_id, $include_bookings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTotalRefunds'
     *
     * @param  string|null $pk_order_id The id of the order (optional)
     * @param  bool|null $include_bookings If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTotalRefundsRequest($pk_order_id = null, $include_bookings = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {




        $resourcePath = '/api/ProcessedOrders/GetTotalRefunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_bookings,
            'includeBookings', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation isRefundValid
     *
     * IsRefundValid
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest $processed_orders_is_refund_valid_request processed_orders_is_refund_valid_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValid'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ValidationResult
     */
    public function isRefundValid($processed_orders_is_refund_valid_request, string $contentType = self::contentTypes['isRefundValid'][0])
    {
        list($response) = $this->isRefundValidWithHttpInfo($processed_orders_is_refund_valid_request, $contentType);
        return $response;
    }

    /**
     * Operation isRefundValidWithHttpInfo
     *
     * IsRefundValid
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest $processed_orders_is_refund_valid_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValid'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ValidationResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function isRefundValidWithHttpInfo($processed_orders_is_refund_valid_request, string $contentType = self::contentTypes['isRefundValid'][0])
    {
        $request = $this->isRefundValidRequest($processed_orders_is_refund_valid_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ValidationResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ValidationResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ValidationResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ValidationResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ValidationResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation isRefundValidAsync
     *
     * IsRefundValid
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest $processed_orders_is_refund_valid_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isRefundValidAsync($processed_orders_is_refund_valid_request, string $contentType = self::contentTypes['isRefundValid'][0])
    {
        return $this->isRefundValidAsyncWithHttpInfo($processed_orders_is_refund_valid_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation isRefundValidAsyncWithHttpInfo
     *
     * IsRefundValid
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest $processed_orders_is_refund_valid_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isRefundValidAsyncWithHttpInfo($processed_orders_is_refund_valid_request, string $contentType = self::contentTypes['isRefundValid'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ValidationResult';
        $request = $this->isRefundValidRequest($processed_orders_is_refund_valid_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'isRefundValid'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest $processed_orders_is_refund_valid_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function isRefundValidRequest($processed_orders_is_refund_valid_request, string $contentType = self::contentTypes['isRefundValid'][0])
    {

        // verify the required parameter 'processed_orders_is_refund_valid_request' is set
        if ($processed_orders_is_refund_valid_request === null || (is_array($processed_orders_is_refund_valid_request) && count($processed_orders_is_refund_valid_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_is_refund_valid_request when calling isRefundValid'
            );
        }


        $resourcePath = '/api/ProcessedOrders/IsRefundValid';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_is_refund_valid_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_is_refund_valid_request));
            } else {
                $httpBody = $processed_orders_is_refund_valid_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation isRefundValidationRequiredByOrderId
     *
     * IsRefundValidationRequiredByOrderId
     *
     * @param  string|null $pk_order_id The order id of the order which requires validation (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValidationRequiredByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function isRefundValidationRequiredByOrderId($pk_order_id = null, string $contentType = self::contentTypes['isRefundValidationRequiredByOrderId'][0])
    {
        list($response) = $this->isRefundValidationRequiredByOrderIdWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation isRefundValidationRequiredByOrderIdWithHttpInfo
     *
     * IsRefundValidationRequiredByOrderId
     *
     * @param  string|null $pk_order_id The order id of the order which requires validation (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValidationRequiredByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function isRefundValidationRequiredByOrderIdWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['isRefundValidationRequiredByOrderId'][0])
    {
        $request = $this->isRefundValidationRequiredByOrderIdRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('bool' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('bool' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'bool', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'bool';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation isRefundValidationRequiredByOrderIdAsync
     *
     * IsRefundValidationRequiredByOrderId
     *
     * @param  string|null $pk_order_id The order id of the order which requires validation (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValidationRequiredByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isRefundValidationRequiredByOrderIdAsync($pk_order_id = null, string $contentType = self::contentTypes['isRefundValidationRequiredByOrderId'][0])
    {
        return $this->isRefundValidationRequiredByOrderIdAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation isRefundValidationRequiredByOrderIdAsyncWithHttpInfo
     *
     * IsRefundValidationRequiredByOrderId
     *
     * @param  string|null $pk_order_id The order id of the order which requires validation (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValidationRequiredByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isRefundValidationRequiredByOrderIdAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['isRefundValidationRequiredByOrderId'][0])
    {
        $returnType = 'bool';
        $request = $this->isRefundValidationRequiredByOrderIdRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'isRefundValidationRequiredByOrderId'
     *
     * @param  string|null $pk_order_id The order id of the order which requires validation (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isRefundValidationRequiredByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function isRefundValidationRequiredByOrderIdRequest($pk_order_id = null, string $contentType = self::contentTypes['isRefundValidationRequiredByOrderId'][0])
    {



        $resourcePath = '/api/ProcessedOrders/IsRefundValidationRequiredByOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation markManualRefundsAsActioned
     *
     * MarkManualRefundsAsActioned
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest $processed_orders_mark_manual_refunds_as_actioned_request processed_orders_mark_manual_refunds_as_actioned_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markManualRefundsAsActioned'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function markManualRefundsAsActioned($processed_orders_mark_manual_refunds_as_actioned_request, string $contentType = self::contentTypes['markManualRefundsAsActioned'][0])
    {
        $this->markManualRefundsAsActionedWithHttpInfo($processed_orders_mark_manual_refunds_as_actioned_request, $contentType);
    }

    /**
     * Operation markManualRefundsAsActionedWithHttpInfo
     *
     * MarkManualRefundsAsActioned
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest $processed_orders_mark_manual_refunds_as_actioned_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markManualRefundsAsActioned'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function markManualRefundsAsActionedWithHttpInfo($processed_orders_mark_manual_refunds_as_actioned_request, string $contentType = self::contentTypes['markManualRefundsAsActioned'][0])
    {
        $request = $this->markManualRefundsAsActionedRequest($processed_orders_mark_manual_refunds_as_actioned_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation markManualRefundsAsActionedAsync
     *
     * MarkManualRefundsAsActioned
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest $processed_orders_mark_manual_refunds_as_actioned_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markManualRefundsAsActioned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markManualRefundsAsActionedAsync($processed_orders_mark_manual_refunds_as_actioned_request, string $contentType = self::contentTypes['markManualRefundsAsActioned'][0])
    {
        return $this->markManualRefundsAsActionedAsyncWithHttpInfo($processed_orders_mark_manual_refunds_as_actioned_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation markManualRefundsAsActionedAsyncWithHttpInfo
     *
     * MarkManualRefundsAsActioned
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest $processed_orders_mark_manual_refunds_as_actioned_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markManualRefundsAsActioned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markManualRefundsAsActionedAsyncWithHttpInfo($processed_orders_mark_manual_refunds_as_actioned_request, string $contentType = self::contentTypes['markManualRefundsAsActioned'][0])
    {
        $returnType = '';
        $request = $this->markManualRefundsAsActionedRequest($processed_orders_mark_manual_refunds_as_actioned_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'markManualRefundsAsActioned'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest $processed_orders_mark_manual_refunds_as_actioned_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markManualRefundsAsActioned'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function markManualRefundsAsActionedRequest($processed_orders_mark_manual_refunds_as_actioned_request, string $contentType = self::contentTypes['markManualRefundsAsActioned'][0])
    {

        // verify the required parameter 'processed_orders_mark_manual_refunds_as_actioned_request' is set
        if ($processed_orders_mark_manual_refunds_as_actioned_request === null || (is_array($processed_orders_mark_manual_refunds_as_actioned_request) && count($processed_orders_mark_manual_refunds_as_actioned_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_mark_manual_refunds_as_actioned_request when calling markManualRefundsAsActioned'
            );
        }


        $resourcePath = '/api/ProcessedOrders/MarkManualRefundsAsActioned';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_mark_manual_refunds_as_actioned_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_mark_manual_refunds_as_actioned_request));
            } else {
                $httpBody = $processed_orders_mark_manual_refunds_as_actioned_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation refundFreeText
     *
     * RefundFreeText
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest $processed_orders_refund_free_text_request processed_orders_refund_free_text_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundFreeText'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\RefundInfo[]
     */
    public function refundFreeText($processed_orders_refund_free_text_request, string $contentType = self::contentTypes['refundFreeText'][0])
    {
        list($response) = $this->refundFreeTextWithHttpInfo($processed_orders_refund_free_text_request, $contentType);
        return $response;
    }

    /**
     * Operation refundFreeTextWithHttpInfo
     *
     * RefundFreeText
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest $processed_orders_refund_free_text_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundFreeText'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\RefundInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function refundFreeTextWithHttpInfo($processed_orders_refund_free_text_request, string $contentType = self::contentTypes['refundFreeText'][0])
    {
        $request = $this->refundFreeTextRequest($processed_orders_refund_free_text_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\RefundInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\RefundInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation refundFreeTextAsync
     *
     * RefundFreeText
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest $processed_orders_refund_free_text_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundFreeText'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundFreeTextAsync($processed_orders_refund_free_text_request, string $contentType = self::contentTypes['refundFreeText'][0])
    {
        return $this->refundFreeTextAsyncWithHttpInfo($processed_orders_refund_free_text_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation refundFreeTextAsyncWithHttpInfo
     *
     * RefundFreeText
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest $processed_orders_refund_free_text_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundFreeText'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundFreeTextAsyncWithHttpInfo($processed_orders_refund_free_text_request, string $contentType = self::contentTypes['refundFreeText'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
        $request = $this->refundFreeTextRequest($processed_orders_refund_free_text_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'refundFreeText'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest $processed_orders_refund_free_text_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundFreeText'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function refundFreeTextRequest($processed_orders_refund_free_text_request, string $contentType = self::contentTypes['refundFreeText'][0])
    {

        // verify the required parameter 'processed_orders_refund_free_text_request' is set
        if ($processed_orders_refund_free_text_request === null || (is_array($processed_orders_refund_free_text_request) && count($processed_orders_refund_free_text_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_refund_free_text_request when calling refundFreeText'
            );
        }


        $resourcePath = '/api/ProcessedOrders/RefundFreeText';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_refund_free_text_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_refund_free_text_request));
            } else {
                $httpBody = $processed_orders_refund_free_text_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation refundServices
     *
     * RefundServices
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest $processed_orders_refund_services_request processed_orders_refund_services_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundServices'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\RefundInfo[]
     */
    public function refundServices($processed_orders_refund_services_request, string $contentType = self::contentTypes['refundServices'][0])
    {
        list($response) = $this->refundServicesWithHttpInfo($processed_orders_refund_services_request, $contentType);
        return $response;
    }

    /**
     * Operation refundServicesWithHttpInfo
     *
     * RefundServices
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest $processed_orders_refund_services_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundServices'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\RefundInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function refundServicesWithHttpInfo($processed_orders_refund_services_request, string $contentType = self::contentTypes['refundServices'][0])
    {
        $request = $this->refundServicesRequest($processed_orders_refund_services_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\RefundInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\RefundInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation refundServicesAsync
     *
     * RefundServices
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest $processed_orders_refund_services_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundServicesAsync($processed_orders_refund_services_request, string $contentType = self::contentTypes['refundServices'][0])
    {
        return $this->refundServicesAsyncWithHttpInfo($processed_orders_refund_services_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation refundServicesAsyncWithHttpInfo
     *
     * RefundServices
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest $processed_orders_refund_services_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundServicesAsyncWithHttpInfo($processed_orders_refund_services_request, string $contentType = self::contentTypes['refundServices'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
        $request = $this->refundServicesRequest($processed_orders_refund_services_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'refundServices'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest $processed_orders_refund_services_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundServices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function refundServicesRequest($processed_orders_refund_services_request, string $contentType = self::contentTypes['refundServices'][0])
    {

        // verify the required parameter 'processed_orders_refund_services_request' is set
        if ($processed_orders_refund_services_request === null || (is_array($processed_orders_refund_services_request) && count($processed_orders_refund_services_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_refund_services_request when calling refundServices'
            );
        }


        $resourcePath = '/api/ProcessedOrders/RefundServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_refund_services_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_refund_services_request));
            } else {
                $httpBody = $processed_orders_refund_services_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation refundShipping
     *
     * RefundShipping
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest $processed_orders_refund_shipping_request processed_orders_refund_shipping_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundShipping'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\RefundInfo[]
     */
    public function refundShipping($processed_orders_refund_shipping_request, string $contentType = self::contentTypes['refundShipping'][0])
    {
        list($response) = $this->refundShippingWithHttpInfo($processed_orders_refund_shipping_request, $contentType);
        return $response;
    }

    /**
     * Operation refundShippingWithHttpInfo
     *
     * RefundShipping
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest $processed_orders_refund_shipping_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundShipping'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\RefundInfo[], HTTP status code, HTTP response headers (array of strings)
     */
    public function refundShippingWithHttpInfo($processed_orders_refund_shipping_request, string $contentType = self::contentTypes['refundShipping'][0])
    {
        $request = $this->refundShippingRequest($processed_orders_refund_shipping_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\RefundInfo[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\RefundInfo[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\RefundInfo[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation refundShippingAsync
     *
     * RefundShipping
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest $processed_orders_refund_shipping_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundShipping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundShippingAsync($processed_orders_refund_shipping_request, string $contentType = self::contentTypes['refundShipping'][0])
    {
        return $this->refundShippingAsyncWithHttpInfo($processed_orders_refund_shipping_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation refundShippingAsyncWithHttpInfo
     *
     * RefundShipping
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest $processed_orders_refund_shipping_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundShipping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundShippingAsyncWithHttpInfo($processed_orders_refund_shipping_request, string $contentType = self::contentTypes['refundShipping'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\RefundInfo[]';
        $request = $this->refundShippingRequest($processed_orders_refund_shipping_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'refundShipping'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest $processed_orders_refund_shipping_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundShipping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function refundShippingRequest($processed_orders_refund_shipping_request, string $contentType = self::contentTypes['refundShipping'][0])
    {

        // verify the required parameter 'processed_orders_refund_shipping_request' is set
        if ($processed_orders_refund_shipping_request === null || (is_array($processed_orders_refund_shipping_request) && count($processed_orders_refund_shipping_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_refund_shipping_request when calling refundShipping'
            );
        }


        $resourcePath = '/api/ProcessedOrders/RefundShipping';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_refund_shipping_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_refund_shipping_request));
            } else {
                $httpBody = $processed_orders_refund_shipping_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation renameReturnCategory
     *
     * RenameReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest $processed_orders_rename_return_category_request processed_orders_rename_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function renameReturnCategory($processed_orders_rename_return_category_request, string $contentType = self::contentTypes['renameReturnCategory'][0])
    {
        $this->renameReturnCategoryWithHttpInfo($processed_orders_rename_return_category_request, $contentType);
    }

    /**
     * Operation renameReturnCategoryWithHttpInfo
     *
     * RenameReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest $processed_orders_rename_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameReturnCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function renameReturnCategoryWithHttpInfo($processed_orders_rename_return_category_request, string $contentType = self::contentTypes['renameReturnCategory'][0])
    {
        $request = $this->renameReturnCategoryRequest($processed_orders_rename_return_category_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation renameReturnCategoryAsync
     *
     * RenameReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest $processed_orders_rename_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameReturnCategoryAsync($processed_orders_rename_return_category_request, string $contentType = self::contentTypes['renameReturnCategory'][0])
    {
        return $this->renameReturnCategoryAsyncWithHttpInfo($processed_orders_rename_return_category_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation renameReturnCategoryAsyncWithHttpInfo
     *
     * RenameReturnCategory
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest $processed_orders_rename_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameReturnCategoryAsyncWithHttpInfo($processed_orders_rename_return_category_request, string $contentType = self::contentTypes['renameReturnCategory'][0])
    {
        $returnType = '';
        $request = $this->renameReturnCategoryRequest($processed_orders_rename_return_category_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'renameReturnCategory'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest $processed_orders_rename_return_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameReturnCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function renameReturnCategoryRequest($processed_orders_rename_return_category_request, string $contentType = self::contentTypes['renameReturnCategory'][0])
    {

        // verify the required parameter 'processed_orders_rename_return_category_request' is set
        if ($processed_orders_rename_return_category_request === null || (is_array($processed_orders_rename_return_category_request) && count($processed_orders_rename_return_category_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_rename_return_category_request when calling renameReturnCategory'
            );
        }


        $resourcePath = '/api/ProcessedOrders/RenameReturnCategory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_rename_return_category_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_rename_return_category_request));
            } else {
                $httpBody = $processed_orders_rename_return_category_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchProcessedOrders
     *
     * SearchProcessedOrders
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest $processed_orders_search_processed_orders_request processed_orders_search_processed_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse
     */
    public function searchProcessedOrders($processed_orders_search_processed_orders_request, string $contentType = self::contentTypes['searchProcessedOrders'][0])
    {
        list($response) = $this->searchProcessedOrdersWithHttpInfo($processed_orders_search_processed_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation searchProcessedOrdersWithHttpInfo
     *
     * SearchProcessedOrders
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest $processed_orders_search_processed_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchProcessedOrdersWithHttpInfo($processed_orders_search_processed_orders_request, string $contentType = self::contentTypes['searchProcessedOrders'][0])
    {
        $request = $this->searchProcessedOrdersRequest($processed_orders_search_processed_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchProcessedOrdersAsync
     *
     * SearchProcessedOrders
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest $processed_orders_search_processed_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchProcessedOrdersAsync($processed_orders_search_processed_orders_request, string $contentType = self::contentTypes['searchProcessedOrders'][0])
    {
        return $this->searchProcessedOrdersAsyncWithHttpInfo($processed_orders_search_processed_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchProcessedOrdersAsyncWithHttpInfo
     *
     * SearchProcessedOrders
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest $processed_orders_search_processed_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchProcessedOrdersAsyncWithHttpInfo($processed_orders_search_processed_orders_request, string $contentType = self::contentTypes['searchProcessedOrders'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse';
        $request = $this->searchProcessedOrdersRequest($processed_orders_search_processed_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchProcessedOrders'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest $processed_orders_search_processed_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchProcessedOrdersRequest($processed_orders_search_processed_orders_request, string $contentType = self::contentTypes['searchProcessedOrders'][0])
    {

        // verify the required parameter 'processed_orders_search_processed_orders_request' is set
        if ($processed_orders_search_processed_orders_request === null || (is_array($processed_orders_search_processed_orders_request) && count($processed_orders_search_processed_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_search_processed_orders_request when calling searchProcessedOrders'
            );
        }


        $resourcePath = '/api/ProcessedOrders/SearchProcessedOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_search_processed_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_search_processed_orders_request));
            } else {
                $httpBody = $processed_orders_search_processed_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchProcessedOrdersPaged
     *
     * SearchProcessedOrdersPaged
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest $processed_orders_search_processed_orders_paged_request processed_orders_search_processed_orders_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrdersPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb
     * @deprecated
     */
    public function searchProcessedOrdersPaged($processed_orders_search_processed_orders_paged_request, string $contentType = self::contentTypes['searchProcessedOrdersPaged'][0])
    {
        list($response) = $this->searchProcessedOrdersPagedWithHttpInfo($processed_orders_search_processed_orders_paged_request, $contentType);
        return $response;
    }

    /**
     * Operation searchProcessedOrdersPagedWithHttpInfo
     *
     * SearchProcessedOrdersPaged
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest $processed_orders_search_processed_orders_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrdersPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function searchProcessedOrdersPagedWithHttpInfo($processed_orders_search_processed_orders_paged_request, string $contentType = self::contentTypes['searchProcessedOrdersPaged'][0])
    {
        $request = $this->searchProcessedOrdersPagedRequest($processed_orders_search_processed_orders_paged_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchProcessedOrdersPagedAsync
     *
     * SearchProcessedOrdersPaged
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest $processed_orders_search_processed_orders_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrdersPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function searchProcessedOrdersPagedAsync($processed_orders_search_processed_orders_paged_request, string $contentType = self::contentTypes['searchProcessedOrdersPaged'][0])
    {
        return $this->searchProcessedOrdersPagedAsyncWithHttpInfo($processed_orders_search_processed_orders_paged_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchProcessedOrdersPagedAsyncWithHttpInfo
     *
     * SearchProcessedOrdersPaged
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest $processed_orders_search_processed_orders_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrdersPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function searchProcessedOrdersPagedAsyncWithHttpInfo($processed_orders_search_processed_orders_paged_request, string $contentType = self::contentTypes['searchProcessedOrdersPaged'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb';
        $request = $this->searchProcessedOrdersPagedRequest($processed_orders_search_processed_orders_paged_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchProcessedOrdersPaged'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest $processed_orders_search_processed_orders_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProcessedOrdersPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function searchProcessedOrdersPagedRequest($processed_orders_search_processed_orders_paged_request, string $contentType = self::contentTypes['searchProcessedOrdersPaged'][0])
    {

        // verify the required parameter 'processed_orders_search_processed_orders_paged_request' is set
        if ($processed_orders_search_processed_orders_paged_request === null || (is_array($processed_orders_search_processed_orders_paged_request) && count($processed_orders_search_processed_orders_paged_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_search_processed_orders_paged_request when calling searchProcessedOrdersPaged'
            );
        }


        $resourcePath = '/api/ProcessedOrders/SearchProcessedOrdersPaged';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_search_processed_orders_paged_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_search_processed_orders_paged_request));
            } else {
                $httpBody = $processed_orders_search_processed_orders_paged_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation validateCompleteOrderRefund
     *
     * ValidateCompleteOrderRefund
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest $processed_orders_validate_complete_order_refund_request processed_orders_validate_complete_order_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validateCompleteOrderRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ProcessedOrders\Model\ValidationResult
     */
    public function validateCompleteOrderRefund($processed_orders_validate_complete_order_refund_request, string $contentType = self::contentTypes['validateCompleteOrderRefund'][0])
    {
        list($response) = $this->validateCompleteOrderRefundWithHttpInfo($processed_orders_validate_complete_order_refund_request, $contentType);
        return $response;
    }

    /**
     * Operation validateCompleteOrderRefundWithHttpInfo
     *
     * ValidateCompleteOrderRefund
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest $processed_orders_validate_complete_order_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validateCompleteOrderRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ProcessedOrders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ProcessedOrders\Model\ValidationResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function validateCompleteOrderRefundWithHttpInfo($processed_orders_validate_complete_order_refund_request, string $contentType = self::contentTypes['validateCompleteOrderRefund'][0])
    {
        $request = $this->validateCompleteOrderRefundRequest($processed_orders_validate_complete_order_refund_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ProcessedOrders\Model\ValidationResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ProcessedOrders\Model\ValidationResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ProcessedOrders\Model\ValidationResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ProcessedOrders\Model\ValidationResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ProcessedOrders\Model\ValidationResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation validateCompleteOrderRefundAsync
     *
     * ValidateCompleteOrderRefund
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest $processed_orders_validate_complete_order_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validateCompleteOrderRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function validateCompleteOrderRefundAsync($processed_orders_validate_complete_order_refund_request, string $contentType = self::contentTypes['validateCompleteOrderRefund'][0])
    {
        return $this->validateCompleteOrderRefundAsyncWithHttpInfo($processed_orders_validate_complete_order_refund_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation validateCompleteOrderRefundAsyncWithHttpInfo
     *
     * ValidateCompleteOrderRefund
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest $processed_orders_validate_complete_order_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validateCompleteOrderRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function validateCompleteOrderRefundAsyncWithHttpInfo($processed_orders_validate_complete_order_refund_request, string $contentType = self::contentTypes['validateCompleteOrderRefund'][0])
    {
        $returnType = '\Linnworks\ProcessedOrders\Model\ValidationResult';
        $request = $this->validateCompleteOrderRefundRequest($processed_orders_validate_complete_order_refund_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'validateCompleteOrderRefund'
     *
     * @param  \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest $processed_orders_validate_complete_order_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validateCompleteOrderRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function validateCompleteOrderRefundRequest($processed_orders_validate_complete_order_refund_request, string $contentType = self::contentTypes['validateCompleteOrderRefund'][0])
    {

        // verify the required parameter 'processed_orders_validate_complete_order_refund_request' is set
        if ($processed_orders_validate_complete_order_refund_request === null || (is_array($processed_orders_validate_complete_order_refund_request) && count($processed_orders_validate_complete_order_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $processed_orders_validate_complete_order_refund_request when calling validateCompleteOrderRefund'
            );
        }


        $resourcePath = '/api/ProcessedOrders/ValidateCompleteOrderRefund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($processed_orders_validate_complete_order_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($processed_orders_validate_complete_order_refund_request));
            } else {
                $httpBody = $processed_orders_validate_complete_order_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
