# Linnworks\ProcessedOrders\ProcessedOrdersApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addOrderNote()**](ProcessedOrdersApi.md#addOrderNote) | **POST** /api/ProcessedOrders/AddOrderNote | AddOrderNote |
| [**addReturnCategory()**](ProcessedOrdersApi.md#addReturnCategory) | **POST** /api/ProcessedOrders/AddReturnCategory | AddReturnCategory |
| [**changeOrderNote()**](ProcessedOrdersApi.md#changeOrderNote) | **POST** /api/ProcessedOrders/ChangeOrderNote | ChangeOrderNote |
| [**checkOrderFullyReturned()**](ProcessedOrdersApi.md#checkOrderFullyReturned) | **GET** /api/ProcessedOrders/CheckOrderFullyReturned | CheckOrderFullyReturned |
| [**createExchange()**](ProcessedOrdersApi.md#createExchange) | **POST** /api/ProcessedOrders/CreateExchange | CreateExchange |
| [**createFullResend()**](ProcessedOrdersApi.md#createFullResend) | **POST** /api/ProcessedOrders/CreateFullResend | CreateFullResend |
| [**createResend()**](ProcessedOrdersApi.md#createResend) | **POST** /api/ProcessedOrders/CreateResend | CreateResend |
| [**deleteOrderNote()**](ProcessedOrdersApi.md#deleteOrderNote) | **POST** /api/ProcessedOrders/DeleteOrderNote | DeleteOrderNote |
| [**deleteReturnCategory()**](ProcessedOrdersApi.md#deleteReturnCategory) | **POST** /api/ProcessedOrders/DeleteReturnCategory | DeleteReturnCategory |
| [**downloadOrdersToCSV()**](ProcessedOrdersApi.md#downloadOrdersToCSV) | **POST** /api/ProcessedOrders/DownloadOrdersToCSV | DownloadOrdersToCSV |
| [**getChannelRefundReasons()**](ProcessedOrdersApi.md#getChannelRefundReasons) | **GET** /api/ProcessedOrders/GetChannelRefundReasons | GetChannelRefundReasons |
| [**getOrderInfo()**](ProcessedOrdersApi.md#getOrderInfo) | **GET** /api/ProcessedOrders/GetOrderInfo | GetOrderInfo |
| [**getOrderTrackingURLs()**](ProcessedOrdersApi.md#getOrderTrackingURLs) | **POST** /api/ProcessedOrders/GetOrderTrackingURLs | GetOrderTrackingURLs |
| [**getPackageSplit()**](ProcessedOrdersApi.md#getPackageSplit) | **GET** /api/ProcessedOrders/GetPackageSplit | GetPackageSplit |
| [**getProcessedAuditTrail()**](ProcessedOrdersApi.md#getProcessedAuditTrail) | **GET** /api/ProcessedOrders/GetProcessedAuditTrail | GetProcessedAuditTrail |
| [**getProcessedOrderExtendedProperties()**](ProcessedOrdersApi.md#getProcessedOrderExtendedProperties) | **GET** /api/ProcessedOrders/GetProcessedOrderExtendedProperties | GetProcessedOrderExtendedProperties |
| [**getProcessedOrderNotes()**](ProcessedOrdersApi.md#getProcessedOrderNotes) | **GET** /api/ProcessedOrders/GetProcessedOrderNotes | GetProcessedOrderNotes |
| [**getProcessedRelatives()**](ProcessedOrdersApi.md#getProcessedRelatives) | **GET** /api/ProcessedOrders/GetProcessedRelatives | GetProcessedRelatives |
| [**getRefundableServiceItems()**](ProcessedOrdersApi.md#getRefundableServiceItems) | **GET** /api/ProcessedOrders/GetRefundableServiceItems | GetRefundableServiceItems |
| [**getRefunds()**](ProcessedOrdersApi.md#getRefunds) | **GET** /api/ProcessedOrders/GetRefunds | GetRefunds |
| [**getRefundsOptions()**](ProcessedOrdersApi.md#getRefundsOptions) | **GET** /api/ProcessedOrders/GetRefundsOptions | GetRefundsOptions |
| [**getReturnCategories()**](ProcessedOrdersApi.md#getReturnCategories) | **GET** /api/ProcessedOrders/GetReturnCategories | GetReturnCategories |
| [**getReturnItemsInfo()**](ProcessedOrdersApi.md#getReturnItemsInfo) | **GET** /api/ProcessedOrders/GetReturnItemsInfo | GetReturnItemsInfo |
| [**getReturnOrderInfo()**](ProcessedOrdersApi.md#getReturnOrderInfo) | **GET** /api/ProcessedOrders/GetReturnOrderInfo | GetReturnOrderInfo |
| [**getReturnsExchanges()**](ProcessedOrdersApi.md#getReturnsExchanges) | **GET** /api/ProcessedOrders/GetReturnsExchanges | GetReturnsExchanges |
| [**getTotalRefunds()**](ProcessedOrdersApi.md#getTotalRefunds) | **GET** /api/ProcessedOrders/GetTotalRefunds | GetTotalRefunds |
| [**isRefundValid()**](ProcessedOrdersApi.md#isRefundValid) | **POST** /api/ProcessedOrders/IsRefundValid | IsRefundValid |
| [**isRefundValidationRequiredByOrderId()**](ProcessedOrdersApi.md#isRefundValidationRequiredByOrderId) | **GET** /api/ProcessedOrders/IsRefundValidationRequiredByOrderId | IsRefundValidationRequiredByOrderId |
| [**markManualRefundsAsActioned()**](ProcessedOrdersApi.md#markManualRefundsAsActioned) | **POST** /api/ProcessedOrders/MarkManualRefundsAsActioned | MarkManualRefundsAsActioned |
| [**refundFreeText()**](ProcessedOrdersApi.md#refundFreeText) | **POST** /api/ProcessedOrders/RefundFreeText | RefundFreeText |
| [**refundServices()**](ProcessedOrdersApi.md#refundServices) | **POST** /api/ProcessedOrders/RefundServices | RefundServices |
| [**refundShipping()**](ProcessedOrdersApi.md#refundShipping) | **POST** /api/ProcessedOrders/RefundShipping | RefundShipping |
| [**renameReturnCategory()**](ProcessedOrdersApi.md#renameReturnCategory) | **POST** /api/ProcessedOrders/RenameReturnCategory | RenameReturnCategory |
| [**searchProcessedOrders()**](ProcessedOrdersApi.md#searchProcessedOrders) | **POST** /api/ProcessedOrders/SearchProcessedOrders | SearchProcessedOrders |
| [**searchProcessedOrdersPaged()**](ProcessedOrdersApi.md#searchProcessedOrdersPaged) | **POST** /api/ProcessedOrders/SearchProcessedOrdersPaged | SearchProcessedOrdersPaged |
| [**validateCompleteOrderRefund()**](ProcessedOrdersApi.md#validateCompleteOrderRefund) | **POST** /api/ProcessedOrders/ValidateCompleteOrderRefund | ValidateCompleteOrderRefund |


## `addOrderNote()`

```php
addOrderNote($processed_orders_add_order_note_request): string
```

AddOrderNote

Use this call to add a new note to an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_add_order_note_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest

try {
    $result = $apiInstance->addOrderNote($processed_orders_add_order_note_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->addOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_add_order_note_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest**](../Model/ProcessedOrdersAddOrderNoteRequest.md)|  | |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addReturnCategory()`

```php
addReturnCategory($processed_orders_add_return_category_request): \Linnworks\ProcessedOrders\Model\OrderReturnCategory
```

AddReturnCategory

Use this call to add a new return category. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_add_return_category_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest

try {
    $result = $apiInstance->addReturnCategory($processed_orders_add_return_category_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->addReturnCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_add_return_category_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersAddReturnCategoryRequest**](../Model/ProcessedOrdersAddReturnCategoryRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\OrderReturnCategory**](../Model/OrderReturnCategory.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `changeOrderNote()`

```php
changeOrderNote($processed_orders_change_order_note_request)
```

ChangeOrderNote

Edit an existing order note <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_change_order_note_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest

try {
    $apiInstance->changeOrderNote($processed_orders_change_order_note_request);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->changeOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_change_order_note_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersChangeOrderNoteRequest**](../Model/ProcessedOrdersChangeOrderNoteRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `checkOrderFullyReturned()`

```php
checkOrderFullyReturned($pk_order_id): bool
```

CheckOrderFullyReturned

Checks if order was fully returned <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | Primary key for an order

try {
    $result = $apiInstance->checkOrderFullyReturned($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->checkOrderFullyReturned: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| Primary key for an order | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createExchange()`

```php
createExchange($processed_orders_create_exchange_request): \Linnworks\ProcessedOrders\Model\ReturnInfo[]
```

CreateExchange

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_create_exchange_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest

try {
    $result = $apiInstance->createExchange($processed_orders_create_exchange_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->createExchange: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_create_exchange_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateExchangeRequest**](../Model/ProcessedOrdersCreateExchangeRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\ReturnInfo[]**](../Model/ReturnInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createFullResend()`

```php
createFullResend($processed_orders_create_full_resend_request): \Linnworks\ProcessedOrders\Model\ReturnInfo[]
```

CreateFullResend

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_create_full_resend_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest

try {
    $result = $apiInstance->createFullResend($processed_orders_create_full_resend_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->createFullResend: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_create_full_resend_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateFullResendRequest**](../Model/ProcessedOrdersCreateFullResendRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\ReturnInfo[]**](../Model/ReturnInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createResend()`

```php
createResend($processed_orders_create_resend_request): \Linnworks\ProcessedOrders\Model\ReturnInfo[]
```

CreateResend

Creates a resend <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_create_resend_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest

try {
    $result = $apiInstance->createResend($processed_orders_create_resend_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->createResend: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_create_resend_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersCreateResendRequest**](../Model/ProcessedOrdersCreateResendRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\ReturnInfo[]**](../Model/ReturnInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrderNote()`

```php
deleteOrderNote($processed_orders_delete_order_note_request)
```

DeleteOrderNote

Delete an existing order note <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_delete_order_note_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest

try {
    $apiInstance->deleteOrderNote($processed_orders_delete_order_note_request);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->deleteOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_delete_order_note_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteOrderNoteRequest**](../Model/ProcessedOrdersDeleteOrderNoteRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteReturnCategory()`

```php
deleteReturnCategory($processed_orders_delete_return_category_request)
```

DeleteReturnCategory

Use this call to delete an existing return category. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_delete_return_category_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest

try {
    $apiInstance->deleteReturnCategory($processed_orders_delete_return_category_request);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->deleteReturnCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_delete_return_category_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersDeleteReturnCategoryRequest**](../Model/ProcessedOrdersDeleteReturnCategoryRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `downloadOrdersToCSV()`

```php
downloadOrdersToCSV($processed_orders_download_orders_to_csv_request): \Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse
```

DownloadOrdersToCSV

Download Processed Orders to CSV <b>Permissions Required: </b> GlobalPermissions.OrderBook.ProcessedOrders.DownloadProcessedOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_download_orders_to_csv_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest

try {
    $result = $apiInstance->downloadOrdersToCSV($processed_orders_download_orders_to_csv_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->downloadOrdersToCSV: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_download_orders_to_csv_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersDownloadOrdersToCSVRequest**](../Model/ProcessedOrdersDownloadOrdersToCSVRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\DownloadOrdersToCSVResponse**](../Model/DownloadOrdersToCSVResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getChannelRefundReasons()`

```php
getChannelRefundReasons($pk_order_id): \Linnworks\ProcessedOrders\Model\ChannelRefundReason[]
```

GetChannelRefundReasons

Use this call to get a list of valid channel refund reasons for a given order. These are needed for channel refunds. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id to get reasons for

try {
    $result = $apiInstance->getChannelRefundReasons($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getChannelRefundReasons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id to get reasons for | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ChannelRefundReason[]**](../Model/ChannelRefundReason.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderInfo()`

```php
getOrderInfo($pk_order_id): \Linnworks\ProcessedOrders\Model\ProcessedOrderWeb
```

GetOrderInfo

Use this call to retrieve detailed information about a processed order (header level). <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The id of the order.

try {
    $result = $apiInstance->getOrderInfo($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getOrderInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The id of the order. | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ProcessedOrderWeb**](../Model/ProcessedOrderWeb.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderTrackingURLs()`

```php
getOrderTrackingURLs($request): \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse
```

GetOrderTrackingURLs

Use this call to retrieve detailed TrackingURL for orders Vendor and TrackingNumber. <b>Permissions Required: </b> GlobalPermissions.OrderBook.ProcessedOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest(); // \Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest | The request for TrackingURL.

try {
    $result = $apiInstance->getOrderTrackingURLs($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getOrderTrackingURLs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsRequest**](../Model/GetOrderTrackingURLsRequest.md)| The request for TrackingURL. | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\GetOrderTrackingURLsResponse**](../Model/GetOrderTrackingURLsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPackageSplit()`

```php
getPackageSplit($pk_order_id): \Linnworks\ProcessedOrders\Model\SplitPackaging[]
```

GetPackageSplit

Use this call to get split packaging information for an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id

try {
    $result = $apiInstance->getPackageSplit($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getPackageSplit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\SplitPackaging[]**](../Model/SplitPackaging.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedAuditTrail()`

```php
getProcessedAuditTrail($pk_order_id): \Linnworks\ProcessedOrders\Model\AuditEntry[]
```

GetProcessedAuditTrail

Use this call to get an order's audit trail information <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id

try {
    $result = $apiInstance->getProcessedAuditTrail($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getProcessedAuditTrail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\AuditEntry[]**](../Model/AuditEntry.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedOrderExtendedProperties()`

```php
getProcessedOrderExtendedProperties($pk_order_id): \Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]
```

GetProcessedOrderExtendedProperties

Use this call to retrieve a list of order-level extended properties. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id

try {
    $result = $apiInstance->getProcessedOrderExtendedProperties($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getProcessedOrderExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\OrderExtendedProperty[]**](../Model/OrderExtendedProperty.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedOrderNotes()`

```php
getProcessedOrderNotes($pk_order_id): \Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]
```

GetProcessedOrderNotes

Use this call to get a list of order notes for a given order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id

try {
    $result = $apiInstance->getProcessedOrderNotes($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getProcessedOrderNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ProcessedOrderNote[]**](../Model/ProcessedOrderNote.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedRelatives()`

```php
getProcessedRelatives($pk_order_id): \Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]
```

GetProcessedRelatives

Use this call to get a list of related orders. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id

try {
    $result = $apiInstance->getProcessedRelatives($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getProcessedRelatives: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ProcessedOrderRelation[]**](../Model/ProcessedOrderRelation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundableServiceItems()`

```php
getRefundableServiceItems($pk_order_id): \Linnworks\ProcessedOrders\Model\ServiceItem[]
```

GetRefundableServiceItems

Use this call to get a list of service items which can be refunded. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The id of the order which the service items belong to.

try {
    $result = $apiInstance->getRefundableServiceItems($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getRefundableServiceItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The id of the order which the service items belong to. | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ServiceItem[]**](../Model/ServiceItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefunds()`

```php
getRefunds($pk_order_id): \Linnworks\ProcessedOrders\Model\RefundInfo[]
```

GetRefunds

Gets all refund order items for an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | Primary key for order

try {
    $result = $apiInstance->getRefunds($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getRefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| Primary key for order | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\RefundInfo[]**](../Model/RefundInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundsOptions()`

```php
getRefundsOptions($pk_order_id): \Linnworks\ProcessedOrders\Model\RefundScreenOptions
```

GetRefundsOptions

Use this call to get information about manual/automated refunds (which kinds of refunds are possible) for a given order. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The id of the order

try {
    $result = $apiInstance->getRefundsOptions($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getRefundsOptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The id of the order | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\RefundScreenOptions**](../Model/RefundScreenOptions.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReturnCategories()`

```php
getReturnCategories(): \Linnworks\ProcessedOrders\Model\OrderReturnCategory[]
```

GetReturnCategories

Use this call to retrieve a list of return categories. Used for refunds, resends and exchanges. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getReturnCategories();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getReturnCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\ProcessedOrders\Model\OrderReturnCategory[]**](../Model/OrderReturnCategory.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReturnItemsInfo()`

```php
getReturnItemsInfo($pk_order_id): \Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]
```

GetReturnItemsInfo

Use this call to get a list of all items on an order, including return quantities and resend quantities. The information can be used to calculate how many items has already been returned. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id to get the returns for

try {
    $result = $apiInstance->getReturnItemsInfo($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getReturnItemsInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id to get the returns for | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\OrderItemReturnInfo[]**](../Model/OrderItemReturnInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReturnOrderInfo()`

```php
getReturnOrderInfo($pk_order_id, $include_refund_link): \Linnworks\ProcessedOrders\Model\ReturnOrderHeader
```

GetReturnOrderInfo

Use this call to get basic information about a processed order (e.g. source, subsource, address) as seen on the Returns/Refunds screens. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The id of the order.
$include_refund_link = True; // bool | Is a refund link required (not available for all channels).

try {
    $result = $apiInstance->getReturnOrderInfo($pk_order_id, $include_refund_link);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getReturnOrderInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The id of the order. | [optional] |
| **include_refund_link** | **bool**| Is a refund link required (not available for all channels). | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ReturnOrderHeader**](../Model/ReturnOrderHeader.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReturnsExchanges()`

```php
getReturnsExchanges($pk_order_id): \Linnworks\ProcessedOrders\Model\ReturnInfo[]
```

GetReturnsExchanges

Use this call to get a basic list of returns, exchanges and resends for an order. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id to get the returns for

try {
    $result = $apiInstance->getReturnsExchanges($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getReturnsExchanges: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id to get the returns for | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ReturnInfo[]**](../Model/ReturnInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTotalRefunds()`

```php
getTotalRefunds($pk_order_id, $include_bookings): \Linnworks\ProcessedOrders\Model\ExistingRefundTotal
```

GetTotalRefunds

Use this call to retrieve the total value of refunds against an order. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The id of the order
$include_bookings = True; // bool | If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.)

try {
    $result = $apiInstance->getTotalRefunds($pk_order_id, $include_bookings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->getTotalRefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The id of the order | [optional] |
| **include_bookings** | **bool**| If true, pending refunds against return bookings and exchange bookings will be included. (Optional, default is false.) | [optional] |

### Return type

[**\Linnworks\ProcessedOrders\Model\ExistingRefundTotal**](../Model/ExistingRefundTotal.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `isRefundValid()`

```php
isRefundValid($processed_orders_is_refund_valid_request): \Linnworks\ProcessedOrders\Model\ValidationResult
```

IsRefundValid

Use this call to determine if the refunds in a given return set are valid. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_is_refund_valid_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest

try {
    $result = $apiInstance->isRefundValid($processed_orders_is_refund_valid_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->isRefundValid: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_is_refund_valid_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersIsRefundValidRequest**](../Model/ProcessedOrdersIsRefundValidRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\ValidationResult**](../Model/ValidationResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `isRefundValidationRequiredByOrderId()`

```php
isRefundValidationRequiredByOrderId($pk_order_id): bool
```

IsRefundValidationRequiredByOrderId

Use this call to determine if validation of refunds or returns/exchanges with refund components is required for a given order. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | The order id of the order which requires validation

try {
    $result = $apiInstance->isRefundValidationRequiredByOrderId($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->isRefundValidationRequiredByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| The order id of the order which requires validation | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `markManualRefundsAsActioned()`

```php
markManualRefundsAsActioned($processed_orders_mark_manual_refunds_as_actioned_request)
```

MarkManualRefundsAsActioned

Use this call to update pending manual refunds to the actioned state. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_mark_manual_refunds_as_actioned_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest

try {
    $apiInstance->markManualRefundsAsActioned($processed_orders_mark_manual_refunds_as_actioned_request);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->markManualRefundsAsActioned: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_mark_manual_refunds_as_actioned_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersMarkManualRefundsAsActionedRequest**](../Model/ProcessedOrdersMarkManualRefundsAsActionedRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refundFreeText()`

```php
refundFreeText($processed_orders_refund_free_text_request): \Linnworks\ProcessedOrders\Model\RefundInfo[]
```

RefundFreeText

Use this call to add or update a free text refund. This method can also be used to change the refund amount for any pending manual refund. Please check any automated refunds are valid prior to calling this method. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_refund_free_text_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest

try {
    $result = $apiInstance->refundFreeText($processed_orders_refund_free_text_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->refundFreeText: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_refund_free_text_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundFreeTextRequest**](../Model/ProcessedOrdersRefundFreeTextRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\RefundInfo[]**](../Model/RefundInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refundServices()`

```php
refundServices($processed_orders_refund_services_request): \Linnworks\ProcessedOrders\Model\RefundInfo[]
```

RefundServices

Use this call to refund one or more services on an order. Please check that any automated refunds are valid prior to calling this method. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_refund_services_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest

try {
    $result = $apiInstance->refundServices($processed_orders_refund_services_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->refundServices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_refund_services_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundServicesRequest**](../Model/ProcessedOrdersRefundServicesRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\RefundInfo[]**](../Model/RefundInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refundShipping()`

```php
refundShipping($processed_orders_refund_shipping_request): \Linnworks\ProcessedOrders\Model\RefundInfo[]
```

RefundShipping

Use this call to refund shipping for an order. Please check the refund options to ensure that a shipping refund is possible. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_refund_shipping_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest

try {
    $result = $apiInstance->refundShipping($processed_orders_refund_shipping_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->refundShipping: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_refund_shipping_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersRefundShippingRequest**](../Model/ProcessedOrdersRefundShippingRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\RefundInfo[]**](../Model/RefundInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `renameReturnCategory()`

```php
renameReturnCategory($processed_orders_rename_return_category_request)
```

RenameReturnCategory

Use this call to rename an existing return category. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_rename_return_category_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest

try {
    $apiInstance->renameReturnCategory($processed_orders_rename_return_category_request);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->renameReturnCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_rename_return_category_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersRenameReturnCategoryRequest**](../Model/ProcessedOrdersRenameReturnCategoryRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchProcessedOrders()`

```php
searchProcessedOrders($processed_orders_search_processed_orders_request): \Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse
```

SearchProcessedOrders

Search Processed Orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.ProcessedOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_search_processed_orders_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest

try {
    $result = $apiInstance->searchProcessedOrders($processed_orders_search_processed_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->searchProcessedOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_search_processed_orders_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersRequest**](../Model/ProcessedOrdersSearchProcessedOrdersRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\SearchProcessedOrdersResponse**](../Model/SearchProcessedOrdersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchProcessedOrdersPaged()`

```php
searchProcessedOrdersPaged($processed_orders_search_processed_orders_paged_request): \Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb
```

SearchProcessedOrdersPaged

Use this call to search for processed orders. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_search_processed_orders_paged_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest

try {
    $result = $apiInstance->searchProcessedOrdersPaged($processed_orders_search_processed_orders_paged_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->searchProcessedOrdersPaged: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_search_processed_orders_paged_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersSearchProcessedOrdersPagedRequest**](../Model/ProcessedOrdersSearchProcessedOrdersPagedRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\GenericPagedResultProcessedOrderWeb**](../Model/GenericPagedResultProcessedOrderWeb.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `validateCompleteOrderRefund()`

```php
validateCompleteOrderRefund($processed_orders_validate_complete_order_refund_request): \Linnworks\ProcessedOrders\Model\ValidationResult
```

ValidateCompleteOrderRefund

Use this call to check if it is possible to do an automated full-order refund. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_validate_complete_order_refund_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest

try {
    $result = $apiInstance->validateCompleteOrderRefund($processed_orders_validate_complete_order_refund_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->validateCompleteOrderRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **processed_orders_validate_complete_order_refund_request** | [**\Linnworks\ProcessedOrders\Model\ProcessedOrdersValidateCompleteOrderRefundRequest**](../Model/ProcessedOrdersValidateCompleteOrderRefundRequest.md)|  | |

### Return type

[**\Linnworks\ProcessedOrders\Model\ValidationResult**](../Model/ValidationResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
