# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ProcessedOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ProcessedOrders\Api\ProcessedOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$processed_orders_add_order_note_request = new \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest(); // \Linnworks\ProcessedOrders\Model\ProcessedOrdersAddOrderNoteRequest

try {
    $result = $apiInstance->addOrderNote($processed_orders_add_order_note_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProcessedOrdersApi->addOrderNote: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ProcessedOrdersApi* | [**addOrderNote**](docs/Api/ProcessedOrdersApi.md#addordernote) | **POST** /api/ProcessedOrders/AddOrderNote | AddOrderNote
*ProcessedOrdersApi* | [**addReturnCategory**](docs/Api/ProcessedOrdersApi.md#addreturncategory) | **POST** /api/ProcessedOrders/AddReturnCategory | AddReturnCategory
*ProcessedOrdersApi* | [**changeOrderNote**](docs/Api/ProcessedOrdersApi.md#changeordernote) | **POST** /api/ProcessedOrders/ChangeOrderNote | ChangeOrderNote
*ProcessedOrdersApi* | [**checkOrderFullyReturned**](docs/Api/ProcessedOrdersApi.md#checkorderfullyreturned) | **GET** /api/ProcessedOrders/CheckOrderFullyReturned | CheckOrderFullyReturned
*ProcessedOrdersApi* | [**createExchange**](docs/Api/ProcessedOrdersApi.md#createexchange) | **POST** /api/ProcessedOrders/CreateExchange | CreateExchange
*ProcessedOrdersApi* | [**createFullResend**](docs/Api/ProcessedOrdersApi.md#createfullresend) | **POST** /api/ProcessedOrders/CreateFullResend | CreateFullResend
*ProcessedOrdersApi* | [**createResend**](docs/Api/ProcessedOrdersApi.md#createresend) | **POST** /api/ProcessedOrders/CreateResend | CreateResend
*ProcessedOrdersApi* | [**deleteOrderNote**](docs/Api/ProcessedOrdersApi.md#deleteordernote) | **POST** /api/ProcessedOrders/DeleteOrderNote | DeleteOrderNote
*ProcessedOrdersApi* | [**deleteReturnCategory**](docs/Api/ProcessedOrdersApi.md#deletereturncategory) | **POST** /api/ProcessedOrders/DeleteReturnCategory | DeleteReturnCategory
*ProcessedOrdersApi* | [**downloadOrdersToCSV**](docs/Api/ProcessedOrdersApi.md#downloadorderstocsv) | **POST** /api/ProcessedOrders/DownloadOrdersToCSV | DownloadOrdersToCSV
*ProcessedOrdersApi* | [**getChannelRefundReasons**](docs/Api/ProcessedOrdersApi.md#getchannelrefundreasons) | **GET** /api/ProcessedOrders/GetChannelRefundReasons | GetChannelRefundReasons
*ProcessedOrdersApi* | [**getOrderInfo**](docs/Api/ProcessedOrdersApi.md#getorderinfo) | **GET** /api/ProcessedOrders/GetOrderInfo | GetOrderInfo
*ProcessedOrdersApi* | [**getOrderTrackingURLs**](docs/Api/ProcessedOrdersApi.md#getordertrackingurls) | **POST** /api/ProcessedOrders/GetOrderTrackingURLs | GetOrderTrackingURLs
*ProcessedOrdersApi* | [**getPackageSplit**](docs/Api/ProcessedOrdersApi.md#getpackagesplit) | **GET** /api/ProcessedOrders/GetPackageSplit | GetPackageSplit
*ProcessedOrdersApi* | [**getProcessedAuditTrail**](docs/Api/ProcessedOrdersApi.md#getprocessedaudittrail) | **GET** /api/ProcessedOrders/GetProcessedAuditTrail | GetProcessedAuditTrail
*ProcessedOrdersApi* | [**getProcessedOrderExtendedProperties**](docs/Api/ProcessedOrdersApi.md#getprocessedorderextendedproperties) | **GET** /api/ProcessedOrders/GetProcessedOrderExtendedProperties | GetProcessedOrderExtendedProperties
*ProcessedOrdersApi* | [**getProcessedOrderNotes**](docs/Api/ProcessedOrdersApi.md#getprocessedordernotes) | **GET** /api/ProcessedOrders/GetProcessedOrderNotes | GetProcessedOrderNotes
*ProcessedOrdersApi* | [**getProcessedRelatives**](docs/Api/ProcessedOrdersApi.md#getprocessedrelatives) | **GET** /api/ProcessedOrders/GetProcessedRelatives | GetProcessedRelatives
*ProcessedOrdersApi* | [**getRefundableServiceItems**](docs/Api/ProcessedOrdersApi.md#getrefundableserviceitems) | **GET** /api/ProcessedOrders/GetRefundableServiceItems | GetRefundableServiceItems
*ProcessedOrdersApi* | [**getRefunds**](docs/Api/ProcessedOrdersApi.md#getrefunds) | **GET** /api/ProcessedOrders/GetRefunds | GetRefunds
*ProcessedOrdersApi* | [**getRefundsOptions**](docs/Api/ProcessedOrdersApi.md#getrefundsoptions) | **GET** /api/ProcessedOrders/GetRefundsOptions | GetRefundsOptions
*ProcessedOrdersApi* | [**getReturnCategories**](docs/Api/ProcessedOrdersApi.md#getreturncategories) | **GET** /api/ProcessedOrders/GetReturnCategories | GetReturnCategories
*ProcessedOrdersApi* | [**getReturnItemsInfo**](docs/Api/ProcessedOrdersApi.md#getreturnitemsinfo) | **GET** /api/ProcessedOrders/GetReturnItemsInfo | GetReturnItemsInfo
*ProcessedOrdersApi* | [**getReturnOrderInfo**](docs/Api/ProcessedOrdersApi.md#getreturnorderinfo) | **GET** /api/ProcessedOrders/GetReturnOrderInfo | GetReturnOrderInfo
*ProcessedOrdersApi* | [**getReturnsExchanges**](docs/Api/ProcessedOrdersApi.md#getreturnsexchanges) | **GET** /api/ProcessedOrders/GetReturnsExchanges | GetReturnsExchanges
*ProcessedOrdersApi* | [**getTotalRefunds**](docs/Api/ProcessedOrdersApi.md#gettotalrefunds) | **GET** /api/ProcessedOrders/GetTotalRefunds | GetTotalRefunds
*ProcessedOrdersApi* | [**isRefundValid**](docs/Api/ProcessedOrdersApi.md#isrefundvalid) | **POST** /api/ProcessedOrders/IsRefundValid | IsRefundValid
*ProcessedOrdersApi* | [**isRefundValidationRequiredByOrderId**](docs/Api/ProcessedOrdersApi.md#isrefundvalidationrequiredbyorderid) | **GET** /api/ProcessedOrders/IsRefundValidationRequiredByOrderId | IsRefundValidationRequiredByOrderId
*ProcessedOrdersApi* | [**markManualRefundsAsActioned**](docs/Api/ProcessedOrdersApi.md#markmanualrefundsasactioned) | **POST** /api/ProcessedOrders/MarkManualRefundsAsActioned | MarkManualRefundsAsActioned
*ProcessedOrdersApi* | [**refundFreeText**](docs/Api/ProcessedOrdersApi.md#refundfreetext) | **POST** /api/ProcessedOrders/RefundFreeText | RefundFreeText
*ProcessedOrdersApi* | [**refundServices**](docs/Api/ProcessedOrdersApi.md#refundservices) | **POST** /api/ProcessedOrders/RefundServices | RefundServices
*ProcessedOrdersApi* | [**refundShipping**](docs/Api/ProcessedOrdersApi.md#refundshipping) | **POST** /api/ProcessedOrders/RefundShipping | RefundShipping
*ProcessedOrdersApi* | [**renameReturnCategory**](docs/Api/ProcessedOrdersApi.md#renamereturncategory) | **POST** /api/ProcessedOrders/RenameReturnCategory | RenameReturnCategory
*ProcessedOrdersApi* | [**searchProcessedOrders**](docs/Api/ProcessedOrdersApi.md#searchprocessedorders) | **POST** /api/ProcessedOrders/SearchProcessedOrders | SearchProcessedOrders
*ProcessedOrdersApi* | [**searchProcessedOrdersPaged**](docs/Api/ProcessedOrdersApi.md#searchprocessedorderspaged) | **POST** /api/ProcessedOrders/SearchProcessedOrdersPaged | SearchProcessedOrdersPaged
*ProcessedOrdersApi* | [**validateCompleteOrderRefund**](docs/Api/ProcessedOrdersApi.md#validatecompleteorderrefund) | **POST** /api/ProcessedOrders/ValidateCompleteOrderRefund | ValidateCompleteOrderRefund

## Models

- [AuditEntry](docs/Model/AuditEntry.md)
- [ChannelRefundReason](docs/Model/ChannelRefundReason.md)
- [ChannelRefundSubReason](docs/Model/ChannelRefundSubReason.md)
- [DownloadOrdersToCSVRequest](docs/Model/DownloadOrdersToCSVRequest.md)
- [DownloadOrdersToCSVResponse](docs/Model/DownloadOrdersToCSVResponse.md)
- [ExistingRefundTotal](docs/Model/ExistingRefundTotal.md)
- [GenericPagedResultProcessedOrderWeb](docs/Model/GenericPagedResultProcessedOrderWeb.md)
- [GetOrderTrackingURLsRequest](docs/Model/GetOrderTrackingURLsRequest.md)
- [GetOrderTrackingURLsResponse](docs/Model/GetOrderTrackingURLsResponse.md)
- [OrderExtendedProperty](docs/Model/OrderExtendedProperty.md)
- [OrderItemBatch](docs/Model/OrderItemBatch.md)
- [OrderItemReturnInfo](docs/Model/OrderItemReturnInfo.md)
- [OrderItemReturnInfoBatched](docs/Model/OrderItemReturnInfoBatched.md)
- [OrderReturnCategory](docs/Model/OrderReturnCategory.md)
- [ProcessedOrderNote](docs/Model/ProcessedOrderNote.md)
- [ProcessedOrderRelation](docs/Model/ProcessedOrderRelation.md)
- [ProcessedOrderWeb](docs/Model/ProcessedOrderWeb.md)
- [ProcessedOrdersAddOrderNoteRequest](docs/Model/ProcessedOrdersAddOrderNoteRequest.md)
- [ProcessedOrdersAddReturnCategoryRequest](docs/Model/ProcessedOrdersAddReturnCategoryRequest.md)
- [ProcessedOrdersChangeOrderNoteRequest](docs/Model/ProcessedOrdersChangeOrderNoteRequest.md)
- [ProcessedOrdersCreateExchangeRequest](docs/Model/ProcessedOrdersCreateExchangeRequest.md)
- [ProcessedOrdersCreateFullResendRequest](docs/Model/ProcessedOrdersCreateFullResendRequest.md)
- [ProcessedOrdersCreateResendRequest](docs/Model/ProcessedOrdersCreateResendRequest.md)
- [ProcessedOrdersDeleteOrderNoteRequest](docs/Model/ProcessedOrdersDeleteOrderNoteRequest.md)
- [ProcessedOrdersDeleteReturnCategoryRequest](docs/Model/ProcessedOrdersDeleteReturnCategoryRequest.md)
- [ProcessedOrdersDownloadOrdersToCSVRequest](docs/Model/ProcessedOrdersDownloadOrdersToCSVRequest.md)
- [ProcessedOrdersIsRefundValidRequest](docs/Model/ProcessedOrdersIsRefundValidRequest.md)
- [ProcessedOrdersMarkManualRefundsAsActionedRequest](docs/Model/ProcessedOrdersMarkManualRefundsAsActionedRequest.md)
- [ProcessedOrdersRefundFreeTextRequest](docs/Model/ProcessedOrdersRefundFreeTextRequest.md)
- [ProcessedOrdersRefundServicesRequest](docs/Model/ProcessedOrdersRefundServicesRequest.md)
- [ProcessedOrdersRefundShippingRequest](docs/Model/ProcessedOrdersRefundShippingRequest.md)
- [ProcessedOrdersRenameReturnCategoryRequest](docs/Model/ProcessedOrdersRenameReturnCategoryRequest.md)
- [ProcessedOrdersSearchProcessedOrdersPagedRequest](docs/Model/ProcessedOrdersSearchProcessedOrdersPagedRequest.md)
- [ProcessedOrdersSearchProcessedOrdersRequest](docs/Model/ProcessedOrdersSearchProcessedOrdersRequest.md)
- [ProcessedOrdersValidateCompleteOrderRefundRequest](docs/Model/ProcessedOrdersValidateCompleteOrderRefundRequest.md)
- [RefundInfo](docs/Model/RefundInfo.md)
- [RefundItem](docs/Model/RefundItem.md)
- [RefundScreenOptions](docs/Model/RefundScreenOptions.md)
- [ReturnInfo](docs/Model/ReturnInfo.md)
- [ReturnOrderHeader](docs/Model/ReturnOrderHeader.md)
- [RowQty](docs/Model/RowQty.md)
- [SearchFilters](docs/Model/SearchFilters.md)
- [SearchProcessedOrdersRequest](docs/Model/SearchProcessedOrdersRequest.md)
- [SearchProcessedOrdersResponse](docs/Model/SearchProcessedOrdersResponse.md)
- [SearchSorting](docs/Model/SearchSorting.md)
- [ServiceItem](docs/Model/ServiceItem.md)
- [SplitPackaging](docs/Model/SplitPackaging.md)
- [StockItemBatch](docs/Model/StockItemBatch.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [TrackingURLRequestItem](docs/Model/TrackingURLRequestItem.md)
- [TrackingURLResponseItem](docs/Model/TrackingURLResponseItem.md)
- [ValidationResult](docs/Model/ValidationResult.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `processedorders`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
