<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OrdersV2\Model;

use \ArrayAccess;
use \Linnworks\OrdersV2\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'general_info' => '\Linnworks\OrdersV2\Model\GeneralInfo',
        'customer_info' => '\Linnworks\OrdersV2\Model\CustomerInfo',
        'items' => '\Linnworks\OrdersV2\Model\Item[]',
        'notes' => '\Linnworks\OrdersV2\Model\Note[]',
        'order_id' => 'string',
        'num_order_id' => 'int',
        'processed' => 'bool',
        'processed_on' => 'string',
        'paid_on' => 'string',
        'last_updated' => 'string',
        'fulfilment_location_id' => 'string',
        'shipping_info' => '\Linnworks\OrdersV2\Model\ShippingInfo',
        'totals_info' => '\Linnworks\OrdersV2\Model\TotalsInfo',
        'extended_properties' => '\Linnworks\OrdersV2\Model\ExtendedProperty[]',
        'folders' => 'string[]',
        'tax_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'general_info' => null,
        'customer_info' => null,
        'items' => null,
        'notes' => null,
        'order_id' => null,
        'num_order_id' => null,
        'processed' => null,
        'processed_on' => null,
        'paid_on' => null,
        'last_updated' => null,
        'fulfilment_location_id' => null,
        'shipping_info' => null,
        'totals_info' => null,
        'extended_properties' => null,
        'folders' => null,
        'tax_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'general_info' => false,
        'customer_info' => false,
        'items' => false,
        'notes' => false,
        'order_id' => false,
        'num_order_id' => false,
        'processed' => false,
        'processed_on' => false,
        'paid_on' => false,
        'last_updated' => false,
        'fulfilment_location_id' => false,
        'shipping_info' => false,
        'totals_info' => false,
        'extended_properties' => false,
        'folders' => false,
        'tax_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'general_info' => 'GeneralInfo',
        'customer_info' => 'CustomerInfo',
        'items' => 'Items',
        'notes' => 'Notes',
        'order_id' => 'OrderId',
        'num_order_id' => 'NumOrderId',
        'processed' => 'Processed',
        'processed_on' => 'ProcessedOn',
        'paid_on' => 'PaidOn',
        'last_updated' => 'LastUpdated',
        'fulfilment_location_id' => 'FulfilmentLocationId',
        'shipping_info' => 'ShippingInfo',
        'totals_info' => 'TotalsInfo',
        'extended_properties' => 'ExtendedProperties',
        'folders' => 'Folders',
        'tax_id' => 'TaxId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'general_info' => 'setGeneralInfo',
        'customer_info' => 'setCustomerInfo',
        'items' => 'setItems',
        'notes' => 'setNotes',
        'order_id' => 'setOrderId',
        'num_order_id' => 'setNumOrderId',
        'processed' => 'setProcessed',
        'processed_on' => 'setProcessedOn',
        'paid_on' => 'setPaidOn',
        'last_updated' => 'setLastUpdated',
        'fulfilment_location_id' => 'setFulfilmentLocationId',
        'shipping_info' => 'setShippingInfo',
        'totals_info' => 'setTotalsInfo',
        'extended_properties' => 'setExtendedProperties',
        'folders' => 'setFolders',
        'tax_id' => 'setTaxId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'general_info' => 'getGeneralInfo',
        'customer_info' => 'getCustomerInfo',
        'items' => 'getItems',
        'notes' => 'getNotes',
        'order_id' => 'getOrderId',
        'num_order_id' => 'getNumOrderId',
        'processed' => 'getProcessed',
        'processed_on' => 'getProcessedOn',
        'paid_on' => 'getPaidOn',
        'last_updated' => 'getLastUpdated',
        'fulfilment_location_id' => 'getFulfilmentLocationId',
        'shipping_info' => 'getShippingInfo',
        'totals_info' => 'getTotalsInfo',
        'extended_properties' => 'getExtendedProperties',
        'folders' => 'getFolders',
        'tax_id' => 'getTaxId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('general_info', $data ?? [], null);
        $this->setIfExists('customer_info', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('num_order_id', $data ?? [], null);
        $this->setIfExists('processed', $data ?? [], null);
        $this->setIfExists('processed_on', $data ?? [], null);
        $this->setIfExists('paid_on', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('fulfilment_location_id', $data ?? [], null);
        $this->setIfExists('shipping_info', $data ?? [], null);
        $this->setIfExists('totals_info', $data ?? [], null);
        $this->setIfExists('extended_properties', $data ?? [], null);
        $this->setIfExists('folders', $data ?? [], null);
        $this->setIfExists('tax_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets general_info
     *
     * @return \Linnworks\OrdersV2\Model\GeneralInfo|null
     */
    public function getGeneralInfo()
    {
        return $this->container['general_info'];
    }

    /**
     * Sets general_info
     *
     * @param \Linnworks\OrdersV2\Model\GeneralInfo|null $general_info general_info
     *
     * @return self
     */
    public function setGeneralInfo($general_info)
    {
        if (is_null($general_info)) {
            throw new \InvalidArgumentException('non-nullable general_info cannot be null');
        }
        $this->container['general_info'] = $general_info;

        return $this;
    }

    /**
     * Gets customer_info
     *
     * @return \Linnworks\OrdersV2\Model\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->container['customer_info'];
    }

    /**
     * Sets customer_info
     *
     * @param \Linnworks\OrdersV2\Model\CustomerInfo|null $customer_info customer_info
     *
     * @return self
     */
    public function setCustomerInfo($customer_info)
    {
        if (is_null($customer_info)) {
            throw new \InvalidArgumentException('non-nullable customer_info cannot be null');
        }
        $this->container['customer_info'] = $customer_info;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\OrdersV2\Model\Item[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\OrdersV2\Model\Item[]|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return \Linnworks\OrdersV2\Model\Note[]|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param \Linnworks\OrdersV2\Model\Note[]|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id order_id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets num_order_id
     *
     * @return int|null
     */
    public function getNumOrderId()
    {
        return $this->container['num_order_id'];
    }

    /**
     * Sets num_order_id
     *
     * @param int|null $num_order_id num_order_id
     *
     * @return self
     */
    public function setNumOrderId($num_order_id)
    {
        if (is_null($num_order_id)) {
            throw new \InvalidArgumentException('non-nullable num_order_id cannot be null');
        }
        $this->container['num_order_id'] = $num_order_id;

        return $this;
    }

    /**
     * Gets processed
     *
     * @return bool|null
     */
    public function getProcessed()
    {
        return $this->container['processed'];
    }

    /**
     * Sets processed
     *
     * @param bool|null $processed processed
     *
     * @return self
     */
    public function setProcessed($processed)
    {
        if (is_null($processed)) {
            throw new \InvalidArgumentException('non-nullable processed cannot be null');
        }
        $this->container['processed'] = $processed;

        return $this;
    }

    /**
     * Gets processed_on
     *
     * @return string|null
     */
    public function getProcessedOn()
    {
        return $this->container['processed_on'];
    }

    /**
     * Sets processed_on
     *
     * @param string|null $processed_on processed_on
     *
     * @return self
     */
    public function setProcessedOn($processed_on)
    {
        if (is_null($processed_on)) {
            throw new \InvalidArgumentException('non-nullable processed_on cannot be null');
        }
        $this->container['processed_on'] = $processed_on;

        return $this;
    }

    /**
     * Gets paid_on
     *
     * @return string|null
     */
    public function getPaidOn()
    {
        return $this->container['paid_on'];
    }

    /**
     * Sets paid_on
     *
     * @param string|null $paid_on paid_on
     *
     * @return self
     */
    public function setPaidOn($paid_on)
    {
        if (is_null($paid_on)) {
            throw new \InvalidArgumentException('non-nullable paid_on cannot be null');
        }
        $this->container['paid_on'] = $paid_on;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param string|null $last_updated last_updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets fulfilment_location_id
     *
     * @return string|null
     */
    public function getFulfilmentLocationId()
    {
        return $this->container['fulfilment_location_id'];
    }

    /**
     * Sets fulfilment_location_id
     *
     * @param string|null $fulfilment_location_id fulfilment_location_id
     *
     * @return self
     */
    public function setFulfilmentLocationId($fulfilment_location_id)
    {
        if (is_null($fulfilment_location_id)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_location_id cannot be null');
        }
        $this->container['fulfilment_location_id'] = $fulfilment_location_id;

        return $this;
    }

    /**
     * Gets shipping_info
     *
     * @return \Linnworks\OrdersV2\Model\ShippingInfo|null
     */
    public function getShippingInfo()
    {
        return $this->container['shipping_info'];
    }

    /**
     * Sets shipping_info
     *
     * @param \Linnworks\OrdersV2\Model\ShippingInfo|null $shipping_info shipping_info
     *
     * @return self
     */
    public function setShippingInfo($shipping_info)
    {
        if (is_null($shipping_info)) {
            throw new \InvalidArgumentException('non-nullable shipping_info cannot be null');
        }
        $this->container['shipping_info'] = $shipping_info;

        return $this;
    }

    /**
     * Gets totals_info
     *
     * @return \Linnworks\OrdersV2\Model\TotalsInfo|null
     */
    public function getTotalsInfo()
    {
        return $this->container['totals_info'];
    }

    /**
     * Sets totals_info
     *
     * @param \Linnworks\OrdersV2\Model\TotalsInfo|null $totals_info totals_info
     *
     * @return self
     */
    public function setTotalsInfo($totals_info)
    {
        if (is_null($totals_info)) {
            throw new \InvalidArgumentException('non-nullable totals_info cannot be null');
        }
        $this->container['totals_info'] = $totals_info;

        return $this;
    }

    /**
     * Gets extended_properties
     *
     * @return \Linnworks\OrdersV2\Model\ExtendedProperty[]|null
     */
    public function getExtendedProperties()
    {
        return $this->container['extended_properties'];
    }

    /**
     * Sets extended_properties
     *
     * @param \Linnworks\OrdersV2\Model\ExtendedProperty[]|null $extended_properties extended_properties
     *
     * @return self
     */
    public function setExtendedProperties($extended_properties)
    {
        if (is_null($extended_properties)) {
            throw new \InvalidArgumentException('non-nullable extended_properties cannot be null');
        }
        $this->container['extended_properties'] = $extended_properties;

        return $this;
    }

    /**
     * Gets folders
     *
     * @return string[]|null
     */
    public function getFolders()
    {
        return $this->container['folders'];
    }

    /**
     * Sets folders
     *
     * @param string[]|null $folders folders
     *
     * @return self
     */
    public function setFolders($folders)
    {
        if (is_null($folders)) {
            throw new \InvalidArgumentException('non-nullable folders cannot be null');
        }
        $this->container['folders'] = $folders;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id tax_id
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        if (is_null($tax_id)) {
            throw new \InvalidArgumentException('non-nullable tax_id cannot be null');
        }
        $this->container['tax_id'] = $tax_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


