<?php
/**
 * Item
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OrdersV2\Model;

use \ArrayAccess;
use \Linnworks\OrdersV2\ObjectSerializer;

/**
 * Item Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Item implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'item';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'additional_info' => 'object[]',
        'composite_sub_items' => 'object[]',
        'parent_item_id' => 'string',
        'stock_item_int_id' => 'int',
        'item_number' => 'string',
        'sku' => 'string',
        'item_source' => 'string',
        'title' => 'string',
        'category_id' => 'string',
        'category_name' => 'string',
        'price_per_unit' => 'int',
        'unit_cost' => 'int',
        'despatch_stock_unit_cost' => 'float',
        'discount' => 'int',
        'tax_rate' => 'int',
        'cost' => 'float',
        'cost_inc_tax' => 'float',
        'sales_tax' => 'float',
        'tax_cost_inclusive' => 'bool',
        'discount_value' => 'float',
        'weight' => 'int',
        'barcode_number' => 'string',
        'channel_sku' => 'string',
        'channel_title' => 'string',
        'batch_number_scan_required' => 'bool',
        'serial_number_scan_required' => 'bool',
        'bin_racks' => 'object[]',
        'added_date' => 'string',
        'row_id' => 'string',
        'stock_item_id' => 'string',
        'is_service' => 'bool',
        'is_unlinked' => 'bool',
        'quantity' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'additional_info' => null,
        'composite_sub_items' => null,
        'parent_item_id' => 'uuid',
        'stock_item_int_id' => null,
        'item_number' => null,
        'sku' => null,
        'item_source' => null,
        'title' => null,
        'category_id' => null,
        'category_name' => null,
        'price_per_unit' => null,
        'unit_cost' => null,
        'despatch_stock_unit_cost' => null,
        'discount' => null,
        'tax_rate' => null,
        'cost' => null,
        'cost_inc_tax' => null,
        'sales_tax' => null,
        'tax_cost_inclusive' => null,
        'discount_value' => null,
        'weight' => null,
        'barcode_number' => null,
        'channel_sku' => null,
        'channel_title' => null,
        'batch_number_scan_required' => null,
        'serial_number_scan_required' => null,
        'bin_racks' => null,
        'added_date' => null,
        'row_id' => null,
        'stock_item_id' => null,
        'is_service' => null,
        'is_unlinked' => null,
        'quantity' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'additional_info' => false,
        'composite_sub_items' => false,
        'parent_item_id' => false,
        'stock_item_int_id' => false,
        'item_number' => false,
        'sku' => false,
        'item_source' => false,
        'title' => false,
        'category_id' => false,
        'category_name' => false,
        'price_per_unit' => false,
        'unit_cost' => false,
        'despatch_stock_unit_cost' => false,
        'discount' => false,
        'tax_rate' => false,
        'cost' => false,
        'cost_inc_tax' => false,
        'sales_tax' => false,
        'tax_cost_inclusive' => false,
        'discount_value' => false,
        'weight' => false,
        'barcode_number' => false,
        'channel_sku' => false,
        'channel_title' => false,
        'batch_number_scan_required' => false,
        'serial_number_scan_required' => false,
        'bin_racks' => false,
        'added_date' => false,
        'row_id' => false,
        'stock_item_id' => false,
        'is_service' => false,
        'is_unlinked' => false,
        'quantity' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'additional_info' => 'AdditionalInfo',
        'composite_sub_items' => 'CompositeSubItems',
        'parent_item_id' => 'ParentItemId',
        'stock_item_int_id' => 'StockItemIntId',
        'item_number' => 'ItemNumber',
        'sku' => 'SKU',
        'item_source' => 'ItemSource',
        'title' => 'Title',
        'category_id' => 'CategoryId',
        'category_name' => 'CategoryName',
        'price_per_unit' => 'PricePerUnit',
        'unit_cost' => 'UnitCost',
        'despatch_stock_unit_cost' => 'DespatchStockUnitCost',
        'discount' => 'Discount',
        'tax_rate' => 'TaxRate',
        'cost' => 'Cost',
        'cost_inc_tax' => 'CostIncTax',
        'sales_tax' => 'SalesTax',
        'tax_cost_inclusive' => 'TaxCostInclusive',
        'discount_value' => 'DiscountValue',
        'weight' => 'Weight',
        'barcode_number' => 'BarcodeNumber',
        'channel_sku' => 'ChannelSKU',
        'channel_title' => 'ChannelTitle',
        'batch_number_scan_required' => 'BatchNumberScanRequired',
        'serial_number_scan_required' => 'SerialNumberScanRequired',
        'bin_racks' => 'BinRacks',
        'added_date' => 'AddedDate',
        'row_id' => 'RowId',
        'stock_item_id' => 'StockItemId',
        'is_service' => 'IsService',
        'is_unlinked' => 'IsUnlinked',
        'quantity' => 'Quantity'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'additional_info' => 'setAdditionalInfo',
        'composite_sub_items' => 'setCompositeSubItems',
        'parent_item_id' => 'setParentItemId',
        'stock_item_int_id' => 'setStockItemIntId',
        'item_number' => 'setItemNumber',
        'sku' => 'setSku',
        'item_source' => 'setItemSource',
        'title' => 'setTitle',
        'category_id' => 'setCategoryId',
        'category_name' => 'setCategoryName',
        'price_per_unit' => 'setPricePerUnit',
        'unit_cost' => 'setUnitCost',
        'despatch_stock_unit_cost' => 'setDespatchStockUnitCost',
        'discount' => 'setDiscount',
        'tax_rate' => 'setTaxRate',
        'cost' => 'setCost',
        'cost_inc_tax' => 'setCostIncTax',
        'sales_tax' => 'setSalesTax',
        'tax_cost_inclusive' => 'setTaxCostInclusive',
        'discount_value' => 'setDiscountValue',
        'weight' => 'setWeight',
        'barcode_number' => 'setBarcodeNumber',
        'channel_sku' => 'setChannelSku',
        'channel_title' => 'setChannelTitle',
        'batch_number_scan_required' => 'setBatchNumberScanRequired',
        'serial_number_scan_required' => 'setSerialNumberScanRequired',
        'bin_racks' => 'setBinRacks',
        'added_date' => 'setAddedDate',
        'row_id' => 'setRowId',
        'stock_item_id' => 'setStockItemId',
        'is_service' => 'setIsService',
        'is_unlinked' => 'setIsUnlinked',
        'quantity' => 'setQuantity'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'additional_info' => 'getAdditionalInfo',
        'composite_sub_items' => 'getCompositeSubItems',
        'parent_item_id' => 'getParentItemId',
        'stock_item_int_id' => 'getStockItemIntId',
        'item_number' => 'getItemNumber',
        'sku' => 'getSku',
        'item_source' => 'getItemSource',
        'title' => 'getTitle',
        'category_id' => 'getCategoryId',
        'category_name' => 'getCategoryName',
        'price_per_unit' => 'getPricePerUnit',
        'unit_cost' => 'getUnitCost',
        'despatch_stock_unit_cost' => 'getDespatchStockUnitCost',
        'discount' => 'getDiscount',
        'tax_rate' => 'getTaxRate',
        'cost' => 'getCost',
        'cost_inc_tax' => 'getCostIncTax',
        'sales_tax' => 'getSalesTax',
        'tax_cost_inclusive' => 'getTaxCostInclusive',
        'discount_value' => 'getDiscountValue',
        'weight' => 'getWeight',
        'barcode_number' => 'getBarcodeNumber',
        'channel_sku' => 'getChannelSku',
        'channel_title' => 'getChannelTitle',
        'batch_number_scan_required' => 'getBatchNumberScanRequired',
        'serial_number_scan_required' => 'getSerialNumberScanRequired',
        'bin_racks' => 'getBinRacks',
        'added_date' => 'getAddedDate',
        'row_id' => 'getRowId',
        'stock_item_id' => 'getStockItemId',
        'is_service' => 'getIsService',
        'is_unlinked' => 'getIsUnlinked',
        'quantity' => 'getQuantity'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('additional_info', $data ?? [], null);
        $this->setIfExists('composite_sub_items', $data ?? [], null);
        $this->setIfExists('parent_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_source', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('category_name', $data ?? [], null);
        $this->setIfExists('price_per_unit', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('despatch_stock_unit_cost', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('cost_inc_tax', $data ?? [], null);
        $this->setIfExists('sales_tax', $data ?? [], null);
        $this->setIfExists('tax_cost_inclusive', $data ?? [], null);
        $this->setIfExists('discount_value', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('channel_sku', $data ?? [], null);
        $this->setIfExists('channel_title', $data ?? [], null);
        $this->setIfExists('batch_number_scan_required', $data ?? [], null);
        $this->setIfExists('serial_number_scan_required', $data ?? [], null);
        $this->setIfExists('bin_racks', $data ?? [], null);
        $this->setIfExists('added_date', $data ?? [], null);
        $this->setIfExists('row_id', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('is_service', $data ?? [], null);
        $this->setIfExists('is_unlinked', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets additional_info
     *
     * @return object[]|null
     */
    public function getAdditionalInfo()
    {
        return $this->container['additional_info'];
    }

    /**
     * Sets additional_info
     *
     * @param object[]|null $additional_info additional_info
     *
     * @return self
     */
    public function setAdditionalInfo($additional_info)
    {
        if (is_null($additional_info)) {
            throw new \InvalidArgumentException('non-nullable additional_info cannot be null');
        }
        $this->container['additional_info'] = $additional_info;

        return $this;
    }

    /**
     * Gets composite_sub_items
     *
     * @return object[]|null
     */
    public function getCompositeSubItems()
    {
        return $this->container['composite_sub_items'];
    }

    /**
     * Sets composite_sub_items
     *
     * @param object[]|null $composite_sub_items composite_sub_items
     *
     * @return self
     */
    public function setCompositeSubItems($composite_sub_items)
    {
        if (is_null($composite_sub_items)) {
            throw new \InvalidArgumentException('non-nullable composite_sub_items cannot be null');
        }
        $this->container['composite_sub_items'] = $composite_sub_items;

        return $this;
    }

    /**
     * Gets parent_item_id
     *
     * @return string|null
     */
    public function getParentItemId()
    {
        return $this->container['parent_item_id'];
    }

    /**
     * Sets parent_item_id
     *
     * @param string|null $parent_item_id parent_item_id
     *
     * @return self
     */
    public function setParentItemId($parent_item_id)
    {
        if (is_null($parent_item_id)) {
            throw new \InvalidArgumentException('non-nullable parent_item_id cannot be null');
        }
        $this->container['parent_item_id'] = $parent_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id stock_item_int_id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number item_number
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_source
     *
     * @return string|null
     */
    public function getItemSource()
    {
        return $this->container['item_source'];
    }

    /**
     * Sets item_source
     *
     * @param string|null $item_source item_source
     *
     * @return self
     */
    public function setItemSource($item_source)
    {
        if (is_null($item_source)) {
            throw new \InvalidArgumentException('non-nullable item_source cannot be null');
        }
        $this->container['item_source'] = $item_source;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string|null $category_id category_id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets category_name
     *
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->container['category_name'];
    }

    /**
     * Sets category_name
     *
     * @param string|null $category_name category_name
     *
     * @return self
     */
    public function setCategoryName($category_name)
    {
        if (is_null($category_name)) {
            throw new \InvalidArgumentException('non-nullable category_name cannot be null');
        }
        $this->container['category_name'] = $category_name;

        return $this;
    }

    /**
     * Gets price_per_unit
     *
     * @return int|null
     */
    public function getPricePerUnit()
    {
        return $this->container['price_per_unit'];
    }

    /**
     * Sets price_per_unit
     *
     * @param int|null $price_per_unit price_per_unit
     *
     * @return self
     */
    public function setPricePerUnit($price_per_unit)
    {
        if (is_null($price_per_unit)) {
            throw new \InvalidArgumentException('non-nullable price_per_unit cannot be null');
        }
        $this->container['price_per_unit'] = $price_per_unit;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return int|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param int|null $unit_cost unit_cost
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets despatch_stock_unit_cost
     *
     * @return float|null
     */
    public function getDespatchStockUnitCost()
    {
        return $this->container['despatch_stock_unit_cost'];
    }

    /**
     * Sets despatch_stock_unit_cost
     *
     * @param float|null $despatch_stock_unit_cost despatch_stock_unit_cost
     *
     * @return self
     */
    public function setDespatchStockUnitCost($despatch_stock_unit_cost)
    {
        if (is_null($despatch_stock_unit_cost)) {
            throw new \InvalidArgumentException('non-nullable despatch_stock_unit_cost cannot be null');
        }
        $this->container['despatch_stock_unit_cost'] = $despatch_stock_unit_cost;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param int|null $discount discount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return int|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param int|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost cost
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets cost_inc_tax
     *
     * @return float|null
     */
    public function getCostIncTax()
    {
        return $this->container['cost_inc_tax'];
    }

    /**
     * Sets cost_inc_tax
     *
     * @param float|null $cost_inc_tax cost_inc_tax
     *
     * @return self
     */
    public function setCostIncTax($cost_inc_tax)
    {
        if (is_null($cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable cost_inc_tax cannot be null');
        }
        $this->container['cost_inc_tax'] = $cost_inc_tax;

        return $this;
    }

    /**
     * Gets sales_tax
     *
     * @return float|null
     */
    public function getSalesTax()
    {
        return $this->container['sales_tax'];
    }

    /**
     * Sets sales_tax
     *
     * @param float|null $sales_tax sales_tax
     *
     * @return self
     */
    public function setSalesTax($sales_tax)
    {
        if (is_null($sales_tax)) {
            throw new \InvalidArgumentException('non-nullable sales_tax cannot be null');
        }
        $this->container['sales_tax'] = $sales_tax;

        return $this;
    }

    /**
     * Gets tax_cost_inclusive
     *
     * @return bool|null
     */
    public function getTaxCostInclusive()
    {
        return $this->container['tax_cost_inclusive'];
    }

    /**
     * Sets tax_cost_inclusive
     *
     * @param bool|null $tax_cost_inclusive tax_cost_inclusive
     *
     * @return self
     */
    public function setTaxCostInclusive($tax_cost_inclusive)
    {
        if (is_null($tax_cost_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_cost_inclusive cannot be null');
        }
        $this->container['tax_cost_inclusive'] = $tax_cost_inclusive;

        return $this;
    }

    /**
     * Gets discount_value
     *
     * @return float|null
     */
    public function getDiscountValue()
    {
        return $this->container['discount_value'];
    }

    /**
     * Sets discount_value
     *
     * @param float|null $discount_value discount_value
     *
     * @return self
     */
    public function setDiscountValue($discount_value)
    {
        if (is_null($discount_value)) {
            throw new \InvalidArgumentException('non-nullable discount_value cannot be null');
        }
        $this->container['discount_value'] = $discount_value;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return int|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param int|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number barcode_number
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            throw new \InvalidArgumentException('non-nullable barcode_number cannot be null');
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets channel_sku
     *
     * @return string|null
     */
    public function getChannelSku()
    {
        return $this->container['channel_sku'];
    }

    /**
     * Sets channel_sku
     *
     * @param string|null $channel_sku channel_sku
     *
     * @return self
     */
    public function setChannelSku($channel_sku)
    {
        if (is_null($channel_sku)) {
            throw new \InvalidArgumentException('non-nullable channel_sku cannot be null');
        }
        $this->container['channel_sku'] = $channel_sku;

        return $this;
    }

    /**
     * Gets channel_title
     *
     * @return string|null
     */
    public function getChannelTitle()
    {
        return $this->container['channel_title'];
    }

    /**
     * Sets channel_title
     *
     * @param string|null $channel_title channel_title
     *
     * @return self
     */
    public function setChannelTitle($channel_title)
    {
        if (is_null($channel_title)) {
            throw new \InvalidArgumentException('non-nullable channel_title cannot be null');
        }
        $this->container['channel_title'] = $channel_title;

        return $this;
    }

    /**
     * Gets batch_number_scan_required
     *
     * @return bool|null
     */
    public function getBatchNumberScanRequired()
    {
        return $this->container['batch_number_scan_required'];
    }

    /**
     * Sets batch_number_scan_required
     *
     * @param bool|null $batch_number_scan_required batch_number_scan_required
     *
     * @return self
     */
    public function setBatchNumberScanRequired($batch_number_scan_required)
    {
        if (is_null($batch_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable batch_number_scan_required cannot be null');
        }
        $this->container['batch_number_scan_required'] = $batch_number_scan_required;

        return $this;
    }

    /**
     * Gets serial_number_scan_required
     *
     * @return bool|null
     */
    public function getSerialNumberScanRequired()
    {
        return $this->container['serial_number_scan_required'];
    }

    /**
     * Sets serial_number_scan_required
     *
     * @param bool|null $serial_number_scan_required serial_number_scan_required
     *
     * @return self
     */
    public function setSerialNumberScanRequired($serial_number_scan_required)
    {
        if (is_null($serial_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable serial_number_scan_required cannot be null');
        }
        $this->container['serial_number_scan_required'] = $serial_number_scan_required;

        return $this;
    }

    /**
     * Gets bin_racks
     *
     * @return object[]|null
     */
    public function getBinRacks()
    {
        return $this->container['bin_racks'];
    }

    /**
     * Sets bin_racks
     *
     * @param object[]|null $bin_racks bin_racks
     *
     * @return self
     */
    public function setBinRacks($bin_racks)
    {
        if (is_null($bin_racks)) {
            throw new \InvalidArgumentException('non-nullable bin_racks cannot be null');
        }
        $this->container['bin_racks'] = $bin_racks;

        return $this;
    }

    /**
     * Gets added_date
     *
     * @return string|null
     */
    public function getAddedDate()
    {
        return $this->container['added_date'];
    }

    /**
     * Sets added_date
     *
     * @param string|null $added_date added_date
     *
     * @return self
     */
    public function setAddedDate($added_date)
    {
        if (is_null($added_date)) {
            throw new \InvalidArgumentException('non-nullable added_date cannot be null');
        }
        $this->container['added_date'] = $added_date;

        return $this;
    }

    /**
     * Gets row_id
     *
     * @return string|null
     */
    public function getRowId()
    {
        return $this->container['row_id'];
    }

    /**
     * Sets row_id
     *
     * @param string|null $row_id row_id
     *
     * @return self
     */
    public function setRowId($row_id)
    {
        if (is_null($row_id)) {
            throw new \InvalidArgumentException('non-nullable row_id cannot be null');
        }
        $this->container['row_id'] = $row_id;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id stock_item_id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets is_service
     *
     * @return bool|null
     */
    public function getIsService()
    {
        return $this->container['is_service'];
    }

    /**
     * Sets is_service
     *
     * @param bool|null $is_service is_service
     *
     * @return self
     */
    public function setIsService($is_service)
    {
        if (is_null($is_service)) {
            throw new \InvalidArgumentException('non-nullable is_service cannot be null');
        }
        $this->container['is_service'] = $is_service;

        return $this;
    }

    /**
     * Gets is_unlinked
     *
     * @return bool|null
     */
    public function getIsUnlinked()
    {
        return $this->container['is_unlinked'];
    }

    /**
     * Sets is_unlinked
     *
     * @param bool|null $is_unlinked is_unlinked
     *
     * @return self
     */
    public function setIsUnlinked($is_unlinked)
    {
        if (is_null($is_unlinked)) {
            throw new \InvalidArgumentException('non-nullable is_unlinked cannot be null');
        }
        $this->container['is_unlinked'] = $is_unlinked;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


