<?php
/**
 * OrdersApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OrdersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\OrdersV2\ApiException;
use Linnworks\OrdersV2\Configuration;
use Linnworks\OrdersV2\HeaderSelector;
use Linnworks\OrdersV2\ObjectSerializer;

/**
 * OrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getOrders' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getOrders
     *
     * GetOrders
     *
     * @param  string[]|null $id Order IDs to fetch. If included, all other request parameters will be disregarded. (optional)
     * @param  \DateTime|null $from_date The datetime to start retrieving orders from, based on when the orders were last updated (optional)
     * @param  int|null $entries_per_page The maximum number of orders to be returned in the response (optional)
     * @param  bool|null $include_processed If true the response will also include orders that have been processed; else the response will only contain open orders (optional)
     * @param  bool|null $only_paid If true the response will only contain paid orders; else the response will also include unpaid orders (optional)
     * @param  string|null $location_id The ID of location if the response should only contain orders that are specific to that location (optional)
     * @param  string|null $search_token The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\OrdersV2\Model\GetOrderResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse
     */
    public function getOrders($id = null, $from_date = null, $entries_per_page = null, $include_processed = null, $only_paid = null, $location_id = null, $search_token = null, string $contentType = self::contentTypes['getOrders'][0])
    {
        list($response) = $this->getOrdersWithHttpInfo($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token, $contentType);
        return $response;
    }

    /**
     * Operation getOrdersWithHttpInfo
     *
     * GetOrders
     *
     * @param  string[]|null $id Order IDs to fetch. If included, all other request parameters will be disregarded. (optional)
     * @param  \DateTime|null $from_date The datetime to start retrieving orders from, based on when the orders were last updated (optional)
     * @param  int|null $entries_per_page The maximum number of orders to be returned in the response (optional)
     * @param  bool|null $include_processed If true the response will also include orders that have been processed; else the response will only contain open orders (optional)
     * @param  bool|null $only_paid If true the response will only contain paid orders; else the response will also include unpaid orders (optional)
     * @param  string|null $location_id The ID of location if the response should only contain orders that are specific to that location (optional)
     * @param  string|null $search_token The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\OrdersV2\Model\GetOrderResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse|\Linnworks\OrdersV2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrdersWithHttpInfo($id = null, $from_date = null, $entries_per_page = null, $include_processed = null, $only_paid = null, $location_id = null, $search_token = null, string $contentType = self::contentTypes['getOrders'][0])
    {
        $request = $this->getOrdersRequest($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\OrdersV2\Model\GetOrderResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\OrdersV2\Model\GetOrderResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\OrdersV2\Model\GetOrderResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Linnworks\OrdersV2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\OrdersV2\Model\ErrorResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\OrdersV2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Linnworks\OrdersV2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\OrdersV2\Model\ErrorResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\OrdersV2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Linnworks\OrdersV2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\OrdersV2\Model\ErrorResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\OrdersV2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Linnworks\OrdersV2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\OrdersV2\Model\ErrorResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\OrdersV2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\OrdersV2\Model\GetOrderResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\OrdersV2\Model\GetOrderResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\OrdersV2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\OrdersV2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\OrdersV2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\OrdersV2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrdersAsync
     *
     * GetOrders
     *
     * @param  string[]|null $id Order IDs to fetch. If included, all other request parameters will be disregarded. (optional)
     * @param  \DateTime|null $from_date The datetime to start retrieving orders from, based on when the orders were last updated (optional)
     * @param  int|null $entries_per_page The maximum number of orders to be returned in the response (optional)
     * @param  bool|null $include_processed If true the response will also include orders that have been processed; else the response will only contain open orders (optional)
     * @param  bool|null $only_paid If true the response will only contain paid orders; else the response will also include unpaid orders (optional)
     * @param  string|null $location_id The ID of location if the response should only contain orders that are specific to that location (optional)
     * @param  string|null $search_token The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersAsync($id = null, $from_date = null, $entries_per_page = null, $include_processed = null, $only_paid = null, $location_id = null, $search_token = null, string $contentType = self::contentTypes['getOrders'][0])
    {
        return $this->getOrdersAsyncWithHttpInfo($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrdersAsyncWithHttpInfo
     *
     * GetOrders
     *
     * @param  string[]|null $id Order IDs to fetch. If included, all other request parameters will be disregarded. (optional)
     * @param  \DateTime|null $from_date The datetime to start retrieving orders from, based on when the orders were last updated (optional)
     * @param  int|null $entries_per_page The maximum number of orders to be returned in the response (optional)
     * @param  bool|null $include_processed If true the response will also include orders that have been processed; else the response will only contain open orders (optional)
     * @param  bool|null $only_paid If true the response will only contain paid orders; else the response will also include unpaid orders (optional)
     * @param  string|null $location_id The ID of location if the response should only contain orders that are specific to that location (optional)
     * @param  string|null $search_token The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersAsyncWithHttpInfo($id = null, $from_date = null, $entries_per_page = null, $include_processed = null, $only_paid = null, $location_id = null, $search_token = null, string $contentType = self::contentTypes['getOrders'][0])
    {
        $returnType = '\Linnworks\OrdersV2\Model\GetOrderResponse';
        $request = $this->getOrdersRequest($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrders'
     *
     * @param  string[]|null $id Order IDs to fetch. If included, all other request parameters will be disregarded. (optional)
     * @param  \DateTime|null $from_date The datetime to start retrieving orders from, based on when the orders were last updated (optional)
     * @param  int|null $entries_per_page The maximum number of orders to be returned in the response (optional)
     * @param  bool|null $include_processed If true the response will also include orders that have been processed; else the response will only contain open orders (optional)
     * @param  bool|null $only_paid If true the response will only contain paid orders; else the response will also include unpaid orders (optional)
     * @param  string|null $location_id The ID of location if the response should only contain orders that are specific to that location (optional)
     * @param  string|null $search_token The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrdersRequest($id = null, $from_date = null, $entries_per_page = null, $include_processed = null, $only_paid = null, $location_id = null, $search_token = null, string $contentType = self::contentTypes['getOrders'][0])
    {

        







        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'fromDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entries_per_page,
            'entriesPerPage', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_processed,
            'includeProcessed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $only_paid,
            'onlyPaid', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_token,
            'searchToken', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/problem+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
