# Linnworks\OrdersV2\OrdersApi

All URIs are relative to https://eu-api.linnworks.net/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getOrders()**](OrdersApi.md#getOrders) | **GET** /orders | GetOrders |


## `getOrders()`

```php
getOrders($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token): \Linnworks\OrdersV2\Model\GetOrderResponse
```

GetOrders

Get orders

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Linnworks
$config = Linnworks\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = array('id_example'); // string[] | Order IDs to fetch. If included, all other request parameters will be disregarded.
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The datetime to start retrieving orders from, based on when the orders were last updated
$entries_per_page = 56; // int | The maximum number of orders to be returned in the response
$include_processed = True; // bool | If true the response will also include orders that have been processed; else the response will only contain open orders
$only_paid = True; // bool | If true the response will only contain paid orders; else the response will also include unpaid orders
$location_id = 'location_id_example'; // string | The ID of location if the response should only contain orders that are specific to that location
$search_token = 'search_token_example'; // string | The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one.

try {
    $result = $apiInstance->getOrders($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | [**string[]**](../Model/string.md)| Order IDs to fetch. If included, all other request parameters will be disregarded. | [optional] |
| **from_date** | **\DateTime**| The datetime to start retrieving orders from, based on when the orders were last updated | [optional] |
| **entries_per_page** | **int**| The maximum number of orders to be returned in the response | [optional] |
| **include_processed** | **bool**| If true the response will also include orders that have been processed; else the response will only contain open orders | [optional] |
| **only_paid** | **bool**| If true the response will only contain paid orders; else the response will also include unpaid orders | [optional] |
| **location_id** | **string**| The ID of location if the response should only contain orders that are specific to that location | [optional] |
| **search_token** | **string**| The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one. | [optional] |

### Return type

[**\Linnworks\OrdersV2\Model\GetOrderResponse**](../Model/GetOrderResponse.md)

### Authorization

[Linnworks](../../README.md#Linnworks)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/problem+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
