# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: Linnworks
$config = Linnworks\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = array('id_example'); // string[] | Order IDs to fetch. If included, all other request parameters will be disregarded.
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The datetime to start retrieving orders from, based on when the orders were last updated
$entries_per_page = 56; // int | The maximum number of orders to be returned in the response
$include_processed = True; // bool | If true the response will also include orders that have been processed; else the response will only contain open orders
$only_paid = True; // bool | If true the response will only contain paid orders; else the response will also include unpaid orders
$location_id = 'location_id_example'; // string | The ID of location if the response should only contain orders that are specific to that location
$search_token = 'search_token_example'; // string | The search token for the previous page of results. Can be found on the response object of the call to GetOrder prior to this one.

try {
    $result = $apiInstance->getOrders($id, $from_date, $entries_per_page, $include_processed, $only_paid, $location_id, $search_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrders: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-api.linnworks.net/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OrdersApi* | [**getOrders**](docs/Api/OrdersApi.md#getorders) | **GET** /orders | GetOrders

## Models

- [Address](docs/Model/Address.md)
- [BillingAddress](docs/Model/BillingAddress.md)
- [CustomerInfo](docs/Model/CustomerInfo.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [ExtendedProperty](docs/Model/ExtendedProperty.md)
- [GeneralInfo](docs/Model/GeneralInfo.md)
- [GeneralInfoScheduledDelivery](docs/Model/GeneralInfoScheduledDelivery.md)
- [GetOrderResponse](docs/Model/GetOrderResponse.md)
- [Identifier](docs/Model/Identifier.md)
- [Item](docs/Model/Item.md)
- [Note](docs/Model/Note.md)
- [Order](docs/Model/Order.md)
- [ShippingInfo](docs/Model/ShippingInfo.md)
- [TotalsInfo](docs/Model/TotalsInfo.md)

## Authorization

Authentication schemes defined for the API:
### Linnworks

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v1`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
