<?php
/**
 * SetOrderPackagingRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * SetOrderPackagingRequest Class Doc Comment
 *
 * @category Class
 * @description Request class for SetOrderPackaging method in Orders controller
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SetOrderPackagingRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SetOrderPackagingRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fk_packaging_group_id' => 'string',
        'fk_packaging_type_id' => 'string',
        'pk_order_id' => 'string',
        'total_weight' => 'float',
        'manual_adjust' => 'bool',
        'is_auto_split' => 'bool',
        'total_depth' => 'float',
        'total_height' => 'float',
        'total_width' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fk_packaging_group_id' => 'uuid',
        'fk_packaging_type_id' => 'uuid',
        'pk_order_id' => 'uuid',
        'total_weight' => 'double',
        'manual_adjust' => null,
        'is_auto_split' => null,
        'total_depth' => 'double',
        'total_height' => 'double',
        'total_width' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fk_packaging_group_id' => false,
        'fk_packaging_type_id' => false,
        'pk_order_id' => false,
        'total_weight' => false,
        'manual_adjust' => false,
        'is_auto_split' => false,
        'total_depth' => false,
        'total_height' => false,
        'total_width' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fk_packaging_group_id' => 'fkPackagingGroupId',
        'fk_packaging_type_id' => 'fkPackagingTypeId',
        'pk_order_id' => 'pkOrderId',
        'total_weight' => 'TotalWeight',
        'manual_adjust' => 'ManualAdjust',
        'is_auto_split' => 'IsAutoSplit',
        'total_depth' => 'TotalDepth',
        'total_height' => 'TotalHeight',
        'total_width' => 'TotalWidth'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fk_packaging_group_id' => 'setFkPackagingGroupId',
        'fk_packaging_type_id' => 'setFkPackagingTypeId',
        'pk_order_id' => 'setPkOrderId',
        'total_weight' => 'setTotalWeight',
        'manual_adjust' => 'setManualAdjust',
        'is_auto_split' => 'setIsAutoSplit',
        'total_depth' => 'setTotalDepth',
        'total_height' => 'setTotalHeight',
        'total_width' => 'setTotalWidth'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fk_packaging_group_id' => 'getFkPackagingGroupId',
        'fk_packaging_type_id' => 'getFkPackagingTypeId',
        'pk_order_id' => 'getPkOrderId',
        'total_weight' => 'getTotalWeight',
        'manual_adjust' => 'getManualAdjust',
        'is_auto_split' => 'getIsAutoSplit',
        'total_depth' => 'getTotalDepth',
        'total_height' => 'getTotalHeight',
        'total_width' => 'getTotalWidth'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fk_packaging_group_id', $data ?? [], null);
        $this->setIfExists('fk_packaging_type_id', $data ?? [], null);
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('manual_adjust', $data ?? [], null);
        $this->setIfExists('is_auto_split', $data ?? [], null);
        $this->setIfExists('total_depth', $data ?? [], null);
        $this->setIfExists('total_height', $data ?? [], null);
        $this->setIfExists('total_width', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fk_packaging_group_id
     *
     * @return string|null
     */
    public function getFkPackagingGroupId()
    {
        return $this->container['fk_packaging_group_id'];
    }

    /**
     * Sets fk_packaging_group_id
     *
     * @param string|null $fk_packaging_group_id Packaging group Id
     *
     * @return self
     */
    public function setFkPackagingGroupId($fk_packaging_group_id)
    {
        if (is_null($fk_packaging_group_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_group_id cannot be null');
        }
        $this->container['fk_packaging_group_id'] = $fk_packaging_group_id;

        return $this;
    }

    /**
     * Gets fk_packaging_type_id
     *
     * @return string|null
     */
    public function getFkPackagingTypeId()
    {
        return $this->container['fk_packaging_type_id'];
    }

    /**
     * Sets fk_packaging_type_id
     *
     * @param string|null $fk_packaging_type_id Packaging Type Id. It has to be one of types available for selected Group Id
     *
     * @return self
     */
    public function setFkPackagingTypeId($fk_packaging_type_id)
    {
        if (is_null($fk_packaging_type_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_type_id cannot be null');
        }
        $this->container['fk_packaging_type_id'] = $fk_packaging_type_id;

        return $this;
    }

    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order Id to set the order packaging data
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Total weight of order packaging
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets manual_adjust
     *
     * @return bool|null
     */
    public function getManualAdjust()
    {
        return $this->container['manual_adjust'];
    }

    /**
     * Sets manual_adjust
     *
     * @param bool|null $manual_adjust Indicate if this data is manually adjusted with the rest of fields or is auto calculated
     *
     * @return self
     */
    public function setManualAdjust($manual_adjust)
    {
        if (is_null($manual_adjust)) {
            throw new \InvalidArgumentException('non-nullable manual_adjust cannot be null');
        }
        $this->container['manual_adjust'] = $manual_adjust;

        return $this;
    }

    /**
     * Gets is_auto_split
     *
     * @return bool|null
     */
    public function getIsAutoSplit()
    {
        return $this->container['is_auto_split'];
    }

    /**
     * Sets is_auto_split
     *
     * @param bool|null $is_auto_split Indicates whether the order should be auto split. Usually via the 3D packaging methods.
     *
     * @return self
     */
    public function setIsAutoSplit($is_auto_split)
    {
        if (is_null($is_auto_split)) {
            throw new \InvalidArgumentException('non-nullable is_auto_split cannot be null');
        }
        $this->container['is_auto_split'] = $is_auto_split;

        return $this;
    }

    /**
     * Gets total_depth
     *
     * @return float|null
     */
    public function getTotalDepth()
    {
        return $this->container['total_depth'];
    }

    /**
     * Sets total_depth
     *
     * @param float|null $total_depth Total packaging depth
     *
     * @return self
     */
    public function setTotalDepth($total_depth)
    {
        if (is_null($total_depth)) {
            throw new \InvalidArgumentException('non-nullable total_depth cannot be null');
        }
        $this->container['total_depth'] = $total_depth;

        return $this;
    }

    /**
     * Gets total_height
     *
     * @return float|null
     */
    public function getTotalHeight()
    {
        return $this->container['total_height'];
    }

    /**
     * Sets total_height
     *
     * @param float|null $total_height Total Height
     *
     * @return self
     */
    public function setTotalHeight($total_height)
    {
        if (is_null($total_height)) {
            throw new \InvalidArgumentException('non-nullable total_height cannot be null');
        }
        $this->container['total_height'] = $total_height;

        return $this;
    }

    /**
     * Gets total_width
     *
     * @return float|null
     */
    public function getTotalWidth()
    {
        return $this->container['total_width'];
    }

    /**
     * Sets total_width
     *
     * @param float|null $total_width Total Width
     *
     * @return self
     */
    public function setTotalWidth($total_width)
    {
        if (is_null($total_width)) {
            throw new \InvalidArgumentException('non-nullable total_width cannot be null');
        }
        $this->container['total_width'] = $total_width;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


