<?php
/**
 * ProcessOrderByOrderIdOrReferenceResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * ProcessOrderByOrderIdOrReferenceResponse Class Doc Comment
 *
 * @category Class
 * @description A response class used when processing an order by order id or reference
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessOrderByOrderIdOrReferenceResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessOrderByOrderIdOrReferenceResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'processed_state' => 'string',
        'message' => 'string',
        'response' => 'object',
        'order_id' => 'string',
        'order_summary' => '\Linnworks\Orders\Model\OrderSummary',
        'items' => '\Linnworks\Orders\Model\OrderItem[]',
        'batch_information' => '\Linnworks\Orders\Model\StockItemBatch[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'processed_state' => null,
        'message' => null,
        'response' => null,
        'order_id' => 'uuid',
        'order_summary' => null,
        'items' => null,
        'batch_information' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'processed_state' => false,
        'message' => false,
        'response' => false,
        'order_id' => false,
        'order_summary' => false,
        'items' => false,
        'batch_information' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'processed_state' => 'ProcessedState',
        'message' => 'Message',
        'response' => 'Response',
        'order_id' => 'OrderId',
        'order_summary' => 'OrderSummary',
        'items' => 'Items',
        'batch_information' => 'BatchInformation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'processed_state' => 'setProcessedState',
        'message' => 'setMessage',
        'response' => 'setResponse',
        'order_id' => 'setOrderId',
        'order_summary' => 'setOrderSummary',
        'items' => 'setItems',
        'batch_information' => 'setBatchInformation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'processed_state' => 'getProcessedState',
        'message' => 'getMessage',
        'response' => 'getResponse',
        'order_id' => 'getOrderId',
        'order_summary' => 'getOrderSummary',
        'items' => 'getItems',
        'batch_information' => 'getBatchInformation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const PROCESSED_STATE_PROCESSED = 'PROCESSED';
    public const PROCESSED_STATE_NOT_FOUND = 'NOT_FOUND';
    public const PROCESSED_STATE_SCAN_REQUIRED = 'SCAN_REQUIRED';
    public const PROCESSED_STATE_NOT_PROCESSED = 'NOT_PROCESSED';
    public const PROCESSED_STATE_NOTE_ACKNOWLEDGEMENT_REQUIRED = 'NOTE_ACKNOWLEDGEMENT_REQUIRED';
    public const PROCESSED_STATE_NOT_IN_WORKFLOW = 'NOT_IN_WORKFLOW';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getProcessedStateAllowableValues()
    {
        return [
            self::PROCESSED_STATE_PROCESSED,
            self::PROCESSED_STATE_NOT_FOUND,
            self::PROCESSED_STATE_SCAN_REQUIRED,
            self::PROCESSED_STATE_NOT_PROCESSED,
            self::PROCESSED_STATE_NOTE_ACKNOWLEDGEMENT_REQUIRED,
            self::PROCESSED_STATE_NOT_IN_WORKFLOW,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('processed_state', $data ?? [], null);
        $this->setIfExists('message', $data ?? [], null);
        $this->setIfExists('response', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('order_summary', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('batch_information', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getProcessedStateAllowableValues();
        if (!is_null($this->container['processed_state']) && !in_array($this->container['processed_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'processed_state', must be one of '%s'",
                $this->container['processed_state'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets processed_state
     *
     * @return string|null
     */
    public function getProcessedState()
    {
        return $this->container['processed_state'];
    }

    /**
     * Sets processed_state
     *
     * @param string|null $processed_state The processed state
     *
     * @return self
     */
    public function setProcessedState($processed_state)
    {
        if (is_null($processed_state)) {
            throw new \InvalidArgumentException('non-nullable processed_state cannot be null');
        }
        $allowedValues = $this->getProcessedStateAllowableValues();
        if (!in_array($processed_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'processed_state', must be one of '%s'",
                    $processed_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['processed_state'] = $processed_state;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string|null
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param string|null $message A message - Provided if there have been errors
     *
     * @return self
     */
    public function setMessage($message)
    {
        if (is_null($message)) {
            throw new \InvalidArgumentException('non-nullable message cannot be null');
        }
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets response
     *
     * @return object|null
     */
    public function getResponse()
    {
        return $this->container['response'];
    }

    /**
     * Sets response
     *
     * @param object|null $response A response object used if further action is required
     *
     * @return self
     */
    public function setResponse($response)
    {
        if (is_null($response)) {
            throw new \InvalidArgumentException('non-nullable response cannot be null');
        }
        $this->container['response'] = $response;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id The ID of the order - Guid empty if not found
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets order_summary
     *
     * @return \Linnworks\Orders\Model\OrderSummary|null
     */
    public function getOrderSummary()
    {
        return $this->container['order_summary'];
    }

    /**
     * Sets order_summary
     *
     * @param \Linnworks\Orders\Model\OrderSummary|null $order_summary order_summary
     *
     * @return self
     */
    public function setOrderSummary($order_summary)
    {
        if (is_null($order_summary)) {
            throw new \InvalidArgumentException('non-nullable order_summary cannot be null');
        }
        $this->container['order_summary'] = $order_summary;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\OrderItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\OrderItem[]|null $items The items that need to be scanned - If any
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets batch_information
     *
     * @return \Linnworks\Orders\Model\StockItemBatch[]|null
     */
    public function getBatchInformation()
    {
        return $this->container['batch_information'];
    }

    /**
     * Sets batch_information
     *
     * @param \Linnworks\Orders\Model\StockItemBatch[]|null $batch_information The batched items
     *
     * @return self
     */
    public function setBatchInformation($batch_information)
    {
        if (is_null($batch_information)) {
            throw new \InvalidArgumentException('non-nullable batch_information cannot be null');
        }
        $this->container['batch_information'] = $batch_information;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


