<?php
/**
 * ProcessOrderByOrderIdOrReferenceRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * ProcessOrderByOrderIdOrReferenceRequest Class Doc Comment
 *
 * @category Class
 * @description A request used to process an order by id or reference
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessOrderByOrderIdOrReferenceRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessOrderByOrderIdOrReferenceRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_or_reference_id' => 'string',
        'location_id' => 'string',
        'scans_performed' => 'bool',
        'order_processing_notes_acknowledged' => 'bool',
        'workflow_job_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_or_reference_id' => null,
        'location_id' => 'uuid',
        'scans_performed' => null,
        'order_processing_notes_acknowledged' => null,
        'workflow_job_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_or_reference_id' => false,
        'location_id' => false,
        'scans_performed' => false,
        'order_processing_notes_acknowledged' => false,
        'workflow_job_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_or_reference_id' => 'OrderOrReferenceId',
        'location_id' => 'LocationId',
        'scans_performed' => 'ScansPerformed',
        'order_processing_notes_acknowledged' => 'OrderProcessingNotesAcknowledged',
        'workflow_job_id' => 'WorkflowJobId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_or_reference_id' => 'setOrderOrReferenceId',
        'location_id' => 'setLocationId',
        'scans_performed' => 'setScansPerformed',
        'order_processing_notes_acknowledged' => 'setOrderProcessingNotesAcknowledged',
        'workflow_job_id' => 'setWorkflowJobId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_or_reference_id' => 'getOrderOrReferenceId',
        'location_id' => 'getLocationId',
        'scans_performed' => 'getScansPerformed',
        'order_processing_notes_acknowledged' => 'getOrderProcessingNotesAcknowledged',
        'workflow_job_id' => 'getWorkflowJobId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_or_reference_id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('scans_performed', $data ?? [], null);
        $this->setIfExists('order_processing_notes_acknowledged', $data ?? [], null);
        $this->setIfExists('workflow_job_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_or_reference_id
     *
     * @return string|null
     */
    public function getOrderOrReferenceId()
    {
        return $this->container['order_or_reference_id'];
    }

    /**
     * Sets order_or_reference_id
     *
     * @param string|null $order_or_reference_id The order id or reference id
     *
     * @return self
     */
    public function setOrderOrReferenceId($order_or_reference_id)
    {
        if (is_null($order_or_reference_id)) {
            throw new \InvalidArgumentException('non-nullable order_or_reference_id cannot be null');
        }
        $this->container['order_or_reference_id'] = $order_or_reference_id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id The location to process the order from
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets scans_performed
     *
     * @return bool|null
     */
    public function getScansPerformed()
    {
        return $this->container['scans_performed'];
    }

    /**
     * Sets scans_performed
     *
     * @param bool|null $scans_performed Defines if the batches have been scanned
     *
     * @return self
     */
    public function setScansPerformed($scans_performed)
    {
        if (is_null($scans_performed)) {
            throw new \InvalidArgumentException('non-nullable scans_performed cannot be null');
        }
        $this->container['scans_performed'] = $scans_performed;

        return $this;
    }

    /**
     * Gets order_processing_notes_acknowledged
     *
     * @return bool|null
     */
    public function getOrderProcessingNotesAcknowledged()
    {
        return $this->container['order_processing_notes_acknowledged'];
    }

    /**
     * Sets order_processing_notes_acknowledged
     *
     * @param bool|null $order_processing_notes_acknowledged Have the processing notes been acknowledged
     *
     * @return self
     */
    public function setOrderProcessingNotesAcknowledged($order_processing_notes_acknowledged)
    {
        if (is_null($order_processing_notes_acknowledged)) {
            throw new \InvalidArgumentException('non-nullable order_processing_notes_acknowledged cannot be null');
        }
        $this->container['order_processing_notes_acknowledged'] = $order_processing_notes_acknowledged;

        return $this;
    }

    /**
     * Gets workflow_job_id
     *
     * @return int|null
     */
    public function getWorkflowJobId()
    {
        return $this->container['workflow_job_id'];
    }

    /**
     * Sets workflow_job_id
     *
     * @param int|null $workflow_job_id Workflow job id that the order is supposed to belong to
     *
     * @return self
     */
    public function setWorkflowJobId($workflow_job_id)
    {
        if (is_null($workflow_job_id)) {
            throw new \InvalidArgumentException('non-nullable workflow_job_id cannot be null');
        }
        $this->container['workflow_job_id'] = $workflow_job_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


