<?php
/**
 * PostageService
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * PostageService Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PostageService implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PostageService';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_postal_service_id' => 'string',
        'postal_service_name' => 'string',
        'tracking_number_required' => 'bool',
        'vendor' => 'string',
        'integrated_service_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_postal_service_id' => 'uuid',
        'postal_service_name' => null,
        'tracking_number_required' => null,
        'vendor' => null,
        'integrated_service_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_postal_service_id' => false,
        'postal_service_name' => false,
        'tracking_number_required' => false,
        'vendor' => false,
        'integrated_service_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_postal_service_id' => 'pkPostalServiceId',
        'postal_service_name' => 'PostalServiceName',
        'tracking_number_required' => 'TrackingNumberRequired',
        'vendor' => 'Vendor',
        'integrated_service_id' => 'IntegratedServiceID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_postal_service_id' => 'setPkPostalServiceId',
        'postal_service_name' => 'setPostalServiceName',
        'tracking_number_required' => 'setTrackingNumberRequired',
        'vendor' => 'setVendor',
        'integrated_service_id' => 'setIntegratedServiceId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_postal_service_id' => 'getPkPostalServiceId',
        'postal_service_name' => 'getPostalServiceName',
        'tracking_number_required' => 'getTrackingNumberRequired',
        'vendor' => 'getVendor',
        'integrated_service_id' => 'getIntegratedServiceId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_postal_service_id', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('tracking_number_required', $data ?? [], null);
        $this->setIfExists('vendor', $data ?? [], null);
        $this->setIfExists('integrated_service_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_postal_service_id
     *
     * @return string|null
     */
    public function getPkPostalServiceId()
    {
        return $this->container['pk_postal_service_id'];
    }

    /**
     * Sets pk_postal_service_id
     *
     * @param string|null $pk_postal_service_id Postal service ID
     *
     * @return self
     */
    public function setPkPostalServiceId($pk_postal_service_id)
    {
        if (is_null($pk_postal_service_id)) {
            throw new \InvalidArgumentException('non-nullable pk_postal_service_id cannot be null');
        }
        $this->container['pk_postal_service_id'] = $pk_postal_service_id;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name Postal service name
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets tracking_number_required
     *
     * @return bool|null
     */
    public function getTrackingNumberRequired()
    {
        return $this->container['tracking_number_required'];
    }

    /**
     * Sets tracking_number_required
     *
     * @param bool|null $tracking_number_required If tracking number is required for this service
     *
     * @return self
     */
    public function setTrackingNumberRequired($tracking_number_required)
    {
        if (is_null($tracking_number_required)) {
            throw new \InvalidArgumentException('non-nullable tracking_number_required cannot be null');
        }
        $this->container['tracking_number_required'] = $tracking_number_required;

        return $this;
    }

    /**
     * Gets vendor
     *
     * @return string|null
     */
    public function getVendor()
    {
        return $this->container['vendor'];
    }

    /**
     * Sets vendor
     *
     * @param string|null $vendor vendor
     *
     * @return self
     */
    public function setVendor($vendor)
    {
        if (is_null($vendor)) {
            throw new \InvalidArgumentException('non-nullable vendor cannot be null');
        }
        $this->container['vendor'] = $vendor;

        return $this;
    }

    /**
     * Gets integrated_service_id
     *
     * @return string|null
     */
    public function getIntegratedServiceId()
    {
        return $this->container['integrated_service_id'];
    }

    /**
     * Sets integrated_service_id
     *
     * @param string|null $integrated_service_id integrated_service_id
     *
     * @return self
     */
    public function setIntegratedServiceId($integrated_service_id)
    {
        if (is_null($integrated_service_id)) {
            throw new \InvalidArgumentException('non-nullable integrated_service_id cannot be null');
        }
        $this->container['integrated_service_id'] = $integrated_service_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


