<?php
/**
 * PackageResult
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * PackageResult Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PackageResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PackageResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'packaging_id' => 'string',
        'width' => 'float',
        'height' => 'float',
        'depth' => 'float',
        'item_weight' => 'float',
        'packaging_weight' => 'float',
        'faces' => '\Linnworks\Orders\Model\Face[]',
        'items' => '\Linnworks\Orders\Model\PackedItem[]',
        'layer_count' => 'int',
        'layer_face' => 'array<string,\Linnworks\Orders\Model\Face>',
        'is_manual_package' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'packaging_id' => 'uuid',
        'width' => 'double',
        'height' => 'double',
        'depth' => 'double',
        'item_weight' => 'double',
        'packaging_weight' => 'double',
        'faces' => null,
        'items' => null,
        'layer_count' => 'int32',
        'layer_face' => null,
        'is_manual_package' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'packaging_id' => false,
        'width' => false,
        'height' => false,
        'depth' => false,
        'item_weight' => false,
        'packaging_weight' => false,
        'faces' => false,
        'items' => false,
        'layer_count' => false,
        'layer_face' => false,
        'is_manual_package' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'packaging_id' => 'PackagingId',
        'width' => 'Width',
        'height' => 'Height',
        'depth' => 'Depth',
        'item_weight' => 'ItemWeight',
        'packaging_weight' => 'PackagingWeight',
        'faces' => 'Faces',
        'items' => 'Items',
        'layer_count' => 'LayerCount',
        'layer_face' => 'LayerFace',
        'is_manual_package' => 'IsManualPackage'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'packaging_id' => 'setPackagingId',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'item_weight' => 'setItemWeight',
        'packaging_weight' => 'setPackagingWeight',
        'faces' => 'setFaces',
        'items' => 'setItems',
        'layer_count' => 'setLayerCount',
        'layer_face' => 'setLayerFace',
        'is_manual_package' => 'setIsManualPackage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'packaging_id' => 'getPackagingId',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'item_weight' => 'getItemWeight',
        'packaging_weight' => 'getPackagingWeight',
        'faces' => 'getFaces',
        'items' => 'getItems',
        'layer_count' => 'getLayerCount',
        'layer_face' => 'getLayerFace',
        'is_manual_package' => 'getIsManualPackage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('packaging_id', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('packaging_weight', $data ?? [], null);
        $this->setIfExists('faces', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('layer_count', $data ?? [], null);
        $this->setIfExists('layer_face', $data ?? [], null);
        $this->setIfExists('is_manual_package', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets packaging_id
     *
     * @return string|null
     */
    public function getPackagingId()
    {
        return $this->container['packaging_id'];
    }

    /**
     * Sets packaging_id
     *
     * @param string|null $packaging_id packaging_id
     *
     * @return self
     */
    public function setPackagingId($packaging_id)
    {
        if (is_null($packaging_id)) {
            throw new \InvalidArgumentException('non-nullable packaging_id cannot be null');
        }
        $this->container['packaging_id'] = $packaging_id;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight item_weight
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets packaging_weight
     *
     * @return float|null
     */
    public function getPackagingWeight()
    {
        return $this->container['packaging_weight'];
    }

    /**
     * Sets packaging_weight
     *
     * @param float|null $packaging_weight packaging_weight
     *
     * @return self
     */
    public function setPackagingWeight($packaging_weight)
    {
        if (is_null($packaging_weight)) {
            throw new \InvalidArgumentException('non-nullable packaging_weight cannot be null');
        }
        $this->container['packaging_weight'] = $packaging_weight;

        return $this;
    }

    /**
     * Gets faces
     *
     * @return \Linnworks\Orders\Model\Face[]|null
     */
    public function getFaces()
    {
        return $this->container['faces'];
    }

    /**
     * Sets faces
     *
     * @param \Linnworks\Orders\Model\Face[]|null $faces faces
     *
     * @return self
     */
    public function setFaces($faces)
    {
        if (is_null($faces)) {
            throw new \InvalidArgumentException('non-nullable faces cannot be null');
        }
        $this->container['faces'] = $faces;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\PackedItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\PackedItem[]|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets layer_count
     *
     * @return int|null
     */
    public function getLayerCount()
    {
        return $this->container['layer_count'];
    }

    /**
     * Sets layer_count
     *
     * @param int|null $layer_count layer_count
     *
     * @return self
     */
    public function setLayerCount($layer_count)
    {
        if (is_null($layer_count)) {
            throw new \InvalidArgumentException('non-nullable layer_count cannot be null');
        }
        $this->container['layer_count'] = $layer_count;

        return $this;
    }

    /**
     * Gets layer_face
     *
     * @return array<string,\Linnworks\Orders\Model\Face>|null
     */
    public function getLayerFace()
    {
        return $this->container['layer_face'];
    }

    /**
     * Sets layer_face
     *
     * @param array<string,\Linnworks\Orders\Model\Face>|null $layer_face layer_face
     *
     * @return self
     */
    public function setLayerFace($layer_face)
    {
        if (is_null($layer_face)) {
            throw new \InvalidArgumentException('non-nullable layer_face cannot be null');
        }
        $this->container['layer_face'] = $layer_face;

        return $this;
    }

    /**
     * Gets is_manual_package
     *
     * @return bool|null
     */
    public function getIsManualPackage()
    {
        return $this->container['is_manual_package'];
    }

    /**
     * Sets is_manual_package
     *
     * @param bool|null $is_manual_package is_manual_package
     *
     * @return self
     */
    public function setIsManualPackage($is_manual_package)
    {
        if (is_null($is_manual_package)) {
            throw new \InvalidArgumentException('non-nullable is_manual_package cannot be null');
        }
        $this->container['is_manual_package'] = $is_manual_package;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


