<?php
/**
 * OrdersSplitOrderRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OrdersSplitOrderRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrdersSplitOrderRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Orders_SplitOrderRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_id' => 'string',
        'new_orders' => '\Linnworks\Orders\Model\OrderSplit[]',
        'type' => 'string',
        'fulfilment_location_id' => 'string',
        'recalc_packaging' => 'bool',
        'fulfillment_status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_id' => 'uuid',
        'new_orders' => null,
        'type' => null,
        'fulfilment_location_id' => 'uuid',
        'recalc_packaging' => null,
        'fulfillment_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_id' => false,
        'new_orders' => false,
        'type' => false,
        'fulfilment_location_id' => false,
        'recalc_packaging' => false,
        'fulfillment_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_id' => 'orderId',
        'new_orders' => 'newOrders',
        'type' => 'type',
        'fulfilment_location_id' => 'fulfilmentLocationId',
        'recalc_packaging' => 'recalcPackaging',
        'fulfillment_status' => 'fulfillmentStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_id' => 'setOrderId',
        'new_orders' => 'setNewOrders',
        'type' => 'setType',
        'fulfilment_location_id' => 'setFulfilmentLocationId',
        'recalc_packaging' => 'setRecalcPackaging',
        'fulfillment_status' => 'setFulfillmentStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_id' => 'getOrderId',
        'new_orders' => 'getNewOrders',
        'type' => 'getType',
        'fulfilment_location_id' => 'getFulfilmentLocationId',
        'recalc_packaging' => 'getRecalcPackaging',
        'fulfillment_status' => 'getFulfillmentStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FULFILLMENT_STATUS_UNASSIGNED = 'Unassigned';
    public const FULFILLMENT_STATUS_ASSIGNED = 'Assigned';
    public const FULFILLMENT_STATUS_SUBMITTED = 'Submitted';
    public const FULFILLMENT_STATUS_ACCEPTED = 'Accepted';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFulfillmentStatusAllowableValues()
    {
        return [
            self::FULFILLMENT_STATUS_UNASSIGNED,
            self::FULFILLMENT_STATUS_ASSIGNED,
            self::FULFILLMENT_STATUS_SUBMITTED,
            self::FULFILLMENT_STATUS_ACCEPTED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('new_orders', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('fulfilment_location_id', $data ?? [], null);
        $this->setIfExists('recalc_packaging', $data ?? [], null);
        $this->setIfExists('fulfillment_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFulfillmentStatusAllowableValues();
        if (!is_null($this->container['fulfillment_status']) && !in_array($this->container['fulfillment_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fulfillment_status', must be one of '%s'",
                $this->container['fulfillment_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Order id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets new_orders
     *
     * @return \Linnworks\Orders\Model\OrderSplit[]|null
     */
    public function getNewOrders()
    {
        return $this->container['new_orders'];
    }

    /**
     * Sets new_orders
     *
     * @param \Linnworks\Orders\Model\OrderSplit[]|null $new_orders New orders
     *
     * @return self
     */
    public function setNewOrders($new_orders)
    {
        if (is_null($new_orders)) {
            throw new \InvalidArgumentException('non-nullable new_orders cannot be null');
        }
        $this->container['new_orders'] = $new_orders;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Split type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets fulfilment_location_id
     *
     * @return string|null
     */
    public function getFulfilmentLocationId()
    {
        return $this->container['fulfilment_location_id'];
    }

    /**
     * Sets fulfilment_location_id
     *
     * @param string|null $fulfilment_location_id Current fulfilment center
     *
     * @return self
     */
    public function setFulfilmentLocationId($fulfilment_location_id)
    {
        if (is_null($fulfilment_location_id)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_location_id cannot be null');
        }
        $this->container['fulfilment_location_id'] = $fulfilment_location_id;

        return $this;
    }

    /**
     * Gets recalc_packaging
     *
     * @return bool|null
     */
    public function getRecalcPackaging()
    {
        return $this->container['recalc_packaging'];
    }

    /**
     * Sets recalc_packaging
     *
     * @param bool|null $recalc_packaging Whether or not to recalculate the order packaging
     *
     * @return self
     */
    public function setRecalcPackaging($recalc_packaging)
    {
        if (is_null($recalc_packaging)) {
            throw new \InvalidArgumentException('non-nullable recalc_packaging cannot be null');
        }
        $this->container['recalc_packaging'] = $recalc_packaging;

        return $this;
    }

    /**
     * Gets fulfillment_status
     *
     * @return string|null
     */
    public function getFulfillmentStatus()
    {
        return $this->container['fulfillment_status'];
    }

    /**
     * Sets fulfillment_status
     *
     * @param string|null $fulfillment_status Optional, if provided the fulfillment status for the newly created orders will be set to this
     *
     * @return self
     */
    public function setFulfillmentStatus($fulfillment_status)
    {
        if (is_null($fulfillment_status)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_status cannot be null');
        }
        $allowedValues = $this->getFulfillmentStatusAllowableValues();
        if (!in_array($fulfillment_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fulfillment_status', must be one of '%s'",
                    $fulfillment_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fulfillment_status'] = $fulfillment_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


