<?php
/**
 * OrdersGetOpenOrdersRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OrdersGetOpenOrdersRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrdersGetOpenOrdersRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Orders_GetOpenOrdersRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'entries_per_page' => 'int',
        'page_number' => 'int',
        'filters' => '\Linnworks\Orders\Model\FieldsFilter',
        'sorting' => '\Linnworks\Orders\Model\FieldSorting[]',
        'fulfilment_center' => 'string',
        'additional_filter' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'entries_per_page' => 'int32',
        'page_number' => 'int32',
        'filters' => null,
        'sorting' => null,
        'fulfilment_center' => 'uuid',
        'additional_filter' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'entries_per_page' => false,
        'page_number' => false,
        'filters' => false,
        'sorting' => false,
        'fulfilment_center' => false,
        'additional_filter' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entries_per_page' => 'entriesPerPage',
        'page_number' => 'pageNumber',
        'filters' => 'filters',
        'sorting' => 'sorting',
        'fulfilment_center' => 'fulfilmentCenter',
        'additional_filter' => 'additionalFilter'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'entries_per_page' => 'setEntriesPerPage',
        'page_number' => 'setPageNumber',
        'filters' => 'setFilters',
        'sorting' => 'setSorting',
        'fulfilment_center' => 'setFulfilmentCenter',
        'additional_filter' => 'setAdditionalFilter'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'entries_per_page' => 'getEntriesPerPage',
        'page_number' => 'getPageNumber',
        'filters' => 'getFilters',
        'sorting' => 'getSorting',
        'fulfilment_center' => 'getFulfilmentCenter',
        'additional_filter' => 'getAdditionalFilter'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('entries_per_page', $data ?? [], null);
        $this->setIfExists('page_number', $data ?? [], null);
        $this->setIfExists('filters', $data ?? [], null);
        $this->setIfExists('sorting', $data ?? [], null);
        $this->setIfExists('fulfilment_center', $data ?? [], null);
        $this->setIfExists('additional_filter', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets entries_per_page
     *
     * @return int|null
     */
    public function getEntriesPerPage()
    {
        return $this->container['entries_per_page'];
    }

    /**
     * Sets entries_per_page
     *
     * @param int|null $entries_per_page Entries per page
     *
     * @return self
     */
    public function setEntriesPerPage($entries_per_page)
    {
        if (is_null($entries_per_page)) {
            throw new \InvalidArgumentException('non-nullable entries_per_page cannot be null');
        }
        $this->container['entries_per_page'] = $entries_per_page;

        return $this;
    }

    /**
     * Gets page_number
     *
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     *
     * @param int|null $page_number Page number
     *
     * @return self
     */
    public function setPageNumber($page_number)
    {
        if (is_null($page_number)) {
            throw new \InvalidArgumentException('non-nullable page_number cannot be null');
        }
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets filters
     *
     * @return \Linnworks\Orders\Model\FieldsFilter|null
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     *
     * @param \Linnworks\Orders\Model\FieldsFilter|null $filters filters
     *
     * @return self
     */
    public function setFilters($filters)
    {
        if (is_null($filters)) {
            throw new \InvalidArgumentException('non-nullable filters cannot be null');
        }
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets sorting
     *
     * @return \Linnworks\Orders\Model\FieldSorting[]|null
     */
    public function getSorting()
    {
        return $this->container['sorting'];
    }

    /**
     * Sets sorting
     *
     * @param \Linnworks\Orders\Model\FieldSorting[]|null $sorting Sorting to apply
     *
     * @return self
     */
    public function setSorting($sorting)
    {
        if (is_null($sorting)) {
            throw new \InvalidArgumentException('non-nullable sorting cannot be null');
        }
        $this->container['sorting'] = $sorting;

        return $this;
    }

    /**
     * Gets fulfilment_center
     *
     * @return string|null
     */
    public function getFulfilmentCenter()
    {
        return $this->container['fulfilment_center'];
    }

    /**
     * Sets fulfilment_center
     *
     * @param string|null $fulfilment_center Location to get the orders for
     *
     * @return self
     */
    public function setFulfilmentCenter($fulfilment_center)
    {
        if (is_null($fulfilment_center)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_center cannot be null');
        }
        $this->container['fulfilment_center'] = $fulfilment_center;

        return $this;
    }

    /**
     * Gets additional_filter
     *
     * @return string|null
     */
    public function getAdditionalFilter()
    {
        return $this->container['additional_filter'];
    }

    /**
     * Sets additional_filter
     *
     * @param string|null $additional_filter Additional filter
     *
     * @return self
     */
    public function setAdditionalFilter($additional_filter)
    {
        if (is_null($additional_filter)) {
            throw new \InvalidArgumentException('non-nullable additional_filter cannot be null');
        }
        $this->container['additional_filter'] = $additional_filter;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


