<?php
/**
 * OrderTotalsInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OrderTotalsInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderTotalsInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderTotalsInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'subtotal' => 'float',
        'postage_cost' => 'float',
        'postage_cost_ex_tax' => 'float',
        'tax' => 'float',
        'total_charge' => 'float',
        'payment_method' => 'string',
        'payment_method_id' => 'string',
        'profit_margin' => 'float',
        'total_discount' => 'float',
        'currency' => 'string',
        'country_tax_rate' => 'float',
        'conversion_rate' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'subtotal' => 'double',
        'postage_cost' => 'double',
        'postage_cost_ex_tax' => 'double',
        'tax' => 'double',
        'total_charge' => 'double',
        'payment_method' => null,
        'payment_method_id' => 'uuid',
        'profit_margin' => 'double',
        'total_discount' => 'double',
        'currency' => null,
        'country_tax_rate' => 'double',
        'conversion_rate' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'subtotal' => false,
        'postage_cost' => false,
        'postage_cost_ex_tax' => false,
        'tax' => false,
        'total_charge' => false,
        'payment_method' => false,
        'payment_method_id' => false,
        'profit_margin' => false,
        'total_discount' => false,
        'currency' => false,
        'country_tax_rate' => false,
        'conversion_rate' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'subtotal' => 'Subtotal',
        'postage_cost' => 'PostageCost',
        'postage_cost_ex_tax' => 'PostageCostExTax',
        'tax' => 'Tax',
        'total_charge' => 'TotalCharge',
        'payment_method' => 'PaymentMethod',
        'payment_method_id' => 'PaymentMethodId',
        'profit_margin' => 'ProfitMargin',
        'total_discount' => 'TotalDiscount',
        'currency' => 'Currency',
        'country_tax_rate' => 'CountryTaxRate',
        'conversion_rate' => 'ConversionRate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'subtotal' => 'setSubtotal',
        'postage_cost' => 'setPostageCost',
        'postage_cost_ex_tax' => 'setPostageCostExTax',
        'tax' => 'setTax',
        'total_charge' => 'setTotalCharge',
        'payment_method' => 'setPaymentMethod',
        'payment_method_id' => 'setPaymentMethodId',
        'profit_margin' => 'setProfitMargin',
        'total_discount' => 'setTotalDiscount',
        'currency' => 'setCurrency',
        'country_tax_rate' => 'setCountryTaxRate',
        'conversion_rate' => 'setConversionRate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'subtotal' => 'getSubtotal',
        'postage_cost' => 'getPostageCost',
        'postage_cost_ex_tax' => 'getPostageCostExTax',
        'tax' => 'getTax',
        'total_charge' => 'getTotalCharge',
        'payment_method' => 'getPaymentMethod',
        'payment_method_id' => 'getPaymentMethodId',
        'profit_margin' => 'getProfitMargin',
        'total_discount' => 'getTotalDiscount',
        'currency' => 'getCurrency',
        'country_tax_rate' => 'getCountryTaxRate',
        'conversion_rate' => 'getConversionRate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('postage_cost', $data ?? [], null);
        $this->setIfExists('postage_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('total_charge', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('payment_method_id', $data ?? [], null);
        $this->setIfExists('profit_margin', $data ?? [], null);
        $this->setIfExists('total_discount', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('country_tax_rate', $data ?? [], null);
        $this->setIfExists('conversion_rate', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets subtotal
     *
     * @return float|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param float|null $subtotal Order subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets postage_cost
     *
     * @return float|null
     */
    public function getPostageCost()
    {
        return $this->container['postage_cost'];
    }

    /**
     * Sets postage_cost
     *
     * @param float|null $postage_cost Order postage cost
     *
     * @return self
     */
    public function setPostageCost($postage_cost)
    {
        if (is_null($postage_cost)) {
            throw new \InvalidArgumentException('non-nullable postage_cost cannot be null');
        }
        $this->container['postage_cost'] = $postage_cost;

        return $this;
    }

    /**
     * Gets postage_cost_ex_tax
     *
     * @return float|null
     */
    public function getPostageCostExTax()
    {
        return $this->container['postage_cost_ex_tax'];
    }

    /**
     * Sets postage_cost_ex_tax
     *
     * @param float|null $postage_cost_ex_tax Order postage cost ex. tax
     *
     * @return self
     */
    public function setPostageCostExTax($postage_cost_ex_tax)
    {
        if (is_null($postage_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable postage_cost_ex_tax cannot be null');
        }
        $this->container['postage_cost_ex_tax'] = $postage_cost_ex_tax;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return float|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param float|null $tax Tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets total_charge
     *
     * @return float|null
     */
    public function getTotalCharge()
    {
        return $this->container['total_charge'];
    }

    /**
     * Sets total_charge
     *
     * @param float|null $total_charge Total charge
     *
     * @return self
     */
    public function setTotalCharge($total_charge)
    {
        if (is_null($total_charge)) {
            throw new \InvalidArgumentException('non-nullable total_charge cannot be null');
        }
        $this->container['total_charge'] = $total_charge;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method Payment method
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_method_id
     *
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->container['payment_method_id'];
    }

    /**
     * Sets payment_method_id
     *
     * @param string|null $payment_method_id Payment method ID
     *
     * @return self
     */
    public function setPaymentMethodId($payment_method_id)
    {
        if (is_null($payment_method_id)) {
            throw new \InvalidArgumentException('non-nullable payment_method_id cannot be null');
        }
        $this->container['payment_method_id'] = $payment_method_id;

        return $this;
    }

    /**
     * Gets profit_margin
     *
     * @return float|null
     */
    public function getProfitMargin()
    {
        return $this->container['profit_margin'];
    }

    /**
     * Sets profit_margin
     *
     * @param float|null $profit_margin Profit margin
     *
     * @return self
     */
    public function setProfitMargin($profit_margin)
    {
        if (is_null($profit_margin)) {
            throw new \InvalidArgumentException('non-nullable profit_margin cannot be null');
        }
        $this->container['profit_margin'] = $profit_margin;

        return $this;
    }

    /**
     * Gets total_discount
     *
     * @return float|null
     */
    public function getTotalDiscount()
    {
        return $this->container['total_discount'];
    }

    /**
     * Sets total_discount
     *
     * @param float|null $total_discount Total discount applied to the order
     *
     * @return self
     */
    public function setTotalDiscount($total_discount)
    {
        if (is_null($total_discount)) {
            throw new \InvalidArgumentException('non-nullable total_discount cannot be null');
        }
        $this->container['total_discount'] = $total_discount;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Order currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets country_tax_rate
     *
     * @return float|null
     */
    public function getCountryTaxRate()
    {
        return $this->container['country_tax_rate'];
    }

    /**
     * Sets country_tax_rate
     *
     * @param float|null $country_tax_rate Country tax rate
     *
     * @return self
     */
    public function setCountryTaxRate($country_tax_rate)
    {
        if (is_null($country_tax_rate)) {
            throw new \InvalidArgumentException('non-nullable country_tax_rate cannot be null');
        }
        $this->container['country_tax_rate'] = $country_tax_rate;

        return $this;
    }

    /**
     * Gets conversion_rate
     *
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->container['conversion_rate'];
    }

    /**
     * Sets conversion_rate
     *
     * @param float|null $conversion_rate Currency conversion rate. Set at point of save by the currency
     *
     * @return self
     */
    public function setConversionRate($conversion_rate)
    {
        if (is_null($conversion_rate)) {
            throw new \InvalidArgumentException('non-nullable conversion_rate cannot be null');
        }
        $this->container['conversion_rate'] = $conversion_rate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


