<?php
/**
 * OrderShippingInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OrderShippingInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderShippingInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderShippingInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'vendor' => 'string',
        'postal_service_id' => 'string',
        'postal_service_name' => 'string',
        'total_weight' => 'float',
        'item_weight' => 'float',
        'package_category_id' => 'string',
        'package_category' => 'string',
        'package_type_id' => 'string',
        'package_type' => 'string',
        'postage_cost' => 'float',
        'postage_cost_ex_tax' => 'float',
        'tracking_number' => 'string',
        'manual_adjust' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'vendor' => null,
        'postal_service_id' => 'uuid',
        'postal_service_name' => null,
        'total_weight' => 'double',
        'item_weight' => 'double',
        'package_category_id' => 'uuid',
        'package_category' => null,
        'package_type_id' => 'uuid',
        'package_type' => null,
        'postage_cost' => 'double',
        'postage_cost_ex_tax' => 'double',
        'tracking_number' => null,
        'manual_adjust' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'vendor' => false,
        'postal_service_id' => false,
        'postal_service_name' => false,
        'total_weight' => false,
        'item_weight' => false,
        'package_category_id' => false,
        'package_category' => false,
        'package_type_id' => false,
        'package_type' => false,
        'postage_cost' => false,
        'postage_cost_ex_tax' => false,
        'tracking_number' => false,
        'manual_adjust' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'vendor' => 'Vendor',
        'postal_service_id' => 'PostalServiceId',
        'postal_service_name' => 'PostalServiceName',
        'total_weight' => 'TotalWeight',
        'item_weight' => 'ItemWeight',
        'package_category_id' => 'PackageCategoryId',
        'package_category' => 'PackageCategory',
        'package_type_id' => 'PackageTypeId',
        'package_type' => 'PackageType',
        'postage_cost' => 'PostageCost',
        'postage_cost_ex_tax' => 'PostageCostExTax',
        'tracking_number' => 'TrackingNumber',
        'manual_adjust' => 'ManualAdjust'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'vendor' => 'setVendor',
        'postal_service_id' => 'setPostalServiceId',
        'postal_service_name' => 'setPostalServiceName',
        'total_weight' => 'setTotalWeight',
        'item_weight' => 'setItemWeight',
        'package_category_id' => 'setPackageCategoryId',
        'package_category' => 'setPackageCategory',
        'package_type_id' => 'setPackageTypeId',
        'package_type' => 'setPackageType',
        'postage_cost' => 'setPostageCost',
        'postage_cost_ex_tax' => 'setPostageCostExTax',
        'tracking_number' => 'setTrackingNumber',
        'manual_adjust' => 'setManualAdjust'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'vendor' => 'getVendor',
        'postal_service_id' => 'getPostalServiceId',
        'postal_service_name' => 'getPostalServiceName',
        'total_weight' => 'getTotalWeight',
        'item_weight' => 'getItemWeight',
        'package_category_id' => 'getPackageCategoryId',
        'package_category' => 'getPackageCategory',
        'package_type_id' => 'getPackageTypeId',
        'package_type' => 'getPackageType',
        'postage_cost' => 'getPostageCost',
        'postage_cost_ex_tax' => 'getPostageCostExTax',
        'tracking_number' => 'getTrackingNumber',
        'manual_adjust' => 'getManualAdjust'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('vendor', $data ?? [], null);
        $this->setIfExists('postal_service_id', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('package_category_id', $data ?? [], null);
        $this->setIfExists('package_category', $data ?? [], null);
        $this->setIfExists('package_type_id', $data ?? [], null);
        $this->setIfExists('package_type', $data ?? [], null);
        $this->setIfExists('postage_cost', $data ?? [], null);
        $this->setIfExists('postage_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('manual_adjust', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets vendor
     *
     * @return string|null
     */
    public function getVendor()
    {
        return $this->container['vendor'];
    }

    /**
     * Sets vendor
     *
     * @param string|null $vendor Courier name (e.g. Royal Mail)
     *
     * @return self
     */
    public function setVendor($vendor)
    {
        if (is_null($vendor)) {
            throw new \InvalidArgumentException('non-nullable vendor cannot be null');
        }
        $this->container['vendor'] = $vendor;

        return $this;
    }

    /**
     * Gets postal_service_id
     *
     * @return string|null
     */
    public function getPostalServiceId()
    {
        return $this->container['postal_service_id'];
    }

    /**
     * Sets postal_service_id
     *
     * @param string|null $postal_service_id Postal service ID
     *
     * @return self
     */
    public function setPostalServiceId($postal_service_id)
    {
        if (is_null($postal_service_id)) {
            throw new \InvalidArgumentException('non-nullable postal_service_id cannot be null');
        }
        $this->container['postal_service_id'] = $postal_service_id;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name Postal service name (e.g. Next day delivery)
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Order total weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight If order is processed
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets package_category_id
     *
     * @return string|null
     */
    public function getPackageCategoryId()
    {
        return $this->container['package_category_id'];
    }

    /**
     * Sets package_category_id
     *
     * @param string|null $package_category_id Package category ID
     *
     * @return self
     */
    public function setPackageCategoryId($package_category_id)
    {
        if (is_null($package_category_id)) {
            throw new \InvalidArgumentException('non-nullable package_category_id cannot be null');
        }
        $this->container['package_category_id'] = $package_category_id;

        return $this;
    }

    /**
     * Gets package_category
     *
     * @return string|null
     */
    public function getPackageCategory()
    {
        return $this->container['package_category'];
    }

    /**
     * Sets package_category
     *
     * @param string|null $package_category Package category name
     *
     * @return self
     */
    public function setPackageCategory($package_category)
    {
        if (is_null($package_category)) {
            throw new \InvalidArgumentException('non-nullable package_category cannot be null');
        }
        $this->container['package_category'] = $package_category;

        return $this;
    }

    /**
     * Gets package_type_id
     *
     * @return string|null
     */
    public function getPackageTypeId()
    {
        return $this->container['package_type_id'];
    }

    /**
     * Sets package_type_id
     *
     * @param string|null $package_type_id Package type ID
     *
     * @return self
     */
    public function setPackageTypeId($package_type_id)
    {
        if (is_null($package_type_id)) {
            throw new \InvalidArgumentException('non-nullable package_type_id cannot be null');
        }
        $this->container['package_type_id'] = $package_type_id;

        return $this;
    }

    /**
     * Gets package_type
     *
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->container['package_type'];
    }

    /**
     * Sets package_type
     *
     * @param string|null $package_type Package type name
     *
     * @return self
     */
    public function setPackageType($package_type)
    {
        if (is_null($package_type)) {
            throw new \InvalidArgumentException('non-nullable package_type cannot be null');
        }
        $this->container['package_type'] = $package_type;

        return $this;
    }

    /**
     * Gets postage_cost
     *
     * @return float|null
     */
    public function getPostageCost()
    {
        return $this->container['postage_cost'];
    }

    /**
     * Sets postage_cost
     *
     * @param float|null $postage_cost Order postage cost
     *
     * @return self
     */
    public function setPostageCost($postage_cost)
    {
        if (is_null($postage_cost)) {
            throw new \InvalidArgumentException('non-nullable postage_cost cannot be null');
        }
        $this->container['postage_cost'] = $postage_cost;

        return $this;
    }

    /**
     * Gets postage_cost_ex_tax
     *
     * @return float|null
     */
    public function getPostageCostExTax()
    {
        return $this->container['postage_cost_ex_tax'];
    }

    /**
     * Sets postage_cost_ex_tax
     *
     * @param float|null $postage_cost_ex_tax Order postage cost excluding tax
     *
     * @return self
     */
    public function setPostageCostExTax($postage_cost_ex_tax)
    {
        if (is_null($postage_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable postage_cost_ex_tax cannot be null');
        }
        $this->container['postage_cost_ex_tax'] = $postage_cost_ex_tax;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number Order tracking number provided by courier
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets manual_adjust
     *
     * @return bool|null
     */
    public function getManualAdjust()
    {
        return $this->container['manual_adjust'];
    }

    /**
     * Sets manual_adjust
     *
     * @param bool|null $manual_adjust If there is an adjustment to shipping cost was made
     *
     * @return self
     */
    public function setManualAdjust($manual_adjust)
    {
        if (is_null($manual_adjust)) {
            throw new \InvalidArgumentException('non-nullable manual_adjust cannot be null');
        }
        $this->container['manual_adjust'] = $manual_adjust;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


