<?php
/**
 * OrderPackagingSplit
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OrderPackagingSplit Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderPackagingSplit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderPackagingSplit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_bin_id' => 'string',
        'pk_postal_service_id' => 'string',
        'packaging_weight' => 'float',
        'fk_packaging_type_id' => 'string',
        'items' => '\Linnworks\Orders\Model\OrderPackagingSplitItem[]',
        'total_weight' => 'float',
        'width' => 'float',
        'height' => 'float',
        'depth' => 'float',
        'tracking_numbers' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_bin_id' => 'uuid',
        'pk_postal_service_id' => 'uuid',
        'packaging_weight' => 'double',
        'fk_packaging_type_id' => 'uuid',
        'items' => null,
        'total_weight' => 'double',
        'width' => 'double',
        'height' => 'double',
        'depth' => 'double',
        'tracking_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_bin_id' => false,
        'pk_postal_service_id' => false,
        'packaging_weight' => false,
        'fk_packaging_type_id' => false,
        'items' => false,
        'total_weight' => false,
        'width' => false,
        'height' => false,
        'depth' => false,
        'tracking_numbers' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_bin_id' => 'pkBinId',
        'pk_postal_service_id' => 'pkPostalServiceId',
        'packaging_weight' => 'PackagingWeight',
        'fk_packaging_type_id' => 'fkPackagingTypeId',
        'items' => 'Items',
        'total_weight' => 'TotalWeight',
        'width' => 'Width',
        'height' => 'Height',
        'depth' => 'Depth',
        'tracking_numbers' => 'TrackingNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_bin_id' => 'setPkBinId',
        'pk_postal_service_id' => 'setPkPostalServiceId',
        'packaging_weight' => 'setPackagingWeight',
        'fk_packaging_type_id' => 'setFkPackagingTypeId',
        'items' => 'setItems',
        'total_weight' => 'setTotalWeight',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'tracking_numbers' => 'setTrackingNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_bin_id' => 'getPkBinId',
        'pk_postal_service_id' => 'getPkPostalServiceId',
        'packaging_weight' => 'getPackagingWeight',
        'fk_packaging_type_id' => 'getFkPackagingTypeId',
        'items' => 'getItems',
        'total_weight' => 'getTotalWeight',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'tracking_numbers' => 'getTrackingNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_bin_id', $data ?? [], null);
        $this->setIfExists('pk_postal_service_id', $data ?? [], null);
        $this->setIfExists('packaging_weight', $data ?? [], null);
        $this->setIfExists('fk_packaging_type_id', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('tracking_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_bin_id
     *
     * @return string|null
     */
    public function getPkBinId()
    {
        return $this->container['pk_bin_id'];
    }

    /**
     * Sets pk_bin_id
     *
     * @param string|null $pk_bin_id Bin ID
     *
     * @return self
     */
    public function setPkBinId($pk_bin_id)
    {
        if (is_null($pk_bin_id)) {
            throw new \InvalidArgumentException('non-nullable pk_bin_id cannot be null');
        }
        $this->container['pk_bin_id'] = $pk_bin_id;

        return $this;
    }

    /**
     * Gets pk_postal_service_id
     *
     * @return string|null
     */
    public function getPkPostalServiceId()
    {
        return $this->container['pk_postal_service_id'];
    }

    /**
     * Sets pk_postal_service_id
     *
     * @param string|null $pk_postal_service_id Postal service ID
     *
     * @return self
     */
    public function setPkPostalServiceId($pk_postal_service_id)
    {
        if (is_null($pk_postal_service_id)) {
            throw new \InvalidArgumentException('non-nullable pk_postal_service_id cannot be null');
        }
        $this->container['pk_postal_service_id'] = $pk_postal_service_id;

        return $this;
    }

    /**
     * Gets packaging_weight
     *
     * @return float|null
     */
    public function getPackagingWeight()
    {
        return $this->container['packaging_weight'];
    }

    /**
     * Sets packaging_weight
     *
     * @param float|null $packaging_weight Order packaging weight
     *
     * @return self
     */
    public function setPackagingWeight($packaging_weight)
    {
        if (is_null($packaging_weight)) {
            throw new \InvalidArgumentException('non-nullable packaging_weight cannot be null');
        }
        $this->container['packaging_weight'] = $packaging_weight;

        return $this;
    }

    /**
     * Gets fk_packaging_type_id
     *
     * @return string|null
     */
    public function getFkPackagingTypeId()
    {
        return $this->container['fk_packaging_type_id'];
    }

    /**
     * Sets fk_packaging_type_id
     *
     * @param string|null $fk_packaging_type_id Order packaging type
     *
     * @return self
     */
    public function setFkPackagingTypeId($fk_packaging_type_id)
    {
        if (is_null($fk_packaging_type_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_type_id cannot be null');
        }
        $this->container['fk_packaging_type_id'] = $fk_packaging_type_id;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\OrderPackagingSplitItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\OrderPackagingSplitItem[]|null $items List of items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Total weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width Width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height Height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth Depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets tracking_numbers
     *
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->container['tracking_numbers'];
    }

    /**
     * Sets tracking_numbers
     *
     * @param string|null $tracking_numbers Tracking number
     *
     * @return self
     */
    public function setTrackingNumbers($tracking_numbers)
    {
        if (is_null($tracking_numbers)) {
            throw new \InvalidArgumentException('non-nullable tracking_numbers cannot be null');
        }
        $this->container['tracking_numbers'] = $tracking_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


