<?php
/**
 * OpenOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * OpenOrder Class Doc Comment
 *
 * @category Class
 * @description comment class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OpenOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OpenOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'num_order_id' => 'int',
        'general_info' => '\Linnworks\Orders\Model\OrderGeneralInfo',
        'shipping_info' => '\Linnworks\Orders\Model\OrderShippingInfo',
        'customer_info' => '\Linnworks\Orders\Model\OrderCustomerInfo',
        'totals_info' => '\Linnworks\Orders\Model\OrderTotalsInfo',
        'tax_info' => '\Linnworks\Orders\Model\OrderTaxInfo',
        'folder_name' => 'string[]',
        'is_post_filtered_out' => 'bool',
        'can_fulfil' => 'bool',
        'fulfillment' => '\Linnworks\Orders\Model\OrderFulfillmentState',
        'items' => '\Linnworks\Orders\Model\OrderItem[]',
        'has_items' => 'bool',
        'total_items_sum' => 'int',
        'order_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'num_order_id' => 'int32',
        'general_info' => null,
        'shipping_info' => null,
        'customer_info' => null,
        'totals_info' => null,
        'tax_info' => null,
        'folder_name' => null,
        'is_post_filtered_out' => null,
        'can_fulfil' => null,
        'fulfillment' => null,
        'items' => null,
        'has_items' => null,
        'total_items_sum' => 'int32',
        'order_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'num_order_id' => false,
        'general_info' => false,
        'shipping_info' => false,
        'customer_info' => false,
        'totals_info' => false,
        'tax_info' => false,
        'folder_name' => false,
        'is_post_filtered_out' => false,
        'can_fulfil' => false,
        'fulfillment' => false,
        'items' => false,
        'has_items' => false,
        'total_items_sum' => false,
        'order_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'num_order_id' => 'NumOrderId',
        'general_info' => 'GeneralInfo',
        'shipping_info' => 'ShippingInfo',
        'customer_info' => 'CustomerInfo',
        'totals_info' => 'TotalsInfo',
        'tax_info' => 'TaxInfo',
        'folder_name' => 'FolderName',
        'is_post_filtered_out' => 'IsPostFilteredOut',
        'can_fulfil' => 'CanFulfil',
        'fulfillment' => 'Fulfillment',
        'items' => 'Items',
        'has_items' => 'HasItems',
        'total_items_sum' => 'TotalItemsSum',
        'order_id' => 'OrderId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'num_order_id' => 'setNumOrderId',
        'general_info' => 'setGeneralInfo',
        'shipping_info' => 'setShippingInfo',
        'customer_info' => 'setCustomerInfo',
        'totals_info' => 'setTotalsInfo',
        'tax_info' => 'setTaxInfo',
        'folder_name' => 'setFolderName',
        'is_post_filtered_out' => 'setIsPostFilteredOut',
        'can_fulfil' => 'setCanFulfil',
        'fulfillment' => 'setFulfillment',
        'items' => 'setItems',
        'has_items' => 'setHasItems',
        'total_items_sum' => 'setTotalItemsSum',
        'order_id' => 'setOrderId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'num_order_id' => 'getNumOrderId',
        'general_info' => 'getGeneralInfo',
        'shipping_info' => 'getShippingInfo',
        'customer_info' => 'getCustomerInfo',
        'totals_info' => 'getTotalsInfo',
        'tax_info' => 'getTaxInfo',
        'folder_name' => 'getFolderName',
        'is_post_filtered_out' => 'getIsPostFilteredOut',
        'can_fulfil' => 'getCanFulfil',
        'fulfillment' => 'getFulfillment',
        'items' => 'getItems',
        'has_items' => 'getHasItems',
        'total_items_sum' => 'getTotalItemsSum',
        'order_id' => 'getOrderId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('num_order_id', $data ?? [], null);
        $this->setIfExists('general_info', $data ?? [], null);
        $this->setIfExists('shipping_info', $data ?? [], null);
        $this->setIfExists('customer_info', $data ?? [], null);
        $this->setIfExists('totals_info', $data ?? [], null);
        $this->setIfExists('tax_info', $data ?? [], null);
        $this->setIfExists('folder_name', $data ?? [], null);
        $this->setIfExists('is_post_filtered_out', $data ?? [], null);
        $this->setIfExists('can_fulfil', $data ?? [], null);
        $this->setIfExists('fulfillment', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('has_items', $data ?? [], null);
        $this->setIfExists('total_items_sum', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets num_order_id
     *
     * @return int|null
     */
    public function getNumOrderId()
    {
        return $this->container['num_order_id'];
    }

    /**
     * Sets num_order_id
     *
     * @param int|null $num_order_id Linnworks order number
     *
     * @return self
     */
    public function setNumOrderId($num_order_id)
    {
        if (is_null($num_order_id)) {
            throw new \InvalidArgumentException('non-nullable num_order_id cannot be null');
        }
        $this->container['num_order_id'] = $num_order_id;

        return $this;
    }

    /**
     * Gets general_info
     *
     * @return \Linnworks\Orders\Model\OrderGeneralInfo|null
     */
    public function getGeneralInfo()
    {
        return $this->container['general_info'];
    }

    /**
     * Sets general_info
     *
     * @param \Linnworks\Orders\Model\OrderGeneralInfo|null $general_info general_info
     *
     * @return self
     */
    public function setGeneralInfo($general_info)
    {
        if (is_null($general_info)) {
            throw new \InvalidArgumentException('non-nullable general_info cannot be null');
        }
        $this->container['general_info'] = $general_info;

        return $this;
    }

    /**
     * Gets shipping_info
     *
     * @return \Linnworks\Orders\Model\OrderShippingInfo|null
     */
    public function getShippingInfo()
    {
        return $this->container['shipping_info'];
    }

    /**
     * Sets shipping_info
     *
     * @param \Linnworks\Orders\Model\OrderShippingInfo|null $shipping_info shipping_info
     *
     * @return self
     */
    public function setShippingInfo($shipping_info)
    {
        if (is_null($shipping_info)) {
            throw new \InvalidArgumentException('non-nullable shipping_info cannot be null');
        }
        $this->container['shipping_info'] = $shipping_info;

        return $this;
    }

    /**
     * Gets customer_info
     *
     * @return \Linnworks\Orders\Model\OrderCustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->container['customer_info'];
    }

    /**
     * Sets customer_info
     *
     * @param \Linnworks\Orders\Model\OrderCustomerInfo|null $customer_info customer_info
     *
     * @return self
     */
    public function setCustomerInfo($customer_info)
    {
        if (is_null($customer_info)) {
            throw new \InvalidArgumentException('non-nullable customer_info cannot be null');
        }
        $this->container['customer_info'] = $customer_info;

        return $this;
    }

    /**
     * Gets totals_info
     *
     * @return \Linnworks\Orders\Model\OrderTotalsInfo|null
     */
    public function getTotalsInfo()
    {
        return $this->container['totals_info'];
    }

    /**
     * Sets totals_info
     *
     * @param \Linnworks\Orders\Model\OrderTotalsInfo|null $totals_info totals_info
     *
     * @return self
     */
    public function setTotalsInfo($totals_info)
    {
        if (is_null($totals_info)) {
            throw new \InvalidArgumentException('non-nullable totals_info cannot be null');
        }
        $this->container['totals_info'] = $totals_info;

        return $this;
    }

    /**
     * Gets tax_info
     *
     * @return \Linnworks\Orders\Model\OrderTaxInfo|null
     */
    public function getTaxInfo()
    {
        return $this->container['tax_info'];
    }

    /**
     * Sets tax_info
     *
     * @param \Linnworks\Orders\Model\OrderTaxInfo|null $tax_info tax_info
     *
     * @return self
     */
    public function setTaxInfo($tax_info)
    {
        if (is_null($tax_info)) {
            throw new \InvalidArgumentException('non-nullable tax_info cannot be null');
        }
        $this->container['tax_info'] = $tax_info;

        return $this;
    }

    /**
     * Gets folder_name
     *
     * @return string[]|null
     */
    public function getFolderName()
    {
        return $this->container['folder_name'];
    }

    /**
     * Sets folder_name
     *
     * @param string[]|null $folder_name Folder name of an order if any assigned
     *
     * @return self
     */
    public function setFolderName($folder_name)
    {
        if (is_null($folder_name)) {
            throw new \InvalidArgumentException('non-nullable folder_name cannot be null');
        }
        $this->container['folder_name'] = $folder_name;

        return $this;
    }

    /**
     * Gets is_post_filtered_out
     *
     * @return bool|null
     */
    public function getIsPostFilteredOut()
    {
        return $this->container['is_post_filtered_out'];
    }

    /**
     * Sets is_post_filtered_out
     *
     * @param bool|null $is_post_filtered_out is_post_filtered_out
     *
     * @return self
     */
    public function setIsPostFilteredOut($is_post_filtered_out)
    {
        if (is_null($is_post_filtered_out)) {
            throw new \InvalidArgumentException('non-nullable is_post_filtered_out cannot be null');
        }
        $this->container['is_post_filtered_out'] = $is_post_filtered_out;

        return $this;
    }

    /**
     * Gets can_fulfil
     *
     * @return bool|null
     */
    public function getCanFulfil()
    {
        return $this->container['can_fulfil'];
    }

    /**
     * Sets can_fulfil
     *
     * @param bool|null $can_fulfil can_fulfil
     *
     * @return self
     */
    public function setCanFulfil($can_fulfil)
    {
        if (is_null($can_fulfil)) {
            throw new \InvalidArgumentException('non-nullable can_fulfil cannot be null');
        }
        $this->container['can_fulfil'] = $can_fulfil;

        return $this;
    }

    /**
     * Gets fulfillment
     *
     * @return \Linnworks\Orders\Model\OrderFulfillmentState|null
     */
    public function getFulfillment()
    {
        return $this->container['fulfillment'];
    }

    /**
     * Sets fulfillment
     *
     * @param \Linnworks\Orders\Model\OrderFulfillmentState|null $fulfillment fulfillment
     *
     * @return self
     */
    public function setFulfillment($fulfillment)
    {
        if (is_null($fulfillment)) {
            throw new \InvalidArgumentException('non-nullable fulfillment cannot be null');
        }
        $this->container['fulfillment'] = $fulfillment;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\OrderItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\OrderItem[]|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets has_items
     *
     * @return bool|null
     */
    public function getHasItems()
    {
        return $this->container['has_items'];
    }

    /**
     * Sets has_items
     *
     * @param bool|null $has_items has_items
     *
     * @return self
     */
    public function setHasItems($has_items)
    {
        if (is_null($has_items)) {
            throw new \InvalidArgumentException('non-nullable has_items cannot be null');
        }
        $this->container['has_items'] = $has_items;

        return $this;
    }

    /**
     * Gets total_items_sum
     *
     * @return int|null
     */
    public function getTotalItemsSum()
    {
        return $this->container['total_items_sum'];
    }

    /**
     * Sets total_items_sum
     *
     * @param int|null $total_items_sum total_items_sum
     *
     * @return self
     */
    public function setTotalItemsSum($total_items_sum)
    {
        if (is_null($total_items_sum)) {
            throw new \InvalidArgumentException('non-nullable total_items_sum cannot be null');
        }
        $this->container['total_items_sum'] = $total_items_sum;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Order ID (pkOrderID)
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


