<?php
/**
 * FieldsFilter
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * FieldsFilter Class Doc Comment
 *
 * @category Class
 * @description Fields filter
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldsFilter implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FieldsFilter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'text_fields' => '\Linnworks\Orders\Model\TextFieldFilter[]',
        'boolean_fields' => '\Linnworks\Orders\Model\BooleanFieldFilter[]',
        'numeric_fields' => '\Linnworks\Orders\Model\NumericFieldFilter[]',
        'date_fields' => '\Linnworks\Orders\Model\DateFieldFilter[]',
        'list_fields' => '\Linnworks\Orders\Model\ListFieldFilter[]',
        'field_visibility' => '\Linnworks\Orders\Model\FieldVisibility[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'text_fields' => null,
        'boolean_fields' => null,
        'numeric_fields' => null,
        'date_fields' => null,
        'list_fields' => null,
        'field_visibility' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'text_fields' => false,
        'boolean_fields' => false,
        'numeric_fields' => false,
        'date_fields' => false,
        'list_fields' => false,
        'field_visibility' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'text_fields' => 'TextFields',
        'boolean_fields' => 'BooleanFields',
        'numeric_fields' => 'NumericFields',
        'date_fields' => 'DateFields',
        'list_fields' => 'ListFields',
        'field_visibility' => 'FieldVisibility'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'text_fields' => 'setTextFields',
        'boolean_fields' => 'setBooleanFields',
        'numeric_fields' => 'setNumericFields',
        'date_fields' => 'setDateFields',
        'list_fields' => 'setListFields',
        'field_visibility' => 'setFieldVisibility'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'text_fields' => 'getTextFields',
        'boolean_fields' => 'getBooleanFields',
        'numeric_fields' => 'getNumericFields',
        'date_fields' => 'getDateFields',
        'list_fields' => 'getListFields',
        'field_visibility' => 'getFieldVisibility'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('text_fields', $data ?? [], null);
        $this->setIfExists('boolean_fields', $data ?? [], null);
        $this->setIfExists('numeric_fields', $data ?? [], null);
        $this->setIfExists('date_fields', $data ?? [], null);
        $this->setIfExists('list_fields', $data ?? [], null);
        $this->setIfExists('field_visibility', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets text_fields
     *
     * @return \Linnworks\Orders\Model\TextFieldFilter[]|null
     */
    public function getTextFields()
    {
        return $this->container['text_fields'];
    }

    /**
     * Sets text_fields
     *
     * @param \Linnworks\Orders\Model\TextFieldFilter[]|null $text_fields Text type field filters
     *
     * @return self
     */
    public function setTextFields($text_fields)
    {
        if (is_null($text_fields)) {
            throw new \InvalidArgumentException('non-nullable text_fields cannot be null');
        }
        $this->container['text_fields'] = $text_fields;

        return $this;
    }

    /**
     * Gets boolean_fields
     *
     * @return \Linnworks\Orders\Model\BooleanFieldFilter[]|null
     */
    public function getBooleanFields()
    {
        return $this->container['boolean_fields'];
    }

    /**
     * Sets boolean_fields
     *
     * @param \Linnworks\Orders\Model\BooleanFieldFilter[]|null $boolean_fields Boolean type field filters
     *
     * @return self
     */
    public function setBooleanFields($boolean_fields)
    {
        if (is_null($boolean_fields)) {
            throw new \InvalidArgumentException('non-nullable boolean_fields cannot be null');
        }
        $this->container['boolean_fields'] = $boolean_fields;

        return $this;
    }

    /**
     * Gets numeric_fields
     *
     * @return \Linnworks\Orders\Model\NumericFieldFilter[]|null
     */
    public function getNumericFields()
    {
        return $this->container['numeric_fields'];
    }

    /**
     * Sets numeric_fields
     *
     * @param \Linnworks\Orders\Model\NumericFieldFilter[]|null $numeric_fields Numerical type field filters
     *
     * @return self
     */
    public function setNumericFields($numeric_fields)
    {
        if (is_null($numeric_fields)) {
            throw new \InvalidArgumentException('non-nullable numeric_fields cannot be null');
        }
        $this->container['numeric_fields'] = $numeric_fields;

        return $this;
    }

    /**
     * Gets date_fields
     *
     * @return \Linnworks\Orders\Model\DateFieldFilter[]|null
     */
    public function getDateFields()
    {
        return $this->container['date_fields'];
    }

    /**
     * Sets date_fields
     *
     * @param \Linnworks\Orders\Model\DateFieldFilter[]|null $date_fields Date type field filters
     *
     * @return self
     */
    public function setDateFields($date_fields)
    {
        if (is_null($date_fields)) {
            throw new \InvalidArgumentException('non-nullable date_fields cannot be null');
        }
        $this->container['date_fields'] = $date_fields;

        return $this;
    }

    /**
     * Gets list_fields
     *
     * @return \Linnworks\Orders\Model\ListFieldFilter[]|null
     */
    public function getListFields()
    {
        return $this->container['list_fields'];
    }

    /**
     * Sets list_fields
     *
     * @param \Linnworks\Orders\Model\ListFieldFilter[]|null $list_fields List type field filters
     *
     * @return self
     */
    public function setListFields($list_fields)
    {
        if (is_null($list_fields)) {
            throw new \InvalidArgumentException('non-nullable list_fields cannot be null');
        }
        $this->container['list_fields'] = $list_fields;

        return $this;
    }

    /**
     * Gets field_visibility
     *
     * @return \Linnworks\Orders\Model\FieldVisibility[]|null
     */
    public function getFieldVisibility()
    {
        return $this->container['field_visibility'];
    }

    /**
     * Sets field_visibility
     *
     * @param \Linnworks\Orders\Model\FieldVisibility[]|null $field_visibility field_visibility
     *
     * @return self
     */
    public function setFieldVisibility($field_visibility)
    {
        if (is_null($field_visibility)) {
            throw new \InvalidArgumentException('non-nullable field_visibility cannot be null');
        }
        $this->container['field_visibility'] = $field_visibility;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


