<?php
/**
 * FieldVisibility
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * FieldVisibility Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldVisibility implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FieldVisibility';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'visible' => 'bool',
        'can_filter' => 'bool',
        'can_sort' => 'bool',
        'field_type' => 'string',
        'code' => 'string',
        'sub_fields' => '\Linnworks\Orders\Model\FieldVisibility[]',
        'is_filter_only' => 'bool',
        'hot_button_icon' => 'string',
        'hot_button_key' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'visible' => null,
        'can_filter' => null,
        'can_sort' => null,
        'field_type' => null,
        'code' => null,
        'sub_fields' => null,
        'is_filter_only' => null,
        'hot_button_icon' => null,
        'hot_button_key' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'visible' => false,
        'can_filter' => false,
        'can_sort' => false,
        'field_type' => false,
        'code' => false,
        'sub_fields' => false,
        'is_filter_only' => false,
        'hot_button_icon' => false,
        'hot_button_key' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'Name',
        'visible' => 'Visible',
        'can_filter' => 'CanFilter',
        'can_sort' => 'CanSort',
        'field_type' => 'FieldType',
        'code' => 'Code',
        'sub_fields' => 'SubFields',
        'is_filter_only' => 'IsFilterOnly',
        'hot_button_icon' => 'HotButtonIcon',
        'hot_button_key' => 'HotButtonKey'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'visible' => 'setVisible',
        'can_filter' => 'setCanFilter',
        'can_sort' => 'setCanSort',
        'field_type' => 'setFieldType',
        'code' => 'setCode',
        'sub_fields' => 'setSubFields',
        'is_filter_only' => 'setIsFilterOnly',
        'hot_button_icon' => 'setHotButtonIcon',
        'hot_button_key' => 'setHotButtonKey'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'visible' => 'getVisible',
        'can_filter' => 'getCanFilter',
        'can_sort' => 'getCanSort',
        'field_type' => 'getFieldType',
        'code' => 'getCode',
        'sub_fields' => 'getSubFields',
        'is_filter_only' => 'getIsFilterOnly',
        'hot_button_icon' => 'getHotButtonIcon',
        'hot_button_key' => 'getHotButtonKey'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FIELD_TYPE_DECIMAL = 'Decimal';
    public const FIELD_TYPE_TEXT = 'Text';
    public const FIELD_TYPE__LIST = 'List';
    public const FIELD_TYPE_DATE = 'Date';
    public const FIELD_TYPE_BOOLEAN = 'Boolean';
    public const FIELD_TYPE_NONE = 'None';
    public const FIELD_TYPE_BUTTON = 'Button';
    public const FIELD_TYPE_HTML_LIST = 'HtmlList';
    public const FIELD_TYPE_INTEGER = 'Integer';
    public const CODE_NONE = 'NONE';
    public const CODE_GENERAL_INFO = 'GENERAL_INFO';
    public const CODE_GENERAL_INFO_ORDER_ID = 'GENERAL_INFO_ORDER_ID';
    public const CODE_GENERAL_INFO_REFERENCE_NUMBER = 'GENERAL_INFO_REFERENCE_NUMBER';
    public const CODE_GENERAL_INFO_CHANNEL_REFERENCE_NUMBER = 'GENERAL_INFO_CHANNEL_REFERENCE_NUMBER';
    public const CODE_GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER = 'GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER';
    public const CODE_GENERAL_INFO_DATE = 'GENERAL_INFO_DATE';
    public const CODE_GENERAL_INFO_SOURCE = 'GENERAL_INFO_SOURCE';
    public const CODE_GENERAL_INFO_SUBSOURCE = 'GENERAL_INFO_SUBSOURCE';
    public const CODE_GENERAL_INFO_LABEL_PRINTED = 'GENERAL_INFO_LABEL_PRINTED';
    public const CODE_GENERAL_INFO_INVOICE_PRINTED = 'GENERAL_INFO_INVOICE_PRINTED';
    public const CODE_GENERAL_INFO_PICK_LIST_PRINTED = 'GENERAL_INFO_PICK_LIST_PRINTED';
    public const CODE_GENERAL_INFO_IS_RULE_RUN = 'GENERAL_INFO_IS_RULE_RUN';
    public const CODE_GENERAL_INFO_NOTES = 'GENERAL_INFO_NOTES';
    public const CODE_GENERAL_INFO_LOCKED = 'GENERAL_INFO_LOCKED';
    public const CODE_GENERAL_INFO_PARKED = 'GENERAL_INFO_PARKED';
    public const CODE_GENERAL_INFO_PART_SHIPPED = 'GENERAL_INFO_PART_SHIPPED';
    public const CODE_GENERAL_INFO_TAG = 'GENERAL_INFO_TAG';
    public const CODE_GENERAL_INFO_IDENTIFIER = 'GENERAL_INFO_IDENTIFIER';
    public const CODE_GENERAL_INFO_STATUS = 'GENERAL_INFO_STATUS';
    public const CODE_GENERAL_INFO_DESPATCHBYDATE = 'GENERAL_INFO_DESPATCHBYDATE';
    public const CODE_GENERAL_INFO_ITEMS_COUNT = 'GENERAL_INFO_ITEMS_COUNT';
    public const CODE_GENERAL_INFO_SHIPPING_LABEL_ERROR = 'GENERAL_INFO_SHIPPING_LABEL_ERROR';
    public const CODE_GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR = 'GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR';
    public const CODE_SHIPPING_INFORMATION = 'SHIPPING_INFORMATION';
    public const CODE_SHIPPING_INFORMATION_VENDOR = 'SHIPPING_INFORMATION_VENDOR';
    public const CODE_SHIPPING_INFORMATION_SERVICE = 'SHIPPING_INFORMATION_SERVICE';
    public const CODE_SHIPPING_INFORMATION_WEIGHT = 'SHIPPING_INFORMATION_WEIGHT';
    public const CODE_SHIPPING_INFORMATION_PACKAGING_GROUP = 'SHIPPING_INFORMATION_PACKAGING_GROUP';
    public const CODE_SHIPPING_INFORMATION_PACKAGING_TYPE = 'SHIPPING_INFORMATION_PACKAGING_TYPE';
    public const CODE_SHIPPING_INFORMATION_COST = 'SHIPPING_INFORMATION_COST';
    public const CODE_SHIPPING_INFORMATION_TRACKING_NUMBER = 'SHIPPING_INFORMATION_TRACKING_NUMBER';
    public const CODE_SHIPPING_INFORMATION_SERVICE_ID = 'SHIPPING_INFORMATION_SERVICE_ID';
    public const CODE_SHIPPING_SCHEDULED_DELIVERY_START = 'SHIPPING_SCHEDULED_DELIVERY_START';
    public const CODE_SHIPPING_SCHEDULED_DELIVERY_END = 'SHIPPING_SCHEDULED_DELIVERY_END';
    public const CODE_CUSTOMER = 'CUSTOMER';
    public const CODE_CUSTOMER_ADDRESS_ADDRESS = 'CUSTOMER_ADDRESS_ADDRESS';
    public const CODE_CUSTOMER_ADDRESS_FULL_NAME = 'CUSTOMER_ADDRESS_FULL_NAME';
    public const CODE_CUSTOMER_ADDRESS_COMPANY = 'CUSTOMER_ADDRESS_COMPANY';
    public const CODE_CUSTOMER_ADDRESS_POSTCODE = 'CUSTOMER_ADDRESS_POSTCODE';
    public const CODE_CUSTOMER_ADDRESS_COUNTY = 'CUSTOMER_ADDRESS_COUNTY';
    public const CODE_CUSTOMER_ADDRESS_COUNTRY = 'CUSTOMER_ADDRESS_COUNTRY';
    public const CODE_CUSTOMER_ADDRESS_COUNTRY_ZONE = 'CUSTOMER_ADDRESS_COUNTRY_ZONE';
    public const CODE_CUSTOMER_ADDRESS_ADDRESS1 = 'CUSTOMER_ADDRESS_ADDRESS1';
    public const CODE_CUSTOMER_ADDRESS_ADDRESS2 = 'CUSTOMER_ADDRESS_ADDRESS2';
    public const CODE_CUSTOMER_ADDRESS_ADDRESS3 = 'CUSTOMER_ADDRESS_ADDRESS3';
    public const CODE_CUSTOMER_ADDRESS_TOWN = 'CUSTOMER_ADDRESS_TOWN';
    public const CODE_CUSTOMER_EMAIL = 'CUSTOMER_EMAIL';
    public const CODE_CUSTOMER_CHANNEL_BUYER_NAME = 'CUSTOMER_CHANNEL_BUYER_NAME';
    public const CODE_CUSTOMER_PHONE = 'CUSTOMER_PHONE';
    public const CODE_CUSTOMER_BILLING_ADDRESS = 'CUSTOMER_BILLING_ADDRESS';
    public const CODE_CUSTOMER_BILLING_ADDRESS_NAME = 'CUSTOMER_BILLING_ADDRESS_NAME';
    public const CODE_CUSTOMER_BILLING_ADDRESS_COMPANY = 'CUSTOMER_BILLING_ADDRESS_COMPANY';
    public const CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS1 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS1';
    public const CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS2 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS2';
    public const CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS3 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS3';
    public const CODE_CUSTOMER_BILLING_ADDRESS_TOWN = 'CUSTOMER_BILLING_ADDRESS_TOWN';
    public const CODE_CUSTOMER_BILLING_ADDRESS_REGION = 'CUSTOMER_BILLING_ADDRESS_REGION';
    public const CODE_CUSTOMER_BILLING_ADDRESS_POSTCODE = 'CUSTOMER_BILLING_ADDRESS_POSTCODE';
    public const CODE_CUSTOMER_BILLING_ADDRESS_COUNTRY = 'CUSTOMER_BILLING_ADDRESS_COUNTRY';
    public const CODE_CUSTOMER_BILLING_EMAIL = 'CUSTOMER_BILLING_EMAIL';
    public const CODE_CUSTOMER_BILLING_PHONE = 'CUSTOMER_BILLING_PHONE';
    public const CODE_TOTALS = 'TOTALS';
    public const CODE_TOTALS_SUBTOTAL = 'TOTALS_SUBTOTAL';
    public const CODE_TOTALS_SHIPPING = 'TOTALS_SHIPPING';
    public const CODE_TOTALS_TAX = 'TOTALS_TAX';
    public const CODE_TOTALS_TOTAL = 'TOTALS_TOTAL';
    public const CODE_TOTALS_DISCOUNT = 'TOTALS_DISCOUNT';
    public const CODE_TOTALS_CURRENCY = 'TOTALS_CURRENCY';
    public const CODE_TOTALS_PAYMENT_METHOD = 'TOTALS_PAYMENT_METHOD';
    public const CODE_TOTALS_COUNTRY_TAX_RATE = 'TOTALS_COUNTRY_TAX_RATE';
    public const CODE_ORDER_TOTAL = 'ORDER_TOTAL';
    public const CODE_ORDER_TOTAL_TOTAL = 'ORDER_TOTAL_TOTAL';
    public const CODE_ORDER_TOTAL_CURRENCY = 'ORDER_TOTAL_CURRENCY';
    public const CODE_ORDER_TAX = 'ORDER_TAX';
    public const CODE_ORDER_TAX_TOTAL = 'ORDER_TAX_TOTAL';
    public const CODE_ORDER_TAX_CURRENCY = 'ORDER_TAX_CURRENCY';
    public const CODE_FOLDER = 'FOLDER';
    public const CODE_FOLDERS = 'FOLDERS';
    public const CODE_JOB = 'JOB';
    public const CODE_ITEMS = 'ITEMS';
    public const CODE_ITEMS_IMAGE = 'ITEMS_IMAGE';
    public const CODE_ITEMS_SKU = 'ITEMS_SKU';
    public const CODE_ITEMS_ORIGINAL_SKU = 'ITEMS_ORIGINAL_SKU';
    public const CODE_ITEMS_TITLE = 'ITEMS_TITLE';
    public const CODE_ITEMS_ORIGINAL_TITLE = 'ITEMS_ORIGINAL_TITLE';
    public const CODE_ITEMS_ITEM_NUMBER = 'ITEMS_ITEM_NUMBER';
    public const CODE_ITEMS_IS_SERVICE = 'ITEMS_IS_SERVICE';
    public const CODE_ITEMS_QUANTITY = 'ITEMS_QUANTITY';
    public const CODE_ITEMS_SOURCE = 'ITEMS_SOURCE';
    public const CODE_ITEMS_LINE = 'ITEMS_LINE';
    public const CODE_ITEMS_COST_INC_TAX = 'ITEMS_COST_INC_TAX';
    public const CODE_ITEMS_COST = 'ITEMS_COST';
    public const CODE_ITEMS_SALES_TAX = 'ITEMS_SALES_TAX';
    public const CODE_ITEMS_TAX_RATE = 'ITEMS_TAX_RATE';
    public const CODE_ITEMS_CURRENCY = 'ITEMS_CURRENCY';
    public const CODE_ITEMS_CATEGORY = 'ITEMS_CATEGORY';
    public const CODE_ITEMS_BINRACK = 'ITEMS_BINRACK';
    public const CODE_ITEMS_TAX_COST_INCLUSIVE = 'ITEMS_TAX_COST_INCLUSIVE';
    public const CODE_ITEMS_DISCOUNT = 'ITEMS_DISCOUNT';
    public const CODE_ITEMS_SUM_QUANTITY = 'ITEMS_SUM_QUANTITY';
    public const CODE_ITEMS_WEIGHT = 'ITEMS_WEIGHT';
    public const CODE_ITEMS_UNIT_COST = 'ITEMS_UNIT_COST';
    public const CODE_ITEMS_PRICE_PER_UNIT = 'ITEMS_PRICE_PER_UNIT';
    public const CODE_ITEMS_BATCHED = 'ITEMS_BATCHED';
    public const CODE_ITEMS_INVENTORY_TRACKING_TYPE = 'ITEMS_INVENTORY_TRACKING_TYPE';
    public const CODE_ITEMS_BARCODE_NUMBER = 'ITEMS_BARCODE_NUMBER';
    public const CODE_STOCK_LEVEL = 'STOCK_LEVEL';
    public const CODE_CAN_FULFIL = 'CAN_FULFIL';
    public const CODE_HOT_BUTTONS = 'HOT_BUTTONS';
    public const CODE_HOT_BUTTON = 'HOT_BUTTON';
    public const CODE_ADDITIONAL = 'ADDITIONAL';
    public const CODE_LOCATION_ID = 'LOCATION_ID';
    public const CODE_ITEMS_STOCKITEM_ID = 'ITEMS_STOCKITEM_ID';
    public const CODE_ITEMS_COMPOSITE_PARENT_ID = 'ITEMS_COMPOSITE_PARENT_ID';
    public const CODE_GENERAL_INFO_STOCK_ALLOCATION = 'GENERAL_INFO_STOCK_ALLOCATION';
    public const CODE_GENERAL_INFO_NOTE = 'GENERAL_INFO_NOTE';
    public const CODE_GENERAL_INFO_NOTE_COUNT = 'GENERAL_INFO_NOTE_COUNT';
    public const CODE_GENERAL_INFO_PICKWAVE_IDS = 'GENERAL_INFO_PICKWAVE_IDS';
    public const CODE_FULFILLMENT = 'FULFILLMENT';
    public const CODE_FULFILLMENT_STATE = 'FULFILLMENT_STATE';
    public const CODE_FULFILLMENT_ADDITIONAL = 'FULFILLMENT_ADDITIONAL';
    public const CODE_GENERAL_INFO_INVOICE_PRINT_ERROR = 'GENERAL_INFO_INVOICE_PRINT_ERROR';
    public const CODE_GENERAL_INFO_PICK_LIST_PRINT_ERROR = 'GENERAL_INFO_PICK_LIST_PRINT_ERROR';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldTypeAllowableValues()
    {
        return [
            self::FIELD_TYPE_DECIMAL,
            self::FIELD_TYPE_TEXT,
            self::FIELD_TYPE__LIST,
            self::FIELD_TYPE_DATE,
            self::FIELD_TYPE_BOOLEAN,
            self::FIELD_TYPE_NONE,
            self::FIELD_TYPE_BUTTON,
            self::FIELD_TYPE_HTML_LIST,
            self::FIELD_TYPE_INTEGER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCodeAllowableValues()
    {
        return [
            self::CODE_NONE,
            self::CODE_GENERAL_INFO,
            self::CODE_GENERAL_INFO_ORDER_ID,
            self::CODE_GENERAL_INFO_REFERENCE_NUMBER,
            self::CODE_GENERAL_INFO_CHANNEL_REFERENCE_NUMBER,
            self::CODE_GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER,
            self::CODE_GENERAL_INFO_DATE,
            self::CODE_GENERAL_INFO_SOURCE,
            self::CODE_GENERAL_INFO_SUBSOURCE,
            self::CODE_GENERAL_INFO_LABEL_PRINTED,
            self::CODE_GENERAL_INFO_INVOICE_PRINTED,
            self::CODE_GENERAL_INFO_PICK_LIST_PRINTED,
            self::CODE_GENERAL_INFO_IS_RULE_RUN,
            self::CODE_GENERAL_INFO_NOTES,
            self::CODE_GENERAL_INFO_LOCKED,
            self::CODE_GENERAL_INFO_PARKED,
            self::CODE_GENERAL_INFO_PART_SHIPPED,
            self::CODE_GENERAL_INFO_TAG,
            self::CODE_GENERAL_INFO_IDENTIFIER,
            self::CODE_GENERAL_INFO_STATUS,
            self::CODE_GENERAL_INFO_DESPATCHBYDATE,
            self::CODE_GENERAL_INFO_ITEMS_COUNT,
            self::CODE_GENERAL_INFO_SHIPPING_LABEL_ERROR,
            self::CODE_GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR,
            self::CODE_SHIPPING_INFORMATION,
            self::CODE_SHIPPING_INFORMATION_VENDOR,
            self::CODE_SHIPPING_INFORMATION_SERVICE,
            self::CODE_SHIPPING_INFORMATION_WEIGHT,
            self::CODE_SHIPPING_INFORMATION_PACKAGING_GROUP,
            self::CODE_SHIPPING_INFORMATION_PACKAGING_TYPE,
            self::CODE_SHIPPING_INFORMATION_COST,
            self::CODE_SHIPPING_INFORMATION_TRACKING_NUMBER,
            self::CODE_SHIPPING_INFORMATION_SERVICE_ID,
            self::CODE_SHIPPING_SCHEDULED_DELIVERY_START,
            self::CODE_SHIPPING_SCHEDULED_DELIVERY_END,
            self::CODE_CUSTOMER,
            self::CODE_CUSTOMER_ADDRESS_ADDRESS,
            self::CODE_CUSTOMER_ADDRESS_FULL_NAME,
            self::CODE_CUSTOMER_ADDRESS_COMPANY,
            self::CODE_CUSTOMER_ADDRESS_POSTCODE,
            self::CODE_CUSTOMER_ADDRESS_COUNTY,
            self::CODE_CUSTOMER_ADDRESS_COUNTRY,
            self::CODE_CUSTOMER_ADDRESS_COUNTRY_ZONE,
            self::CODE_CUSTOMER_ADDRESS_ADDRESS1,
            self::CODE_CUSTOMER_ADDRESS_ADDRESS2,
            self::CODE_CUSTOMER_ADDRESS_ADDRESS3,
            self::CODE_CUSTOMER_ADDRESS_TOWN,
            self::CODE_CUSTOMER_EMAIL,
            self::CODE_CUSTOMER_CHANNEL_BUYER_NAME,
            self::CODE_CUSTOMER_PHONE,
            self::CODE_CUSTOMER_BILLING_ADDRESS,
            self::CODE_CUSTOMER_BILLING_ADDRESS_NAME,
            self::CODE_CUSTOMER_BILLING_ADDRESS_COMPANY,
            self::CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS1,
            self::CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS2,
            self::CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS3,
            self::CODE_CUSTOMER_BILLING_ADDRESS_TOWN,
            self::CODE_CUSTOMER_BILLING_ADDRESS_REGION,
            self::CODE_CUSTOMER_BILLING_ADDRESS_POSTCODE,
            self::CODE_CUSTOMER_BILLING_ADDRESS_COUNTRY,
            self::CODE_CUSTOMER_BILLING_EMAIL,
            self::CODE_CUSTOMER_BILLING_PHONE,
            self::CODE_TOTALS,
            self::CODE_TOTALS_SUBTOTAL,
            self::CODE_TOTALS_SHIPPING,
            self::CODE_TOTALS_TAX,
            self::CODE_TOTALS_TOTAL,
            self::CODE_TOTALS_DISCOUNT,
            self::CODE_TOTALS_CURRENCY,
            self::CODE_TOTALS_PAYMENT_METHOD,
            self::CODE_TOTALS_COUNTRY_TAX_RATE,
            self::CODE_ORDER_TOTAL,
            self::CODE_ORDER_TOTAL_TOTAL,
            self::CODE_ORDER_TOTAL_CURRENCY,
            self::CODE_ORDER_TAX,
            self::CODE_ORDER_TAX_TOTAL,
            self::CODE_ORDER_TAX_CURRENCY,
            self::CODE_FOLDER,
            self::CODE_FOLDERS,
            self::CODE_JOB,
            self::CODE_ITEMS,
            self::CODE_ITEMS_IMAGE,
            self::CODE_ITEMS_SKU,
            self::CODE_ITEMS_ORIGINAL_SKU,
            self::CODE_ITEMS_TITLE,
            self::CODE_ITEMS_ORIGINAL_TITLE,
            self::CODE_ITEMS_ITEM_NUMBER,
            self::CODE_ITEMS_IS_SERVICE,
            self::CODE_ITEMS_QUANTITY,
            self::CODE_ITEMS_SOURCE,
            self::CODE_ITEMS_LINE,
            self::CODE_ITEMS_COST_INC_TAX,
            self::CODE_ITEMS_COST,
            self::CODE_ITEMS_SALES_TAX,
            self::CODE_ITEMS_TAX_RATE,
            self::CODE_ITEMS_CURRENCY,
            self::CODE_ITEMS_CATEGORY,
            self::CODE_ITEMS_BINRACK,
            self::CODE_ITEMS_TAX_COST_INCLUSIVE,
            self::CODE_ITEMS_DISCOUNT,
            self::CODE_ITEMS_SUM_QUANTITY,
            self::CODE_ITEMS_WEIGHT,
            self::CODE_ITEMS_UNIT_COST,
            self::CODE_ITEMS_PRICE_PER_UNIT,
            self::CODE_ITEMS_BATCHED,
            self::CODE_ITEMS_INVENTORY_TRACKING_TYPE,
            self::CODE_ITEMS_BARCODE_NUMBER,
            self::CODE_STOCK_LEVEL,
            self::CODE_CAN_FULFIL,
            self::CODE_HOT_BUTTONS,
            self::CODE_HOT_BUTTON,
            self::CODE_ADDITIONAL,
            self::CODE_LOCATION_ID,
            self::CODE_ITEMS_STOCKITEM_ID,
            self::CODE_ITEMS_COMPOSITE_PARENT_ID,
            self::CODE_GENERAL_INFO_STOCK_ALLOCATION,
            self::CODE_GENERAL_INFO_NOTE,
            self::CODE_GENERAL_INFO_NOTE_COUNT,
            self::CODE_GENERAL_INFO_PICKWAVE_IDS,
            self::CODE_FULFILLMENT,
            self::CODE_FULFILLMENT_STATE,
            self::CODE_FULFILLMENT_ADDITIONAL,
            self::CODE_GENERAL_INFO_INVOICE_PRINT_ERROR,
            self::CODE_GENERAL_INFO_PICK_LIST_PRINT_ERROR,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('visible', $data ?? [], null);
        $this->setIfExists('can_filter', $data ?? [], null);
        $this->setIfExists('can_sort', $data ?? [], null);
        $this->setIfExists('field_type', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('sub_fields', $data ?? [], null);
        $this->setIfExists('is_filter_only', $data ?? [], null);
        $this->setIfExists('hot_button_icon', $data ?? [], null);
        $this->setIfExists('hot_button_key', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!is_null($this->container['field_type']) && !in_array($this->container['field_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field_type', must be one of '%s'",
                $this->container['field_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getCodeAllowableValues();
        if (!is_null($this->container['code']) && !in_array($this->container['code'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'code', must be one of '%s'",
                $this->container['code'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets visible
     *
     * @return bool|null
     */
    public function getVisible()
    {
        return $this->container['visible'];
    }

    /**
     * Sets visible
     *
     * @param bool|null $visible visible
     *
     * @return self
     */
    public function setVisible($visible)
    {
        if (is_null($visible)) {
            throw new \InvalidArgumentException('non-nullable visible cannot be null');
        }
        $this->container['visible'] = $visible;

        return $this;
    }

    /**
     * Gets can_filter
     *
     * @return bool|null
     */
    public function getCanFilter()
    {
        return $this->container['can_filter'];
    }

    /**
     * Sets can_filter
     *
     * @param bool|null $can_filter can_filter
     *
     * @return self
     */
    public function setCanFilter($can_filter)
    {
        if (is_null($can_filter)) {
            throw new \InvalidArgumentException('non-nullable can_filter cannot be null');
        }
        $this->container['can_filter'] = $can_filter;

        return $this;
    }

    /**
     * Gets can_sort
     *
     * @return bool|null
     */
    public function getCanSort()
    {
        return $this->container['can_sort'];
    }

    /**
     * Sets can_sort
     *
     * @param bool|null $can_sort can_sort
     *
     * @return self
     */
    public function setCanSort($can_sort)
    {
        if (is_null($can_sort)) {
            throw new \InvalidArgumentException('non-nullable can_sort cannot be null');
        }
        $this->container['can_sort'] = $can_sort;

        return $this;
    }

    /**
     * Gets field_type
     *
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->container['field_type'];
    }

    /**
     * Sets field_type
     *
     * @param string|null $field_type field_type
     *
     * @return self
     */
    public function setFieldType($field_type)
    {
        if (is_null($field_type)) {
            throw new \InvalidArgumentException('non-nullable field_type cannot be null');
        }
        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!in_array($field_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field_type', must be one of '%s'",
                    $field_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field_type'] = $field_type;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $allowedValues = $this->getCodeAllowableValues();
        if (!in_array($code, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'code', must be one of '%s'",
                    $code,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets sub_fields
     *
     * @return \Linnworks\Orders\Model\FieldVisibility[]|null
     */
    public function getSubFields()
    {
        return $this->container['sub_fields'];
    }

    /**
     * Sets sub_fields
     *
     * @param \Linnworks\Orders\Model\FieldVisibility[]|null $sub_fields sub_fields
     *
     * @return self
     */
    public function setSubFields($sub_fields)
    {
        if (is_null($sub_fields)) {
            throw new \InvalidArgumentException('non-nullable sub_fields cannot be null');
        }
        $this->container['sub_fields'] = $sub_fields;

        return $this;
    }

    /**
     * Gets is_filter_only
     *
     * @return bool|null
     */
    public function getIsFilterOnly()
    {
        return $this->container['is_filter_only'];
    }

    /**
     * Sets is_filter_only
     *
     * @param bool|null $is_filter_only Defines if the field can only be used as a filter
     *
     * @return self
     */
    public function setIsFilterOnly($is_filter_only)
    {
        if (is_null($is_filter_only)) {
            throw new \InvalidArgumentException('non-nullable is_filter_only cannot be null');
        }
        $this->container['is_filter_only'] = $is_filter_only;

        return $this;
    }

    /**
     * Gets hot_button_icon
     *
     * @return string|null
     */
    public function getHotButtonIcon()
    {
        return $this->container['hot_button_icon'];
    }

    /**
     * Sets hot_button_icon
     *
     * @param string|null $hot_button_icon hot_button_icon
     *
     * @return self
     */
    public function setHotButtonIcon($hot_button_icon)
    {
        if (is_null($hot_button_icon)) {
            throw new \InvalidArgumentException('non-nullable hot_button_icon cannot be null');
        }
        $this->container['hot_button_icon'] = $hot_button_icon;

        return $this;
    }

    /**
     * Gets hot_button_key
     *
     * @return string|null
     */
    public function getHotButtonKey()
    {
        return $this->container['hot_button_key'];
    }

    /**
     * Sets hot_button_key
     *
     * @param string|null $hot_button_key hot_button_key
     *
     * @return self
     */
    public function setHotButtonKey($hot_button_key)
    {
        if (is_null($hot_button_key)) {
            throw new \InvalidArgumentException('non-nullable hot_button_key cannot be null');
        }
        $this->container['hot_button_key'] = $hot_button_key;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


