<?php
/**
 * DateFieldFilter
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * DateFieldFilter Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DateFieldFilter implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DateFieldFilter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'date_from' => '\DateTime',
        'date_to' => '\DateTime',
        'type' => 'string',
        'value' => 'int',
        'field_code' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'date_from' => 'date-time',
        'date_to' => 'date-time',
        'type' => null,
        'value' => 'int32',
        'field_code' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'date_from' => false,
        'date_to' => false,
        'type' => false,
        'value' => false,
        'field_code' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'date_from' => 'DateFrom',
        'date_to' => 'DateTo',
        'type' => 'Type',
        'value' => 'Value',
        'field_code' => 'FieldCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'date_from' => 'setDateFrom',
        'date_to' => 'setDateTo',
        'type' => 'setType',
        'value' => 'setValue',
        'field_code' => 'setFieldCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'date_from' => 'getDateFrom',
        'date_to' => 'getDateTo',
        'type' => 'getType',
        'value' => 'getValue',
        'field_code' => 'getFieldCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_RANGE = 'Range';
    public const TYPE_OLDER_THAN = 'OlderThan';
    public const TYPE_LAST_DAYS = 'LastDays';
    public const FIELD_CODE_NONE = 'NONE';
    public const FIELD_CODE_GENERAL_INFO = 'GENERAL_INFO';
    public const FIELD_CODE_GENERAL_INFO_ORDER_ID = 'GENERAL_INFO_ORDER_ID';
    public const FIELD_CODE_GENERAL_INFO_REFERENCE_NUMBER = 'GENERAL_INFO_REFERENCE_NUMBER';
    public const FIELD_CODE_GENERAL_INFO_CHANNEL_REFERENCE_NUMBER = 'GENERAL_INFO_CHANNEL_REFERENCE_NUMBER';
    public const FIELD_CODE_GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER = 'GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER';
    public const FIELD_CODE_GENERAL_INFO_DATE = 'GENERAL_INFO_DATE';
    public const FIELD_CODE_GENERAL_INFO_SOURCE = 'GENERAL_INFO_SOURCE';
    public const FIELD_CODE_GENERAL_INFO_SUBSOURCE = 'GENERAL_INFO_SUBSOURCE';
    public const FIELD_CODE_GENERAL_INFO_LABEL_PRINTED = 'GENERAL_INFO_LABEL_PRINTED';
    public const FIELD_CODE_GENERAL_INFO_INVOICE_PRINTED = 'GENERAL_INFO_INVOICE_PRINTED';
    public const FIELD_CODE_GENERAL_INFO_PICK_LIST_PRINTED = 'GENERAL_INFO_PICK_LIST_PRINTED';
    public const FIELD_CODE_GENERAL_INFO_IS_RULE_RUN = 'GENERAL_INFO_IS_RULE_RUN';
    public const FIELD_CODE_GENERAL_INFO_NOTES = 'GENERAL_INFO_NOTES';
    public const FIELD_CODE_GENERAL_INFO_LOCKED = 'GENERAL_INFO_LOCKED';
    public const FIELD_CODE_GENERAL_INFO_PARKED = 'GENERAL_INFO_PARKED';
    public const FIELD_CODE_GENERAL_INFO_PART_SHIPPED = 'GENERAL_INFO_PART_SHIPPED';
    public const FIELD_CODE_GENERAL_INFO_TAG = 'GENERAL_INFO_TAG';
    public const FIELD_CODE_GENERAL_INFO_IDENTIFIER = 'GENERAL_INFO_IDENTIFIER';
    public const FIELD_CODE_GENERAL_INFO_STATUS = 'GENERAL_INFO_STATUS';
    public const FIELD_CODE_GENERAL_INFO_DESPATCHBYDATE = 'GENERAL_INFO_DESPATCHBYDATE';
    public const FIELD_CODE_GENERAL_INFO_ITEMS_COUNT = 'GENERAL_INFO_ITEMS_COUNT';
    public const FIELD_CODE_GENERAL_INFO_SHIPPING_LABEL_ERROR = 'GENERAL_INFO_SHIPPING_LABEL_ERROR';
    public const FIELD_CODE_GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR = 'GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR';
    public const FIELD_CODE_SHIPPING_INFORMATION = 'SHIPPING_INFORMATION';
    public const FIELD_CODE_SHIPPING_INFORMATION_VENDOR = 'SHIPPING_INFORMATION_VENDOR';
    public const FIELD_CODE_SHIPPING_INFORMATION_SERVICE = 'SHIPPING_INFORMATION_SERVICE';
    public const FIELD_CODE_SHIPPING_INFORMATION_WEIGHT = 'SHIPPING_INFORMATION_WEIGHT';
    public const FIELD_CODE_SHIPPING_INFORMATION_PACKAGING_GROUP = 'SHIPPING_INFORMATION_PACKAGING_GROUP';
    public const FIELD_CODE_SHIPPING_INFORMATION_PACKAGING_TYPE = 'SHIPPING_INFORMATION_PACKAGING_TYPE';
    public const FIELD_CODE_SHIPPING_INFORMATION_COST = 'SHIPPING_INFORMATION_COST';
    public const FIELD_CODE_SHIPPING_INFORMATION_TRACKING_NUMBER = 'SHIPPING_INFORMATION_TRACKING_NUMBER';
    public const FIELD_CODE_SHIPPING_INFORMATION_SERVICE_ID = 'SHIPPING_INFORMATION_SERVICE_ID';
    public const FIELD_CODE_SHIPPING_SCHEDULED_DELIVERY_START = 'SHIPPING_SCHEDULED_DELIVERY_START';
    public const FIELD_CODE_SHIPPING_SCHEDULED_DELIVERY_END = 'SHIPPING_SCHEDULED_DELIVERY_END';
    public const FIELD_CODE_CUSTOMER = 'CUSTOMER';
    public const FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS = 'CUSTOMER_ADDRESS_ADDRESS';
    public const FIELD_CODE_CUSTOMER_ADDRESS_FULL_NAME = 'CUSTOMER_ADDRESS_FULL_NAME';
    public const FIELD_CODE_CUSTOMER_ADDRESS_COMPANY = 'CUSTOMER_ADDRESS_COMPANY';
    public const FIELD_CODE_CUSTOMER_ADDRESS_POSTCODE = 'CUSTOMER_ADDRESS_POSTCODE';
    public const FIELD_CODE_CUSTOMER_ADDRESS_COUNTY = 'CUSTOMER_ADDRESS_COUNTY';
    public const FIELD_CODE_CUSTOMER_ADDRESS_COUNTRY = 'CUSTOMER_ADDRESS_COUNTRY';
    public const FIELD_CODE_CUSTOMER_ADDRESS_COUNTRY_ZONE = 'CUSTOMER_ADDRESS_COUNTRY_ZONE';
    public const FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS1 = 'CUSTOMER_ADDRESS_ADDRESS1';
    public const FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS2 = 'CUSTOMER_ADDRESS_ADDRESS2';
    public const FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS3 = 'CUSTOMER_ADDRESS_ADDRESS3';
    public const FIELD_CODE_CUSTOMER_ADDRESS_TOWN = 'CUSTOMER_ADDRESS_TOWN';
    public const FIELD_CODE_CUSTOMER_EMAIL = 'CUSTOMER_EMAIL';
    public const FIELD_CODE_CUSTOMER_CHANNEL_BUYER_NAME = 'CUSTOMER_CHANNEL_BUYER_NAME';
    public const FIELD_CODE_CUSTOMER_PHONE = 'CUSTOMER_PHONE';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS = 'CUSTOMER_BILLING_ADDRESS';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_NAME = 'CUSTOMER_BILLING_ADDRESS_NAME';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_COMPANY = 'CUSTOMER_BILLING_ADDRESS_COMPANY';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS1 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS1';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS2 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS2';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS3 = 'CUSTOMER_BILLING_ADDRESS_ADDRESS3';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_TOWN = 'CUSTOMER_BILLING_ADDRESS_TOWN';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_REGION = 'CUSTOMER_BILLING_ADDRESS_REGION';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_POSTCODE = 'CUSTOMER_BILLING_ADDRESS_POSTCODE';
    public const FIELD_CODE_CUSTOMER_BILLING_ADDRESS_COUNTRY = 'CUSTOMER_BILLING_ADDRESS_COUNTRY';
    public const FIELD_CODE_CUSTOMER_BILLING_EMAIL = 'CUSTOMER_BILLING_EMAIL';
    public const FIELD_CODE_CUSTOMER_BILLING_PHONE = 'CUSTOMER_BILLING_PHONE';
    public const FIELD_CODE_TOTALS = 'TOTALS';
    public const FIELD_CODE_TOTALS_SUBTOTAL = 'TOTALS_SUBTOTAL';
    public const FIELD_CODE_TOTALS_SHIPPING = 'TOTALS_SHIPPING';
    public const FIELD_CODE_TOTALS_TAX = 'TOTALS_TAX';
    public const FIELD_CODE_TOTALS_TOTAL = 'TOTALS_TOTAL';
    public const FIELD_CODE_TOTALS_DISCOUNT = 'TOTALS_DISCOUNT';
    public const FIELD_CODE_TOTALS_CURRENCY = 'TOTALS_CURRENCY';
    public const FIELD_CODE_TOTALS_PAYMENT_METHOD = 'TOTALS_PAYMENT_METHOD';
    public const FIELD_CODE_TOTALS_COUNTRY_TAX_RATE = 'TOTALS_COUNTRY_TAX_RATE';
    public const FIELD_CODE_ORDER_TOTAL = 'ORDER_TOTAL';
    public const FIELD_CODE_ORDER_TOTAL_TOTAL = 'ORDER_TOTAL_TOTAL';
    public const FIELD_CODE_ORDER_TOTAL_CURRENCY = 'ORDER_TOTAL_CURRENCY';
    public const FIELD_CODE_ORDER_TAX = 'ORDER_TAX';
    public const FIELD_CODE_ORDER_TAX_TOTAL = 'ORDER_TAX_TOTAL';
    public const FIELD_CODE_ORDER_TAX_CURRENCY = 'ORDER_TAX_CURRENCY';
    public const FIELD_CODE_FOLDER = 'FOLDER';
    public const FIELD_CODE_FOLDERS = 'FOLDERS';
    public const FIELD_CODE_JOB = 'JOB';
    public const FIELD_CODE_ITEMS = 'ITEMS';
    public const FIELD_CODE_ITEMS_IMAGE = 'ITEMS_IMAGE';
    public const FIELD_CODE_ITEMS_SKU = 'ITEMS_SKU';
    public const FIELD_CODE_ITEMS_ORIGINAL_SKU = 'ITEMS_ORIGINAL_SKU';
    public const FIELD_CODE_ITEMS_TITLE = 'ITEMS_TITLE';
    public const FIELD_CODE_ITEMS_ORIGINAL_TITLE = 'ITEMS_ORIGINAL_TITLE';
    public const FIELD_CODE_ITEMS_ITEM_NUMBER = 'ITEMS_ITEM_NUMBER';
    public const FIELD_CODE_ITEMS_IS_SERVICE = 'ITEMS_IS_SERVICE';
    public const FIELD_CODE_ITEMS_QUANTITY = 'ITEMS_QUANTITY';
    public const FIELD_CODE_ITEMS_SOURCE = 'ITEMS_SOURCE';
    public const FIELD_CODE_ITEMS_LINE = 'ITEMS_LINE';
    public const FIELD_CODE_ITEMS_COST_INC_TAX = 'ITEMS_COST_INC_TAX';
    public const FIELD_CODE_ITEMS_COST = 'ITEMS_COST';
    public const FIELD_CODE_ITEMS_SALES_TAX = 'ITEMS_SALES_TAX';
    public const FIELD_CODE_ITEMS_TAX_RATE = 'ITEMS_TAX_RATE';
    public const FIELD_CODE_ITEMS_CURRENCY = 'ITEMS_CURRENCY';
    public const FIELD_CODE_ITEMS_CATEGORY = 'ITEMS_CATEGORY';
    public const FIELD_CODE_ITEMS_BINRACK = 'ITEMS_BINRACK';
    public const FIELD_CODE_ITEMS_TAX_COST_INCLUSIVE = 'ITEMS_TAX_COST_INCLUSIVE';
    public const FIELD_CODE_ITEMS_DISCOUNT = 'ITEMS_DISCOUNT';
    public const FIELD_CODE_ITEMS_SUM_QUANTITY = 'ITEMS_SUM_QUANTITY';
    public const FIELD_CODE_ITEMS_WEIGHT = 'ITEMS_WEIGHT';
    public const FIELD_CODE_ITEMS_UNIT_COST = 'ITEMS_UNIT_COST';
    public const FIELD_CODE_ITEMS_PRICE_PER_UNIT = 'ITEMS_PRICE_PER_UNIT';
    public const FIELD_CODE_ITEMS_BATCHED = 'ITEMS_BATCHED';
    public const FIELD_CODE_ITEMS_INVENTORY_TRACKING_TYPE = 'ITEMS_INVENTORY_TRACKING_TYPE';
    public const FIELD_CODE_ITEMS_BARCODE_NUMBER = 'ITEMS_BARCODE_NUMBER';
    public const FIELD_CODE_STOCK_LEVEL = 'STOCK_LEVEL';
    public const FIELD_CODE_CAN_FULFIL = 'CAN_FULFIL';
    public const FIELD_CODE_HOT_BUTTONS = 'HOT_BUTTONS';
    public const FIELD_CODE_HOT_BUTTON = 'HOT_BUTTON';
    public const FIELD_CODE_ADDITIONAL = 'ADDITIONAL';
    public const FIELD_CODE_LOCATION_ID = 'LOCATION_ID';
    public const FIELD_CODE_ITEMS_STOCKITEM_ID = 'ITEMS_STOCKITEM_ID';
    public const FIELD_CODE_ITEMS_COMPOSITE_PARENT_ID = 'ITEMS_COMPOSITE_PARENT_ID';
    public const FIELD_CODE_GENERAL_INFO_STOCK_ALLOCATION = 'GENERAL_INFO_STOCK_ALLOCATION';
    public const FIELD_CODE_GENERAL_INFO_NOTE = 'GENERAL_INFO_NOTE';
    public const FIELD_CODE_GENERAL_INFO_NOTE_COUNT = 'GENERAL_INFO_NOTE_COUNT';
    public const FIELD_CODE_GENERAL_INFO_PICKWAVE_IDS = 'GENERAL_INFO_PICKWAVE_IDS';
    public const FIELD_CODE_FULFILLMENT = 'FULFILLMENT';
    public const FIELD_CODE_FULFILLMENT_STATE = 'FULFILLMENT_STATE';
    public const FIELD_CODE_FULFILLMENT_ADDITIONAL = 'FULFILLMENT_ADDITIONAL';
    public const FIELD_CODE_GENERAL_INFO_INVOICE_PRINT_ERROR = 'GENERAL_INFO_INVOICE_PRINT_ERROR';
    public const FIELD_CODE_GENERAL_INFO_PICK_LIST_PRINT_ERROR = 'GENERAL_INFO_PICK_LIST_PRINT_ERROR';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_RANGE,
            self::TYPE_OLDER_THAN,
            self::TYPE_LAST_DAYS,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldCodeAllowableValues()
    {
        return [
            self::FIELD_CODE_NONE,
            self::FIELD_CODE_GENERAL_INFO,
            self::FIELD_CODE_GENERAL_INFO_ORDER_ID,
            self::FIELD_CODE_GENERAL_INFO_REFERENCE_NUMBER,
            self::FIELD_CODE_GENERAL_INFO_CHANNEL_REFERENCE_NUMBER,
            self::FIELD_CODE_GENERAL_INFO_EXTERNAL_REFERENCE_NUMBER,
            self::FIELD_CODE_GENERAL_INFO_DATE,
            self::FIELD_CODE_GENERAL_INFO_SOURCE,
            self::FIELD_CODE_GENERAL_INFO_SUBSOURCE,
            self::FIELD_CODE_GENERAL_INFO_LABEL_PRINTED,
            self::FIELD_CODE_GENERAL_INFO_INVOICE_PRINTED,
            self::FIELD_CODE_GENERAL_INFO_PICK_LIST_PRINTED,
            self::FIELD_CODE_GENERAL_INFO_IS_RULE_RUN,
            self::FIELD_CODE_GENERAL_INFO_NOTES,
            self::FIELD_CODE_GENERAL_INFO_LOCKED,
            self::FIELD_CODE_GENERAL_INFO_PARKED,
            self::FIELD_CODE_GENERAL_INFO_PART_SHIPPED,
            self::FIELD_CODE_GENERAL_INFO_TAG,
            self::FIELD_CODE_GENERAL_INFO_IDENTIFIER,
            self::FIELD_CODE_GENERAL_INFO_STATUS,
            self::FIELD_CODE_GENERAL_INFO_DESPATCHBYDATE,
            self::FIELD_CODE_GENERAL_INFO_ITEMS_COUNT,
            self::FIELD_CODE_GENERAL_INFO_SHIPPING_LABEL_ERROR,
            self::FIELD_CODE_GENERAL_INFO_HAS_SHIPPING_LABEL_ERROR,
            self::FIELD_CODE_SHIPPING_INFORMATION,
            self::FIELD_CODE_SHIPPING_INFORMATION_VENDOR,
            self::FIELD_CODE_SHIPPING_INFORMATION_SERVICE,
            self::FIELD_CODE_SHIPPING_INFORMATION_WEIGHT,
            self::FIELD_CODE_SHIPPING_INFORMATION_PACKAGING_GROUP,
            self::FIELD_CODE_SHIPPING_INFORMATION_PACKAGING_TYPE,
            self::FIELD_CODE_SHIPPING_INFORMATION_COST,
            self::FIELD_CODE_SHIPPING_INFORMATION_TRACKING_NUMBER,
            self::FIELD_CODE_SHIPPING_INFORMATION_SERVICE_ID,
            self::FIELD_CODE_SHIPPING_SCHEDULED_DELIVERY_START,
            self::FIELD_CODE_SHIPPING_SCHEDULED_DELIVERY_END,
            self::FIELD_CODE_CUSTOMER,
            self::FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS,
            self::FIELD_CODE_CUSTOMER_ADDRESS_FULL_NAME,
            self::FIELD_CODE_CUSTOMER_ADDRESS_COMPANY,
            self::FIELD_CODE_CUSTOMER_ADDRESS_POSTCODE,
            self::FIELD_CODE_CUSTOMER_ADDRESS_COUNTY,
            self::FIELD_CODE_CUSTOMER_ADDRESS_COUNTRY,
            self::FIELD_CODE_CUSTOMER_ADDRESS_COUNTRY_ZONE,
            self::FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS1,
            self::FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS2,
            self::FIELD_CODE_CUSTOMER_ADDRESS_ADDRESS3,
            self::FIELD_CODE_CUSTOMER_ADDRESS_TOWN,
            self::FIELD_CODE_CUSTOMER_EMAIL,
            self::FIELD_CODE_CUSTOMER_CHANNEL_BUYER_NAME,
            self::FIELD_CODE_CUSTOMER_PHONE,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_NAME,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_COMPANY,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS1,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS2,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_ADDRESS3,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_TOWN,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_REGION,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_POSTCODE,
            self::FIELD_CODE_CUSTOMER_BILLING_ADDRESS_COUNTRY,
            self::FIELD_CODE_CUSTOMER_BILLING_EMAIL,
            self::FIELD_CODE_CUSTOMER_BILLING_PHONE,
            self::FIELD_CODE_TOTALS,
            self::FIELD_CODE_TOTALS_SUBTOTAL,
            self::FIELD_CODE_TOTALS_SHIPPING,
            self::FIELD_CODE_TOTALS_TAX,
            self::FIELD_CODE_TOTALS_TOTAL,
            self::FIELD_CODE_TOTALS_DISCOUNT,
            self::FIELD_CODE_TOTALS_CURRENCY,
            self::FIELD_CODE_TOTALS_PAYMENT_METHOD,
            self::FIELD_CODE_TOTALS_COUNTRY_TAX_RATE,
            self::FIELD_CODE_ORDER_TOTAL,
            self::FIELD_CODE_ORDER_TOTAL_TOTAL,
            self::FIELD_CODE_ORDER_TOTAL_CURRENCY,
            self::FIELD_CODE_ORDER_TAX,
            self::FIELD_CODE_ORDER_TAX_TOTAL,
            self::FIELD_CODE_ORDER_TAX_CURRENCY,
            self::FIELD_CODE_FOLDER,
            self::FIELD_CODE_FOLDERS,
            self::FIELD_CODE_JOB,
            self::FIELD_CODE_ITEMS,
            self::FIELD_CODE_ITEMS_IMAGE,
            self::FIELD_CODE_ITEMS_SKU,
            self::FIELD_CODE_ITEMS_ORIGINAL_SKU,
            self::FIELD_CODE_ITEMS_TITLE,
            self::FIELD_CODE_ITEMS_ORIGINAL_TITLE,
            self::FIELD_CODE_ITEMS_ITEM_NUMBER,
            self::FIELD_CODE_ITEMS_IS_SERVICE,
            self::FIELD_CODE_ITEMS_QUANTITY,
            self::FIELD_CODE_ITEMS_SOURCE,
            self::FIELD_CODE_ITEMS_LINE,
            self::FIELD_CODE_ITEMS_COST_INC_TAX,
            self::FIELD_CODE_ITEMS_COST,
            self::FIELD_CODE_ITEMS_SALES_TAX,
            self::FIELD_CODE_ITEMS_TAX_RATE,
            self::FIELD_CODE_ITEMS_CURRENCY,
            self::FIELD_CODE_ITEMS_CATEGORY,
            self::FIELD_CODE_ITEMS_BINRACK,
            self::FIELD_CODE_ITEMS_TAX_COST_INCLUSIVE,
            self::FIELD_CODE_ITEMS_DISCOUNT,
            self::FIELD_CODE_ITEMS_SUM_QUANTITY,
            self::FIELD_CODE_ITEMS_WEIGHT,
            self::FIELD_CODE_ITEMS_UNIT_COST,
            self::FIELD_CODE_ITEMS_PRICE_PER_UNIT,
            self::FIELD_CODE_ITEMS_BATCHED,
            self::FIELD_CODE_ITEMS_INVENTORY_TRACKING_TYPE,
            self::FIELD_CODE_ITEMS_BARCODE_NUMBER,
            self::FIELD_CODE_STOCK_LEVEL,
            self::FIELD_CODE_CAN_FULFIL,
            self::FIELD_CODE_HOT_BUTTONS,
            self::FIELD_CODE_HOT_BUTTON,
            self::FIELD_CODE_ADDITIONAL,
            self::FIELD_CODE_LOCATION_ID,
            self::FIELD_CODE_ITEMS_STOCKITEM_ID,
            self::FIELD_CODE_ITEMS_COMPOSITE_PARENT_ID,
            self::FIELD_CODE_GENERAL_INFO_STOCK_ALLOCATION,
            self::FIELD_CODE_GENERAL_INFO_NOTE,
            self::FIELD_CODE_GENERAL_INFO_NOTE_COUNT,
            self::FIELD_CODE_GENERAL_INFO_PICKWAVE_IDS,
            self::FIELD_CODE_FULFILLMENT,
            self::FIELD_CODE_FULFILLMENT_STATE,
            self::FIELD_CODE_FULFILLMENT_ADDITIONAL,
            self::FIELD_CODE_GENERAL_INFO_INVOICE_PRINT_ERROR,
            self::FIELD_CODE_GENERAL_INFO_PICK_LIST_PRINT_ERROR,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('date_from', $data ?? [], null);
        $this->setIfExists('date_to', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('field_code', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFieldCodeAllowableValues();
        if (!is_null($this->container['field_code']) && !in_array($this->container['field_code'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field_code', must be one of '%s'",
                $this->container['field_code'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets date_from
     *
     * @return \DateTime|null
     */
    public function getDateFrom()
    {
        return $this->container['date_from'];
    }

    /**
     * Sets date_from
     *
     * @param \DateTime|null $date_from Date from
     *
     * @return self
     */
    public function setDateFrom($date_from)
    {
        if (is_null($date_from)) {
            throw new \InvalidArgumentException('non-nullable date_from cannot be null');
        }
        $this->container['date_from'] = $date_from;

        return $this;
    }

    /**
     * Gets date_to
     *
     * @return \DateTime|null
     */
    public function getDateTo()
    {
        return $this->container['date_to'];
    }

    /**
     * Sets date_to
     *
     * @param \DateTime|null $date_to Date to
     *
     * @return self
     */
    public function setDateTo($date_to)
    {
        if (is_null($date_to)) {
            throw new \InvalidArgumentException('non-nullable date_to cannot be null');
        }
        $this->container['date_to'] = $date_to;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Filter type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets value
     *
     * @return int|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param int|null $value Filtering input
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets field_code
     *
     * @return string|null
     */
    public function getFieldCode()
    {
        return $this->container['field_code'];
    }

    /**
     * Sets field_code
     *
     * @param string|null $field_code field_code
     *
     * @return self
     */
    public function setFieldCode($field_code)
    {
        if (is_null($field_code)) {
            throw new \InvalidArgumentException('non-nullable field_code cannot be null');
        }
        $allowedValues = $this->getFieldCodeAllowableValues();
        if (!in_array($field_code, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field_code', must be one of '%s'",
                    $field_code,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field_code'] = $field_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


