<?php
/**
 * CouponValidationResult
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * CouponValidationResult Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CouponValidationResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CouponValidationResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'validation_text' => 'string',
        'deduct_visible' => 'bool',
        'deduct_text' => 'string',
        'balance_visible' => 'bool',
        'balance_text' => 'string',
        'value_text' => 'string',
        'discount_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'validation_text' => null,
        'deduct_visible' => null,
        'deduct_text' => null,
        'balance_visible' => null,
        'balance_text' => null,
        'value_text' => null,
        'discount_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'validation_text' => false,
        'deduct_visible' => false,
        'deduct_text' => false,
        'balance_visible' => false,
        'balance_text' => false,
        'value_text' => false,
        'discount_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'validation_text' => 'ValidationText',
        'deduct_visible' => 'DeductVisible',
        'deduct_text' => 'DeductText',
        'balance_visible' => 'BalanceVisible',
        'balance_text' => 'BalanceText',
        'value_text' => 'ValueText',
        'discount_type' => 'DiscountType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'validation_text' => 'setValidationText',
        'deduct_visible' => 'setDeductVisible',
        'deduct_text' => 'setDeductText',
        'balance_visible' => 'setBalanceVisible',
        'balance_text' => 'setBalanceText',
        'value_text' => 'setValueText',
        'discount_type' => 'setDiscountType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'validation_text' => 'getValidationText',
        'deduct_visible' => 'getDeductVisible',
        'deduct_text' => 'getDeductText',
        'balance_visible' => 'getBalanceVisible',
        'balance_text' => 'getBalanceText',
        'value_text' => 'getValueText',
        'discount_type' => 'getDiscountType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('validation_text', $data ?? [], null);
        $this->setIfExists('deduct_visible', $data ?? [], null);
        $this->setIfExists('deduct_text', $data ?? [], null);
        $this->setIfExists('balance_visible', $data ?? [], null);
        $this->setIfExists('balance_text', $data ?? [], null);
        $this->setIfExists('value_text', $data ?? [], null);
        $this->setIfExists('discount_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets validation_text
     *
     * @return string|null
     */
    public function getValidationText()
    {
        return $this->container['validation_text'];
    }

    /**
     * Sets validation_text
     *
     * @param string|null $validation_text Validation note
     *
     * @return self
     */
    public function setValidationText($validation_text)
    {
        if (is_null($validation_text)) {
            throw new \InvalidArgumentException('non-nullable validation_text cannot be null');
        }
        $this->container['validation_text'] = $validation_text;

        return $this;
    }

    /**
     * Gets deduct_visible
     *
     * @return bool|null
     */
    public function getDeductVisible()
    {
        return $this->container['deduct_visible'];
    }

    /**
     * Sets deduct_visible
     *
     * @param bool|null $deduct_visible If deduction is visible
     *
     * @return self
     */
    public function setDeductVisible($deduct_visible)
    {
        if (is_null($deduct_visible)) {
            throw new \InvalidArgumentException('non-nullable deduct_visible cannot be null');
        }
        $this->container['deduct_visible'] = $deduct_visible;

        return $this;
    }

    /**
     * Gets deduct_text
     *
     * @return string|null
     */
    public function getDeductText()
    {
        return $this->container['deduct_text'];
    }

    /**
     * Sets deduct_text
     *
     * @param string|null $deduct_text Deduction note
     *
     * @return self
     */
    public function setDeductText($deduct_text)
    {
        if (is_null($deduct_text)) {
            throw new \InvalidArgumentException('non-nullable deduct_text cannot be null');
        }
        $this->container['deduct_text'] = $deduct_text;

        return $this;
    }

    /**
     * Gets balance_visible
     *
     * @return bool|null
     */
    public function getBalanceVisible()
    {
        return $this->container['balance_visible'];
    }

    /**
     * Sets balance_visible
     *
     * @param bool|null $balance_visible If balance is visible
     *
     * @return self
     */
    public function setBalanceVisible($balance_visible)
    {
        if (is_null($balance_visible)) {
            throw new \InvalidArgumentException('non-nullable balance_visible cannot be null');
        }
        $this->container['balance_visible'] = $balance_visible;

        return $this;
    }

    /**
     * Gets balance_text
     *
     * @return string|null
     */
    public function getBalanceText()
    {
        return $this->container['balance_text'];
    }

    /**
     * Sets balance_text
     *
     * @param string|null $balance_text Balance record
     *
     * @return self
     */
    public function setBalanceText($balance_text)
    {
        if (is_null($balance_text)) {
            throw new \InvalidArgumentException('non-nullable balance_text cannot be null');
        }
        $this->container['balance_text'] = $balance_text;

        return $this;
    }

    /**
     * Gets value_text
     *
     * @return string|null
     */
    public function getValueText()
    {
        return $this->container['value_text'];
    }

    /**
     * Sets value_text
     *
     * @param string|null $value_text Value
     *
     * @return self
     */
    public function setValueText($value_text)
    {
        if (is_null($value_text)) {
            throw new \InvalidArgumentException('non-nullable value_text cannot be null');
        }
        $this->container['value_text'] = $value_text;

        return $this;
    }

    /**
     * Gets discount_type
     *
     * @return string|null
     */
    public function getDiscountType()
    {
        return $this->container['discount_type'];
    }

    /**
     * Sets discount_type
     *
     * @param string|null $discount_type Discount type
     *
     * @return self
     */
    public function setDiscountType($discount_type)
    {
        if (is_null($discount_type)) {
            throw new \InvalidArgumentException('non-nullable discount_type cannot be null');
        }
        $this->container['discount_type'] = $discount_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


