<?php
/**
 * ChannelOrderItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * ChannelOrderItem Class Doc Comment
 *
 * @category Class
 * @description Channel order item
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ChannelOrderItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ChannelOrderItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_cost_inclusive' => 'bool',
        'use_channel_tax' => 'bool',
        'price_per_unit' => 'float',
        'postal_service_cost' => 'float',
        'qty' => 'int',
        'tax_rate' => 'float',
        'line_discount' => 'float',
        'line_refund' => 'float',
        'refund_quantity' => 'float',
        'shipping_refund' => 'float',
        'total_refund' => 'float',
        'item_number' => 'string',
        'channel_reference_id' => 'string',
        'channel_sku' => 'string',
        'is_service' => 'bool',
        'item_title' => 'string',
        'options' => '\Linnworks\Orders\Model\ChannelOrderItemOption[]',
        'taxes' => '\Linnworks\Orders\Model\ChannelOrderItemTax[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_cost_inclusive' => null,
        'use_channel_tax' => null,
        'price_per_unit' => 'double',
        'postal_service_cost' => 'double',
        'qty' => 'int32',
        'tax_rate' => 'double',
        'line_discount' => 'double',
        'line_refund' => 'double',
        'refund_quantity' => 'double',
        'shipping_refund' => 'double',
        'total_refund' => 'double',
        'item_number' => null,
        'channel_reference_id' => null,
        'channel_sku' => null,
        'is_service' => null,
        'item_title' => null,
        'options' => null,
        'taxes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'tax_cost_inclusive' => false,
        'use_channel_tax' => false,
        'price_per_unit' => false,
        'postal_service_cost' => false,
        'qty' => false,
        'tax_rate' => false,
        'line_discount' => false,
        'line_refund' => false,
        'refund_quantity' => false,
        'shipping_refund' => false,
        'total_refund' => false,
        'item_number' => false,
        'channel_reference_id' => false,
        'channel_sku' => false,
        'is_service' => false,
        'item_title' => false,
        'options' => false,
        'taxes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_cost_inclusive' => 'TaxCostInclusive',
        'use_channel_tax' => 'UseChannelTax',
        'price_per_unit' => 'PricePerUnit',
        'postal_service_cost' => 'PostalServiceCost',
        'qty' => 'Qty',
        'tax_rate' => 'TaxRate',
        'line_discount' => 'LineDiscount',
        'line_refund' => 'LineRefund',
        'refund_quantity' => 'RefundQuantity',
        'shipping_refund' => 'ShippingRefund',
        'total_refund' => 'TotalRefund',
        'item_number' => 'ItemNumber',
        'channel_reference_id' => 'ChannelReferenceId',
        'channel_sku' => 'ChannelSKU',
        'is_service' => 'IsService',
        'item_title' => 'ItemTitle',
        'options' => 'Options',
        'taxes' => 'Taxes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_cost_inclusive' => 'setTaxCostInclusive',
        'use_channel_tax' => 'setUseChannelTax',
        'price_per_unit' => 'setPricePerUnit',
        'postal_service_cost' => 'setPostalServiceCost',
        'qty' => 'setQty',
        'tax_rate' => 'setTaxRate',
        'line_discount' => 'setLineDiscount',
        'line_refund' => 'setLineRefund',
        'refund_quantity' => 'setRefundQuantity',
        'shipping_refund' => 'setShippingRefund',
        'total_refund' => 'setTotalRefund',
        'item_number' => 'setItemNumber',
        'channel_reference_id' => 'setChannelReferenceId',
        'channel_sku' => 'setChannelSku',
        'is_service' => 'setIsService',
        'item_title' => 'setItemTitle',
        'options' => 'setOptions',
        'taxes' => 'setTaxes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_cost_inclusive' => 'getTaxCostInclusive',
        'use_channel_tax' => 'getUseChannelTax',
        'price_per_unit' => 'getPricePerUnit',
        'postal_service_cost' => 'getPostalServiceCost',
        'qty' => 'getQty',
        'tax_rate' => 'getTaxRate',
        'line_discount' => 'getLineDiscount',
        'line_refund' => 'getLineRefund',
        'refund_quantity' => 'getRefundQuantity',
        'shipping_refund' => 'getShippingRefund',
        'total_refund' => 'getTotalRefund',
        'item_number' => 'getItemNumber',
        'channel_reference_id' => 'getChannelReferenceId',
        'channel_sku' => 'getChannelSku',
        'is_service' => 'getIsService',
        'item_title' => 'getItemTitle',
        'options' => 'getOptions',
        'taxes' => 'getTaxes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('tax_cost_inclusive', $data ?? [], null);
        $this->setIfExists('use_channel_tax', $data ?? [], null);
        $this->setIfExists('price_per_unit', $data ?? [], null);
        $this->setIfExists('postal_service_cost', $data ?? [], null);
        $this->setIfExists('qty', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('line_discount', $data ?? [], null);
        $this->setIfExists('line_refund', $data ?? [], null);
        $this->setIfExists('refund_quantity', $data ?? [], null);
        $this->setIfExists('shipping_refund', $data ?? [], null);
        $this->setIfExists('total_refund', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('channel_reference_id', $data ?? [], null);
        $this->setIfExists('channel_sku', $data ?? [], null);
        $this->setIfExists('is_service', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('options', $data ?? [], null);
        $this->setIfExists('taxes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_cost_inclusive
     *
     * @return bool|null
     */
    public function getTaxCostInclusive()
    {
        return $this->container['tax_cost_inclusive'];
    }

    /**
     * Sets tax_cost_inclusive
     *
     * @param bool|null $tax_cost_inclusive tax_cost_inclusive
     *
     * @return self
     */
    public function setTaxCostInclusive($tax_cost_inclusive)
    {
        if (is_null($tax_cost_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_cost_inclusive cannot be null');
        }
        $this->container['tax_cost_inclusive'] = $tax_cost_inclusive;

        return $this;
    }

    /**
     * Gets use_channel_tax
     *
     * @return bool|null
     */
    public function getUseChannelTax()
    {
        return $this->container['use_channel_tax'];
    }

    /**
     * Sets use_channel_tax
     *
     * @param bool|null $use_channel_tax Validate if the tax should be overwritten on the order item.
     *
     * @return self
     */
    public function setUseChannelTax($use_channel_tax)
    {
        if (is_null($use_channel_tax)) {
            throw new \InvalidArgumentException('non-nullable use_channel_tax cannot be null');
        }
        $this->container['use_channel_tax'] = $use_channel_tax;

        return $this;
    }

    /**
     * Gets price_per_unit
     *
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return $this->container['price_per_unit'];
    }

    /**
     * Sets price_per_unit
     *
     * @param float|null $price_per_unit Individual price of the item
     *
     * @return self
     */
    public function setPricePerUnit($price_per_unit)
    {
        if (is_null($price_per_unit)) {
            throw new \InvalidArgumentException('non-nullable price_per_unit cannot be null');
        }
        $this->container['price_per_unit'] = $price_per_unit;

        return $this;
    }

    /**
     * Gets postal_service_cost
     *
     * @return float|null
     */
    public function getPostalServiceCost()
    {
        return $this->container['postal_service_cost'];
    }

    /**
     * Sets postal_service_cost
     *
     * @param float|null $postal_service_cost Postal service cost after discount
     *
     * @return self
     */
    public function setPostalServiceCost($postal_service_cost)
    {
        if (is_null($postal_service_cost)) {
            throw new \InvalidArgumentException('non-nullable postal_service_cost cannot be null');
        }
        $this->container['postal_service_cost'] = $postal_service_cost;

        return $this;
    }

    /**
     * Gets qty
     *
     * @return int|null
     */
    public function getQty()
    {
        return $this->container['qty'];
    }

    /**
     * Sets qty
     *
     * @param int|null $qty Quantity customer ordered
     *
     * @return self
     */
    public function setQty($qty)
    {
        if (is_null($qty)) {
            throw new \InvalidArgumentException('non-nullable qty cannot be null');
        }
        $this->container['qty'] = $qty;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Tax Rate as a whole number eg. 20
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets line_discount
     *
     * @return float|null
     */
    public function getLineDiscount()
    {
        return $this->container['line_discount'];
    }

    /**
     * Sets line_discount
     *
     * @param float|null $line_discount Discount percentage on the line as a whole number eg. 10
     *
     * @return self
     */
    public function setLineDiscount($line_discount)
    {
        if (is_null($line_discount)) {
            throw new \InvalidArgumentException('non-nullable line_discount cannot be null');
        }
        $this->container['line_discount'] = $line_discount;

        return $this;
    }

    /**
     * Gets line_refund
     *
     * @return float|null
     */
    public function getLineRefund()
    {
        return $this->container['line_refund'];
    }

    /**
     * Sets line_refund
     *
     * @param float|null $line_refund The refund amount applied on the line, excluding shipping charges
     *
     * @return self
     */
    public function setLineRefund($line_refund)
    {
        if (is_null($line_refund)) {
            throw new \InvalidArgumentException('non-nullable line_refund cannot be null');
        }
        $this->container['line_refund'] = $line_refund;

        return $this;
    }

    /**
     * Gets refund_quantity
     *
     * @return float|null
     */
    public function getRefundQuantity()
    {
        return $this->container['refund_quantity'];
    }

    /**
     * Sets refund_quantity
     *
     * @param float|null $refund_quantity The quantity of items refunded (can be decimalised)
     *
     * @return self
     */
    public function setRefundQuantity($refund_quantity)
    {
        if (is_null($refund_quantity)) {
            throw new \InvalidArgumentException('non-nullable refund_quantity cannot be null');
        }
        $this->container['refund_quantity'] = $refund_quantity;

        return $this;
    }

    /**
     * Gets shipping_refund
     *
     * @return float|null
     */
    public function getShippingRefund()
    {
        return $this->container['shipping_refund'];
    }

    /**
     * Sets shipping_refund
     *
     * @param float|null $shipping_refund The shipping refund for this line (if known)
     *
     * @return self
     */
    public function setShippingRefund($shipping_refund)
    {
        if (is_null($shipping_refund)) {
            throw new \InvalidArgumentException('non-nullable shipping_refund cannot be null');
        }
        $this->container['shipping_refund'] = $shipping_refund;

        return $this;
    }

    /**
     * Gets total_refund
     *
     * @return float|null
     */
    public function getTotalRefund()
    {
        return $this->container['total_refund'];
    }

    /**
     * Sets total_refund
     *
     * @param float|null $total_refund The total refund amount applied on the line-level, including any shipping charges
     *
     * @return self
     */
    public function setTotalRefund($total_refund)
    {
        if (is_null($total_refund)) {
            throw new \InvalidArgumentException('non-nullable total_refund cannot be null');
        }
        $this->container['total_refund'] = $total_refund;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number Unique line number
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets channel_reference_id
     *
     * @return string|null
     */
    public function getChannelReferenceId()
    {
        return $this->container['channel_reference_id'];
    }

    /**
     * Sets channel_reference_id
     *
     * @param string|null $channel_reference_id The item reference id on the channel
     *
     * @return self
     */
    public function setChannelReferenceId($channel_reference_id)
    {
        if (is_null($channel_reference_id)) {
            throw new \InvalidArgumentException('non-nullable channel_reference_id cannot be null');
        }
        $this->container['channel_reference_id'] = $channel_reference_id;

        return $this;
    }

    /**
     * Gets channel_sku
     *
     * @return string|null
     */
    public function getChannelSku()
    {
        return $this->container['channel_sku'];
    }

    /**
     * Sets channel_sku
     *
     * @param string|null $channel_sku SKU of the item ordered on the channel
     *
     * @return self
     */
    public function setChannelSku($channel_sku)
    {
        if (is_null($channel_sku)) {
            throw new \InvalidArgumentException('non-nullable channel_sku cannot be null');
        }
        $this->container['channel_sku'] = $channel_sku;

        return $this;
    }

    /**
     * Gets is_service
     *
     * @return bool|null
     */
    public function getIsService()
    {
        return $this->container['is_service'];
    }

    /**
     * Sets is_service
     *
     * @param bool|null $is_service Indicates the item is a service and not a physical item
     *
     * @return self
     */
    public function setIsService($is_service)
    {
        if (is_null($is_service)) {
            throw new \InvalidArgumentException('non-nullable is_service cannot be null');
        }
        $this->container['is_service'] = $is_service;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Title of the item ordered, or service name
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets options
     *
     * @return \Linnworks\Orders\Model\ChannelOrderItemOption[]|null
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param \Linnworks\Orders\Model\ChannelOrderItemOption[]|null $options Options on the item ordered
     *
     * @return self
     */
    public function setOptions($options)
    {
        if (is_null($options)) {
            throw new \InvalidArgumentException('non-nullable options cannot be null');
        }
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Linnworks\Orders\Model\ChannelOrderItemTax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Linnworks\Orders\Model\ChannelOrderItemTax[]|null $taxes taxes
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        if (is_null($taxes)) {
            throw new \InvalidArgumentException('non-nullable taxes cannot be null');
        }
        $this->container['taxes'] = $taxes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


