<?php
/**
 * CalcOrderItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * CalcOrderItem Class Doc Comment
 *
 * @category Class
 * @description Class represents order item for package calculation purposes only
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CalcOrderItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CalcOrderItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fk_stock_item_id' => 'string',
        'fk_order_item_id' => 'string',
        'stock_item_int_id' => 'int',
        'sku' => 'string',
        'n_qty' => 'int',
        'item_weight' => 'float',
        'dim_height' => 'float',
        'dim_width' => 'float',
        'dim_depth' => 'float',
        'package_group' => 'string',
        'fk_composite_parent_row_id' => 'string',
        'is_composite_child' => 'bool',
        'boxes' => '\Linnworks\Orders\Model\StockItemBoxConfiguration[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fk_stock_item_id' => 'uuid',
        'fk_order_item_id' => 'uuid',
        'stock_item_int_id' => 'int32',
        'sku' => null,
        'n_qty' => 'int32',
        'item_weight' => 'double',
        'dim_height' => 'double',
        'dim_width' => 'double',
        'dim_depth' => 'double',
        'package_group' => 'uuid',
        'fk_composite_parent_row_id' => 'uuid',
        'is_composite_child' => null,
        'boxes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fk_stock_item_id' => false,
        'fk_order_item_id' => false,
        'stock_item_int_id' => false,
        'sku' => false,
        'n_qty' => false,
        'item_weight' => false,
        'dim_height' => false,
        'dim_width' => false,
        'dim_depth' => false,
        'package_group' => false,
        'fk_composite_parent_row_id' => false,
        'is_composite_child' => false,
        'boxes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fk_stock_item_id' => 'fkStockItemId',
        'fk_order_item_id' => 'fkOrderItemId',
        'stock_item_int_id' => 'StockItemIntId',
        'sku' => 'SKU',
        'n_qty' => 'nQty',
        'item_weight' => 'ItemWeight',
        'dim_height' => 'DimHeight',
        'dim_width' => 'DimWidth',
        'dim_depth' => 'DimDepth',
        'package_group' => 'PackageGroup',
        'fk_composite_parent_row_id' => 'fkCompositeParentRowId',
        'is_composite_child' => 'IsCompositeChild',
        'boxes' => 'Boxes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fk_stock_item_id' => 'setFkStockItemId',
        'fk_order_item_id' => 'setFkOrderItemId',
        'stock_item_int_id' => 'setStockItemIntId',
        'sku' => 'setSku',
        'n_qty' => 'setNQty',
        'item_weight' => 'setItemWeight',
        'dim_height' => 'setDimHeight',
        'dim_width' => 'setDimWidth',
        'dim_depth' => 'setDimDepth',
        'package_group' => 'setPackageGroup',
        'fk_composite_parent_row_id' => 'setFkCompositeParentRowId',
        'is_composite_child' => 'setIsCompositeChild',
        'boxes' => 'setBoxes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fk_stock_item_id' => 'getFkStockItemId',
        'fk_order_item_id' => 'getFkOrderItemId',
        'stock_item_int_id' => 'getStockItemIntId',
        'sku' => 'getSku',
        'n_qty' => 'getNQty',
        'item_weight' => 'getItemWeight',
        'dim_height' => 'getDimHeight',
        'dim_width' => 'getDimWidth',
        'dim_depth' => 'getDimDepth',
        'package_group' => 'getPackageGroup',
        'fk_composite_parent_row_id' => 'getFkCompositeParentRowId',
        'is_composite_child' => 'getIsCompositeChild',
        'boxes' => 'getBoxes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fk_stock_item_id', $data ?? [], null);
        $this->setIfExists('fk_order_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('n_qty', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('dim_height', $data ?? [], null);
        $this->setIfExists('dim_width', $data ?? [], null);
        $this->setIfExists('dim_depth', $data ?? [], null);
        $this->setIfExists('package_group', $data ?? [], null);
        $this->setIfExists('fk_composite_parent_row_id', $data ?? [], null);
        $this->setIfExists('is_composite_child', $data ?? [], null);
        $this->setIfExists('boxes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fk_stock_item_id
     *
     * @return string|null
     */
    public function getFkStockItemId()
    {
        return $this->container['fk_stock_item_id'];
    }

    /**
     * Sets fk_stock_item_id
     *
     * @param string|null $fk_stock_item_id Unique stock item identifier
     *
     * @return self
     */
    public function setFkStockItemId($fk_stock_item_id)
    {
        if (is_null($fk_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_stock_item_id cannot be null');
        }
        $this->container['fk_stock_item_id'] = $fk_stock_item_id;

        return $this;
    }

    /**
     * Gets fk_order_item_id
     *
     * @return string|null
     */
    public function getFkOrderItemId()
    {
        return $this->container['fk_order_item_id'];
    }

    /**
     * Sets fk_order_item_id
     *
     * @param string|null $fk_order_item_id Unique row identifier of the order item
     *
     * @return self
     */
    public function setFkOrderItemId($fk_order_item_id)
    {
        if (is_null($fk_order_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_id cannot be null');
        }
        $this->container['fk_order_item_id'] = $fk_order_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id stock_item_int_id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets n_qty
     *
     * @return int|null
     */
    public function getNQty()
    {
        return $this->container['n_qty'];
    }

    /**
     * Sets n_qty
     *
     * @param int|null $n_qty Quantity of items
     *
     * @return self
     */
    public function setNQty($n_qty)
    {
        if (is_null($n_qty)) {
            throw new \InvalidArgumentException('non-nullable n_qty cannot be null');
        }
        $this->container['n_qty'] = $n_qty;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight Item weight
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets dim_height
     *
     * @return float|null
     */
    public function getDimHeight()
    {
        return $this->container['dim_height'];
    }

    /**
     * Sets dim_height
     *
     * @param float|null $dim_height Item height
     *
     * @return self
     */
    public function setDimHeight($dim_height)
    {
        if (is_null($dim_height)) {
            throw new \InvalidArgumentException('non-nullable dim_height cannot be null');
        }
        $this->container['dim_height'] = $dim_height;

        return $this;
    }

    /**
     * Gets dim_width
     *
     * @return float|null
     */
    public function getDimWidth()
    {
        return $this->container['dim_width'];
    }

    /**
     * Sets dim_width
     *
     * @param float|null $dim_width Item width
     *
     * @return self
     */
    public function setDimWidth($dim_width)
    {
        if (is_null($dim_width)) {
            throw new \InvalidArgumentException('non-nullable dim_width cannot be null');
        }
        $this->container['dim_width'] = $dim_width;

        return $this;
    }

    /**
     * Gets dim_depth
     *
     * @return float|null
     */
    public function getDimDepth()
    {
        return $this->container['dim_depth'];
    }

    /**
     * Sets dim_depth
     *
     * @param float|null $dim_depth item depth
     *
     * @return self
     */
    public function setDimDepth($dim_depth)
    {
        if (is_null($dim_depth)) {
            throw new \InvalidArgumentException('non-nullable dim_depth cannot be null');
        }
        $this->container['dim_depth'] = $dim_depth;

        return $this;
    }

    /**
     * Gets package_group
     *
     * @return string|null
     */
    public function getPackageGroup()
    {
        return $this->container['package_group'];
    }

    /**
     * Sets package_group
     *
     * @param string|null $package_group Prefered Packaging group
     *
     * @return self
     */
    public function setPackageGroup($package_group)
    {
        if (is_null($package_group)) {
            throw new \InvalidArgumentException('non-nullable package_group cannot be null');
        }
        $this->container['package_group'] = $package_group;

        return $this;
    }

    /**
     * Gets fk_composite_parent_row_id
     *
     * @return string|null
     */
    public function getFkCompositeParentRowId()
    {
        return $this->container['fk_composite_parent_row_id'];
    }

    /**
     * Sets fk_composite_parent_row_id
     *
     * @param string|null $fk_composite_parent_row_id Indicates whether the item is a child of a composite, if EmptyGuid or Null not a child
     *
     * @return self
     */
    public function setFkCompositeParentRowId($fk_composite_parent_row_id)
    {
        if (is_null($fk_composite_parent_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_composite_parent_row_id cannot be null');
        }
        $this->container['fk_composite_parent_row_id'] = $fk_composite_parent_row_id;

        return $this;
    }

    /**
     * Gets is_composite_child
     *
     * @return bool|null
     */
    public function getIsCompositeChild()
    {
        return $this->container['is_composite_child'];
    }

    /**
     * Sets is_composite_child
     *
     * @param bool|null $is_composite_child is_composite_child
     *
     * @return self
     */
    public function setIsCompositeChild($is_composite_child)
    {
        if (is_null($is_composite_child)) {
            throw new \InvalidArgumentException('non-nullable is_composite_child cannot be null');
        }
        $this->container['is_composite_child'] = $is_composite_child;

        return $this;
    }

    /**
     * Gets boxes
     *
     * @return \Linnworks\Orders\Model\StockItemBoxConfiguration[]|null
     */
    public function getBoxes()
    {
        return $this->container['boxes'];
    }

    /**
     * Sets boxes
     *
     * @param \Linnworks\Orders\Model\StockItemBoxConfiguration[]|null $boxes boxes
     *
     * @return self
     */
    public function setBoxes($boxes)
    {
        if (is_null($boxes)) {
            throw new \InvalidArgumentException('non-nullable boxes cannot be null');
        }
        $this->container['boxes'] = $boxes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


