<?php
/**
 * CalcOrderHeader
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * CalcOrderHeader Class Doc Comment
 *
 * @category Class
 * @description Class represents a single instance of an order and its header packaging information. Note that if the order contains split packaging fkPackagingTypeId will be Empty Guid
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CalcOrderHeader implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CalcOrderHeader';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'n_order_id' => 'int',
        'fk_postal_service_id' => 'string',
        'fk_country_id' => 'string',
        'c_country' => 'string',
        'item_weight' => 'float',
        'fk_packaging_group_id' => 'string',
        'fk_packaging_type_id' => 'string',
        'is_split_packaging' => 'bool',
        'packaging_weight' => 'float',
        'total_weight' => 'float',
        'total_width' => 'float',
        'total_height' => 'float',
        'total_depth' => 'float',
        'manual_adjust' => 'bool',
        'can_auto_split' => 'bool',
        'is_auto_split' => 'bool',
        'split_package_count' => 'int',
        'label_printed' => 'bool',
        'calculation_hints' => 'string[]',
        'items' => '\Linnworks\Orders\Model\CalcOrderItem[]',
        'bins' => '\Linnworks\Orders\Model\CalcBin[]',
        'three_dim_packaging' => '\Linnworks\Orders\Model\PackingResult',
        'dim_method' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'n_order_id' => 'int32',
        'fk_postal_service_id' => 'uuid',
        'fk_country_id' => 'uuid',
        'c_country' => null,
        'item_weight' => 'double',
        'fk_packaging_group_id' => 'uuid',
        'fk_packaging_type_id' => 'uuid',
        'is_split_packaging' => null,
        'packaging_weight' => 'double',
        'total_weight' => 'double',
        'total_width' => 'double',
        'total_height' => 'double',
        'total_depth' => 'double',
        'manual_adjust' => null,
        'can_auto_split' => null,
        'is_auto_split' => null,
        'split_package_count' => 'int32',
        'label_printed' => null,
        'calculation_hints' => null,
        'items' => null,
        'bins' => null,
        'three_dim_packaging' => null,
        'dim_method' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'n_order_id' => false,
        'fk_postal_service_id' => false,
        'fk_country_id' => false,
        'c_country' => false,
        'item_weight' => false,
        'fk_packaging_group_id' => false,
        'fk_packaging_type_id' => false,
        'is_split_packaging' => false,
        'packaging_weight' => false,
        'total_weight' => false,
        'total_width' => false,
        'total_height' => false,
        'total_depth' => false,
        'manual_adjust' => false,
        'can_auto_split' => false,
        'is_auto_split' => false,
        'split_package_count' => false,
        'label_printed' => false,
        'calculation_hints' => false,
        'items' => false,
        'bins' => false,
        'three_dim_packaging' => false,
        'dim_method' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderID',
        'n_order_id' => 'nOrderId',
        'fk_postal_service_id' => 'fkPostalServiceId',
        'fk_country_id' => 'fkCountryId',
        'c_country' => 'cCountry',
        'item_weight' => 'ItemWeight',
        'fk_packaging_group_id' => 'fkPackagingGroupId',
        'fk_packaging_type_id' => 'fkPackagingTypeId',
        'is_split_packaging' => 'IsSplitPackaging',
        'packaging_weight' => 'PackagingWeight',
        'total_weight' => 'TotalWeight',
        'total_width' => 'TotalWidth',
        'total_height' => 'TotalHeight',
        'total_depth' => 'TotalDepth',
        'manual_adjust' => 'ManualAdjust',
        'can_auto_split' => 'CanAutoSplit',
        'is_auto_split' => 'IsAutoSplit',
        'split_package_count' => 'SplitPackageCount',
        'label_printed' => 'LabelPrinted',
        'calculation_hints' => 'CalculationHints',
        'items' => 'Items',
        'bins' => 'Bins',
        'three_dim_packaging' => 'ThreeDimPackaging',
        'dim_method' => 'DimMethod'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'n_order_id' => 'setNOrderId',
        'fk_postal_service_id' => 'setFkPostalServiceId',
        'fk_country_id' => 'setFkCountryId',
        'c_country' => 'setCCountry',
        'item_weight' => 'setItemWeight',
        'fk_packaging_group_id' => 'setFkPackagingGroupId',
        'fk_packaging_type_id' => 'setFkPackagingTypeId',
        'is_split_packaging' => 'setIsSplitPackaging',
        'packaging_weight' => 'setPackagingWeight',
        'total_weight' => 'setTotalWeight',
        'total_width' => 'setTotalWidth',
        'total_height' => 'setTotalHeight',
        'total_depth' => 'setTotalDepth',
        'manual_adjust' => 'setManualAdjust',
        'can_auto_split' => 'setCanAutoSplit',
        'is_auto_split' => 'setIsAutoSplit',
        'split_package_count' => 'setSplitPackageCount',
        'label_printed' => 'setLabelPrinted',
        'calculation_hints' => 'setCalculationHints',
        'items' => 'setItems',
        'bins' => 'setBins',
        'three_dim_packaging' => 'setThreeDimPackaging',
        'dim_method' => 'setDimMethod'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'n_order_id' => 'getNOrderId',
        'fk_postal_service_id' => 'getFkPostalServiceId',
        'fk_country_id' => 'getFkCountryId',
        'c_country' => 'getCCountry',
        'item_weight' => 'getItemWeight',
        'fk_packaging_group_id' => 'getFkPackagingGroupId',
        'fk_packaging_type_id' => 'getFkPackagingTypeId',
        'is_split_packaging' => 'getIsSplitPackaging',
        'packaging_weight' => 'getPackagingWeight',
        'total_weight' => 'getTotalWeight',
        'total_width' => 'getTotalWidth',
        'total_height' => 'getTotalHeight',
        'total_depth' => 'getTotalDepth',
        'manual_adjust' => 'getManualAdjust',
        'can_auto_split' => 'getCanAutoSplit',
        'is_auto_split' => 'getIsAutoSplit',
        'split_package_count' => 'getSplitPackageCount',
        'label_printed' => 'getLabelPrinted',
        'calculation_hints' => 'getCalculationHints',
        'items' => 'getItems',
        'bins' => 'getBins',
        'three_dim_packaging' => 'getThreeDimPackaging',
        'dim_method' => 'getDimMethod'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DIM_METHOD_LEGACY = 'LEGACY';
    public const DIM_METHOD_MAX = 'MAX';
    public const DIM_METHOD_STACKED = 'STACKED';
    public const DIM_METHOD_WEIGHTFIT = 'WEIGHTFIT';
    public const DIM_METHOD_THREEDIM_ALL = 'THREEDIM_ALL';
    public const DIM_METHOD_THREEDIM_ITEMS = 'THREEDIM_ITEMS';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDimMethodAllowableValues()
    {
        return [
            self::DIM_METHOD_LEGACY,
            self::DIM_METHOD_MAX,
            self::DIM_METHOD_STACKED,
            self::DIM_METHOD_WEIGHTFIT,
            self::DIM_METHOD_THREEDIM_ALL,
            self::DIM_METHOD_THREEDIM_ITEMS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('fk_postal_service_id', $data ?? [], null);
        $this->setIfExists('fk_country_id', $data ?? [], null);
        $this->setIfExists('c_country', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('fk_packaging_group_id', $data ?? [], null);
        $this->setIfExists('fk_packaging_type_id', $data ?? [], null);
        $this->setIfExists('is_split_packaging', $data ?? [], null);
        $this->setIfExists('packaging_weight', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('total_width', $data ?? [], null);
        $this->setIfExists('total_height', $data ?? [], null);
        $this->setIfExists('total_depth', $data ?? [], null);
        $this->setIfExists('manual_adjust', $data ?? [], null);
        $this->setIfExists('can_auto_split', $data ?? [], null);
        $this->setIfExists('is_auto_split', $data ?? [], null);
        $this->setIfExists('split_package_count', $data ?? [], null);
        $this->setIfExists('label_printed', $data ?? [], null);
        $this->setIfExists('calculation_hints', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('bins', $data ?? [], null);
        $this->setIfExists('three_dim_packaging', $data ?? [], null);
        $this->setIfExists('dim_method', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDimMethodAllowableValues();
        if (!is_null($this->container['dim_method']) && !in_array($this->container['dim_method'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'dim_method', must be one of '%s'",
                $this->container['dim_method'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order id
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Numeric order id
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets fk_postal_service_id
     *
     * @return string|null
     */
    public function getFkPostalServiceId()
    {
        return $this->container['fk_postal_service_id'];
    }

    /**
     * Sets fk_postal_service_id
     *
     * @param string|null $fk_postal_service_id Shipping service id
     *
     * @return self
     */
    public function setFkPostalServiceId($fk_postal_service_id)
    {
        if (is_null($fk_postal_service_id)) {
            throw new \InvalidArgumentException('non-nullable fk_postal_service_id cannot be null');
        }
        $this->container['fk_postal_service_id'] = $fk_postal_service_id;

        return $this;
    }

    /**
     * Gets fk_country_id
     *
     * @return string|null
     */
    public function getFkCountryId()
    {
        return $this->container['fk_country_id'];
    }

    /**
     * Sets fk_country_id
     *
     * @param string|null $fk_country_id Country Id
     *
     * @return self
     */
    public function setFkCountryId($fk_country_id)
    {
        if (is_null($fk_country_id)) {
            throw new \InvalidArgumentException('non-nullable fk_country_id cannot be null');
        }
        $this->container['fk_country_id'] = $fk_country_id;

        return $this;
    }

    /**
     * Gets c_country
     *
     * @return string|null
     */
    public function getCCountry()
    {
        return $this->container['c_country'];
    }

    /**
     * Sets c_country
     *
     * @param string|null $c_country Country Name
     *
     * @return self
     */
    public function setCCountry($c_country)
    {
        if (is_null($c_country)) {
            throw new \InvalidArgumentException('non-nullable c_country cannot be null');
        }
        $this->container['c_country'] = $c_country;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight Total Item weight in the order
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets fk_packaging_group_id
     *
     * @return string|null
     */
    public function getFkPackagingGroupId()
    {
        return $this->container['fk_packaging_group_id'];
    }

    /**
     * Sets fk_packaging_group_id
     *
     * @param string|null $fk_packaging_group_id Packaging Group Id
     *
     * @return self
     */
    public function setFkPackagingGroupId($fk_packaging_group_id)
    {
        if (is_null($fk_packaging_group_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_group_id cannot be null');
        }
        $this->container['fk_packaging_group_id'] = $fk_packaging_group_id;

        return $this;
    }

    /**
     * Gets fk_packaging_type_id
     *
     * @return string|null
     */
    public function getFkPackagingTypeId()
    {
        return $this->container['fk_packaging_type_id'];
    }

    /**
     * Sets fk_packaging_type_id
     *
     * @param string|null $fk_packaging_type_id Calculated packaging type for the order
     *
     * @return self
     */
    public function setFkPackagingTypeId($fk_packaging_type_id)
    {
        if (is_null($fk_packaging_type_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_type_id cannot be null');
        }
        $this->container['fk_packaging_type_id'] = $fk_packaging_type_id;

        return $this;
    }

    /**
     * Gets is_split_packaging
     *
     * @return bool|null
     */
    public function getIsSplitPackaging()
    {
        return $this->container['is_split_packaging'];
    }

    /**
     * Sets is_split_packaging
     *
     * @param bool|null $is_split_packaging Is the packaging split?
     *
     * @return self
     */
    public function setIsSplitPackaging($is_split_packaging)
    {
        if (is_null($is_split_packaging)) {
            throw new \InvalidArgumentException('non-nullable is_split_packaging cannot be null');
        }
        $this->container['is_split_packaging'] = $is_split_packaging;

        return $this;
    }

    /**
     * Gets packaging_weight
     *
     * @return float|null
     */
    public function getPackagingWeight()
    {
        return $this->container['packaging_weight'];
    }

    /**
     * Sets packaging_weight
     *
     * @param float|null $packaging_weight Packaging weight
     *
     * @return self
     */
    public function setPackagingWeight($packaging_weight)
    {
        if (is_null($packaging_weight)) {
            throw new \InvalidArgumentException('non-nullable packaging_weight cannot be null');
        }
        $this->container['packaging_weight'] = $packaging_weight;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Total weight, items + packaging weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets total_width
     *
     * @return float|null
     */
    public function getTotalWidth()
    {
        return $this->container['total_width'];
    }

    /**
     * Sets total_width
     *
     * @param float|null $total_width Total width of the order packaging. If null the recalculation was not performed yet. See documentation about how the dimensions of the order calculated.
     *
     * @return self
     */
    public function setTotalWidth($total_width)
    {
        if (is_null($total_width)) {
            throw new \InvalidArgumentException('non-nullable total_width cannot be null');
        }
        $this->container['total_width'] = $total_width;

        return $this;
    }

    /**
     * Gets total_height
     *
     * @return float|null
     */
    public function getTotalHeight()
    {
        return $this->container['total_height'];
    }

    /**
     * Sets total_height
     *
     * @param float|null $total_height Total Height of the order packaging. If null the recalculation was not performed yet. See documentation about how the dimensions of the order calculated.
     *
     * @return self
     */
    public function setTotalHeight($total_height)
    {
        if (is_null($total_height)) {
            throw new \InvalidArgumentException('non-nullable total_height cannot be null');
        }
        $this->container['total_height'] = $total_height;

        return $this;
    }

    /**
     * Gets total_depth
     *
     * @return float|null
     */
    public function getTotalDepth()
    {
        return $this->container['total_depth'];
    }

    /**
     * Sets total_depth
     *
     * @param float|null $total_depth Total Depth of the order packaging. If null the recalculation was not performed yet. See documentation about how the dimensions of the order calculated.
     *
     * @return self
     */
    public function setTotalDepth($total_depth)
    {
        if (is_null($total_depth)) {
            throw new \InvalidArgumentException('non-nullable total_depth cannot be null');
        }
        $this->container['total_depth'] = $total_depth;

        return $this;
    }

    /**
     * Gets manual_adjust
     *
     * @return bool|null
     */
    public function getManualAdjust()
    {
        return $this->container['manual_adjust'];
    }

    /**
     * Sets manual_adjust
     *
     * @param bool|null $manual_adjust Inidicates that order weights, packaging dimensions has been manually adjusted by the user and therefore automatic recalculation should not be performed for this order
     *
     * @return self
     */
    public function setManualAdjust($manual_adjust)
    {
        if (is_null($manual_adjust)) {
            throw new \InvalidArgumentException('non-nullable manual_adjust cannot be null');
        }
        $this->container['manual_adjust'] = $manual_adjust;

        return $this;
    }

    /**
     * Gets can_auto_split
     *
     * @return bool|null
     */
    public function getCanAutoSplit()
    {
        return $this->container['can_auto_split'];
    }

    /**
     * Sets can_auto_split
     *
     * @param bool|null $can_auto_split can_auto_split
     *
     * @return self
     */
    public function setCanAutoSplit($can_auto_split)
    {
        if (is_null($can_auto_split)) {
            throw new \InvalidArgumentException('non-nullable can_auto_split cannot be null');
        }
        $this->container['can_auto_split'] = $can_auto_split;

        return $this;
    }

    /**
     * Gets is_auto_split
     *
     * @return bool|null
     */
    public function getIsAutoSplit()
    {
        return $this->container['is_auto_split'];
    }

    /**
     * Sets is_auto_split
     *
     * @param bool|null $is_auto_split Was the packaging automatically split? Usually by the 3D Packaging method.
     *
     * @return self
     */
    public function setIsAutoSplit($is_auto_split)
    {
        if (is_null($is_auto_split)) {
            throw new \InvalidArgumentException('non-nullable is_auto_split cannot be null');
        }
        $this->container['is_auto_split'] = $is_auto_split;

        return $this;
    }

    /**
     * Gets split_package_count
     *
     * @return int|null
     */
    public function getSplitPackageCount()
    {
        return $this->container['split_package_count'];
    }

    /**
     * Sets split_package_count
     *
     * @param int|null $split_package_count Indicates the number of split packaging bins. If null, or 0 - no split packaging
     *
     * @return self
     */
    public function setSplitPackageCount($split_package_count)
    {
        if (is_null($split_package_count)) {
            throw new \InvalidArgumentException('non-nullable split_package_count cannot be null');
        }
        $this->container['split_package_count'] = $split_package_count;

        return $this;
    }

    /**
     * Gets label_printed
     *
     * @return bool|null
     */
    public function getLabelPrinted()
    {
        return $this->container['label_printed'];
    }

    /**
     * Sets label_printed
     *
     * @param bool|null $label_printed Is Label Printed
     *
     * @return self
     */
    public function setLabelPrinted($label_printed)
    {
        if (is_null($label_printed)) {
            throw new \InvalidArgumentException('non-nullable label_printed cannot be null');
        }
        $this->container['label_printed'] = $label_printed;

        return $this;
    }

    /**
     * Gets calculation_hints
     *
     * @return string[]|null
     */
    public function getCalculationHints()
    {
        return $this->container['calculation_hints'];
    }

    /**
     * Sets calculation_hints
     *
     * @param string[]|null $calculation_hints Calculation comments. The recalculation routine will output some basic comments about how the calculation was performed in English.
     *
     * @return self
     */
    public function setCalculationHints($calculation_hints)
    {
        if (is_null($calculation_hints)) {
            throw new \InvalidArgumentException('non-nullable calculation_hints cannot be null');
        }
        $this->container['calculation_hints'] = $calculation_hints;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\CalcOrderItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\CalcOrderItem[]|null $items List of order items (excluding composite parents)
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets bins
     *
     * @return \Linnworks\Orders\Model\CalcBin[]|null
     */
    public function getBins()
    {
        return $this->container['bins'];
    }

    /**
     * Sets bins
     *
     * @param \Linnworks\Orders\Model\CalcBin[]|null $bins List of bins (split packaging)
     *
     * @return self
     */
    public function setBins($bins)
    {
        if (is_null($bins)) {
            throw new \InvalidArgumentException('non-nullable bins cannot be null');
        }
        $this->container['bins'] = $bins;

        return $this;
    }

    /**
     * Gets three_dim_packaging
     *
     * @return \Linnworks\Orders\Model\PackingResult|null
     */
    public function getThreeDimPackaging()
    {
        return $this->container['three_dim_packaging'];
    }

    /**
     * Sets three_dim_packaging
     *
     * @param \Linnworks\Orders\Model\PackingResult|null $three_dim_packaging three_dim_packaging
     *
     * @return self
     */
    public function setThreeDimPackaging($three_dim_packaging)
    {
        if (is_null($three_dim_packaging)) {
            throw new \InvalidArgumentException('non-nullable three_dim_packaging cannot be null');
        }
        $this->container['three_dim_packaging'] = $three_dim_packaging;

        return $this;
    }

    /**
     * Gets dim_method
     *
     * @return string|null
     */
    public function getDimMethod()
    {
        return $this->container['dim_method'];
    }

    /**
     * Sets dim_method
     *
     * @param string|null $dim_method Dimension Calculation method
     *
     * @return self
     */
    public function setDimMethod($dim_method)
    {
        if (is_null($dim_method)) {
            throw new \InvalidArgumentException('non-nullable dim_method cannot be null');
        }
        $allowedValues = $this->getDimMethodAllowableValues();
        if (!in_array($dim_method, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'dim_method', must be one of '%s'",
                    $dim_method,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['dim_method'] = $dim_method;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


