<?php
/**
 * CalcBin
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Model;

use \ArrayAccess;
use \Linnworks\Orders\ObjectSerializer;

/**
 * CalcBin Class Doc Comment
 *
 * @category Class
 * @description Class represents split packaging bin
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CalcBin implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CalcBin';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_bin_id' => 'string',
        'tracking_number' => 'string',
        'label_id' => 'string',
        'weight' => 'float',
        'print_date' => '\DateTime',
        'cost' => 'float',
        'fk_packaging_type_id' => 'string',
        'width' => 'float',
        'height' => 'float',
        'depth' => 'float',
        'packaging_weight' => 'float',
        'item_weight' => 'float',
        'manual_adjust' => 'bool',
        'items' => '\Linnworks\Orders\Model\CalcBinItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_bin_id' => 'uuid',
        'tracking_number' => null,
        'label_id' => null,
        'weight' => 'double',
        'print_date' => 'date-time',
        'cost' => 'double',
        'fk_packaging_type_id' => 'uuid',
        'width' => 'double',
        'height' => 'double',
        'depth' => 'double',
        'packaging_weight' => 'double',
        'item_weight' => 'double',
        'manual_adjust' => null,
        'items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_bin_id' => false,
        'tracking_number' => false,
        'label_id' => false,
        'weight' => false,
        'print_date' => false,
        'cost' => false,
        'fk_packaging_type_id' => false,
        'width' => false,
        'height' => false,
        'depth' => false,
        'packaging_weight' => false,
        'item_weight' => false,
        'manual_adjust' => false,
        'items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_bin_id' => 'pkBinId',
        'tracking_number' => 'TrackingNumber',
        'label_id' => 'LabelId',
        'weight' => 'Weight',
        'print_date' => 'PrintDate',
        'cost' => 'Cost',
        'fk_packaging_type_id' => 'fkPackagingTypeId',
        'width' => 'Width',
        'height' => 'Height',
        'depth' => 'Depth',
        'packaging_weight' => 'PackagingWeight',
        'item_weight' => 'ItemWeight',
        'manual_adjust' => 'ManualAdjust',
        'items' => 'Items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_bin_id' => 'setPkBinId',
        'tracking_number' => 'setTrackingNumber',
        'label_id' => 'setLabelId',
        'weight' => 'setWeight',
        'print_date' => 'setPrintDate',
        'cost' => 'setCost',
        'fk_packaging_type_id' => 'setFkPackagingTypeId',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'packaging_weight' => 'setPackagingWeight',
        'item_weight' => 'setItemWeight',
        'manual_adjust' => 'setManualAdjust',
        'items' => 'setItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_bin_id' => 'getPkBinId',
        'tracking_number' => 'getTrackingNumber',
        'label_id' => 'getLabelId',
        'weight' => 'getWeight',
        'print_date' => 'getPrintDate',
        'cost' => 'getCost',
        'fk_packaging_type_id' => 'getFkPackagingTypeId',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'packaging_weight' => 'getPackagingWeight',
        'item_weight' => 'getItemWeight',
        'manual_adjust' => 'getManualAdjust',
        'items' => 'getItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_bin_id', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('label_id', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('print_date', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('fk_packaging_type_id', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('packaging_weight', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('manual_adjust', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_bin_id
     *
     * @return string|null
     */
    public function getPkBinId()
    {
        return $this->container['pk_bin_id'];
    }

    /**
     * Sets pk_bin_id
     *
     * @param string|null $pk_bin_id Bin Id
     *
     * @return self
     */
    public function setPkBinId($pk_bin_id)
    {
        if (is_null($pk_bin_id)) {
            throw new \InvalidArgumentException('non-nullable pk_bin_id cannot be null');
        }
        $this->container['pk_bin_id'] = $pk_bin_id;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number Bin Tracking number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets label_id
     *
     * @return string|null
     */
    public function getLabelId()
    {
        return $this->container['label_id'];
    }

    /**
     * Sets label_id
     *
     * @param string|null $label_id Bin Label Id
     *
     * @return self
     */
    public function setLabelId($label_id)
    {
        if (is_null($label_id)) {
            throw new \InvalidArgumentException('non-nullable label_id cannot be null');
        }
        $this->container['label_id'] = $label_id;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Bin total weight. If null, recalculation was not performed
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets print_date
     *
     * @return \DateTime|null
     */
    public function getPrintDate()
    {
        return $this->container['print_date'];
    }

    /**
     * Sets print_date
     *
     * @param \DateTime|null $print_date Label Print date
     *
     * @return self
     */
    public function setPrintDate($print_date)
    {
        if (is_null($print_date)) {
            throw new \InvalidArgumentException('non-nullable print_date cannot be null');
        }
        $this->container['print_date'] = $print_date;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost Label cost if available
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets fk_packaging_type_id
     *
     * @return string|null
     */
    public function getFkPackagingTypeId()
    {
        return $this->container['fk_packaging_type_id'];
    }

    /**
     * Sets fk_packaging_type_id
     *
     * @param string|null $fk_packaging_type_id Bin allocated packaging type
     *
     * @return self
     */
    public function setFkPackagingTypeId($fk_packaging_type_id)
    {
        if (is_null($fk_packaging_type_id)) {
            throw new \InvalidArgumentException('non-nullable fk_packaging_type_id cannot be null');
        }
        $this->container['fk_packaging_type_id'] = $fk_packaging_type_id;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width Bin width. If null, recalculation was not performed
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height Bin height. If null, recalculation was not performed
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth Bin depth. If null, recalculation was not performed
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets packaging_weight
     *
     * @return float|null
     */
    public function getPackagingWeight()
    {
        return $this->container['packaging_weight'];
    }

    /**
     * Sets packaging_weight
     *
     * @param float|null $packaging_weight Bin packaging weight. If null, recalculation was not performed
     *
     * @return self
     */
    public function setPackagingWeight($packaging_weight)
    {
        if (is_null($packaging_weight)) {
            throw new \InvalidArgumentException('non-nullable packaging_weight cannot be null');
        }
        $this->container['packaging_weight'] = $packaging_weight;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight Bin ItemWeight. If null, recalculation was not performed
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            throw new \InvalidArgumentException('non-nullable item_weight cannot be null');
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets manual_adjust
     *
     * @return bool|null
     */
    public function getManualAdjust()
    {
        return $this->container['manual_adjust'];
    }

    /**
     * Sets manual_adjust
     *
     * @param bool|null $manual_adjust Indicates that the bin weights and dimensions have been manually adjusted by the user
     *
     * @return self
     */
    public function setManualAdjust($manual_adjust)
    {
        if (is_null($manual_adjust)) {
            throw new \InvalidArgumentException('non-nullable manual_adjust cannot be null');
        }
        $this->container['manual_adjust'] = $manual_adjust;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Orders\Model\CalcBinItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Orders\Model\CalcBinItem[]|null $items List of order item ids in the bin and their quantities
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


