<?php
/**
 * OrdersApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: orders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Orders\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\Orders\ApiException;
use Linnworks\Orders\Configuration;
use Linnworks\Orders\HeaderSelector;
use Linnworks\Orders\ObjectSerializer;

/**
 * OrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Orders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addCoupon' => [
            'application/json',
        ],
        'addExtendedProperties' => [
            'application/json',
        ],
        'addOrderItem' => [
            'application/json',
        ],
        'addOrderService' => [
            'application/json',
        ],
        'assignOrderItemBatches' => [
            'application/json',
        ],
        'assignStockToOrder' => [
            'application/json',
        ],
        'assignToFolder' => [
            'application/json',
        ],
        'cancelOrder' => [
            'application/json',
        ],
        'changeOrderTag' => [
            'application/json',
        ],
        'changeShippingMethod' => [
            'application/json',
        ],
        'changeStatus' => [
            'application/json',
        ],
        'clearInvoicePrinted' => [
            'application/json',
        ],
        'clearPickListPrinted' => [
            'application/json',
        ],
        'clearShippingLabelInfo' => [
            'application/json',
        ],
        'completeOrder' => [
            'application/json',
        ],
        'createNewItemAndLink' => [
            'application/json',
        ],
        'createNewOrder' => [
            'application/json',
        ],
        'createOrders' => [
            'application/json',
        ],
        'createSerialisedValuesForOrderItems' => [
            'application/json',
        ],
        'customerLookUp' => [
            'application/json',
        ],
        'deleteOrder' => [
            'application/json',
        ],
        'getAllAvailableOrderItemBatchsByOrderId' => [
            'application/json',
        ],
        'getAllOpenOrders' => [
            'application/json',
        ],
        'getAllOpenOrdersBetweenIndex' => [
            'application/json',
        ],
        'getAssignedOrderItemBatches' => [
            'application/json',
        ],
        'getAvailableFolders' => [
            'application/json',
        ],
        'getBatchPilots' => [
            'application/json',
        ],
        'getCountries' => [
            'application/json',
        ],
        'getDefaultPaymentMethodIdForNewOrder' => [
            'application/json',
        ],
        'getDraftOrders' => [
            'application/json',
        ],
        'getExtendedProperties' => [
            'application/json',
        ],
        'getExtendedPropertyNames' => [
            'application/json',
        ],
        'getExtendedPropertyTypes' => [
            'application/json',
        ],
        'getLinkedItems' => [
            'application/json',
        ],
        'getOpenOrderIdByOrderOrReferenceId' => [
            'application/json',
        ],
        'getOpenOrderItemsSuppliers' => [
            'application/json',
        ],
        'getOpenOrders' => [
            'application/json',
        ],
        'getOpenOrdersByItemBarcode' => [
            'application/json',
        ],
        'getOrder' => [
            'application/json',
        ],
        'getOrderAuditTrail' => [
            'application/json',
        ],
        'getOrderAuditTrailsByIds' => [
            'application/json',
        ],
        'getOrderById' => [
            'application/json',
        ],
        'getOrderDetailsByNumOrderId' => [
            'application/json',
        ],
        'getOrderDetailsByReferenceId' => [
            'application/json',
        ],
        'getOrderItemBatchesByOrderIds' => [
            'application/json',
        ],
        'getOrderItemBatchsByOrderId' => [
            'application/json',
        ],
        'getOrderItemComposition' => [
            'application/json',
        ],
        'getOrderItemRowSerialValuesByOrderIds' => [
            'application/json',
        ],
        'getOrderItems' => [
            'application/json',
        ],
        'getOrderNoteTypes' => [
            'application/json',
        ],
        'getOrderNotes' => [
            'application/json',
        ],
        'getOrderPackagingCalculation' => [
            'application/json',
        ],
        'getOrderPackagingSplit' => [
            'application/json',
        ],
        'getOrderRelations' => [
            'application/json',
        ],
        'getOrderView' => [
            'application/json',
        ],
        'getOrderViews' => [
            'application/json',
        ],
        'getOrderXml' => [
            'application/json',
        ],
        'getOrderXmlJSTree' => [
            'application/json',
        ],
        'getOrders' => [
            'application/json',
        ],
        'getOrdersById' => [
            'application/json',
        ],
        'getOrdersNotes' => [
            'application/json',
        ],
        'getOrdersRelations' => [
            'application/json',
        ],
        'getPackagingGroups' => [
            'application/json',
        ],
        'getPaymentMethods' => [
            'application/json',
        ],
        'getShippingMethods' => [
            'application/json',
        ],
        'getUserLocationId' => [
            'application/json',
        ],
        'lockOrder' => [
            'application/json',
        ],
        'mergeOrders' => [
            'application/json',
        ],
        'moveToLocation' => [
            'application/json',
        ],
        'processFulfilmentCentreOrder' => [
            'application/json',
        ],
        'processOrder' => [
            'application/json',
        ],
        'processOrderByOrderOrReferenceId' => [
            'application/json',
        ],
        'processOrderRequiredBatchScans' => [
            'application/json',
        ],
        'processOrdersInBatch' => [
            'application/json',
        ],
        'recalculateSingleOrderPackaging' => [
            'application/json',
        ],
        'removeOrderItem' => [
            'application/json',
        ],
        'runRulesEngine' => [
            'application/json',
        ],
        'saveOrderView' => [
            'application/json',
        ],
        'setAdditionalInfo' => [
            'application/json',
        ],
        'setAvailableFolders' => [
            'application/json',
        ],
        'setDefaultPaymentMethodIdForNewOrder' => [
            'application/json',
        ],
        'setExtendedProperties' => [
            'application/json',
        ],
        'setInvoicesPrinted' => [
            'application/json',
        ],
        'setLabelsPrinted' => [
            'application/json',
        ],
        'setOrderCustomerInfo' => [
            'application/json',
        ],
        'setOrderGeneralInfo' => [
            'application/json',
        ],
        'setOrderNotes' => [
            'application/json',
        ],
        'setOrderPackaging' => [
            'application/json',
        ],
        'setOrderPackagingSplit' => [
            'application/json',
        ],
        'setOrderShippingInfo' => [
            'application/json',
        ],
        'setOrderSplitPackagingManualOverwrite' => [
            'application/json',
        ],
        'setOrderTotalsInfo' => [
            'application/json',
        ],
        'setPaymentMethods' => [
            'application/json',
        ],
        'setPickListPrinted' => [
            'application/json',
        ],
        'splitOrder' => [
            'application/json',
        ],
        'unassignToFolder' => [
            'application/json',
        ],
        'updateAdditionalInfo' => [
            'application/json',
        ],
        'updateBillingAddress' => [
            'application/json',
        ],
        'updateLinkItem' => [
            'application/json',
        ],
        'updateOrderItem' => [
            'application/json',
        ],
        'validateCoupon' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addCoupon
     *
     * AddCoupon
     *
     * @param  \Linnworks\Orders\Model\OrdersAddCouponRequest $orders_add_coupon_request orders_add_coupon_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addCoupon'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UpdateOrderItemResult
     */
    public function addCoupon($orders_add_coupon_request, string $contentType = self::contentTypes['addCoupon'][0])
    {
        list($response) = $this->addCouponWithHttpInfo($orders_add_coupon_request, $contentType);
        return $response;
    }

    /**
     * Operation addCouponWithHttpInfo
     *
     * AddCoupon
     *
     * @param  \Linnworks\Orders\Model\OrdersAddCouponRequest $orders_add_coupon_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addCoupon'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UpdateOrderItemResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function addCouponWithHttpInfo($orders_add_coupon_request, string $contentType = self::contentTypes['addCoupon'][0])
    {
        $request = $this->addCouponRequest($orders_add_coupon_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UpdateOrderItemResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UpdateOrderItemResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UpdateOrderItemResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UpdateOrderItemResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addCouponAsync
     *
     * AddCoupon
     *
     * @param  \Linnworks\Orders\Model\OrdersAddCouponRequest $orders_add_coupon_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addCoupon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addCouponAsync($orders_add_coupon_request, string $contentType = self::contentTypes['addCoupon'][0])
    {
        return $this->addCouponAsyncWithHttpInfo($orders_add_coupon_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addCouponAsyncWithHttpInfo
     *
     * AddCoupon
     *
     * @param  \Linnworks\Orders\Model\OrdersAddCouponRequest $orders_add_coupon_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addCoupon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addCouponAsyncWithHttpInfo($orders_add_coupon_request, string $contentType = self::contentTypes['addCoupon'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
        $request = $this->addCouponRequest($orders_add_coupon_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addCoupon'
     *
     * @param  \Linnworks\Orders\Model\OrdersAddCouponRequest $orders_add_coupon_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addCoupon'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addCouponRequest($orders_add_coupon_request, string $contentType = self::contentTypes['addCoupon'][0])
    {

        // verify the required parameter 'orders_add_coupon_request' is set
        if ($orders_add_coupon_request === null || (is_array($orders_add_coupon_request) && count($orders_add_coupon_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_add_coupon_request when calling addCoupon'
            );
        }


        $resourcePath = '/api/Orders/AddCoupon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_add_coupon_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_add_coupon_request));
            } else {
                $httpBody = $orders_add_coupon_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addExtendedProperties
     *
     * AddExtendedProperties
     *
     * @param  \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest $orders_add_extended_properties_request orders_add_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\AddExtendedPropertiesResponse
     */
    public function addExtendedProperties($orders_add_extended_properties_request, string $contentType = self::contentTypes['addExtendedProperties'][0])
    {
        list($response) = $this->addExtendedPropertiesWithHttpInfo($orders_add_extended_properties_request, $contentType);
        return $response;
    }

    /**
     * Operation addExtendedPropertiesWithHttpInfo
     *
     * AddExtendedProperties
     *
     * @param  \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest $orders_add_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\AddExtendedPropertiesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addExtendedPropertiesWithHttpInfo($orders_add_extended_properties_request, string $contentType = self::contentTypes['addExtendedProperties'][0])
    {
        $request = $this->addExtendedPropertiesRequest($orders_add_extended_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\AddExtendedPropertiesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\AddExtendedPropertiesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\AddExtendedPropertiesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\AddExtendedPropertiesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\AddExtendedPropertiesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addExtendedPropertiesAsync
     *
     * AddExtendedProperties
     *
     * @param  \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest $orders_add_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addExtendedPropertiesAsync($orders_add_extended_properties_request, string $contentType = self::contentTypes['addExtendedProperties'][0])
    {
        return $this->addExtendedPropertiesAsyncWithHttpInfo($orders_add_extended_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addExtendedPropertiesAsyncWithHttpInfo
     *
     * AddExtendedProperties
     *
     * @param  \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest $orders_add_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addExtendedPropertiesAsyncWithHttpInfo($orders_add_extended_properties_request, string $contentType = self::contentTypes['addExtendedProperties'][0])
    {
        $returnType = '\Linnworks\Orders\Model\AddExtendedPropertiesResponse';
        $request = $this->addExtendedPropertiesRequest($orders_add_extended_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addExtendedProperties'
     *
     * @param  \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest $orders_add_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addExtendedPropertiesRequest($orders_add_extended_properties_request, string $contentType = self::contentTypes['addExtendedProperties'][0])
    {

        // verify the required parameter 'orders_add_extended_properties_request' is set
        if ($orders_add_extended_properties_request === null || (is_array($orders_add_extended_properties_request) && count($orders_add_extended_properties_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_add_extended_properties_request when calling addExtendedProperties'
            );
        }


        $resourcePath = '/api/Orders/AddExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_add_extended_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_add_extended_properties_request));
            } else {
                $httpBody = $orders_add_extended_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrderItem
     *
     * AddOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderItemRequest $orders_add_order_item_request orders_add_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UpdateOrderItemResult
     */
    public function addOrderItem($orders_add_order_item_request, string $contentType = self::contentTypes['addOrderItem'][0])
    {
        list($response) = $this->addOrderItemWithHttpInfo($orders_add_order_item_request, $contentType);
        return $response;
    }

    /**
     * Operation addOrderItemWithHttpInfo
     *
     * AddOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderItemRequest $orders_add_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UpdateOrderItemResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrderItemWithHttpInfo($orders_add_order_item_request, string $contentType = self::contentTypes['addOrderItem'][0])
    {
        $request = $this->addOrderItemRequest($orders_add_order_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UpdateOrderItemResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UpdateOrderItemResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UpdateOrderItemResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UpdateOrderItemResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addOrderItemAsync
     *
     * AddOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderItemRequest $orders_add_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderItemAsync($orders_add_order_item_request, string $contentType = self::contentTypes['addOrderItem'][0])
    {
        return $this->addOrderItemAsyncWithHttpInfo($orders_add_order_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrderItemAsyncWithHttpInfo
     *
     * AddOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderItemRequest $orders_add_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderItemAsyncWithHttpInfo($orders_add_order_item_request, string $contentType = self::contentTypes['addOrderItem'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
        $request = $this->addOrderItemRequest($orders_add_order_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrderItem'
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderItemRequest $orders_add_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrderItemRequest($orders_add_order_item_request, string $contentType = self::contentTypes['addOrderItem'][0])
    {

        // verify the required parameter 'orders_add_order_item_request' is set
        if ($orders_add_order_item_request === null || (is_array($orders_add_order_item_request) && count($orders_add_order_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_add_order_item_request when calling addOrderItem'
            );
        }


        $resourcePath = '/api/Orders/AddOrderItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_add_order_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_add_order_item_request));
            } else {
                $httpBody = $orders_add_order_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addOrderService
     *
     * AddOrderService
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderServiceRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderService'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UpdateOrderItemResult
     */
    public function addOrderService($request = null, string $contentType = self::contentTypes['addOrderService'][0])
    {
        list($response) = $this->addOrderServiceWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation addOrderServiceWithHttpInfo
     *
     * AddOrderService
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderServiceRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderService'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UpdateOrderItemResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function addOrderServiceWithHttpInfo($request = null, string $contentType = self::contentTypes['addOrderService'][0])
    {
        $request = $this->addOrderServiceRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UpdateOrderItemResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UpdateOrderItemResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UpdateOrderItemResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UpdateOrderItemResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addOrderServiceAsync
     *
     * AddOrderService
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderServiceRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderService'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderServiceAsync($request = null, string $contentType = self::contentTypes['addOrderService'][0])
    {
        return $this->addOrderServiceAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addOrderServiceAsyncWithHttpInfo
     *
     * AddOrderService
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderServiceRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderService'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addOrderServiceAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['addOrderService'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
        $request = $this->addOrderServiceRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addOrderService'
     *
     * @param  \Linnworks\Orders\Model\OrdersAddOrderServiceRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addOrderService'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addOrderServiceRequest($request = null, string $contentType = self::contentTypes['addOrderService'][0])
    {



        $resourcePath = '/api/Orders/AddOrderService';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation assignOrderItemBatches
     *
     * AssignOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest $orders_assign_order_item_batches_request orders_assign_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function assignOrderItemBatches($orders_assign_order_item_batches_request, string $contentType = self::contentTypes['assignOrderItemBatches'][0])
    {
        $this->assignOrderItemBatchesWithHttpInfo($orders_assign_order_item_batches_request, $contentType);
    }

    /**
     * Operation assignOrderItemBatchesWithHttpInfo
     *
     * AssignOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest $orders_assign_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function assignOrderItemBatchesWithHttpInfo($orders_assign_order_item_batches_request, string $contentType = self::contentTypes['assignOrderItemBatches'][0])
    {
        $request = $this->assignOrderItemBatchesRequest($orders_assign_order_item_batches_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation assignOrderItemBatchesAsync
     *
     * AssignOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest $orders_assign_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignOrderItemBatchesAsync($orders_assign_order_item_batches_request, string $contentType = self::contentTypes['assignOrderItemBatches'][0])
    {
        return $this->assignOrderItemBatchesAsyncWithHttpInfo($orders_assign_order_item_batches_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation assignOrderItemBatchesAsyncWithHttpInfo
     *
     * AssignOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest $orders_assign_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignOrderItemBatchesAsyncWithHttpInfo($orders_assign_order_item_batches_request, string $contentType = self::contentTypes['assignOrderItemBatches'][0])
    {
        $returnType = '';
        $request = $this->assignOrderItemBatchesRequest($orders_assign_order_item_batches_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'assignOrderItemBatches'
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest $orders_assign_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function assignOrderItemBatchesRequest($orders_assign_order_item_batches_request, string $contentType = self::contentTypes['assignOrderItemBatches'][0])
    {

        // verify the required parameter 'orders_assign_order_item_batches_request' is set
        if ($orders_assign_order_item_batches_request === null || (is_array($orders_assign_order_item_batches_request) && count($orders_assign_order_item_batches_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_assign_order_item_batches_request when calling assignOrderItemBatches'
            );
        }


        $resourcePath = '/api/Orders/AssignOrderItemBatches';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_assign_order_item_batches_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_assign_order_item_batches_request));
            } else {
                $httpBody = $orders_assign_order_item_batches_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation assignStockToOrder
     *
     * AssignStockToOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest $orders_assign_stock_to_order_request orders_assign_stock_to_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignStockToOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderItemBatch[]
     */
    public function assignStockToOrder($orders_assign_stock_to_order_request, string $contentType = self::contentTypes['assignStockToOrder'][0])
    {
        list($response) = $this->assignStockToOrderWithHttpInfo($orders_assign_stock_to_order_request, $contentType);
        return $response;
    }

    /**
     * Operation assignStockToOrderWithHttpInfo
     *
     * AssignStockToOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest $orders_assign_stock_to_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignStockToOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function assignStockToOrderWithHttpInfo($orders_assign_stock_to_order_request, string $contentType = self::contentTypes['assignStockToOrder'][0])
    {
        $request = $this->assignStockToOrderRequest($orders_assign_stock_to_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation assignStockToOrderAsync
     *
     * AssignStockToOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest $orders_assign_stock_to_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignStockToOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignStockToOrderAsync($orders_assign_stock_to_order_request, string $contentType = self::contentTypes['assignStockToOrder'][0])
    {
        return $this->assignStockToOrderAsyncWithHttpInfo($orders_assign_stock_to_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation assignStockToOrderAsyncWithHttpInfo
     *
     * AssignStockToOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest $orders_assign_stock_to_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignStockToOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignStockToOrderAsyncWithHttpInfo($orders_assign_stock_to_order_request, string $contentType = self::contentTypes['assignStockToOrder'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
        $request = $this->assignStockToOrderRequest($orders_assign_stock_to_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'assignStockToOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest $orders_assign_stock_to_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignStockToOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function assignStockToOrderRequest($orders_assign_stock_to_order_request, string $contentType = self::contentTypes['assignStockToOrder'][0])
    {

        // verify the required parameter 'orders_assign_stock_to_order_request' is set
        if ($orders_assign_stock_to_order_request === null || (is_array($orders_assign_stock_to_order_request) && count($orders_assign_stock_to_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_assign_stock_to_order_request when calling assignStockToOrder'
            );
        }


        $resourcePath = '/api/Orders/AssignStockToOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_assign_stock_to_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_assign_stock_to_order_request));
            } else {
                $httpBody = $orders_assign_stock_to_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation assignToFolder
     *
     * AssignToFolder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignToFolderRequest $orders_assign_to_folder_request orders_assign_to_folder_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignToFolder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function assignToFolder($orders_assign_to_folder_request, string $contentType = self::contentTypes['assignToFolder'][0])
    {
        list($response) = $this->assignToFolderWithHttpInfo($orders_assign_to_folder_request, $contentType);
        return $response;
    }

    /**
     * Operation assignToFolderWithHttpInfo
     *
     * AssignToFolder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignToFolderRequest $orders_assign_to_folder_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignToFolder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function assignToFolderWithHttpInfo($orders_assign_to_folder_request, string $contentType = self::contentTypes['assignToFolder'][0])
    {
        $request = $this->assignToFolderRequest($orders_assign_to_folder_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation assignToFolderAsync
     *
     * AssignToFolder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignToFolderRequest $orders_assign_to_folder_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignToFolder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignToFolderAsync($orders_assign_to_folder_request, string $contentType = self::contentTypes['assignToFolder'][0])
    {
        return $this->assignToFolderAsyncWithHttpInfo($orders_assign_to_folder_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation assignToFolderAsyncWithHttpInfo
     *
     * AssignToFolder
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignToFolderRequest $orders_assign_to_folder_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignToFolder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignToFolderAsyncWithHttpInfo($orders_assign_to_folder_request, string $contentType = self::contentTypes['assignToFolder'][0])
    {
        $returnType = 'string[]';
        $request = $this->assignToFolderRequest($orders_assign_to_folder_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'assignToFolder'
     *
     * @param  \Linnworks\Orders\Model\OrdersAssignToFolderRequest $orders_assign_to_folder_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['assignToFolder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function assignToFolderRequest($orders_assign_to_folder_request, string $contentType = self::contentTypes['assignToFolder'][0])
    {

        // verify the required parameter 'orders_assign_to_folder_request' is set
        if ($orders_assign_to_folder_request === null || (is_array($orders_assign_to_folder_request) && count($orders_assign_to_folder_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_assign_to_folder_request when calling assignToFolder'
            );
        }


        $resourcePath = '/api/Orders/AssignToFolder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_assign_to_folder_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_assign_to_folder_request));
            } else {
                $httpBody = $orders_assign_to_folder_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cancelOrder
     *
     * CancelOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCancelOrderRequest $orders_cancel_order_request orders_cancel_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cancelOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function cancelOrder($orders_cancel_order_request, string $contentType = self::contentTypes['cancelOrder'][0])
    {
        list($response) = $this->cancelOrderWithHttpInfo($orders_cancel_order_request, $contentType);
        return $response;
    }

    /**
     * Operation cancelOrderWithHttpInfo
     *
     * CancelOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCancelOrderRequest $orders_cancel_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cancelOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelOrderWithHttpInfo($orders_cancel_order_request, string $contentType = self::contentTypes['cancelOrder'][0])
    {
        $request = $this->cancelOrderRequest($orders_cancel_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cancelOrderAsync
     *
     * CancelOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCancelOrderRequest $orders_cancel_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelOrderAsync($orders_cancel_order_request, string $contentType = self::contentTypes['cancelOrder'][0])
    {
        return $this->cancelOrderAsyncWithHttpInfo($orders_cancel_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cancelOrderAsyncWithHttpInfo
     *
     * CancelOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCancelOrderRequest $orders_cancel_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelOrderAsyncWithHttpInfo($orders_cancel_order_request, string $contentType = self::contentTypes['cancelOrder'][0])
    {
        $returnType = 'string';
        $request = $this->cancelOrderRequest($orders_cancel_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersCancelOrderRequest $orders_cancel_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelOrderRequest($orders_cancel_order_request, string $contentType = self::contentTypes['cancelOrder'][0])
    {

        // verify the required parameter 'orders_cancel_order_request' is set
        if ($orders_cancel_order_request === null || (is_array($orders_cancel_order_request) && count($orders_cancel_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_cancel_order_request when calling cancelOrder'
            );
        }


        $resourcePath = '/api/Orders/CancelOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_cancel_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_cancel_order_request));
            } else {
                $httpBody = $orders_cancel_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation changeOrderTag
     *
     * ChangeOrderTag
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeOrderTagRequest $orders_change_order_tag_request orders_change_order_tag_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderTag'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function changeOrderTag($orders_change_order_tag_request, string $contentType = self::contentTypes['changeOrderTag'][0])
    {
        list($response) = $this->changeOrderTagWithHttpInfo($orders_change_order_tag_request, $contentType);
        return $response;
    }

    /**
     * Operation changeOrderTagWithHttpInfo
     *
     * ChangeOrderTag
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeOrderTagRequest $orders_change_order_tag_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderTag'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function changeOrderTagWithHttpInfo($orders_change_order_tag_request, string $contentType = self::contentTypes['changeOrderTag'][0])
    {
        $request = $this->changeOrderTagRequest($orders_change_order_tag_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation changeOrderTagAsync
     *
     * ChangeOrderTag
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeOrderTagRequest $orders_change_order_tag_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeOrderTagAsync($orders_change_order_tag_request, string $contentType = self::contentTypes['changeOrderTag'][0])
    {
        return $this->changeOrderTagAsyncWithHttpInfo($orders_change_order_tag_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation changeOrderTagAsyncWithHttpInfo
     *
     * ChangeOrderTag
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeOrderTagRequest $orders_change_order_tag_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeOrderTagAsyncWithHttpInfo($orders_change_order_tag_request, string $contentType = self::contentTypes['changeOrderTag'][0])
    {
        $returnType = 'string[]';
        $request = $this->changeOrderTagRequest($orders_change_order_tag_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'changeOrderTag'
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeOrderTagRequest $orders_change_order_tag_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function changeOrderTagRequest($orders_change_order_tag_request, string $contentType = self::contentTypes['changeOrderTag'][0])
    {

        // verify the required parameter 'orders_change_order_tag_request' is set
        if ($orders_change_order_tag_request === null || (is_array($orders_change_order_tag_request) && count($orders_change_order_tag_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_change_order_tag_request when calling changeOrderTag'
            );
        }


        $resourcePath = '/api/Orders/ChangeOrderTag';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_change_order_tag_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_change_order_tag_request));
            } else {
                $httpBody = $orders_change_order_tag_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation changeShippingMethod
     *
     * ChangeShippingMethod
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest $orders_change_shipping_method_request orders_change_shipping_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeShippingMethod'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function changeShippingMethod($orders_change_shipping_method_request, string $contentType = self::contentTypes['changeShippingMethod'][0])
    {
        list($response) = $this->changeShippingMethodWithHttpInfo($orders_change_shipping_method_request, $contentType);
        return $response;
    }

    /**
     * Operation changeShippingMethodWithHttpInfo
     *
     * ChangeShippingMethod
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest $orders_change_shipping_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeShippingMethod'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function changeShippingMethodWithHttpInfo($orders_change_shipping_method_request, string $contentType = self::contentTypes['changeShippingMethod'][0])
    {
        $request = $this->changeShippingMethodRequest($orders_change_shipping_method_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation changeShippingMethodAsync
     *
     * ChangeShippingMethod
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest $orders_change_shipping_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeShippingMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeShippingMethodAsync($orders_change_shipping_method_request, string $contentType = self::contentTypes['changeShippingMethod'][0])
    {
        return $this->changeShippingMethodAsyncWithHttpInfo($orders_change_shipping_method_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation changeShippingMethodAsyncWithHttpInfo
     *
     * ChangeShippingMethod
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest $orders_change_shipping_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeShippingMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeShippingMethodAsyncWithHttpInfo($orders_change_shipping_method_request, string $contentType = self::contentTypes['changeShippingMethod'][0])
    {
        $returnType = 'string[]';
        $request = $this->changeShippingMethodRequest($orders_change_shipping_method_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'changeShippingMethod'
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest $orders_change_shipping_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeShippingMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function changeShippingMethodRequest($orders_change_shipping_method_request, string $contentType = self::contentTypes['changeShippingMethod'][0])
    {

        // verify the required parameter 'orders_change_shipping_method_request' is set
        if ($orders_change_shipping_method_request === null || (is_array($orders_change_shipping_method_request) && count($orders_change_shipping_method_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_change_shipping_method_request when calling changeShippingMethod'
            );
        }


        $resourcePath = '/api/Orders/ChangeShippingMethod';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_change_shipping_method_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_change_shipping_method_request));
            } else {
                $httpBody = $orders_change_shipping_method_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation changeStatus
     *
     * ChangeStatus
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeStatusRequest $orders_change_status_request orders_change_status_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeStatus'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function changeStatus($orders_change_status_request, string $contentType = self::contentTypes['changeStatus'][0])
    {
        list($response) = $this->changeStatusWithHttpInfo($orders_change_status_request, $contentType);
        return $response;
    }

    /**
     * Operation changeStatusWithHttpInfo
     *
     * ChangeStatus
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeStatusRequest $orders_change_status_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeStatus'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function changeStatusWithHttpInfo($orders_change_status_request, string $contentType = self::contentTypes['changeStatus'][0])
    {
        $request = $this->changeStatusRequest($orders_change_status_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation changeStatusAsync
     *
     * ChangeStatus
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeStatusRequest $orders_change_status_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeStatusAsync($orders_change_status_request, string $contentType = self::contentTypes['changeStatus'][0])
    {
        return $this->changeStatusAsyncWithHttpInfo($orders_change_status_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation changeStatusAsyncWithHttpInfo
     *
     * ChangeStatus
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeStatusRequest $orders_change_status_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeStatusAsyncWithHttpInfo($orders_change_status_request, string $contentType = self::contentTypes['changeStatus'][0])
    {
        $returnType = 'string[]';
        $request = $this->changeStatusRequest($orders_change_status_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'changeStatus'
     *
     * @param  \Linnworks\Orders\Model\OrdersChangeStatusRequest $orders_change_status_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function changeStatusRequest($orders_change_status_request, string $contentType = self::contentTypes['changeStatus'][0])
    {

        // verify the required parameter 'orders_change_status_request' is set
        if ($orders_change_status_request === null || (is_array($orders_change_status_request) && count($orders_change_status_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_change_status_request when calling changeStatus'
            );
        }


        $resourcePath = '/api/Orders/ChangeStatus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_change_status_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_change_status_request));
            } else {
                $httpBody = $orders_change_status_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation clearInvoicePrinted
     *
     * ClearInvoicePrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest $orders_clear_invoice_printed_request orders_clear_invoice_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearInvoicePrinted'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function clearInvoicePrinted($orders_clear_invoice_printed_request, string $contentType = self::contentTypes['clearInvoicePrinted'][0])
    {
        list($response) = $this->clearInvoicePrintedWithHttpInfo($orders_clear_invoice_printed_request, $contentType);
        return $response;
    }

    /**
     * Operation clearInvoicePrintedWithHttpInfo
     *
     * ClearInvoicePrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest $orders_clear_invoice_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearInvoicePrinted'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function clearInvoicePrintedWithHttpInfo($orders_clear_invoice_printed_request, string $contentType = self::contentTypes['clearInvoicePrinted'][0])
    {
        $request = $this->clearInvoicePrintedRequest($orders_clear_invoice_printed_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clearInvoicePrintedAsync
     *
     * ClearInvoicePrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest $orders_clear_invoice_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearInvoicePrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearInvoicePrintedAsync($orders_clear_invoice_printed_request, string $contentType = self::contentTypes['clearInvoicePrinted'][0])
    {
        return $this->clearInvoicePrintedAsyncWithHttpInfo($orders_clear_invoice_printed_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clearInvoicePrintedAsyncWithHttpInfo
     *
     * ClearInvoicePrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest $orders_clear_invoice_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearInvoicePrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearInvoicePrintedAsyncWithHttpInfo($orders_clear_invoice_printed_request, string $contentType = self::contentTypes['clearInvoicePrinted'][0])
    {
        $returnType = 'string[]';
        $request = $this->clearInvoicePrintedRequest($orders_clear_invoice_printed_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clearInvoicePrinted'
     *
     * @param  \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest $orders_clear_invoice_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearInvoicePrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clearInvoicePrintedRequest($orders_clear_invoice_printed_request, string $contentType = self::contentTypes['clearInvoicePrinted'][0])
    {

        // verify the required parameter 'orders_clear_invoice_printed_request' is set
        if ($orders_clear_invoice_printed_request === null || (is_array($orders_clear_invoice_printed_request) && count($orders_clear_invoice_printed_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_clear_invoice_printed_request when calling clearInvoicePrinted'
            );
        }


        $resourcePath = '/api/Orders/ClearInvoicePrinted';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_clear_invoice_printed_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_clear_invoice_printed_request));
            } else {
                $httpBody = $orders_clear_invoice_printed_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation clearPickListPrinted
     *
     * ClearPickListPrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest $orders_clear_pick_list_printed_request orders_clear_pick_list_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearPickListPrinted'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function clearPickListPrinted($orders_clear_pick_list_printed_request, string $contentType = self::contentTypes['clearPickListPrinted'][0])
    {
        list($response) = $this->clearPickListPrintedWithHttpInfo($orders_clear_pick_list_printed_request, $contentType);
        return $response;
    }

    /**
     * Operation clearPickListPrintedWithHttpInfo
     *
     * ClearPickListPrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest $orders_clear_pick_list_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearPickListPrinted'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function clearPickListPrintedWithHttpInfo($orders_clear_pick_list_printed_request, string $contentType = self::contentTypes['clearPickListPrinted'][0])
    {
        $request = $this->clearPickListPrintedRequest($orders_clear_pick_list_printed_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clearPickListPrintedAsync
     *
     * ClearPickListPrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest $orders_clear_pick_list_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearPickListPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearPickListPrintedAsync($orders_clear_pick_list_printed_request, string $contentType = self::contentTypes['clearPickListPrinted'][0])
    {
        return $this->clearPickListPrintedAsyncWithHttpInfo($orders_clear_pick_list_printed_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clearPickListPrintedAsyncWithHttpInfo
     *
     * ClearPickListPrinted
     *
     * @param  \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest $orders_clear_pick_list_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearPickListPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearPickListPrintedAsyncWithHttpInfo($orders_clear_pick_list_printed_request, string $contentType = self::contentTypes['clearPickListPrinted'][0])
    {
        $returnType = 'string[]';
        $request = $this->clearPickListPrintedRequest($orders_clear_pick_list_printed_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clearPickListPrinted'
     *
     * @param  \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest $orders_clear_pick_list_printed_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearPickListPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clearPickListPrintedRequest($orders_clear_pick_list_printed_request, string $contentType = self::contentTypes['clearPickListPrinted'][0])
    {

        // verify the required parameter 'orders_clear_pick_list_printed_request' is set
        if ($orders_clear_pick_list_printed_request === null || (is_array($orders_clear_pick_list_printed_request) && count($orders_clear_pick_list_printed_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_clear_pick_list_printed_request when calling clearPickListPrinted'
            );
        }


        $resourcePath = '/api/Orders/ClearPickListPrinted';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_clear_pick_list_printed_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_clear_pick_list_printed_request));
            } else {
                $httpBody = $orders_clear_pick_list_printed_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation clearShippingLabelInfo
     *
     * ClearShippingLabelInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest $orders_clear_shipping_label_info_request orders_clear_shipping_label_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearShippingLabelInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\KeyValuePairGuidString[]
     */
    public function clearShippingLabelInfo($orders_clear_shipping_label_info_request, string $contentType = self::contentTypes['clearShippingLabelInfo'][0])
    {
        list($response) = $this->clearShippingLabelInfoWithHttpInfo($orders_clear_shipping_label_info_request, $contentType);
        return $response;
    }

    /**
     * Operation clearShippingLabelInfoWithHttpInfo
     *
     * ClearShippingLabelInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest $orders_clear_shipping_label_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearShippingLabelInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\KeyValuePairGuidString[], HTTP status code, HTTP response headers (array of strings)
     */
    public function clearShippingLabelInfoWithHttpInfo($orders_clear_shipping_label_info_request, string $contentType = self::contentTypes['clearShippingLabelInfo'][0])
    {
        $request = $this->clearShippingLabelInfoRequest($orders_clear_shipping_label_info_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\KeyValuePairGuidString[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\KeyValuePairGuidString[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\KeyValuePairGuidString[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidString[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\KeyValuePairGuidString[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clearShippingLabelInfoAsync
     *
     * ClearShippingLabelInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest $orders_clear_shipping_label_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearShippingLabelInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearShippingLabelInfoAsync($orders_clear_shipping_label_info_request, string $contentType = self::contentTypes['clearShippingLabelInfo'][0])
    {
        return $this->clearShippingLabelInfoAsyncWithHttpInfo($orders_clear_shipping_label_info_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clearShippingLabelInfoAsyncWithHttpInfo
     *
     * ClearShippingLabelInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest $orders_clear_shipping_label_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearShippingLabelInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clearShippingLabelInfoAsyncWithHttpInfo($orders_clear_shipping_label_info_request, string $contentType = self::contentTypes['clearShippingLabelInfo'][0])
    {
        $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidString[]';
        $request = $this->clearShippingLabelInfoRequest($orders_clear_shipping_label_info_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clearShippingLabelInfo'
     *
     * @param  \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest $orders_clear_shipping_label_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clearShippingLabelInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clearShippingLabelInfoRequest($orders_clear_shipping_label_info_request, string $contentType = self::contentTypes['clearShippingLabelInfo'][0])
    {

        // verify the required parameter 'orders_clear_shipping_label_info_request' is set
        if ($orders_clear_shipping_label_info_request === null || (is_array($orders_clear_shipping_label_info_request) && count($orders_clear_shipping_label_info_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_clear_shipping_label_info_request when calling clearShippingLabelInfo'
            );
        }


        $resourcePath = '/api/Orders/ClearShippingLabelInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_clear_shipping_label_info_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_clear_shipping_label_info_request));
            } else {
                $httpBody = $orders_clear_shipping_label_info_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation completeOrder
     *
     * CompleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCompleteOrderRequest $orders_complete_order_request orders_complete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function completeOrder($orders_complete_order_request, string $contentType = self::contentTypes['completeOrder'][0])
    {
        list($response) = $this->completeOrderWithHttpInfo($orders_complete_order_request, $contentType);
        return $response;
    }

    /**
     * Operation completeOrderWithHttpInfo
     *
     * CompleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCompleteOrderRequest $orders_complete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function completeOrderWithHttpInfo($orders_complete_order_request, string $contentType = self::contentTypes['completeOrder'][0])
    {
        $request = $this->completeOrderRequest($orders_complete_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation completeOrderAsync
     *
     * CompleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCompleteOrderRequest $orders_complete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeOrderAsync($orders_complete_order_request, string $contentType = self::contentTypes['completeOrder'][0])
    {
        return $this->completeOrderAsyncWithHttpInfo($orders_complete_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation completeOrderAsyncWithHttpInfo
     *
     * CompleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCompleteOrderRequest $orders_complete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeOrderAsyncWithHttpInfo($orders_complete_order_request, string $contentType = self::contentTypes['completeOrder'][0])
    {
        $returnType = 'string';
        $request = $this->completeOrderRequest($orders_complete_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'completeOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersCompleteOrderRequest $orders_complete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function completeOrderRequest($orders_complete_order_request, string $contentType = self::contentTypes['completeOrder'][0])
    {

        // verify the required parameter 'orders_complete_order_request' is set
        if ($orders_complete_order_request === null || (is_array($orders_complete_order_request) && count($orders_complete_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_complete_order_request when calling completeOrder'
            );
        }


        $resourcePath = '/api/Orders/CompleteOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_complete_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_complete_order_request));
            } else {
                $httpBody = $orders_complete_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createNewItemAndLink
     *
     * CreateNewItemAndLink
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest $orders_create_new_item_and_link_request orders_create_new_item_and_link_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewItemAndLink'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function createNewItemAndLink($orders_create_new_item_and_link_request, string $contentType = self::contentTypes['createNewItemAndLink'][0])
    {
        list($response) = $this->createNewItemAndLinkWithHttpInfo($orders_create_new_item_and_link_request, $contentType);
        return $response;
    }

    /**
     * Operation createNewItemAndLinkWithHttpInfo
     *
     * CreateNewItemAndLink
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest $orders_create_new_item_and_link_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewItemAndLink'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNewItemAndLinkWithHttpInfo($orders_create_new_item_and_link_request, string $contentType = self::contentTypes['createNewItemAndLink'][0])
    {
        $request = $this->createNewItemAndLinkRequest($orders_create_new_item_and_link_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createNewItemAndLinkAsync
     *
     * CreateNewItemAndLink
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest $orders_create_new_item_and_link_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewItemAndLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNewItemAndLinkAsync($orders_create_new_item_and_link_request, string $contentType = self::contentTypes['createNewItemAndLink'][0])
    {
        return $this->createNewItemAndLinkAsyncWithHttpInfo($orders_create_new_item_and_link_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createNewItemAndLinkAsyncWithHttpInfo
     *
     * CreateNewItemAndLink
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest $orders_create_new_item_and_link_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewItemAndLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNewItemAndLinkAsyncWithHttpInfo($orders_create_new_item_and_link_request, string $contentType = self::contentTypes['createNewItemAndLink'][0])
    {
        $returnType = 'string';
        $request = $this->createNewItemAndLinkRequest($orders_create_new_item_and_link_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createNewItemAndLink'
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest $orders_create_new_item_and_link_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewItemAndLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createNewItemAndLinkRequest($orders_create_new_item_and_link_request, string $contentType = self::contentTypes['createNewItemAndLink'][0])
    {

        // verify the required parameter 'orders_create_new_item_and_link_request' is set
        if ($orders_create_new_item_and_link_request === null || (is_array($orders_create_new_item_and_link_request) && count($orders_create_new_item_and_link_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_create_new_item_and_link_request when calling createNewItemAndLink'
            );
        }


        $resourcePath = '/api/Orders/CreateNewItemAndLink';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_create_new_item_and_link_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_create_new_item_and_link_request));
            } else {
                $httpBody = $orders_create_new_item_and_link_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createNewOrder
     *
     * CreateNewOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewOrderRequest $orders_create_new_order_request orders_create_new_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OpenOrder
     */
    public function createNewOrder($orders_create_new_order_request, string $contentType = self::contentTypes['createNewOrder'][0])
    {
        list($response) = $this->createNewOrderWithHttpInfo($orders_create_new_order_request, $contentType);
        return $response;
    }

    /**
     * Operation createNewOrderWithHttpInfo
     *
     * CreateNewOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewOrderRequest $orders_create_new_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OpenOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNewOrderWithHttpInfo($orders_create_new_order_request, string $contentType = self::contentTypes['createNewOrder'][0])
    {
        $request = $this->createNewOrderRequest($orders_create_new_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OpenOrder' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OpenOrder' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OpenOrder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OpenOrder';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OpenOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createNewOrderAsync
     *
     * CreateNewOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewOrderRequest $orders_create_new_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNewOrderAsync($orders_create_new_order_request, string $contentType = self::contentTypes['createNewOrder'][0])
    {
        return $this->createNewOrderAsyncWithHttpInfo($orders_create_new_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createNewOrderAsyncWithHttpInfo
     *
     * CreateNewOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewOrderRequest $orders_create_new_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNewOrderAsyncWithHttpInfo($orders_create_new_order_request, string $contentType = self::contentTypes['createNewOrder'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OpenOrder';
        $request = $this->createNewOrderRequest($orders_create_new_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createNewOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateNewOrderRequest $orders_create_new_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createNewOrderRequest($orders_create_new_order_request, string $contentType = self::contentTypes['createNewOrder'][0])
    {

        // verify the required parameter 'orders_create_new_order_request' is set
        if ($orders_create_new_order_request === null || (is_array($orders_create_new_order_request) && count($orders_create_new_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_create_new_order_request when calling createNewOrder'
            );
        }


        $resourcePath = '/api/Orders/CreateNewOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_create_new_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_create_new_order_request));
            } else {
                $httpBody = $orders_create_new_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrders
     *
     * CreateOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateOrdersRequest $orders_create_orders_request orders_create_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function createOrders($orders_create_orders_request, string $contentType = self::contentTypes['createOrders'][0])
    {
        list($response) = $this->createOrdersWithHttpInfo($orders_create_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation createOrdersWithHttpInfo
     *
     * CreateOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateOrdersRequest $orders_create_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrdersWithHttpInfo($orders_create_orders_request, string $contentType = self::contentTypes['createOrders'][0])
    {
        $request = $this->createOrdersRequest($orders_create_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOrdersAsync
     *
     * CreateOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateOrdersRequest $orders_create_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrdersAsync($orders_create_orders_request, string $contentType = self::contentTypes['createOrders'][0])
    {
        return $this->createOrdersAsyncWithHttpInfo($orders_create_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrdersAsyncWithHttpInfo
     *
     * CreateOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateOrdersRequest $orders_create_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrdersAsyncWithHttpInfo($orders_create_orders_request, string $contentType = self::contentTypes['createOrders'][0])
    {
        $returnType = 'string[]';
        $request = $this->createOrdersRequest($orders_create_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrders'
     *
     * @param  \Linnworks\Orders\Model\OrdersCreateOrdersRequest $orders_create_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrdersRequest($orders_create_orders_request, string $contentType = self::contentTypes['createOrders'][0])
    {

        // verify the required parameter 'orders_create_orders_request' is set
        if ($orders_create_orders_request === null || (is_array($orders_create_orders_request) && count($orders_create_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_create_orders_request when calling createOrders'
            );
        }


        $resourcePath = '/api/Orders/CreateOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_create_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_create_orders_request));
            } else {
                $httpBody = $orders_create_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSerialisedValuesForOrderItems
     *
     * CreateSerialisedValuesForOrderItems
     *
     * @param  \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest|null $request Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSerialisedValuesForOrderItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createSerialisedValuesForOrderItems($request = null, string $contentType = self::contentTypes['createSerialisedValuesForOrderItems'][0])
    {
        $this->createSerialisedValuesForOrderItemsWithHttpInfo($request, $contentType);
    }

    /**
     * Operation createSerialisedValuesForOrderItemsWithHttpInfo
     *
     * CreateSerialisedValuesForOrderItems
     *
     * @param  \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest|null $request Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSerialisedValuesForOrderItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSerialisedValuesForOrderItemsWithHttpInfo($request = null, string $contentType = self::contentTypes['createSerialisedValuesForOrderItems'][0])
    {
        $request = $this->createSerialisedValuesForOrderItemsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createSerialisedValuesForOrderItemsAsync
     *
     * CreateSerialisedValuesForOrderItems
     *
     * @param  \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest|null $request Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSerialisedValuesForOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSerialisedValuesForOrderItemsAsync($request = null, string $contentType = self::contentTypes['createSerialisedValuesForOrderItems'][0])
    {
        return $this->createSerialisedValuesForOrderItemsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSerialisedValuesForOrderItemsAsyncWithHttpInfo
     *
     * CreateSerialisedValuesForOrderItems
     *
     * @param  \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest|null $request Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSerialisedValuesForOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSerialisedValuesForOrderItemsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['createSerialisedValuesForOrderItems'][0])
    {
        $returnType = '';
        $request = $this->createSerialisedValuesForOrderItemsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSerialisedValuesForOrderItems'
     *
     * @param  \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest|null $request Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSerialisedValuesForOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSerialisedValuesForOrderItemsRequest($request = null, string $contentType = self::contentTypes['createSerialisedValuesForOrderItems'][0])
    {



        $resourcePath = '/api/Orders/CreateSerialisedValuesForOrderItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customerLookUp
     *
     * CustomerLookUp
     *
     * @param  string|null $field Field to search by (optional)
     * @param  string|null $txt Text to find (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerLookUp'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\CustomerAddress[]
     */
    public function customerLookUp($field = null, $txt = null, string $contentType = self::contentTypes['customerLookUp'][0])
    {
        list($response) = $this->customerLookUpWithHttpInfo($field, $txt, $contentType);
        return $response;
    }

    /**
     * Operation customerLookUpWithHttpInfo
     *
     * CustomerLookUp
     *
     * @param  string|null $field Field to search by (optional)
     * @param  string|null $txt Text to find (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerLookUp'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\CustomerAddress[], HTTP status code, HTTP response headers (array of strings)
     */
    public function customerLookUpWithHttpInfo($field = null, $txt = null, string $contentType = self::contentTypes['customerLookUp'][0])
    {
        $request = $this->customerLookUpRequest($field, $txt, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\CustomerAddress[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\CustomerAddress[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\CustomerAddress[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\CustomerAddress[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\CustomerAddress[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation customerLookUpAsync
     *
     * CustomerLookUp
     *
     * @param  string|null $field Field to search by (optional)
     * @param  string|null $txt Text to find (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerLookUp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerLookUpAsync($field = null, $txt = null, string $contentType = self::contentTypes['customerLookUp'][0])
    {
        return $this->customerLookUpAsyncWithHttpInfo($field, $txt, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customerLookUpAsyncWithHttpInfo
     *
     * CustomerLookUp
     *
     * @param  string|null $field Field to search by (optional)
     * @param  string|null $txt Text to find (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerLookUp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerLookUpAsyncWithHttpInfo($field = null, $txt = null, string $contentType = self::contentTypes['customerLookUp'][0])
    {
        $returnType = '\Linnworks\Orders\Model\CustomerAddress[]';
        $request = $this->customerLookUpRequest($field, $txt, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customerLookUp'
     *
     * @param  string|null $field Field to search by (optional)
     * @param  string|null $txt Text to find (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerLookUp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customerLookUpRequest($field = null, $txt = null, string $contentType = self::contentTypes['customerLookUp'][0])
    {




        $resourcePath = '/api/Orders/CustomerLookUp';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $field,
            'field', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $txt,
            'txt', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrder
     *
     * DeleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersDeleteOrderRequest $orders_delete_order_request orders_delete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrder($orders_delete_order_request, string $contentType = self::contentTypes['deleteOrder'][0])
    {
        $this->deleteOrderWithHttpInfo($orders_delete_order_request, $contentType);
    }

    /**
     * Operation deleteOrderWithHttpInfo
     *
     * DeleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersDeleteOrderRequest $orders_delete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrderWithHttpInfo($orders_delete_order_request, string $contentType = self::contentTypes['deleteOrder'][0])
    {
        $request = $this->deleteOrderRequest($orders_delete_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrderAsync
     *
     * DeleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersDeleteOrderRequest $orders_delete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrderAsync($orders_delete_order_request, string $contentType = self::contentTypes['deleteOrder'][0])
    {
        return $this->deleteOrderAsyncWithHttpInfo($orders_delete_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrderAsyncWithHttpInfo
     *
     * DeleteOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersDeleteOrderRequest $orders_delete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrderAsyncWithHttpInfo($orders_delete_order_request, string $contentType = self::contentTypes['deleteOrder'][0])
    {
        $returnType = '';
        $request = $this->deleteOrderRequest($orders_delete_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersDeleteOrderRequest $orders_delete_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrderRequest($orders_delete_order_request, string $contentType = self::contentTypes['deleteOrder'][0])
    {

        // verify the required parameter 'orders_delete_order_request' is set
        if ($orders_delete_order_request === null || (is_array($orders_delete_order_request) && count($orders_delete_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_delete_order_request when calling deleteOrder'
            );
        }


        $resourcePath = '/api/Orders/DeleteOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_delete_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_delete_order_request));
            } else {
                $httpBody = $orders_delete_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllAvailableOrderItemBatchsByOrderId
     *
     * GetAllAvailableOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest $orders_get_all_available_order_item_batchs_by_order_id_request orders_get_all_available_order_item_batchs_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\StockItemBatch[]
     */
    public function getAllAvailableOrderItemBatchsByOrderId($orders_get_all_available_order_item_batchs_by_order_id_request, string $contentType = self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'][0])
    {
        list($response) = $this->getAllAvailableOrderItemBatchsByOrderIdWithHttpInfo($orders_get_all_available_order_item_batchs_by_order_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getAllAvailableOrderItemBatchsByOrderIdWithHttpInfo
     *
     * GetAllAvailableOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest $orders_get_all_available_order_item_batchs_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\StockItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllAvailableOrderItemBatchsByOrderIdWithHttpInfo($orders_get_all_available_order_item_batchs_by_order_id_request, string $contentType = self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'][0])
    {
        $request = $this->getAllAvailableOrderItemBatchsByOrderIdRequest($orders_get_all_available_order_item_batchs_by_order_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\StockItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\StockItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\StockItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\StockItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\StockItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllAvailableOrderItemBatchsByOrderIdAsync
     *
     * GetAllAvailableOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest $orders_get_all_available_order_item_batchs_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAvailableOrderItemBatchsByOrderIdAsync($orders_get_all_available_order_item_batchs_by_order_id_request, string $contentType = self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'][0])
    {
        return $this->getAllAvailableOrderItemBatchsByOrderIdAsyncWithHttpInfo($orders_get_all_available_order_item_batchs_by_order_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllAvailableOrderItemBatchsByOrderIdAsyncWithHttpInfo
     *
     * GetAllAvailableOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest $orders_get_all_available_order_item_batchs_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAvailableOrderItemBatchsByOrderIdAsyncWithHttpInfo($orders_get_all_available_order_item_batchs_by_order_id_request, string $contentType = self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'][0])
    {
        $returnType = '\Linnworks\Orders\Model\StockItemBatch[]';
        $request = $this->getAllAvailableOrderItemBatchsByOrderIdRequest($orders_get_all_available_order_item_batchs_by_order_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllAvailableOrderItemBatchsByOrderId'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest $orders_get_all_available_order_item_batchs_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllAvailableOrderItemBatchsByOrderIdRequest($orders_get_all_available_order_item_batchs_by_order_id_request, string $contentType = self::contentTypes['getAllAvailableOrderItemBatchsByOrderId'][0])
    {

        // verify the required parameter 'orders_get_all_available_order_item_batchs_by_order_id_request' is set
        if ($orders_get_all_available_order_item_batchs_by_order_id_request === null || (is_array($orders_get_all_available_order_item_batchs_by_order_id_request) && count($orders_get_all_available_order_item_batchs_by_order_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_all_available_order_item_batchs_by_order_id_request when calling getAllAvailableOrderItemBatchsByOrderId'
            );
        }


        $resourcePath = '/api/Orders/GetAllAvailableOrderItemBatchsByOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_all_available_order_item_batchs_by_order_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_all_available_order_item_batchs_by_order_id_request));
            } else {
                $httpBody = $orders_get_all_available_order_item_batchs_by_order_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllOpenOrders
     *
     * GetAllOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest $orders_get_all_open_orders_request orders_get_all_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getAllOpenOrders($orders_get_all_open_orders_request, string $contentType = self::contentTypes['getAllOpenOrders'][0])
    {
        list($response) = $this->getAllOpenOrdersWithHttpInfo($orders_get_all_open_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation getAllOpenOrdersWithHttpInfo
     *
     * GetAllOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest $orders_get_all_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllOpenOrdersWithHttpInfo($orders_get_all_open_orders_request, string $contentType = self::contentTypes['getAllOpenOrders'][0])
    {
        $request = $this->getAllOpenOrdersRequest($orders_get_all_open_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllOpenOrdersAsync
     *
     * GetAllOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest $orders_get_all_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOpenOrdersAsync($orders_get_all_open_orders_request, string $contentType = self::contentTypes['getAllOpenOrders'][0])
    {
        return $this->getAllOpenOrdersAsyncWithHttpInfo($orders_get_all_open_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllOpenOrdersAsyncWithHttpInfo
     *
     * GetAllOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest $orders_get_all_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOpenOrdersAsyncWithHttpInfo($orders_get_all_open_orders_request, string $contentType = self::contentTypes['getAllOpenOrders'][0])
    {
        $returnType = 'string[]';
        $request = $this->getAllOpenOrdersRequest($orders_get_all_open_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllOpenOrders'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest $orders_get_all_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllOpenOrdersRequest($orders_get_all_open_orders_request, string $contentType = self::contentTypes['getAllOpenOrders'][0])
    {

        // verify the required parameter 'orders_get_all_open_orders_request' is set
        if ($orders_get_all_open_orders_request === null || (is_array($orders_get_all_open_orders_request) && count($orders_get_all_open_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_all_open_orders_request when calling getAllOpenOrders'
            );
        }


        $resourcePath = '/api/Orders/GetAllOpenOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_all_open_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_all_open_orders_request));
            } else {
                $httpBody = $orders_get_all_open_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllOpenOrdersBetweenIndex
     *
     * GetAllOpenOrdersBetweenIndex
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest $orders_get_all_open_orders_between_index_request orders_get_all_open_orders_between_index_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrdersBetweenIndex'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getAllOpenOrdersBetweenIndex($orders_get_all_open_orders_between_index_request, string $contentType = self::contentTypes['getAllOpenOrdersBetweenIndex'][0])
    {
        list($response) = $this->getAllOpenOrdersBetweenIndexWithHttpInfo($orders_get_all_open_orders_between_index_request, $contentType);
        return $response;
    }

    /**
     * Operation getAllOpenOrdersBetweenIndexWithHttpInfo
     *
     * GetAllOpenOrdersBetweenIndex
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest $orders_get_all_open_orders_between_index_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrdersBetweenIndex'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllOpenOrdersBetweenIndexWithHttpInfo($orders_get_all_open_orders_between_index_request, string $contentType = self::contentTypes['getAllOpenOrdersBetweenIndex'][0])
    {
        $request = $this->getAllOpenOrdersBetweenIndexRequest($orders_get_all_open_orders_between_index_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllOpenOrdersBetweenIndexAsync
     *
     * GetAllOpenOrdersBetweenIndex
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest $orders_get_all_open_orders_between_index_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrdersBetweenIndex'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOpenOrdersBetweenIndexAsync($orders_get_all_open_orders_between_index_request, string $contentType = self::contentTypes['getAllOpenOrdersBetweenIndex'][0])
    {
        return $this->getAllOpenOrdersBetweenIndexAsyncWithHttpInfo($orders_get_all_open_orders_between_index_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllOpenOrdersBetweenIndexAsyncWithHttpInfo
     *
     * GetAllOpenOrdersBetweenIndex
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest $orders_get_all_open_orders_between_index_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrdersBetweenIndex'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOpenOrdersBetweenIndexAsyncWithHttpInfo($orders_get_all_open_orders_between_index_request, string $contentType = self::contentTypes['getAllOpenOrdersBetweenIndex'][0])
    {
        $returnType = 'string[]';
        $request = $this->getAllOpenOrdersBetweenIndexRequest($orders_get_all_open_orders_between_index_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllOpenOrdersBetweenIndex'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest $orders_get_all_open_orders_between_index_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOpenOrdersBetweenIndex'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllOpenOrdersBetweenIndexRequest($orders_get_all_open_orders_between_index_request, string $contentType = self::contentTypes['getAllOpenOrdersBetweenIndex'][0])
    {

        // verify the required parameter 'orders_get_all_open_orders_between_index_request' is set
        if ($orders_get_all_open_orders_between_index_request === null || (is_array($orders_get_all_open_orders_between_index_request) && count($orders_get_all_open_orders_between_index_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_all_open_orders_between_index_request when calling getAllOpenOrdersBetweenIndex'
            );
        }


        $resourcePath = '/api/Orders/GetAllOpenOrdersBetweenIndex';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_all_open_orders_between_index_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_all_open_orders_between_index_request));
            } else {
                $httpBody = $orders_get_all_open_orders_between_index_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssignedOrderItemBatches
     *
     * GetAssignedOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest $orders_get_assigned_order_item_batches_request orders_get_assigned_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAssignedOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderItemBatch[]
     */
    public function getAssignedOrderItemBatches($orders_get_assigned_order_item_batches_request, string $contentType = self::contentTypes['getAssignedOrderItemBatches'][0])
    {
        list($response) = $this->getAssignedOrderItemBatchesWithHttpInfo($orders_get_assigned_order_item_batches_request, $contentType);
        return $response;
    }

    /**
     * Operation getAssignedOrderItemBatchesWithHttpInfo
     *
     * GetAssignedOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest $orders_get_assigned_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAssignedOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssignedOrderItemBatchesWithHttpInfo($orders_get_assigned_order_item_batches_request, string $contentType = self::contentTypes['getAssignedOrderItemBatches'][0])
    {
        $request = $this->getAssignedOrderItemBatchesRequest($orders_get_assigned_order_item_batches_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAssignedOrderItemBatchesAsync
     *
     * GetAssignedOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest $orders_get_assigned_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAssignedOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssignedOrderItemBatchesAsync($orders_get_assigned_order_item_batches_request, string $contentType = self::contentTypes['getAssignedOrderItemBatches'][0])
    {
        return $this->getAssignedOrderItemBatchesAsyncWithHttpInfo($orders_get_assigned_order_item_batches_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAssignedOrderItemBatchesAsyncWithHttpInfo
     *
     * GetAssignedOrderItemBatches
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest $orders_get_assigned_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAssignedOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssignedOrderItemBatchesAsyncWithHttpInfo($orders_get_assigned_order_item_batches_request, string $contentType = self::contentTypes['getAssignedOrderItemBatches'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
        $request = $this->getAssignedOrderItemBatchesRequest($orders_get_assigned_order_item_batches_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssignedOrderItemBatches'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest $orders_get_assigned_order_item_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAssignedOrderItemBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAssignedOrderItemBatchesRequest($orders_get_assigned_order_item_batches_request, string $contentType = self::contentTypes['getAssignedOrderItemBatches'][0])
    {

        // verify the required parameter 'orders_get_assigned_order_item_batches_request' is set
        if ($orders_get_assigned_order_item_batches_request === null || (is_array($orders_get_assigned_order_item_batches_request) && count($orders_get_assigned_order_item_batches_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_assigned_order_item_batches_request when calling getAssignedOrderItemBatches'
            );
        }


        $resourcePath = '/api/Orders/GetAssignedOrderItemBatches';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_assigned_order_item_batches_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_assigned_order_item_batches_request));
            } else {
                $httpBody = $orders_get_assigned_order_item_batches_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAvailableFolders
     *
     * GetAvailableFolders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableFolders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderFolder[]
     */
    public function getAvailableFolders(string $contentType = self::contentTypes['getAvailableFolders'][0])
    {
        list($response) = $this->getAvailableFoldersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getAvailableFoldersWithHttpInfo
     *
     * GetAvailableFolders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableFolders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderFolder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAvailableFoldersWithHttpInfo(string $contentType = self::contentTypes['getAvailableFolders'][0])
    {
        $request = $this->getAvailableFoldersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderFolder[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderFolder[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderFolder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderFolder[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderFolder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAvailableFoldersAsync
     *
     * GetAvailableFolders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableFolders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableFoldersAsync(string $contentType = self::contentTypes['getAvailableFolders'][0])
    {
        return $this->getAvailableFoldersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAvailableFoldersAsyncWithHttpInfo
     *
     * GetAvailableFolders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableFolders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableFoldersAsyncWithHttpInfo(string $contentType = self::contentTypes['getAvailableFolders'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderFolder[]';
        $request = $this->getAvailableFoldersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAvailableFolders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableFolders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAvailableFoldersRequest(string $contentType = self::contentTypes['getAvailableFolders'][0])
    {


        $resourcePath = '/api/Orders/GetAvailableFolders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBatchPilots
     *
     * GetBatchPilots
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchPilots'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\KeyValuePairGuidString[]
     */
    public function getBatchPilots(string $contentType = self::contentTypes['getBatchPilots'][0])
    {
        list($response) = $this->getBatchPilotsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getBatchPilotsWithHttpInfo
     *
     * GetBatchPilots
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchPilots'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\KeyValuePairGuidString[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getBatchPilotsWithHttpInfo(string $contentType = self::contentTypes['getBatchPilots'][0])
    {
        $request = $this->getBatchPilotsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\KeyValuePairGuidString[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\KeyValuePairGuidString[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\KeyValuePairGuidString[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidString[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\KeyValuePairGuidString[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBatchPilotsAsync
     *
     * GetBatchPilots
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchPilots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchPilotsAsync(string $contentType = self::contentTypes['getBatchPilots'][0])
    {
        return $this->getBatchPilotsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBatchPilotsAsyncWithHttpInfo
     *
     * GetBatchPilots
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchPilots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchPilotsAsyncWithHttpInfo(string $contentType = self::contentTypes['getBatchPilots'][0])
    {
        $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidString[]';
        $request = $this->getBatchPilotsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBatchPilots'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchPilots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBatchPilotsRequest(string $contentType = self::contentTypes['getBatchPilots'][0])
    {


        $resourcePath = '/api/Orders/GetBatchPilots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCountries
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderCountry[]
     */
    public function getCountries(string $contentType = self::contentTypes['getCountries'][0])
    {
        list($response) = $this->getCountriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCountriesWithHttpInfo
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderCountry[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getCountriesWithHttpInfo(string $contentType = self::contentTypes['getCountries'][0])
    {
        $request = $this->getCountriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderCountry[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderCountry[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderCountry[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderCountry[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderCountry[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCountriesAsync
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountriesAsync(string $contentType = self::contentTypes['getCountries'][0])
    {
        return $this->getCountriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCountriesAsyncWithHttpInfo
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getCountries'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderCountry[]';
        $request = $this->getCountriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCountries'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCountriesRequest(string $contentType = self::contentTypes['getCountries'][0])
    {


        $resourcePath = '/api/Orders/GetCountries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDefaultPaymentMethodIdForNewOrder
     *
     * GetDefaultPaymentMethodIdForNewOrder
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultPaymentMethodIdForNewOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getDefaultPaymentMethodIdForNewOrder(string $contentType = self::contentTypes['getDefaultPaymentMethodIdForNewOrder'][0])
    {
        list($response) = $this->getDefaultPaymentMethodIdForNewOrderWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getDefaultPaymentMethodIdForNewOrderWithHttpInfo
     *
     * GetDefaultPaymentMethodIdForNewOrder
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultPaymentMethodIdForNewOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDefaultPaymentMethodIdForNewOrderWithHttpInfo(string $contentType = self::contentTypes['getDefaultPaymentMethodIdForNewOrder'][0])
    {
        $request = $this->getDefaultPaymentMethodIdForNewOrderRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDefaultPaymentMethodIdForNewOrderAsync
     *
     * GetDefaultPaymentMethodIdForNewOrder
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultPaymentMethodIdForNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDefaultPaymentMethodIdForNewOrderAsync(string $contentType = self::contentTypes['getDefaultPaymentMethodIdForNewOrder'][0])
    {
        return $this->getDefaultPaymentMethodIdForNewOrderAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDefaultPaymentMethodIdForNewOrderAsyncWithHttpInfo
     *
     * GetDefaultPaymentMethodIdForNewOrder
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultPaymentMethodIdForNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDefaultPaymentMethodIdForNewOrderAsyncWithHttpInfo(string $contentType = self::contentTypes['getDefaultPaymentMethodIdForNewOrder'][0])
    {
        $returnType = 'string';
        $request = $this->getDefaultPaymentMethodIdForNewOrderRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDefaultPaymentMethodIdForNewOrder'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultPaymentMethodIdForNewOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDefaultPaymentMethodIdForNewOrderRequest(string $contentType = self::contentTypes['getDefaultPaymentMethodIdForNewOrder'][0])
    {


        $resourcePath = '/api/Orders/GetDefaultPaymentMethodIdForNewOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDraftOrders
     *
     * GetDraftOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getDraftOrders(string $contentType = self::contentTypes['getDraftOrders'][0])
    {
        list($response) = $this->getDraftOrdersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getDraftOrdersWithHttpInfo
     *
     * GetDraftOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getDraftOrdersWithHttpInfo(string $contentType = self::contentTypes['getDraftOrders'][0])
    {
        $request = $this->getDraftOrdersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDraftOrdersAsync
     *
     * GetDraftOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftOrdersAsync(string $contentType = self::contentTypes['getDraftOrders'][0])
    {
        return $this->getDraftOrdersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDraftOrdersAsyncWithHttpInfo
     *
     * GetDraftOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftOrdersAsyncWithHttpInfo(string $contentType = self::contentTypes['getDraftOrders'][0])
    {
        $returnType = 'string[]';
        $request = $this->getDraftOrdersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDraftOrders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDraftOrdersRequest(string $contentType = self::contentTypes['getDraftOrders'][0])
    {


        $resourcePath = '/api/Orders/GetDraftOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExtendedProperties
     *
     * GetExtendedProperties
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ExtendedProperty[]
     */
    public function getExtendedProperties($order_id = null, string $contentType = self::contentTypes['getExtendedProperties'][0])
    {
        list($response) = $this->getExtendedPropertiesWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getExtendedPropertiesWithHttpInfo
     *
     * GetExtendedProperties
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ExtendedProperty[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getExtendedPropertiesWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getExtendedProperties'][0])
    {
        $request = $this->getExtendedPropertiesRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ExtendedProperty[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ExtendedProperty[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ExtendedProperty[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ExtendedProperty[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ExtendedProperty[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExtendedPropertiesAsync
     *
     * GetExtendedProperties
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertiesAsync($order_id = null, string $contentType = self::contentTypes['getExtendedProperties'][0])
    {
        return $this->getExtendedPropertiesAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExtendedPropertiesAsyncWithHttpInfo
     *
     * GetExtendedProperties
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertiesAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getExtendedProperties'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ExtendedProperty[]';
        $request = $this->getExtendedPropertiesRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExtendedProperties'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExtendedPropertiesRequest($order_id = null, string $contentType = self::contentTypes['getExtendedProperties'][0])
    {



        $resourcePath = '/api/Orders/GetExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExtendedPropertyNames
     *
     * GetExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getExtendedPropertyNames(string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        list($response) = $this->getExtendedPropertyNamesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getExtendedPropertyNamesWithHttpInfo
     *
     * GetExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getExtendedPropertyNamesWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        $request = $this->getExtendedPropertyNamesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExtendedPropertyNamesAsync
     *
     * GetExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyNamesAsync(string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        return $this->getExtendedPropertyNamesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExtendedPropertyNamesAsyncWithHttpInfo
     *
     * GetExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyNamesAsyncWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        $returnType = 'string[]';
        $request = $this->getExtendedPropertyNamesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExtendedPropertyNames'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExtendedPropertyNamesRequest(string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {


        $resourcePath = '/api/Orders/GetExtendedPropertyNames';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExtendedPropertyTypes
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getExtendedPropertyTypes(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        list($response) = $this->getExtendedPropertyTypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getExtendedPropertyTypesWithHttpInfo
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getExtendedPropertyTypesWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        $request = $this->getExtendedPropertyTypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExtendedPropertyTypesAsync
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyTypesAsync(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        return $this->getExtendedPropertyTypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExtendedPropertyTypesAsyncWithHttpInfo
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyTypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        $returnType = 'string[]';
        $request = $this->getExtendedPropertyTypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExtendedPropertyTypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExtendedPropertyTypesRequest(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {


        $resourcePath = '/api/Orders/GetExtendedPropertyTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLinkedItems
     *
     * GetLinkedItems
     *
     * @param  string|null $item_id Item id (pkStockItemId) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLinkedItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\LinkedItem[]
     */
    public function getLinkedItems($item_id = null, string $contentType = self::contentTypes['getLinkedItems'][0])
    {
        list($response) = $this->getLinkedItemsWithHttpInfo($item_id, $contentType);
        return $response;
    }

    /**
     * Operation getLinkedItemsWithHttpInfo
     *
     * GetLinkedItems
     *
     * @param  string|null $item_id Item id (pkStockItemId) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLinkedItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\LinkedItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getLinkedItemsWithHttpInfo($item_id = null, string $contentType = self::contentTypes['getLinkedItems'][0])
    {
        $request = $this->getLinkedItemsRequest($item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\LinkedItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\LinkedItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\LinkedItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\LinkedItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\LinkedItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLinkedItemsAsync
     *
     * GetLinkedItems
     *
     * @param  string|null $item_id Item id (pkStockItemId) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLinkedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLinkedItemsAsync($item_id = null, string $contentType = self::contentTypes['getLinkedItems'][0])
    {
        return $this->getLinkedItemsAsyncWithHttpInfo($item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLinkedItemsAsyncWithHttpInfo
     *
     * GetLinkedItems
     *
     * @param  string|null $item_id Item id (pkStockItemId) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLinkedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLinkedItemsAsyncWithHttpInfo($item_id = null, string $contentType = self::contentTypes['getLinkedItems'][0])
    {
        $returnType = '\Linnworks\Orders\Model\LinkedItem[]';
        $request = $this->getLinkedItemsRequest($item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLinkedItems'
     *
     * @param  string|null $item_id Item id (pkStockItemId) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLinkedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLinkedItemsRequest($item_id = null, string $contentType = self::contentTypes['getLinkedItems'][0])
    {



        $resourcePath = '/api/Orders/GetLinkedItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_id,
            'itemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOpenOrderIdByOrderOrReferenceId
     *
     * GetOpenOrderIdByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest $orders_get_open_order_id_by_order_or_reference_id_request orders_get_open_order_id_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderIdByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getOpenOrderIdByOrderOrReferenceId($orders_get_open_order_id_by_order_or_reference_id_request, string $contentType = self::contentTypes['getOpenOrderIdByOrderOrReferenceId'][0])
    {
        list($response) = $this->getOpenOrderIdByOrderOrReferenceIdWithHttpInfo($orders_get_open_order_id_by_order_or_reference_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getOpenOrderIdByOrderOrReferenceIdWithHttpInfo
     *
     * GetOpenOrderIdByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest $orders_get_open_order_id_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderIdByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOpenOrderIdByOrderOrReferenceIdWithHttpInfo($orders_get_open_order_id_by_order_or_reference_id_request, string $contentType = self::contentTypes['getOpenOrderIdByOrderOrReferenceId'][0])
    {
        $request = $this->getOpenOrderIdByOrderOrReferenceIdRequest($orders_get_open_order_id_by_order_or_reference_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOpenOrderIdByOrderOrReferenceIdAsync
     *
     * GetOpenOrderIdByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest $orders_get_open_order_id_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderIdByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrderIdByOrderOrReferenceIdAsync($orders_get_open_order_id_by_order_or_reference_id_request, string $contentType = self::contentTypes['getOpenOrderIdByOrderOrReferenceId'][0])
    {
        return $this->getOpenOrderIdByOrderOrReferenceIdAsyncWithHttpInfo($orders_get_open_order_id_by_order_or_reference_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOpenOrderIdByOrderOrReferenceIdAsyncWithHttpInfo
     *
     * GetOpenOrderIdByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest $orders_get_open_order_id_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderIdByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrderIdByOrderOrReferenceIdAsyncWithHttpInfo($orders_get_open_order_id_by_order_or_reference_id_request, string $contentType = self::contentTypes['getOpenOrderIdByOrderOrReferenceId'][0])
    {
        $returnType = 'string';
        $request = $this->getOpenOrderIdByOrderOrReferenceIdRequest($orders_get_open_order_id_by_order_or_reference_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOpenOrderIdByOrderOrReferenceId'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest $orders_get_open_order_id_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderIdByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOpenOrderIdByOrderOrReferenceIdRequest($orders_get_open_order_id_by_order_or_reference_id_request, string $contentType = self::contentTypes['getOpenOrderIdByOrderOrReferenceId'][0])
    {

        // verify the required parameter 'orders_get_open_order_id_by_order_or_reference_id_request' is set
        if ($orders_get_open_order_id_by_order_or_reference_id_request === null || (is_array($orders_get_open_order_id_by_order_or_reference_id_request) && count($orders_get_open_order_id_by_order_or_reference_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_open_order_id_by_order_or_reference_id_request when calling getOpenOrderIdByOrderOrReferenceId'
            );
        }


        $resourcePath = '/api/Orders/GetOpenOrderIdByOrderOrReferenceId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_open_order_id_by_order_or_reference_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_open_order_id_by_order_or_reference_id_request));
            } else {
                $httpBody = $orders_get_open_order_id_by_order_or_reference_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOpenOrderItemsSuppliers
     *
     * GetOpenOrderItemsSuppliers
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderItemsSuppliers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\KeyValuePairGuidGuid[]
     */
    public function getOpenOrderItemsSuppliers($order_id = null, string $contentType = self::contentTypes['getOpenOrderItemsSuppliers'][0])
    {
        list($response) = $this->getOpenOrderItemsSuppliersWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOpenOrderItemsSuppliersWithHttpInfo
     *
     * GetOpenOrderItemsSuppliers
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderItemsSuppliers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\KeyValuePairGuidGuid[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOpenOrderItemsSuppliersWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOpenOrderItemsSuppliers'][0])
    {
        $request = $this->getOpenOrderItemsSuppliersRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\KeyValuePairGuidGuid[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\KeyValuePairGuidGuid[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\KeyValuePairGuidGuid[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidGuid[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\KeyValuePairGuidGuid[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOpenOrderItemsSuppliersAsync
     *
     * GetOpenOrderItemsSuppliers
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderItemsSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrderItemsSuppliersAsync($order_id = null, string $contentType = self::contentTypes['getOpenOrderItemsSuppliers'][0])
    {
        return $this->getOpenOrderItemsSuppliersAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOpenOrderItemsSuppliersAsyncWithHttpInfo
     *
     * GetOpenOrderItemsSuppliers
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderItemsSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrderItemsSuppliersAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOpenOrderItemsSuppliers'][0])
    {
        $returnType = '\Linnworks\Orders\Model\KeyValuePairGuidGuid[]';
        $request = $this->getOpenOrderItemsSuppliersRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOpenOrderItemsSuppliers'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrderItemsSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOpenOrderItemsSuppliersRequest($order_id = null, string $contentType = self::contentTypes['getOpenOrderItemsSuppliers'][0])
    {



        $resourcePath = '/api/Orders/GetOpenOrderItemsSuppliers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOpenOrders
     *
     * GetOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest $orders_get_open_orders_request orders_get_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\GenericPagedResultOpenOrder
     */
    public function getOpenOrders($orders_get_open_orders_request, string $contentType = self::contentTypes['getOpenOrders'][0])
    {
        list($response) = $this->getOpenOrdersWithHttpInfo($orders_get_open_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation getOpenOrdersWithHttpInfo
     *
     * GetOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest $orders_get_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\GenericPagedResultOpenOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOpenOrdersWithHttpInfo($orders_get_open_orders_request, string $contentType = self::contentTypes['getOpenOrders'][0])
    {
        $request = $this->getOpenOrdersRequest($orders_get_open_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\GenericPagedResultOpenOrder' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\GenericPagedResultOpenOrder' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\GenericPagedResultOpenOrder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\GenericPagedResultOpenOrder';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\GenericPagedResultOpenOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOpenOrdersAsync
     *
     * GetOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest $orders_get_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrdersAsync($orders_get_open_orders_request, string $contentType = self::contentTypes['getOpenOrders'][0])
    {
        return $this->getOpenOrdersAsyncWithHttpInfo($orders_get_open_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOpenOrdersAsyncWithHttpInfo
     *
     * GetOpenOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest $orders_get_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrdersAsyncWithHttpInfo($orders_get_open_orders_request, string $contentType = self::contentTypes['getOpenOrders'][0])
    {
        $returnType = '\Linnworks\Orders\Model\GenericPagedResultOpenOrder';
        $request = $this->getOpenOrdersRequest($orders_get_open_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOpenOrders'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest $orders_get_open_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOpenOrdersRequest($orders_get_open_orders_request, string $contentType = self::contentTypes['getOpenOrders'][0])
    {

        // verify the required parameter 'orders_get_open_orders_request' is set
        if ($orders_get_open_orders_request === null || (is_array($orders_get_open_orders_request) && count($orders_get_open_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_open_orders_request when calling getOpenOrders'
            );
        }


        $resourcePath = '/api/Orders/GetOpenOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_open_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_open_orders_request));
            } else {
                $httpBody = $orders_get_open_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOpenOrdersByItemBarcode
     *
     * GetOpenOrdersByItemBarcode
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest $orders_get_open_orders_by_item_barcode_request orders_get_open_orders_by_item_barcode_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrdersByItemBarcode'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\KeyValuePairListOrderSummaryString
     */
    public function getOpenOrdersByItemBarcode($orders_get_open_orders_by_item_barcode_request, string $contentType = self::contentTypes['getOpenOrdersByItemBarcode'][0])
    {
        list($response) = $this->getOpenOrdersByItemBarcodeWithHttpInfo($orders_get_open_orders_by_item_barcode_request, $contentType);
        return $response;
    }

    /**
     * Operation getOpenOrdersByItemBarcodeWithHttpInfo
     *
     * GetOpenOrdersByItemBarcode
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest $orders_get_open_orders_by_item_barcode_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrdersByItemBarcode'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\KeyValuePairListOrderSummaryString, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOpenOrdersByItemBarcodeWithHttpInfo($orders_get_open_orders_by_item_barcode_request, string $contentType = self::contentTypes['getOpenOrdersByItemBarcode'][0])
    {
        $request = $this->getOpenOrdersByItemBarcodeRequest($orders_get_open_orders_by_item_barcode_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOpenOrdersByItemBarcodeAsync
     *
     * GetOpenOrdersByItemBarcode
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest $orders_get_open_orders_by_item_barcode_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrdersByItemBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrdersByItemBarcodeAsync($orders_get_open_orders_by_item_barcode_request, string $contentType = self::contentTypes['getOpenOrdersByItemBarcode'][0])
    {
        return $this->getOpenOrdersByItemBarcodeAsyncWithHttpInfo($orders_get_open_orders_by_item_barcode_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOpenOrdersByItemBarcodeAsyncWithHttpInfo
     *
     * GetOpenOrdersByItemBarcode
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest $orders_get_open_orders_by_item_barcode_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrdersByItemBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOpenOrdersByItemBarcodeAsyncWithHttpInfo($orders_get_open_orders_by_item_barcode_request, string $contentType = self::contentTypes['getOpenOrdersByItemBarcode'][0])
    {
        $returnType = '\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString';
        $request = $this->getOpenOrdersByItemBarcodeRequest($orders_get_open_orders_by_item_barcode_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOpenOrdersByItemBarcode'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest $orders_get_open_orders_by_item_barcode_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOpenOrdersByItemBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOpenOrdersByItemBarcodeRequest($orders_get_open_orders_by_item_barcode_request, string $contentType = self::contentTypes['getOpenOrdersByItemBarcode'][0])
    {

        // verify the required parameter 'orders_get_open_orders_by_item_barcode_request' is set
        if ($orders_get_open_orders_by_item_barcode_request === null || (is_array($orders_get_open_orders_by_item_barcode_request) && count($orders_get_open_orders_by_item_barcode_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_open_orders_by_item_barcode_request when calling getOpenOrdersByItemBarcode'
            );
        }


        $resourcePath = '/api/Orders/GetOpenOrdersByItemBarcode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_open_orders_by_item_barcode_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_open_orders_by_item_barcode_request));
            } else {
                $httpBody = $orders_get_open_orders_by_item_barcode_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrder
     *
     * GetOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrderRequest $orders_get_order_request orders_get_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OpenOrder
     */
    public function getOrder($orders_get_order_request, string $contentType = self::contentTypes['getOrder'][0])
    {
        list($response) = $this->getOrderWithHttpInfo($orders_get_order_request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderWithHttpInfo
     *
     * GetOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrderRequest $orders_get_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OpenOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderWithHttpInfo($orders_get_order_request, string $contentType = self::contentTypes['getOrder'][0])
    {
        $request = $this->getOrderRequest($orders_get_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OpenOrder' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OpenOrder' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OpenOrder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OpenOrder';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OpenOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderAsync
     *
     * GetOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrderRequest $orders_get_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAsync($orders_get_order_request, string $contentType = self::contentTypes['getOrder'][0])
    {
        return $this->getOrderAsyncWithHttpInfo($orders_get_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderAsyncWithHttpInfo
     *
     * GetOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrderRequest $orders_get_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAsyncWithHttpInfo($orders_get_order_request, string $contentType = self::contentTypes['getOrder'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OpenOrder';
        $request = $this->getOrderRequest($orders_get_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrderRequest $orders_get_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderRequest($orders_get_order_request, string $contentType = self::contentTypes['getOrder'][0])
    {

        // verify the required parameter 'orders_get_order_request' is set
        if ($orders_get_order_request === null || (is_array($orders_get_order_request) && count($orders_get_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_order_request when calling getOrder'
            );
        }


        $resourcePath = '/api/Orders/GetOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_order_request));
            } else {
                $httpBody = $orders_get_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderAuditTrail
     *
     * GetOrderAuditTrail
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderAuditTrail[]
     */
    public function getOrderAuditTrail($order_id = null, string $contentType = self::contentTypes['getOrderAuditTrail'][0])
    {
        list($response) = $this->getOrderAuditTrailWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderAuditTrailWithHttpInfo
     *
     * GetOrderAuditTrail
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderAuditTrail[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderAuditTrailWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderAuditTrail'][0])
    {
        $request = $this->getOrderAuditTrailRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderAuditTrail[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderAuditTrail[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderAuditTrail[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderAuditTrail[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderAuditTrail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderAuditTrailAsync
     *
     * GetOrderAuditTrail
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAuditTrailAsync($order_id = null, string $contentType = self::contentTypes['getOrderAuditTrail'][0])
    {
        return $this->getOrderAuditTrailAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderAuditTrailAsyncWithHttpInfo
     *
     * GetOrderAuditTrail
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAuditTrailAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderAuditTrail'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderAuditTrail[]';
        $request = $this->getOrderAuditTrailRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderAuditTrail'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderAuditTrailRequest($order_id = null, string $contentType = self::contentTypes['getOrderAuditTrail'][0])
    {



        $resourcePath = '/api/Orders/GetOrderAuditTrail';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderAuditTrailsByIds
     *
     * GetOrderAuditTrailsByIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrailsByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse
     */
    public function getOrderAuditTrailsByIds($request = null, string $contentType = self::contentTypes['getOrderAuditTrailsByIds'][0])
    {
        list($response) = $this->getOrderAuditTrailsByIdsWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderAuditTrailsByIdsWithHttpInfo
     *
     * GetOrderAuditTrailsByIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrailsByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderAuditTrailsByIdsWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderAuditTrailsByIds'][0])
    {
        $request = $this->getOrderAuditTrailsByIdsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderAuditTrailsByIdsAsync
     *
     * GetOrderAuditTrailsByIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrailsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAuditTrailsByIdsAsync($request = null, string $contentType = self::contentTypes['getOrderAuditTrailsByIds'][0])
    {
        return $this->getOrderAuditTrailsByIdsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderAuditTrailsByIdsAsyncWithHttpInfo
     *
     * GetOrderAuditTrailsByIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrailsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderAuditTrailsByIdsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderAuditTrailsByIds'][0])
    {
        $returnType = '\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse';
        $request = $this->getOrderAuditTrailsByIdsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderAuditTrailsByIds'
     *
     * @param  \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderAuditTrailsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderAuditTrailsByIdsRequest($request = null, string $contentType = self::contentTypes['getOrderAuditTrailsByIds'][0])
    {



        $resourcePath = '/api/Orders/GetOrderAuditTrailsByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderById
     *
     * GetOrderById
     *
     * @param  string|null $pk_order_id pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderDetails
     */
    public function getOrderById($pk_order_id = null, string $contentType = self::contentTypes['getOrderById'][0])
    {
        list($response) = $this->getOrderByIdWithHttpInfo($pk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderByIdWithHttpInfo
     *
     * GetOrderById
     *
     * @param  string|null $pk_order_id pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderByIdWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getOrderById'][0])
    {
        $request = $this->getOrderByIdRequest($pk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderDetails' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderDetails' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderDetails';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderByIdAsync
     *
     * GetOrderById
     *
     * @param  string|null $pk_order_id pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderByIdAsync($pk_order_id = null, string $contentType = self::contentTypes['getOrderById'][0])
    {
        return $this->getOrderByIdAsyncWithHttpInfo($pk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderByIdAsyncWithHttpInfo
     *
     * GetOrderById
     *
     * @param  string|null $pk_order_id pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderByIdAsyncWithHttpInfo($pk_order_id = null, string $contentType = self::contentTypes['getOrderById'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderDetails';
        $request = $this->getOrderByIdRequest($pk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderById'
     *
     * @param  string|null $pk_order_id pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderByIdRequest($pk_order_id = null, string $contentType = self::contentTypes['getOrderById'][0])
    {



        $resourcePath = '/api/Orders/GetOrderById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_order_id,
            'pkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderDetailsByNumOrderId
     *
     * GetOrderDetailsByNumOrderId
     *
     * @param  int|null $order_id Order Id (numeric) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByNumOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderDetails
     */
    public function getOrderDetailsByNumOrderId($order_id = null, string $contentType = self::contentTypes['getOrderDetailsByNumOrderId'][0])
    {
        list($response) = $this->getOrderDetailsByNumOrderIdWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderDetailsByNumOrderIdWithHttpInfo
     *
     * GetOrderDetailsByNumOrderId
     *
     * @param  int|null $order_id Order Id (numeric) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByNumOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderDetailsByNumOrderIdWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderDetailsByNumOrderId'][0])
    {
        $request = $this->getOrderDetailsByNumOrderIdRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderDetails' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderDetails' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderDetails';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderDetailsByNumOrderIdAsync
     *
     * GetOrderDetailsByNumOrderId
     *
     * @param  int|null $order_id Order Id (numeric) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByNumOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderDetailsByNumOrderIdAsync($order_id = null, string $contentType = self::contentTypes['getOrderDetailsByNumOrderId'][0])
    {
        return $this->getOrderDetailsByNumOrderIdAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderDetailsByNumOrderIdAsyncWithHttpInfo
     *
     * GetOrderDetailsByNumOrderId
     *
     * @param  int|null $order_id Order Id (numeric) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByNumOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderDetailsByNumOrderIdAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderDetailsByNumOrderId'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderDetails';
        $request = $this->getOrderDetailsByNumOrderIdRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderDetailsByNumOrderId'
     *
     * @param  int|null $order_id Order Id (numeric) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByNumOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderDetailsByNumOrderIdRequest($order_id = null, string $contentType = self::contentTypes['getOrderDetailsByNumOrderId'][0])
    {



        $resourcePath = '/api/Orders/GetOrderDetailsByNumOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'OrderId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderDetailsByReferenceId
     *
     * GetOrderDetailsByReferenceId
     *
     * @param  string|null $reference_id Order reference id, or SecondaryReferenceNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderDetails[]
     */
    public function getOrderDetailsByReferenceId($reference_id = null, string $contentType = self::contentTypes['getOrderDetailsByReferenceId'][0])
    {
        list($response) = $this->getOrderDetailsByReferenceIdWithHttpInfo($reference_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderDetailsByReferenceIdWithHttpInfo
     *
     * GetOrderDetailsByReferenceId
     *
     * @param  string|null $reference_id Order reference id, or SecondaryReferenceNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderDetails[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderDetailsByReferenceIdWithHttpInfo($reference_id = null, string $contentType = self::contentTypes['getOrderDetailsByReferenceId'][0])
    {
        $request = $this->getOrderDetailsByReferenceIdRequest($reference_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderDetails[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderDetails[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderDetails[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderDetails[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderDetailsByReferenceIdAsync
     *
     * GetOrderDetailsByReferenceId
     *
     * @param  string|null $reference_id Order reference id, or SecondaryReferenceNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderDetailsByReferenceIdAsync($reference_id = null, string $contentType = self::contentTypes['getOrderDetailsByReferenceId'][0])
    {
        return $this->getOrderDetailsByReferenceIdAsyncWithHttpInfo($reference_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderDetailsByReferenceIdAsyncWithHttpInfo
     *
     * GetOrderDetailsByReferenceId
     *
     * @param  string|null $reference_id Order reference id, or SecondaryReferenceNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderDetailsByReferenceIdAsyncWithHttpInfo($reference_id = null, string $contentType = self::contentTypes['getOrderDetailsByReferenceId'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderDetails[]';
        $request = $this->getOrderDetailsByReferenceIdRequest($reference_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderDetailsByReferenceId'
     *
     * @param  string|null $reference_id Order reference id, or SecondaryReferenceNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderDetailsByReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderDetailsByReferenceIdRequest($reference_id = null, string $contentType = self::contentTypes['getOrderDetailsByReferenceId'][0])
    {



        $resourcePath = '/api/Orders/GetOrderDetailsByReferenceId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $reference_id,
            'ReferenceId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderItemBatchesByOrderIds
     *
     * GetOrderItemBatchesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest|null $request Made up of list of pkOrderIds (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchesByOrderIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse
     */
    public function getOrderItemBatchesByOrderIds($request = null, string $contentType = self::contentTypes['getOrderItemBatchesByOrderIds'][0])
    {
        list($response) = $this->getOrderItemBatchesByOrderIdsWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderItemBatchesByOrderIdsWithHttpInfo
     *
     * GetOrderItemBatchesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest|null $request Made up of list of pkOrderIds (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchesByOrderIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderItemBatchesByOrderIdsWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderItemBatchesByOrderIds'][0])
    {
        $request = $this->getOrderItemBatchesByOrderIdsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderItemBatchesByOrderIdsAsync
     *
     * GetOrderItemBatchesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest|null $request Made up of list of pkOrderIds (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemBatchesByOrderIdsAsync($request = null, string $contentType = self::contentTypes['getOrderItemBatchesByOrderIds'][0])
    {
        return $this->getOrderItemBatchesByOrderIdsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderItemBatchesByOrderIdsAsyncWithHttpInfo
     *
     * GetOrderItemBatchesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest|null $request Made up of list of pkOrderIds (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemBatchesByOrderIdsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderItemBatchesByOrderIds'][0])
    {
        $returnType = '\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse';
        $request = $this->getOrderItemBatchesByOrderIdsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderItemBatchesByOrderIds'
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest|null $request Made up of list of pkOrderIds (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderItemBatchesByOrderIdsRequest($request = null, string $contentType = self::contentTypes['getOrderItemBatchesByOrderIds'][0])
    {



        $resourcePath = '/api/Orders/GetOrderItemBatchesByOrderIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderItemBatchsByOrderId
     *
     * GetOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrderItemBatchInfo|null $parameters Made up of pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderItemBatch[]
     */
    public function getOrderItemBatchsByOrderId($parameters = null, string $contentType = self::contentTypes['getOrderItemBatchsByOrderId'][0])
    {
        list($response) = $this->getOrderItemBatchsByOrderIdWithHttpInfo($parameters, $contentType);
        return $response;
    }

    /**
     * Operation getOrderItemBatchsByOrderIdWithHttpInfo
     *
     * GetOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrderItemBatchInfo|null $parameters Made up of pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderItemBatchsByOrderIdWithHttpInfo($parameters = null, string $contentType = self::contentTypes['getOrderItemBatchsByOrderId'][0])
    {
        $request = $this->getOrderItemBatchsByOrderIdRequest($parameters, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderItemBatchsByOrderIdAsync
     *
     * GetOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrderItemBatchInfo|null $parameters Made up of pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemBatchsByOrderIdAsync($parameters = null, string $contentType = self::contentTypes['getOrderItemBatchsByOrderId'][0])
    {
        return $this->getOrderItemBatchsByOrderIdAsyncWithHttpInfo($parameters, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderItemBatchsByOrderIdAsyncWithHttpInfo
     *
     * GetOrderItemBatchsByOrderId
     *
     * @param  \Linnworks\Orders\Model\OrderItemBatchInfo|null $parameters Made up of pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemBatchsByOrderIdAsyncWithHttpInfo($parameters = null, string $contentType = self::contentTypes['getOrderItemBatchsByOrderId'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderItemBatch[]';
        $request = $this->getOrderItemBatchsByOrderIdRequest($parameters, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderItemBatchsByOrderId'
     *
     * @param  \Linnworks\Orders\Model\OrderItemBatchInfo|null $parameters Made up of pkOrderId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemBatchsByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderItemBatchsByOrderIdRequest($parameters = null, string $contentType = self::contentTypes['getOrderItemBatchsByOrderId'][0])
    {



        $resourcePath = '/api/Orders/GetOrderItemBatchsByOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($parameters)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($parameters));
            } else {
                $httpBody = $parameters;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderItemComposition
     *
     * GetOrderItemComposition
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $fulfilment_center Location to get the order item composition for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemComposition'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderItem
     */
    public function getOrderItemComposition($order_id = null, $stock_item_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItemComposition'][0])
    {
        list($response) = $this->getOrderItemCompositionWithHttpInfo($order_id, $stock_item_id, $fulfilment_center, $contentType);
        return $response;
    }

    /**
     * Operation getOrderItemCompositionWithHttpInfo
     *
     * GetOrderItemComposition
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $fulfilment_center Location to get the order item composition for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemComposition'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderItemCompositionWithHttpInfo($order_id = null, $stock_item_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItemComposition'][0])
    {
        $request = $this->getOrderItemCompositionRequest($order_id, $stock_item_id, $fulfilment_center, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderItem' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderItem' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderItem';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderItemCompositionAsync
     *
     * GetOrderItemComposition
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $fulfilment_center Location to get the order item composition for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemComposition'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemCompositionAsync($order_id = null, $stock_item_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItemComposition'][0])
    {
        return $this->getOrderItemCompositionAsyncWithHttpInfo($order_id, $stock_item_id, $fulfilment_center, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderItemCompositionAsyncWithHttpInfo
     *
     * GetOrderItemComposition
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $fulfilment_center Location to get the order item composition for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemComposition'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemCompositionAsyncWithHttpInfo($order_id = null, $stock_item_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItemComposition'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderItem';
        $request = $this->getOrderItemCompositionRequest($order_id, $stock_item_id, $fulfilment_center, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderItemComposition'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $fulfilment_center Location to get the order item composition for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemComposition'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderItemCompositionRequest($order_id = null, $stock_item_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItemComposition'][0])
    {





        $resourcePath = '/api/Orders/GetOrderItemComposition';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fulfilment_center,
            'fulfilmentCenter', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderItemRowSerialValuesByOrderIds
     *
     * GetOrderItemRowSerialValuesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest|null $request Request with collection of order ids as properties (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemRowSerialValuesByOrderIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse
     */
    public function getOrderItemRowSerialValuesByOrderIds($request = null, string $contentType = self::contentTypes['getOrderItemRowSerialValuesByOrderIds'][0])
    {
        list($response) = $this->getOrderItemRowSerialValuesByOrderIdsWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderItemRowSerialValuesByOrderIdsWithHttpInfo
     *
     * GetOrderItemRowSerialValuesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest|null $request Request with collection of order ids as properties (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemRowSerialValuesByOrderIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderItemRowSerialValuesByOrderIdsWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderItemRowSerialValuesByOrderIds'][0])
    {
        $request = $this->getOrderItemRowSerialValuesByOrderIdsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderItemRowSerialValuesByOrderIdsAsync
     *
     * GetOrderItemRowSerialValuesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest|null $request Request with collection of order ids as properties (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemRowSerialValuesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemRowSerialValuesByOrderIdsAsync($request = null, string $contentType = self::contentTypes['getOrderItemRowSerialValuesByOrderIds'][0])
    {
        return $this->getOrderItemRowSerialValuesByOrderIdsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderItemRowSerialValuesByOrderIdsAsyncWithHttpInfo
     *
     * GetOrderItemRowSerialValuesByOrderIds
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest|null $request Request with collection of order ids as properties (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemRowSerialValuesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemRowSerialValuesByOrderIdsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderItemRowSerialValuesByOrderIds'][0])
    {
        $returnType = '\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse';
        $request = $this->getOrderItemRowSerialValuesByOrderIdsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderItemRowSerialValuesByOrderIds'
     *
     * @param  \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest|null $request Request with collection of order ids as properties (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItemRowSerialValuesByOrderIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderItemRowSerialValuesByOrderIdsRequest($request = null, string $contentType = self::contentTypes['getOrderItemRowSerialValuesByOrderIds'][0])
    {



        $resourcePath = '/api/Orders/GetOrderItemRowSerialValuesByOrderIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderItems
     *
     * GetOrderItems
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $fulfilment_center Current fulfilment center (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderItem[]
     */
    public function getOrderItems($order_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItems'][0])
    {
        list($response) = $this->getOrderItemsWithHttpInfo($order_id, $fulfilment_center, $contentType);
        return $response;
    }

    /**
     * Operation getOrderItemsWithHttpInfo
     *
     * GetOrderItems
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $fulfilment_center Current fulfilment center (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderItemsWithHttpInfo($order_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItems'][0])
    {
        $request = $this->getOrderItemsRequest($order_id, $fulfilment_center, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderItemsAsync
     *
     * GetOrderItems
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $fulfilment_center Current fulfilment center (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemsAsync($order_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItems'][0])
    {
        return $this->getOrderItemsAsyncWithHttpInfo($order_id, $fulfilment_center, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderItemsAsyncWithHttpInfo
     *
     * GetOrderItems
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $fulfilment_center Current fulfilment center (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderItemsAsyncWithHttpInfo($order_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItems'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderItem[]';
        $request = $this->getOrderItemsRequest($order_id, $fulfilment_center, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderItems'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string|null $fulfilment_center Current fulfilment center (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderItemsRequest($order_id = null, $fulfilment_center = null, string $contentType = self::contentTypes['getOrderItems'][0])
    {




        $resourcePath = '/api/Orders/GetOrderItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fulfilment_center,
            'fulfilmentCenter', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderNoteTypes
     *
     * GetOrderNoteTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNoteTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderNoteType[]
     */
    public function getOrderNoteTypes(string $contentType = self::contentTypes['getOrderNoteTypes'][0])
    {
        list($response) = $this->getOrderNoteTypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrderNoteTypesWithHttpInfo
     *
     * GetOrderNoteTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNoteTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderNoteType[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderNoteTypesWithHttpInfo(string $contentType = self::contentTypes['getOrderNoteTypes'][0])
    {
        $request = $this->getOrderNoteTypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderNoteType[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderNoteType[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderNoteType[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderNoteType[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderNoteType[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderNoteTypesAsync
     *
     * GetOrderNoteTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNoteTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderNoteTypesAsync(string $contentType = self::contentTypes['getOrderNoteTypes'][0])
    {
        return $this->getOrderNoteTypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderNoteTypesAsyncWithHttpInfo
     *
     * GetOrderNoteTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNoteTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderNoteTypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrderNoteTypes'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderNoteType[]';
        $request = $this->getOrderNoteTypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderNoteTypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNoteTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderNoteTypesRequest(string $contentType = self::contentTypes['getOrderNoteTypes'][0])
    {


        $resourcePath = '/api/Orders/GetOrderNoteTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderNotes
     *
     * GetOrderNotes
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderNote[]
     */
    public function getOrderNotes($order_id = null, string $contentType = self::contentTypes['getOrderNotes'][0])
    {
        list($response) = $this->getOrderNotesWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderNotesWithHttpInfo
     *
     * GetOrderNotes
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderNote[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderNotesWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderNotes'][0])
    {
        $request = $this->getOrderNotesRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderNote[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderNote[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderNote[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderNote[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderNote[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderNotesAsync
     *
     * GetOrderNotes
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderNotesAsync($order_id = null, string $contentType = self::contentTypes['getOrderNotes'][0])
    {
        return $this->getOrderNotesAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderNotesAsyncWithHttpInfo
     *
     * GetOrderNotes
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderNotesAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderNotes'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderNote[]';
        $request = $this->getOrderNotesRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderNotes'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderNotesRequest($order_id = null, string $contentType = self::contentTypes['getOrderNotes'][0])
    {



        $resourcePath = '/api/Orders/GetOrderNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderPackagingCalculation
     *
     * GetOrderPackagingCalculation
     *
     * @param  \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest|null $request Orders to get packaging calculations for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingCalculation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\CalcOrderHeader[]
     */
    public function getOrderPackagingCalculation($request = null, string $contentType = self::contentTypes['getOrderPackagingCalculation'][0])
    {
        list($response) = $this->getOrderPackagingCalculationWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getOrderPackagingCalculationWithHttpInfo
     *
     * GetOrderPackagingCalculation
     *
     * @param  \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest|null $request Orders to get packaging calculations for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingCalculation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\CalcOrderHeader[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderPackagingCalculationWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderPackagingCalculation'][0])
    {
        $request = $this->getOrderPackagingCalculationRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\CalcOrderHeader[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\CalcOrderHeader[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\CalcOrderHeader[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\CalcOrderHeader[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\CalcOrderHeader[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderPackagingCalculationAsync
     *
     * GetOrderPackagingCalculation
     *
     * @param  \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest|null $request Orders to get packaging calculations for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingCalculation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderPackagingCalculationAsync($request = null, string $contentType = self::contentTypes['getOrderPackagingCalculation'][0])
    {
        return $this->getOrderPackagingCalculationAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderPackagingCalculationAsyncWithHttpInfo
     *
     * GetOrderPackagingCalculation
     *
     * @param  \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest|null $request Orders to get packaging calculations for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingCalculation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderPackagingCalculationAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getOrderPackagingCalculation'][0])
    {
        $returnType = '\Linnworks\Orders\Model\CalcOrderHeader[]';
        $request = $this->getOrderPackagingCalculationRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderPackagingCalculation'
     *
     * @param  \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest|null $request Orders to get packaging calculations for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingCalculation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderPackagingCalculationRequest($request = null, string $contentType = self::contentTypes['getOrderPackagingCalculation'][0])
    {



        $resourcePath = '/api/Orders/GetOrderPackagingCalculation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderPackagingSplit
     *
     * GetOrderPackagingSplit
     *
     * @param  string|null $order_id Order id (optional)
     * @param  bool|null $open_orders_only Whether to search open orders only, or all orders (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingSplit'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderPackagingSplit[]
     */
    public function getOrderPackagingSplit($order_id = null, $open_orders_only = null, string $contentType = self::contentTypes['getOrderPackagingSplit'][0])
    {
        list($response) = $this->getOrderPackagingSplitWithHttpInfo($order_id, $open_orders_only, $contentType);
        return $response;
    }

    /**
     * Operation getOrderPackagingSplitWithHttpInfo
     *
     * GetOrderPackagingSplit
     *
     * @param  string|null $order_id Order id (optional)
     * @param  bool|null $open_orders_only Whether to search open orders only, or all orders (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingSplit'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderPackagingSplit[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderPackagingSplitWithHttpInfo($order_id = null, $open_orders_only = null, string $contentType = self::contentTypes['getOrderPackagingSplit'][0])
    {
        $request = $this->getOrderPackagingSplitRequest($order_id, $open_orders_only, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderPackagingSplit[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderPackagingSplit[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderPackagingSplit[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderPackagingSplit[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderPackagingSplit[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderPackagingSplitAsync
     *
     * GetOrderPackagingSplit
     *
     * @param  string|null $order_id Order id (optional)
     * @param  bool|null $open_orders_only Whether to search open orders only, or all orders (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderPackagingSplitAsync($order_id = null, $open_orders_only = null, string $contentType = self::contentTypes['getOrderPackagingSplit'][0])
    {
        return $this->getOrderPackagingSplitAsyncWithHttpInfo($order_id, $open_orders_only, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderPackagingSplitAsyncWithHttpInfo
     *
     * GetOrderPackagingSplit
     *
     * @param  string|null $order_id Order id (optional)
     * @param  bool|null $open_orders_only Whether to search open orders only, or all orders (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderPackagingSplitAsyncWithHttpInfo($order_id = null, $open_orders_only = null, string $contentType = self::contentTypes['getOrderPackagingSplit'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderPackagingSplit[]';
        $request = $this->getOrderPackagingSplitRequest($order_id, $open_orders_only, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderPackagingSplit'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  bool|null $open_orders_only Whether to search open orders only, or all orders (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderPackagingSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderPackagingSplitRequest($order_id = null, $open_orders_only = null, string $contentType = self::contentTypes['getOrderPackagingSplit'][0])
    {




        $resourcePath = '/api/Orders/GetOrderPackagingSplit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $open_orders_only,
            'openOrdersOnly', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderRelations
     *
     * GetOrderRelations
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderRelations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderRelation[]
     */
    public function getOrderRelations($order_id = null, string $contentType = self::contentTypes['getOrderRelations'][0])
    {
        list($response) = $this->getOrderRelationsWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderRelationsWithHttpInfo
     *
     * GetOrderRelations
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderRelations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderRelation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderRelationsWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderRelations'][0])
    {
        $request = $this->getOrderRelationsRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderRelation[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderRelation[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderRelation[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderRelation[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderRelation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderRelationsAsync
     *
     * GetOrderRelations
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderRelationsAsync($order_id = null, string $contentType = self::contentTypes['getOrderRelations'][0])
    {
        return $this->getOrderRelationsAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderRelationsAsyncWithHttpInfo
     *
     * GetOrderRelations
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderRelationsAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderRelations'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderRelation[]';
        $request = $this->getOrderRelationsRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderRelations'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderRelationsRequest($order_id = null, string $contentType = self::contentTypes['getOrderRelations'][0])
    {



        $resourcePath = '/api/Orders/GetOrderRelations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderView
     *
     * GetOrderView
     *
     * @param  int|null $pk_view_id View id (optional)
     * @param  bool|null $mark_as_latest_viewed Mark it in the database as latest viewer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UserOrderView
     */
    public function getOrderView($pk_view_id = null, $mark_as_latest_viewed = null, string $contentType = self::contentTypes['getOrderView'][0])
    {
        list($response) = $this->getOrderViewWithHttpInfo($pk_view_id, $mark_as_latest_viewed, $contentType);
        return $response;
    }

    /**
     * Operation getOrderViewWithHttpInfo
     *
     * GetOrderView
     *
     * @param  int|null $pk_view_id View id (optional)
     * @param  bool|null $mark_as_latest_viewed Mark it in the database as latest viewer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UserOrderView, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderViewWithHttpInfo($pk_view_id = null, $mark_as_latest_viewed = null, string $contentType = self::contentTypes['getOrderView'][0])
    {
        $request = $this->getOrderViewRequest($pk_view_id, $mark_as_latest_viewed, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UserOrderView' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UserOrderView' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UserOrderView', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UserOrderView';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UserOrderView',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderViewAsync
     *
     * GetOrderView
     *
     * @param  int|null $pk_view_id View id (optional)
     * @param  bool|null $mark_as_latest_viewed Mark it in the database as latest viewer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderViewAsync($pk_view_id = null, $mark_as_latest_viewed = null, string $contentType = self::contentTypes['getOrderView'][0])
    {
        return $this->getOrderViewAsyncWithHttpInfo($pk_view_id, $mark_as_latest_viewed, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderViewAsyncWithHttpInfo
     *
     * GetOrderView
     *
     * @param  int|null $pk_view_id View id (optional)
     * @param  bool|null $mark_as_latest_viewed Mark it in the database as latest viewer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderViewAsyncWithHttpInfo($pk_view_id = null, $mark_as_latest_viewed = null, string $contentType = self::contentTypes['getOrderView'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UserOrderView';
        $request = $this->getOrderViewRequest($pk_view_id, $mark_as_latest_viewed, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderView'
     *
     * @param  int|null $pk_view_id View id (optional)
     * @param  bool|null $mark_as_latest_viewed Mark it in the database as latest viewer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderViewRequest($pk_view_id = null, $mark_as_latest_viewed = null, string $contentType = self::contentTypes['getOrderView'][0])
    {




        $resourcePath = '/api/Orders/GetOrderView';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_view_id,
            'pkViewId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $mark_as_latest_viewed,
            'markAsLatestViewed', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderViews
     *
     * GetOrderViews
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderViews'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UserOrderView[]
     * @deprecated
     */
    public function getOrderViews(string $contentType = self::contentTypes['getOrderViews'][0])
    {
        list($response) = $this->getOrderViewsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrderViewsWithHttpInfo
     *
     * GetOrderViews
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderViews'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UserOrderView[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getOrderViewsWithHttpInfo(string $contentType = self::contentTypes['getOrderViews'][0])
    {
        $request = $this->getOrderViewsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UserOrderView[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UserOrderView[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UserOrderView[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UserOrderView[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UserOrderView[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderViewsAsync
     *
     * GetOrderViews
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderViews'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getOrderViewsAsync(string $contentType = self::contentTypes['getOrderViews'][0])
    {
        return $this->getOrderViewsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderViewsAsyncWithHttpInfo
     *
     * GetOrderViews
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderViews'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getOrderViewsAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrderViews'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UserOrderView[]';
        $request = $this->getOrderViewsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderViews'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderViews'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getOrderViewsRequest(string $contentType = self::contentTypes['getOrderViews'][0])
    {


        $resourcePath = '/api/Orders/GetOrderViews';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderXml
     *
     * GetOrderXml
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXml'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderXML[]
     */
    public function getOrderXml($order_id = null, string $contentType = self::contentTypes['getOrderXml'][0])
    {
        list($response) = $this->getOrderXmlWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderXmlWithHttpInfo
     *
     * GetOrderXml
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXml'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderXML[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderXmlWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderXml'][0])
    {
        $request = $this->getOrderXmlRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderXML[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderXML[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderXML[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderXML[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderXML[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderXmlAsync
     *
     * GetOrderXml
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderXmlAsync($order_id = null, string $contentType = self::contentTypes['getOrderXml'][0])
    {
        return $this->getOrderXmlAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderXmlAsyncWithHttpInfo
     *
     * GetOrderXml
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderXmlAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderXml'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderXML[]';
        $request = $this->getOrderXmlRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderXml'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderXmlRequest($order_id = null, string $contentType = self::contentTypes['getOrderXml'][0])
    {



        $resourcePath = '/api/Orders/GetOrderXml';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrderXmlJSTree
     *
     * GetOrderXmlJSTree
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXmlJSTree'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getOrderXmlJSTree($order_id = null, string $contentType = self::contentTypes['getOrderXmlJSTree'][0])
    {
        list($response) = $this->getOrderXmlJSTreeWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getOrderXmlJSTreeWithHttpInfo
     *
     * GetOrderXmlJSTree
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXmlJSTree'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderXmlJSTreeWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderXmlJSTree'][0])
    {
        $request = $this->getOrderXmlJSTreeRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrderXmlJSTreeAsync
     *
     * GetOrderXmlJSTree
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXmlJSTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderXmlJSTreeAsync($order_id = null, string $contentType = self::contentTypes['getOrderXmlJSTree'][0])
    {
        return $this->getOrderXmlJSTreeAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderXmlJSTreeAsyncWithHttpInfo
     *
     * GetOrderXmlJSTree
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXmlJSTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderXmlJSTreeAsyncWithHttpInfo($order_id = null, string $contentType = self::contentTypes['getOrderXmlJSTree'][0])
    {
        $returnType = 'string';
        $request = $this->getOrderXmlJSTreeRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderXmlJSTree'
     *
     * @param  string|null $order_id Order id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderXmlJSTree'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderXmlJSTreeRequest($order_id = null, string $contentType = self::contentTypes['getOrderXmlJSTree'][0])
    {



        $resourcePath = '/api/Orders/GetOrderXmlJSTree';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrders
     *
     * GetOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRequest $orders_get_orders_request orders_get_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OpenOrder[]
     */
    public function getOrders($orders_get_orders_request, string $contentType = self::contentTypes['getOrders'][0])
    {
        list($response) = $this->getOrdersWithHttpInfo($orders_get_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation getOrdersWithHttpInfo
     *
     * GetOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRequest $orders_get_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OpenOrder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrdersWithHttpInfo($orders_get_orders_request, string $contentType = self::contentTypes['getOrders'][0])
    {
        $request = $this->getOrdersRequest($orders_get_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OpenOrder[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OpenOrder[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OpenOrder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OpenOrder[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OpenOrder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrdersAsync
     *
     * GetOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRequest $orders_get_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersAsync($orders_get_orders_request, string $contentType = self::contentTypes['getOrders'][0])
    {
        return $this->getOrdersAsyncWithHttpInfo($orders_get_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrdersAsyncWithHttpInfo
     *
     * GetOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRequest $orders_get_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersAsyncWithHttpInfo($orders_get_orders_request, string $contentType = self::contentTypes['getOrders'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OpenOrder[]';
        $request = $this->getOrdersRequest($orders_get_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrders'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRequest $orders_get_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrdersRequest($orders_get_orders_request, string $contentType = self::contentTypes['getOrders'][0])
    {

        // verify the required parameter 'orders_get_orders_request' is set
        if ($orders_get_orders_request === null || (is_array($orders_get_orders_request) && count($orders_get_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_orders_request when calling getOrders'
            );
        }


        $resourcePath = '/api/Orders/GetOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_orders_request));
            } else {
                $httpBody = $orders_get_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrdersById
     *
     * GetOrdersById
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest $orders_get_orders_by_id_request orders_get_orders_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderDetails[]
     */
    public function getOrdersById($orders_get_orders_by_id_request, string $contentType = self::contentTypes['getOrdersById'][0])
    {
        list($response) = $this->getOrdersByIdWithHttpInfo($orders_get_orders_by_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getOrdersByIdWithHttpInfo
     *
     * GetOrdersById
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest $orders_get_orders_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderDetails[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrdersByIdWithHttpInfo($orders_get_orders_by_id_request, string $contentType = self::contentTypes['getOrdersById'][0])
    {
        $request = $this->getOrdersByIdRequest($orders_get_orders_by_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderDetails[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderDetails[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderDetails[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OrderDetails[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OrderDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrdersByIdAsync
     *
     * GetOrdersById
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest $orders_get_orders_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersByIdAsync($orders_get_orders_by_id_request, string $contentType = self::contentTypes['getOrdersById'][0])
    {
        return $this->getOrdersByIdAsyncWithHttpInfo($orders_get_orders_by_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrdersByIdAsyncWithHttpInfo
     *
     * GetOrdersById
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest $orders_get_orders_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersByIdAsyncWithHttpInfo($orders_get_orders_by_id_request, string $contentType = self::contentTypes['getOrdersById'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OrderDetails[]';
        $request = $this->getOrdersByIdRequest($orders_get_orders_by_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrdersById'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest $orders_get_orders_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrdersByIdRequest($orders_get_orders_by_id_request, string $contentType = self::contentTypes['getOrdersById'][0])
    {

        // verify the required parameter 'orders_get_orders_by_id_request' is set
        if ($orders_get_orders_by_id_request === null || (is_array($orders_get_orders_by_id_request) && count($orders_get_orders_by_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_orders_by_id_request when calling getOrdersById'
            );
        }


        $resourcePath = '/api/Orders/GetOrdersById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_orders_by_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_orders_by_id_request));
            } else {
                $httpBody = $orders_get_orders_by_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrdersNotes
     *
     * GetOrdersNotes
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest $orders_get_orders_notes_request orders_get_orders_notes_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,\Linnworks\Orders\Model\OrderNote[]>
     */
    public function getOrdersNotes($orders_get_orders_notes_request, string $contentType = self::contentTypes['getOrdersNotes'][0])
    {
        list($response) = $this->getOrdersNotesWithHttpInfo($orders_get_orders_notes_request, $contentType);
        return $response;
    }

    /**
     * Operation getOrdersNotesWithHttpInfo
     *
     * GetOrdersNotes
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest $orders_get_orders_notes_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersNotes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,\Linnworks\Orders\Model\OrderNote[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrdersNotesWithHttpInfo($orders_get_orders_notes_request, string $contentType = self::contentTypes['getOrdersNotes'][0])
    {
        $request = $this->getOrdersNotesRequest($orders_get_orders_notes_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,\Linnworks\Orders\Model\OrderNote[]>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,\Linnworks\Orders\Model\OrderNote[]>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,\Linnworks\Orders\Model\OrderNote[]>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,\Linnworks\Orders\Model\OrderNote[]>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,\Linnworks\Orders\Model\OrderNote[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrdersNotesAsync
     *
     * GetOrdersNotes
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest $orders_get_orders_notes_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersNotesAsync($orders_get_orders_notes_request, string $contentType = self::contentTypes['getOrdersNotes'][0])
    {
        return $this->getOrdersNotesAsyncWithHttpInfo($orders_get_orders_notes_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrdersNotesAsyncWithHttpInfo
     *
     * GetOrdersNotes
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest $orders_get_orders_notes_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersNotesAsyncWithHttpInfo($orders_get_orders_notes_request, string $contentType = self::contentTypes['getOrdersNotes'][0])
    {
        $returnType = 'array<string,\Linnworks\Orders\Model\OrderNote[]>';
        $request = $this->getOrdersNotesRequest($orders_get_orders_notes_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrdersNotes'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest $orders_get_orders_notes_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrdersNotesRequest($orders_get_orders_notes_request, string $contentType = self::contentTypes['getOrdersNotes'][0])
    {

        // verify the required parameter 'orders_get_orders_notes_request' is set
        if ($orders_get_orders_notes_request === null || (is_array($orders_get_orders_notes_request) && count($orders_get_orders_notes_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_orders_notes_request when calling getOrdersNotes'
            );
        }


        $resourcePath = '/api/Orders/GetOrdersNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_orders_notes_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_orders_notes_request));
            } else {
                $httpBody = $orders_get_orders_notes_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrdersRelations
     *
     * GetOrdersRelations
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest $orders_get_orders_relations_request orders_get_orders_relations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersRelations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,\Linnworks\Orders\Model\OrderRelation[]>
     */
    public function getOrdersRelations($orders_get_orders_relations_request, string $contentType = self::contentTypes['getOrdersRelations'][0])
    {
        list($response) = $this->getOrdersRelationsWithHttpInfo($orders_get_orders_relations_request, $contentType);
        return $response;
    }

    /**
     * Operation getOrdersRelationsWithHttpInfo
     *
     * GetOrdersRelations
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest $orders_get_orders_relations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersRelations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,\Linnworks\Orders\Model\OrderRelation[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrdersRelationsWithHttpInfo($orders_get_orders_relations_request, string $contentType = self::contentTypes['getOrdersRelations'][0])
    {
        $request = $this->getOrdersRelationsRequest($orders_get_orders_relations_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,\Linnworks\Orders\Model\OrderRelation[]>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,\Linnworks\Orders\Model\OrderRelation[]>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,\Linnworks\Orders\Model\OrderRelation[]>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,\Linnworks\Orders\Model\OrderRelation[]>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,\Linnworks\Orders\Model\OrderRelation[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrdersRelationsAsync
     *
     * GetOrdersRelations
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest $orders_get_orders_relations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersRelationsAsync($orders_get_orders_relations_request, string $contentType = self::contentTypes['getOrdersRelations'][0])
    {
        return $this->getOrdersRelationsAsyncWithHttpInfo($orders_get_orders_relations_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrdersRelationsAsyncWithHttpInfo
     *
     * GetOrdersRelations
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest $orders_get_orders_relations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrdersRelationsAsyncWithHttpInfo($orders_get_orders_relations_request, string $contentType = self::contentTypes['getOrdersRelations'][0])
    {
        $returnType = 'array<string,\Linnworks\Orders\Model\OrderRelation[]>';
        $request = $this->getOrdersRelationsRequest($orders_get_orders_relations_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrdersRelations'
     *
     * @param  \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest $orders_get_orders_relations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrdersRelations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrdersRelationsRequest($orders_get_orders_relations_request, string $contentType = self::contentTypes['getOrdersRelations'][0])
    {

        // verify the required parameter 'orders_get_orders_relations_request' is set
        if ($orders_get_orders_relations_request === null || (is_array($orders_get_orders_relations_request) && count($orders_get_orders_relations_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_get_orders_relations_request when calling getOrdersRelations'
            );
        }


        $resourcePath = '/api/Orders/GetOrdersRelations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_get_orders_relations_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_get_orders_relations_request));
            } else {
                $httpBody = $orders_get_orders_relations_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPackagingGroups
     *
     * GetPackagingGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackagingGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\PackageGroup[]
     */
    public function getPackagingGroups(string $contentType = self::contentTypes['getPackagingGroups'][0])
    {
        list($response) = $this->getPackagingGroupsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getPackagingGroupsWithHttpInfo
     *
     * GetPackagingGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackagingGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\PackageGroup[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPackagingGroupsWithHttpInfo(string $contentType = self::contentTypes['getPackagingGroups'][0])
    {
        $request = $this->getPackagingGroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\PackageGroup[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\PackageGroup[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\PackageGroup[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\PackageGroup[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\PackageGroup[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPackagingGroupsAsync
     *
     * GetPackagingGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackagingGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackagingGroupsAsync(string $contentType = self::contentTypes['getPackagingGroups'][0])
    {
        return $this->getPackagingGroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPackagingGroupsAsyncWithHttpInfo
     *
     * GetPackagingGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackagingGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackagingGroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['getPackagingGroups'][0])
    {
        $returnType = '\Linnworks\Orders\Model\PackageGroup[]';
        $request = $this->getPackagingGroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPackagingGroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackagingGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPackagingGroupsRequest(string $contentType = self::contentTypes['getPackagingGroups'][0])
    {


        $resourcePath = '/api/Orders/GetPackagingGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaymentMethods
     *
     * GetPaymentMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentMethods'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\PaymentMethod[]
     */
    public function getPaymentMethods(string $contentType = self::contentTypes['getPaymentMethods'][0])
    {
        list($response) = $this->getPaymentMethodsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getPaymentMethodsWithHttpInfo
     *
     * GetPaymentMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentMethods'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\PaymentMethod[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentMethodsWithHttpInfo(string $contentType = self::contentTypes['getPaymentMethods'][0])
    {
        $request = $this->getPaymentMethodsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\PaymentMethod[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\PaymentMethod[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\PaymentMethod[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\PaymentMethod[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\PaymentMethod[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPaymentMethodsAsync
     *
     * GetPaymentMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentMethodsAsync(string $contentType = self::contentTypes['getPaymentMethods'][0])
    {
        return $this->getPaymentMethodsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPaymentMethodsAsyncWithHttpInfo
     *
     * GetPaymentMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentMethodsAsyncWithHttpInfo(string $contentType = self::contentTypes['getPaymentMethods'][0])
    {
        $returnType = '\Linnworks\Orders\Model\PaymentMethod[]';
        $request = $this->getPaymentMethodsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaymentMethods'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPaymentMethodsRequest(string $contentType = self::contentTypes['getPaymentMethods'][0])
    {


        $resourcePath = '/api/Orders/GetPaymentMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShippingMethods
     *
     * GetShippingMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingMethods'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ShippingMethod[]
     */
    public function getShippingMethods(string $contentType = self::contentTypes['getShippingMethods'][0])
    {
        list($response) = $this->getShippingMethodsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getShippingMethodsWithHttpInfo
     *
     * GetShippingMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingMethods'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ShippingMethod[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getShippingMethodsWithHttpInfo(string $contentType = self::contentTypes['getShippingMethods'][0])
    {
        $request = $this->getShippingMethodsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ShippingMethod[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ShippingMethod[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ShippingMethod[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ShippingMethod[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ShippingMethod[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShippingMethodsAsync
     *
     * GetShippingMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShippingMethodsAsync(string $contentType = self::contentTypes['getShippingMethods'][0])
    {
        return $this->getShippingMethodsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShippingMethodsAsyncWithHttpInfo
     *
     * GetShippingMethods
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShippingMethodsAsyncWithHttpInfo(string $contentType = self::contentTypes['getShippingMethods'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ShippingMethod[]';
        $request = $this->getShippingMethodsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShippingMethods'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShippingMethodsRequest(string $contentType = self::contentTypes['getShippingMethods'][0])
    {


        $resourcePath = '/api/Orders/GetShippingMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getUserLocationId
     *
     * GetUserLocationId
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUserLocationId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getUserLocationId(string $contentType = self::contentTypes['getUserLocationId'][0])
    {
        list($response) = $this->getUserLocationIdWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getUserLocationIdWithHttpInfo
     *
     * GetUserLocationId
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUserLocationId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUserLocationIdWithHttpInfo(string $contentType = self::contentTypes['getUserLocationId'][0])
    {
        $request = $this->getUserLocationIdRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getUserLocationIdAsync
     *
     * GetUserLocationId
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUserLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUserLocationIdAsync(string $contentType = self::contentTypes['getUserLocationId'][0])
    {
        return $this->getUserLocationIdAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getUserLocationIdAsyncWithHttpInfo
     *
     * GetUserLocationId
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUserLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUserLocationIdAsyncWithHttpInfo(string $contentType = self::contentTypes['getUserLocationId'][0])
    {
        $returnType = 'string';
        $request = $this->getUserLocationIdRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getUserLocationId'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUserLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getUserLocationIdRequest(string $contentType = self::contentTypes['getUserLocationId'][0])
    {


        $resourcePath = '/api/Orders/GetUserLocationId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation lockOrder
     *
     * LockOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersLockOrderRequest $orders_lock_order_request orders_lock_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['lockOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function lockOrder($orders_lock_order_request, string $contentType = self::contentTypes['lockOrder'][0])
    {
        $this->lockOrderWithHttpInfo($orders_lock_order_request, $contentType);
    }

    /**
     * Operation lockOrderWithHttpInfo
     *
     * LockOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersLockOrderRequest $orders_lock_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['lockOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function lockOrderWithHttpInfo($orders_lock_order_request, string $contentType = self::contentTypes['lockOrder'][0])
    {
        $request = $this->lockOrderRequest($orders_lock_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation lockOrderAsync
     *
     * LockOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersLockOrderRequest $orders_lock_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['lockOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function lockOrderAsync($orders_lock_order_request, string $contentType = self::contentTypes['lockOrder'][0])
    {
        return $this->lockOrderAsyncWithHttpInfo($orders_lock_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation lockOrderAsyncWithHttpInfo
     *
     * LockOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersLockOrderRequest $orders_lock_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['lockOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function lockOrderAsyncWithHttpInfo($orders_lock_order_request, string $contentType = self::contentTypes['lockOrder'][0])
    {
        $returnType = '';
        $request = $this->lockOrderRequest($orders_lock_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'lockOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersLockOrderRequest $orders_lock_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['lockOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function lockOrderRequest($orders_lock_order_request, string $contentType = self::contentTypes['lockOrder'][0])
    {

        // verify the required parameter 'orders_lock_order_request' is set
        if ($orders_lock_order_request === null || (is_array($orders_lock_order_request) && count($orders_lock_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_lock_order_request when calling lockOrder'
            );
        }


        $resourcePath = '/api/Orders/LockOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_lock_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_lock_order_request));
            } else {
                $httpBody = $orders_lock_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation mergeOrders
     *
     * MergeOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersMergeOrdersRequest $orders_merge_orders_request orders_merge_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['mergeOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OpenOrder
     */
    public function mergeOrders($orders_merge_orders_request, string $contentType = self::contentTypes['mergeOrders'][0])
    {
        list($response) = $this->mergeOrdersWithHttpInfo($orders_merge_orders_request, $contentType);
        return $response;
    }

    /**
     * Operation mergeOrdersWithHttpInfo
     *
     * MergeOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersMergeOrdersRequest $orders_merge_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['mergeOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OpenOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function mergeOrdersWithHttpInfo($orders_merge_orders_request, string $contentType = self::contentTypes['mergeOrders'][0])
    {
        $request = $this->mergeOrdersRequest($orders_merge_orders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OpenOrder' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OpenOrder' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OpenOrder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\OpenOrder';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\OpenOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation mergeOrdersAsync
     *
     * MergeOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersMergeOrdersRequest $orders_merge_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['mergeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function mergeOrdersAsync($orders_merge_orders_request, string $contentType = self::contentTypes['mergeOrders'][0])
    {
        return $this->mergeOrdersAsyncWithHttpInfo($orders_merge_orders_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation mergeOrdersAsyncWithHttpInfo
     *
     * MergeOrders
     *
     * @param  \Linnworks\Orders\Model\OrdersMergeOrdersRequest $orders_merge_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['mergeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function mergeOrdersAsyncWithHttpInfo($orders_merge_orders_request, string $contentType = self::contentTypes['mergeOrders'][0])
    {
        $returnType = '\Linnworks\Orders\Model\OpenOrder';
        $request = $this->mergeOrdersRequest($orders_merge_orders_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'mergeOrders'
     *
     * @param  \Linnworks\Orders\Model\OrdersMergeOrdersRequest $orders_merge_orders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['mergeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function mergeOrdersRequest($orders_merge_orders_request, string $contentType = self::contentTypes['mergeOrders'][0])
    {

        // verify the required parameter 'orders_merge_orders_request' is set
        if ($orders_merge_orders_request === null || (is_array($orders_merge_orders_request) && count($orders_merge_orders_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_merge_orders_request when calling mergeOrders'
            );
        }


        $resourcePath = '/api/Orders/MergeOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_merge_orders_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_merge_orders_request));
            } else {
                $httpBody = $orders_merge_orders_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation moveToLocation
     *
     * MoveToLocation
     *
     * @param  \Linnworks\Orders\Model\OrdersMoveToLocationRequest $orders_move_to_location_request orders_move_to_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['moveToLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\MoveToLocationResult
     */
    public function moveToLocation($orders_move_to_location_request, string $contentType = self::contentTypes['moveToLocation'][0])
    {
        list($response) = $this->moveToLocationWithHttpInfo($orders_move_to_location_request, $contentType);
        return $response;
    }

    /**
     * Operation moveToLocationWithHttpInfo
     *
     * MoveToLocation
     *
     * @param  \Linnworks\Orders\Model\OrdersMoveToLocationRequest $orders_move_to_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['moveToLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\MoveToLocationResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function moveToLocationWithHttpInfo($orders_move_to_location_request, string $contentType = self::contentTypes['moveToLocation'][0])
    {
        $request = $this->moveToLocationRequest($orders_move_to_location_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\MoveToLocationResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\MoveToLocationResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\MoveToLocationResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\MoveToLocationResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\MoveToLocationResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation moveToLocationAsync
     *
     * MoveToLocation
     *
     * @param  \Linnworks\Orders\Model\OrdersMoveToLocationRequest $orders_move_to_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['moveToLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function moveToLocationAsync($orders_move_to_location_request, string $contentType = self::contentTypes['moveToLocation'][0])
    {
        return $this->moveToLocationAsyncWithHttpInfo($orders_move_to_location_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation moveToLocationAsyncWithHttpInfo
     *
     * MoveToLocation
     *
     * @param  \Linnworks\Orders\Model\OrdersMoveToLocationRequest $orders_move_to_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['moveToLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function moveToLocationAsyncWithHttpInfo($orders_move_to_location_request, string $contentType = self::contentTypes['moveToLocation'][0])
    {
        $returnType = '\Linnworks\Orders\Model\MoveToLocationResult';
        $request = $this->moveToLocationRequest($orders_move_to_location_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'moveToLocation'
     *
     * @param  \Linnworks\Orders\Model\OrdersMoveToLocationRequest $orders_move_to_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['moveToLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function moveToLocationRequest($orders_move_to_location_request, string $contentType = self::contentTypes['moveToLocation'][0])
    {

        // verify the required parameter 'orders_move_to_location_request' is set
        if ($orders_move_to_location_request === null || (is_array($orders_move_to_location_request) && count($orders_move_to_location_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_move_to_location_request when calling moveToLocation'
            );
        }


        $resourcePath = '/api/Orders/MoveToLocation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_move_to_location_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_move_to_location_request));
            } else {
                $httpBody = $orders_move_to_location_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation processFulfilmentCentreOrder
     *
     * ProcessFulfilmentCentreOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest $orders_process_fulfilment_centre_order_request orders_process_fulfilment_centre_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processFulfilmentCentreOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ProcessOrderResult
     */
    public function processFulfilmentCentreOrder($orders_process_fulfilment_centre_order_request, string $contentType = self::contentTypes['processFulfilmentCentreOrder'][0])
    {
        list($response) = $this->processFulfilmentCentreOrderWithHttpInfo($orders_process_fulfilment_centre_order_request, $contentType);
        return $response;
    }

    /**
     * Operation processFulfilmentCentreOrderWithHttpInfo
     *
     * ProcessFulfilmentCentreOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest $orders_process_fulfilment_centre_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processFulfilmentCentreOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ProcessOrderResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function processFulfilmentCentreOrderWithHttpInfo($orders_process_fulfilment_centre_order_request, string $contentType = self::contentTypes['processFulfilmentCentreOrder'][0])
    {
        $request = $this->processFulfilmentCentreOrderRequest($orders_process_fulfilment_centre_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ProcessOrderResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ProcessOrderResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ProcessOrderResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ProcessOrderResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ProcessOrderResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation processFulfilmentCentreOrderAsync
     *
     * ProcessFulfilmentCentreOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest $orders_process_fulfilment_centre_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processFulfilmentCentreOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processFulfilmentCentreOrderAsync($orders_process_fulfilment_centre_order_request, string $contentType = self::contentTypes['processFulfilmentCentreOrder'][0])
    {
        return $this->processFulfilmentCentreOrderAsyncWithHttpInfo($orders_process_fulfilment_centre_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation processFulfilmentCentreOrderAsyncWithHttpInfo
     *
     * ProcessFulfilmentCentreOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest $orders_process_fulfilment_centre_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processFulfilmentCentreOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processFulfilmentCentreOrderAsyncWithHttpInfo($orders_process_fulfilment_centre_order_request, string $contentType = self::contentTypes['processFulfilmentCentreOrder'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ProcessOrderResult';
        $request = $this->processFulfilmentCentreOrderRequest($orders_process_fulfilment_centre_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'processFulfilmentCentreOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest $orders_process_fulfilment_centre_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processFulfilmentCentreOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function processFulfilmentCentreOrderRequest($orders_process_fulfilment_centre_order_request, string $contentType = self::contentTypes['processFulfilmentCentreOrder'][0])
    {

        // verify the required parameter 'orders_process_fulfilment_centre_order_request' is set
        if ($orders_process_fulfilment_centre_order_request === null || (is_array($orders_process_fulfilment_centre_order_request) && count($orders_process_fulfilment_centre_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_process_fulfilment_centre_order_request when calling processFulfilmentCentreOrder'
            );
        }


        $resourcePath = '/api/Orders/ProcessFulfilmentCentreOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_process_fulfilment_centre_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_process_fulfilment_centre_order_request));
            } else {
                $httpBody = $orders_process_fulfilment_centre_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation processOrder
     *
     * ProcessOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequest $orders_process_order_request orders_process_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ProcessOrderResult
     */
    public function processOrder($orders_process_order_request, string $contentType = self::contentTypes['processOrder'][0])
    {
        list($response) = $this->processOrderWithHttpInfo($orders_process_order_request, $contentType);
        return $response;
    }

    /**
     * Operation processOrderWithHttpInfo
     *
     * ProcessOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequest $orders_process_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ProcessOrderResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function processOrderWithHttpInfo($orders_process_order_request, string $contentType = self::contentTypes['processOrder'][0])
    {
        $request = $this->processOrderRequest($orders_process_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ProcessOrderResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ProcessOrderResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ProcessOrderResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ProcessOrderResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ProcessOrderResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation processOrderAsync
     *
     * ProcessOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequest $orders_process_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderAsync($orders_process_order_request, string $contentType = self::contentTypes['processOrder'][0])
    {
        return $this->processOrderAsyncWithHttpInfo($orders_process_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation processOrderAsyncWithHttpInfo
     *
     * ProcessOrder
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequest $orders_process_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderAsyncWithHttpInfo($orders_process_order_request, string $contentType = self::contentTypes['processOrder'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ProcessOrderResult';
        $request = $this->processOrderRequest($orders_process_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'processOrder'
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequest $orders_process_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function processOrderRequest($orders_process_order_request, string $contentType = self::contentTypes['processOrder'][0])
    {

        // verify the required parameter 'orders_process_order_request' is set
        if ($orders_process_order_request === null || (is_array($orders_process_order_request) && count($orders_process_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_process_order_request when calling processOrder'
            );
        }


        $resourcePath = '/api/Orders/ProcessOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_process_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_process_order_request));
            } else {
                $httpBody = $orders_process_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation processOrderByOrderOrReferenceId
     *
     * ProcessOrderByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest $orders_process_order_by_order_or_reference_id_request orders_process_order_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse
     */
    public function processOrderByOrderOrReferenceId($orders_process_order_by_order_or_reference_id_request, string $contentType = self::contentTypes['processOrderByOrderOrReferenceId'][0])
    {
        list($response) = $this->processOrderByOrderOrReferenceIdWithHttpInfo($orders_process_order_by_order_or_reference_id_request, $contentType);
        return $response;
    }

    /**
     * Operation processOrderByOrderOrReferenceIdWithHttpInfo
     *
     * ProcessOrderByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest $orders_process_order_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function processOrderByOrderOrReferenceIdWithHttpInfo($orders_process_order_by_order_or_reference_id_request, string $contentType = self::contentTypes['processOrderByOrderOrReferenceId'][0])
    {
        $request = $this->processOrderByOrderOrReferenceIdRequest($orders_process_order_by_order_or_reference_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation processOrderByOrderOrReferenceIdAsync
     *
     * ProcessOrderByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest $orders_process_order_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderByOrderOrReferenceIdAsync($orders_process_order_by_order_or_reference_id_request, string $contentType = self::contentTypes['processOrderByOrderOrReferenceId'][0])
    {
        return $this->processOrderByOrderOrReferenceIdAsyncWithHttpInfo($orders_process_order_by_order_or_reference_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation processOrderByOrderOrReferenceIdAsyncWithHttpInfo
     *
     * ProcessOrderByOrderOrReferenceId
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest $orders_process_order_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderByOrderOrReferenceIdAsyncWithHttpInfo($orders_process_order_by_order_or_reference_id_request, string $contentType = self::contentTypes['processOrderByOrderOrReferenceId'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse';
        $request = $this->processOrderByOrderOrReferenceIdRequest($orders_process_order_by_order_or_reference_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'processOrderByOrderOrReferenceId'
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest $orders_process_order_by_order_or_reference_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderByOrderOrReferenceId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function processOrderByOrderOrReferenceIdRequest($orders_process_order_by_order_or_reference_id_request, string $contentType = self::contentTypes['processOrderByOrderOrReferenceId'][0])
    {

        // verify the required parameter 'orders_process_order_by_order_or_reference_id_request' is set
        if ($orders_process_order_by_order_or_reference_id_request === null || (is_array($orders_process_order_by_order_or_reference_id_request) && count($orders_process_order_by_order_or_reference_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_process_order_by_order_or_reference_id_request when calling processOrderByOrderOrReferenceId'
            );
        }


        $resourcePath = '/api/Orders/ProcessOrderByOrderOrReferenceId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_process_order_by_order_or_reference_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_process_order_by_order_or_reference_id_request));
            } else {
                $httpBody = $orders_process_order_by_order_or_reference_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation processOrderRequiredBatchScans
     *
     * ProcessOrder_RequiredBatchScans
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest $orders_process_order_required_batch_scans_request orders_process_order_required_batch_scans_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderRequiredBatchScans'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function processOrderRequiredBatchScans($orders_process_order_required_batch_scans_request, string $contentType = self::contentTypes['processOrderRequiredBatchScans'][0])
    {
        $this->processOrderRequiredBatchScansWithHttpInfo($orders_process_order_required_batch_scans_request, $contentType);
    }

    /**
     * Operation processOrderRequiredBatchScansWithHttpInfo
     *
     * ProcessOrder_RequiredBatchScans
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest $orders_process_order_required_batch_scans_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderRequiredBatchScans'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function processOrderRequiredBatchScansWithHttpInfo($orders_process_order_required_batch_scans_request, string $contentType = self::contentTypes['processOrderRequiredBatchScans'][0])
    {
        $request = $this->processOrderRequiredBatchScansRequest($orders_process_order_required_batch_scans_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation processOrderRequiredBatchScansAsync
     *
     * ProcessOrder_RequiredBatchScans
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest $orders_process_order_required_batch_scans_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderRequiredBatchScans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderRequiredBatchScansAsync($orders_process_order_required_batch_scans_request, string $contentType = self::contentTypes['processOrderRequiredBatchScans'][0])
    {
        return $this->processOrderRequiredBatchScansAsyncWithHttpInfo($orders_process_order_required_batch_scans_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation processOrderRequiredBatchScansAsyncWithHttpInfo
     *
     * ProcessOrder_RequiredBatchScans
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest $orders_process_order_required_batch_scans_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderRequiredBatchScans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrderRequiredBatchScansAsyncWithHttpInfo($orders_process_order_required_batch_scans_request, string $contentType = self::contentTypes['processOrderRequiredBatchScans'][0])
    {
        $returnType = '';
        $request = $this->processOrderRequiredBatchScansRequest($orders_process_order_required_batch_scans_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'processOrderRequiredBatchScans'
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest $orders_process_order_required_batch_scans_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrderRequiredBatchScans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function processOrderRequiredBatchScansRequest($orders_process_order_required_batch_scans_request, string $contentType = self::contentTypes['processOrderRequiredBatchScans'][0])
    {

        // verify the required parameter 'orders_process_order_required_batch_scans_request' is set
        if ($orders_process_order_required_batch_scans_request === null || (is_array($orders_process_order_required_batch_scans_request) && count($orders_process_order_required_batch_scans_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_process_order_required_batch_scans_request when calling processOrderRequiredBatchScans'
            );
        }


        $resourcePath = '/api/Orders/ProcessOrder_RequiredBatchScans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_process_order_required_batch_scans_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_process_order_required_batch_scans_request));
            } else {
                $httpBody = $orders_process_order_required_batch_scans_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation processOrdersInBatch
     *
     * ProcessOrdersInBatch
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest $orders_process_orders_in_batch_request orders_process_orders_in_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrdersInBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\ProcessOrderResult[]
     */
    public function processOrdersInBatch($orders_process_orders_in_batch_request, string $contentType = self::contentTypes['processOrdersInBatch'][0])
    {
        list($response) = $this->processOrdersInBatchWithHttpInfo($orders_process_orders_in_batch_request, $contentType);
        return $response;
    }

    /**
     * Operation processOrdersInBatchWithHttpInfo
     *
     * ProcessOrdersInBatch
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest $orders_process_orders_in_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrdersInBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\ProcessOrderResult[], HTTP status code, HTTP response headers (array of strings)
     */
    public function processOrdersInBatchWithHttpInfo($orders_process_orders_in_batch_request, string $contentType = self::contentTypes['processOrdersInBatch'][0])
    {
        $request = $this->processOrdersInBatchRequest($orders_process_orders_in_batch_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\ProcessOrderResult[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\ProcessOrderResult[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\ProcessOrderResult[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\ProcessOrderResult[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\ProcessOrderResult[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation processOrdersInBatchAsync
     *
     * ProcessOrdersInBatch
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest $orders_process_orders_in_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrdersInBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrdersInBatchAsync($orders_process_orders_in_batch_request, string $contentType = self::contentTypes['processOrdersInBatch'][0])
    {
        return $this->processOrdersInBatchAsyncWithHttpInfo($orders_process_orders_in_batch_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation processOrdersInBatchAsyncWithHttpInfo
     *
     * ProcessOrdersInBatch
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest $orders_process_orders_in_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrdersInBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processOrdersInBatchAsyncWithHttpInfo($orders_process_orders_in_batch_request, string $contentType = self::contentTypes['processOrdersInBatch'][0])
    {
        $returnType = '\Linnworks\Orders\Model\ProcessOrderResult[]';
        $request = $this->processOrdersInBatchRequest($orders_process_orders_in_batch_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'processOrdersInBatch'
     *
     * @param  \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest $orders_process_orders_in_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['processOrdersInBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function processOrdersInBatchRequest($orders_process_orders_in_batch_request, string $contentType = self::contentTypes['processOrdersInBatch'][0])
    {

        // verify the required parameter 'orders_process_orders_in_batch_request' is set
        if ($orders_process_orders_in_batch_request === null || (is_array($orders_process_orders_in_batch_request) && count($orders_process_orders_in_batch_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_process_orders_in_batch_request when calling processOrdersInBatch'
            );
        }


        $resourcePath = '/api/Orders/ProcessOrdersInBatch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_process_orders_in_batch_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_process_orders_in_batch_request));
            } else {
                $httpBody = $orders_process_orders_in_batch_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation recalculateSingleOrderPackaging
     *
     * RecalculateSingleOrderPackaging
     *
     * @param  \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest $orders_recalculate_single_order_packaging_request orders_recalculate_single_order_packaging_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recalculateSingleOrderPackaging'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\CalcOrderHeader
     */
    public function recalculateSingleOrderPackaging($orders_recalculate_single_order_packaging_request, string $contentType = self::contentTypes['recalculateSingleOrderPackaging'][0])
    {
        list($response) = $this->recalculateSingleOrderPackagingWithHttpInfo($orders_recalculate_single_order_packaging_request, $contentType);
        return $response;
    }

    /**
     * Operation recalculateSingleOrderPackagingWithHttpInfo
     *
     * RecalculateSingleOrderPackaging
     *
     * @param  \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest $orders_recalculate_single_order_packaging_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recalculateSingleOrderPackaging'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\CalcOrderHeader, HTTP status code, HTTP response headers (array of strings)
     */
    public function recalculateSingleOrderPackagingWithHttpInfo($orders_recalculate_single_order_packaging_request, string $contentType = self::contentTypes['recalculateSingleOrderPackaging'][0])
    {
        $request = $this->recalculateSingleOrderPackagingRequest($orders_recalculate_single_order_packaging_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\CalcOrderHeader' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\CalcOrderHeader' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\CalcOrderHeader', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\CalcOrderHeader';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\CalcOrderHeader',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation recalculateSingleOrderPackagingAsync
     *
     * RecalculateSingleOrderPackaging
     *
     * @param  \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest $orders_recalculate_single_order_packaging_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recalculateSingleOrderPackaging'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function recalculateSingleOrderPackagingAsync($orders_recalculate_single_order_packaging_request, string $contentType = self::contentTypes['recalculateSingleOrderPackaging'][0])
    {
        return $this->recalculateSingleOrderPackagingAsyncWithHttpInfo($orders_recalculate_single_order_packaging_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation recalculateSingleOrderPackagingAsyncWithHttpInfo
     *
     * RecalculateSingleOrderPackaging
     *
     * @param  \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest $orders_recalculate_single_order_packaging_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recalculateSingleOrderPackaging'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function recalculateSingleOrderPackagingAsyncWithHttpInfo($orders_recalculate_single_order_packaging_request, string $contentType = self::contentTypes['recalculateSingleOrderPackaging'][0])
    {
        $returnType = '\Linnworks\Orders\Model\CalcOrderHeader';
        $request = $this->recalculateSingleOrderPackagingRequest($orders_recalculate_single_order_packaging_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'recalculateSingleOrderPackaging'
     *
     * @param  \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest $orders_recalculate_single_order_packaging_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recalculateSingleOrderPackaging'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function recalculateSingleOrderPackagingRequest($orders_recalculate_single_order_packaging_request, string $contentType = self::contentTypes['recalculateSingleOrderPackaging'][0])
    {

        // verify the required parameter 'orders_recalculate_single_order_packaging_request' is set
        if ($orders_recalculate_single_order_packaging_request === null || (is_array($orders_recalculate_single_order_packaging_request) && count($orders_recalculate_single_order_packaging_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_recalculate_single_order_packaging_request when calling recalculateSingleOrderPackaging'
            );
        }


        $resourcePath = '/api/Orders/RecalculateSingleOrderPackaging';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_recalculate_single_order_packaging_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_recalculate_single_order_packaging_request));
            } else {
                $httpBody = $orders_recalculate_single_order_packaging_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation removeOrderItem
     *
     * RemoveOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest $orders_remove_order_item_request orders_remove_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeOrderItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\UpdateOrderItemResult
     */
    public function removeOrderItem($orders_remove_order_item_request, string $contentType = self::contentTypes['removeOrderItem'][0])
    {
        list($response) = $this->removeOrderItemWithHttpInfo($orders_remove_order_item_request, $contentType);
        return $response;
    }

    /**
     * Operation removeOrderItemWithHttpInfo
     *
     * RemoveOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest $orders_remove_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeOrderItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\UpdateOrderItemResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function removeOrderItemWithHttpInfo($orders_remove_order_item_request, string $contentType = self::contentTypes['removeOrderItem'][0])
    {
        $request = $this->removeOrderItemRequest($orders_remove_order_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\UpdateOrderItemResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\UpdateOrderItemResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\UpdateOrderItemResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Orders\Model\UpdateOrderItemResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation removeOrderItemAsync
     *
     * RemoveOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest $orders_remove_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function removeOrderItemAsync($orders_remove_order_item_request, string $contentType = self::contentTypes['removeOrderItem'][0])
    {
        return $this->removeOrderItemAsyncWithHttpInfo($orders_remove_order_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation removeOrderItemAsyncWithHttpInfo
     *
     * RemoveOrderItem
     *
     * @param  \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest $orders_remove_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function removeOrderItemAsyncWithHttpInfo($orders_remove_order_item_request, string $contentType = self::contentTypes['removeOrderItem'][0])
    {
        $returnType = '\Linnworks\Orders\Model\UpdateOrderItemResult';
        $request = $this->removeOrderItemRequest($orders_remove_order_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'removeOrderItem'
     *
     * @param  \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest $orders_remove_order_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function removeOrderItemRequest($orders_remove_order_item_request, string $contentType = self::contentTypes['removeOrderItem'][0])
    {

        // verify the required parameter 'orders_remove_order_item_request' is set
        if ($orders_remove_order_item_request === null || (is_array($orders_remove_order_item_request) && count($orders_remove_order_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_remove_order_item_request when calling removeOrderItem'
            );
        }


        $resourcePath = '/api/Orders/RemoveOrderItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_remove_order_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_remove_order_item_request));
            } else {
                $httpBody = $orders_remove_order_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation runRulesEngine
     *
     * RunRulesEngine
     *
     * @param  \Linnworks\Orders\Model\OrdersRunRulesEngineRequest $orders_run_rules_engine_request orders_run_rules_engine_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['runRulesEngine'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function runRulesEngine($orders_run_rules_engine_request, string $contentType = self::contentTypes['runRulesEngine'][0])
    {
        list($response) = $this->runRulesEngineWithHttpInfo($orders_run_rules_engine_request, $contentType);
        return $response;
    }

    /**
     * Operation runRulesEngineWithHttpInfo
     *
     * RunRulesEngine
     *
     * @param  \Linnworks\Orders\Model\OrdersRunRulesEngineRequest $orders_run_rules_engine_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['runRulesEngine'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function runRulesEngineWithHttpInfo($orders_run_rules_engine_request, string $contentType = self::contentTypes['runRulesEngine'][0])
    {
        $request = $this->runRulesEngineRequest($orders_run_rules_engine_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation runRulesEngineAsync
     *
     * RunRulesEngine
     *
     * @param  \Linnworks\Orders\Model\OrdersRunRulesEngineRequest $orders_run_rules_engine_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['runRulesEngine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function runRulesEngineAsync($orders_run_rules_engine_request, string $contentType = self::contentTypes['runRulesEngine'][0])
    {
        return $this->runRulesEngineAsyncWithHttpInfo($orders_run_rules_engine_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation runRulesEngineAsyncWithHttpInfo
     *
     * RunRulesEngine
     *
     * @param  \Linnworks\Orders\Model\OrdersRunRulesEngineRequest $orders_run_rules_engine_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['runRulesEngine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function runRulesEngineAsyncWithHttpInfo($orders_run_rules_engine_request, string $contentType = self::contentTypes['runRulesEngine'][0])
    {
        $returnType = 'string[]';
        $request = $this->runRulesEngineRequest($orders_run_rules_engine_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'runRulesEngine'
     *
     * @param  \Linnworks\Orders\Model\OrdersRunRulesEngineRequest $orders_run_rules_engine_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['runRulesEngine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function runRulesEngineRequest($orders_run_rules_engine_request, string $contentType = self::contentTypes['runRulesEngine'][0])
    {

        // verify the required parameter 'orders_run_rules_engine_request' is set
        if ($orders_run_rules_engine_request === null || (is_array($orders_run_rules_engine_request) && count($orders_run_rules_engine_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_run_rules_engine_request when calling runRulesEngine'
            );
        }


        $resourcePath = '/api/Orders/RunRulesEngine';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_run_rules_engine_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_run_rules_engine_request));
            } else {
                $httpBody = $orders_run_rules_engine_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation saveOrderView
     *
     * SaveOrderView
     *
     * @param  \Linnworks\Orders\Model\OrdersSaveOrderViewRequest $orders_save_order_view_request orders_save_order_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveOrderView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function saveOrderView($orders_save_order_view_request, string $contentType = self::contentTypes['saveOrderView'][0])
    {
        $this->saveOrderViewWithHttpInfo($orders_save_order_view_request, $contentType);
    }

    /**
     * Operation saveOrderViewWithHttpInfo
     *
     * SaveOrderView
     *
     * @param  \Linnworks\Orders\Model\OrdersSaveOrderViewRequest $orders_save_order_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveOrderView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function saveOrderViewWithHttpInfo($orders_save_order_view_request, string $contentType = self::contentTypes['saveOrderView'][0])
    {
        $request = $this->saveOrderViewRequest($orders_save_order_view_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation saveOrderViewAsync
     *
     * SaveOrderView
     *
     * @param  \Linnworks\Orders\Model\OrdersSaveOrderViewRequest $orders_save_order_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function saveOrderViewAsync($orders_save_order_view_request, string $contentType = self::contentTypes['saveOrderView'][0])
    {
        return $this->saveOrderViewAsyncWithHttpInfo($orders_save_order_view_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation saveOrderViewAsyncWithHttpInfo
     *
     * SaveOrderView
     *
     * @param  \Linnworks\Orders\Model\OrdersSaveOrderViewRequest $orders_save_order_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function saveOrderViewAsyncWithHttpInfo($orders_save_order_view_request, string $contentType = self::contentTypes['saveOrderView'][0])
    {
        $returnType = '';
        $request = $this->saveOrderViewRequest($orders_save_order_view_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'saveOrderView'
     *
     * @param  \Linnworks\Orders\Model\OrdersSaveOrderViewRequest $orders_save_order_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['saveOrderView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function saveOrderViewRequest($orders_save_order_view_request, string $contentType = self::contentTypes['saveOrderView'][0])
    {

        // verify the required parameter 'orders_save_order_view_request' is set
        if ($orders_save_order_view_request === null || (is_array($orders_save_order_view_request) && count($orders_save_order_view_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_save_order_view_request when calling saveOrderView'
            );
        }


        $resourcePath = '/api/Orders/SaveOrderView';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_save_order_view_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_save_order_view_request));
            } else {
                $httpBody = $orders_save_order_view_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setAdditionalInfo
     *
     * SetAdditionalInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest $orders_set_additional_info_request orders_set_additional_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdditionalInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setAdditionalInfo($orders_set_additional_info_request, string $contentType = self::contentTypes['setAdditionalInfo'][0])
    {
        $this->setAdditionalInfoWithHttpInfo($orders_set_additional_info_request, $contentType);
    }

    /**
     * Operation setAdditionalInfoWithHttpInfo
     *
     * SetAdditionalInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest $orders_set_additional_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdditionalInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setAdditionalInfoWithHttpInfo($orders_set_additional_info_request, string $contentType = self::contentTypes['setAdditionalInfo'][0])
    {
        $request = $this->setAdditionalInfoRequest($orders_set_additional_info_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setAdditionalInfoAsync
     *
     * SetAdditionalInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest $orders_set_additional_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdditionalInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdditionalInfoAsync($orders_set_additional_info_request, string $contentType = self::contentTypes['setAdditionalInfo'][0])
    {
        return $this->setAdditionalInfoAsyncWithHttpInfo($orders_set_additional_info_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setAdditionalInfoAsyncWithHttpInfo
     *
     * SetAdditionalInfo
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest $orders_set_additional_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdditionalInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAdditionalInfoAsyncWithHttpInfo($orders_set_additional_info_request, string $contentType = self::contentTypes['setAdditionalInfo'][0])
    {
        $returnType = '';
        $request = $this->setAdditionalInfoRequest($orders_set_additional_info_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setAdditionalInfo'
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest $orders_set_additional_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAdditionalInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setAdditionalInfoRequest($orders_set_additional_info_request, string $contentType = self::contentTypes['setAdditionalInfo'][0])
    {

        // verify the required parameter 'orders_set_additional_info_request' is set
        if ($orders_set_additional_info_request === null || (is_array($orders_set_additional_info_request) && count($orders_set_additional_info_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orders_set_additional_info_request when calling setAdditionalInfo'
            );
        }


        $resourcePath = '/api/Orders/SetAdditionalInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orders_set_additional_info_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orders_set_additional_info_request));
            } else {
                $httpBody = $orders_set_additional_info_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setAvailableFolders
     *
     * SetAvailableFolders
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAvailableFoldersRequest $orders_set_available_folders_request orders_set_available_folders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAvailableFolders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Orders\Model\OrderFolder[]
     */
    public function setAvailableFolders($orders_set_available_folders_request, string $contentType = self::contentTypes['setAvailableFolders'][0])
    {
        list($response) = $this->setAvailableFoldersWithHttpInfo($orders_set_available_folders_request, $contentType);
        return $response;
    }

    /**
     * Operation setAvailableFoldersWithHttpInfo
     *
     * SetAvailableFolders
     *
     * @param  \Linnworks\Orders\Model\OrdersSetAvailableFoldersRequest $orders_set_available_folders_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setAvailableFolders'] to see the possible values for this operation
     *
     * @throws \Linnworks\Orders\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Orders\Model\OrderFolder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function setAvailableFoldersWithHttpInfo($orders_set_available_folders_request, string $contentType = self::contentTypes['setAvailableFolders'][0])
    {
        $request = $this->setAvailableFoldersRequest($orders_set_available_folders_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Orders\Model\OrderFolder[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Orders\Model\OrderFolder[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Orders\Model\OrderFolder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                