# # ChannelOrder

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**use_channel_tax** | **bool** | Validate if the tax should be overwritten on the order. | [optional]
**pk_order_id** | **string** | Used when IsNew is false to update the order | [optional] [readonly]
**automatically_link_by_sku** | **bool** | When the order is saved it will try and link by SKU after trying by channel sku mapping. | [optional]
**automatically_link_by_barcode** | **bool** | When the order is saved it will try and link by Barcode after trying by channel sku mapping. | [optional]
**automatically_link_by_asin** | **bool** | When the order is saved it will try and link by ASIN after trying by channel sku mapping. | [optional]
**site** | **string** | Used to determine the site of the order. | [optional]
**match_postal_service_tag** | **string** | Match postal service method by name | [optional]
**postal_service_name** | **string** | Postal service name used for saving new postal services | [optional]
**save_postal_service_if_not_exist** | **bool** | Determines wither or not to save postal service if it does not exist | [optional]
**match_payment_method_tag** | **string** | Match payment method by name | [optional]
**payment_method_name** | **string** | Payment method name used for saving new payment methods | [optional]
**save_payment_method_if_not_exist** | **bool** | Determines wither or not to save payment methods if it does not exist | [optional]
**mapping_source** | **string** | Overrides the mapping source for the channel for example if the Source is &#39;AMAZON FBA&#39; MappingSource can be used to override to &#39;AMAZON&#39; | [optional]
**order_state** | **string** | State the order should be saved e.g. hold, parked, none | [optional]
**order_fulfilment_type** | **string** | Defines type of fulfilment required for order | [optional]
**order_status_type** | **string** | The status of the order on the channel | [optional]
**order_status** | **string** | The raw status text of the order on the channel | [optional]
**payment_status** | **string** | Payment status of the order, eg Paid  If Unpaid ChannelOrderAdapter.Save() will ensure order is PARKED | [optional]
**order_items** | [**\Linnworks\Orders\Model\ChannelOrderItem[]**](ChannelOrderItem.md) | List of order items | [optional]
**locations** | [**\Linnworks\Orders\Model\ChannelOrderLocation[]**](ChannelOrderLocation.md) | The order location(s) on the channel | [optional]
**extended_properties** | [**\Linnworks\Orders\Model\ChannelOrderExtendedProperty[]**](ChannelOrderExtendedProperty.md) | List of extended properties for the order | [optional]
**notes** | [**\Linnworks\Orders\Model\ChannelOrderNote[]**](ChannelOrderNote.md) | List of notes for the order | [optional]
**source** | **string** | Source | [optional]
**sub_source** | **string** | SubSource | [optional]
**channel_buyer_name** | **string** | Channel buyer username / name | [optional]
**reference_number** | **string** | Reference number, should be the same as the one used for despatches | [optional]
**external_reference** | **string** | External Reference | [optional]
**secondary_reference_number** | **string** | Secondary reference number | [optional]
**currency** | **string** | Currency of the order, if value is null, empty or white space it will default to UNK | [optional]
**conversion_rate** | **float** | The currency conversion rate Sale/Base | [optional]
**received_date** | **\DateTime** | UTC received date/time of the order | [optional]
**updated_date** | **\DateTime** | UTC date/time the order was last updated at | [optional]
**dispatch_by** | **\DateTime** | UTC date/time the order should be despatched by | [optional]
**paid_on** | **\DateTime** | Date the order was paid for | [optional]
**postal_service_cost** | **float** | Postal service cost inclusive of tax after discount | [optional]
**postal_service_tax_rate** | **float** | Tax percent for the postal service cost, eg 20 | [optional]
**postal_service_discount** | **float** | Discount percent for the postal service cost, this will not calculate down the postal service cost | [optional]
**discount** | **float** | This represents the final discount applied to the order, as a value (not a percentage), after all item-level discounts are applied. It will be split evenly across all order items | [optional]
**items_refund** | **float** | The refund amount applied across all items | [optional]
**shipping_refund** | **float** | The amount refunded for shipping (if known) | [optional]
**total_refund** | **float** | The total refund amount applied to the order across all items, services and order-level refunds | [optional]
**line_refund_allocation** | **string** | The known refund allocation for the order lines | [optional]
**shipping_refund_allocation** | **string** | The known refund allocation for the order shipping | [optional]
**buyer_tax_number** | **string** | The tax number of the buyer | [optional]
**discount_type** | **string** | This represents how the discount will be split between items and postage. For an expsanation of each opiton, see the enum documentation | [optional]
**discount_tax_type** | **string** | This represents if the discount is applied before or after tax | [optional]
**billing_address** | [**\Linnworks\Orders\Model\ChannelAddress**](ChannelAddress.md) |  | [optional]
**delivery_address** | [**\Linnworks\Orders\Model\ChannelAddress**](ChannelAddress.md) |  | [optional]
**delivery_start_date** | **\DateTime** | Channel specified delivery start date (do not set where is not provided) | [optional]
**delivery_end_date** | **\DateTime** | Channel specified delivery end date (do not set where is not provided) | [optional]
**order_identifier_tags** | **string[]** | Order identifier tags | [optional]
**force_re_save_fulfilled_order** | **bool** | Bool to re-save order | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
