# Linnworks\Orders\OrdersApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addCoupon()**](OrdersApi.md#addCoupon) | **POST** /api/Orders/AddCoupon | AddCoupon |
| [**addExtendedProperties()**](OrdersApi.md#addExtendedProperties) | **POST** /api/Orders/AddExtendedProperties | AddExtendedProperties |
| [**addOrderItem()**](OrdersApi.md#addOrderItem) | **POST** /api/Orders/AddOrderItem | AddOrderItem |
| [**addOrderService()**](OrdersApi.md#addOrderService) | **POST** /api/Orders/AddOrderService | AddOrderService |
| [**assignOrderItemBatches()**](OrdersApi.md#assignOrderItemBatches) | **POST** /api/Orders/AssignOrderItemBatches | AssignOrderItemBatches |
| [**assignStockToOrder()**](OrdersApi.md#assignStockToOrder) | **POST** /api/Orders/AssignStockToOrder | AssignStockToOrder |
| [**assignToFolder()**](OrdersApi.md#assignToFolder) | **POST** /api/Orders/AssignToFolder | AssignToFolder |
| [**cancelOrder()**](OrdersApi.md#cancelOrder) | **POST** /api/Orders/CancelOrder | CancelOrder |
| [**changeOrderTag()**](OrdersApi.md#changeOrderTag) | **POST** /api/Orders/ChangeOrderTag | ChangeOrderTag |
| [**changeShippingMethod()**](OrdersApi.md#changeShippingMethod) | **POST** /api/Orders/ChangeShippingMethod | ChangeShippingMethod |
| [**changeStatus()**](OrdersApi.md#changeStatus) | **POST** /api/Orders/ChangeStatus | ChangeStatus |
| [**clearInvoicePrinted()**](OrdersApi.md#clearInvoicePrinted) | **POST** /api/Orders/ClearInvoicePrinted | ClearInvoicePrinted |
| [**clearPickListPrinted()**](OrdersApi.md#clearPickListPrinted) | **POST** /api/Orders/ClearPickListPrinted | ClearPickListPrinted |
| [**clearShippingLabelInfo()**](OrdersApi.md#clearShippingLabelInfo) | **POST** /api/Orders/ClearShippingLabelInfo | ClearShippingLabelInfo |
| [**completeOrder()**](OrdersApi.md#completeOrder) | **POST** /api/Orders/CompleteOrder | CompleteOrder |
| [**createNewItemAndLink()**](OrdersApi.md#createNewItemAndLink) | **POST** /api/Orders/CreateNewItemAndLink | CreateNewItemAndLink |
| [**createNewOrder()**](OrdersApi.md#createNewOrder) | **POST** /api/Orders/CreateNewOrder | CreateNewOrder |
| [**createOrders()**](OrdersApi.md#createOrders) | **POST** /api/Orders/CreateOrders | CreateOrders |
| [**createSerialisedValuesForOrderItems()**](OrdersApi.md#createSerialisedValuesForOrderItems) | **POST** /api/Orders/CreateSerialisedValuesForOrderItems | CreateSerialisedValuesForOrderItems |
| [**customerLookUp()**](OrdersApi.md#customerLookUp) | **GET** /api/Orders/CustomerLookUp | CustomerLookUp |
| [**deleteOrder()**](OrdersApi.md#deleteOrder) | **POST** /api/Orders/DeleteOrder | DeleteOrder |
| [**getAllAvailableOrderItemBatchsByOrderId()**](OrdersApi.md#getAllAvailableOrderItemBatchsByOrderId) | **POST** /api/Orders/GetAllAvailableOrderItemBatchsByOrderId | GetAllAvailableOrderItemBatchsByOrderId |
| [**getAllOpenOrders()**](OrdersApi.md#getAllOpenOrders) | **POST** /api/Orders/GetAllOpenOrders | GetAllOpenOrders |
| [**getAllOpenOrdersBetweenIndex()**](OrdersApi.md#getAllOpenOrdersBetweenIndex) | **POST** /api/Orders/GetAllOpenOrdersBetweenIndex | GetAllOpenOrdersBetweenIndex |
| [**getAssignedOrderItemBatches()**](OrdersApi.md#getAssignedOrderItemBatches) | **POST** /api/Orders/GetAssignedOrderItemBatches | GetAssignedOrderItemBatches |
| [**getAvailableFolders()**](OrdersApi.md#getAvailableFolders) | **GET** /api/Orders/GetAvailableFolders | GetAvailableFolders |
| [**getBatchPilots()**](OrdersApi.md#getBatchPilots) | **GET** /api/Orders/GetBatchPilots | GetBatchPilots |
| [**getCountries()**](OrdersApi.md#getCountries) | **GET** /api/Orders/GetCountries | GetCountries |
| [**getDefaultPaymentMethodIdForNewOrder()**](OrdersApi.md#getDefaultPaymentMethodIdForNewOrder) | **GET** /api/Orders/GetDefaultPaymentMethodIdForNewOrder | GetDefaultPaymentMethodIdForNewOrder |
| [**getDraftOrders()**](OrdersApi.md#getDraftOrders) | **GET** /api/Orders/GetDraftOrders | GetDraftOrders |
| [**getExtendedProperties()**](OrdersApi.md#getExtendedProperties) | **GET** /api/Orders/GetExtendedProperties | GetExtendedProperties |
| [**getExtendedPropertyNames()**](OrdersApi.md#getExtendedPropertyNames) | **GET** /api/Orders/GetExtendedPropertyNames | GetExtendedPropertyNames |
| [**getExtendedPropertyTypes()**](OrdersApi.md#getExtendedPropertyTypes) | **GET** /api/Orders/GetExtendedPropertyTypes | GetExtendedPropertyTypes |
| [**getLinkedItems()**](OrdersApi.md#getLinkedItems) | **GET** /api/Orders/GetLinkedItems | GetLinkedItems |
| [**getOpenOrderIdByOrderOrReferenceId()**](OrdersApi.md#getOpenOrderIdByOrderOrReferenceId) | **POST** /api/Orders/GetOpenOrderIdByOrderOrReferenceId | GetOpenOrderIdByOrderOrReferenceId |
| [**getOpenOrderItemsSuppliers()**](OrdersApi.md#getOpenOrderItemsSuppliers) | **GET** /api/Orders/GetOpenOrderItemsSuppliers | GetOpenOrderItemsSuppliers |
| [**getOpenOrders()**](OrdersApi.md#getOpenOrders) | **POST** /api/Orders/GetOpenOrders | GetOpenOrders |
| [**getOpenOrdersByItemBarcode()**](OrdersApi.md#getOpenOrdersByItemBarcode) | **POST** /api/Orders/GetOpenOrdersByItemBarcode | GetOpenOrdersByItemBarcode |
| [**getOrder()**](OrdersApi.md#getOrder) | **POST** /api/Orders/GetOrder | GetOrder |
| [**getOrderAuditTrail()**](OrdersApi.md#getOrderAuditTrail) | **GET** /api/Orders/GetOrderAuditTrail | GetOrderAuditTrail |
| [**getOrderAuditTrailsByIds()**](OrdersApi.md#getOrderAuditTrailsByIds) | **POST** /api/Orders/GetOrderAuditTrailsByIds | GetOrderAuditTrailsByIds |
| [**getOrderById()**](OrdersApi.md#getOrderById) | **GET** /api/Orders/GetOrderById | GetOrderById |
| [**getOrderDetailsByNumOrderId()**](OrdersApi.md#getOrderDetailsByNumOrderId) | **GET** /api/Orders/GetOrderDetailsByNumOrderId | GetOrderDetailsByNumOrderId |
| [**getOrderDetailsByReferenceId()**](OrdersApi.md#getOrderDetailsByReferenceId) | **GET** /api/Orders/GetOrderDetailsByReferenceId | GetOrderDetailsByReferenceId |
| [**getOrderItemBatchesByOrderIds()**](OrdersApi.md#getOrderItemBatchesByOrderIds) | **POST** /api/Orders/GetOrderItemBatchesByOrderIds | GetOrderItemBatchesByOrderIds |
| [**getOrderItemBatchsByOrderId()**](OrdersApi.md#getOrderItemBatchsByOrderId) | **POST** /api/Orders/GetOrderItemBatchsByOrderId | GetOrderItemBatchsByOrderId |
| [**getOrderItemComposition()**](OrdersApi.md#getOrderItemComposition) | **GET** /api/Orders/GetOrderItemComposition | GetOrderItemComposition |
| [**getOrderItemRowSerialValuesByOrderIds()**](OrdersApi.md#getOrderItemRowSerialValuesByOrderIds) | **POST** /api/Orders/GetOrderItemRowSerialValuesByOrderIds | GetOrderItemRowSerialValuesByOrderIds |
| [**getOrderItems()**](OrdersApi.md#getOrderItems) | **GET** /api/Orders/GetOrderItems | GetOrderItems |
| [**getOrderNoteTypes()**](OrdersApi.md#getOrderNoteTypes) | **GET** /api/Orders/GetOrderNoteTypes | GetOrderNoteTypes |
| [**getOrderNotes()**](OrdersApi.md#getOrderNotes) | **GET** /api/Orders/GetOrderNotes | GetOrderNotes |
| [**getOrderPackagingCalculation()**](OrdersApi.md#getOrderPackagingCalculation) | **POST** /api/Orders/GetOrderPackagingCalculation | GetOrderPackagingCalculation |
| [**getOrderPackagingSplit()**](OrdersApi.md#getOrderPackagingSplit) | **GET** /api/Orders/GetOrderPackagingSplit | GetOrderPackagingSplit |
| [**getOrderRelations()**](OrdersApi.md#getOrderRelations) | **GET** /api/Orders/GetOrderRelations | GetOrderRelations |
| [**getOrderView()**](OrdersApi.md#getOrderView) | **GET** /api/Orders/GetOrderView | GetOrderView |
| [**getOrderViews()**](OrdersApi.md#getOrderViews) | **GET** /api/Orders/GetOrderViews | GetOrderViews |
| [**getOrderXml()**](OrdersApi.md#getOrderXml) | **GET** /api/Orders/GetOrderXml | GetOrderXml |
| [**getOrderXmlJSTree()**](OrdersApi.md#getOrderXmlJSTree) | **GET** /api/Orders/GetOrderXmlJSTree | GetOrderXmlJSTree |
| [**getOrders()**](OrdersApi.md#getOrders) | **POST** /api/Orders/GetOrders | GetOrders |
| [**getOrdersById()**](OrdersApi.md#getOrdersById) | **POST** /api/Orders/GetOrdersById | GetOrdersById |
| [**getOrdersNotes()**](OrdersApi.md#getOrdersNotes) | **POST** /api/Orders/GetOrdersNotes | GetOrdersNotes |
| [**getOrdersRelations()**](OrdersApi.md#getOrdersRelations) | **POST** /api/Orders/GetOrdersRelations | GetOrdersRelations |
| [**getPackagingGroups()**](OrdersApi.md#getPackagingGroups) | **GET** /api/Orders/GetPackagingGroups | GetPackagingGroups |
| [**getPaymentMethods()**](OrdersApi.md#getPaymentMethods) | **GET** /api/Orders/GetPaymentMethods | GetPaymentMethods |
| [**getShippingMethods()**](OrdersApi.md#getShippingMethods) | **GET** /api/Orders/GetShippingMethods | GetShippingMethods |
| [**getUserLocationId()**](OrdersApi.md#getUserLocationId) | **GET** /api/Orders/GetUserLocationId | GetUserLocationId |
| [**lockOrder()**](OrdersApi.md#lockOrder) | **POST** /api/Orders/LockOrder | LockOrder |
| [**mergeOrders()**](OrdersApi.md#mergeOrders) | **POST** /api/Orders/MergeOrders | MergeOrders |
| [**moveToLocation()**](OrdersApi.md#moveToLocation) | **POST** /api/Orders/MoveToLocation | MoveToLocation |
| [**processFulfilmentCentreOrder()**](OrdersApi.md#processFulfilmentCentreOrder) | **POST** /api/Orders/ProcessFulfilmentCentreOrder | ProcessFulfilmentCentreOrder |
| [**processOrder()**](OrdersApi.md#processOrder) | **POST** /api/Orders/ProcessOrder | ProcessOrder |
| [**processOrderByOrderOrReferenceId()**](OrdersApi.md#processOrderByOrderOrReferenceId) | **POST** /api/Orders/ProcessOrderByOrderOrReferenceId | ProcessOrderByOrderOrReferenceId |
| [**processOrderRequiredBatchScans()**](OrdersApi.md#processOrderRequiredBatchScans) | **POST** /api/Orders/ProcessOrder_RequiredBatchScans | ProcessOrder_RequiredBatchScans |
| [**processOrdersInBatch()**](OrdersApi.md#processOrdersInBatch) | **POST** /api/Orders/ProcessOrdersInBatch | ProcessOrdersInBatch |
| [**recalculateSingleOrderPackaging()**](OrdersApi.md#recalculateSingleOrderPackaging) | **POST** /api/Orders/RecalculateSingleOrderPackaging | RecalculateSingleOrderPackaging |
| [**removeOrderItem()**](OrdersApi.md#removeOrderItem) | **POST** /api/Orders/RemoveOrderItem | RemoveOrderItem |
| [**runRulesEngine()**](OrdersApi.md#runRulesEngine) | **POST** /api/Orders/RunRulesEngine | RunRulesEngine |
| [**saveOrderView()**](OrdersApi.md#saveOrderView) | **POST** /api/Orders/SaveOrderView | SaveOrderView |
| [**setAdditionalInfo()**](OrdersApi.md#setAdditionalInfo) | **POST** /api/Orders/SetAdditionalInfo | SetAdditionalInfo |
| [**setAvailableFolders()**](OrdersApi.md#setAvailableFolders) | **POST** /api/Orders/SetAvailableFolders | SetAvailableFolders |
| [**setDefaultPaymentMethodIdForNewOrder()**](OrdersApi.md#setDefaultPaymentMethodIdForNewOrder) | **POST** /api/Orders/SetDefaultPaymentMethodIdForNewOrder | SetDefaultPaymentMethodIdForNewOrder |
| [**setExtendedProperties()**](OrdersApi.md#setExtendedProperties) | **POST** /api/Orders/SetExtendedProperties | SetExtendedProperties |
| [**setInvoicesPrinted()**](OrdersApi.md#setInvoicesPrinted) | **POST** /api/Orders/SetInvoicesPrinted | SetInvoicesPrinted |
| [**setLabelsPrinted()**](OrdersApi.md#setLabelsPrinted) | **POST** /api/Orders/SetLabelsPrinted | SetLabelsPrinted |
| [**setOrderCustomerInfo()**](OrdersApi.md#setOrderCustomerInfo) | **POST** /api/Orders/SetOrderCustomerInfo | SetOrderCustomerInfo |
| [**setOrderGeneralInfo()**](OrdersApi.md#setOrderGeneralInfo) | **POST** /api/Orders/SetOrderGeneralInfo | SetOrderGeneralInfo |
| [**setOrderNotes()**](OrdersApi.md#setOrderNotes) | **POST** /api/Orders/SetOrderNotes | SetOrderNotes |
| [**setOrderPackaging()**](OrdersApi.md#setOrderPackaging) | **POST** /api/Orders/SetOrderPackaging | SetOrderPackaging |
| [**setOrderPackagingSplit()**](OrdersApi.md#setOrderPackagingSplit) | **POST** /api/Orders/SetOrderPackagingSplit | SetOrderPackagingSplit |
| [**setOrderShippingInfo()**](OrdersApi.md#setOrderShippingInfo) | **POST** /api/Orders/SetOrderShippingInfo | SetOrderShippingInfo |
| [**setOrderSplitPackagingManualOverwrite()**](OrdersApi.md#setOrderSplitPackagingManualOverwrite) | **POST** /api/Orders/SetOrderSplitPackagingManualOverwrite | SetOrderSplitPackagingManualOverwrite |
| [**setOrderTotalsInfo()**](OrdersApi.md#setOrderTotalsInfo) | **POST** /api/Orders/SetOrderTotalsInfo | SetOrderTotalsInfo |
| [**setPaymentMethods()**](OrdersApi.md#setPaymentMethods) | **POST** /api/Orders/SetPaymentMethods | SetPaymentMethods |
| [**setPickListPrinted()**](OrdersApi.md#setPickListPrinted) | **POST** /api/Orders/SetPickListPrinted | SetPickListPrinted |
| [**splitOrder()**](OrdersApi.md#splitOrder) | **POST** /api/Orders/SplitOrder | SplitOrder |
| [**unassignToFolder()**](OrdersApi.md#unassignToFolder) | **POST** /api/Orders/UnassignToFolder | UnassignToFolder |
| [**updateAdditionalInfo()**](OrdersApi.md#updateAdditionalInfo) | **POST** /api/Orders/UpdateAdditionalInfo | UpdateAdditionalInfo |
| [**updateBillingAddress()**](OrdersApi.md#updateBillingAddress) | **POST** /api/Orders/UpdateBillingAddress | UpdateBillingAddress |
| [**updateLinkItem()**](OrdersApi.md#updateLinkItem) | **POST** /api/Orders/UpdateLinkItem | UpdateLinkItem |
| [**updateOrderItem()**](OrdersApi.md#updateOrderItem) | **POST** /api/Orders/UpdateOrderItem | UpdateOrderItem |
| [**validateCoupon()**](OrdersApi.md#validateCoupon) | **POST** /api/Orders/ValidateCoupon | ValidateCoupon |


## `addCoupon()`

```php
addCoupon($orders_add_coupon_request): \Linnworks\Orders\Model\UpdateOrderItemResult
```

AddCoupon

Add a coupon to a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_add_coupon_request = new \Linnworks\Orders\Model\OrdersAddCouponRequest(); // \Linnworks\Orders\Model\OrdersAddCouponRequest

try {
    $result = $apiInstance->addCoupon($orders_add_coupon_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->addCoupon: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_add_coupon_request** | [**\Linnworks\Orders\Model\OrdersAddCouponRequest**](../Model/OrdersAddCouponRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateOrderItemResult**](../Model/UpdateOrderItemResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addExtendedProperties()`

```php
addExtendedProperties($orders_add_extended_properties_request): \Linnworks\Orders\Model\AddExtendedPropertiesResponse
```

AddExtendedProperties

Adds extended properties to a Linnworks orders.  This will NOT update properties that match on property name / value <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_add_extended_properties_request = new \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest(); // \Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest

try {
    $result = $apiInstance->addExtendedProperties($orders_add_extended_properties_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->addExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_add_extended_properties_request** | [**\Linnworks\Orders\Model\OrdersAddExtendedPropertiesRequest**](../Model/OrdersAddExtendedPropertiesRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\AddExtendedPropertiesResponse**](../Model/AddExtendedPropertiesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addOrderItem()`

```php
addOrderItem($orders_add_order_item_request): \Linnworks\Orders\Model\UpdateOrderItemResult
```

AddOrderItem

Add an item to a specific order.  Line pricing is optional with the default values being  - PricePerUnit: Stock item retail price  - DiscountPercentage: 0  - TaxRatePercentage: Stock item tax rate.  - TaxInclusive: true <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_add_order_item_request = new \Linnworks\Orders\Model\OrdersAddOrderItemRequest(); // \Linnworks\Orders\Model\OrdersAddOrderItemRequest

try {
    $result = $apiInstance->addOrderItem($orders_add_order_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->addOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_add_order_item_request** | [**\Linnworks\Orders\Model\OrdersAddOrderItemRequest**](../Model/OrdersAddOrderItemRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateOrderItemResult**](../Model/UpdateOrderItemResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addOrderService()`

```php
addOrderService($request): \Linnworks\Orders\Model\UpdateOrderItemResult
```

AddOrderService

Add a service to an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\OrdersAddOrderServiceRequest(); // \Linnworks\Orders\Model\OrdersAddOrderServiceRequest

try {
    $result = $apiInstance->addOrderService($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->addOrderService: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\OrdersAddOrderServiceRequest**](../Model/OrdersAddOrderServiceRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Orders\Model\UpdateOrderItemResult**](../Model/UpdateOrderItemResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `assignOrderItemBatches()`

```php
assignOrderItemBatches($orders_assign_order_item_batches_request)
```

AssignOrderItemBatches

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_assign_order_item_batches_request = new \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest(); // \Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest

try {
    $apiInstance->assignOrderItemBatches($orders_assign_order_item_batches_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->assignOrderItemBatches: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_assign_order_item_batches_request** | [**\Linnworks\Orders\Model\OrdersAssignOrderItemBatchesRequest**](../Model/OrdersAssignOrderItemBatchesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `assignStockToOrder()`

```php
assignStockToOrder($orders_assign_stock_to_order_request): \Linnworks\Orders\Model\OrderItemBatch[]
```

AssignStockToOrder

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_assign_stock_to_order_request = new \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest(); // \Linnworks\Orders\Model\OrdersAssignStockToOrderRequest

try {
    $result = $apiInstance->assignStockToOrder($orders_assign_stock_to_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->assignStockToOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_assign_stock_to_order_request** | [**\Linnworks\Orders\Model\OrdersAssignStockToOrderRequest**](../Model/OrdersAssignStockToOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OrderItemBatch[]**](../Model/OrderItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `assignToFolder()`

```php
assignToFolder($orders_assign_to_folder_request): string[]
```

AssignToFolder

Assign a list of orders to a specific folder. This operation can not be executed on locked or parked orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_assign_to_folder_request = new \Linnworks\Orders\Model\OrdersAssignToFolderRequest(); // \Linnworks\Orders\Model\OrdersAssignToFolderRequest

try {
    $result = $apiInstance->assignToFolder($orders_assign_to_folder_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->assignToFolder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_assign_to_folder_request** | [**\Linnworks\Orders\Model\OrdersAssignToFolderRequest**](../Model/OrdersAssignToFolderRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `cancelOrder()`

```php
cancelOrder($orders_cancel_order_request): string
```

CancelOrder

Cancel a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_cancel_order_request = new \Linnworks\Orders\Model\OrdersCancelOrderRequest(); // \Linnworks\Orders\Model\OrdersCancelOrderRequest

try {
    $result = $apiInstance->cancelOrder($orders_cancel_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->cancelOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_cancel_order_request** | [**\Linnworks\Orders\Model\OrdersCancelOrderRequest**](../Model/OrdersCancelOrderRequest.md)|  | |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `changeOrderTag()`

```php
changeOrderTag($orders_change_order_tag_request): string[]
```

ChangeOrderTag

Change the tag for the specific order list. Tags can be 1-6 for custom tags, or 7 to initialize a 'parked' status on the order. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_change_order_tag_request = new \Linnworks\Orders\Model\OrdersChangeOrderTagRequest(); // \Linnworks\Orders\Model\OrdersChangeOrderTagRequest

try {
    $result = $apiInstance->changeOrderTag($orders_change_order_tag_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->changeOrderTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_change_order_tag_request** | [**\Linnworks\Orders\Model\OrdersChangeOrderTagRequest**](../Model/OrdersChangeOrderTagRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `changeShippingMethod()`

```php
changeShippingMethod($orders_change_shipping_method_request): string[]
```

ChangeShippingMethod

Change the shipping method to a list of orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_change_shipping_method_request = new \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest(); // \Linnworks\Orders\Model\OrdersChangeShippingMethodRequest

try {
    $result = $apiInstance->changeShippingMethod($orders_change_shipping_method_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->changeShippingMethod: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_change_shipping_method_request** | [**\Linnworks\Orders\Model\OrdersChangeShippingMethodRequest**](../Model/OrdersChangeShippingMethodRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `changeStatus()`

```php
changeStatus($orders_change_status_request): string[]
```

ChangeStatus

Change the status to a list of orders  0 = 'UNPAID'  1 = 'PAID'  2 = 'RETURN'  3 = 'PENDING'  4 = 'RESEND' <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_change_status_request = new \Linnworks\Orders\Model\OrdersChangeStatusRequest(); // \Linnworks\Orders\Model\OrdersChangeStatusRequest

try {
    $result = $apiInstance->changeStatus($orders_change_status_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->changeStatus: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_change_status_request** | [**\Linnworks\Orders\Model\OrdersChangeStatusRequest**](../Model/OrdersChangeStatusRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `clearInvoicePrinted()`

```php
clearInvoicePrinted($orders_clear_invoice_printed_request): string[]
```

ClearInvoicePrinted

Clear invoice printed flag for a list of orders. This operation can not be executed on locked or parked orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_clear_invoice_printed_request = new \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest(); // \Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest

try {
    $result = $apiInstance->clearInvoicePrinted($orders_clear_invoice_printed_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->clearInvoicePrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_clear_invoice_printed_request** | [**\Linnworks\Orders\Model\OrdersClearInvoicePrintedRequest**](../Model/OrdersClearInvoicePrintedRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `clearPickListPrinted()`

```php
clearPickListPrinted($orders_clear_pick_list_printed_request): string[]
```

ClearPickListPrinted

Clear invoice printed flag for a list of orders. This operation can not be executed on locked or parked orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_clear_pick_list_printed_request = new \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest(); // \Linnworks\Orders\Model\OrdersClearPickListPrintedRequest

try {
    $result = $apiInstance->clearPickListPrinted($orders_clear_pick_list_printed_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->clearPickListPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_clear_pick_list_printed_request** | [**\Linnworks\Orders\Model\OrdersClearPickListPrintedRequest**](../Model/OrdersClearPickListPrintedRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `clearShippingLabelInfo()`

```php
clearShippingLabelInfo($orders_clear_shipping_label_info_request): \Linnworks\Orders\Model\KeyValuePairGuidString[]
```

ClearShippingLabelInfo

Clear the shipping label info to a list of orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_clear_shipping_label_info_request = new \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest(); // \Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest

try {
    $result = $apiInstance->clearShippingLabelInfo($orders_clear_shipping_label_info_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->clearShippingLabelInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_clear_shipping_label_info_request** | [**\Linnworks\Orders\Model\OrdersClearShippingLabelInfoRequest**](../Model/OrdersClearShippingLabelInfoRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\KeyValuePairGuidString[]**](../Model/KeyValuePairGuidString.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `completeOrder()`

```php
completeOrder($orders_complete_order_request): string
```

CompleteOrder

Complete a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_complete_order_request = new \Linnworks\Orders\Model\OrdersCompleteOrderRequest(); // \Linnworks\Orders\Model\OrdersCompleteOrderRequest

try {
    $result = $apiInstance->completeOrder($orders_complete_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->completeOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_complete_order_request** | [**\Linnworks\Orders\Model\OrdersCompleteOrderRequest**](../Model/OrdersCompleteOrderRequest.md)|  | |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createNewItemAndLink()`

```php
createNewItemAndLink($orders_create_new_item_and_link_request): string
```

CreateNewItemAndLink

Create a new item and link it to a specific stock item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_create_new_item_and_link_request = new \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest(); // \Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest

try {
    $result = $apiInstance->createNewItemAndLink($orders_create_new_item_and_link_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->createNewItemAndLink: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_create_new_item_and_link_request** | [**\Linnworks\Orders\Model\OrdersCreateNewItemAndLinkRequest**](../Model/OrdersCreateNewItemAndLinkRequest.md)|  | |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createNewOrder()`

```php
createNewOrder($orders_create_new_order_request): \Linnworks\Orders\Model\OpenOrder
```

CreateNewOrder

Create an empty draft order. (Please see CreateOrders call) <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrders.CreateOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_create_new_order_request = new \Linnworks\Orders\Model\OrdersCreateNewOrderRequest(); // \Linnworks\Orders\Model\OrdersCreateNewOrderRequest

try {
    $result = $apiInstance->createNewOrder($orders_create_new_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->createNewOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_create_new_order_request** | [**\Linnworks\Orders\Model\OrdersCreateNewOrderRequest**](../Model/OrdersCreateNewOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OpenOrder**](../Model/OpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createOrders()`

```php
createOrders($orders_create_orders_request): string[]
```

CreateOrders

Creates new orders, once an order is paid it will be skipped on save. Returns list of pkOrderId's that were saved. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_create_orders_request = new \Linnworks\Orders\Model\OrdersCreateOrdersRequest(); // \Linnworks\Orders\Model\OrdersCreateOrdersRequest

try {
    $result = $apiInstance->createOrders($orders_create_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->createOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_create_orders_request** | [**\Linnworks\Orders\Model\OrdersCreateOrdersRequest**](../Model/OrdersCreateOrdersRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createSerialisedValuesForOrderItems()`

```php
createSerialisedValuesForOrderItems($request)
```

CreateSerialisedValuesForOrderItems

Create serial data for the given orderItemRowIds <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest(); // \Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest | Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data.

try {
    $apiInstance->createSerialisedValuesForOrderItems($request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->createSerialisedValuesForOrderItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\CreateSerialisedValuesForOrderItemsRequest**](../Model/CreateSerialisedValuesForOrderItemsRequest.md)| Request with list of OrderItemSerialModel as property. Each entry represents an OrderItemRowId and a list of collections of serial data. Seperated by correlation (quantity for this row)               Note there can be one collection of serial data for each physical item being shipped - e.g. an order item with quantity of 2 can have 2 collections of serial data.              Note that values assigned to each OrderItemRowId will overwrite any existing data. | [optional] |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerLookUp()`

```php
customerLookUp($field, $txt): \Linnworks\Orders\Model\CustomerAddress[]
```

CustomerLookUp

Get a list of possible addresses based on a search <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$field = 'field_example'; // string | Field to search by
$txt = 'txt_example'; // string | Text to find

try {
    $result = $apiInstance->customerLookUp($field, $txt);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->customerLookUp: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **field** | **string**| Field to search by | [optional] |
| **txt** | **string**| Text to find | [optional] |

### Return type

[**\Linnworks\Orders\Model\CustomerAddress[]**](../Model/CustomerAddress.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrder()`

```php
deleteOrder($orders_delete_order_request)
```

DeleteOrder

Delete a specific order <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrders.DeleteOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_delete_order_request = new \Linnworks\Orders\Model\OrdersDeleteOrderRequest(); // \Linnworks\Orders\Model\OrdersDeleteOrderRequest

try {
    $apiInstance->deleteOrder($orders_delete_order_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->deleteOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_delete_order_request** | [**\Linnworks\Orders\Model\OrdersDeleteOrderRequest**](../Model/OrdersDeleteOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllAvailableOrderItemBatchsByOrderId()`

```php
getAllAvailableOrderItemBatchsByOrderId($orders_get_all_available_order_item_batchs_by_order_id_request): \Linnworks\Orders\Model\StockItemBatch[]
```

GetAllAvailableOrderItemBatchsByOrderId

Get a list of available batchs for each order item for the specified order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_all_available_order_item_batchs_by_order_id_request = new \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest(); // \Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest

try {
    $result = $apiInstance->getAllAvailableOrderItemBatchsByOrderId($orders_get_all_available_order_item_batchs_by_order_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAllAvailableOrderItemBatchsByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_all_available_order_item_batchs_by_order_id_request** | [**\Linnworks\Orders\Model\OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest**](../Model/OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\StockItemBatch[]**](../Model/StockItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllOpenOrders()`

```php
getAllOpenOrders($orders_get_all_open_orders_request): string[]
```

GetAllOpenOrders

Get the list of Id's of all open orders (without pagination) <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_all_open_orders_request = new \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest(); // \Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest

try {
    $result = $apiInstance->getAllOpenOrders($orders_get_all_open_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAllOpenOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_all_open_orders_request** | [**\Linnworks\Orders\Model\OrdersGetAllOpenOrdersRequest**](../Model/OrdersGetAllOpenOrdersRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllOpenOrdersBetweenIndex()`

```php
getAllOpenOrdersBetweenIndex($orders_get_all_open_orders_between_index_request): string[]
```

GetAllOpenOrdersBetweenIndex

Get the list of open order id's between two index with the current filters and sorting <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_all_open_orders_between_index_request = new \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest(); // \Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest

try {
    $result = $apiInstance->getAllOpenOrdersBetweenIndex($orders_get_all_open_orders_between_index_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAllOpenOrdersBetweenIndex: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_all_open_orders_between_index_request** | [**\Linnworks\Orders\Model\OrdersGetAllOpenOrdersBetweenIndexRequest**](../Model/OrdersGetAllOpenOrdersBetweenIndexRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAssignedOrderItemBatches()`

```php
getAssignedOrderItemBatches($orders_get_assigned_order_item_batches_request): \Linnworks\Orders\Model\OrderItemBatch[]
```

GetAssignedOrderItemBatches

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_assigned_order_item_batches_request = new \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest(); // \Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest

try {
    $result = $apiInstance->getAssignedOrderItemBatches($orders_get_assigned_order_item_batches_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAssignedOrderItemBatches: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_assigned_order_item_batches_request** | [**\Linnworks\Orders\Model\OrdersGetAssignedOrderItemBatchesRequest**](../Model/OrdersGetAssignedOrderItemBatchesRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OrderItemBatch[]**](../Model/OrderItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAvailableFolders()`

```php
getAvailableFolders(): \Linnworks\Orders\Model\OrderFolder[]
```

GetAvailableFolders

Get list of available folders that orders can be assigned to <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getAvailableFolders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAvailableFolders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\OrderFolder[]**](../Model/OrderFolder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBatchPilots()`

```php
getBatchPilots(): \Linnworks\Orders\Model\KeyValuePairGuidString[]
```

GetBatchPilots

Get the list of available batch pilots <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getBatchPilots();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getBatchPilots: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\KeyValuePairGuidString[]**](../Model/KeyValuePairGuidString.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCountries()`

```php
getCountries(): \Linnworks\Orders\Model\OrderCountry[]
```

GetCountries

Get list of available countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCountries();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\OrderCountry[]**](../Model/OrderCountry.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getDefaultPaymentMethodIdForNewOrder()`

```php
getDefaultPaymentMethodIdForNewOrder(): string
```

GetDefaultPaymentMethodIdForNewOrder

Get the default payment method for new direct orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getDefaultPaymentMethodIdForNewOrder();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getDefaultPaymentMethodIdForNewOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getDraftOrders()`

```php
getDraftOrders(): string[]
```

GetDraftOrders

Get list of draft orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getDraftOrders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getDraftOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getExtendedProperties()`

```php
getExtendedProperties($order_id): \Linnworks\Orders\Model\ExtendedProperty[]
```

GetExtendedProperties

Get the extended properties for a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getExtendedProperties($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\ExtendedProperty[]**](../Model/ExtendedProperty.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getExtendedPropertyNames()`

```php
getExtendedPropertyNames(): string[]
```

GetExtendedPropertyNames

Get the available types of extended properties <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getExtendedPropertyNames();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getExtendedPropertyNames: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getExtendedPropertyTypes()`

```php
getExtendedPropertyTypes(): string[]
```

GetExtendedPropertyTypes

Get the available types of extended properties <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getExtendedPropertyTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getExtendedPropertyTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLinkedItems()`

```php
getLinkedItems($item_id): \Linnworks\Orders\Model\LinkedItem[]
```

GetLinkedItems

Get linked items to another one <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_id = 'item_id_example'; // string | Item id (pkStockItemId)

try {
    $result = $apiInstance->getLinkedItems($item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getLinkedItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_id** | **string**| Item id (pkStockItemId) | [optional] |

### Return type

[**\Linnworks\Orders\Model\LinkedItem[]**](../Model/LinkedItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrderIdByOrderOrReferenceId()`

```php
getOpenOrderIdByOrderOrReferenceId($orders_get_open_order_id_by_order_or_reference_id_request): string
```

GetOpenOrderIdByOrderOrReferenceId

Get an order by reference number or order number <b>Permissions Required: </b> GlobalPermissions.OrderBookNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_open_order_id_by_order_or_reference_id_request = new \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest(); // \Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest

try {
    $result = $apiInstance->getOpenOrderIdByOrderOrReferenceId($orders_get_open_order_id_by_order_or_reference_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOpenOrderIdByOrderOrReferenceId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_open_order_id_by_order_or_reference_id_request** | [**\Linnworks\Orders\Model\OrdersGetOpenOrderIdByOrderOrReferenceIdRequest**](../Model/OrdersGetOpenOrderIdByOrderOrReferenceIdRequest.md)|  | |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrderItemsSuppliers()`

```php
getOpenOrderItemsSuppliers($order_id): \Linnworks\Orders\Model\KeyValuePairGuidGuid[]
```

GetOpenOrderItemsSuppliers

Get items suppliers list for a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOpenOrderItemsSuppliers($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOpenOrderItemsSuppliers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\KeyValuePairGuidGuid[]**](../Model/KeyValuePairGuidGuid.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrders()`

```php
getOpenOrders($orders_get_open_orders_request): \Linnworks\Orders\Model\GenericPagedResultOpenOrder
```

GetOpenOrders

Get a paged list of open orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_open_orders_request = new \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest(); // \Linnworks\Orders\Model\OrdersGetOpenOrdersRequest

try {
    $result = $apiInstance->getOpenOrders($orders_get_open_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOpenOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_open_orders_request** | [**\Linnworks\Orders\Model\OrdersGetOpenOrdersRequest**](../Model/OrdersGetOpenOrdersRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\GenericPagedResultOpenOrder**](../Model/GenericPagedResultOpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrdersByItemBarcode()`

```php
getOpenOrdersByItemBarcode($orders_get_open_orders_by_item_barcode_request): \Linnworks\Orders\Model\KeyValuePairListOrderSummaryString
```

GetOpenOrdersByItemBarcode

Get orders by order item barcode <b>Permissions Required: </b> GlobalPermissions.OrderBookNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_open_orders_by_item_barcode_request = new \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest(); // \Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest

try {
    $result = $apiInstance->getOpenOrdersByItemBarcode($orders_get_open_orders_by_item_barcode_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOpenOrdersByItemBarcode: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_open_orders_by_item_barcode_request** | [**\Linnworks\Orders\Model\OrdersGetOpenOrdersByItemBarcodeRequest**](../Model/OrdersGetOpenOrdersByItemBarcodeRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\KeyValuePairListOrderSummaryString**](../Model/KeyValuePairListOrderSummaryString.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrder()`

```php
getOrder($orders_get_order_request): \Linnworks\Orders\Model\OpenOrder
```

GetOrder

Get a specific open order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_order_request = new \Linnworks\Orders\Model\OrdersGetOrderRequest(); // \Linnworks\Orders\Model\OrdersGetOrderRequest

try {
    $result = $apiInstance->getOrder($orders_get_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_order_request** | [**\Linnworks\Orders\Model\OrdersGetOrderRequest**](../Model/OrdersGetOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OpenOrder**](../Model/OpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderAuditTrail()`

```php
getOrderAuditTrail($order_id): \Linnworks\Orders\Model\OrderAuditTrail[]
```

GetOrderAuditTrail

Get order audit trail <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOrderAuditTrail($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderAuditTrail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderAuditTrail[]**](../Model/OrderAuditTrail.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderAuditTrailsByIds()`

```php
getOrderAuditTrailsByIds($request): \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse
```

GetOrderAuditTrailsByIds

Returns a list of audit trails for the provided order ids <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest(); // \Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest

try {
    $result = $apiInstance->getOrderAuditTrailsByIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderAuditTrailsByIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsRequest**](../Model/GetOrderAuditTrailsByIdsRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Orders\Model\GetOrderAuditTrailsByIdsResponse**](../Model/GetOrderAuditTrailsByIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderById()`

```php
getOrderById($pk_order_id): \Linnworks\Orders\Model\OrderDetails
```

GetOrderById

Retrieves the order detail for a unique system order id identifier (pkOrderId)  For working with open orders recommended to use OpenOrders/GetOpenOrdersDetails <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_order_id = 'pk_order_id_example'; // string | pkOrderId

try {
    $result = $apiInstance->getOrderById($pk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_order_id** | **string**| pkOrderId | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderDetails**](../Model/OrderDetails.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderDetailsByNumOrderId()`

```php
getOrderDetailsByNumOrderId($order_id): \Linnworks\Orders\Model\OrderDetails
```

GetOrderDetailsByNumOrderId

Retrieves the order detail for a given order numeric id. If not found  empty class is returned.    For working with open orders recommended to use OpenOrders/GetOpenOrdersDetails <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | Order Id (numeric)

try {
    $result = $apiInstance->getOrderDetailsByNumOrderId($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderDetailsByNumOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| Order Id (numeric) | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderDetails**](../Model/OrderDetails.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderDetailsByReferenceId()`

```php
getOrderDetailsByReferenceId($reference_id): \Linnworks\Orders\Model\OrderDetails[]
```

GetOrderDetailsByReferenceId

Retrieves a list of order details for a given order reference number, returns maximum of 50 orders.  For eBay orders, if Sellling Manager Pro sales number is available the order can be retrived by this number <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$reference_id = 'reference_id_example'; // string | Order reference id, or SecondaryReferenceNumber

try {
    $result = $apiInstance->getOrderDetailsByReferenceId($reference_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderDetailsByReferenceId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **reference_id** | **string**| Order reference id, or SecondaryReferenceNumber | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderDetails[]**](../Model/OrderDetails.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItemBatchesByOrderIds()`

```php
getOrderItemBatchesByOrderIds($request): \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse
```

GetOrderItemBatchesByOrderIds

Get a list of order item batch information for the specified orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest(); // \Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest | Made up of list of pkOrderIds

try {
    $result = $apiInstance->getOrderItemBatchesByOrderIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderItemBatchesByOrderIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsRequest**](../Model/GetOrderItemBatchesByOrderIdsRequest.md)| Made up of list of pkOrderIds | [optional] |

### Return type

[**\Linnworks\Orders\Model\GetOrderItemBatchesByOrderIdsResponse**](../Model/GetOrderItemBatchesByOrderIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItemBatchsByOrderId()`

```php
getOrderItemBatchsByOrderId($parameters): \Linnworks\Orders\Model\OrderItemBatch[]
```

GetOrderItemBatchsByOrderId

Get a list of order item batch information for the specified order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$parameters = new \Linnworks\Orders\Model\OrderItemBatchInfo(); // \Linnworks\Orders\Model\OrderItemBatchInfo | Made up of pkOrderId

try {
    $result = $apiInstance->getOrderItemBatchsByOrderId($parameters);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderItemBatchsByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **parameters** | [**\Linnworks\Orders\Model\OrderItemBatchInfo**](../Model/OrderItemBatchInfo.md)| Made up of pkOrderId | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderItemBatch[]**](../Model/OrderItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItemComposition()`

```php
getOrderItemComposition($order_id, $stock_item_id, $fulfilment_center): \Linnworks\Orders\Model\OrderItem
```

GetOrderItemComposition

Get the detail (composition) of a specific order item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id
$stock_item_id = 'stock_item_id_example'; // string | Stock item id
$fulfilment_center = 'fulfilment_center_example'; // string | Location to get the order item composition for

try {
    $result = $apiInstance->getOrderItemComposition($order_id, $stock_item_id, $fulfilment_center);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderItemComposition: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |
| **stock_item_id** | **string**| Stock item id | [optional] |
| **fulfilment_center** | **string**| Location to get the order item composition for | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderItem**](../Model/OrderItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItemRowSerialValuesByOrderIds()`

```php
getOrderItemRowSerialValuesByOrderIds($request): \Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse
```

GetOrderItemRowSerialValuesByOrderIds

Get order item row serial information by requested order ids. Maximum requested orderIds is 25. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest(); // \Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest | Request with collection of order ids as properties

try {
    $result = $apiInstance->getOrderItemRowSerialValuesByOrderIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderItemRowSerialValuesByOrderIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\GetOrderItemRowSerialValuesByOrderIdsRequest**](../Model/GetOrderItemRowSerialValuesByOrderIdsRequest.md)| Request with collection of order ids as properties | [optional] |

### Return type

[**\Linnworks\Orders\Model\GetSerialisedValuesForOrdersResponse**](../Model/GetSerialisedValuesForOrdersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItems()`

```php
getOrderItems($order_id, $fulfilment_center): \Linnworks\Orders\Model\OrderItem[]
```

GetOrderItems

Get order items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id
$fulfilment_center = 'fulfilment_center_example'; // string | Current fulfilment center

try {
    $result = $apiInstance->getOrderItems($order_id, $fulfilment_center);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |
| **fulfilment_center** | **string**| Current fulfilment center | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderItem[]**](../Model/OrderItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderNoteTypes()`

```php
getOrderNoteTypes(): \Linnworks\Orders\Model\OrderNoteType[]
```

GetOrderNoteTypes

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getOrderNoteTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderNoteTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\OrderNoteType[]**](../Model/OrderNoteType.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderNotes()`

```php
getOrderNotes($order_id): \Linnworks\Orders\Model\OrderNote[]
```

GetOrderNotes

Get the order notes <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOrderNotes($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderNote[]**](../Model/OrderNote.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderPackagingCalculation()`

```php
getOrderPackagingCalculation($request): \Linnworks\Orders\Model\CalcOrderHeader[]
```

GetOrderPackagingCalculation

Retrieves order packaging, weight and dimension information with split packaging. The method can perform ad hoc recalculation and saving of any changes. <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest(); // \Linnworks\Orders\Model\GetOrderPackagingCalculationRequest | Orders to get packaging calculations for

try {
    $result = $apiInstance->getOrderPackagingCalculation($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderPackagingCalculation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Orders\Model\GetOrderPackagingCalculationRequest**](../Model/GetOrderPackagingCalculationRequest.md)| Orders to get packaging calculations for | [optional] |

### Return type

[**\Linnworks\Orders\Model\CalcOrderHeader[]**](../Model/CalcOrderHeader.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderPackagingSplit()`

```php
getOrderPackagingSplit($order_id, $open_orders_only): \Linnworks\Orders\Model\OrderPackagingSplit[]
```

GetOrderPackagingSplit

Get a possible order split by packaging <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id
$open_orders_only = True; // bool | Whether to search open orders only, or all orders

try {
    $result = $apiInstance->getOrderPackagingSplit($order_id, $open_orders_only);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderPackagingSplit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |
| **open_orders_only** | **bool**| Whether to search open orders only, or all orders | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderPackagingSplit[]**](../Model/OrderPackagingSplit.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderRelations()`

```php
getOrderRelations($order_id): \Linnworks\Orders\Model\OrderRelation[]
```

GetOrderRelations

Get order relations <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOrderRelations($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderRelations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderRelation[]**](../Model/OrderRelation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderView()`

```php
getOrderView($pk_view_id, $mark_as_latest_viewed): \Linnworks\Orders\Model\UserOrderView
```

GetOrderView

Get a specific open order view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_view_id = 56; // int | View id
$mark_as_latest_viewed = True; // bool | Mark it in the database as latest viewer

try {
    $result = $apiInstance->getOrderView($pk_view_id, $mark_as_latest_viewed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderView: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_view_id** | **int**| View id | [optional] |
| **mark_as_latest_viewed** | **bool**| Mark it in the database as latest viewer | [optional] |

### Return type

[**\Linnworks\Orders\Model\UserOrderView**](../Model/UserOrderView.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderViews()`

```php
getOrderViews(): \Linnworks\Orders\Model\UserOrderView[]
```

GetOrderViews

Get open order views <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getOrderViews();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderViews: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\UserOrderView[]**](../Model/UserOrderView.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderXml()`

```php
getOrderXml($order_id): \Linnworks\Orders\Model\OrderXML[]
```

GetOrderXml

Get order XML received from channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOrderXml($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderXml: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

[**\Linnworks\Orders\Model\OrderXML[]**](../Model/OrderXML.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderXmlJSTree()`

```php
getOrderXmlJSTree($order_id): string
```

GetOrderXmlJSTree

Get order XML received from channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string | Order id

try {
    $result = $apiInstance->getOrderXmlJSTree($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrderXmlJSTree: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**| Order id | [optional] |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrders()`

```php
getOrders($orders_get_orders_request): \Linnworks\Orders\Model\OpenOrder[]
```

GetOrders

Get list of open orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_orders_request = new \Linnworks\Orders\Model\OrdersGetOrdersRequest(); // \Linnworks\Orders\Model\OrdersGetOrdersRequest

try {
    $result = $apiInstance->getOrders($orders_get_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_orders_request** | [**\Linnworks\Orders\Model\OrdersGetOrdersRequest**](../Model/OrdersGetOrdersRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OpenOrder[]**](../Model/OpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrdersById()`

```php
getOrdersById($orders_get_orders_by_id_request): \Linnworks\Orders\Model\OrderDetails[]
```

GetOrdersById

Retrieves the order detail list for a list of order id identifiers (pkOrderId)  For working with open orders recommended to use OpenOrders/GetOpenOrdersDetails <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_orders_by_id_request = new \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest(); // \Linnworks\Orders\Model\OrdersGetOrdersByIdRequest

try {
    $result = $apiInstance->getOrdersById($orders_get_orders_by_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrdersById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_orders_by_id_request** | [**\Linnworks\Orders\Model\OrdersGetOrdersByIdRequest**](../Model/OrdersGetOrdersByIdRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OrderDetails[]**](../Model/OrderDetails.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrdersNotes()`

```php
getOrdersNotes($orders_get_orders_notes_request): array<string,\Linnworks\Orders\Model\OrderNote[]>
```

GetOrdersNotes

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_orders_notes_request = new \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest(); // \Linnworks\Orders\Model\OrdersGetOrdersNotesRequest

try {
    $result = $apiInstance->getOrdersNotes($orders_get_orders_notes_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrdersNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_orders_notes_request** | [**\Linnworks\Orders\Model\OrdersGetOrdersNotesRequest**](../Model/OrdersGetOrdersNotesRequest.md)|  | |

### Return type

**array<string,\Linnworks\Orders\Model\OrderNote[]>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrdersRelations()`

```php
getOrdersRelations($orders_get_orders_relations_request): array<string,\Linnworks\Orders\Model\OrderRelation[]>
```

GetOrdersRelations

Get order relations for a list of orders. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_get_orders_relations_request = new \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest(); // \Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest

try {
    $result = $apiInstance->getOrdersRelations($orders_get_orders_relations_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getOrdersRelations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_get_orders_relations_request** | [**\Linnworks\Orders\Model\OrdersGetOrdersRelationsRequest**](../Model/OrdersGetOrdersRelationsRequest.md)|  | |

### Return type

**array<string,\Linnworks\Orders\Model\OrderRelation[]>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPackagingGroups()`

```php
getPackagingGroups(): \Linnworks\Orders\Model\PackageGroup[]
```

GetPackagingGroups

Get available packaging groups <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getPackagingGroups();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getPackagingGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\PackageGroup[]**](../Model/PackageGroup.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPaymentMethods()`

```php
getPaymentMethods(): \Linnworks\Orders\Model\PaymentMethod[]
```

GetPaymentMethods

Get the available payment methods <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getPaymentMethods();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getPaymentMethods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\PaymentMethod[]**](../Model/PaymentMethod.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getShippingMethods()`

```php
getShippingMethods(): \Linnworks\Orders\Model\ShippingMethod[]
```

GetShippingMethods

Get available shipping methods <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getShippingMethods();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getShippingMethods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Orders\Model\ShippingMethod[]**](../Model/ShippingMethod.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getUserLocationId()`

```php
getUserLocationId(): string
```

GetUserLocationId

Get the user location from settings <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getUserLocationId();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getUserLocationId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `lockOrder()`

```php
lockOrder($orders_lock_order_request)
```

LockOrder

Lock a list of orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_lock_order_request = new \Linnworks\Orders\Model\OrdersLockOrderRequest(); // \Linnworks\Orders\Model\OrdersLockOrderRequest

try {
    $apiInstance->lockOrder($orders_lock_order_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->lockOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_lock_order_request** | [**\Linnworks\Orders\Model\OrdersLockOrderRequest**](../Model/OrdersLockOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mergeOrders()`

```php
mergeOrders($orders_merge_orders_request): \Linnworks\Orders\Model\OpenOrder
```

MergeOrders

Merge a list of orders into a new one <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrders.MergeOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_merge_orders_request = new \Linnworks\Orders\Model\OrdersMergeOrdersRequest(); // \Linnworks\Orders\Model\OrdersMergeOrdersRequest

try {
    $result = $apiInstance->mergeOrders($orders_merge_orders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->mergeOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_merge_orders_request** | [**\Linnworks\Orders\Model\OrdersMergeOrdersRequest**](../Model/OrdersMergeOrdersRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OpenOrder**](../Model/OpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `moveToLocation()`

```php
moveToLocation($orders_move_to_location_request): \Linnworks\Orders\Model\MoveToLocationResult
```

MoveToLocation

Move a list of orders to a specific location <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_move_to_location_request = new \Linnworks\Orders\Model\OrdersMoveToLocationRequest(); // \Linnworks\Orders\Model\OrdersMoveToLocationRequest

try {
    $result = $apiInstance->moveToLocation($orders_move_to_location_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->moveToLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_move_to_location_request** | [**\Linnworks\Orders\Model\OrdersMoveToLocationRequest**](../Model/OrdersMoveToLocationRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\MoveToLocationResult**](../Model/MoveToLocationResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `processFulfilmentCentreOrder()`

```php
processFulfilmentCentreOrder($orders_process_fulfilment_centre_order_request): \Linnworks\Orders\Model\ProcessOrderResult
```

ProcessFulfilmentCentreOrder

Process Orders associated with a Fulfilment Centre <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_process_fulfilment_centre_order_request = new \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest(); // \Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest

try {
    $result = $apiInstance->processFulfilmentCentreOrder($orders_process_fulfilment_centre_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->processFulfilmentCentreOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_process_fulfilment_centre_order_request** | [**\Linnworks\Orders\Model\OrdersProcessFulfilmentCentreOrderRequest**](../Model/OrdersProcessFulfilmentCentreOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\ProcessOrderResult**](../Model/ProcessOrderResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `processOrder()`

```php
processOrder($orders_process_order_request): \Linnworks\Orders\Model\ProcessOrderResult
```

ProcessOrder

Process a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_process_order_request = new \Linnworks\Orders\Model\OrdersProcessOrderRequest(); // \Linnworks\Orders\Model\OrdersProcessOrderRequest

try {
    $result = $apiInstance->processOrder($orders_process_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->processOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_process_order_request** | [**\Linnworks\Orders\Model\OrdersProcessOrderRequest**](../Model/OrdersProcessOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\ProcessOrderResult**](../Model/ProcessOrderResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `processOrderByOrderOrReferenceId()`

```php
processOrderByOrderOrReferenceId($orders_process_order_by_order_or_reference_id_request): \Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse
```

ProcessOrderByOrderOrReferenceId

<b>Permissions Required: </b> GlobalPermissions.OrderBook.DespatchConsoleNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_process_order_by_order_or_reference_id_request = new \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest(); // \Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest

try {
    $result = $apiInstance->processOrderByOrderOrReferenceId($orders_process_order_by_order_or_reference_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->processOrderByOrderOrReferenceId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_process_order_by_order_or_reference_id_request** | [**\Linnworks\Orders\Model\OrdersProcessOrderByOrderOrReferenceIdRequest**](../Model/OrdersProcessOrderByOrderOrReferenceIdRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\ProcessOrderByOrderIdOrReferenceResponse**](../Model/ProcessOrderByOrderIdOrReferenceResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `processOrderRequiredBatchScans()`

```php
processOrderRequiredBatchScans($orders_process_order_required_batch_scans_request)
```

ProcessOrder_RequiredBatchScans

Update the order with the batch numbers scanned during process order (i.e. those items with dbo.StockItem.BatchNumberScanRequired set)  batches must be provided for all items in the order which require batch number scanning (including composite children)  Overwrites any existing batch assignment for the required items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_process_order_required_batch_scans_request = new \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest(); // \Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest

try {
    $apiInstance->processOrderRequiredBatchScans($orders_process_order_required_batch_scans_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->processOrderRequiredBatchScans: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_process_order_required_batch_scans_request** | [**\Linnworks\Orders\Model\OrdersProcessOrderRequiredBatchScansRequest**](../Model/OrdersProcessOrderRequiredBatchScansRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `processOrdersInBatch()`

```php
processOrdersInBatch($orders_process_orders_in_batch_request): \Linnworks\Orders\Model\ProcessOrderResult[]
```

ProcessOrdersInBatch

Process a list of orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_process_orders_in_batch_request = new \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest(); // \Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest

try {
    $result = $apiInstance->processOrdersInBatch($orders_process_orders_in_batch_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->processOrdersInBatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_process_orders_in_batch_request** | [**\Linnworks\Orders\Model\OrdersProcessOrdersInBatchRequest**](../Model/OrdersProcessOrdersInBatchRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\ProcessOrderResult[]**](../Model/ProcessOrderResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `recalculateSingleOrderPackaging()`

```php
recalculateSingleOrderPackaging($orders_recalculate_single_order_packaging_request): \Linnworks\Orders\Model\CalcOrderHeader
```

RecalculateSingleOrderPackaging

Designed to recalculate order packaging totals based on the object provided <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_recalculate_single_order_packaging_request = new \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest(); // \Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest

try {
    $result = $apiInstance->recalculateSingleOrderPackaging($orders_recalculate_single_order_packaging_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->recalculateSingleOrderPackaging: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_recalculate_single_order_packaging_request** | [**\Linnworks\Orders\Model\OrdersRecalculateSingleOrderPackagingRequest**](../Model/OrdersRecalculateSingleOrderPackagingRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\CalcOrderHeader**](../Model/CalcOrderHeader.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `removeOrderItem()`

```php
removeOrderItem($orders_remove_order_item_request): \Linnworks\Orders\Model\UpdateOrderItemResult
```

RemoveOrderItem

Remove item from an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_remove_order_item_request = new \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest(); // \Linnworks\Orders\Model\OrdersRemoveOrderItemRequest

try {
    $result = $apiInstance->removeOrderItem($orders_remove_order_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->removeOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_remove_order_item_request** | [**\Linnworks\Orders\Model\OrdersRemoveOrderItemRequest**](../Model/OrdersRemoveOrderItemRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateOrderItemResult**](../Model/UpdateOrderItemResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `runRulesEngine()`

```php
runRulesEngine($orders_run_rules_engine_request): string[]
```

RunRulesEngine

Run Rules Engine on Open Orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_run_rules_engine_request = new \Linnworks\Orders\Model\OrdersRunRulesEngineRequest(); // \Linnworks\Orders\Model\OrdersRunRulesEngineRequest

try {
    $result = $apiInstance->runRulesEngine($orders_run_rules_engine_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->runRulesEngine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_run_rules_engine_request** | [**\Linnworks\Orders\Model\OrdersRunRulesEngineRequest**](../Model/OrdersRunRulesEngineRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saveOrderView()`

```php
saveOrderView($orders_save_order_view_request)
```

SaveOrderView

Update a open order view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_save_order_view_request = new \Linnworks\Orders\Model\OrdersSaveOrderViewRequest(); // \Linnworks\Orders\Model\OrdersSaveOrderViewRequest

try {
    $apiInstance->saveOrderView($orders_save_order_view_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->saveOrderView: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_save_order_view_request** | [**\Linnworks\Orders\Model\OrdersSaveOrderViewRequest**](../Model/OrdersSaveOrderViewRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setAdditionalInfo()`

```php
setAdditionalInfo($orders_set_additional_info_request)
```

SetAdditionalInfo

Overwrites the existing order item additional info <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_additional_info_request = new \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest(); // \Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest

try {
    $apiInstance->setAdditionalInfo($orders_set_additional_info_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setAdditionalInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_additional_info_request** | [**\Linnworks\Orders\Model\OrdersSetAdditionalInfoRequest**](../Model/OrdersSetAdditionalInfoRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setAvailableFolders()`

```php
setAvailableFolders($orders_set_available_folders_request): \Linnworks\Orders\Model\OrderFolder[]
```

SetAvailableFolders

Set the list of available folders that orders can be assigned to <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_available_folders_request = new \Linnworks\Orders\Model\OrdersSetAvailableFoldersRequest(); // \Linnworks\Orders\Model\OrdersSetAvailableFoldersRequest

try {
    $result = $apiInstance->setAvailableFolders($orders_set_available_folders_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setAvailableFolders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_available_folders_request** | [**\Linnworks\Orders\Model\OrdersSetAvailableFoldersRequest**](../Model/OrdersSetAvailableFoldersRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OrderFolder[]**](../Model/OrderFolder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setDefaultPaymentMethodIdForNewOrder()`

```php
setDefaultPaymentMethodIdForNewOrder($orders_set_default_payment_method_id_for_new_order_request)
```

SetDefaultPaymentMethodIdForNewOrder

Set the default payment method for new direct orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_default_payment_method_id_for_new_order_request = new \Linnworks\Orders\Model\OrdersSetDefaultPaymentMethodIdForNewOrderRequest(); // \Linnworks\Orders\Model\OrdersSetDefaultPaymentMethodIdForNewOrderRequest

try {
    $apiInstance->setDefaultPaymentMethodIdForNewOrder($orders_set_default_payment_method_id_for_new_order_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setDefaultPaymentMethodIdForNewOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_default_payment_method_id_for_new_order_request** | [**\Linnworks\Orders\Model\OrdersSetDefaultPaymentMethodIdForNewOrderRequest**](../Model/OrdersSetDefaultPaymentMethodIdForNewOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setExtendedProperties()`

```php
setExtendedProperties($orders_set_extended_properties_request): \Linnworks\Orders\Model\ExtendedProperty[]
```

SetExtendedProperties

Set the extended properties for a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_extended_properties_request = new \Linnworks\Orders\Model\OrdersSetExtendedPropertiesRequest(); // \Linnworks\Orders\Model\OrdersSetExtendedPropertiesRequest

try {
    $result = $apiInstance->setExtendedProperties($orders_set_extended_properties_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_extended_properties_request** | [**\Linnworks\Orders\Model\OrdersSetExtendedPropertiesRequest**](../Model/OrdersSetExtendedPropertiesRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\ExtendedProperty[]**](../Model/ExtendedProperty.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setInvoicesPrinted()`

```php
setInvoicesPrinted($orders_set_invoices_printed_request): string[]
```

SetInvoicesPrinted

Mark a list of orders as invoice printed. This operation can not be executed on locked or parked orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_invoices_printed_request = new \Linnworks\Orders\Model\OrdersSetInvoicesPrintedRequest(); // \Linnworks\Orders\Model\OrdersSetInvoicesPrintedRequest

try {
    $result = $apiInstance->setInvoicesPrinted($orders_set_invoices_printed_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setInvoicesPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_invoices_printed_request** | [**\Linnworks\Orders\Model\OrdersSetInvoicesPrintedRequest**](../Model/OrdersSetInvoicesPrintedRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setLabelsPrinted()`

```php
setLabelsPrinted($orders_set_labels_printed_request): string[]
```

SetLabelsPrinted

Mark a list of orders as label printed <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_labels_printed_request = new \Linnworks\Orders\Model\OrdersSetLabelsPrintedRequest(); // \Linnworks\Orders\Model\OrdersSetLabelsPrintedRequest

try {
    $result = $apiInstance->setLabelsPrinted($orders_set_labels_printed_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setLabelsPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_labels_printed_request** | [**\Linnworks\Orders\Model\OrdersSetLabelsPrintedRequest**](../Model/OrdersSetLabelsPrintedRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderCustomerInfo()`

```php
setOrderCustomerInfo($orders_set_order_customer_info_request): \Linnworks\Orders\Model\OrderTotalsInfo
```

SetOrderCustomerInfo

Update the customer info of a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_customer_info_request = new \Linnworks\Orders\Model\OrdersSetOrderCustomerInfoRequest(); // \Linnworks\Orders\Model\OrdersSetOrderCustomerInfoRequest

try {
    $result = $apiInstance->setOrderCustomerInfo($orders_set_order_customer_info_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderCustomerInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_customer_info_request** | [**\Linnworks\Orders\Model\OrdersSetOrderCustomerInfoRequest**](../Model/OrdersSetOrderCustomerInfoRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OrderTotalsInfo**](../Model/OrderTotalsInfo.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderGeneralInfo()`

```php
setOrderGeneralInfo($orders_set_order_general_info_request)
```

SetOrderGeneralInfo

Update the general info of a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_general_info_request = new \Linnworks\Orders\Model\OrdersSetOrderGeneralInfoRequest(); // \Linnworks\Orders\Model\OrdersSetOrderGeneralInfoRequest

try {
    $apiInstance->setOrderGeneralInfo($orders_set_order_general_info_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderGeneralInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_general_info_request** | [**\Linnworks\Orders\Model\OrdersSetOrderGeneralInfoRequest**](../Model/OrdersSetOrderGeneralInfoRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderNotes()`

```php
setOrderNotes($orders_set_order_notes_request)
```

SetOrderNotes

Set the order notes for a specific order  SetOrderNotes overwrites the existing order notes with those in the list provided.   Any existing notes should be retrieved using GetOrderNotes and added to this list, so that they are not lost/overwritten. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_notes_request = new \Linnworks\Orders\Model\OrdersSetOrderNotesRequest(); // \Linnworks\Orders\Model\OrdersSetOrderNotesRequest

try {
    $apiInstance->setOrderNotes($orders_set_order_notes_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_notes_request** | [**\Linnworks\Orders\Model\OrdersSetOrderNotesRequest**](../Model/OrdersSetOrderNotesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderPackaging()`

```php
setOrderPackaging($orders_set_order_packaging_request): \Linnworks\Orders\Model\CalcOrderHeader
```

SetOrderPackaging

Designed to save order packaging when it has already been calculated but not saved or is a manual edit. <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_packaging_request = new \Linnworks\Orders\Model\OrdersSetOrderPackagingRequest(); // \Linnworks\Orders\Model\OrdersSetOrderPackagingRequest

try {
    $result = $apiInstance->setOrderPackaging($orders_set_order_packaging_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderPackaging: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_packaging_request** | [**\Linnworks\Orders\Model\OrdersSetOrderPackagingRequest**](../Model/OrdersSetOrderPackagingRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\CalcOrderHeader**](../Model/CalcOrderHeader.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderPackagingSplit()`

```php
setOrderPackagingSplit($orders_set_order_packaging_split_request): \Linnworks\Orders\Model\UpdateTotalsResult
```

SetOrderPackagingSplit

Split an order by packaging <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_packaging_split_request = new \Linnworks\Orders\Model\OrdersSetOrderPackagingSplitRequest(); // \Linnworks\Orders\Model\OrdersSetOrderPackagingSplitRequest

try {
    $result = $apiInstance->setOrderPackagingSplit($orders_set_order_packaging_split_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderPackagingSplit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_packaging_split_request** | [**\Linnworks\Orders\Model\OrdersSetOrderPackagingSplitRequest**](../Model/OrdersSetOrderPackagingSplitRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateTotalsResult**](../Model/UpdateTotalsResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderShippingInfo()`

```php
setOrderShippingInfo($orders_set_order_shipping_info_request): \Linnworks\Orders\Model\UpdateTotalsResult
```

SetOrderShippingInfo

Update the shipping info of a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_shipping_info_request = new \Linnworks\Orders\Model\OrdersSetOrderShippingInfoRequest(); // \Linnworks\Orders\Model\OrdersSetOrderShippingInfoRequest

try {
    $result = $apiInstance->setOrderShippingInfo($orders_set_order_shipping_info_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderShippingInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_shipping_info_request** | [**\Linnworks\Orders\Model\OrdersSetOrderShippingInfoRequest**](../Model/OrdersSetOrderShippingInfoRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateTotalsResult**](../Model/UpdateTotalsResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderSplitPackagingManualOverwrite()`

```php
setOrderSplitPackagingManualOverwrite($orders_set_order_split_packaging_manual_overwrite_request): \Linnworks\Orders\Model\CalcOrderHeader
```

SetOrderSplitPackagingManualOverwrite

Designed to save order split packaging after a manual override <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_split_packaging_manual_overwrite_request = new \Linnworks\Orders\Model\OrdersSetOrderSplitPackagingManualOverwriteRequest(); // \Linnworks\Orders\Model\OrdersSetOrderSplitPackagingManualOverwriteRequest

try {
    $result = $apiInstance->setOrderSplitPackagingManualOverwrite($orders_set_order_split_packaging_manual_overwrite_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderSplitPackagingManualOverwrite: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_split_packaging_manual_overwrite_request** | [**\Linnworks\Orders\Model\OrdersSetOrderSplitPackagingManualOverwriteRequest**](../Model/OrdersSetOrderSplitPackagingManualOverwriteRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\CalcOrderHeader**](../Model/CalcOrderHeader.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setOrderTotalsInfo()`

```php
setOrderTotalsInfo($orders_set_order_totals_info_request)
```

SetOrderTotalsInfo

Update totals info of a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_order_totals_info_request = new \Linnworks\Orders\Model\OrdersSetOrderTotalsInfoRequest(); // \Linnworks\Orders\Model\OrdersSetOrderTotalsInfoRequest

try {
    $apiInstance->setOrderTotalsInfo($orders_set_order_totals_info_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setOrderTotalsInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_order_totals_info_request** | [**\Linnworks\Orders\Model\OrdersSetOrderTotalsInfoRequest**](../Model/OrdersSetOrderTotalsInfoRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setPaymentMethods()`

```php
setPaymentMethods($orders_set_payment_methods_request): \Linnworks\Orders\Model\PaymentMethod[]
```

SetPaymentMethods

Set the available payment methods <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_payment_methods_request = new \Linnworks\Orders\Model\OrdersSetPaymentMethodsRequest(); // \Linnworks\Orders\Model\OrdersSetPaymentMethodsRequest

try {
    $result = $apiInstance->setPaymentMethods($orders_set_payment_methods_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setPaymentMethods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_payment_methods_request** | [**\Linnworks\Orders\Model\OrdersSetPaymentMethodsRequest**](../Model/OrdersSetPaymentMethodsRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\PaymentMethod[]**](../Model/PaymentMethod.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setPickListPrinted()`

```php
setPickListPrinted($orders_set_pick_list_printed_request)
```

SetPickListPrinted

Sets the print flag for the given orders. This operation can not be executed on locked or parked orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_set_pick_list_printed_request = new \Linnworks\Orders\Model\OrdersSetPickListPrintedRequest(); // \Linnworks\Orders\Model\OrdersSetPickListPrintedRequest

try {
    $apiInstance->setPickListPrinted($orders_set_pick_list_printed_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->setPickListPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_set_pick_list_printed_request** | [**\Linnworks\Orders\Model\OrdersSetPickListPrintedRequest**](../Model/OrdersSetPickListPrintedRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `splitOrder()`

```php
splitOrder($orders_split_order_request): \Linnworks\Orders\Model\OpenOrder[]
```

SplitOrder

Split a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_split_order_request = new \Linnworks\Orders\Model\OrdersSplitOrderRequest(); // \Linnworks\Orders\Model\OrdersSplitOrderRequest

try {
    $result = $apiInstance->splitOrder($orders_split_order_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->splitOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_split_order_request** | [**\Linnworks\Orders\Model\OrdersSplitOrderRequest**](../Model/OrdersSplitOrderRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\OpenOrder[]**](../Model/OpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `unassignToFolder()`

```php
unassignToFolder($orders_unassign_to_folder_request): string[]
```

UnassignToFolder

Unassign a list of orders to a specific folder. This operation can not be executed on locked or parked orders <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_unassign_to_folder_request = new \Linnworks\Orders\Model\OrdersUnassignToFolderRequest(); // \Linnworks\Orders\Model\OrdersUnassignToFolderRequest

try {
    $result = $apiInstance->unassignToFolder($orders_unassign_to_folder_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->unassignToFolder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_unassign_to_folder_request** | [**\Linnworks\Orders\Model\OrdersUnassignToFolderRequest**](../Model/OrdersUnassignToFolderRequest.md)|  | |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAdditionalInfo()`

```php
updateAdditionalInfo($orders_update_additional_info_request)
```

UpdateAdditionalInfo

Updates additional info of a specific item <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_update_additional_info_request = new \Linnworks\Orders\Model\OrdersUpdateAdditionalInfoRequest(); // \Linnworks\Orders\Model\OrdersUpdateAdditionalInfoRequest

try {
    $apiInstance->updateAdditionalInfo($orders_update_additional_info_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->updateAdditionalInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_update_additional_info_request** | [**\Linnworks\Orders\Model\OrdersUpdateAdditionalInfoRequest**](../Model/OrdersUpdateAdditionalInfoRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateBillingAddress()`

```php
updateBillingAddress($orders_update_billing_address_request)
```

UpdateBillingAddress

Update the billing address of a specific order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_update_billing_address_request = new \Linnworks\Orders\Model\OrdersUpdateBillingAddressRequest(); // \Linnworks\Orders\Model\OrdersUpdateBillingAddressRequest

try {
    $apiInstance->updateBillingAddress($orders_update_billing_address_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->updateBillingAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_update_billing_address_request** | [**\Linnworks\Orders\Model\OrdersUpdateBillingAddressRequest**](../Model/OrdersUpdateBillingAddressRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateLinkItem()`

```php
updateLinkItem($orders_update_link_item_request)
```

UpdateLinkItem

Update linked item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_update_link_item_request = new \Linnworks\Orders\Model\OrdersUpdateLinkItemRequest(); // \Linnworks\Orders\Model\OrdersUpdateLinkItemRequest

try {
    $apiInstance->updateLinkItem($orders_update_link_item_request);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->updateLinkItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_update_link_item_request** | [**\Linnworks\Orders\Model\OrdersUpdateLinkItemRequest**](../Model/OrdersUpdateLinkItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateOrderItem()`

```php
updateOrderItem($orders_update_order_item_request): \Linnworks\Orders\Model\UpdateOrderItemResult
```

UpdateOrderItem

Update an order item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_update_order_item_request = new \Linnworks\Orders\Model\OrdersUpdateOrderItemRequest(); // \Linnworks\Orders\Model\OrdersUpdateOrderItemRequest

try {
    $result = $apiInstance->updateOrderItem($orders_update_order_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->updateOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_update_order_item_request** | [**\Linnworks\Orders\Model\OrdersUpdateOrderItemRequest**](../Model/OrdersUpdateOrderItemRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\UpdateOrderItemResult**](../Model/UpdateOrderItemResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `validateCoupon()`

```php
validateCoupon($orders_validate_coupon_request): \Linnworks\Orders\Model\CouponValidationResult
```

ValidateCoupon

Validate a coupon <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_validate_coupon_request = new \Linnworks\Orders\Model\OrdersValidateCouponRequest(); // \Linnworks\Orders\Model\OrdersValidateCouponRequest

try {
    $result = $apiInstance->validateCoupon($orders_validate_coupon_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->validateCoupon: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **orders_validate_coupon_request** | [**\Linnworks\Orders\Model\OrdersValidateCouponRequest**](../Model/OrdersValidateCouponRequest.md)|  | |

### Return type

[**\Linnworks\Orders\Model\CouponValidationResult**](../Model/CouponValidationResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
