# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Orders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Orders\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orders_add_coupon_request = new \Linnworks\Orders\Model\OrdersAddCouponRequest(); // \Linnworks\Orders\Model\OrdersAddCouponRequest

try {
    $result = $apiInstance->addCoupon($orders_add_coupon_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->addCoupon: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OrdersApi* | [**addCoupon**](docs/Api/OrdersApi.md#addcoupon) | **POST** /api/Orders/AddCoupon | AddCoupon
*OrdersApi* | [**addExtendedProperties**](docs/Api/OrdersApi.md#addextendedproperties) | **POST** /api/Orders/AddExtendedProperties | AddExtendedProperties
*OrdersApi* | [**addOrderItem**](docs/Api/OrdersApi.md#addorderitem) | **POST** /api/Orders/AddOrderItem | AddOrderItem
*OrdersApi* | [**addOrderService**](docs/Api/OrdersApi.md#addorderservice) | **POST** /api/Orders/AddOrderService | AddOrderService
*OrdersApi* | [**assignOrderItemBatches**](docs/Api/OrdersApi.md#assignorderitembatches) | **POST** /api/Orders/AssignOrderItemBatches | AssignOrderItemBatches
*OrdersApi* | [**assignStockToOrder**](docs/Api/OrdersApi.md#assignstocktoorder) | **POST** /api/Orders/AssignStockToOrder | AssignStockToOrder
*OrdersApi* | [**assignToFolder**](docs/Api/OrdersApi.md#assigntofolder) | **POST** /api/Orders/AssignToFolder | AssignToFolder
*OrdersApi* | [**cancelOrder**](docs/Api/OrdersApi.md#cancelorder) | **POST** /api/Orders/CancelOrder | CancelOrder
*OrdersApi* | [**changeOrderTag**](docs/Api/OrdersApi.md#changeordertag) | **POST** /api/Orders/ChangeOrderTag | ChangeOrderTag
*OrdersApi* | [**changeShippingMethod**](docs/Api/OrdersApi.md#changeshippingmethod) | **POST** /api/Orders/ChangeShippingMethod | ChangeShippingMethod
*OrdersApi* | [**changeStatus**](docs/Api/OrdersApi.md#changestatus) | **POST** /api/Orders/ChangeStatus | ChangeStatus
*OrdersApi* | [**clearInvoicePrinted**](docs/Api/OrdersApi.md#clearinvoiceprinted) | **POST** /api/Orders/ClearInvoicePrinted | ClearInvoicePrinted
*OrdersApi* | [**clearPickListPrinted**](docs/Api/OrdersApi.md#clearpicklistprinted) | **POST** /api/Orders/ClearPickListPrinted | ClearPickListPrinted
*OrdersApi* | [**clearShippingLabelInfo**](docs/Api/OrdersApi.md#clearshippinglabelinfo) | **POST** /api/Orders/ClearShippingLabelInfo | ClearShippingLabelInfo
*OrdersApi* | [**completeOrder**](docs/Api/OrdersApi.md#completeorder) | **POST** /api/Orders/CompleteOrder | CompleteOrder
*OrdersApi* | [**createNewItemAndLink**](docs/Api/OrdersApi.md#createnewitemandlink) | **POST** /api/Orders/CreateNewItemAndLink | CreateNewItemAndLink
*OrdersApi* | [**createNewOrder**](docs/Api/OrdersApi.md#createneworder) | **POST** /api/Orders/CreateNewOrder | CreateNewOrder
*OrdersApi* | [**createOrders**](docs/Api/OrdersApi.md#createorders) | **POST** /api/Orders/CreateOrders | CreateOrders
*OrdersApi* | [**createSerialisedValuesForOrderItems**](docs/Api/OrdersApi.md#createserialisedvaluesfororderitems) | **POST** /api/Orders/CreateSerialisedValuesForOrderItems | CreateSerialisedValuesForOrderItems
*OrdersApi* | [**customerLookUp**](docs/Api/OrdersApi.md#customerlookup) | **GET** /api/Orders/CustomerLookUp | CustomerLookUp
*OrdersApi* | [**deleteOrder**](docs/Api/OrdersApi.md#deleteorder) | **POST** /api/Orders/DeleteOrder | DeleteOrder
*OrdersApi* | [**getAllAvailableOrderItemBatchsByOrderId**](docs/Api/OrdersApi.md#getallavailableorderitembatchsbyorderid) | **POST** /api/Orders/GetAllAvailableOrderItemBatchsByOrderId | GetAllAvailableOrderItemBatchsByOrderId
*OrdersApi* | [**getAllOpenOrders**](docs/Api/OrdersApi.md#getallopenorders) | **POST** /api/Orders/GetAllOpenOrders | GetAllOpenOrders
*OrdersApi* | [**getAllOpenOrdersBetweenIndex**](docs/Api/OrdersApi.md#getallopenordersbetweenindex) | **POST** /api/Orders/GetAllOpenOrdersBetweenIndex | GetAllOpenOrdersBetweenIndex
*OrdersApi* | [**getAssignedOrderItemBatches**](docs/Api/OrdersApi.md#getassignedorderitembatches) | **POST** /api/Orders/GetAssignedOrderItemBatches | GetAssignedOrderItemBatches
*OrdersApi* | [**getAvailableFolders**](docs/Api/OrdersApi.md#getavailablefolders) | **GET** /api/Orders/GetAvailableFolders | GetAvailableFolders
*OrdersApi* | [**getBatchPilots**](docs/Api/OrdersApi.md#getbatchpilots) | **GET** /api/Orders/GetBatchPilots | GetBatchPilots
*OrdersApi* | [**getCountries**](docs/Api/OrdersApi.md#getcountries) | **GET** /api/Orders/GetCountries | GetCountries
*OrdersApi* | [**getDefaultPaymentMethodIdForNewOrder**](docs/Api/OrdersApi.md#getdefaultpaymentmethodidforneworder) | **GET** /api/Orders/GetDefaultPaymentMethodIdForNewOrder | GetDefaultPaymentMethodIdForNewOrder
*OrdersApi* | [**getDraftOrders**](docs/Api/OrdersApi.md#getdraftorders) | **GET** /api/Orders/GetDraftOrders | GetDraftOrders
*OrdersApi* | [**getExtendedProperties**](docs/Api/OrdersApi.md#getextendedproperties) | **GET** /api/Orders/GetExtendedProperties | GetExtendedProperties
*OrdersApi* | [**getExtendedPropertyNames**](docs/Api/OrdersApi.md#getextendedpropertynames) | **GET** /api/Orders/GetExtendedPropertyNames | GetExtendedPropertyNames
*OrdersApi* | [**getExtendedPropertyTypes**](docs/Api/OrdersApi.md#getextendedpropertytypes) | **GET** /api/Orders/GetExtendedPropertyTypes | GetExtendedPropertyTypes
*OrdersApi* | [**getLinkedItems**](docs/Api/OrdersApi.md#getlinkeditems) | **GET** /api/Orders/GetLinkedItems | GetLinkedItems
*OrdersApi* | [**getOpenOrderIdByOrderOrReferenceId**](docs/Api/OrdersApi.md#getopenorderidbyorderorreferenceid) | **POST** /api/Orders/GetOpenOrderIdByOrderOrReferenceId | GetOpenOrderIdByOrderOrReferenceId
*OrdersApi* | [**getOpenOrderItemsSuppliers**](docs/Api/OrdersApi.md#getopenorderitemssuppliers) | **GET** /api/Orders/GetOpenOrderItemsSuppliers | GetOpenOrderItemsSuppliers
*OrdersApi* | [**getOpenOrders**](docs/Api/OrdersApi.md#getopenorders) | **POST** /api/Orders/GetOpenOrders | GetOpenOrders
*OrdersApi* | [**getOpenOrdersByItemBarcode**](docs/Api/OrdersApi.md#getopenordersbyitembarcode) | **POST** /api/Orders/GetOpenOrdersByItemBarcode | GetOpenOrdersByItemBarcode
*OrdersApi* | [**getOrder**](docs/Api/OrdersApi.md#getorder) | **POST** /api/Orders/GetOrder | GetOrder
*OrdersApi* | [**getOrderAuditTrail**](docs/Api/OrdersApi.md#getorderaudittrail) | **GET** /api/Orders/GetOrderAuditTrail | GetOrderAuditTrail
*OrdersApi* | [**getOrderAuditTrailsByIds**](docs/Api/OrdersApi.md#getorderaudittrailsbyids) | **POST** /api/Orders/GetOrderAuditTrailsByIds | GetOrderAuditTrailsByIds
*OrdersApi* | [**getOrderById**](docs/Api/OrdersApi.md#getorderbyid) | **GET** /api/Orders/GetOrderById | GetOrderById
*OrdersApi* | [**getOrderDetailsByNumOrderId**](docs/Api/OrdersApi.md#getorderdetailsbynumorderid) | **GET** /api/Orders/GetOrderDetailsByNumOrderId | GetOrderDetailsByNumOrderId
*OrdersApi* | [**getOrderDetailsByReferenceId**](docs/Api/OrdersApi.md#getorderdetailsbyreferenceid) | **GET** /api/Orders/GetOrderDetailsByReferenceId | GetOrderDetailsByReferenceId
*OrdersApi* | [**getOrderItemBatchesByOrderIds**](docs/Api/OrdersApi.md#getorderitembatchesbyorderids) | **POST** /api/Orders/GetOrderItemBatchesByOrderIds | GetOrderItemBatchesByOrderIds
*OrdersApi* | [**getOrderItemBatchsByOrderId**](docs/Api/OrdersApi.md#getorderitembatchsbyorderid) | **POST** /api/Orders/GetOrderItemBatchsByOrderId | GetOrderItemBatchsByOrderId
*OrdersApi* | [**getOrderItemComposition**](docs/Api/OrdersApi.md#getorderitemcomposition) | **GET** /api/Orders/GetOrderItemComposition | GetOrderItemComposition
*OrdersApi* | [**getOrderItemRowSerialValuesByOrderIds**](docs/Api/OrdersApi.md#getorderitemrowserialvaluesbyorderids) | **POST** /api/Orders/GetOrderItemRowSerialValuesByOrderIds | GetOrderItemRowSerialValuesByOrderIds
*OrdersApi* | [**getOrderItems**](docs/Api/OrdersApi.md#getorderitems) | **GET** /api/Orders/GetOrderItems | GetOrderItems
*OrdersApi* | [**getOrderNoteTypes**](docs/Api/OrdersApi.md#getordernotetypes) | **GET** /api/Orders/GetOrderNoteTypes | GetOrderNoteTypes
*OrdersApi* | [**getOrderNotes**](docs/Api/OrdersApi.md#getordernotes) | **GET** /api/Orders/GetOrderNotes | GetOrderNotes
*OrdersApi* | [**getOrderPackagingCalculation**](docs/Api/OrdersApi.md#getorderpackagingcalculation) | **POST** /api/Orders/GetOrderPackagingCalculation | GetOrderPackagingCalculation
*OrdersApi* | [**getOrderPackagingSplit**](docs/Api/OrdersApi.md#getorderpackagingsplit) | **GET** /api/Orders/GetOrderPackagingSplit | GetOrderPackagingSplit
*OrdersApi* | [**getOrderRelations**](docs/Api/OrdersApi.md#getorderrelations) | **GET** /api/Orders/GetOrderRelations | GetOrderRelations
*OrdersApi* | [**getOrderView**](docs/Api/OrdersApi.md#getorderview) | **GET** /api/Orders/GetOrderView | GetOrderView
*OrdersApi* | [**getOrderViews**](docs/Api/OrdersApi.md#getorderviews) | **GET** /api/Orders/GetOrderViews | GetOrderViews
*OrdersApi* | [**getOrderXml**](docs/Api/OrdersApi.md#getorderxml) | **GET** /api/Orders/GetOrderXml | GetOrderXml
*OrdersApi* | [**getOrderXmlJSTree**](docs/Api/OrdersApi.md#getorderxmljstree) | **GET** /api/Orders/GetOrderXmlJSTree | GetOrderXmlJSTree
*OrdersApi* | [**getOrders**](docs/Api/OrdersApi.md#getorders) | **POST** /api/Orders/GetOrders | GetOrders
*OrdersApi* | [**getOrdersById**](docs/Api/OrdersApi.md#getordersbyid) | **POST** /api/Orders/GetOrdersById | GetOrdersById
*OrdersApi* | [**getOrdersNotes**](docs/Api/OrdersApi.md#getordersnotes) | **POST** /api/Orders/GetOrdersNotes | GetOrdersNotes
*OrdersApi* | [**getOrdersRelations**](docs/Api/OrdersApi.md#getordersrelations) | **POST** /api/Orders/GetOrdersRelations | GetOrdersRelations
*OrdersApi* | [**getPackagingGroups**](docs/Api/OrdersApi.md#getpackaginggroups) | **GET** /api/Orders/GetPackagingGroups | GetPackagingGroups
*OrdersApi* | [**getPaymentMethods**](docs/Api/OrdersApi.md#getpaymentmethods) | **GET** /api/Orders/GetPaymentMethods | GetPaymentMethods
*OrdersApi* | [**getShippingMethods**](docs/Api/OrdersApi.md#getshippingmethods) | **GET** /api/Orders/GetShippingMethods | GetShippingMethods
*OrdersApi* | [**getUserLocationId**](docs/Api/OrdersApi.md#getuserlocationid) | **GET** /api/Orders/GetUserLocationId | GetUserLocationId
*OrdersApi* | [**lockOrder**](docs/Api/OrdersApi.md#lockorder) | **POST** /api/Orders/LockOrder | LockOrder
*OrdersApi* | [**mergeOrders**](docs/Api/OrdersApi.md#mergeorders) | **POST** /api/Orders/MergeOrders | MergeOrders
*OrdersApi* | [**moveToLocation**](docs/Api/OrdersApi.md#movetolocation) | **POST** /api/Orders/MoveToLocation | MoveToLocation
*OrdersApi* | [**processFulfilmentCentreOrder**](docs/Api/OrdersApi.md#processfulfilmentcentreorder) | **POST** /api/Orders/ProcessFulfilmentCentreOrder | ProcessFulfilmentCentreOrder
*OrdersApi* | [**processOrder**](docs/Api/OrdersApi.md#processorder) | **POST** /api/Orders/ProcessOrder | ProcessOrder
*OrdersApi* | [**processOrderByOrderOrReferenceId**](docs/Api/OrdersApi.md#processorderbyorderorreferenceid) | **POST** /api/Orders/ProcessOrderByOrderOrReferenceId | ProcessOrderByOrderOrReferenceId
*OrdersApi* | [**processOrderRequiredBatchScans**](docs/Api/OrdersApi.md#processorderrequiredbatchscans) | **POST** /api/Orders/ProcessOrder_RequiredBatchScans | ProcessOrder_RequiredBatchScans
*OrdersApi* | [**processOrdersInBatch**](docs/Api/OrdersApi.md#processordersinbatch) | **POST** /api/Orders/ProcessOrdersInBatch | ProcessOrdersInBatch
*OrdersApi* | [**recalculateSingleOrderPackaging**](docs/Api/OrdersApi.md#recalculatesingleorderpackaging) | **POST** /api/Orders/RecalculateSingleOrderPackaging | RecalculateSingleOrderPackaging
*OrdersApi* | [**removeOrderItem**](docs/Api/OrdersApi.md#removeorderitem) | **POST** /api/Orders/RemoveOrderItem | RemoveOrderItem
*OrdersApi* | [**runRulesEngine**](docs/Api/OrdersApi.md#runrulesengine) | **POST** /api/Orders/RunRulesEngine | RunRulesEngine
*OrdersApi* | [**saveOrderView**](docs/Api/OrdersApi.md#saveorderview) | **POST** /api/Orders/SaveOrderView | SaveOrderView
*OrdersApi* | [**setAdditionalInfo**](docs/Api/OrdersApi.md#setadditionalinfo) | **POST** /api/Orders/SetAdditionalInfo | SetAdditionalInfo
*OrdersApi* | [**setAvailableFolders**](docs/Api/OrdersApi.md#setavailablefolders) | **POST** /api/Orders/SetAvailableFolders | SetAvailableFolders
*OrdersApi* | [**setDefaultPaymentMethodIdForNewOrder**](docs/Api/OrdersApi.md#setdefaultpaymentmethodidforneworder) | **POST** /api/Orders/SetDefaultPaymentMethodIdForNewOrder | SetDefaultPaymentMethodIdForNewOrder
*OrdersApi* | [**setExtendedProperties**](docs/Api/OrdersApi.md#setextendedproperties) | **POST** /api/Orders/SetExtendedProperties | SetExtendedProperties
*OrdersApi* | [**setInvoicesPrinted**](docs/Api/OrdersApi.md#setinvoicesprinted) | **POST** /api/Orders/SetInvoicesPrinted | SetInvoicesPrinted
*OrdersApi* | [**setLabelsPrinted**](docs/Api/OrdersApi.md#setlabelsprinted) | **POST** /api/Orders/SetLabelsPrinted | SetLabelsPrinted
*OrdersApi* | [**setOrderCustomerInfo**](docs/Api/OrdersApi.md#setordercustomerinfo) | **POST** /api/Orders/SetOrderCustomerInfo | SetOrderCustomerInfo
*OrdersApi* | [**setOrderGeneralInfo**](docs/Api/OrdersApi.md#setordergeneralinfo) | **POST** /api/Orders/SetOrderGeneralInfo | SetOrderGeneralInfo
*OrdersApi* | [**setOrderNotes**](docs/Api/OrdersApi.md#setordernotes) | **POST** /api/Orders/SetOrderNotes | SetOrderNotes
*OrdersApi* | [**setOrderPackaging**](docs/Api/OrdersApi.md#setorderpackaging) | **POST** /api/Orders/SetOrderPackaging | SetOrderPackaging
*OrdersApi* | [**setOrderPackagingSplit**](docs/Api/OrdersApi.md#setorderpackagingsplit) | **POST** /api/Orders/SetOrderPackagingSplit | SetOrderPackagingSplit
*OrdersApi* | [**setOrderShippingInfo**](docs/Api/OrdersApi.md#setordershippinginfo) | **POST** /api/Orders/SetOrderShippingInfo | SetOrderShippingInfo
*OrdersApi* | [**setOrderSplitPackagingManualOverwrite**](docs/Api/OrdersApi.md#setordersplitpackagingmanualoverwrite) | **POST** /api/Orders/SetOrderSplitPackagingManualOverwrite | SetOrderSplitPackagingManualOverwrite
*OrdersApi* | [**setOrderTotalsInfo**](docs/Api/OrdersApi.md#setordertotalsinfo) | **POST** /api/Orders/SetOrderTotalsInfo | SetOrderTotalsInfo
*OrdersApi* | [**setPaymentMethods**](docs/Api/OrdersApi.md#setpaymentmethods) | **POST** /api/Orders/SetPaymentMethods | SetPaymentMethods
*OrdersApi* | [**setPickListPrinted**](docs/Api/OrdersApi.md#setpicklistprinted) | **POST** /api/Orders/SetPickListPrinted | SetPickListPrinted
*OrdersApi* | [**splitOrder**](docs/Api/OrdersApi.md#splitorder) | **POST** /api/Orders/SplitOrder | SplitOrder
*OrdersApi* | [**unassignToFolder**](docs/Api/OrdersApi.md#unassigntofolder) | **POST** /api/Orders/UnassignToFolder | UnassignToFolder
*OrdersApi* | [**updateAdditionalInfo**](docs/Api/OrdersApi.md#updateadditionalinfo) | **POST** /api/Orders/UpdateAdditionalInfo | UpdateAdditionalInfo
*OrdersApi* | [**updateBillingAddress**](docs/Api/OrdersApi.md#updatebillingaddress) | **POST** /api/Orders/UpdateBillingAddress | UpdateBillingAddress
*OrdersApi* | [**updateLinkItem**](docs/Api/OrdersApi.md#updatelinkitem) | **POST** /api/Orders/UpdateLinkItem | UpdateLinkItem
*OrdersApi* | [**updateOrderItem**](docs/Api/OrdersApi.md#updateorderitem) | **POST** /api/Orders/UpdateOrderItem | UpdateOrderItem
*OrdersApi* | [**validateCoupon**](docs/Api/OrdersApi.md#validatecoupon) | **POST** /api/Orders/ValidateCoupon | ValidateCoupon

## Models

- [AddExtendedPropertiesRequest](docs/Model/AddExtendedPropertiesRequest.md)
- [AddExtendedPropertiesResponse](docs/Model/AddExtendedPropertiesResponse.md)
- [AssignOrderItemBatches](docs/Model/AssignOrderItemBatches.md)
- [AssignStockToOrderRequest](docs/Model/AssignStockToOrderRequest.md)
- [AvailableOrderItemBatchsInfo](docs/Model/AvailableOrderItemBatchsInfo.md)
- [BasicExtendedProperty](docs/Model/BasicExtendedProperty.md)
- [BatchAssignment](docs/Model/BatchAssignment.md)
- [BatchAssignmentForOrderItems](docs/Model/BatchAssignmentForOrderItems.md)
- [BooleanFieldFilter](docs/Model/BooleanFieldFilter.md)
- [CalcBin](docs/Model/CalcBin.md)
- [CalcBinItem](docs/Model/CalcBinItem.md)
- [CalcOrderHeader](docs/Model/CalcOrderHeader.md)
- [CalcOrderItem](docs/Model/CalcOrderItem.md)
- [ChannelAddress](docs/Model/ChannelAddress.md)
- [ChannelOrder](docs/Model/ChannelOrder.md)
- [ChannelOrderExtendedProperty](docs/Model/ChannelOrderExtendedProperty.md)
- [ChannelOrderItem](docs/Model/ChannelOrderItem.md)
- [ChannelOrderItemLocationAllocation](docs/Model/ChannelOrderItemLocationAllocation.md)
- [ChannelOrderItemOption](docs/Model/ChannelOrderItemOption.md)
- [ChannelOrderItemTax](docs/Model/ChannelOrderItemTax.md)
- [ChannelOrderLocation](docs/Model/ChannelOrderLocation.md)
- [ChannelOrderNote](docs/Model/ChannelOrderNote.md)
- [ClientContext](docs/Model/ClientContext.md)
- [CouponValidationResult](docs/Model/CouponValidationResult.md)
- [CreateSerialisedValuesForOrderItemsRequest](docs/Model/CreateSerialisedValuesForOrderItemsRequest.md)
- [CustomerAddress](docs/Model/CustomerAddress.md)
- [DateFieldFilter](docs/Model/DateFieldFilter.md)
- [ExtendedProperty](docs/Model/ExtendedProperty.md)
- [Face](docs/Model/Face.md)
- [FieldSorting](docs/Model/FieldSorting.md)
- [FieldVisibility](docs/Model/FieldVisibility.md)
- [FieldsFilter](docs/Model/FieldsFilter.md)
- [GenericPagedResultOpenOrder](docs/Model/GenericPagedResultOpenOrder.md)
- [GetAssignedOrderItemBatchesRequest](docs/Model/GetAssignedOrderItemBatchesRequest.md)
- [GetOrderAuditTrailsByIdsRequest](docs/Model/GetOrderAuditTrailsByIdsRequest.md)
- [GetOrderAuditTrailsByIdsResponse](docs/Model/GetOrderAuditTrailsByIdsResponse.md)
- [GetOrderItemBatchesByOrderIdsRequest](docs/Model/GetOrderItemBatchesByOrderIdsRequest.md)
- [GetOrderItemBatchesByOrderIdsResponse](docs/Model/GetOrderItemBatchesByOrderIdsResponse.md)
- [GetOrderItemRowSerialValuesByOrderIdsRequest](docs/Model/GetOrderItemRowSerialValuesByOrderIdsRequest.md)
- [GetOrderPackagingCalculationRequest](docs/Model/GetOrderPackagingCalculationRequest.md)
- [GetSerialisedValuesForOrdersResponse](docs/Model/GetSerialisedValuesForOrdersResponse.md)
- [Identifier](docs/Model/Identifier.md)
- [KeyValuePairGuidGuid](docs/Model/KeyValuePairGuidGuid.md)
- [KeyValuePairGuidString](docs/Model/KeyValuePairGuidString.md)
- [KeyValuePairListOrderSummaryString](docs/Model/KeyValuePairListOrderSummaryString.md)
- [LinePricingRequest](docs/Model/LinePricingRequest.md)
- [LinkedItem](docs/Model/LinkedItem.md)
- [ListFieldFilter](docs/Model/ListFieldFilter.md)
- [MoveToLocationResult](docs/Model/MoveToLocationResult.md)
- [NumericFieldFilter](docs/Model/NumericFieldFilter.md)
- [OpenOrder](docs/Model/OpenOrder.md)
- [OrderAuditTrail](docs/Model/OrderAuditTrail.md)
- [OrderAuditTrailExtended](docs/Model/OrderAuditTrailExtended.md)
- [OrderCountry](docs/Model/OrderCountry.md)
- [OrderCustomerInfo](docs/Model/OrderCustomerInfo.md)
- [OrderDetails](docs/Model/OrderDetails.md)
- [OrderFolder](docs/Model/OrderFolder.md)
- [OrderFulfillmentState](docs/Model/OrderFulfillmentState.md)
- [OrderGeneralInfo](docs/Model/OrderGeneralInfo.md)
- [OrderItem](docs/Model/OrderItem.md)
- [OrderItemBatch](docs/Model/OrderItemBatch.md)
- [OrderItemBatchExtended](docs/Model/OrderItemBatchExtended.md)
- [OrderItemBatchInfo](docs/Model/OrderItemBatchInfo.md)
- [OrderItemBinRack](docs/Model/OrderItemBinRack.md)
- [OrderItemOnOrder](docs/Model/OrderItemOnOrder.md)
- [OrderItemOption](docs/Model/OrderItemOption.md)
- [OrderItemOptionUpdate](docs/Model/OrderItemOptionUpdate.md)
- [OrderItemSerialModel](docs/Model/OrderItemSerialModel.md)
- [OrderItemShippingBatchWithRow](docs/Model/OrderItemShippingBatchWithRow.md)
- [OrderNote](docs/Model/OrderNote.md)
- [OrderNoteType](docs/Model/OrderNoteType.md)
- [OrderPackagingSplit](docs/Model/OrderPackagingSplit.md)
- [OrderPackagingSplitItem](docs/Model/OrderPackagingSplitItem.md)
- [OrderRelation](docs/Model/OrderRelation.md)
- [OrderShippingInfo](docs/Model/OrderShippingInfo.md)
- [OrderSplit](docs/Model/OrderSplit.md)
- [OrderSplitOutItem](docs/Model/OrderSplitOutItem.md)
- [OrderSummary](docs/Model/OrderSummary.md)
- [OrderTaxInfo](docs/Model/OrderTaxInfo.md)
- [OrderTotalsInfo](docs/Model/OrderTotalsInfo.md)
- [OrderXML](docs/Model/OrderXML.md)
- [OrdersAddCouponRequest](docs/Model/OrdersAddCouponRequest.md)
- [OrdersAddExtendedPropertiesRequest](docs/Model/OrdersAddExtendedPropertiesRequest.md)
- [OrdersAddOrderItemRequest](docs/Model/OrdersAddOrderItemRequest.md)
- [OrdersAddOrderServiceRequest](docs/Model/OrdersAddOrderServiceRequest.md)
- [OrdersAssignOrderItemBatchesRequest](docs/Model/OrdersAssignOrderItemBatchesRequest.md)
- [OrdersAssignStockToOrderRequest](docs/Model/OrdersAssignStockToOrderRequest.md)
- [OrdersAssignToFolderRequest](docs/Model/OrdersAssignToFolderRequest.md)
- [OrdersCancelOrderRequest](docs/Model/OrdersCancelOrderRequest.md)
- [OrdersChangeOrderTagRequest](docs/Model/OrdersChangeOrderTagRequest.md)
- [OrdersChangeShippingMethodRequest](docs/Model/OrdersChangeShippingMethodRequest.md)
- [OrdersChangeStatusRequest](docs/Model/OrdersChangeStatusRequest.md)
- [OrdersClearInvoicePrintedRequest](docs/Model/OrdersClearInvoicePrintedRequest.md)
- [OrdersClearPickListPrintedRequest](docs/Model/OrdersClearPickListPrintedRequest.md)
- [OrdersClearShippingLabelInfoRequest](docs/Model/OrdersClearShippingLabelInfoRequest.md)
- [OrdersCompleteOrderRequest](docs/Model/OrdersCompleteOrderRequest.md)
- [OrdersCreateNewItemAndLinkRequest](docs/Model/OrdersCreateNewItemAndLinkRequest.md)
- [OrdersCreateNewOrderRequest](docs/Model/OrdersCreateNewOrderRequest.md)
- [OrdersCreateOrdersRequest](docs/Model/OrdersCreateOrdersRequest.md)
- [OrdersDeleteOrderRequest](docs/Model/OrdersDeleteOrderRequest.md)
- [OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest](docs/Model/OrdersGetAllAvailableOrderItemBatchsByOrderIdRequest.md)
- [OrdersGetAllOpenOrdersBetweenIndexRequest](docs/Model/OrdersGetAllOpenOrdersBetweenIndexRequest.md)
- [OrdersGetAllOpenOrdersRequest](docs/Model/OrdersGetAllOpenOrdersRequest.md)
- [OrdersGetAssignedOrderItemBatchesRequest](docs/Model/OrdersGetAssignedOrderItemBatchesRequest.md)
- [OrdersGetOpenOrderIdByOrderOrReferenceIdRequest](docs/Model/OrdersGetOpenOrderIdByOrderOrReferenceIdRequest.md)
- [OrdersGetOpenOrdersByItemBarcodeRequest](docs/Model/OrdersGetOpenOrdersByItemBarcodeRequest.md)
- [OrdersGetOpenOrdersRequest](docs/Model/OrdersGetOpenOrdersRequest.md)
- [OrdersGetOrderRequest](docs/Model/OrdersGetOrderRequest.md)
- [OrdersGetOrdersByIdRequest](docs/Model/OrdersGetOrdersByIdRequest.md)
- [OrdersGetOrdersNotesRequest](docs/Model/OrdersGetOrdersNotesRequest.md)
- [OrdersGetOrdersRelationsRequest](docs/Model/OrdersGetOrdersRelationsRequest.md)
- [OrdersGetOrdersRequest](docs/Model/OrdersGetOrdersRequest.md)
- [OrdersLockOrderRequest](docs/Model/OrdersLockOrderRequest.md)
- [OrdersMergeOrdersRequest](docs/Model/OrdersMergeOrdersRequest.md)
- [OrdersMoveToLocationRequest](docs/Model/OrdersMoveToLocationRequest.md)
- [OrdersProcessFulfilmentCentreOrderRequest](docs/Model/OrdersProcessFulfilmentCentreOrderRequest.md)
- [OrdersProcessOrderByOrderOrReferenceIdRequest](docs/Model/OrdersProcessOrderByOrderOrReferenceIdRequest.md)
- [OrdersProcessOrderRequest](docs/Model/OrdersProcessOrderRequest.md)
- [OrdersProcessOrderRequiredBatchScansRequest](docs/Model/OrdersProcessOrderRequiredBatchScansRequest.md)
- [OrdersProcessOrdersInBatchRequest](docs/Model/OrdersProcessOrdersInBatchRequest.md)
- [OrdersRecalculateSingleOrderPackagingRequest](docs/Model/OrdersRecalculateSingleOrderPackagingRequest.md)
- [OrdersRemoveOrderItemRequest](docs/Model/OrdersRemoveOrderItemRequest.md)
- [OrdersRunRulesEngineRequest](docs/Model/OrdersRunRulesEngineRequest.md)
- [OrdersSaveOrderViewRequest](docs/Model/OrdersSaveOrderViewRequest.md)
- [OrdersSetAdditionalInfoRequest](docs/Model/OrdersSetAdditionalInfoRequest.md)
- [OrdersSetAvailableFoldersRequest](docs/Model/OrdersSetAvailableFoldersRequest.md)
- [OrdersSetDefaultPaymentMethodIdForNewOrderRequest](docs/Model/OrdersSetDefaultPaymentMethodIdForNewOrderRequest.md)
- [OrdersSetExtendedPropertiesRequest](docs/Model/OrdersSetExtendedPropertiesRequest.md)
- [OrdersSetInvoicesPrintedRequest](docs/Model/OrdersSetInvoicesPrintedRequest.md)
- [OrdersSetLabelsPrintedRequest](docs/Model/OrdersSetLabelsPrintedRequest.md)
- [OrdersSetOrderCustomerInfoRequest](docs/Model/OrdersSetOrderCustomerInfoRequest.md)
- [OrdersSetOrderGeneralInfoRequest](docs/Model/OrdersSetOrderGeneralInfoRequest.md)
- [OrdersSetOrderNotesRequest](docs/Model/OrdersSetOrderNotesRequest.md)
- [OrdersSetOrderPackagingRequest](docs/Model/OrdersSetOrderPackagingRequest.md)
- [OrdersSetOrderPackagingSplitRequest](docs/Model/OrdersSetOrderPackagingSplitRequest.md)
- [OrdersSetOrderShippingInfoRequest](docs/Model/OrdersSetOrderShippingInfoRequest.md)
- [OrdersSetOrderSplitPackagingManualOverwriteRequest](docs/Model/OrdersSetOrderSplitPackagingManualOverwriteRequest.md)
- [OrdersSetOrderTotalsInfoRequest](docs/Model/OrdersSetOrderTotalsInfoRequest.md)
- [OrdersSetPaymentMethodsRequest](docs/Model/OrdersSetPaymentMethodsRequest.md)
- [OrdersSetPickListPrintedRequest](docs/Model/OrdersSetPickListPrintedRequest.md)
- [OrdersSplitOrderRequest](docs/Model/OrdersSplitOrderRequest.md)
- [OrdersUnassignToFolderRequest](docs/Model/OrdersUnassignToFolderRequest.md)
- [OrdersUpdateAdditionalInfoRequest](docs/Model/OrdersUpdateAdditionalInfoRequest.md)
- [OrdersUpdateBillingAddressRequest](docs/Model/OrdersUpdateBillingAddressRequest.md)
- [OrdersUpdateLinkItemRequest](docs/Model/OrdersUpdateLinkItemRequest.md)
- [OrdersUpdateOrderItemRequest](docs/Model/OrdersUpdateOrderItemRequest.md)
- [OrdersValidateCouponRequest](docs/Model/OrdersValidateCouponRequest.md)
- [PackageGroup](docs/Model/PackageGroup.md)
- [PackageResult](docs/Model/PackageResult.md)
- [PackageType](docs/Model/PackageType.md)
- [PackedItem](docs/Model/PackedItem.md)
- [PackingResult](docs/Model/PackingResult.md)
- [PaymentMethod](docs/Model/PaymentMethod.md)
- [PointF](docs/Model/PointF.md)
- [PostageService](docs/Model/PostageService.md)
- [ProcessOrderByOrderIdOrReferenceRequest](docs/Model/ProcessOrderByOrderIdOrReferenceRequest.md)
- [ProcessOrderByOrderIdOrReferenceResponse](docs/Model/ProcessOrderByOrderIdOrReferenceResponse.md)
- [ProcessOrderResult](docs/Model/ProcessOrderResult.md)
- [ScheduledDelivery](docs/Model/ScheduledDelivery.md)
- [SerialModel](docs/Model/SerialModel.md)
- [SetOrderPackagingRequest](docs/Model/SetOrderPackagingRequest.md)
- [SetPickListPrintedRequest](docs/Model/SetPickListPrintedRequest.md)
- [ShippingMethod](docs/Model/ShippingMethod.md)
- [StockItemBatch](docs/Model/StockItemBatch.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [StockItemBoxConfiguration](docs/Model/StockItemBoxConfiguration.md)
- [TextFieldFilter](docs/Model/TextFieldFilter.md)
- [UpdateAdditionalInfoRequest](docs/Model/UpdateAdditionalInfoRequest.md)
- [UpdateOrderItemResult](docs/Model/UpdateOrderItemResult.md)
- [UpdateOrderShippingInfoRequest](docs/Model/UpdateOrderShippingInfoRequest.md)
- [UpdateTotalsResult](docs/Model/UpdateTotalsResult.md)
- [UserOrderView](docs/Model/UserOrderView.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `orders`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
