<?php
/**
 * OrderViewStats
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Open Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: openorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OpenOrders\Model;

use \ArrayAccess;
use \Linnworks\OpenOrders\ObjectSerializer;

/**
 * OrderViewStats Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderViewStats implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderViewStats';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'view_id' => 'int',
        'view_name' => 'string',
        'is_system' => 'bool',
        'total_orders' => 'int',
        'location_id' => 'string',
        'expiry_date' => '\DateTime',
        'is_calculating' => 'bool',
        'view_exists' => 'bool',
        'last_requested' => '\DateTime',
        'user_management' => '\Linnworks\OpenOrders\Model\ViewUserManagement',
        'order_view_user_preference' => '\Linnworks\OpenOrders\Model\OrderViewUserPreference',
        'owner' => '\Linnworks\OpenOrders\Model\ViewUser',
        'is_cacheable' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'view_id' => 'int32',
        'view_name' => null,
        'is_system' => null,
        'total_orders' => 'int64',
        'location_id' => 'uuid',
        'expiry_date' => 'date-time',
        'is_calculating' => null,
        'view_exists' => null,
        'last_requested' => 'date-time',
        'user_management' => null,
        'order_view_user_preference' => null,
        'owner' => null,
        'is_cacheable' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'view_id' => false,
        'view_name' => false,
        'is_system' => false,
        'total_orders' => false,
        'location_id' => false,
        'expiry_date' => false,
        'is_calculating' => false,
        'view_exists' => false,
        'last_requested' => false,
        'user_management' => false,
        'order_view_user_preference' => false,
        'owner' => false,
        'is_cacheable' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'view_id' => 'ViewId',
        'view_name' => 'ViewName',
        'is_system' => 'IsSystem',
        'total_orders' => 'TotalOrders',
        'location_id' => 'LocationId',
        'expiry_date' => 'ExpiryDate',
        'is_calculating' => 'IsCalculating',
        'view_exists' => 'ViewExists',
        'last_requested' => 'LastRequested',
        'user_management' => 'UserManagement',
        'order_view_user_preference' => 'OrderViewUserPreference',
        'owner' => 'Owner',
        'is_cacheable' => 'IsCacheable'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'view_id' => 'setViewId',
        'view_name' => 'setViewName',
        'is_system' => 'setIsSystem',
        'total_orders' => 'setTotalOrders',
        'location_id' => 'setLocationId',
        'expiry_date' => 'setExpiryDate',
        'is_calculating' => 'setIsCalculating',
        'view_exists' => 'setViewExists',
        'last_requested' => 'setLastRequested',
        'user_management' => 'setUserManagement',
        'order_view_user_preference' => 'setOrderViewUserPreference',
        'owner' => 'setOwner',
        'is_cacheable' => 'setIsCacheable'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'view_id' => 'getViewId',
        'view_name' => 'getViewName',
        'is_system' => 'getIsSystem',
        'total_orders' => 'getTotalOrders',
        'location_id' => 'getLocationId',
        'expiry_date' => 'getExpiryDate',
        'is_calculating' => 'getIsCalculating',
        'view_exists' => 'getViewExists',
        'last_requested' => 'getLastRequested',
        'user_management' => 'getUserManagement',
        'order_view_user_preference' => 'getOrderViewUserPreference',
        'owner' => 'getOwner',
        'is_cacheable' => 'getIsCacheable'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('view_id', $data ?? [], null);
        $this->setIfExists('view_name', $data ?? [], null);
        $this->setIfExists('is_system', $data ?? [], null);
        $this->setIfExists('total_orders', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('expiry_date', $data ?? [], null);
        $this->setIfExists('is_calculating', $data ?? [], null);
        $this->setIfExists('view_exists', $data ?? [], null);
        $this->setIfExists('last_requested', $data ?? [], null);
        $this->setIfExists('user_management', $data ?? [], null);
        $this->setIfExists('order_view_user_preference', $data ?? [], null);
        $this->setIfExists('owner', $data ?? [], null);
        $this->setIfExists('is_cacheable', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets view_id
     *
     * @return int|null
     */
    public function getViewId()
    {
        return $this->container['view_id'];
    }

    /**
     * Sets view_id
     *
     * @param int|null $view_id view_id
     *
     * @return self
     */
    public function setViewId($view_id)
    {
        if (is_null($view_id)) {
            throw new \InvalidArgumentException('non-nullable view_id cannot be null');
        }
        $this->container['view_id'] = $view_id;

        return $this;
    }

    /**
     * Gets view_name
     *
     * @return string|null
     */
    public function getViewName()
    {
        return $this->container['view_name'];
    }

    /**
     * Sets view_name
     *
     * @param string|null $view_name view_name
     *
     * @return self
     */
    public function setViewName($view_name)
    {
        if (is_null($view_name)) {
            throw new \InvalidArgumentException('non-nullable view_name cannot be null');
        }
        $this->container['view_name'] = $view_name;

        return $this;
    }

    /**
     * Gets is_system
     *
     * @return bool|null
     */
    public function getIsSystem()
    {
        return $this->container['is_system'];
    }

    /**
     * Sets is_system
     *
     * @param bool|null $is_system is_system
     *
     * @return self
     */
    public function setIsSystem($is_system)
    {
        if (is_null($is_system)) {
            throw new \InvalidArgumentException('non-nullable is_system cannot be null');
        }
        $this->container['is_system'] = $is_system;

        return $this;
    }

    /**
     * Gets total_orders
     *
     * @return int|null
     */
    public function getTotalOrders()
    {
        return $this->container['total_orders'];
    }

    /**
     * Sets total_orders
     *
     * @param int|null $total_orders total_orders
     *
     * @return self
     */
    public function setTotalOrders($total_orders)
    {
        if (is_null($total_orders)) {
            throw new \InvalidArgumentException('non-nullable total_orders cannot be null');
        }
        $this->container['total_orders'] = $total_orders;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id location_id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets expiry_date
     *
     * @return \DateTime|null
     */
    public function getExpiryDate()
    {
        return $this->container['expiry_date'];
    }

    /**
     * Sets expiry_date
     *
     * @param \DateTime|null $expiry_date expiry_date
     *
     * @return self
     */
    public function setExpiryDate($expiry_date)
    {
        if (is_null($expiry_date)) {
            throw new \InvalidArgumentException('non-nullable expiry_date cannot be null');
        }
        $this->container['expiry_date'] = $expiry_date;

        return $this;
    }

    /**
     * Gets is_calculating
     *
     * @return bool|null
     */
    public function getIsCalculating()
    {
        return $this->container['is_calculating'];
    }

    /**
     * Sets is_calculating
     *
     * @param bool|null $is_calculating is_calculating
     *
     * @return self
     */
    public function setIsCalculating($is_calculating)
    {
        if (is_null($is_calculating)) {
            throw new \InvalidArgumentException('non-nullable is_calculating cannot be null');
        }
        $this->container['is_calculating'] = $is_calculating;

        return $this;
    }

    /**
     * Gets view_exists
     *
     * @return bool|null
     */
    public function getViewExists()
    {
        return $this->container['view_exists'];
    }

    /**
     * Sets view_exists
     *
     * @param bool|null $view_exists view_exists
     *
     * @return self
     */
    public function setViewExists($view_exists)
    {
        if (is_null($view_exists)) {
            throw new \InvalidArgumentException('non-nullable view_exists cannot be null');
        }
        $this->container['view_exists'] = $view_exists;

        return $this;
    }

    /**
     * Gets last_requested
     *
     * @return \DateTime|null
     */
    public function getLastRequested()
    {
        return $this->container['last_requested'];
    }

    /**
     * Sets last_requested
     *
     * @param \DateTime|null $last_requested last_requested
     *
     * @return self
     */
    public function setLastRequested($last_requested)
    {
        if (is_null($last_requested)) {
            throw new \InvalidArgumentException('non-nullable last_requested cannot be null');
        }
        $this->container['last_requested'] = $last_requested;

        return $this;
    }

    /**
     * Gets user_management
     *
     * @return \Linnworks\OpenOrders\Model\ViewUserManagement|null
     */
    public function getUserManagement()
    {
        return $this->container['user_management'];
    }

    /**
     * Sets user_management
     *
     * @param \Linnworks\OpenOrders\Model\ViewUserManagement|null $user_management user_management
     *
     * @return self
     */
    public function setUserManagement($user_management)
    {
        if (is_null($user_management)) {
            throw new \InvalidArgumentException('non-nullable user_management cannot be null');
        }
        $this->container['user_management'] = $user_management;

        return $this;
    }

    /**
     * Gets order_view_user_preference
     *
     * @return \Linnworks\OpenOrders\Model\OrderViewUserPreference|null
     */
    public function getOrderViewUserPreference()
    {
        return $this->container['order_view_user_preference'];
    }

    /**
     * Sets order_view_user_preference
     *
     * @param \Linnworks\OpenOrders\Model\OrderViewUserPreference|null $order_view_user_preference order_view_user_preference
     *
     * @return self
     */
    public function setOrderViewUserPreference($order_view_user_preference)
    {
        if (is_null($order_view_user_preference)) {
            throw new \InvalidArgumentException('non-nullable order_view_user_preference cannot be null');
        }
        $this->container['order_view_user_preference'] = $order_view_user_preference;

        return $this;
    }

    /**
     * Gets owner
     *
     * @return \Linnworks\OpenOrders\Model\ViewUser|null
     */
    public function getOwner()
    {
        return $this->container['owner'];
    }

    /**
     * Sets owner
     *
     * @param \Linnworks\OpenOrders\Model\ViewUser|null $owner owner
     *
     * @return self
     */
    public function setOwner($owner)
    {
        if (is_null($owner)) {
            throw new \InvalidArgumentException('non-nullable owner cannot be null');
        }
        $this->container['owner'] = $owner;

        return $this;
    }

    /**
     * Gets is_cacheable
     *
     * @return bool|null
     */
    public function getIsCacheable()
    {
        return $this->container['is_cacheable'];
    }

    /**
     * Sets is_cacheable
     *
     * @param bool|null $is_cacheable is_cacheable
     *
     * @return self
     */
    public function setIsCacheable($is_cacheable)
    {
        if (is_null($is_cacheable)) {
            throw new \InvalidArgumentException('non-nullable is_cacheable cannot be null');
        }
        $this->container['is_cacheable'] = $is_cacheable;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


