<?php
/**
 * OrderItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Open Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: openorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OpenOrders\Model;

use \ArrayAccess;
use \Linnworks\OpenOrders\ObjectSerializer;

/**
 * OrderItem Class Doc Comment
 *
 * @category Class
 * @description Order item object
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_id' => 'string',
        'item_number' => 'string',
        'sku' => 'string',
        'item_source' => 'string',
        'title' => 'string',
        'quantity' => 'int',
        'category_name' => 'string',
        'composite_availablity' => 'int',
        'stock_levels_specified' => 'bool',
        'on_order' => 'int',
        'on_purchase_order' => '\Linnworks\OpenOrders\Model\OrderItemOnOrder',
        'in_order_book' => 'int',
        'level' => 'int',
        'minimum_level' => 'int',
        'available_stock' => 'int',
        'price_per_unit' => 'float',
        'unit_cost' => 'float',
        'despatch_stock_unit_cost' => 'float',
        'discount' => 'float',
        'tax' => 'float',
        'tax_rate' => 'float',
        'cost' => 'float',
        'cost_inc_tax' => 'float',
        'composite_sub_items' => '\Linnworks\OpenOrders\Model\OrderItem[]',
        'is_service' => 'bool',
        'sales_tax' => 'float',
        'tax_cost_inclusive' => 'bool',
        'part_shipped' => 'bool',
        'weight' => 'float',
        'barcode_number' => 'string',
        'market' => 'int',
        'channel_sku' => 'string',
        'channel_title' => 'string',
        'discount_value' => 'float',
        'has_image' => 'bool',
        'image_id' => 'string',
        'additional_info' => '\Linnworks\OpenOrders\Model\OrderItemOption[]',
        'stock_level_indicator' => 'int',
        'shipping_cost' => 'float',
        'part_shipped_qty' => 'int',
        'item_name' => 'string',
        'batch_number_scan_required' => 'bool',
        'serial_number_scan_required' => 'bool',
        'bin_rack' => 'string',
        'bin_racks' => '\Linnworks\OpenOrders\Model\OrderItemBinRack[]',
        'inventory_tracking_type' => 'int',
        'is_batched_stock_item' => 'bool',
        'is_warehouse_managed' => 'bool',
        'is_unlinked' => 'bool',
        'stock_item_int_id' => 'int',
        'boxes' => '\Linnworks\OpenOrders\Model\StockItemBoxConfiguration[]',
        'added_date' => '\DateTime',
        'row_id' => 'string',
        'order_id' => 'string',
        'stock_item_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_id' => 'uuid',
        'item_number' => null,
        'sku' => null,
        'item_source' => null,
        'title' => null,
        'quantity' => 'int32',
        'category_name' => null,
        'composite_availablity' => 'int32',
        'stock_levels_specified' => null,
        'on_order' => 'int32',
        'on_purchase_order' => null,
        'in_order_book' => 'int32',
        'level' => 'int32',
        'minimum_level' => 'int32',
        'available_stock' => 'int32',
        'price_per_unit' => 'double',
        'unit_cost' => 'double',
        'despatch_stock_unit_cost' => 'double',
        'discount' => 'double',
        'tax' => 'double',
        'tax_rate' => 'double',
        'cost' => 'double',
        'cost_inc_tax' => 'double',
        'composite_sub_items' => null,
        'is_service' => null,
        'sales_tax' => 'double',
        'tax_cost_inclusive' => null,
        'part_shipped' => null,
        'weight' => 'double',
        'barcode_number' => null,
        'market' => 'int32',
        'channel_sku' => null,
        'channel_title' => null,
        'discount_value' => 'double',
        'has_image' => null,
        'image_id' => 'uuid',
        'additional_info' => null,
        'stock_level_indicator' => 'int32',
        'shipping_cost' => 'double',
        'part_shipped_qty' => 'int32',
        'item_name' => null,
        'batch_number_scan_required' => null,
        'serial_number_scan_required' => null,
        'bin_rack' => null,
        'bin_racks' => null,
        'inventory_tracking_type' => 'int32',
        'is_batched_stock_item' => null,
        'is_warehouse_managed' => null,
        'is_unlinked' => null,
        'stock_item_int_id' => 'int32',
        'boxes' => null,
        'added_date' => 'date-time',
        'row_id' => 'uuid',
        'order_id' => 'uuid',
        'stock_item_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_id' => false,
        'item_number' => false,
        'sku' => false,
        'item_source' => false,
        'title' => false,
        'quantity' => false,
        'category_name' => false,
        'composite_availablity' => false,
        'stock_levels_specified' => false,
        'on_order' => false,
        'on_purchase_order' => false,
        'in_order_book' => false,
        'level' => false,
        'minimum_level' => false,
        'available_stock' => false,
        'price_per_unit' => false,
        'unit_cost' => false,
        'despatch_stock_unit_cost' => false,
        'discount' => false,
        'tax' => false,
        'tax_rate' => false,
        'cost' => false,
        'cost_inc_tax' => false,
        'composite_sub_items' => false,
        'is_service' => false,
        'sales_tax' => false,
        'tax_cost_inclusive' => false,
        'part_shipped' => false,
        'weight' => false,
        'barcode_number' => false,
        'market' => false,
        'channel_sku' => false,
        'channel_title' => false,
        'discount_value' => false,
        'has_image' => false,
        'image_id' => false,
        'additional_info' => false,
        'stock_level_indicator' => false,
        'shipping_cost' => false,
        'part_shipped_qty' => false,
        'item_name' => false,
        'batch_number_scan_required' => false,
        'serial_number_scan_required' => false,
        'bin_rack' => false,
        'bin_racks' => false,
        'inventory_tracking_type' => false,
        'is_batched_stock_item' => false,
        'is_warehouse_managed' => false,
        'is_unlinked' => false,
        'stock_item_int_id' => false,
        'boxes' => false,
        'added_date' => false,
        'row_id' => false,
        'order_id' => false,
        'stock_item_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_id' => 'ItemId',
        'item_number' => 'ItemNumber',
        'sku' => 'SKU',
        'item_source' => 'ItemSource',
        'title' => 'Title',
        'quantity' => 'Quantity',
        'category_name' => 'CategoryName',
        'composite_availablity' => 'CompositeAvailablity',
        'stock_levels_specified' => 'StockLevelsSpecified',
        'on_order' => 'OnOrder',
        'on_purchase_order' => 'OnPurchaseOrder',
        'in_order_book' => 'InOrderBook',
        'level' => 'Level',
        'minimum_level' => 'MinimumLevel',
        'available_stock' => 'AvailableStock',
        'price_per_unit' => 'PricePerUnit',
        'unit_cost' => 'UnitCost',
        'despatch_stock_unit_cost' => 'DespatchStockUnitCost',
        'discount' => 'Discount',
        'tax' => 'Tax',
        'tax_rate' => 'TaxRate',
        'cost' => 'Cost',
        'cost_inc_tax' => 'CostIncTax',
        'composite_sub_items' => 'CompositeSubItems',
        'is_service' => 'IsService',
        'sales_tax' => 'SalesTax',
        'tax_cost_inclusive' => 'TaxCostInclusive',
        'part_shipped' => 'PartShipped',
        'weight' => 'Weight',
        'barcode_number' => 'BarcodeNumber',
        'market' => 'Market',
        'channel_sku' => 'ChannelSKU',
        'channel_title' => 'ChannelTitle',
        'discount_value' => 'DiscountValue',
        'has_image' => 'HasImage',
        'image_id' => 'ImageId',
        'additional_info' => 'AdditionalInfo',
        'stock_level_indicator' => 'StockLevelIndicator',
        'shipping_cost' => 'ShippingCost',
        'part_shipped_qty' => 'PartShippedQty',
        'item_name' => 'ItemName',
        'batch_number_scan_required' => 'BatchNumberScanRequired',
        'serial_number_scan_required' => 'SerialNumberScanRequired',
        'bin_rack' => 'BinRack',
        'bin_racks' => 'BinRacks',
        'inventory_tracking_type' => 'InventoryTrackingType',
        'is_batched_stock_item' => 'isBatchedStockItem',
        'is_warehouse_managed' => 'IsWarehouseManaged',
        'is_unlinked' => 'IsUnlinked',
        'stock_item_int_id' => 'StockItemIntId',
        'boxes' => 'Boxes',
        'added_date' => 'AddedDate',
        'row_id' => 'RowId',
        'order_id' => 'OrderId',
        'stock_item_id' => 'StockItemId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_id' => 'setItemId',
        'item_number' => 'setItemNumber',
        'sku' => 'setSku',
        'item_source' => 'setItemSource',
        'title' => 'setTitle',
        'quantity' => 'setQuantity',
        'category_name' => 'setCategoryName',
        'composite_availablity' => 'setCompositeAvailablity',
        'stock_levels_specified' => 'setStockLevelsSpecified',
        'on_order' => 'setOnOrder',
        'on_purchase_order' => 'setOnPurchaseOrder',
        'in_order_book' => 'setInOrderBook',
        'level' => 'setLevel',
        'minimum_level' => 'setMinimumLevel',
        'available_stock' => 'setAvailableStock',
        'price_per_unit' => 'setPricePerUnit',
        'unit_cost' => 'setUnitCost',
        'despatch_stock_unit_cost' => 'setDespatchStockUnitCost',
        'discount' => 'setDiscount',
        'tax' => 'setTax',
        'tax_rate' => 'setTaxRate',
        'cost' => 'setCost',
        'cost_inc_tax' => 'setCostIncTax',
        'composite_sub_items' => 'setCompositeSubItems',
        'is_service' => 'setIsService',
        'sales_tax' => 'setSalesTax',
        'tax_cost_inclusive' => 'setTaxCostInclusive',
        'part_shipped' => 'setPartShipped',
        'weight' => 'setWeight',
        'barcode_number' => 'setBarcodeNumber',
        'market' => 'setMarket',
        'channel_sku' => 'setChannelSku',
        'channel_title' => 'setChannelTitle',
        'discount_value' => 'setDiscountValue',
        'has_image' => 'setHasImage',
        'image_id' => 'setImageId',
        'additional_info' => 'setAdditionalInfo',
        'stock_level_indicator' => 'setStockLevelIndicator',
        'shipping_cost' => 'setShippingCost',
        'part_shipped_qty' => 'setPartShippedQty',
        'item_name' => 'setItemName',
        'batch_number_scan_required' => 'setBatchNumberScanRequired',
        'serial_number_scan_required' => 'setSerialNumberScanRequired',
        'bin_rack' => 'setBinRack',
        'bin_racks' => 'setBinRacks',
        'inventory_tracking_type' => 'setInventoryTrackingType',
        'is_batched_stock_item' => 'setIsBatchedStockItem',
        'is_warehouse_managed' => 'setIsWarehouseManaged',
        'is_unlinked' => 'setIsUnlinked',
        'stock_item_int_id' => 'setStockItemIntId',
        'boxes' => 'setBoxes',
        'added_date' => 'setAddedDate',
        'row_id' => 'setRowId',
        'order_id' => 'setOrderId',
        'stock_item_id' => 'setStockItemId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_id' => 'getItemId',
        'item_number' => 'getItemNumber',
        'sku' => 'getSku',
        'item_source' => 'getItemSource',
        'title' => 'getTitle',
        'quantity' => 'getQuantity',
        'category_name' => 'getCategoryName',
        'composite_availablity' => 'getCompositeAvailablity',
        'stock_levels_specified' => 'getStockLevelsSpecified',
        'on_order' => 'getOnOrder',
        'on_purchase_order' => 'getOnPurchaseOrder',
        'in_order_book' => 'getInOrderBook',
        'level' => 'getLevel',
        'minimum_level' => 'getMinimumLevel',
        'available_stock' => 'getAvailableStock',
        'price_per_unit' => 'getPricePerUnit',
        'unit_cost' => 'getUnitCost',
        'despatch_stock_unit_cost' => 'getDespatchStockUnitCost',
        'discount' => 'getDiscount',
        'tax' => 'getTax',
        'tax_rate' => 'getTaxRate',
        'cost' => 'getCost',
        'cost_inc_tax' => 'getCostIncTax',
        'composite_sub_items' => 'getCompositeSubItems',
        'is_service' => 'getIsService',
        'sales_tax' => 'getSalesTax',
        'tax_cost_inclusive' => 'getTaxCostInclusive',
        'part_shipped' => 'getPartShipped',
        'weight' => 'getWeight',
        'barcode_number' => 'getBarcodeNumber',
        'market' => 'getMarket',
        'channel_sku' => 'getChannelSku',
        'channel_title' => 'getChannelTitle',
        'discount_value' => 'getDiscountValue',
        'has_image' => 'getHasImage',
        'image_id' => 'getImageId',
        'additional_info' => 'getAdditionalInfo',
        'stock_level_indicator' => 'getStockLevelIndicator',
        'shipping_cost' => 'getShippingCost',
        'part_shipped_qty' => 'getPartShippedQty',
        'item_name' => 'getItemName',
        'batch_number_scan_required' => 'getBatchNumberScanRequired',
        'serial_number_scan_required' => 'getSerialNumberScanRequired',
        'bin_rack' => 'getBinRack',
        'bin_racks' => 'getBinRacks',
        'inventory_tracking_type' => 'getInventoryTrackingType',
        'is_batched_stock_item' => 'getIsBatchedStockItem',
        'is_warehouse_managed' => 'getIsWarehouseManaged',
        'is_unlinked' => 'getIsUnlinked',
        'stock_item_int_id' => 'getStockItemIntId',
        'boxes' => 'getBoxes',
        'added_date' => 'getAddedDate',
        'row_id' => 'getRowId',
        'order_id' => 'getOrderId',
        'stock_item_id' => 'getStockItemId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_source', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('category_name', $data ?? [], null);
        $this->setIfExists('composite_availablity', $data ?? [], null);
        $this->setIfExists('stock_levels_specified', $data ?? [], null);
        $this->setIfExists('on_order', $data ?? [], null);
        $this->setIfExists('on_purchase_order', $data ?? [], null);
        $this->setIfExists('in_order_book', $data ?? [], null);
        $this->setIfExists('level', $data ?? [], null);
        $this->setIfExists('minimum_level', $data ?? [], null);
        $this->setIfExists('available_stock', $data ?? [], null);
        $this->setIfExists('price_per_unit', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('despatch_stock_unit_cost', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('cost_inc_tax', $data ?? [], null);
        $this->setIfExists('composite_sub_items', $data ?? [], null);
        $this->setIfExists('is_service', $data ?? [], null);
        $this->setIfExists('sales_tax', $data ?? [], null);
        $this->setIfExists('tax_cost_inclusive', $data ?? [], null);
        $this->setIfExists('part_shipped', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('market', $data ?? [], null);
        $this->setIfExists('channel_sku', $data ?? [], null);
        $this->setIfExists('channel_title', $data ?? [], null);
        $this->setIfExists('discount_value', $data ?? [], null);
        $this->setIfExists('has_image', $data ?? [], null);
        $this->setIfExists('image_id', $data ?? [], null);
        $this->setIfExists('additional_info', $data ?? [], null);
        $this->setIfExists('stock_level_indicator', $data ?? [], null);
        $this->setIfExists('shipping_cost', $data ?? [], null);
        $this->setIfExists('part_shipped_qty', $data ?? [], null);
        $this->setIfExists('item_name', $data ?? [], null);
        $this->setIfExists('batch_number_scan_required', $data ?? [], null);
        $this->setIfExists('serial_number_scan_required', $data ?? [], null);
        $this->setIfExists('bin_rack', $data ?? [], null);
        $this->setIfExists('bin_racks', $data ?? [], null);
        $this->setIfExists('inventory_tracking_type', $data ?? [], null);
        $this->setIfExists('is_batched_stock_item', $data ?? [], null);
        $this->setIfExists('is_warehouse_managed', $data ?? [], null);
        $this->setIfExists('is_unlinked', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
        $this->setIfExists('boxes', $data ?? [], null);
        $this->setIfExists('added_date', $data ?? [], null);
        $this->setIfExists('row_id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_id
     *
     * @return string|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param string|null $item_id Stock Item ID
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number Item number as on channel
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_source
     *
     * @return string|null
     */
    public function getItemSource()
    {
        return $this->container['item_source'];
    }

    /**
     * Sets item_source
     *
     * @param string|null $item_source Item source / channel name
     *
     * @return self
     */
    public function setItemSource($item_source)
    {
        if (is_null($item_source)) {
            throw new \InvalidArgumentException('non-nullable item_source cannot be null');
        }
        $this->container['item_source'] = $item_source;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title Item title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets category_name
     *
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->container['category_name'];
    }

    /**
     * Sets category_name
     *
     * @param string|null $category_name Product category
     *
     * @return self
     */
    public function setCategoryName($category_name)
    {
        if (is_null($category_name)) {
            throw new \InvalidArgumentException('non-nullable category_name cannot be null');
        }
        $this->container['category_name'] = $category_name;

        return $this;
    }

    /**
     * Gets composite_availablity
     *
     * @return int|null
     */
    public function getCompositeAvailablity()
    {
        return $this->container['composite_availablity'];
    }

    /**
     * Sets composite_availablity
     *
     * @param int|null $composite_availablity Composite availability
     *
     * @return self
     */
    public function setCompositeAvailablity($composite_availablity)
    {
        if (is_null($composite_availablity)) {
            throw new \InvalidArgumentException('non-nullable composite_availablity cannot be null');
        }
        $this->container['composite_availablity'] = $composite_availablity;

        return $this;
    }

    /**
     * Gets stock_levels_specified
     *
     * @return bool|null
     */
    public function getStockLevelsSpecified()
    {
        return $this->container['stock_levels_specified'];
    }

    /**
     * Sets stock_levels_specified
     *
     * @param bool|null $stock_levels_specified If stock level specified
     *
     * @return self
     */
    public function setStockLevelsSpecified($stock_levels_specified)
    {
        if (is_null($stock_levels_specified)) {
            throw new \InvalidArgumentException('non-nullable stock_levels_specified cannot be null');
        }
        $this->container['stock_levels_specified'] = $stock_levels_specified;

        return $this;
    }

    /**
     * Gets on_order
     *
     * @return int|null
     */
    public function getOnOrder()
    {
        return $this->container['on_order'];
    }

    /**
     * Sets on_order
     *
     * @param int|null $on_order Level due in purchase orders
     *
     * @return self
     */
    public function setOnOrder($on_order)
    {
        if (is_null($on_order)) {
            throw new \InvalidArgumentException('non-nullable on_order cannot be null');
        }
        $this->container['on_order'] = $on_order;

        return $this;
    }

    /**
     * Gets on_purchase_order
     *
     * @return \Linnworks\OpenOrders\Model\OrderItemOnOrder|null
     */
    public function getOnPurchaseOrder()
    {
        return $this->container['on_purchase_order'];
    }

    /**
     * Sets on_purchase_order
     *
     * @param \Linnworks\OpenOrders\Model\OrderItemOnOrder|null $on_purchase_order on_purchase_order
     *
     * @return self
     */
    public function setOnPurchaseOrder($on_purchase_order)
    {
        if (is_null($on_purchase_order)) {
            throw new \InvalidArgumentException('non-nullable on_purchase_order cannot be null');
        }
        $this->container['on_purchase_order'] = $on_purchase_order;

        return $this;
    }

    /**
     * Gets in_order_book
     *
     * @return int|null
     */
    public function getInOrderBook()
    {
        return $this->container['in_order_book'];
    }

    /**
     * Sets in_order_book
     *
     * @param int|null $in_order_book Quantity currently in open orders
     *
     * @return self
     */
    public function setInOrderBook($in_order_book)
    {
        if (is_null($in_order_book)) {
            throw new \InvalidArgumentException('non-nullable in_order_book cannot be null');
        }
        $this->container['in_order_book'] = $in_order_book;

        return $this;
    }

    /**
     * Gets level
     *
     * @return int|null
     */
    public function getLevel()
    {
        return $this->container['level'];
    }

    /**
     * Sets level
     *
     * @param int|null $level Current stock level
     *
     * @return self
     */
    public function setLevel($level)
    {
        if (is_null($level)) {
            throw new \InvalidArgumentException('non-nullable level cannot be null');
        }
        $this->container['level'] = $level;

        return $this;
    }

    /**
     * Gets minimum_level
     *
     * @return int|null
     */
    public function getMinimumLevel()
    {
        return $this->container['minimum_level'];
    }

    /**
     * Sets minimum_level
     *
     * @param int|null $minimum_level Minimum level
     *
     * @return self
     */
    public function setMinimumLevel($minimum_level)
    {
        if (is_null($minimum_level)) {
            throw new \InvalidArgumentException('non-nullable minimum_level cannot be null');
        }
        $this->container['minimum_level'] = $minimum_level;

        return $this;
    }

    /**
     * Gets available_stock
     *
     * @return int|null
     */
    public function getAvailableStock()
    {
        return $this->container['available_stock'];
    }

    /**
     * Sets available_stock
     *
     * @param int|null $available_stock Currently available stock level (Level-InOrderBook)
     *
     * @return self
     */
    public function setAvailableStock($available_stock)
    {
        if (is_null($available_stock)) {
            throw new \InvalidArgumentException('non-nullable available_stock cannot be null');
        }
        $this->container['available_stock'] = $available_stock;

        return $this;
    }

    /**
     * Gets price_per_unit
     *
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return $this->container['price_per_unit'];
    }

    /**
     * Sets price_per_unit
     *
     * @param float|null $price_per_unit Unit price
     *
     * @return self
     */
    public function setPricePerUnit($price_per_unit)
    {
        if (is_null($price_per_unit)) {
            throw new \InvalidArgumentException('non-nullable price_per_unit cannot be null');
        }
        $this->container['price_per_unit'] = $price_per_unit;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param float|null $unit_cost Unit cost
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets despatch_stock_unit_cost
     *
     * @return float|null
     */
    public function getDespatchStockUnitCost()
    {
        return $this->container['despatch_stock_unit_cost'];
    }

    /**
     * Sets despatch_stock_unit_cost
     *
     * @param float|null $despatch_stock_unit_cost Despatch stock unit cost
     *
     * @return self
     */
    public function setDespatchStockUnitCost($despatch_stock_unit_cost)
    {
        if (is_null($despatch_stock_unit_cost)) {
            throw new \InvalidArgumentException('non-nullable despatch_stock_unit_cost cannot be null');
        }
        $this->container['despatch_stock_unit_cost'] = $despatch_stock_unit_cost;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param float|null $discount Percentage (0%, 10%, 20%, etc...)
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return float|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param float|null $tax Actual tax value on an item
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Tax rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost Total item cost (exc tax)
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets cost_inc_tax
     *
     * @return float|null
     */
    public function getCostIncTax()
    {
        return $this->container['cost_inc_tax'];
    }

    /**
     * Sets cost_inc_tax
     *
     * @param float|null $cost_inc_tax Total item cost (inc tax)
     *
     * @return self
     */
    public function setCostIncTax($cost_inc_tax)
    {
        if (is_null($cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable cost_inc_tax cannot be null');
        }
        $this->container['cost_inc_tax'] = $cost_inc_tax;

        return $this;
    }

    /**
     * Gets composite_sub_items
     *
     * @return \Linnworks\OpenOrders\Model\OrderItem[]|null
     */
    public function getCompositeSubItems()
    {
        return $this->container['composite_sub_items'];
    }

    /**
     * Sets composite_sub_items
     *
     * @param \Linnworks\OpenOrders\Model\OrderItem[]|null $composite_sub_items List of order items
     *
     * @return self
     */
    public function setCompositeSubItems($composite_sub_items)
    {
        if (is_null($composite_sub_items)) {
            throw new \InvalidArgumentException('non-nullable composite_sub_items cannot be null');
        }
        $this->container['composite_sub_items'] = $composite_sub_items;

        return $this;
    }

    /**
     * Gets is_service
     *
     * @return bool|null
     */
    public function getIsService()
    {
        return $this->container['is_service'];
    }

    /**
     * Sets is_service
     *
     * @param bool|null $is_service if item is a service
     *
     * @return self
     */
    public function setIsService($is_service)
    {
        if (is_null($is_service)) {
            throw new \InvalidArgumentException('non-nullable is_service cannot be null');
        }
        $this->container['is_service'] = $is_service;

        return $this;
    }

    /**
     * Gets sales_tax
     *
     * @return float|null
     */
    public function getSalesTax()
    {
        return $this->container['sales_tax'];
    }

    /**
     * Sets sales_tax
     *
     * @param float|null $sales_tax Sales Tax
     *
     * @return self
     */
    public function setSalesTax($sales_tax)
    {
        if (is_null($sales_tax)) {
            throw new \InvalidArgumentException('non-nullable sales_tax cannot be null');
        }
        $this->container['sales_tax'] = $sales_tax;

        return $this;
    }

    /**
     * Gets tax_cost_inclusive
     *
     * @return bool|null
     */
    public function getTaxCostInclusive()
    {
        return $this->container['tax_cost_inclusive'];
    }

    /**
     * Sets tax_cost_inclusive
     *
     * @param bool|null $tax_cost_inclusive If tax is included in a cost
     *
     * @return self
     */
    public function setTaxCostInclusive($tax_cost_inclusive)
    {
        if (is_null($tax_cost_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_cost_inclusive cannot be null');
        }
        $this->container['tax_cost_inclusive'] = $tax_cost_inclusive;

        return $this;
    }

    /**
     * Gets part_shipped
     *
     * @return bool|null
     */
    public function getPartShipped()
    {
        return $this->container['part_shipped'];
    }

    /**
     * Sets part_shipped
     *
     * @param bool|null $part_shipped If order is partly shipped
     *
     * @return self
     */
    public function setPartShipped($part_shipped)
    {
        if (is_null($part_shipped)) {
            throw new \InvalidArgumentException('non-nullable part_shipped cannot be null');
        }
        $this->container['part_shipped'] = $part_shipped;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Order weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number Product barcode
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            throw new \InvalidArgumentException('non-nullable barcode_number cannot be null');
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets market
     *
     * @return int|null
     */
    public function getMarket()
    {
        return $this->container['market'];
    }

    /**
     * Sets market
     *
     * @param int|null $market Market
     *
     * @return self
     */
    public function setMarket($market)
    {
        if (is_null($market)) {
            throw new \InvalidArgumentException('non-nullable market cannot be null');
        }
        $this->container['market'] = $market;

        return $this;
    }

    /**
     * Gets channel_sku
     *
     * @return string|null
     */
    public function getChannelSku()
    {
        return $this->container['channel_sku'];
    }

    /**
     * Sets channel_sku
     *
     * @param string|null $channel_sku Channel product SKU
     *
     * @return self
     */
    public function setChannelSku($channel_sku)
    {
        if (is_null($channel_sku)) {
            throw new \InvalidArgumentException('non-nullable channel_sku cannot be null');
        }
        $this->container['channel_sku'] = $channel_sku;

        return $this;
    }

    /**
     * Gets channel_title
     *
     * @return string|null
     */
    public function getChannelTitle()
    {
        return $this->container['channel_title'];
    }

    /**
     * Sets channel_title
     *
     * @param string|null $channel_title Channel product title
     *
     * @return self
     */
    public function setChannelTitle($channel_title)
    {
        if (is_null($channel_title)) {
            throw new \InvalidArgumentException('non-nullable channel_title cannot be null');
        }
        $this->container['channel_title'] = $channel_title;

        return $this;
    }

    /**
     * Gets discount_value
     *
     * @return float|null
     */
    public function getDiscountValue()
    {
        return $this->container['discount_value'];
    }

    /**
     * Sets discount_value
     *
     * @param float|null $discount_value discount_value
     *
     * @return self
     */
    public function setDiscountValue($discount_value)
    {
        if (is_null($discount_value)) {
            throw new \InvalidArgumentException('non-nullable discount_value cannot be null');
        }
        $this->container['discount_value'] = $discount_value;

        return $this;
    }

    /**
     * Gets has_image
     *
     * @return bool|null
     */
    public function getHasImage()
    {
        return $this->container['has_image'];
    }

    /**
     * Sets has_image
     *
     * @param bool|null $has_image If item got an image
     *
     * @return self
     */
    public function setHasImage($has_image)
    {
        if (is_null($has_image)) {
            throw new \InvalidArgumentException('non-nullable has_image cannot be null');
        }
        $this->container['has_image'] = $has_image;

        return $this;
    }

    /**
     * Gets image_id
     *
     * @return string|null
     */
    public function getImageId()
    {
        return $this->container['image_id'];
    }

    /**
     * Sets image_id
     *
     * @param string|null $image_id Image ID
     *
     * @return self
     */
    public function setImageId($image_id)
    {
        if (is_null($image_id)) {
            throw new \InvalidArgumentException('non-nullable image_id cannot be null');
        }
        $this->container['image_id'] = $image_id;

        return $this;
    }

    /**
     * Gets additional_info
     *
     * @return \Linnworks\OpenOrders\Model\OrderItemOption[]|null
     */
    public function getAdditionalInfo()
    {
        return $this->container['additional_info'];
    }

    /**
     * Sets additional_info
     *
     * @param \Linnworks\OpenOrders\Model\OrderItemOption[]|null $additional_info List of order item options
     *
     * @return self
     */
    public function setAdditionalInfo($additional_info)
    {
        if (is_null($additional_info)) {
            throw new \InvalidArgumentException('non-nullable additional_info cannot be null');
        }
        $this->container['additional_info'] = $additional_info;

        return $this;
    }

    /**
     * Gets stock_level_indicator
     *
     * @return int|null
     */
    public function getStockLevelIndicator()
    {
        return $this->container['stock_level_indicator'];
    }

    /**
     * Sets stock_level_indicator
     *
     * @param int|null $stock_level_indicator Stock level indicator
     *
     * @return self
     */
    public function setStockLevelIndicator($stock_level_indicator)
    {
        if (is_null($stock_level_indicator)) {
            throw new \InvalidArgumentException('non-nullable stock_level_indicator cannot be null');
        }
        $this->container['stock_level_indicator'] = $stock_level_indicator;

        return $this;
    }

    /**
     * Gets shipping_cost
     *
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->container['shipping_cost'];
    }

    /**
     * Sets shipping_cost
     *
     * @param float|null $shipping_cost If batch number scan required
     *
     * @return self
     */
    public function setShippingCost($shipping_cost)
    {
        if (is_null($shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost cannot be null');
        }
        $this->container['shipping_cost'] = $shipping_cost;

        return $this;
    }

    /**
     * Gets part_shipped_qty
     *
     * @return int|null
     */
    public function getPartShippedQty()
    {
        return $this->container['part_shipped_qty'];
    }

    /**
     * Sets part_shipped_qty
     *
     * @param int|null $part_shipped_qty ShippingCost
     *
     * @return self
     */
    public function setPartShippedQty($part_shipped_qty)
    {
        if (is_null($part_shipped_qty)) {
            throw new \InvalidArgumentException('non-nullable part_shipped_qty cannot be null');
        }
        $this->container['part_shipped_qty'] = $part_shipped_qty;

        return $this;
    }

    /**
     * Gets item_name
     *
     * @return string|null
     */
    public function getItemName()
    {
        return $this->container['item_name'];
    }

    /**
     * Sets item_name
     *
     * @param string|null $item_name PartShippedQty
     *
     * @return self
     */
    public function setItemName($item_name)
    {
        if (is_null($item_name)) {
            throw new \InvalidArgumentException('non-nullable item_name cannot be null');
        }
        $this->container['item_name'] = $item_name;

        return $this;
    }

    /**
     * Gets batch_number_scan_required
     *
     * @return bool|null
     */
    public function getBatchNumberScanRequired()
    {
        return $this->container['batch_number_scan_required'];
    }

    /**
     * Sets batch_number_scan_required
     *
     * @param bool|null $batch_number_scan_required ItemName
     *
     * @return self
     */
    public function setBatchNumberScanRequired($batch_number_scan_required)
    {
        if (is_null($batch_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable batch_number_scan_required cannot be null');
        }
        $this->container['batch_number_scan_required'] = $batch_number_scan_required;

        return $this;
    }

    /**
     * Gets serial_number_scan_required
     *
     * @return bool|null
     */
    public function getSerialNumberScanRequired()
    {
        return $this->container['serial_number_scan_required'];
    }

    /**
     * Sets serial_number_scan_required
     *
     * @param bool|null $serial_number_scan_required If serial number scan required
     *
     * @return self
     */
    public function setSerialNumberScanRequired($serial_number_scan_required)
    {
        if (is_null($serial_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable serial_number_scan_required cannot be null');
        }
        $this->container['serial_number_scan_required'] = $serial_number_scan_required;

        return $this;
    }

    /**
     * Gets bin_rack
     *
     * @return string|null
     */
    public function getBinRack()
    {
        return $this->container['bin_rack'];
    }

    /**
     * Sets bin_rack
     *
     * @param string|null $bin_rack Binrack location
     *
     * @return self
     */
    public function setBinRack($bin_rack)
    {
        if (is_null($bin_rack)) {
            throw new \InvalidArgumentException('non-nullable bin_rack cannot be null');
        }
        $this->container['bin_rack'] = $bin_rack;

        return $this;
    }

    /**
     * Gets bin_racks
     *
     * @return \Linnworks\OpenOrders\Model\OrderItemBinRack[]|null
     */
    public function getBinRacks()
    {
        return $this->container['bin_racks'];
    }

    /**
     * Sets bin_racks
     *
     * @param \Linnworks\OpenOrders\Model\OrderItemBinRack[]|null $bin_racks List of BinRacks used for OrderItem
     *
     * @return self
     */
    public function setBinRacks($bin_racks)
    {
        if (is_null($bin_racks)) {
            throw new \InvalidArgumentException('non-nullable bin_racks cannot be null');
        }
        $this->container['bin_racks'] = $bin_racks;

        return $this;
    }

    /**
     * Gets inventory_tracking_type
     *
     * @return int|null
     */
    public function getInventoryTrackingType()
    {
        return $this->container['inventory_tracking_type'];
    }

    /**
     * Sets inventory_tracking_type
     *
     * @param int|null $inventory_tracking_type Identifies whether the item has a sell by date or other defined order in which inventory is to be sold
     *
     * @return self
     */
    public function setInventoryTrackingType($inventory_tracking_type)
    {
        if (is_null($inventory_tracking_type)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking_type cannot be null');
        }
        $this->container['inventory_tracking_type'] = $inventory_tracking_type;

        return $this;
    }

    /**
     * Gets is_batched_stock_item
     *
     * @return bool|null
     */
    public function getIsBatchedStockItem()
    {
        return $this->container['is_batched_stock_item'];
    }

    /**
     * Sets is_batched_stock_item
     *
     * @param bool|null $is_batched_stock_item If item has batches
     *
     * @return self
     */
    public function setIsBatchedStockItem($is_batched_stock_item)
    {
        if (is_null($is_batched_stock_item)) {
            throw new \InvalidArgumentException('non-nullable is_batched_stock_item cannot be null');
        }
        $this->container['is_batched_stock_item'] = $is_batched_stock_item;

        return $this;
    }

    /**
     * Gets is_warehouse_managed
     *
     * @return bool|null
     */
    public function getIsWarehouseManaged()
    {
        return $this->container['is_warehouse_managed'];
    }

    /**
     * Sets is_warehouse_managed
     *
     * @param bool|null $is_warehouse_managed is_warehouse_managed
     *
     * @return self
     */
    public function setIsWarehouseManaged($is_warehouse_managed)
    {
        if (is_null($is_warehouse_managed)) {
            throw new \InvalidArgumentException('non-nullable is_warehouse_managed cannot be null');
        }
        $this->container['is_warehouse_managed'] = $is_warehouse_managed;

        return $this;
    }

    /**
     * Gets is_unlinked
     *
     * @return bool|null
     */
    public function getIsUnlinked()
    {
        return $this->container['is_unlinked'];
    }

    /**
     * Sets is_unlinked
     *
     * @param bool|null $is_unlinked is_unlinked
     *
     * @return self
     */
    public function setIsUnlinked($is_unlinked)
    {
        if (is_null($is_unlinked)) {
            throw new \InvalidArgumentException('non-nullable is_unlinked cannot be null');
        }
        $this->container['is_unlinked'] = $is_unlinked;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id stock_item_int_id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }

    /**
     * Gets boxes
     *
     * @return \Linnworks\OpenOrders\Model\StockItemBoxConfiguration[]|null
     */
    public function getBoxes()
    {
        return $this->container['boxes'];
    }

    /**
     * Sets boxes
     *
     * @param \Linnworks\OpenOrders\Model\StockItemBoxConfiguration[]|null $boxes boxes
     *
     * @return self
     */
    public function setBoxes($boxes)
    {
        if (is_null($boxes)) {
            throw new \InvalidArgumentException('non-nullable boxes cannot be null');
        }
        $this->container['boxes'] = $boxes;

        return $this;
    }

    /**
     * Gets added_date
     *
     * @return \DateTime|null
     */
    public function getAddedDate()
    {
        return $this->container['added_date'];
    }

    /**
     * Sets added_date
     *
     * @param \DateTime|null $added_date added_date
     *
     * @return self
     */
    public function setAddedDate($added_date)
    {
        if (is_null($added_date)) {
            throw new \InvalidArgumentException('non-nullable added_date cannot be null');
        }
        $this->container['added_date'] = $added_date;

        return $this;
    }

    /**
     * Gets row_id
     *
     * @return string|null
     */
    public function getRowId()
    {
        return $this->container['row_id'];
    }

    /**
     * Sets row_id
     *
     * @param string|null $row_id Record row ID
     *
     * @return self
     */
    public function setRowId($row_id)
    {
        if (is_null($row_id)) {
            throw new \InvalidArgumentException('non-nullable row_id cannot be null');
        }
        $this->container['row_id'] = $row_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Order ID (pkOrderID)
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item ID
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


