<?php
/**
 * OrderFulfillmentState
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Open Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: openorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OpenOrders\Model;

use \ArrayAccess;
use \Linnworks\OpenOrders\ObjectSerializer;

/**
 * OrderFulfillmentState Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderFulfillmentState implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderFulfillmentState';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fulfillment_state' => 'string',
        'purchase_order_state' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fulfillment_state' => null,
        'purchase_order_state' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fulfillment_state' => false,
        'purchase_order_state' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fulfillment_state' => 'FulfillmentState',
        'purchase_order_state' => 'PurchaseOrderState'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fulfillment_state' => 'setFulfillmentState',
        'purchase_order_state' => 'setPurchaseOrderState'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fulfillment_state' => 'getFulfillmentState',
        'purchase_order_state' => 'getPurchaseOrderState'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FULFILLMENT_STATE_UNKNOWN = 'Unknown';
    public const FULFILLMENT_STATE_INSUFFICIENT_STOCK = 'Insufficient_Stock';
    public const FULFILLMENT_STATE_INSUFFICIENT_TO_FULFILL_ALL = 'Insufficient_To_Fulfill_All';
    public const FULFILLMENT_STATE_SUFFICIENT_STOCK = 'Sufficient_Stock';
    public const PURCHASE_ORDER_STATE_INSUFFICIENT_PO = 'Insufficient_PO';
    public const PURCHASE_ORDER_STATE_SUFFICIENT_PO = 'Sufficient_PO';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFulfillmentStateAllowableValues()
    {
        return [
            self::FULFILLMENT_STATE_UNKNOWN,
            self::FULFILLMENT_STATE_INSUFFICIENT_STOCK,
            self::FULFILLMENT_STATE_INSUFFICIENT_TO_FULFILL_ALL,
            self::FULFILLMENT_STATE_SUFFICIENT_STOCK,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPurchaseOrderStateAllowableValues()
    {
        return [
            self::PURCHASE_ORDER_STATE_INSUFFICIENT_PO,
            self::PURCHASE_ORDER_STATE_SUFFICIENT_PO,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fulfillment_state', $data ?? [], null);
        $this->setIfExists('purchase_order_state', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFulfillmentStateAllowableValues();
        if (!is_null($this->container['fulfillment_state']) && !in_array($this->container['fulfillment_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fulfillment_state', must be one of '%s'",
                $this->container['fulfillment_state'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPurchaseOrderStateAllowableValues();
        if (!is_null($this->container['purchase_order_state']) && !in_array($this->container['purchase_order_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'purchase_order_state', must be one of '%s'",
                $this->container['purchase_order_state'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fulfillment_state
     *
     * @return string|null
     */
    public function getFulfillmentState()
    {
        return $this->container['fulfillment_state'];
    }

    /**
     * Sets fulfillment_state
     *
     * @param string|null $fulfillment_state fulfillment_state
     *
     * @return self
     */
    public function setFulfillmentState($fulfillment_state)
    {
        if (is_null($fulfillment_state)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_state cannot be null');
        }
        $allowedValues = $this->getFulfillmentStateAllowableValues();
        if (!in_array($fulfillment_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fulfillment_state', must be one of '%s'",
                    $fulfillment_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fulfillment_state'] = $fulfillment_state;

        return $this;
    }

    /**
     * Gets purchase_order_state
     *
     * @return string|null
     */
    public function getPurchaseOrderState()
    {
        return $this->container['purchase_order_state'];
    }

    /**
     * Sets purchase_order_state
     *
     * @param string|null $purchase_order_state purchase_order_state
     *
     * @return self
     */
    public function setPurchaseOrderState($purchase_order_state)
    {
        if (is_null($purchase_order_state)) {
            throw new \InvalidArgumentException('non-nullable purchase_order_state cannot be null');
        }
        $allowedValues = $this->getPurchaseOrderStateAllowableValues();
        if (!in_array($purchase_order_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'purchase_order_state', must be one of '%s'",
                    $purchase_order_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['purchase_order_state'] = $purchase_order_state;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


