<?php
/**
 * OrderDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Open Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: openorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OpenOrders\Model;

use \ArrayAccess;
use \Linnworks\OpenOrders\ObjectSerializer;

/**
 * OrderDetails Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_id' => 'string',
        'num_order_id' => 'int',
        'processed' => 'bool',
        'processed_date_time' => '\DateTime',
        'fulfilment_location_id' => 'string',
        'general_info' => '\Linnworks\OpenOrders\Model\OrderGeneralInfo',
        'shipping_info' => '\Linnworks\OpenOrders\Model\OrderShippingInfo',
        'customer_info' => '\Linnworks\OpenOrders\Model\OrderCustomerInfo',
        'totals_info' => '\Linnworks\OpenOrders\Model\OrderTotalsInfo',
        'extended_properties' => '\Linnworks\OpenOrders\Model\ExtendedProperty[]',
        'folder_name' => 'string[]',
        'items' => '\Linnworks\OpenOrders\Model\OrderItem[]',
        'notes' => '\Linnworks\OpenOrders\Model\OrderNote[]',
        'paid_date_time' => '\DateTime',
        'tax_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_id' => 'uuid',
        'num_order_id' => 'int32',
        'processed' => null,
        'processed_date_time' => 'date-time',
        'fulfilment_location_id' => 'uuid',
        'general_info' => null,
        'shipping_info' => null,
        'customer_info' => null,
        'totals_info' => null,
        'extended_properties' => null,
        'folder_name' => null,
        'items' => null,
        'notes' => null,
        'paid_date_time' => 'date-time',
        'tax_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_id' => false,
        'num_order_id' => false,
        'processed' => false,
        'processed_date_time' => false,
        'fulfilment_location_id' => false,
        'general_info' => false,
        'shipping_info' => false,
        'customer_info' => false,
        'totals_info' => false,
        'extended_properties' => false,
        'folder_name' => false,
        'items' => false,
        'notes' => false,
        'paid_date_time' => false,
        'tax_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_id' => 'OrderId',
        'num_order_id' => 'NumOrderId',
        'processed' => 'Processed',
        'processed_date_time' => 'ProcessedDateTime',
        'fulfilment_location_id' => 'FulfilmentLocationId',
        'general_info' => 'GeneralInfo',
        'shipping_info' => 'ShippingInfo',
        'customer_info' => 'CustomerInfo',
        'totals_info' => 'TotalsInfo',
        'extended_properties' => 'ExtendedProperties',
        'folder_name' => 'FolderName',
        'items' => 'Items',
        'notes' => 'Notes',
        'paid_date_time' => 'PaidDateTime',
        'tax_id' => 'TaxId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_id' => 'setOrderId',
        'num_order_id' => 'setNumOrderId',
        'processed' => 'setProcessed',
        'processed_date_time' => 'setProcessedDateTime',
        'fulfilment_location_id' => 'setFulfilmentLocationId',
        'general_info' => 'setGeneralInfo',
        'shipping_info' => 'setShippingInfo',
        'customer_info' => 'setCustomerInfo',
        'totals_info' => 'setTotalsInfo',
        'extended_properties' => 'setExtendedProperties',
        'folder_name' => 'setFolderName',
        'items' => 'setItems',
        'notes' => 'setNotes',
        'paid_date_time' => 'setPaidDateTime',
        'tax_id' => 'setTaxId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_id' => 'getOrderId',
        'num_order_id' => 'getNumOrderId',
        'processed' => 'getProcessed',
        'processed_date_time' => 'getProcessedDateTime',
        'fulfilment_location_id' => 'getFulfilmentLocationId',
        'general_info' => 'getGeneralInfo',
        'shipping_info' => 'getShippingInfo',
        'customer_info' => 'getCustomerInfo',
        'totals_info' => 'getTotalsInfo',
        'extended_properties' => 'getExtendedProperties',
        'folder_name' => 'getFolderName',
        'items' => 'getItems',
        'notes' => 'getNotes',
        'paid_date_time' => 'getPaidDateTime',
        'tax_id' => 'getTaxId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('num_order_id', $data ?? [], null);
        $this->setIfExists('processed', $data ?? [], null);
        $this->setIfExists('processed_date_time', $data ?? [], null);
        $this->setIfExists('fulfilment_location_id', $data ?? [], null);
        $this->setIfExists('general_info', $data ?? [], null);
        $this->setIfExists('shipping_info', $data ?? [], null);
        $this->setIfExists('customer_info', $data ?? [], null);
        $this->setIfExists('totals_info', $data ?? [], null);
        $this->setIfExists('extended_properties', $data ?? [], null);
        $this->setIfExists('folder_name', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('paid_date_time', $data ?? [], null);
        $this->setIfExists('tax_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Order ID (pkOrderId)
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets num_order_id
     *
     * @return int|null
     */
    public function getNumOrderId()
    {
        return $this->container['num_order_id'];
    }

    /**
     * Sets num_order_id
     *
     * @param int|null $num_order_id Linnworks order number
     *
     * @return self
     */
    public function setNumOrderId($num_order_id)
    {
        if (is_null($num_order_id)) {
            throw new \InvalidArgumentException('non-nullable num_order_id cannot be null');
        }
        $this->container['num_order_id'] = $num_order_id;

        return $this;
    }

    /**
     * Gets processed
     *
     * @return bool|null
     */
    public function getProcessed()
    {
        return $this->container['processed'];
    }

    /**
     * Sets processed
     *
     * @param bool|null $processed If order is processed
     *
     * @return self
     */
    public function setProcessed($processed)
    {
        if (is_null($processed)) {
            throw new \InvalidArgumentException('non-nullable processed cannot be null');
        }
        $this->container['processed'] = $processed;

        return $this;
    }

    /**
     * Gets processed_date_time
     *
     * @return \DateTime|null
     */
    public function getProcessedDateTime()
    {
        return $this->container['processed_date_time'];
    }

    /**
     * Sets processed_date_time
     *
     * @param \DateTime|null $processed_date_time Date and time when order was processed
     *
     * @return self
     */
    public function setProcessedDateTime($processed_date_time)
    {
        if (is_null($processed_date_time)) {
            throw new \InvalidArgumentException('non-nullable processed_date_time cannot be null');
        }
        $this->container['processed_date_time'] = $processed_date_time;

        return $this;
    }

    /**
     * Gets fulfilment_location_id
     *
     * @return string|null
     */
    public function getFulfilmentLocationId()
    {
        return $this->container['fulfilment_location_id'];
    }

    /**
     * Sets fulfilment_location_id
     *
     * @param string|null $fulfilment_location_id Location ID
     *
     * @return self
     */
    public function setFulfilmentLocationId($fulfilment_location_id)
    {
        if (is_null($fulfilment_location_id)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_location_id cannot be null');
        }
        $this->container['fulfilment_location_id'] = $fulfilment_location_id;

        return $this;
    }

    /**
     * Gets general_info
     *
     * @return \Linnworks\OpenOrders\Model\OrderGeneralInfo|null
     */
    public function getGeneralInfo()
    {
        return $this->container['general_info'];
    }

    /**
     * Sets general_info
     *
     * @param \Linnworks\OpenOrders\Model\OrderGeneralInfo|null $general_info general_info
     *
     * @return self
     */
    public function setGeneralInfo($general_info)
    {
        if (is_null($general_info)) {
            throw new \InvalidArgumentException('non-nullable general_info cannot be null');
        }
        $this->container['general_info'] = $general_info;

        return $this;
    }

    /**
     * Gets shipping_info
     *
     * @return \Linnworks\OpenOrders\Model\OrderShippingInfo|null
     */
    public function getShippingInfo()
    {
        return $this->container['shipping_info'];
    }

    /**
     * Sets shipping_info
     *
     * @param \Linnworks\OpenOrders\Model\OrderShippingInfo|null $shipping_info shipping_info
     *
     * @return self
     */
    public function setShippingInfo($shipping_info)
    {
        if (is_null($shipping_info)) {
            throw new \InvalidArgumentException('non-nullable shipping_info cannot be null');
        }
        $this->container['shipping_info'] = $shipping_info;

        return $this;
    }

    /**
     * Gets customer_info
     *
     * @return \Linnworks\OpenOrders\Model\OrderCustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->container['customer_info'];
    }

    /**
     * Sets customer_info
     *
     * @param \Linnworks\OpenOrders\Model\OrderCustomerInfo|null $customer_info customer_info
     *
     * @return self
     */
    public function setCustomerInfo($customer_info)
    {
        if (is_null($customer_info)) {
            throw new \InvalidArgumentException('non-nullable customer_info cannot be null');
        }
        $this->container['customer_info'] = $customer_info;

        return $this;
    }

    /**
     * Gets totals_info
     *
     * @return \Linnworks\OpenOrders\Model\OrderTotalsInfo|null
     */
    public function getTotalsInfo()
    {
        return $this->container['totals_info'];
    }

    /**
     * Sets totals_info
     *
     * @param \Linnworks\OpenOrders\Model\OrderTotalsInfo|null $totals_info totals_info
     *
     * @return self
     */
    public function setTotalsInfo($totals_info)
    {
        if (is_null($totals_info)) {
            throw new \InvalidArgumentException('non-nullable totals_info cannot be null');
        }
        $this->container['totals_info'] = $totals_info;

        return $this;
    }

    /**
     * Gets extended_properties
     *
     * @return \Linnworks\OpenOrders\Model\ExtendedProperty[]|null
     */
    public function getExtendedProperties()
    {
        return $this->container['extended_properties'];
    }

    /**
     * Sets extended_properties
     *
     * @param \Linnworks\OpenOrders\Model\ExtendedProperty[]|null $extended_properties Extended properties of an order
     *
     * @return self
     */
    public function setExtendedProperties($extended_properties)
    {
        if (is_null($extended_properties)) {
            throw new \InvalidArgumentException('non-nullable extended_properties cannot be null');
        }
        $this->container['extended_properties'] = $extended_properties;

        return $this;
    }

    /**
     * Gets folder_name
     *
     * @return string[]|null
     */
    public function getFolderName()
    {
        return $this->container['folder_name'];
    }

    /**
     * Sets folder_name
     *
     * @param string[]|null $folder_name Folder names assigned to an order
     *
     * @return self
     */
    public function setFolderName($folder_name)
    {
        if (is_null($folder_name)) {
            throw new \InvalidArgumentException('non-nullable folder_name cannot be null');
        }
        $this->container['folder_name'] = $folder_name;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\OpenOrders\Model\OrderItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\OpenOrders\Model\OrderItem[]|null $items List of order items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return \Linnworks\OpenOrders\Model\OrderNote[]|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param \Linnworks\OpenOrders\Model\OrderNote[]|null $notes List of order notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets paid_date_time
     *
     * @return \DateTime|null
     */
    public function getPaidDateTime()
    {
        return $this->container['paid_date_time'];
    }

    /**
     * Sets paid_date_time
     *
     * @param \DateTime|null $paid_date_time Date and time when the order was marked as paid
     *
     * @return self
     */
    public function setPaidDateTime($paid_date_time)
    {
        if (is_null($paid_date_time)) {
            throw new \InvalidArgumentException('non-nullable paid_date_time cannot be null');
        }
        $this->container['paid_date_time'] = $paid_date_time;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id Buyer's tax number.
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        if (is_null($tax_id)) {
            throw new \InvalidArgumentException('non-nullable tax_id cannot be null');
        }
        $this->container['tax_id'] = $tax_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


